import{s as Hl,o as Wl,n as lt}from"../chunks/scheduler.ddb4e551.js";import{S as Xl,i as xl,g as p,s as a,r as M,B as Ql,h as o,f as s,c as n,j as Sl,u as c,x as r,k as Ws,y as Yl,a as l,v as u,d as y,t as h,w as d}from"../chunks/index.e16e4efa.js";import{T as st}from"../chunks/Tip.20abb04f.js";import{C as w}from"../chunks/CodeBlock.754e6cfc.js";import{H as U,E as El}from"../chunks/index.e108c5ed.js";function Nl(j){let i,J='Want to be listed as an Inference Provider on the Hugging Face Hub? Please reach out to us on social networks or <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">here on the Hub</a>.';return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-3qkokv"&&(i.innerHTML=J)},m(m,T){l(m,i,T)},p:lt,d(m){m&&s(i)}}}function Fl(j){let i,J='If your implementation strictly follows the OpenAI API for LLMs and VLMs, you may be able to skip most of this section. In that case, simply open a PR on <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> to register.';return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-90vl22"&&(i.innerHTML=J)},m(m,T){l(m,i,T)},p:lt,d(m){m&&s(i)}}}function Pl(j){let i,J=`Note that <code>chatCompletion</code> is an exception as it is not a pipeline_tag, per se. Instead, it
includes models with either <code>pipeline_tag=&quot;text-generation&quot;</code> or <code>pipeline_tag=&quot;image-text-to-text&quot;</code>
which are tagged as “conversational”.`;return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-19q0jcc"&&(i.innerHTML=J)},m(m,T){l(m,i,T)},p:lt,d(m){m&&s(i)}}}function zl(j){let i,J="To proceed with this step, we have to enable your account server-side. Make sure you have an organization on the Hub for your enterprise.";return{c(){i=p("p"),i.textContent=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1letj1o"&&(i.textContent=J)},m(m,T){l(m,i,T)},p:lt,d(m){m&&s(i)}}}function Ll(j){let i,J="This is publicly accessible. It’s useful to be transparent by default and it helps debug client SDKs, etc.";return{c(){i=p("p"),i.textContent=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-94fcay"&&(i.textContent=J)},m(m,T){l(m,i,T)},p:lt,d(m){m&&s(i)}}}function Dl(j){let i,J="Before adding a new provider to the <code>huggingface_hub</code> Python library, make sure that all the previous steps have been completed and everything is working on the Hub. Support in the Python library comes as a second step.";return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-33g0sl"&&(i.innerHTML=J)},m(m,T){l(m,i,T)},p:lt,d(m){m&&s(i)}}}function Ol(j){let i,J,m,T,k,nt,f,it,A,Xs="This guide details the steps for registering as an inference provider on the Hub and provides implementation guidance.",pt,G,xs='<li><strong>Implement standard task APIs</strong> - Follow our task API schemas for compatibility (see <a href="#1-prerequisites">Prerequisites</a>).</li> <li><strong>Submit a PR for JS client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> (see <a href="#2-js-client-integration">JS Client Integration</a>).</li> <li><strong>Register model mappings</strong> - Use our Model Mapping API to link your models to Hub models (see <a href="#3-model-mapping-api">Model Mapping API</a>).</li> <li><strong>Implement a billing endpoint</strong> - Provide an API for billing (see <a href="#4-billing">Billing</a>).</li> <li><strong>Submit a PR for Python client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> (see <a href="#5-python-client-integration">Python client integration</a>).</li> <li><strong>Register your provider server-side and provide an icon</strong> - Reach out to us to add your provider server-side and provide your SVG icon.</li> <li><strong>Create documentation on your side</strong> - Add documentation and do a lot of communication on your side.</li> <li><strong>Add a documentation page</strong> - Open a Pull Request in this repo (huggingface/hub-docs) to add a provider-specific page in the documentation.</li> <li><strong>Share share share</strong> do a lot of comms so that your integration is as successful as possible!</li>',ot,q,rt,g,Mt,Z,Qs=`The first step to understand the integration is to take a look at the JS inference client that lives
inside the <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> repo.`,ct,_,Ys=`This is the client that powers our Inference widgets on model pages, and is the blueprint
implementation downstream (for Python SDK, to generate code snippets, etc.).`,ut,R,yt,V,Es=`You will see that inference methods (<code>textToImage</code>, <code>chatCompletion</code>, etc.) have names that closely
mirror the task names. A task, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of
model (basically which types of inputs and outputs the model has), for instance “text-generation”
or “text-to-image”. It is indicated prominently on model pages, here:`,ht,I,Ns='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-dark.png"/></picture>',dt,S,Fs='The list of all possible tasks can be found at <a href="https://huggingface.co/tasks" rel="nofollow">https://huggingface.co/tasks</a> and the list of JS method names is documented in the README at <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>.',mt,C,Ut,H,Jt,W,Ps=`For each task type, we enforce an API schema to make it easier for end users to use different
models interchangeably. To be compatible, your third-party API must adhere to a “standard” shape API we expect on HF model pages for each pipeline task type.`,Tt,X,zs=`This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be
more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there
exists no standard API.`,jt,x,Ls='For example, you can find the expected schema for Text to Speech here: <a href="https://github.com/huggingface/huggingface.js/blob/0a690a14d52041a872dc103846225603599f4a33/packages/tasks/src/tasks/text-to-speech/spec/input.json#L4" rel="nofollow">https://github.com/huggingface/huggingface.js/packages/src/tasks/text-to-speech/spec/input.json#L4</a>, and similarly for other supported tasks. If your API for a given task is different from HF’s, it is not an issue: you can tweak the code in <code>huggingface.js</code> to be able to call your models, i.e., provide some kind of “translation” of parameter names and output names. However, API specs should not be model-specific, only task-specific. Run the JS code and add some <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/test/HfInference.spec.ts" rel="nofollow">tests</a> to make sure it works well. We can help with this step!',wt,Q,ft,Y,Ds="Before proceeding with the next steps, ensure you’ve implemented the necessary code to integrate with the JS client and thoroughly tested your implementation. Here are the steps to follow:",gt,E,It,N,Os="Create a new file under <code>packages/inference/src/providers/{provider_name}.ts</code> and copy-paste the following snippet.",Ct,F,bt,P,Ks="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. You have to define at least <code>makeRoute</code>, <code>preparePayload</code> and <code>getResponse</code>.",$t,z,el='If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern used in the existing providers implementation, e.g. <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/together.ts" rel="nofollow">Together AI provider implementation</a>.',vt,L,tl='For text-generation and conversational tasks, you can just inherit from <code>BaseTextGenerationTask</code> and <code>BaseConversationalTask</code> respectively (defined in <a href="(https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/providerHelper.ts)">providerHelper.ts</a>) and override the methods if needed. Examples can be found in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/cerebras.ts" rel="nofollow">Cerebras</a> or <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/fireworks.ts" rel="nofollow">Fireworks</a> provider implementations.',Bt,D,kt,O,sl='Go to <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/lib/getProviderHelper.ts" rel="nofollow">packages/inference/src/lib/getProviderHelper.ts</a> and add your provider to <code>PROVIDERS</code>. Please try to respect alphabetical order.',At,K,Gt,ee,ll="Congratulations! You now have a JS implementation to successfully make inference calls on your infra! Time to integrate with the Hub!",qt,te,al="First step is to use the Model Mapping API to register which HF models are supported.",Zt,b,_t,se,Rt,le,Vt,ae,nl="Create a new mapping item, with the following body (JSON-encoded):",St,ne,Ht,ie,il=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>hfModel</code> is the model id on the Hub’s side.</li> <li><code>providerModel</code> is the model id on your side (can be the same or different).</li>`,Wt,pe,pl="In the future, we will add support for a new parameter (ping us if it’s important to you now):",Xt,oe,xt,re,Qt,Me,ol=`You need to be in the <em>provider</em> Hub organization (e.g. <a href="https://huggingface.co/togethercomputer" rel="nofollow">https://huggingface.co/togethercomputer</a>
for TogetherAI) with <strong>Write</strong> permissions to be able to access this endpoint.`,Yt,ce,Et,ue,rl="The endpoint validates that:",Nt,ye,Ml=`<li><code>hfModel</code> is indeed of <code>pipeline_tag == task</code> OR <code>task</code> is “conversational” and the model is
compatible (i.e. the <code>pipeline_tag</code> is either “text-generation” or “image-text-to-text” AND the model is tagged as “conversational”).</li> <li>(in the future) we auto-test that the Partner’s API successfully responds to a
huggingface.js/inference call of the corresponding task i.e. the API specs are valid.</li>`,Ft,he,Pt,de,zt,me,Lt,Ue,cl="Call this HTTP PUT endpoint:",Dt,Je,Ot,Te,ul="With the following body (JSON-encoded):",Kt,je,es,we,ts,fe,ss,ge,yl="This gets all mapping items from the DB. For clarity, the output is grouped by task.",ls,$,as,Ie,hl="Here is an example of response:",ns,Ce,is,be,ps,$e,dl=`For routed requests (see figure below), i.e. when users authenticate via HF, our intent is that
our users only pay the standard provider API rates. There’s no additional markup from us, we
just pass through the provider costs directly.
More details about the pricing structure can be found on the <a href="./pricing.md">pricing page</a>.`,os,v,ml='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/types_of_billing.png"/>',rs,ve,Ul=`We propose an easier way to figure out this cost and charge it to our users, by asking you to
provide the cost for each request via an HTTP API you host on your end.`,Ms,Be,cs,ke,Jl=`We ask that you expose an API that supports a HTTP POST request.
The body of the request is a JSON-encoded object containing a list of request IDs for which we
request the cost.`,us,Ae,ys,Ge,Tl=`The response is also JSON-encoded. The response contains an array of objects specifying the
request’s ID and its cost in nano-USD (10^-9 USD).`,hs,qe,ds,Ze,ms,_e,jl="We require the price to be an <strong>integer</strong> number of <strong>nano-USDs</strong> (10^-9 USD).",Us,Re,Js,Ve,wl=`For each request/generation you serve, you should define a unique request (or response) ID,
and provide it as a response Header. We will use this ID as the request ID for the billing API
above.`,Ts,Se,fl="As part of those requirements, please let us know your Header name. If you don’t already have one, we suggest the <code>Inference-Id</code> name for instance, and it should contain a UUID character string.",js,He,gl="<strong>Example</strong>: Defining an <code>Inference-Id</code> header in your inference response.",ws,We,fs,Xe,gs,B,Is,xe,Cs,Qe,Il="Create a new file under <code>src/huggingface_hub/inference/_providers/{provider_name}.py</code> and copy-paste the following snippet.",bs,Ye,Cl="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. At least one of <code>_prepare_payload_as_dict</code> or <code>_prepare_payload_as_bytes</code> must be overwritten.",$s,Ee,bl="If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern shown in fal_ai.py.",vs,Ne,$l="For text-generation and conversational tasks, one can just inherit from BaseTextGenerationTask and BaseConversationalTask respectively (defined in _common.py) and override the methods if needed. Examples can be found in fireworks_ai.py and together.py.",Bs,Fe,ks,Pe,As,ze,vl='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_providers/__init__.py" rel="nofollow">src/huggingface_hub/inference/_providers/<strong>init</strong>.py</a> and add your provider to <code>PROVIDER_T</code> and <code>PROVIDERS</code>. Please try to respect alphabetical order.</li> <li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py" rel="nofollow">src/huggingface_hub/inference/_client.py</a> and update docstring in <code>InferenceClient.__init__</code> to document your provider.</li>',Gs,Le,qs,De,Bl='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_providers.py" rel="nofollow">tests/test_inference_providers.py</a> and add static tests for overridden methods.</li>',Zs,Oe,_s,Ke,kl="<strong>Question:</strong> By default, in which order do we list providers in the settings page?",Rs,et,Al="<strong>Answer:</strong> The default sort is by total number of requests routed by HF over the last 7 days. This order defines which provider will be used in priority by the widget on the model page (but the user’s order takes precedence).",Vs,tt,Ss,at,Hs;return k=new U({props:{title:"How to be registered as an inference provider on the Hub?",local:"how-to-be-registered-as-an-inference-provider-on-the-hub",headingTag:"h1"}}),f=new st({props:{$$slots:{default:[Nl]},$$scope:{ctx:j}}}),q=new U({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),g=new st({props:{$$slots:{default:[Fl]},$$scope:{ctx:j}}}),R=new U({props:{title:"What is a Task",local:"what-is-a-task",headingTag:"h3"}}),C=new st({props:{$$slots:{default:[Pl]},$$scope:{ctx:j}}}),H=new U({props:{title:"Task API schema",local:"task-api-schema",headingTag:"h3"}}),Q=new U({props:{title:"2. JS Client Integration",local:"2-js-client-integration",headingTag:"h2"}}),E=new U({props:{title:"Implement the provider helper (JS)",local:"implement-the-provider-helper-js",headingTag:"h3"}}),F=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">TaskProviderHelper</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;./providerHelper&quot;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTask</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">TaskProviderHelper</span> {

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params"></span>) {
		<span class="hljs-variable language_">super</span>(<span class="hljs-string">&quot;your-provider-name&quot;</span>, <span class="hljs-string">&quot;your-api-base-url&quot;</span>, <span class="hljs-string">&quot;task-name&quot;</span>);
	}

    <span class="hljs-keyword">override</span> <span class="hljs-title function_">prepareHeaders</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">HeaderParams</span>, <span class="hljs-attr">binary</span>: <span class="hljs-built_in">boolean</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">string</span>&gt; {
        <span class="hljs-comment">// Override the headers to use for the request.</span>
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">super</span>.<span class="hljs-title function_">prepareHeaders</span>(params, binary);
    }

	<span class="hljs-title function_">makeRoute</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">UrlParams</span>): <span class="hljs-built_in">string</span> {
        <span class="hljs-comment">// Return the route to use for the request. e.g. /v1/chat/completions route is commonly use for chat completion.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">preparePayload</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">BodyParams</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">unknown</span>&gt; {
        <span class="hljs-comment">// Return the payload to use for the request, as a dict.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">getResponse</span>(<span class="hljs-attr">response</span>: <span class="hljs-built_in">unknown</span>, outputType?: <span class="hljs-string">&quot;url&quot;</span> | <span class="hljs-string">&quot;blob&quot;</span>): <span class="hljs-built_in">string</span> | <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-title class_">Blob</span>&gt;{
		<span class="hljs-comment">// Return the response in the expected format.</span>
        <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
    }
}`,wrap:!1}}),D=new U({props:{title:"Register the provider",local:"register-the-provider",headingTag:"h3"}}),K=new U({props:{title:"3. Model Mapping API",local:"3-model-mapping-api",headingTag:"h2"}}),b=new st({props:{$$slots:{default:[zl]},$$scope:{ctx:j}}}),se=new U({props:{title:"Register a mapping item",local:"register-a-mapping-item",headingTag:"h3"}}),le=new w({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),ne=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMldpZGdldFR5cGUlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMmhmTW9kZWwlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwb24lMjBIRiUzQSUyMG5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlck1vZGVsJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjB0aGUlMjBwYXJ0bmVyJ3MlMjAlMjJtb2RlbCUyMGlkJTIyJTIwaS5lLiUyMGlkJTIwb24lMjB5b3VyJTIwc2lkZSUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the name of the model on HF: namespace/model-name</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),oe=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaGZGaWx0ZXIlMjIlM0ElMjAlNUIlMjJzdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjAlNUVQb3dlciUyMHVzZXIlMjBtb3ZlJTNBJTIwcmVnaXN0ZXIlMjBhJTIwJTIydGFnJTIyJTIwc2xpY2UlMjBvZiUyMEhGJTIwaW4lMjBvbmUlMjBnby4lMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBFeGFtcGxlJTNBJTIwdGFnJTIwJTNEJTNEJTIwJTIyYmFzZV9tb2RlbCUzQWFkYXB0ZXIlM0FibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMjBmb3IlMjBhbGwlMjBGbHV4LWRldiUyMExvUkFzJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hfFilter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-comment">// ^Power user move: register a &quot;tag&quot; slice of HF in one go.</span>
    <span class="hljs-comment">// Example: tag == &quot;base_model:adapter:black-forest-labs/FLUX.1-dev&quot; for all Flux-dev LoRAs</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),re=new U({props:{title:"Authentication",local:"authentication",headingTag:"h4"}}),ce=new U({props:{title:"Validation",local:"validation",headingTag:"h4"}}),he=new U({props:{title:"Delete a mapping item",local:"delete-a-mapping-item",headingTag:"h3"}}),de=new w({props:{code:"REVMRVRFJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRmhmTW9kZWwlM0RuYW1lc3BhY2UlMkZtb2RlbC1uYW1l",highlighted:"DELETE /api/partners/{provider}/models?hfModel=namespace/model-name",wrap:!1}}),me=new U({props:{title:"Update a mapping item’s status",local:"update-a-mapping-items-status",headingTag:"h3"}}),Je=new w({props:{code:"UFVUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRnN0YXR1cw==",highlighted:"PUT /api/partners/{provider}/models/status",wrap:!1}}),je=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaGZNb2RlbCUyMiUzQSUyMCUyMm5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMjIlMkMlMjAlMkYlMkYlMjBUaGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBtb2RlbCUyMG9uJTIwSEYlMEElMjAlMjAlMjAlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJsaXZlJTIyJTIwJTdDJTIwJTIyc3RhZ2luZyUyMiUyMCUyRiUyRiUyMFRoZSUyMG5ldyUyMHN0YXR1cyUyQyUyMG9uZSUyMG9mJTIwJTIyc3RhZ2luZyUyMiUyMG9yJTIwJTIybGl2ZSUyMiUwQSU3RCUyMCUyMCUyMA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;namespace/model-name&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// The name of the model on HF</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// The new status, one of &quot;staging&quot; or &quot;live&quot;</span>
<span class="hljs-punctuation">}</span>   `,wrap:!1}}),we=new U({props:{title:"List the whole mapping",local:"list-the-whole-mapping",headingTag:"h3"}}),fe=new w({props:{code:"R0VUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRnN0YXR1cyUzRHN0YWdpbmclN0NsaXZl",highlighted:"GET /api/partners/{provider}/models?status=staging|live",wrap:!1}}),$=new st({props:{warning:!0,$$slots:{default:[Ll]},$$scope:{ctx:j}}}),Ce=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text-to-image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-canny&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-depth&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;conversational&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text-generation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),be=new U({props:{title:"4. Billing",local:"4-billing",headingTag:"h2"}}),Be=new U({props:{title:"HTTP API Specs",local:"http-api-specs",headingTag:"h3"}}),Ae=new w({props:{code:"UE9TVCUyMCU3QnlvdXIlMjBVUkwlMjBoZXJlJTdEJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdElkcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMyUyMiUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`POST {your URL here}
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

{
    &quot;requestIds&quot;: [
        &quot;deadbeef0&quot;,
        &quot;deadbeef1&quot;,
        &quot;deadbeef2&quot;,
        &quot;deadbeef3&quot;
    ]
}`,wrap:!1}}),qe=new w({props:{code:"SFRUUCUyRjEuMSUyMDIwMCUyME9LJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjAlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnJlcXVlc3RJZCUyMiUzQSUyMCUyMmRlYWRiZWVmMSUyMiUyQyUyMCUyMmNvc3ROYW5vVXNkJTIyJTNBJTIwMTAwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIycmVxdWVzdElkJTIyJTNBJTIwJTIyZGVhZGJlZWYyJTIyJTJDJTIwJTIyY29zdE5hbm9Vc2QlMjIlM0ElMjAxMDAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjMlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

<span class="language-prolog">{
    <span class="hljs-string">&quot;requests&quot;</span>: [
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef0&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef1&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef2&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef3&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> }
    ]
}</span>`,wrap:!1}}),Ze=new U({props:{title:"Price Unit",local:"price-unit",headingTag:"h3"}}),Re=new U({props:{title:"How to define the request ID",local:"how-to-define-the-request-id",headingTag:"h3"}}),We=new w({props:{code:"UE9TVCUyMCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTVCcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEElNUJyZXF1ZXN0JTIwYm9keSU1RCUwQS0tLS0tLSUwQUhUVFAlMkYxLjElMjAyMDAlMjBPSyUwQUNvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUwQSU1Qm90aGVyJTIwcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEFJbmZlcmVuY2UtSWQlM0ElMjB1bmlxdWUtaWQtMDAxMzElMEElNUJyZXNwb25zZSUyMGJvZHklNUQ=",highlighted:`POST /v1/chat/completions
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[request headers]
[request body]
------
<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[other request headers]
<span class="hljs-attribute">Inference-Id</span><span class="hljs-punctuation">: </span>unique-id-00131
[response body]`,wrap:!1}}),Xe=new U({props:{title:"5. Python client integration",local:"5-python-client-integration",headingTag:"h2"}}),B=new st({props:{$$slots:{default:[Dl]},$$scope:{ctx:j}}}),xe=new U({props:{title:"Implement the provider helper (Python)",local:"implement-the-provider-helper-python",headingTag:"h3"}}),Fe=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">from</span> ._common <span class="hljs-keyword">import</span> TaskProviderHelper


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTaskProviderHelper</span>(<span class="hljs-title class_ inherited__">TaskProviderHelper</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Define high-level parameters.&quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(provider=..., base_url=..., task=...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_response</span>(<span class="hljs-params">
        self,
        response: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bytes</span>, <span class="hljs-type">Dict</span>],
        request_params: <span class="hljs-type">Optional</span>[RequestParameters] = <span class="hljs-literal">None</span>,
    </span>) -&gt; <span class="hljs-type">Any</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return the response in the expected format.

        Override this method in subclasses for customized response handling.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().get_response(response)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_headers</span>(<span class="hljs-params">self, headers: <span class="hljs-type">Dict</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the headers to use for the request.

        Override this method in subclasses for customized headers.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_headers(headers, api_key)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_route</span>(<span class="hljs-params">self, mapped_model: <span class="hljs-built_in">str</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the route to use for the request.

        Override this method in subclasses for customized routes.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_route(mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_dict</span>(<span class="hljs-params">self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the payload to use for the request, as a dict.

        Override this method in subclasses for customized payloads.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_dict(inputs, parameters, mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_bytes</span>(<span class="hljs-params">
        self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span>, extra_payload: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]
    </span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bytes</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the body to use for the request, as bytes.

        Override this method in subclasses for customized body data.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_bytes(inputs, parameters, mapped_model, extra_payload)`,wrap:!1}}),Pe=new U({props:{title:"Register the Provider",local:"register-the-provider",headingTag:"h3"}}),Le=new U({props:{title:"Add tests",local:"add-tests",headingTag:"h3"}}),Oe=new U({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),tt=new El({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/register-as-a-provider.md"}}),{c(){i=p("meta"),J=a(),m=p("p"),T=a(),M(k.$$.fragment),nt=a(),M(f.$$.fragment),it=a(),A=p("p"),A.textContent=Xs,pt=a(),G=p("ol"),G.innerHTML=xs,ot=a(),M(q.$$.fragment),rt=a(),M(g.$$.fragment),Mt=a(),Z=p("p"),Z.innerHTML=Qs,ct=a(),_=p("p"),_.textContent=Ys,ut=a(),M(R.$$.fragment),yt=a(),V=p("p"),V.innerHTML=Es,ht=a(),I=p("div"),I.innerHTML=Ns,dt=a(),S=p("p"),S.innerHTML=Fs,mt=a(),M(C.$$.fragment),Ut=a(),M(H.$$.fragment),Jt=a(),W=p("p"),W.textContent=Ps,Tt=a(),X=p("p"),X.textContent=zs,jt=a(),x=p("p"),x.innerHTML=Ls,wt=a(),M(Q.$$.fragment),ft=a(),Y=p("p"),Y.textContent=Ds,gt=a(),M(E.$$.fragment),It=a(),N=p("p"),N.innerHTML=Os,Ct=a(),M(F.$$.fragment),bt=a(),P=p("p"),P.innerHTML=Ks,$t=a(),z=p("p"),z.innerHTML=el,vt=a(),L=p("p"),L.innerHTML=tl,Bt=a(),M(D.$$.fragment),kt=a(),O=p("p"),O.innerHTML=sl,At=a(),M(K.$$.fragment),Gt=a(),ee=p("p"),ee.textContent=ll,qt=a(),te=p("p"),te.textContent=al,Zt=a(),M(b.$$.fragment),_t=a(),M(se.$$.fragment),Rt=a(),M(le.$$.fragment),Vt=a(),ae=p("p"),ae.textContent=nl,St=a(),M(ne.$$.fragment),Ht=a(),ie=p("ul"),ie.innerHTML=il,Wt=a(),pe=p("p"),pe.textContent=pl,Xt=a(),M(oe.$$.fragment),xt=a(),M(re.$$.fragment),Qt=a(),Me=p("p"),Me.innerHTML=ol,Yt=a(),M(ce.$$.fragment),Et=a(),ue=p("p"),ue.textContent=rl,Nt=a(),ye=p("ul"),ye.innerHTML=Ml,Ft=a(),M(he.$$.fragment),Pt=a(),M(de.$$.fragment),zt=a(),M(me.$$.fragment),Lt=a(),Ue=p("p"),Ue.textContent=cl,Dt=a(),M(Je.$$.fragment),Ot=a(),Te=p("p"),Te.textContent=ul,Kt=a(),M(je.$$.fragment),es=a(),M(we.$$.fragment),ts=a(),M(fe.$$.fragment),ss=a(),ge=p("p"),ge.textContent=yl,ls=a(),M($.$$.fragment),as=a(),Ie=p("p"),Ie.textContent=hl,ns=a(),M(Ce.$$.fragment),is=a(),M(be.$$.fragment),ps=a(),$e=p("p"),$e.innerHTML=dl,os=a(),v=p("div"),v.innerHTML=ml,rs=a(),ve=p("p"),ve.textContent=Ul,Ms=a(),M(Be.$$.fragment),cs=a(),ke=p("p"),ke.textContent=Jl,us=a(),M(Ae.$$.fragment),ys=a(),Ge=p("p"),Ge.textContent=Tl,hs=a(),M(qe.$$.fragment),ds=a(),M(Ze.$$.fragment),ms=a(),_e=p("p"),_e.innerHTML=jl,Us=a(),M(Re.$$.fragment),Js=a(),Ve=p("p"),Ve.textContent=wl,Ts=a(),Se=p("p"),Se.innerHTML=fl,js=a(),He=p("p"),He.innerHTML=gl,ws=a(),M(We.$$.fragment),fs=a(),M(Xe.$$.fragment),gs=a(),M(B.$$.fragment),Is=a(),M(xe.$$.fragment),Cs=a(),Qe=p("p"),Qe.innerHTML=Il,bs=a(),Ye=p("p"),Ye.innerHTML=Cl,$s=a(),Ee=p("p"),Ee.textContent=bl,vs=a(),Ne=p("p"),Ne.textContent=$l,Bs=a(),M(Fe.$$.fragment),ks=a(),M(Pe.$$.fragment),As=a(),ze=p("ul"),ze.innerHTML=vl,Gs=a(),M(Le.$$.fragment),qs=a(),De=p("ul"),De.innerHTML=Bl,Zs=a(),M(Oe.$$.fragment),_s=a(),Ke=p("p"),Ke.innerHTML=kl,Rs=a(),et=p("p"),et.innerHTML=Al,Vs=a(),M(tt.$$.fragment),Ss=a(),at=p("p"),this.h()},l(e){const t=Ql("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(s),J=n(e),m=o(e,"P",{}),Sl(m).forEach(s),T=n(e),c(k.$$.fragment,e),nt=n(e),c(f.$$.fragment,e),it=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-eo2v07"&&(A.textContent=Xs),pt=n(e),G=o(e,"OL",{"data-svelte-h":!0}),r(G)!=="svelte-8emskd"&&(G.innerHTML=xs),ot=n(e),c(q.$$.fragment,e),rt=n(e),c(g.$$.fragment,e),Mt=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-iwney4"&&(Z.innerHTML=Qs),ct=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1xoupob"&&(_.textContent=Ys),ut=n(e),c(R.$$.fragment,e),yt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-hjt0h1"&&(V.innerHTML=Es),ht=n(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(I)!=="svelte-1cxy3tx"&&(I.innerHTML=Ns),dt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-vmhaok"&&(S.innerHTML=Fs),mt=n(e),c(C.$$.fragment,e),Ut=n(e),c(H.$$.fragment,e),Jt=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-epfhsj"&&(W.textContent=Ps),Tt=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-n5dyw"&&(X.textContent=zs),jt=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-qm2nt8"&&(x.innerHTML=Ls),wt=n(e),c(Q.$$.fragment,e),ft=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-aqaw0f"&&(Y.textContent=Ds),gt=n(e),c(E.$$.fragment,e),It=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ccsiy1"&&(N.innerHTML=Os),Ct=n(e),c(F.$$.fragment,e),bt=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-qutua8"&&(P.innerHTML=Ks),$t=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-uj5o95"&&(z.innerHTML=el),vt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ozzcb1"&&(L.innerHTML=tl),Bt=n(e),c(D.$$.fragment,e),kt=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-bhaoly"&&(O.innerHTML=sl),At=n(e),c(K.$$.fragment,e),Gt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1vjzmk"&&(ee.textContent=ll),qt=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1147onl"&&(te.textContent=al),Zt=n(e),c(b.$$.fragment,e),_t=n(e),c(se.$$.fragment,e),Rt=n(e),c(le.$$.fragment,e),Vt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-f1hll8"&&(ae.textContent=nl),St=n(e),c(ne.$$.fragment,e),Ht=n(e),ie=o(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-u6m976"&&(ie.innerHTML=il),Wt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1h7c5bh"&&(pe.textContent=pl),Xt=n(e),c(oe.$$.fragment,e),xt=n(e),c(re.$$.fragment,e),Qt=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1avk6lq"&&(Me.innerHTML=ol),Yt=n(e),c(ce.$$.fragment,e),Et=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-pwj71q"&&(ue.textContent=rl),Nt=n(e),ye=o(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-1i002r6"&&(ye.innerHTML=Ml),Ft=n(e),c(he.$$.fragment,e),Pt=n(e),c(de.$$.fragment,e),zt=n(e),c(me.$$.fragment,e),Lt=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-18yjufw"&&(Ue.textContent=cl),Dt=n(e),c(Je.$$.fragment,e),Ot=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1ar1qn2"&&(Te.textContent=ul),Kt=n(e),c(je.$$.fragment,e),es=n(e),c(we.$$.fragment,e),ts=n(e),c(fe.$$.fragment,e),ss=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-16sv3hm"&&(ge.textContent=yl),ls=n(e),c($.$$.fragment,e),as=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1ovcz13"&&(Ie.textContent=hl),ns=n(e),c(Ce.$$.fragment,e),is=n(e),c(be.$$.fragment,e),ps=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1vo10n6"&&($e.innerHTML=dl),os=n(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1roilif"&&(v.innerHTML=ml),rs=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1072wo1"&&(ve.textContent=Ul),Ms=n(e),c(Be.$$.fragment,e),cs=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-74sgny"&&(ke.textContent=Jl),us=n(e),c(Ae.$$.fragment,e),ys=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-krncuc"&&(Ge.textContent=Tl),hs=n(e),c(qe.$$.fragment,e),ds=n(e),c(Ze.$$.fragment,e),ms=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-cj93i4"&&(_e.innerHTML=jl),Us=n(e),c(Re.$$.fragment,e),Js=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-speu7d"&&(Ve.textContent=wl),Ts=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-13ler1d"&&(Se.innerHTML=fl),js=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-ub059v"&&(He.innerHTML=gl),ws=n(e),c(We.$$.fragment,e),fs=n(e),c(Xe.$$.fragment,e),gs=n(e),c(B.$$.fragment,e),Is=n(e),c(xe.$$.fragment,e),Cs=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-102eqn3"&&(Qe.innerHTML=Il),bs=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-lavds"&&(Ye.innerHTML=Cl),$s=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-f0qt8k"&&(Ee.textContent=bl),vs=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-w9ft7n"&&(Ne.textContent=$l),Bs=n(e),c(Fe.$$.fragment,e),ks=n(e),c(Pe.$$.fragment,e),As=n(e),ze=o(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-117ozzs"&&(ze.innerHTML=vl),Gs=n(e),c(Le.$$.fragment,e),qs=n(e),De=o(e,"UL",{"data-svelte-h":!0}),r(De)!=="svelte-vl7c7p"&&(De.innerHTML=Bl),Zs=n(e),c(Oe.$$.fragment,e),_s=n(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1yfr1yr"&&(Ke.innerHTML=kl),Rs=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1duzsqa"&&(et.innerHTML=Al),Vs=n(e),c(tt.$$.fragment,e),Ss=n(e),at=o(e,"P",{}),Sl(at).forEach(s),this.h()},h(){Ws(i,"name","hf:doc:metadata"),Ws(i,"content",Kl),Ws(I,"class","flex justify-center"),Ws(v,"class","flex justify-center")},m(e,t){Yl(document.head,i),l(e,J,t),l(e,m,t),l(e,T,t),u(k,e,t),l(e,nt,t),u(f,e,t),l(e,it,t),l(e,A,t),l(e,pt,t),l(e,G,t),l(e,ot,t),u(q,e,t),l(e,rt,t),u(g,e,t),l(e,Mt,t),l(e,Z,t),l(e,ct,t),l(e,_,t),l(e,ut,t),u(R,e,t),l(e,yt,t),l(e,V,t),l(e,ht,t),l(e,I,t),l(e,dt,t),l(e,S,t),l(e,mt,t),u(C,e,t),l(e,Ut,t),u(H,e,t),l(e,Jt,t),l(e,W,t),l(e,Tt,t),l(e,X,t),l(e,jt,t),l(e,x,t),l(e,wt,t),u(Q,e,t),l(e,ft,t),l(e,Y,t),l(e,gt,t),u(E,e,t),l(e,It,t),l(e,N,t),l(e,Ct,t),u(F,e,t),l(e,bt,t),l(e,P,t),l(e,$t,t),l(e,z,t),l(e,vt,t),l(e,L,t),l(e,Bt,t),u(D,e,t),l(e,kt,t),l(e,O,t),l(e,At,t),u(K,e,t),l(e,Gt,t),l(e,ee,t),l(e,qt,t),l(e,te,t),l(e,Zt,t),u(b,e,t),l(e,_t,t),u(se,e,t),l(e,Rt,t),u(le,e,t),l(e,Vt,t),l(e,ae,t),l(e,St,t),u(ne,e,t),l(e,Ht,t),l(e,ie,t),l(e,Wt,t),l(e,pe,t),l(e,Xt,t),u(oe,e,t),l(e,xt,t),u(re,e,t),l(e,Qt,t),l(e,Me,t),l(e,Yt,t),u(ce,e,t),l(e,Et,t),l(e,ue,t),l(e,Nt,t),l(e,ye,t),l(e,Ft,t),u(he,e,t),l(e,Pt,t),u(de,e,t),l(e,zt,t),u(me,e,t),l(e,Lt,t),l(e,Ue,t),l(e,Dt,t),u(Je,e,t),l(e,Ot,t),l(e,Te,t),l(e,Kt,t),u(je,e,t),l(e,es,t),u(we,e,t),l(e,ts,t),u(fe,e,t),l(e,ss,t),l(e,ge,t),l(e,ls,t),u($,e,t),l(e,as,t),l(e,Ie,t),l(e,ns,t),u(Ce,e,t),l(e,is,t),u(be,e,t),l(e,ps,t),l(e,$e,t),l(e,os,t),l(e,v,t),l(e,rs,t),l(e,ve,t),l(e,Ms,t),u(Be,e,t),l(e,cs,t),l(e,ke,t),l(e,us,t),u(Ae,e,t),l(e,ys,t),l(e,Ge,t),l(e,hs,t),u(qe,e,t),l(e,ds,t),u(Ze,e,t),l(e,ms,t),l(e,_e,t),l(e,Us,t),u(Re,e,t),l(e,Js,t),l(e,Ve,t),l(e,Ts,t),l(e,Se,t),l(e,js,t),l(e,He,t),l(e,ws,t),u(We,e,t),l(e,fs,t),u(Xe,e,t),l(e,gs,t),u(B,e,t),l(e,Is,t),u(xe,e,t),l(e,Cs,t),l(e,Qe,t),l(e,bs,t),l(e,Ye,t),l(e,$s,t),l(e,Ee,t),l(e,vs,t),l(e,Ne,t),l(e,Bs,t),u(Fe,e,t),l(e,ks,t),u(Pe,e,t),l(e,As,t),l(e,ze,t),l(e,Gs,t),u(Le,e,t),l(e,qs,t),l(e,De,t),l(e,Zs,t),u(Oe,e,t),l(e,_s,t),l(e,Ke,t),l(e,Rs,t),l(e,et,t),l(e,Vs,t),u(tt,e,t),l(e,Ss,t),l(e,at,t),Hs=!0},p(e,[t]){const Gl={};t&2&&(Gl.$$scope={dirty:t,ctx:e}),f.$set(Gl);const ql={};t&2&&(ql.$$scope={dirty:t,ctx:e}),g.$set(ql);const Zl={};t&2&&(Zl.$$scope={dirty:t,ctx:e}),C.$set(Zl);const _l={};t&2&&(_l.$$scope={dirty:t,ctx:e}),b.$set(_l);const Rl={};t&2&&(Rl.$$scope={dirty:t,ctx:e}),$.$set(Rl);const Vl={};t&2&&(Vl.$$scope={dirty:t,ctx:e}),B.$set(Vl)},i(e){Hs||(y(k.$$.fragment,e),y(f.$$.fragment,e),y(q.$$.fragment,e),y(g.$$.fragment,e),y(R.$$.fragment,e),y(C.$$.fragment,e),y(H.$$.fragment,e),y(Q.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(b.$$.fragment,e),y(se.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(ce.$$.fragment,e),y(he.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(Je.$$.fragment,e),y(je.$$.fragment,e),y(we.$$.fragment,e),y(fe.$$.fragment,e),y($.$$.fragment,e),y(Ce.$$.fragment,e),y(be.$$.fragment,e),y(Be.$$.fragment,e),y(Ae.$$.fragment,e),y(qe.$$.fragment,e),y(Ze.$$.fragment,e),y(Re.$$.fragment,e),y(We.$$.fragment,e),y(Xe.$$.fragment,e),y(B.$$.fragment,e),y(xe.$$.fragment,e),y(Fe.$$.fragment,e),y(Pe.$$.fragment,e),y(Le.$$.fragment,e),y(Oe.$$.fragment,e),y(tt.$$.fragment,e),Hs=!0)},o(e){h(k.$$.fragment,e),h(f.$$.fragment,e),h(q.$$.fragment,e),h(g.$$.fragment,e),h(R.$$.fragment,e),h(C.$$.fragment,e),h(H.$$.fragment,e),h(Q.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(b.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(we.$$.fragment,e),h(fe.$$.fragment,e),h($.$$.fragment,e),h(Ce.$$.fragment,e),h(be.$$.fragment,e),h(Be.$$.fragment,e),h(Ae.$$.fragment,e),h(qe.$$.fragment,e),h(Ze.$$.fragment,e),h(Re.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(B.$$.fragment,e),h(xe.$$.fragment,e),h(Fe.$$.fragment,e),h(Pe.$$.fragment,e),h(Le.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),Hs=!1},d(e){e&&(s(J),s(m),s(T),s(nt),s(it),s(A),s(pt),s(G),s(ot),s(rt),s(Mt),s(Z),s(ct),s(_),s(ut),s(yt),s(V),s(ht),s(I),s(dt),s(S),s(mt),s(Ut),s(Jt),s(W),s(Tt),s(X),s(jt),s(x),s(wt),s(ft),s(Y),s(gt),s(It),s(N),s(Ct),s(bt),s(P),s($t),s(z),s(vt),s(L),s(Bt),s(kt),s(O),s(At),s(Gt),s(ee),s(qt),s(te),s(Zt),s(_t),s(Rt),s(Vt),s(ae),s(St),s(Ht),s(ie),s(Wt),s(pe),s(Xt),s(xt),s(Qt),s(Me),s(Yt),s(Et),s(ue),s(Nt),s(ye),s(Ft),s(Pt),s(zt),s(Lt),s(Ue),s(Dt),s(Ot),s(Te),s(Kt),s(es),s(ts),s(ss),s(ge),s(ls),s(as),s(Ie),s(ns),s(is),s(ps),s($e),s(os),s(v),s(rs),s(ve),s(Ms),s(cs),s(ke),s(us),s(ys),s(Ge),s(hs),s(ds),s(ms),s(_e),s(Us),s(Js),s(Ve),s(Ts),s(Se),s(js),s(He),s(ws),s(fs),s(gs),s(Is),s(Cs),s(Qe),s(bs),s(Ye),s($s),s(Ee),s(vs),s(Ne),s(Bs),s(ks),s(As),s(ze),s(Gs),s(qs),s(De),s(Zs),s(_s),s(Ke),s(Rs),s(et),s(Vs),s(Ss),s(at)),s(i),d(k,e),d(f,e),d(q,e),d(g,e),d(R,e),d(C,e),d(H,e),d(Q,e),d(E,e),d(F,e),d(D,e),d(K,e),d(b,e),d(se,e),d(le,e),d(ne,e),d(oe,e),d(re,e),d(ce,e),d(he,e),d(de,e),d(me,e),d(Je,e),d(je,e),d(we,e),d(fe,e),d($,e),d(Ce,e),d(be,e),d(Be,e),d(Ae,e),d(qe,e),d(Ze,e),d(Re,e),d(We,e),d(Xe,e),d(B,e),d(xe,e),d(Fe,e),d(Pe,e),d(Le,e),d(Oe,e),d(tt,e)}}}const Kl='{"title":"How to be registered as an inference provider on the Hub?","local":"how-to-be-registered-as-an-inference-provider-on-the-hub","sections":[{"title":"1. Prerequisites","local":"1-prerequisites","sections":[{"title":"What is a Task","local":"what-is-a-task","sections":[],"depth":3},{"title":"Task API schema","local":"task-api-schema","sections":[],"depth":3}],"depth":2},{"title":"2. JS Client Integration","local":"2-js-client-integration","sections":[{"title":"Implement the provider helper (JS)","local":"implement-the-provider-helper-js","sections":[],"depth":3},{"title":"Register the provider","local":"register-the-provider","sections":[],"depth":3}],"depth":2},{"title":"3. Model Mapping API","local":"3-model-mapping-api","sections":[{"title":"Register a mapping item","local":"register-a-mapping-item","sections":[{"title":"Authentication","local":"authentication","sections":[],"depth":4},{"title":"Validation","local":"validation","sections":[],"depth":4}],"depth":3},{"title":"Delete a mapping item","local":"delete-a-mapping-item","sections":[],"depth":3},{"title":"Update a mapping item’s status","local":"update-a-mapping-items-status","sections":[],"depth":3},{"title":"List the whole mapping","local":"list-the-whole-mapping","sections":[],"depth":3}],"depth":2},{"title":"4. Billing","local":"4-billing","sections":[{"title":"HTTP API Specs","local":"http-api-specs","sections":[],"depth":3},{"title":"Price Unit","local":"price-unit","sections":[],"depth":3},{"title":"How to define the request ID","local":"how-to-define-the-request-id","sections":[],"depth":3}],"depth":2},{"title":"5. Python client integration","local":"5-python-client-integration","sections":[{"title":"Implement the provider helper (Python)","local":"implement-the-provider-helper-python","sections":[],"depth":3},{"title":"Register the Provider","local":"register-the-provider","sections":[],"depth":3},{"title":"Add tests","local":"add-tests","sections":[],"depth":3}],"depth":2},{"title":"FAQ","local":"faq","sections":[],"depth":2}],"depth":1}';function ea(j){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ia extends Xl{constructor(i){super(),xl(this,i,ea,Ol,Hl,{})}}export{ia as component};
