import{s as Xd,o as Nd,n as x}from"../chunks/scheduler.7da89386.js";import{S as Sd,i as zd,g as m,s as l,r as u,A as Bd,h as d,f as i,c as r,j as v,u as g,x as _,k as j,y as o,a as c,v as h,d as f,t as b,w as M}from"../chunks/index.20910acc.js";import{T as W}from"../chunks/Tip.53e22153.js";import{D as J}from"../chunks/Docstring.996c88d3.js";import{C as R}from"../chunks/CodeBlock.143bd81e.js";import{E as U}from"../chunks/ExampleCodeBlock.87e2322d.js";import{H as k}from"../chunks/getInferenceSnippets.be5a64ab.js";function qd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Od(w){let n,T="Example of text generation:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Ed(w){let n,T="Example using <code>transformers.pipelines</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Hd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Ld(w){let n,T="Example of feature extraction:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-12vwt80"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Qd(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Yd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Pd(w){let n,T="Example of text generation:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Ad(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Dd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Kd(w){let n,T="Example of single-label classification:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-ykxpe4"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function ec(w){let n,T="Example using <code>transformers.pipelines</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function tc(w){let n,T="Example using zero-shot-classification <code>transformers.pipelines</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1vtj8d2"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function nc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function sc(w){let n,T="Example of token classification:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-rtgw80"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function oc(w){let n,T="Example using <code>transformers.pipelines</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function ac(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function lc(w){let n,T="Example of mutliple choice:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-lfckvi"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function rc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function ic(w){let n,T="Example of question answering:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1ml1brl"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function pc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function mc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function dc(w){let n,T="Example of image classification:",a,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1nh3zco"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function cc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function uc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function gc(w){let n,T="Example of semantic segmentation:",a,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1wzzaup"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function hc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function fc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function bc(w){let n,T="Example of audio classification:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1mp8f15"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Mc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function yc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Tc(w){let n,T="Example of audio frame classification:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-12boqdm"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function _c(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function $c(w){let n,T="Example of CTC:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-mdyxnj"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function wc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function vc(w){let n,T="Example of text generation:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function jc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Jc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function xc(w){let n,T="Example of Audio XVector:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1kzdm5c"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function kc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Uc(w){let n,T="Example of text generation:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Rc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Zc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Wc(w){let n,T="Example of pix2struct:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-11ikyn3"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Cc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Fc(w){let n,T="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-6kynse"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Ic(w){let n,T="Example using <code>transformers.pipelines</code>(only if the task is supported):",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-xxeb0k"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Gc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Vc(w){let n,T="Example of feature extraction:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-12vwt80"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Xc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:x,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(a)),M(s,t)}}}function Nc(w){let n,T,a,s,y,t,$,Sa,dn,tm="The following ORT classes are available for instantiating a base model class without a specific head.",za,cn,Ba,Z,un,tr,ro,nm="Base class for implementing models using ONNX Runtime.",nr,io,sm=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,sr,po,om="Class attributes:",or,mo,am=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,ar,at,gn,lr,co,lm="Returns whether this model can generate sequences with <code>.generate()</code>.",rr,lt,hn,ir,uo,rm="Instantiate a pretrained model from a pre-trained model configuration.",qa,fn,Oa,bn,im="The following ORT classes are available for the following natural language processing tasks.",Ea,Mn,Ha,I,yn,pr,go,pm="ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt-bigcode, gpt_neo, gpt_neox, gptj, llama.",mr,ho,mm=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,dr,fo,dm='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',cr,ee,Tn,ur,bo,cm="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",gr,rt,hr,it,fr,pt,La,_n,Qa,G,$n,br,Mo,um="ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.",Mr,yo,gm=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,yr,To,hm='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Tr,te,wn,_r,_o,fm="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",$r,mt,wr,dt,vr,ct,Ya,vn,Pa,V,jn,jr,$o,bm="Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot-small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.",Jr,wo,Mm=`This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,xr,vo,ym="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",kr,ne,Jn,Ur,jo,Tm="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",Rr,ut,Zr,gt,Wr,ht,Aa,xn,Da,X,kn,Cr,Jo,_m=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Fr,xo,$m=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ir,ko,wm='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Gr,F,Un,Vr,Uo,vm="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",Xr,ft,Nr,bt,Sr,Mt,zr,yt,Ka,Rn,el,N,Zn,Br,Ro,jm=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,qr,Zo,Jm=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Or,Wo,xm='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Er,se,Wn,Hr,Co,km="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",Lr,Tt,Qr,_t,Yr,$t,tl,Cn,nl,S,Fn,Pr,Fo,Um=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Ar,Io,Rm=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Dr,Go,Zm='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Kr,Be,In,ei,Vo,Wm="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",ti,wt,ni,vt,sl,Gn,ol,z,Vn,si,Xo,Cm="ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.",oi,No,Fm=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ai,So,Im='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',li,oe,Xn,ri,zo,Gm="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",ii,jt,pi,Jt,mi,xt,al,Nn,ll,Sn,Vm="The following ORT classes are available for the following computer vision tasks.",rl,zn,il,B,Bn,di,Bo,Xm="ONNX Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, data2vec-vision, deit, dinov2, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, swinv2, vit.",ci,qo,Nm=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ui,Oo,Sm='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',gi,ae,qn,hi,Eo,zm="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",fi,kt,bi,Ut,Mi,Rt,pl,On,ml,q,En,yi,Ho,Bm="ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports maskformer, segformer.",Ti,Lo,qm=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,_i,Qo,Om='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',$i,le,Hn,wi,Yo,Em="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",vi,Zt,ji,Wt,Ji,Ct,dl,Ln,cl,Qn,Hm="The following ORT classes are available for the following audio tasks.",ul,Yn,gl,O,Pn,xi,Po,Lm=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,ki,Ao,Qm=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ui,Do,Ym='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ri,re,An,Zi,Ko,Pm="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",Wi,Ft,Ci,It,Fi,Gt,hl,Dn,fl,E,Kn,Ii,ea,Am="ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Gi,ta,Dm=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Vi,na,Km='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Xi,qe,es,Ni,sa,ed="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",Si,Vt,zi,Xt,bl,ts,Ml,H,ns,Bi,oa,td="ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",qi,aa,nd=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Oi,la,sd='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ei,Oe,ss,Hi,ra,od="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",Li,Nt,Qi,St,yl,os,Tl,L,as,Yi,ia,ad="Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.",Pi,pa,ld=`This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ai,ma,rd="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",Di,ie,ls,Ki,da,id="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",ep,zt,tp,Bt,np,qt,_l,rs,$l,Q,is,sp,ca,pd="ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",op,ua,md=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ap,ga,dd='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',lp,Ee,ps,rp,ha,cd="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",ip,Ot,pp,Et,wl,ms,vl,ds,ud="The following ORT classes are available for the following multimodal tasks.",jl,cs,Jl,Y,us,mp,fa,gd="VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.",dp,ba,hd=`This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,cp,Ma,fd="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",up,pe,gs,gp,ya,bd="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",hp,Ht,fp,Lt,bp,Qt,xl,hs,kl,P,fs,Mp,Ta,Md="Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.",yp,_a,yd=`This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Tp,$a,Td="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",_p,He,bs,$p,wa,_d="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",wp,Yt,vp,Pt,Ul,Ms,Rl,ys,$d="The following ORT classes are available for the following custom tasks.",Zl,Ts,Wl,A,_s,jp,va,wd="ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.",Jp,ja,vd=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,xp,Ja,jd='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',kp,me,$s,Up,xa,Jd="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",Rp,At,Zp,Dt,Wp,Kt,Cl,ws,Fl,D,vs,Cp,ka,xd="ONNX Model for feature-extraction task.",Fp,Ua,kd=`This model inherits from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ip,Ra,Ud='This class should be initialized using the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Gp,de,js,Vp,Za,Rd="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",Xp,en,Np,tn,Sp,nn,Il,Js,Gl,xs,Vl,De,ks,zp,sn,Us,Bp,Wa,Zd="Call self as a function.",Xl,Rs,Nl,Ke,Zs,qp,on,Ws,Op,Ca,Wd="Call self as a function.",Sl,Cs,zl,et,Fs,Ep,an,Is,Hp,Fa,Cd="Call self as a function.",Bl,Gs,ql,tt,Vs,Lp,ln,Xs,Qp,Ia,Fd="Call self as a function.",Ol,Ns,El,nt,Ss,Yp,rn,zs,Pp,Ga,Id="Call self as a function.",Hl,Bs,Ll,st,qs,Ap,pn,Os,Dp,Va,Gd="Call self as a function.",Ql,Es,Yl,ot,Hs,Kp,mn,Ls,em,Xa,Vd="Call self as a function.",Pl,Na,Al;return y=new k({props:{title:"Models",local:"models",headingTag:"h1"}}),$=new k({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),cn=new k({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),un=new J({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.-",description:'<strong>-</strong> config (<a href="https://huggingface.co/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> &#x2014; The configuration of the model. &#x2014;',name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> session (<code>~onnxruntime.InferenceSession</code>) &#x2014; The ONNX Runtime InferenceSession that is running the model. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to use I/O bindings with **ONNX Runtime &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.with",description:"<strong>with</strong> the CUDAExecutionProvider**, this can significantly speedup inference depending on the task. &#x2014;",name:"with"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> model_save_dir (<code>Path</code>) &#x2014; The directory where the model exported to ONNX is saved. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.By",description:"<strong>By</strong> defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the &#x2014;",name:"By"},{anchor:"optimum.onnxruntime.ORTModel.cache",description:"<strong>cache</strong> directory is used. &#x2014;",name:"cache"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L126"}}),gn=new J({props:{name:"can_generate",anchor:"optimum.onnxruntime.ORTModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L569"}}),hn=new J({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": typing.Union[str, pathlib.Path]"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"},{name:"export",val:": bool = False"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": str = 'main'"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"trust_remote_code",val:": bool = False"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"providers",val:": typing.Optional[typing.Sequence[str]] = None"},{name:"provider_options",val:": typing.Union[typing.Sequence[typing.Dict[str, typing.Any]], typing.Dict[str, typing.Any], NoneType] = None"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.export",description:`<strong>export</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> needs to be exported to the targeted format.`,name:"export"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
Deprecated. Please use the <code>token</code> argument instead.`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model.
See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.providers",description:`<strong>providers</strong> (<code>Optional[Sequence[str]]</code>, defaults to <code>None</code>) &#x2014;
List of execution providers to use for loading the model.
This argument takes precedence over the <code>provider</code> argument.`,name:"providers"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>), &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_io_binding",description:`<strong>use_io_binding</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.`,name:"use_io_binding"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Will be passed to the underlying model loading methods.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L439",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`,parameterGroups:[{title:"Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_cache",description:`<strong>use_cache</strong> (<code>Optional[bool]</code>, defaults to <code>True</code>) &#x2014;
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,name:"use_cache"}]},{title:"Parameters for ORTModelForCausalLM",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_merged",description:`<strong>use_merged</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,name:"use_merged"}]}]}}),fn=new k({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),Mn=new k({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),yn=new J({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_decoder.py#L122"}}),Tn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_decoder.py#L241"}}),rt=new W({props:{$$slots:{default:[qd]},$$scope:{ctx:w}}}),it=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[Od]},$$scope:{ctx:w}}}),pt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[Ed]},$$scope:{ctx:w}}}),_n=new k({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),$n=new J({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L758"}}),wn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L766"}}),mt=new W({props:{$$slots:{default:[Hd]},$$scope:{ctx:w}}}),dt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[Ld]},$$scope:{ctx:w}}}),ct=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[Qd]},$$scope:{ctx:w}}}),vn=new k({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),jn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": typing.Optional[ForwardRef('InferenceSession')] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_seq2seq.py#L1296"}}),Jn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_seq2seq.py#L1305"}}),ut=new W({props:{$$slots:{default:[Yd]},$$scope:{ctx:w}}}),gt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[Pd]},$$scope:{ctx:w}}}),ht=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[Ad]},$$scope:{ctx:w}}}),xn=new k({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),kn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L978"}}),Un=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L987"}}),ft=new W({props:{$$slots:{default:[Dd]},$$scope:{ctx:w}}}),bt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[Kd]},$$scope:{ctx:w}}}),Mt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[ec]},$$scope:{ctx:w}}}),yt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[tc]},$$scope:{ctx:w}}}),Rn=new k({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),Zn=new J({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1080"}}),Wn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1090"}}),Tt=new W({props:{$$slots:{default:[nc]},$$scope:{ctx:w}}}),_t=new U({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[sc]},$$scope:{ctx:w}}}),$t=new U({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[oc]},$$scope:{ctx:w}}}),Cn=new k({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),Fn=new J({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1177"}}),In=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1186"}}),wt=new W({props:{$$slots:{default:[ac]},$$scope:{ctx:w}}}),vt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[lc]},$$scope:{ctx:w}}}),Gn=new k({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),Vn=new J({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L860"}}),Xn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L868"}}),jt=new W({props:{$$slots:{default:[rc]},$$scope:{ctx:w}}}),Jt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[ic]},$$scope:{ctx:w}}}),xt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[pc]},$$scope:{ctx:w}}}),Nn=new k({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),zn=new k({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),Bn=new J({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1283"}}),qn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1291"}}),kt=new W({props:{$$slots:{default:[mc]},$$scope:{ctx:w}}}),Ut=new U({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[dc]},$$scope:{ctx:w}}}),Rt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[cc]},$$scope:{ctx:w}}}),On=new k({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),En=new J({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1381"}}),Hn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1389"}}),Zt=new W({props:{$$slots:{default:[uc]},$$scope:{ctx:w}}}),Wt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[gc]},$$scope:{ctx:w}}}),Ct=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[hc]},$$scope:{ctx:w}}}),Ln=new k({props:{title:"Audio",local:"audio",headingTag:"h2"}}),Yn=new k({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),Pn=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1483"}}),An=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_features",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1492"}}),Ft=new W({props:{$$slots:{default:[fc]},$$scope:{ctx:w}}}),It=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[bc]},$$scope:{ctx:w}}}),Gt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[Mc]},$$scope:{ctx:w}}}),Dn=new k({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),Kn=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1775"}}),es=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1783"}}),Vt=new W({props:{$$slots:{default:[yc]},$$scope:{ctx:w}}}),Xt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[Tc]},$$scope:{ctx:w}}}),ts=new k({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),ns=new J({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1582"}}),ss=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1590"}}),Nt=new W({props:{$$slots:{default:[_c]},$$scope:{ctx:w}}}),St=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[$c]},$$scope:{ctx:w}}}),os=new k({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),as=new J({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_seq2seq.py#L1393"}}),ls=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"cache_position",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_seq2seq.py#L1416"}}),zt=new W({props:{$$slots:{default:[wc]},$$scope:{ctx:w}}}),Bt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[vc]},$$scope:{ctx:w}}}),qt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[jc]},$$scope:{ctx:w}}}),rs=new k({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),is=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1686"}}),ps=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1694"}}),Ot=new W({props:{$$slots:{default:[Jc]},$$scope:{ctx:w}}}),Et=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[xc]},$$scope:{ctx:w}}}),ms=new k({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),cs=new k({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),us=new J({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": typing.Optional[ForwardRef('InferenceSession')] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_seq2seq.py#L1529"}}),gs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_seq2seq.py#L1540"}}),Ht=new W({props:{$$slots:{default:[kc]},$$scope:{ctx:w}}}),Lt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[Uc]},$$scope:{ctx:w}}}),Qt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[Rc]},$$scope:{ctx:w}}}),hs=new k({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),fs=new J({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": typing.Optional[ForwardRef('InferenceSession')] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_seq2seq.py#L1625"}}),bs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_seq2seq.py#L1637"}}),Yt=new W({props:{$$slots:{default:[Zc]},$$scope:{ctx:w}}}),Pt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[Wc]},$$scope:{ctx:w}}}),Ms=new k({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),Ts=new k({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),_s=new J({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1958"}}),$s=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**model_inputs",val:": typing.Union[torch.Tensor, numpy.ndarray]"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L1964"}}),At=new W({props:{$$slots:{default:[Cc]},$$scope:{ctx:w}}}),Dt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[Fc]},$$scope:{ctx:w}}}),Kt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[Ic]},$$scope:{ctx:w}}}),ws=new k({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),vs=new J({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L624"}}),js=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"position_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"visual_embeds",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"visual_attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"visual_token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_features",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/onnxruntime/modeling_ort.py#L632"}}),en=new W({props:{$$slots:{default:[Gc]},$$scope:{ctx:w}}}),tn=new U({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[Vc]},$$scope:{ctx:w}}}),nn=new U({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[Xc]},$$scope:{ctx:w}}}),Js=new k({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),xs=new k({props:{title:"ORTDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",headingTag:"h4"}}),ks=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/utils/dummy_diffusers_objects.py#L18"}}),Us=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Rs=new k({props:{title:"ORTStableDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",headingTag:"h4"}}),Zs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/utils/dummy_diffusers_objects.py#L62"}}),Ws=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Cs=new k({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),Fs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/utils/dummy_diffusers_objects.py#L73"}}),Is=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Gs=new k({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),Vs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/utils/dummy_diffusers_objects.py#L84"}}),Xs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ns=new k({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),Ss=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/utils/dummy_diffusers_objects.py#L95"}}),zs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Bs=new k({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),qs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/utils/dummy_diffusers_objects.py#L106"}}),Os=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Es=new k({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",headingTag:"h4"}}),Hs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_9/optimum/utils/dummy_diffusers_objects.py#L128"}}),Ls=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),{c(){n=m("meta"),T=l(),a=m("p"),s=l(),u(y.$$.fragment),t=l(),u($.$$.fragment),Sa=l(),dn=m("p"),dn.textContent=tm,za=l(),u(cn.$$.fragment),Ba=l(),Z=m("div"),u(un.$$.fragment),tr=l(),ro=m("p"),ro.textContent=nm,nr=l(),io=m("p"),io.innerHTML=sm,sr=l(),po=m("p"),po.textContent=om,or=l(),mo=m("ul"),mo.innerHTML=am,ar=l(),at=m("div"),u(gn.$$.fragment),lr=l(),co=m("p"),co.innerHTML=lm,rr=l(),lt=m("div"),u(hn.$$.fragment),ir=l(),uo=m("p"),uo.textContent=rm,qa=l(),u(fn.$$.fragment),Oa=l(),bn=m("p"),bn.textContent=im,Ea=l(),u(Mn.$$.fragment),Ha=l(),I=m("div"),u(yn.$$.fragment),pr=l(),go=m("p"),go.textContent=pm,mr=l(),ho=m("p"),ho.innerHTML=mm,dr=l(),fo=m("p"),fo.innerHTML=dm,cr=l(),ee=m("div"),u(Tn.$$.fragment),ur=l(),bo=m("p"),bo.innerHTML=cm,gr=l(),u(rt.$$.fragment),hr=l(),u(it.$$.fragment),fr=l(),u(pt.$$.fragment),La=l(),u(_n.$$.fragment),Qa=l(),G=m("div"),u($n.$$.fragment),br=l(),Mo=m("p"),Mo.textContent=um,Mr=l(),yo=m("p"),yo.innerHTML=gm,yr=l(),To=m("p"),To.innerHTML=hm,Tr=l(),te=m("div"),u(wn.$$.fragment),_r=l(),_o=m("p"),_o.innerHTML=fm,$r=l(),u(mt.$$.fragment),wr=l(),u(dt.$$.fragment),vr=l(),u(ct.$$.fragment),Ya=l(),u(vn.$$.fragment),Pa=l(),V=m("div"),u(jn.$$.fragment),jr=l(),$o=m("p"),$o.textContent=bm,Jr=l(),wo=m("p"),wo.innerHTML=Mm,xr=l(),vo=m("p"),vo.innerHTML=ym,kr=l(),ne=m("div"),u(Jn.$$.fragment),Ur=l(),jo=m("p"),jo.innerHTML=Tm,Rr=l(),u(ut.$$.fragment),Zr=l(),u(gt.$$.fragment),Wr=l(),u(ht.$$.fragment),Aa=l(),u(xn.$$.fragment),Da=l(),X=m("div"),u(kn.$$.fragment),Cr=l(),Jo=m("p"),Jo.textContent=_m,Fr=l(),xo=m("p"),xo.innerHTML=$m,Ir=l(),ko=m("p"),ko.innerHTML=wm,Gr=l(),F=m("div"),u(Un.$$.fragment),Vr=l(),Uo=m("p"),Uo.innerHTML=vm,Xr=l(),u(ft.$$.fragment),Nr=l(),u(bt.$$.fragment),Sr=l(),u(Mt.$$.fragment),zr=l(),u(yt.$$.fragment),Ka=l(),u(Rn.$$.fragment),el=l(),N=m("div"),u(Zn.$$.fragment),Br=l(),Ro=m("p"),Ro.textContent=jm,qr=l(),Zo=m("p"),Zo.innerHTML=Jm,Or=l(),Wo=m("p"),Wo.innerHTML=xm,Er=l(),se=m("div"),u(Wn.$$.fragment),Hr=l(),Co=m("p"),Co.innerHTML=km,Lr=l(),u(Tt.$$.fragment),Qr=l(),u(_t.$$.fragment),Yr=l(),u($t.$$.fragment),tl=l(),u(Cn.$$.fragment),nl=l(),S=m("div"),u(Fn.$$.fragment),Pr=l(),Fo=m("p"),Fo.textContent=Um,Ar=l(),Io=m("p"),Io.innerHTML=Rm,Dr=l(),Go=m("p"),Go.innerHTML=Zm,Kr=l(),Be=m("div"),u(In.$$.fragment),ei=l(),Vo=m("p"),Vo.innerHTML=Wm,ti=l(),u(wt.$$.fragment),ni=l(),u(vt.$$.fragment),sl=l(),u(Gn.$$.fragment),ol=l(),z=m("div"),u(Vn.$$.fragment),si=l(),Xo=m("p"),Xo.textContent=Cm,oi=l(),No=m("p"),No.innerHTML=Fm,ai=l(),So=m("p"),So.innerHTML=Im,li=l(),oe=m("div"),u(Xn.$$.fragment),ri=l(),zo=m("p"),zo.innerHTML=Gm,ii=l(),u(jt.$$.fragment),pi=l(),u(Jt.$$.fragment),mi=l(),u(xt.$$.fragment),al=l(),u(Nn.$$.fragment),ll=l(),Sn=m("p"),Sn.textContent=Vm,rl=l(),u(zn.$$.fragment),il=l(),B=m("div"),u(Bn.$$.fragment),di=l(),Bo=m("p"),Bo.textContent=Xm,ci=l(),qo=m("p"),qo.innerHTML=Nm,ui=l(),Oo=m("p"),Oo.innerHTML=Sm,gi=l(),ae=m("div"),u(qn.$$.fragment),hi=l(),Eo=m("p"),Eo.innerHTML=zm,fi=l(),u(kt.$$.fragment),bi=l(),u(Ut.$$.fragment),Mi=l(),u(Rt.$$.fragment),pl=l(),u(On.$$.fragment),ml=l(),q=m("div"),u(En.$$.fragment),yi=l(),Ho=m("p"),Ho.textContent=Bm,Ti=l(),Lo=m("p"),Lo.innerHTML=qm,_i=l(),Qo=m("p"),Qo.innerHTML=Om,$i=l(),le=m("div"),u(Hn.$$.fragment),wi=l(),Yo=m("p"),Yo.innerHTML=Em,vi=l(),u(Zt.$$.fragment),ji=l(),u(Wt.$$.fragment),Ji=l(),u(Ct.$$.fragment),dl=l(),u(Ln.$$.fragment),cl=l(),Qn=m("p"),Qn.textContent=Hm,ul=l(),u(Yn.$$.fragment),gl=l(),O=m("div"),u(Pn.$$.fragment),xi=l(),Po=m("p"),Po.textContent=Lm,ki=l(),Ao=m("p"),Ao.innerHTML=Qm,Ui=l(),Do=m("p"),Do.innerHTML=Ym,Ri=l(),re=m("div"),u(An.$$.fragment),Zi=l(),Ko=m("p"),Ko.innerHTML=Pm,Wi=l(),u(Ft.$$.fragment),Ci=l(),u(It.$$.fragment),Fi=l(),u(Gt.$$.fragment),hl=l(),u(Dn.$$.fragment),fl=l(),E=m("div"),u(Kn.$$.fragment),Ii=l(),ea=m("p"),ea.textContent=Am,Gi=l(),ta=m("p"),ta.innerHTML=Dm,Vi=l(),na=m("p"),na.innerHTML=Km,Xi=l(),qe=m("div"),u(es.$$.fragment),Ni=l(),sa=m("p"),sa.innerHTML=ed,Si=l(),u(Vt.$$.fragment),zi=l(),u(Xt.$$.fragment),bl=l(),u(ts.$$.fragment),Ml=l(),H=m("div"),u(ns.$$.fragment),Bi=l(),oa=m("p"),oa.textContent=td,qi=l(),aa=m("p"),aa.innerHTML=nd,Oi=l(),la=m("p"),la.innerHTML=sd,Ei=l(),Oe=m("div"),u(ss.$$.fragment),Hi=l(),ra=m("p"),ra.innerHTML=od,Li=l(),u(Nt.$$.fragment),Qi=l(),u(St.$$.fragment),yl=l(),u(os.$$.fragment),Tl=l(),L=m("div"),u(as.$$.fragment),Yi=l(),ia=m("p"),ia.textContent=ad,Pi=l(),pa=m("p"),pa.innerHTML=ld,Ai=l(),ma=m("p"),ma.innerHTML=rd,Di=l(),ie=m("div"),u(ls.$$.fragment),Ki=l(),da=m("p"),da.innerHTML=id,ep=l(),u(zt.$$.fragment),tp=l(),u(Bt.$$.fragment),np=l(),u(qt.$$.fragment),_l=l(),u(rs.$$.fragment),$l=l(),Q=m("div"),u(is.$$.fragment),sp=l(),ca=m("p"),ca.textContent=pd,op=l(),ua=m("p"),ua.innerHTML=md,ap=l(),ga=m("p"),ga.innerHTML=dd,lp=l(),Ee=m("div"),u(ps.$$.fragment),rp=l(),ha=m("p"),ha.innerHTML=cd,ip=l(),u(Ot.$$.fragment),pp=l(),u(Et.$$.fragment),wl=l(),u(ms.$$.fragment),vl=l(),ds=m("p"),ds.textContent=ud,jl=l(),u(cs.$$.fragment),Jl=l(),Y=m("div"),u(us.$$.fragment),mp=l(),fa=m("p"),fa.textContent=gd,dp=l(),ba=m("p"),ba.innerHTML=hd,cp=l(),Ma=m("p"),Ma.innerHTML=fd,up=l(),pe=m("div"),u(gs.$$.fragment),gp=l(),ya=m("p"),ya.innerHTML=bd,hp=l(),u(Ht.$$.fragment),fp=l(),u(Lt.$$.fragment),bp=l(),u(Qt.$$.fragment),xl=l(),u(hs.$$.fragment),kl=l(),P=m("div"),u(fs.$$.fragment),Mp=l(),Ta=m("p"),Ta.textContent=Md,yp=l(),_a=m("p"),_a.innerHTML=yd,Tp=l(),$a=m("p"),$a.innerHTML=Td,_p=l(),He=m("div"),u(bs.$$.fragment),$p=l(),wa=m("p"),wa.innerHTML=_d,wp=l(),u(Yt.$$.fragment),vp=l(),u(Pt.$$.fragment),Ul=l(),u(Ms.$$.fragment),Rl=l(),ys=m("p"),ys.textContent=$d,Zl=l(),u(Ts.$$.fragment),Wl=l(),A=m("div"),u(_s.$$.fragment),jp=l(),va=m("p"),va.textContent=wd,Jp=l(),ja=m("p"),ja.innerHTML=vd,xp=l(),Ja=m("p"),Ja.innerHTML=jd,kp=l(),me=m("div"),u($s.$$.fragment),Up=l(),xa=m("p"),xa.innerHTML=Jd,Rp=l(),u(At.$$.fragment),Zp=l(),u(Dt.$$.fragment),Wp=l(),u(Kt.$$.fragment),Cl=l(),u(ws.$$.fragment),Fl=l(),D=m("div"),u(vs.$$.fragment),Cp=l(),ka=m("p"),ka.textContent=xd,Fp=l(),Ua=m("p"),Ua.innerHTML=kd,Ip=l(),Ra=m("p"),Ra.innerHTML=Ud,Gp=l(),de=m("div"),u(js.$$.fragment),Vp=l(),Za=m("p"),Za.innerHTML=Rd,Xp=l(),u(en.$$.fragment),Np=l(),u(tn.$$.fragment),Sp=l(),u(nn.$$.fragment),Il=l(),u(Js.$$.fragment),Gl=l(),u(xs.$$.fragment),Vl=l(),De=m("div"),u(ks.$$.fragment),zp=l(),sn=m("div"),u(Us.$$.fragment),Bp=l(),Wa=m("p"),Wa.textContent=Zd,Xl=l(),u(Rs.$$.fragment),Nl=l(),Ke=m("div"),u(Zs.$$.fragment),qp=l(),on=m("div"),u(Ws.$$.fragment),Op=l(),Ca=m("p"),Ca.textContent=Wd,Sl=l(),u(Cs.$$.fragment),zl=l(),et=m("div"),u(Fs.$$.fragment),Ep=l(),an=m("div"),u(Is.$$.fragment),Hp=l(),Fa=m("p"),Fa.textContent=Cd,Bl=l(),u(Gs.$$.fragment),ql=l(),tt=m("div"),u(Vs.$$.fragment),Lp=l(),ln=m("div"),u(Xs.$$.fragment),Qp=l(),Ia=m("p"),Ia.textContent=Fd,Ol=l(),u(Ns.$$.fragment),El=l(),nt=m("div"),u(Ss.$$.fragment),Yp=l(),rn=m("div"),u(zs.$$.fragment),Pp=l(),Ga=m("p"),Ga.textContent=Id,Hl=l(),u(Bs.$$.fragment),Ll=l(),st=m("div"),u(qs.$$.fragment),Ap=l(),pn=m("div"),u(Os.$$.fragment),Dp=l(),Va=m("p"),Va.textContent=Gd,Ql=l(),u(Es.$$.fragment),Yl=l(),ot=m("div"),u(Hs.$$.fragment),Kp=l(),mn=m("div"),u(Ls.$$.fragment),em=l(),Xa=m("p"),Xa.textContent=Vd,Pl=l(),Na=m("p"),this.h()},l(e){const p=Bd("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(i),T=r(e),a=d(e,"P",{}),v(a).forEach(i),s=r(e),g(y.$$.fragment,e),t=r(e),g($.$$.fragment,e),Sa=r(e),dn=d(e,"P",{"data-svelte-h":!0}),_(dn)!=="svelte-uyecg"&&(dn.textContent=tm),za=r(e),g(cn.$$.fragment,e),Ba=r(e),Z=d(e,"DIV",{class:!0});var C=v(Z);g(un.$$.fragment,C),tr=r(C),ro=d(C,"P",{"data-svelte-h":!0}),_(ro)!=="svelte-12yueui"&&(ro.textContent=nm),nr=r(C),io=d(C,"P",{"data-svelte-h":!0}),_(io)!=="svelte-zarm0s"&&(io.innerHTML=sm),sr=r(C),po=d(C,"P",{"data-svelte-h":!0}),_(po)!=="svelte-wz8va1"&&(po.textContent=om),or=r(C),mo=d(C,"UL",{"data-svelte-h":!0}),_(mo)!=="svelte-qpxha0"&&(mo.innerHTML=am),ar=r(C),at=d(C,"DIV",{class:!0});var Qs=v(at);g(gn.$$.fragment,Qs),lr=r(Qs),co=d(Qs,"P",{"data-svelte-h":!0}),_(co)!=="svelte-1r2xt0l"&&(co.innerHTML=lm),Qs.forEach(i),rr=r(C),lt=d(C,"DIV",{class:!0});var Ys=v(lt);g(hn.$$.fragment,Ys),ir=r(Ys),uo=d(Ys,"P",{"data-svelte-h":!0}),_(uo)!=="svelte-18vxhwp"&&(uo.textContent=rm),Ys.forEach(i),C.forEach(i),qa=r(e),g(fn.$$.fragment,e),Oa=r(e),bn=d(e,"P",{"data-svelte-h":!0}),_(bn)!=="svelte-1tlroh"&&(bn.textContent=im),Ea=r(e),g(Mn.$$.fragment,e),Ha=r(e),I=d(e,"DIV",{class:!0});var ce=v(I);g(yn.$$.fragment,ce),pr=r(ce),go=d(ce,"P",{"data-svelte-h":!0}),_(go)!=="svelte-xjbh35"&&(go.textContent=pm),mr=r(ce),ho=d(ce,"P",{"data-svelte-h":!0}),_(ho)!=="svelte-nbrge6"&&(ho.innerHTML=mm),dr=r(ce),fo=d(ce,"P",{"data-svelte-h":!0}),_(fo)!=="svelte-1pmivet"&&(fo.innerHTML=dm),cr=r(ce),ee=d(ce,"DIV",{class:!0});var ue=v(ee);g(Tn.$$.fragment,ue),ur=r(ue),bo=d(ue,"P",{"data-svelte-h":!0}),_(bo)!=="svelte-1ox9av6"&&(bo.innerHTML=cm),gr=r(ue),g(rt.$$.fragment,ue),hr=r(ue),g(it.$$.fragment,ue),fr=r(ue),g(pt.$$.fragment,ue),ue.forEach(i),ce.forEach(i),La=r(e),g(_n.$$.fragment,e),Qa=r(e),G=d(e,"DIV",{class:!0});var ge=v(G);g($n.$$.fragment,ge),br=r(ge),Mo=d(ge,"P",{"data-svelte-h":!0}),_(Mo)!=="svelte-cu5s5g"&&(Mo.textContent=um),Mr=r(ge),yo=d(ge,"P",{"data-svelte-h":!0}),_(yo)!=="svelte-nbrge6"&&(yo.innerHTML=gm),yr=r(ge),To=d(ge,"P",{"data-svelte-h":!0}),_(To)!=="svelte-1pmivet"&&(To.innerHTML=hm),Tr=r(ge),te=d(ge,"DIV",{class:!0});var he=v(te);g(wn.$$.fragment,he),_r=r(he),_o=d(he,"P",{"data-svelte-h":!0}),_(_o)!=="svelte-1xqof9m"&&(_o.innerHTML=fm),$r=r(he),g(mt.$$.fragment,he),wr=r(he),g(dt.$$.fragment,he),vr=r(he),g(ct.$$.fragment,he),he.forEach(i),ge.forEach(i),Ya=r(e),g(vn.$$.fragment,e),Pa=r(e),V=d(e,"DIV",{class:!0});var fe=v(V);g(jn.$$.fragment,fe),jr=r(fe),$o=d(fe,"P",{"data-svelte-h":!0}),_($o)!=="svelte-voqu2o"&&($o.textContent=bm),Jr=r(fe),wo=d(fe,"P",{"data-svelte-h":!0}),_(wo)!=="svelte-z8qqoo"&&(wo.innerHTML=Mm),xr=r(fe),vo=d(fe,"P",{"data-svelte-h":!0}),_(vo)!=="svelte-10uuk2l"&&(vo.innerHTML=ym),kr=r(fe),ne=d(fe,"DIV",{class:!0});var be=v(ne);g(Jn.$$.fragment,be),Ur=r(be),jo=d(be,"P",{"data-svelte-h":!0}),_(jo)!=="svelte-n65k7h"&&(jo.innerHTML=Tm),Rr=r(be),g(ut.$$.fragment,be),Zr=r(be),g(gt.$$.fragment,be),Wr=r(be),g(ht.$$.fragment,be),be.forEach(i),fe.forEach(i),Aa=r(e),g(xn.$$.fragment,e),Da=r(e),X=d(e,"DIV",{class:!0});var Me=v(X);g(kn.$$.fragment,Me),Cr=r(Me),Jo=d(Me,"P",{"data-svelte-h":!0}),_(Jo)!=="svelte-1fcejq5"&&(Jo.textContent=_m),Fr=r(Me),xo=d(Me,"P",{"data-svelte-h":!0}),_(xo)!=="svelte-nbrge6"&&(xo.innerHTML=$m),Ir=r(Me),ko=d(Me,"P",{"data-svelte-h":!0}),_(ko)!=="svelte-1pmivet"&&(ko.innerHTML=wm),Gr=r(Me),F=d(Me,"DIV",{class:!0});var K=v(F);g(Un.$$.fragment,K),Vr=r(K),Uo=d(K,"P",{"data-svelte-h":!0}),_(Uo)!=="svelte-1plx9t"&&(Uo.innerHTML=vm),Xr=r(K),g(ft.$$.fragment,K),Nr=r(K),g(bt.$$.fragment,K),Sr=r(K),g(Mt.$$.fragment,K),zr=r(K),g(yt.$$.fragment,K),K.forEach(i),Me.forEach(i),Ka=r(e),g(Rn.$$.fragment,e),el=r(e),N=d(e,"DIV",{class:!0});var ye=v(N);g(Zn.$$.fragment,ye),Br=r(ye),Ro=d(ye,"P",{"data-svelte-h":!0}),_(Ro)!=="svelte-1uwjkkt"&&(Ro.textContent=jm),qr=r(ye),Zo=d(ye,"P",{"data-svelte-h":!0}),_(Zo)!=="svelte-nbrge6"&&(Zo.innerHTML=Jm),Or=r(ye),Wo=d(ye,"P",{"data-svelte-h":!0}),_(Wo)!=="svelte-1pmivet"&&(Wo.innerHTML=xm),Er=r(ye),se=d(ye,"DIV",{class:!0});var Te=v(se);g(Wn.$$.fragment,Te),Hr=r(Te),Co=d(Te,"P",{"data-svelte-h":!0}),_(Co)!=="svelte-xk2xch"&&(Co.innerHTML=km),Lr=r(Te),g(Tt.$$.fragment,Te),Qr=r(Te),g(_t.$$.fragment,Te),Yr=r(Te),g($t.$$.fragment,Te),Te.forEach(i),ye.forEach(i),tl=r(e),g(Cn.$$.fragment,e),nl=r(e),S=d(e,"DIV",{class:!0});var _e=v(S);g(Fn.$$.fragment,_e),Pr=r(_e),Fo=d(_e,"P",{"data-svelte-h":!0}),_(Fo)!=="svelte-dcahwi"&&(Fo.textContent=Um),Ar=r(_e),Io=d(_e,"P",{"data-svelte-h":!0}),_(Io)!=="svelte-nbrge6"&&(Io.innerHTML=Rm),Dr=r(_e),Go=d(_e,"P",{"data-svelte-h":!0}),_(Go)!=="svelte-1pmivet"&&(Go.innerHTML=Zm),Kr=r(_e),Be=d(_e,"DIV",{class:!0});var Le=v(Be);g(In.$$.fragment,Le),ei=r(Le),Vo=d(Le,"P",{"data-svelte-h":!0}),_(Vo)!=="svelte-qesv8n"&&(Vo.innerHTML=Wm),ti=r(Le),g(wt.$$.fragment,Le),ni=r(Le),g(vt.$$.fragment,Le),Le.forEach(i),_e.forEach(i),sl=r(e),g(Gn.$$.fragment,e),ol=r(e),z=d(e,"DIV",{class:!0});var $e=v(z);g(Vn.$$.fragment,$e),si=r($e),Xo=d($e,"P",{"data-svelte-h":!0}),_(Xo)!=="svelte-70aqiz"&&(Xo.textContent=Cm),oi=r($e),No=d($e,"P",{"data-svelte-h":!0}),_(No)!=="svelte-nbrge6"&&(No.innerHTML=Fm),ai=r($e),So=d($e,"P",{"data-svelte-h":!0}),_(So)!=="svelte-1pmivet"&&(So.innerHTML=Im),li=r($e),oe=d($e,"DIV",{class:!0});var we=v(oe);g(Xn.$$.fragment,we),ri=r(we),zo=d(we,"P",{"data-svelte-h":!0}),_(zo)!=="svelte-1dng7rw"&&(zo.innerHTML=Gm),ii=r(we),g(jt.$$.fragment,we),pi=r(we),g(Jt.$$.fragment,we),mi=r(we),g(xt.$$.fragment,we),we.forEach(i),$e.forEach(i),al=r(e),g(Nn.$$.fragment,e),ll=r(e),Sn=d(e,"P",{"data-svelte-h":!0}),_(Sn)!=="svelte-1h2y3wu"&&(Sn.textContent=Vm),rl=r(e),g(zn.$$.fragment,e),il=r(e),B=d(e,"DIV",{class:!0});var ve=v(B);g(Bn.$$.fragment,ve),di=r(ve),Bo=d(ve,"P",{"data-svelte-h":!0}),_(Bo)!=="svelte-1726o2j"&&(Bo.textContent=Xm),ci=r(ve),qo=d(ve,"P",{"data-svelte-h":!0}),_(qo)!=="svelte-nbrge6"&&(qo.innerHTML=Nm),ui=r(ve),Oo=d(ve,"P",{"data-svelte-h":!0}),_(Oo)!=="svelte-1pmivet"&&(Oo.innerHTML=Sm),gi=r(ve),ae=d(ve,"DIV",{class:!0});var je=v(ae);g(qn.$$.fragment,je),hi=r(je),Eo=d(je,"P",{"data-svelte-h":!0}),_(Eo)!=="svelte-1azuqx"&&(Eo.innerHTML=zm),fi=r(je),g(kt.$$.fragment,je),bi=r(je),g(Ut.$$.fragment,je),Mi=r(je),g(Rt.$$.fragment,je),je.forEach(i),ve.forEach(i),pl=r(e),g(On.$$.fragment,e),ml=r(e),q=d(e,"DIV",{class:!0});var Je=v(q);g(En.$$.fragment,Je),yi=r(Je),Ho=d(Je,"P",{"data-svelte-h":!0}),_(Ho)!=="svelte-wbsrrf"&&(Ho.textContent=Bm),Ti=r(Je),Lo=d(Je,"P",{"data-svelte-h":!0}),_(Lo)!=="svelte-nbrge6"&&(Lo.innerHTML=qm),_i=r(Je),Qo=d(Je,"P",{"data-svelte-h":!0}),_(Qo)!=="svelte-1pmivet"&&(Qo.innerHTML=Om),$i=r(Je),le=d(Je,"DIV",{class:!0});var xe=v(le);g(Hn.$$.fragment,xe),wi=r(xe),Yo=d(xe,"P",{"data-svelte-h":!0}),_(Yo)!=="svelte-1s27jle"&&(Yo.innerHTML=Em),vi=r(xe),g(Zt.$$.fragment,xe),ji=r(xe),g(Wt.$$.fragment,xe),Ji=r(xe),g(Ct.$$.fragment,xe),xe.forEach(i),Je.forEach(i),dl=r(e),g(Ln.$$.fragment,e),cl=r(e),Qn=d(e,"P",{"data-svelte-h":!0}),_(Qn)!=="svelte-liyjdz"&&(Qn.textContent=Hm),ul=r(e),g(Yn.$$.fragment,e),gl=r(e),O=d(e,"DIV",{class:!0});var ke=v(O);g(Pn.$$.fragment,ke),xi=r(ke),Po=d(ke,"P",{"data-svelte-h":!0}),_(Po)!=="svelte-1uwrr47"&&(Po.textContent=Lm),ki=r(ke),Ao=d(ke,"P",{"data-svelte-h":!0}),_(Ao)!=="svelte-nbrge6"&&(Ao.innerHTML=Qm),Ui=r(ke),Do=d(ke,"P",{"data-svelte-h":!0}),_(Do)!=="svelte-1pmivet"&&(Do.innerHTML=Ym),Ri=r(ke),re=d(ke,"DIV",{class:!0});var Ue=v(re);g(An.$$.fragment,Ue),Zi=r(Ue),Ko=d(Ue,"P",{"data-svelte-h":!0}),_(Ko)!=="svelte-p67kxo"&&(Ko.innerHTML=Pm),Wi=r(Ue),g(Ft.$$.fragment,Ue),Ci=r(Ue),g(It.$$.fragment,Ue),Fi=r(Ue),g(Gt.$$.fragment,Ue),Ue.forEach(i),ke.forEach(i),hl=r(e),g(Dn.$$.fragment,e),fl=r(e),E=d(e,"DIV",{class:!0});var Re=v(E);g(Kn.$$.fragment,Re),Ii=r(Re),ea=d(Re,"P",{"data-svelte-h":!0}),_(ea)!=="svelte-ujzpza"&&(ea.textContent=Am),Gi=r(Re),ta=d(Re,"P",{"data-svelte-h":!0}),_(ta)!=="svelte-nbrge6"&&(ta.innerHTML=Dm),Vi=r(Re),na=d(Re,"P",{"data-svelte-h":!0}),_(na)!=="svelte-1pmivet"&&(na.innerHTML=Km),Xi=r(Re),qe=d(Re,"DIV",{class:!0});var Qe=v(qe);g(es.$$.fragment,Qe),Ni=r(Qe),sa=d(Qe,"P",{"data-svelte-h":!0}),_(sa)!=="svelte-18aced7"&&(sa.innerHTML=ed),Si=r(Qe),g(Vt.$$.fragment,Qe),zi=r(Qe),g(Xt.$$.fragment,Qe),Qe.forEach(i),Re.forEach(i),bl=r(e),g(ts.$$.fragment,e),Ml=r(e),H=d(e,"DIV",{class:!0});var Ze=v(H);g(ns.$$.fragment,Ze),Bi=r(Ze),oa=d(Ze,"P",{"data-svelte-h":!0}),_(oa)!=="svelte-12uzrpk"&&(oa.textContent=td),qi=r(Ze),aa=d(Ze,"P",{"data-svelte-h":!0}),_(aa)!=="svelte-nbrge6"&&(aa.innerHTML=nd),Oi=r(Ze),la=d(Ze,"P",{"data-svelte-h":!0}),_(la)!=="svelte-1pmivet"&&(la.innerHTML=sd),Ei=r(Ze),Oe=d(Ze,"DIV",{class:!0});var Ye=v(Oe);g(ss.$$.fragment,Ye),Hi=r(Ye),ra=d(Ye,"P",{"data-svelte-h":!0}),_(ra)!=="svelte-1szjv6u"&&(ra.innerHTML=od),Li=r(Ye),g(Nt.$$.fragment,Ye),Qi=r(Ye),g(St.$$.fragment,Ye),Ye.forEach(i),Ze.forEach(i),yl=r(e),g(os.$$.fragment,e),Tl=r(e),L=d(e,"DIV",{class:!0});var We=v(L);g(as.$$.fragment,We),Yi=r(We),ia=d(We,"P",{"data-svelte-h":!0}),_(ia)!=="svelte-135bhh9"&&(ia.textContent=ad),Pi=r(We),pa=d(We,"P",{"data-svelte-h":!0}),_(pa)!=="svelte-z8qqoo"&&(pa.innerHTML=ld),Ai=r(We),ma=d(We,"P",{"data-svelte-h":!0}),_(ma)!=="svelte-10uuk2l"&&(ma.innerHTML=rd),Di=r(We),ie=d(We,"DIV",{class:!0});var Ce=v(ie);g(ls.$$.fragment,Ce),Ki=r(Ce),da=d(Ce,"P",{"data-svelte-h":!0}),_(da)!=="svelte-1e3zkhy"&&(da.innerHTML=id),ep=r(Ce),g(zt.$$.fragment,Ce),tp=r(Ce),g(Bt.$$.fragment,Ce),np=r(Ce),g(qt.$$.fragment,Ce),Ce.forEach(i),We.forEach(i),_l=r(e),g(rs.$$.fragment,e),$l=r(e),Q=d(e,"DIV",{class:!0});var Fe=v(Q);g(is.$$.fragment,Fe),sp=r(Fe),ca=d(Fe,"P",{"data-svelte-h":!0}),_(ca)!=="svelte-1yhwrsm"&&(ca.textContent=pd),op=r(Fe),ua=d(Fe,"P",{"data-svelte-h":!0}),_(ua)!=="svelte-nbrge6"&&(ua.innerHTML=md),ap=r(Fe),ga=d(Fe,"P",{"data-svelte-h":!0}),_(ga)!=="svelte-1pmivet"&&(ga.innerHTML=dd),lp=r(Fe),Ee=d(Fe,"DIV",{class:!0});var Pe=v(Ee);g(ps.$$.fragment,Pe),rp=r(Pe),ha=d(Pe,"P",{"data-svelte-h":!0}),_(ha)!=="svelte-1fuxgrl"&&(ha.innerHTML=cd),ip=r(Pe),g(Ot.$$.fragment,Pe),pp=r(Pe),g(Et.$$.fragment,Pe),Pe.forEach(i),Fe.forEach(i),wl=r(e),g(ms.$$.fragment,e),vl=r(e),ds=d(e,"P",{"data-svelte-h":!0}),_(ds)!=="svelte-1gk58z"&&(ds.textContent=ud),jl=r(e),g(cs.$$.fragment,e),Jl=r(e),Y=d(e,"DIV",{class:!0});var Ie=v(Y);g(us.$$.fragment,Ie),mp=r(Ie),fa=d(Ie,"P",{"data-svelte-h":!0}),_(fa)!=="svelte-1yhfevg"&&(fa.textContent=gd),dp=r(Ie),ba=d(Ie,"P",{"data-svelte-h":!0}),_(ba)!=="svelte-z8qqoo"&&(ba.innerHTML=hd),cp=r(Ie),Ma=d(Ie,"P",{"data-svelte-h":!0}),_(Ma)!=="svelte-10uuk2l"&&(Ma.innerHTML=fd),up=r(Ie),pe=d(Ie,"DIV",{class:!0});var Ge=v(pe);g(gs.$$.fragment,Ge),gp=r(Ge),ya=d(Ge,"P",{"data-svelte-h":!0}),_(ya)!=="svelte-11xalzp"&&(ya.innerHTML=bd),hp=r(Ge),g(Ht.$$.fragment,Ge),fp=r(Ge),g(Lt.$$.fragment,Ge),bp=r(Ge),g(Qt.$$.fragment,Ge),Ge.forEach(i),Ie.forEach(i),xl=r(e),g(hs.$$.fragment,e),kl=r(e),P=d(e,"DIV",{class:!0});var Ve=v(P);g(fs.$$.fragment,Ve),Mp=r(Ve),Ta=d(Ve,"P",{"data-svelte-h":!0}),_(Ta)!=="svelte-80a148"&&(Ta.textContent=Md),yp=r(Ve),_a=d(Ve,"P",{"data-svelte-h":!0}),_(_a)!=="svelte-z8qqoo"&&(_a.innerHTML=yd),Tp=r(Ve),$a=d(Ve,"P",{"data-svelte-h":!0}),_($a)!=="svelte-10uuk2l"&&($a.innerHTML=Td),_p=r(Ve),He=d(Ve,"DIV",{class:!0});var Ae=v(He);g(bs.$$.fragment,Ae),$p=r(Ae),wa=d(Ae,"P",{"data-svelte-h":!0}),_(wa)!=="svelte-eywb10"&&(wa.innerHTML=_d),wp=r(Ae),g(Yt.$$.fragment,Ae),vp=r(Ae),g(Pt.$$.fragment,Ae),Ae.forEach(i),Ve.forEach(i),Ul=r(e),g(Ms.$$.fragment,e),Rl=r(e),ys=d(e,"P",{"data-svelte-h":!0}),_(ys)!=="svelte-1n8n3ms"&&(ys.textContent=$d),Zl=r(e),g(Ts.$$.fragment,e),Wl=r(e),A=d(e,"DIV",{class:!0});var Xe=v(A);g(_s.$$.fragment,Xe),jp=r(Xe),va=d(Xe,"P",{"data-svelte-h":!0}),_(va)!=="svelte-5pmyjn"&&(va.textContent=wd),Jp=r(Xe),ja=d(Xe,"P",{"data-svelte-h":!0}),_(ja)!=="svelte-nbrge6"&&(ja.innerHTML=vd),xp=r(Xe),Ja=d(Xe,"P",{"data-svelte-h":!0}),_(Ja)!=="svelte-1pmivet"&&(Ja.innerHTML=jd),kp=r(Xe),me=d(Xe,"DIV",{class:!0});var Ne=v(me);g($s.$$.fragment,Ne),Up=r(Ne),xa=d(Ne,"P",{"data-svelte-h":!0}),_(xa)!=="svelte-1usnw5b"&&(xa.innerHTML=Jd),Rp=r(Ne),g(At.$$.fragment,Ne),Zp=r(Ne),g(Dt.$$.fragment,Ne),Wp=r(Ne),g(Kt.$$.fragment,Ne),Ne.forEach(i),Xe.forEach(i),Cl=r(e),g(ws.$$.fragment,e),Fl=r(e),D=d(e,"DIV",{class:!0});var Se=v(D);g(vs.$$.fragment,Se),Cp=r(Se),ka=d(Se,"P",{"data-svelte-h":!0}),_(ka)!=="svelte-1rhquq6"&&(ka.textContent=xd),Fp=r(Se),Ua=d(Se,"P",{"data-svelte-h":!0}),_(Ua)!=="svelte-nbrge6"&&(Ua.innerHTML=kd),Ip=r(Se),Ra=d(Se,"P",{"data-svelte-h":!0}),_(Ra)!=="svelte-1pmivet"&&(Ra.innerHTML=Ud),Gp=r(Se),de=d(Se,"DIV",{class:!0});var ze=v(de);g(js.$$.fragment,ze),Vp=r(ze),Za=d(ze,"P",{"data-svelte-h":!0}),_(Za)!=="svelte-iqwqsz"&&(Za.innerHTML=Rd),Xp=r(ze),g(en.$$.fragment,ze),Np=r(ze),g(tn.$$.fragment,ze),Sp=r(ze),g(nn.$$.fragment,ze),ze.forEach(i),Se.forEach(i),Il=r(e),g(Js.$$.fragment,e),Gl=r(e),g(xs.$$.fragment,e),Vl=r(e),De=d(e,"DIV",{class:!0});var Ps=v(De);g(ks.$$.fragment,Ps),zp=r(Ps),sn=d(Ps,"DIV",{class:!0});var As=v(sn);g(Us.$$.fragment,As),Bp=r(As),Wa=d(As,"P",{"data-svelte-h":!0}),_(Wa)!=="svelte-1eed40t"&&(Wa.textContent=Zd),As.forEach(i),Ps.forEach(i),Xl=r(e),g(Rs.$$.fragment,e),Nl=r(e),Ke=d(e,"DIV",{class:!0});var Ds=v(Ke);g(Zs.$$.fragment,Ds),qp=r(Ds),on=d(Ds,"DIV",{class:!0});var Ks=v(on);g(Ws.$$.fragment,Ks),Op=r(Ks),Ca=d(Ks,"P",{"data-svelte-h":!0}),_(Ca)!=="svelte-1eed40t"&&(Ca.textContent=Wd),Ks.forEach(i),Ds.forEach(i),Sl=r(e),g(Cs.$$.fragment,e),zl=r(e),et=d(e,"DIV",{class:!0});var eo=v(et);g(Fs.$$.fragment,eo),Ep=r(eo),an=d(eo,"DIV",{class:!0});var to=v(an);g(Is.$$.fragment,to),Hp=r(to),Fa=d(to,"P",{"data-svelte-h":!0}),_(Fa)!=="svelte-1eed40t"&&(Fa.textContent=Cd),to.forEach(i),eo.forEach(i),Bl=r(e),g(Gs.$$.fragment,e),ql=r(e),tt=d(e,"DIV",{class:!0});var no=v(tt);g(Vs.$$.fragment,no),Lp=r(no),ln=d(no,"DIV",{class:!0});var so=v(ln);g(Xs.$$.fragment,so),Qp=r(so),Ia=d(so,"P",{"data-svelte-h":!0}),_(Ia)!=="svelte-1eed40t"&&(Ia.textContent=Fd),so.forEach(i),no.forEach(i),Ol=r(e),g(Ns.$$.fragment,e),El=r(e),nt=d(e,"DIV",{class:!0});var oo=v(nt);g(Ss.$$.fragment,oo),Yp=r(oo),rn=d(oo,"DIV",{class:!0});var ao=v(rn);g(zs.$$.fragment,ao),Pp=r(ao),Ga=d(ao,"P",{"data-svelte-h":!0}),_(Ga)!=="svelte-1eed40t"&&(Ga.textContent=Id),ao.forEach(i),oo.forEach(i),Hl=r(e),g(Bs.$$.fragment,e),Ll=r(e),st=d(e,"DIV",{class:!0});var lo=v(st);g(qs.$$.fragment,lo),Ap=r(lo),pn=d(lo,"DIV",{class:!0});var Dl=v(pn);g(Os.$$.fragment,Dl),Dp=r(Dl),Va=d(Dl,"P",{"data-svelte-h":!0}),_(Va)!=="svelte-1eed40t"&&(Va.textContent=Gd),Dl.forEach(i),lo.forEach(i),Ql=r(e),g(Es.$$.fragment,e),Yl=r(e),ot=d(e,"DIV",{class:!0});var Kl=v(ot);g(Hs.$$.fragment,Kl),Kp=r(Kl),mn=d(Kl,"DIV",{class:!0});var er=v(mn);g(Ls.$$.fragment,er),em=r(er),Xa=d(er,"P",{"data-svelte-h":!0}),_(Xa)!=="svelte-1eed40t"&&(Xa.textContent=Vd),er.forEach(i),Kl.forEach(i),Pl=r(e),Na=d(e,"P",{}),v(Na).forEach(i),this.h()},h(){j(n,"name","hf:doc:metadata"),j(n,"content",Sc),j(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){o(document.head,n),c(e,T,p),c(e,a,p),c(e,s,p),h(y,e,p),c(e,t,p),h($,e,p),c(e,Sa,p),c(e,dn,p),c(e,za,p),h(cn,e,p),c(e,Ba,p),c(e,Z,p),h(un,Z,null),o(Z,tr),o(Z,ro),o(Z,nr),o(Z,io),o(Z,sr),o(Z,po),o(Z,or),o(Z,mo),o(Z,ar),o(Z,at),h(gn,at,null),o(at,lr),o(at,co),o(Z,rr),o(Z,lt),h(hn,lt,null),o(lt,ir),o(lt,uo),c(e,qa,p),h(fn,e,p),c(e,Oa,p),c(e,bn,p),c(e,Ea,p),h(Mn,e,p),c(e,Ha,p),c(e,I,p),h(yn,I,null),o(I,pr),o(I,go),o(I,mr),o(I,ho),o(I,dr),o(I,fo),o(I,cr),o(I,ee),h(Tn,ee,null),o(ee,ur),o(ee,bo),o(ee,gr),h(rt,ee,null),o(ee,hr),h(it,ee,null),o(ee,fr),h(pt,ee,null),c(e,La,p),h(_n,e,p),c(e,Qa,p),c(e,G,p),h($n,G,null),o(G,br),o(G,Mo),o(G,Mr),o(G,yo),o(G,yr),o(G,To),o(G,Tr),o(G,te),h(wn,te,null),o(te,_r),o(te,_o),o(te,$r),h(mt,te,null),o(te,wr),h(dt,te,null),o(te,vr),h(ct,te,null),c(e,Ya,p),h(vn,e,p),c(e,Pa,p),c(e,V,p),h(jn,V,null),o(V,jr),o(V,$o),o(V,Jr),o(V,wo),o(V,xr),o(V,vo),o(V,kr),o(V,ne),h(Jn,ne,null),o(ne,Ur),o(ne,jo),o(ne,Rr),h(ut,ne,null),o(ne,Zr),h(gt,ne,null),o(ne,Wr),h(ht,ne,null),c(e,Aa,p),h(xn,e,p),c(e,Da,p),c(e,X,p),h(kn,X,null),o(X,Cr),o(X,Jo),o(X,Fr),o(X,xo),o(X,Ir),o(X,ko),o(X,Gr),o(X,F),h(Un,F,null),o(F,Vr),o(F,Uo),o(F,Xr),h(ft,F,null),o(F,Nr),h(bt,F,null),o(F,Sr),h(Mt,F,null),o(F,zr),h(yt,F,null),c(e,Ka,p),h(Rn,e,p),c(e,el,p),c(e,N,p),h(Zn,N,null),o(N,Br),o(N,Ro),o(N,qr),o(N,Zo),o(N,Or),o(N,Wo),o(N,Er),o(N,se),h(Wn,se,null),o(se,Hr),o(se,Co),o(se,Lr),h(Tt,se,null),o(se,Qr),h(_t,se,null),o(se,Yr),h($t,se,null),c(e,tl,p),h(Cn,e,p),c(e,nl,p),c(e,S,p),h(Fn,S,null),o(S,Pr),o(S,Fo),o(S,Ar),o(S,Io),o(S,Dr),o(S,Go),o(S,Kr),o(S,Be),h(In,Be,null),o(Be,ei),o(Be,Vo),o(Be,ti),h(wt,Be,null),o(Be,ni),h(vt,Be,null),c(e,sl,p),h(Gn,e,p),c(e,ol,p),c(e,z,p),h(Vn,z,null),o(z,si),o(z,Xo),o(z,oi),o(z,No),o(z,ai),o(z,So),o(z,li),o(z,oe),h(Xn,oe,null),o(oe,ri),o(oe,zo),o(oe,ii),h(jt,oe,null),o(oe,pi),h(Jt,oe,null),o(oe,mi),h(xt,oe,null),c(e,al,p),h(Nn,e,p),c(e,ll,p),c(e,Sn,p),c(e,rl,p),h(zn,e,p),c(e,il,p),c(e,B,p),h(Bn,B,null),o(B,di),o(B,Bo),o(B,ci),o(B,qo),o(B,ui),o(B,Oo),o(B,gi),o(B,ae),h(qn,ae,null),o(ae,hi),o(ae,Eo),o(ae,fi),h(kt,ae,null),o(ae,bi),h(Ut,ae,null),o(ae,Mi),h(Rt,ae,null),c(e,pl,p),h(On,e,p),c(e,ml,p),c(e,q,p),h(En,q,null),o(q,yi),o(q,Ho),o(q,Ti),o(q,Lo),o(q,_i),o(q,Qo),o(q,$i),o(q,le),h(Hn,le,null),o(le,wi),o(le,Yo),o(le,vi),h(Zt,le,null),o(le,ji),h(Wt,le,null),o(le,Ji),h(Ct,le,null),c(e,dl,p),h(Ln,e,p),c(e,cl,p),c(e,Qn,p),c(e,ul,p),h(Yn,e,p),c(e,gl,p),c(e,O,p),h(Pn,O,null),o(O,xi),o(O,Po),o(O,ki),o(O,Ao),o(O,Ui),o(O,Do),o(O,Ri),o(O,re),h(An,re,null),o(re,Zi),o(re,Ko),o(re,Wi),h(Ft,re,null),o(re,Ci),h(It,re,null),o(re,Fi),h(Gt,re,null),c(e,hl,p),h(Dn,e,p),c(e,fl,p),c(e,E,p),h(Kn,E,null),o(E,Ii),o(E,ea),o(E,Gi),o(E,ta),o(E,Vi),o(E,na),o(E,Xi),o(E,qe),h(es,qe,null),o(qe,Ni),o(qe,sa),o(qe,Si),h(Vt,qe,null),o(qe,zi),h(Xt,qe,null),c(e,bl,p),h(ts,e,p),c(e,Ml,p),c(e,H,p),h(ns,H,null),o(H,Bi),o(H,oa),o(H,qi),o(H,aa),o(H,Oi),o(H,la),o(H,Ei),o(H,Oe),h(ss,Oe,null),o(Oe,Hi),o(Oe,ra),o(Oe,Li),h(Nt,Oe,null),o(Oe,Qi),h(St,Oe,null),c(e,yl,p),h(os,e,p),c(e,Tl,p),c(e,L,p),h(as,L,null),o(L,Yi),o(L,ia),o(L,Pi),o(L,pa),o(L,Ai),o(L,ma),o(L,Di),o(L,ie),h(ls,ie,null),o(ie,Ki),o(ie,da),o(ie,ep),h(zt,ie,null),o(ie,tp),h(Bt,ie,null),o(ie,np),h(qt,ie,null),c(e,_l,p),h(rs,e,p),c(e,$l,p),c(e,Q,p),h(is,Q,null),o(Q,sp),o(Q,ca),o(Q,op),o(Q,ua),o(Q,ap),o(Q,ga),o(Q,lp),o(Q,Ee),h(ps,Ee,null),o(Ee,rp),o(Ee,ha),o(Ee,ip),h(Ot,Ee,null),o(Ee,pp),h(Et,Ee,null),c(e,wl,p),h(ms,e,p),c(e,vl,p),c(e,ds,p),c(e,jl,p),h(cs,e,p),c(e,Jl,p),c(e,Y,p),h(us,Y,null),o(Y,mp),o(Y,fa),o(Y,dp),o(Y,ba),o(Y,cp),o(Y,Ma),o(Y,up),o(Y,pe),h(gs,pe,null),o(pe,gp),o(pe,ya),o(pe,hp),h(Ht,pe,null),o(pe,fp),h(Lt,pe,null),o(pe,bp),h(Qt,pe,null),c(e,xl,p),h(hs,e,p),c(e,kl,p),c(e,P,p),h(fs,P,null),o(P,Mp),o(P,Ta),o(P,yp),o(P,_a),o(P,Tp),o(P,$a),o(P,_p),o(P,He),h(bs,He,null),o(He,$p),o(He,wa),o(He,wp),h(Yt,He,null),o(He,vp),h(Pt,He,null),c(e,Ul,p),h(Ms,e,p),c(e,Rl,p),c(e,ys,p),c(e,Zl,p),h(Ts,e,p),c(e,Wl,p),c(e,A,p),h(_s,A,null),o(A,jp),o(A,va),o(A,Jp),o(A,ja),o(A,xp),o(A,Ja),o(A,kp),o(A,me),h($s,me,null),o(me,Up),o(me,xa),o(me,Rp),h(At,me,null),o(me,Zp),h(Dt,me,null),o(me,Wp),h(Kt,me,null),c(e,Cl,p),h(ws,e,p),c(e,Fl,p),c(e,D,p),h(vs,D,null),o(D,Cp),o(D,ka),o(D,Fp),o(D,Ua),o(D,Ip),o(D,Ra),o(D,Gp),o(D,de),h(js,de,null),o(de,Vp),o(de,Za),o(de,Xp),h(en,de,null),o(de,Np),h(tn,de,null),o(de,Sp),h(nn,de,null),c(e,Il,p),h(Js,e,p),c(e,Gl,p),h(xs,e,p),c(e,Vl,p),c(e,De,p),h(ks,De,null),o(De,zp),o(De,sn),h(Us,sn,null),o(sn,Bp),o(sn,Wa),c(e,Xl,p),h(Rs,e,p),c(e,Nl,p),c(e,Ke,p),h(Zs,Ke,null),o(Ke,qp),o(Ke,on),h(Ws,on,null),o(on,Op),o(on,Ca),c(e,Sl,p),h(Cs,e,p),c(e,zl,p),c(e,et,p),h(Fs,et,null),o(et,Ep),o(et,an),h(Is,an,null),o(an,Hp),o(an,Fa),c(e,Bl,p),h(Gs,e,p),c(e,ql,p),c(e,tt,p),h(Vs,tt,null),o(tt,Lp),o(tt,ln),h(Xs,ln,null),o(ln,Qp),o(ln,Ia),c(e,Ol,p),h(Ns,e,p),c(e,El,p),c(e,nt,p),h(Ss,nt,null),o(nt,Yp),o(nt,rn),h(zs,rn,null),o(rn,Pp),o(rn,Ga),c(e,Hl,p),h(Bs,e,p),c(e,Ll,p),c(e,st,p),h(qs,st,null),o(st,Ap),o(st,pn),h(Os,pn,null),o(pn,Dp),o(pn,Va),c(e,Ql,p),h(Es,e,p),c(e,Yl,p),c(e,ot,p),h(Hs,ot,null),o(ot,Kp),o(ot,mn),h(Ls,mn,null),o(mn,em),o(mn,Xa),c(e,Pl,p),c(e,Na,p),Al=!0},p(e,[p]){const C={};p&2&&(C.$$scope={dirty:p,ctx:e}),rt.$set(C);const Qs={};p&2&&(Qs.$$scope={dirty:p,ctx:e}),it.$set(Qs);const Ys={};p&2&&(Ys.$$scope={dirty:p,ctx:e}),pt.$set(Ys);const ce={};p&2&&(ce.$$scope={dirty:p,ctx:e}),mt.$set(ce);const ue={};p&2&&(ue.$$scope={dirty:p,ctx:e}),dt.$set(ue);const ge={};p&2&&(ge.$$scope={dirty:p,ctx:e}),ct.$set(ge);const he={};p&2&&(he.$$scope={dirty:p,ctx:e}),ut.$set(he);const fe={};p&2&&(fe.$$scope={dirty:p,ctx:e}),gt.$set(fe);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),ht.$set(be);const Me={};p&2&&(Me.$$scope={dirty:p,ctx:e}),ft.$set(Me);const K={};p&2&&(K.$$scope={dirty:p,ctx:e}),bt.$set(K);const ye={};p&2&&(ye.$$scope={dirty:p,ctx:e}),Mt.$set(ye);const Te={};p&2&&(Te.$$scope={dirty:p,ctx:e}),yt.$set(Te);const _e={};p&2&&(_e.$$scope={dirty:p,ctx:e}),Tt.$set(_e);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:e}),_t.$set(Le);const $e={};p&2&&($e.$$scope={dirty:p,ctx:e}),$t.$set($e);const we={};p&2&&(we.$$scope={dirty:p,ctx:e}),wt.$set(we);const ve={};p&2&&(ve.$$scope={dirty:p,ctx:e}),vt.$set(ve);const je={};p&2&&(je.$$scope={dirty:p,ctx:e}),jt.$set(je);const Je={};p&2&&(Je.$$scope={dirty:p,ctx:e}),Jt.$set(Je);const xe={};p&2&&(xe.$$scope={dirty:p,ctx:e}),xt.$set(xe);const ke={};p&2&&(ke.$$scope={dirty:p,ctx:e}),kt.$set(ke);const Ue={};p&2&&(Ue.$$scope={dirty:p,ctx:e}),Ut.$set(Ue);const Re={};p&2&&(Re.$$scope={dirty:p,ctx:e}),Rt.$set(Re);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:e}),Zt.$set(Qe);const Ze={};p&2&&(Ze.$$scope={dirty:p,ctx:e}),Wt.$set(Ze);const Ye={};p&2&&(Ye.$$scope={dirty:p,ctx:e}),Ct.$set(Ye);const We={};p&2&&(We.$$scope={dirty:p,ctx:e}),Ft.$set(We);const Ce={};p&2&&(Ce.$$scope={dirty:p,ctx:e}),It.$set(Ce);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:e}),Gt.$set(Fe);const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:e}),Vt.$set(Pe);const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:e}),Xt.$set(Ie);const Ge={};p&2&&(Ge.$$scope={dirty:p,ctx:e}),Nt.$set(Ge);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),St.$set(Ve);const Ae={};p&2&&(Ae.$$scope={dirty:p,ctx:e}),zt.$set(Ae);const Xe={};p&2&&(Xe.$$scope={dirty:p,ctx:e}),Bt.$set(Xe);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),qt.$set(Ne);const Se={};p&2&&(Se.$$scope={dirty:p,ctx:e}),Ot.$set(Se);const ze={};p&2&&(ze.$$scope={dirty:p,ctx:e}),Et.$set(ze);const Ps={};p&2&&(Ps.$$scope={dirty:p,ctx:e}),Ht.$set(Ps);const As={};p&2&&(As.$$scope={dirty:p,ctx:e}),Lt.$set(As);const Ds={};p&2&&(Ds.$$scope={dirty:p,ctx:e}),Qt.$set(Ds);const Ks={};p&2&&(Ks.$$scope={dirty:p,ctx:e}),Yt.$set(Ks);const eo={};p&2&&(eo.$$scope={dirty:p,ctx:e}),Pt.$set(eo);const to={};p&2&&(to.$$scope={dirty:p,ctx:e}),At.$set(to);const no={};p&2&&(no.$$scope={dirty:p,ctx:e}),Dt.$set(no);const so={};p&2&&(so.$$scope={dirty:p,ctx:e}),Kt.$set(so);const oo={};p&2&&(oo.$$scope={dirty:p,ctx:e}),en.$set(oo);const ao={};p&2&&(ao.$$scope={dirty:p,ctx:e}),tn.$set(ao);const lo={};p&2&&(lo.$$scope={dirty:p,ctx:e}),nn.$set(lo)},i(e){Al||(f(y.$$.fragment,e),f($.$$.fragment,e),f(cn.$$.fragment,e),f(un.$$.fragment,e),f(gn.$$.fragment,e),f(hn.$$.fragment,e),f(fn.$$.fragment,e),f(Mn.$$.fragment,e),f(yn.$$.fragment,e),f(Tn.$$.fragment,e),f(rt.$$.fragment,e),f(it.$$.fragment,e),f(pt.$$.fragment,e),f(_n.$$.fragment,e),f($n.$$.fragment,e),f(wn.$$.fragment,e),f(mt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(vn.$$.fragment,e),f(jn.$$.fragment,e),f(Jn.$$.fragment,e),f(ut.$$.fragment,e),f(gt.$$.fragment,e),f(ht.$$.fragment,e),f(xn.$$.fragment,e),f(kn.$$.fragment,e),f(Un.$$.fragment,e),f(ft.$$.fragment,e),f(bt.$$.fragment,e),f(Mt.$$.fragment,e),f(yt.$$.fragment,e),f(Rn.$$.fragment,e),f(Zn.$$.fragment,e),f(Wn.$$.fragment,e),f(Tt.$$.fragment,e),f(_t.$$.fragment,e),f($t.$$.fragment,e),f(Cn.$$.fragment,e),f(Fn.$$.fragment,e),f(In.$$.fragment,e),f(wt.$$.fragment,e),f(vt.$$.fragment,e),f(Gn.$$.fragment,e),f(Vn.$$.fragment,e),f(Xn.$$.fragment,e),f(jt.$$.fragment,e),f(Jt.$$.fragment,e),f(xt.$$.fragment,e),f(Nn.$$.fragment,e),f(zn.$$.fragment,e),f(Bn.$$.fragment,e),f(qn.$$.fragment,e),f(kt.$$.fragment,e),f(Ut.$$.fragment,e),f(Rt.$$.fragment,e),f(On.$$.fragment,e),f(En.$$.fragment,e),f(Hn.$$.fragment,e),f(Zt.$$.fragment,e),f(Wt.$$.fragment,e),f(Ct.$$.fragment,e),f(Ln.$$.fragment,e),f(Yn.$$.fragment,e),f(Pn.$$.fragment,e),f(An.$$.fragment,e),f(Ft.$$.fragment,e),f(It.$$.fragment,e),f(Gt.$$.fragment,e),f(Dn.$$.fragment,e),f(Kn.$$.fragment,e),f(es.$$.fragment,e),f(Vt.$$.fragment,e),f(Xt.$$.fragment,e),f(ts.$$.fragment,e),f(ns.$$.fragment,e),f(ss.$$.fragment,e),f(Nt.$$.fragment,e),f(St.$$.fragment,e),f(os.$$.fragment,e),f(as.$$.fragment,e),f(ls.$$.fragment,e),f(zt.$$.fragment,e),f(Bt.$$.fragment,e),f(qt.$$.fragment,e),f(rs.$$.fragment,e),f(is.$$.fragment,e),f(ps.$$.fragment,e),f(Ot.$$.fragment,e),f(Et.$$.fragment,e),f(ms.$$.fragment,e),f(cs.$$.fragment,e),f(us.$$.fragment,e),f(gs.$$.fragment,e),f(Ht.$$.fragment,e),f(Lt.$$.fragment,e),f(Qt.$$.fragment,e),f(hs.$$.fragment,e),f(fs.$$.fragment,e),f(bs.$$.fragment,e),f(Yt.$$.fragment,e),f(Pt.$$.fragment,e),f(Ms.$$.fragment,e),f(Ts.$$.fragment,e),f(_s.$$.fragment,e),f($s.$$.fragment,e),f(At.$$.fragment,e),f(Dt.$$.fragment,e),f(Kt.$$.fragment,e),f(ws.$$.fragment,e),f(vs.$$.fragment,e),f(js.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(Js.$$.fragment,e),f(xs.$$.fragment,e),f(ks.$$.fragment,e),f(Us.$$.fragment,e),f(Rs.$$.fragment,e),f(Zs.$$.fragment,e),f(Ws.$$.fragment,e),f(Cs.$$.fragment,e),f(Fs.$$.fragment,e),f(Is.$$.fragment,e),f(Gs.$$.fragment,e),f(Vs.$$.fragment,e),f(Xs.$$.fragment,e),f(Ns.$$.fragment,e),f(Ss.$$.fragment,e),f(zs.$$.fragment,e),f(Bs.$$.fragment,e),f(qs.$$.fragment,e),f(Os.$$.fragment,e),f(Es.$$.fragment,e),f(Hs.$$.fragment,e),f(Ls.$$.fragment,e),Al=!0)},o(e){b(y.$$.fragment,e),b($.$$.fragment,e),b(cn.$$.fragment,e),b(un.$$.fragment,e),b(gn.$$.fragment,e),b(hn.$$.fragment,e),b(fn.$$.fragment,e),b(Mn.$$.fragment,e),b(yn.$$.fragment,e),b(Tn.$$.fragment,e),b(rt.$$.fragment,e),b(it.$$.fragment,e),b(pt.$$.fragment,e),b(_n.$$.fragment,e),b($n.$$.fragment,e),b(wn.$$.fragment,e),b(mt.$$.fragment,e),b(dt.$$.fragment,e),b(ct.$$.fragment,e),b(vn.$$.fragment,e),b(jn.$$.fragment,e),b(Jn.$$.fragment,e),b(ut.$$.fragment,e),b(gt.$$.fragment,e),b(ht.$$.fragment,e),b(xn.$$.fragment,e),b(kn.$$.fragment,e),b(Un.$$.fragment,e),b(ft.$$.fragment,e),b(bt.$$.fragment,e),b(Mt.$$.fragment,e),b(yt.$$.fragment,e),b(Rn.$$.fragment,e),b(Zn.$$.fragment,e),b(Wn.$$.fragment,e),b(Tt.$$.fragment,e),b(_t.$$.fragment,e),b($t.$$.fragment,e),b(Cn.$$.fragment,e),b(Fn.$$.fragment,e),b(In.$$.fragment,e),b(wt.$$.fragment,e),b(vt.$$.fragment,e),b(Gn.$$.fragment,e),b(Vn.$$.fragment,e),b(Xn.$$.fragment,e),b(jt.$$.fragment,e),b(Jt.$$.fragment,e),b(xt.$$.fragment,e),b(Nn.$$.fragment,e),b(zn.$$.fragment,e),b(Bn.$$.fragment,e),b(qn.$$.fragment,e),b(kt.$$.fragment,e),b(Ut.$$.fragment,e),b(Rt.$$.fragment,e),b(On.$$.fragment,e),b(En.$$.fragment,e),b(Hn.$$.fragment,e),b(Zt.$$.fragment,e),b(Wt.$$.fragment,e),b(Ct.$$.fragment,e),b(Ln.$$.fragment,e),b(Yn.$$.fragment,e),b(Pn.$$.fragment,e),b(An.$$.fragment,e),b(Ft.$$.fragment,e),b(It.$$.fragment,e),b(Gt.$$.fragment,e),b(Dn.$$.fragment,e),b(Kn.$$.fragment,e),b(es.$$.fragment,e),b(Vt.$$.fragment,e),b(Xt.$$.fragment,e),b(ts.$$.fragment,e),b(ns.$$.fragment,e),b(ss.$$.fragment,e),b(Nt.$$.fragment,e),b(St.$$.fragment,e),b(os.$$.fragment,e),b(as.$$.fragment,e),b(ls.$$.fragment,e),b(zt.$$.fragment,e),b(Bt.$$.fragment,e),b(qt.$$.fragment,e),b(rs.$$.fragment,e),b(is.$$.fragment,e),b(ps.$$.fragment,e),b(Ot.$$.fragment,e),b(Et.$$.fragment,e),b(ms.$$.fragment,e),b(cs.$$.fragment,e),b(us.$$.fragment,e),b(gs.$$.fragment,e),b(Ht.$$.fragment,e),b(Lt.$$.fragment,e),b(Qt.$$.fragment,e),b(hs.$$.fragment,e),b(fs.$$.fragment,e),b(bs.$$.fragment,e),b(Yt.$$.fragment,e),b(Pt.$$.fragment,e),b(Ms.$$.fragment,e),b(Ts.$$.fragment,e),b(_s.$$.fragment,e),b($s.$$.fragment,e),b(At.$$.fragment,e),b(Dt.$$.fragment,e),b(Kt.$$.fragment,e),b(ws.$$.fragment,e),b(vs.$$.fragment,e),b(js.$$.fragment,e),b(en.$$.fragment,e),b(tn.$$.fragment,e),b(nn.$$.fragment,e),b(Js.$$.fragment,e),b(xs.$$.fragment,e),b(ks.$$.fragment,e),b(Us.$$.fragment,e),b(Rs.$$.fragment,e),b(Zs.$$.fragment,e),b(Ws.$$.fragment,e),b(Cs.$$.fragment,e),b(Fs.$$.fragment,e),b(Is.$$.fragment,e),b(Gs.$$.fragment,e),b(Vs.$$.fragment,e),b(Xs.$$.fragment,e),b(Ns.$$.fragment,e),b(Ss.$$.fragment,e),b(zs.$$.fragment,e),b(Bs.$$.fragment,e),b(qs.$$.fragment,e),b(Os.$$.fragment,e),b(Es.$$.fragment,e),b(Hs.$$.fragment,e),b(Ls.$$.fragment,e),Al=!1},d(e){e&&(i(T),i(a),i(s),i(t),i(Sa),i(dn),i(za),i(Ba),i(Z),i(qa),i(Oa),i(bn),i(Ea),i(Ha),i(I),i(La),i(Qa),i(G),i(Ya),i(Pa),i(V),i(Aa),i(Da),i(X),i(Ka),i(el),i(N),i(tl),i(nl),i(S),i(sl),i(ol),i(z),i(al),i(ll),i(Sn),i(rl),i(il),i(B),i(pl),i(ml),i(q),i(dl),i(cl),i(Qn),i(ul),i(gl),i(O),i(hl),i(fl),i(E),i(bl),i(Ml),i(H),i(yl),i(Tl),i(L),i(_l),i($l),i(Q),i(wl),i(vl),i(ds),i(jl),i(Jl),i(Y),i(xl),i(kl),i(P),i(Ul),i(Rl),i(ys),i(Zl),i(Wl),i(A),i(Cl),i(Fl),i(D),i(Il),i(Gl),i(Vl),i(De),i(Xl),i(Nl),i(Ke),i(Sl),i(zl),i(et),i(Bl),i(ql),i(tt),i(Ol),i(El),i(nt),i(Hl),i(Ll),i(st),i(Ql),i(Yl),i(ot),i(Pl),i(Na)),i(n),M(y,e),M($,e),M(cn,e),M(un),M(gn),M(hn),M(fn,e),M(Mn,e),M(yn),M(Tn),M(rt),M(it),M(pt),M(_n,e),M($n),M(wn),M(mt),M(dt),M(ct),M(vn,e),M(jn),M(Jn),M(ut),M(gt),M(ht),M(xn,e),M(kn),M(Un),M(ft),M(bt),M(Mt),M(yt),M(Rn,e),M(Zn),M(Wn),M(Tt),M(_t),M($t),M(Cn,e),M(Fn),M(In),M(wt),M(vt),M(Gn,e),M(Vn),M(Xn),M(jt),M(Jt),M(xt),M(Nn,e),M(zn,e),M(Bn),M(qn),M(kt),M(Ut),M(Rt),M(On,e),M(En),M(Hn),M(Zt),M(Wt),M(Ct),M(Ln,e),M(Yn,e),M(Pn),M(An),M(Ft),M(It),M(Gt),M(Dn,e),M(Kn),M(es),M(Vt),M(Xt),M(ts,e),M(ns),M(ss),M(Nt),M(St),M(os,e),M(as),M(ls),M(zt),M(Bt),M(qt),M(rs,e),M(is),M(ps),M(Ot),M(Et),M(ms,e),M(cs,e),M(us),M(gs),M(Ht),M(Lt),M(Qt),M(hs,e),M(fs),M(bs),M(Yt),M(Pt),M(Ms,e),M(Ts,e),M(_s),M($s),M(At),M(Dt),M(Kt),M(ws,e),M(vs),M(js),M(en),M(tn),M(nn),M(Js,e),M(xs,e),M(ks),M(Us),M(Rs,e),M(Zs),M(Ws),M(Cs,e),M(Fs),M(Is),M(Gs,e),M(Vs),M(Xs),M(Ns,e),M(Ss),M(zs),M(Bs,e),M(qs),M(Os),M(Es,e),M(Hs),M(Ls)}}}const Sc='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"ORTDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function zc(w){return Nd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yc extends Sd{constructor(n){super(),zd(this,n,zc,Nc,Xd,{})}}export{Yc as component};
