import{s as cn,o as un,n as dn}from"../chunks/scheduler.7da89386.js";import{S as Mn,i as hn,g as i,s as n,r,A as Tn,h as o,f as s,c as a,j as rn,u as m,x as p,k as mn,y as yn,a as l,v as c,d as u,t as d,w as M}from"../chunks/index.20910acc.js";import{T as Jn}from"../chunks/Tip.53e22153.js";import{C as h}from"../chunks/CodeBlock.143bd81e.js";import{H as y}from"../chunks/getInferenceSnippets.be5a64ab.js";function gn(ct){let T,w="Due to a limitation of ONNX Runtime, it is not possible to run quantized models on <code>CUDAExecutionProvider</code> and only models with static quantization can be run on <code>TensorrtExecutionProvider</code>.";return{c(){T=i("p"),T.innerHTML=w},l(J){T=o(J,"P",{"data-svelte-h":!0}),p(T)!=="svelte-3znnw0"&&(T.innerHTML=w)},m(J,rt){l(J,T,rt)},p:dn,d(J){J&&s(T)}}}function wn(ct){let T,w,J,rt,U,ut,b,sl="By default, ONNX Runtime runs inference on CPU devices. However, it is possible to place supported operations on an NVIDIA GPU, while leaving any unsupported ones on CPU. In most cases, this allows costly operations to be placed on GPU and significantly accelerate inference.",dt,f,ll="This guide will show you how to run inference on two execution providers that ONNX Runtime supports for NVIDIA GPUs:",Mt,j,nl='<li><code>CUDAExecutionProvider</code>: Generic acceleration on NVIDIA CUDA-enabled GPUs.</li> <li><code>TensorrtExecutionProvider</code>: Uses NVIDIA’s <a href="https://developer.nvidia.com/tensorrt" rel="nofollow">TensorRT</a> inference engine and generally provides the best runtime performance.</li>',ht,g,Tt,v,yt,C,Jt,x,al='Provided the CUDA and cuDNN <a href="https://onnxruntime.ai/docs/execution-providers/CUDA-ExecutionProvider.html#requirements" rel="nofollow">requirements</a> are satisfied, install the additional dependencies by running',gt,N,wt,I,il="To avoid conflicts between <code>onnxruntime</code> and <code>onnxruntime-gpu</code>, make sure the package <code>onnxruntime</code> is not installed by running <code>pip uninstall onnxruntime</code> prior to installing Optimum.",Ut,R,bt,Z,ol="Before going further, run the following sample code to check whether the install was successful:",ft,E,jt,V,pl="In case this code runs gracefully, congratulations, the installation is successful! If you encounter the following error or similar,",vt,G,Ct,B,rl="then something is wrong with the CUDA or ONNX Runtime installation.",xt,$,Nt,_,ml="For non-quantized models, the use is straightforward. Simply specify the <code>provider</code> argument in the <code>ORTModel.from_pretrained()</code> method. Here’s an example:",It,W,Rt,X,cl=`The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.
When using Transformers pipeline, note that the <code>device</code> argument should be set to perform pre- and post-processing on GPU, following the example below:`,Zt,k,Et,z,ul="Additionally, you can pass the session option <code>log_severity_level = 0</code> (verbose), to check whether all nodes are indeed placed on the CUDA execution provider or not:",Vt,Q,Gt,S,dl="You should see the following logs:",Bt,L,$t,F,Ml="In this example, we can see that all the costly MatMul operations are placed on the CUDA execution provider.",_t,q,Wt,H,hl="Due to current limitations in ONNX Runtime, it is not possible to use quantized models with <code>CUDAExecutionProvider</code>. The reasons are as follows:",Xt,A,Tl='<li><p>When using <a href="quantization#dynamic-quantization-example">🤗 Optimum dynamic quantization</a>, nodes as <a href="https://github.com/onnx/onnx/blob/v1.12.0/docs/Operators.md#MatMulInteger" rel="nofollow"><code>MatMulInteger</code></a>, <a href="https://github.com/onnx/onnx/blob/v1.12.0/docs/Operators.md#DynamicQuantizeLinear" rel="nofollow"><code>DynamicQuantizeLinear</code></a> may be inserted in the ONNX graph, that cannot be consumed by the CUDA execution provider.</p></li> <li><p>When using <a href="quantization#static-quantization-example">static quantization</a>, the ONNX computation graph will contain matrix multiplications and convolutions in floating-point arithmetic, along with Quantize + Dequantize operations to simulate quantization. In this case, although the costly matrix multiplications and convolutions will be run on the GPU, they will use floating-point arithmetic as the <code>CUDAExecutionProvider</code> can not consume the Quantize + Dequantize nodes to replace them by the operations using integer arithmetic.</p></li>',kt,P,zt,D,yl='<a href="https://onnxruntime.ai/docs/api/python/api_summary.html#iobinding" rel="nofollow">IOBinding</a> is an efficient way to avoid expensive data copying when using GPUs. By default, ONNX Runtime will copy the input from the CPU (even if the tensors are already copied to the targeted device), and assume that outputs also need to be copied back to the CPU from GPUs after the run. These data copying overheads between the host and devices are expensive, and <strong>can lead to worse inference latency than vanilla PyTorch</strong> especially for the decoding process.',Qt,Y,Jl="To avoid the slowdown, 🤗 Optimum adopts the IOBinding to copy inputs onto GPUs and pre-allocate memory for outputs prior the inference.  When instanciating the <code>ORTModel</code>, set the value of the argument <code>use_io_binding</code> to choose whether to turn on the IOBinding during the inference. <code>use_io_binding</code> is set to <code>True</code> by default, if you choose CUDA as execution provider.",St,O,gl="And if you want to turn off IOBinding:",Lt,K,Ft,ee,wl="For the time being, IOBinding is supported for task-defined ORT models, if you want us to add support for custom models, file us an issue on the Optimum’s repository.",qt,te,Ht,se,Ul="We tested three common models with a decoding process: <code>GPT2</code> / <code>T5-small</code> / <code>M2M100-418M</code>, and the benchmark was run on a versatile Tesla T4 GPU (more environment details at the end of this section).",At,le,bl="Here are some performance results running with <code>CUDAExecutionProvider</code> when IOBinding has been turned on. We have tested input sequence length from 8 to 512, and generated outputs both with greedy search and beam search (<code>num_beam=5</code>):",Pt,ne,fl='<tbody><tr><td><p align="center"><img alt="GPT2" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/t4_res_ort_gpt2.png" width="450"/> <br/> <em style="color: grey">GPT2</em></p></td> <td><p align="center"><img alt="T5-small" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/t4_res_ort_t5_s.png" width="450"/> <br/> <em style="color: grey">T5-small</em></p></td></tr> <tr><td><p align="center"><img alt="M2M100-418M" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/t4_res_ort_m2m100_418m.png" width="450"/> <br/> <em style="color: grey">M2M100-418M</em></p></td></tr></tbody>',Dt,ae,jl="And here is a summary for the saving time with different sequence lengths (32 / 128) and generation modes(greedy search / beam search) while using ONNX Runtime compared with PyTorch:",Yt,ie,vl='<tbody><tr><td><p align="center"><img alt="seq32" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/inference_models_32.png" width="800"/> <br/> <em style="color: grey">sequence length: 32</em></p></td></tr> <tr><td><p align="center"><img alt="seq128" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/inference_models_128.png" width="800"/> <br/> <em style="color: grey">sequence length: 128</em></p></td></tr></tbody>',Ot,oe,Cl="Environment:",Kt,pe,es,re,xl="Note that previous experiments are run with <strong>vanilla ONNX</strong> models exported directly from the exporter. If you are interested in <strong>further acceleration</strong>, with <code>ORTOptimizer</code> you can optimize the graph and convert your model to FP16 if you have a GPU with mixed precision capabilities.",ts,me,ss,ce,Nl='TensorRT uses its own set of optimizations, and <strong>generally does not support the optimizations from <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a></strong>. We therefore recommend to use the original ONNX models when using TensorrtExecutionProvider (<a href="https://github.com/microsoft/onnxruntime/issues/10905#issuecomment-1072649358" rel="nofollow">reference</a>).',ls,ue,ns,de,Il="The easiest way to use TensorRT as the execution provider for models optimized through 🤗 Optimum is with the available ONNX Runtime <code>TensorrtExecutionProvider</code>.",as,Me,Rl="In order to use 🤗 Optimum with TensorRT in a local environment, we recommend following the NVIDIA installation guides:",is,he,Zl='<li>CUDA toolkit: <a href="https://docs.nvidia.com/cuda/cuda-installation-guide-linux/index.html" rel="nofollow">https://docs.nvidia.com/cuda/cuda-installation-guide-linux/index.html</a></li> <li>cuDNN: <a href="https://docs.nvidia.com/deeplearning/cudnn/install-guide/index.html" rel="nofollow">https://docs.nvidia.com/deeplearning/cudnn/install-guide/index.html</a></li> <li>TensorRT: <a href="https://docs.nvidia.com/deeplearning/tensorrt/install-guide/index.html" rel="nofollow">https://docs.nvidia.com/deeplearning/tensorrt/install-guide/index.html</a></li>',os,Te,El='For TensorRT, we recommend the Tar File Installation method. Alternatively, TensorRT may be installable with <code>pip</code> by following <a href="https://github.com/microsoft/onnxruntime/issues/9986" rel="nofollow">these instructions</a>.',ps,ye,Vl="Once the required packages are installed, the following environment variables need to be set with the appropriate paths for ONNX Runtime to detect TensorRT installation:",rs,Je,ms,ge,cs,we,Gl="Before going further, run the following sample code to check whether the install was successful:",us,Ue,ds,be,Bl="In case this code runs gracefully, congratulations, the installation is successful!",Ms,fe,$l="In case the above <code>assert</code> fails, or you encounter the following warning",hs,je,Ts,ve,_l="something is wrong with the TensorRT or ONNX Runtime installation.",ys,Ce,Js,xe,Wl='TensorRT requires to build its <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#build-phase" rel="nofollow">inference engine</a> ahead of inference, which takes some time due to the model optimization and nodes fusion. To avoid rebuilding the engine every time the model is loaded, ONNX Runtime provides a pair of options to save the engine: <code>trt_engine_cache_enable</code> and <code>trt_engine_cache_path</code>.',gs,Ne,Xl='We recommend setting these two provider options when using the TensorRT execution provider. The usage is as follows, where <a href="https://huggingface.co/optimum/gpt2" rel="nofollow"><code>optimum/gpt2</code></a> is an ONNX model converted from PyTorch using the <a href="https://huggingface.co/docs/optimum/main/en/exporters/onnx/usage_guides/export_a_model" rel="nofollow">Optimum ONNX exporter</a>:',ws,Ie,Us,Re,kl="TensorRT builds its engine depending on specified input shapes. One big issue is that building the engine can be time consuming, especially for large models. Therefore, as a workaround, one recommendation is to build the TensorRT engine with dynamic shapes. This allows to avoid rebuilding the engine for new small and large shapes, which is unwanted once the model is deployed for inference.",bs,Ze,zl="To do so we use the provider’s options <code>trt_profile_min_shapes</code>, <code>trt_profile_max_shapes</code> and <code>trt_profile_opt_shapes</code> to specify the minimum, maximum and optimal shapes for the engine. For example, for GPT2, we can use the following shapes:",fs,Ee,js,Ve,Ql="Passing the engine cache path in the provider options, the engine can therefore be built once for all and used fully for inference thereafter.",vs,Ge,Sl="For example, for text generation, the engine can be built with:",Cs,Be,xs,$e,Ll="The engine is stored as:",Ns,_e,Fl='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/tensorrt_cache.png" alt="TensorRT engine cache folder"/>',Is,We,ql="Once the engine is built, the cache can be reloaded and generation does not need to rebuild the engine:",Rs,Xe,Zs,ke,Es,ze,Hl='Once the engine is built, it is recommended to do before inference <strong>one or a few warmup steps</strong>, as the first inference runs have <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#trtexec-flags" rel="nofollow">some overhead</a>.',Vs,Qe,Gs,Se,Al="For non-quantized models, the use is straightforward, by simply using the <code>provider</code> argument in <code>ORTModel.from_pretrained()</code>. For example:",Bs,Le,$s,Fe,Pl='<a href="#use-cuda-execution-provider-with-floatingpoint-models">As previously for <code>CUDAExecutionProvider</code></a>, by passing the session option <code>log_severity_level = 0</code> (verbose), we can check in the logs whether all nodes are indeed placed on the TensorRT execution provider or not:',_s,qe,Ws,He,Dl='The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.',Xs,Ae,ks,Pe,Yl='When it comes to quantized models, TensorRT only supports models that use <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#enable_int8_c" rel="nofollow"><strong>static</strong> quantization</a> with <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#intro-quantization" rel="nofollow"><strong>symmetric quantization</strong> for weights and activations</a>.',zs,De,Ol='🤗 Optimum provides a quantization config ready to be used with <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> with the constraints of TensorRT quantization:',Qs,Ye,Ss,Oe,Kl='Using this <code>qconfig</code>, static quantization can be performed as explained in the <a href="quantization#static-quantization-example">static quantization guide</a>.',Ls,Ke,en='In the code sample below, after performing static quantization, the resulting model is loaded into the <a href="/docs/optimum/pr_9/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a> class using TensorRT as the execution provider. ONNX Runtime graph optimization needs to be disabled for the model to be consumed and optimized by TensorRT, and the fact that INT8 operations are used needs to be specified to TensorRT.',Fs,et,qs,tt,tn='The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.',Hs,st,As,lt,sn="As highlighted in the previous section, TensorRT supports only a limited range of quantized models:",Ps,nt,ln="<li>Static quantization only</li> <li>Weights and activations quantization ranges are symmetric</li> <li>Weights need to be stored in float32 in the ONNX model, thus there is no storage space saving from quantization. TensorRT indeed requires to insert full Quantize + Dequantize pairs. Normally, weights would be stored in fixed point 8-bits format and only a <code>DequantizeLinear</code> would be applied on the weights.</li>",Ds,at,nn="In case <code>provider=&quot;TensorrtExecutionProvider&quot;</code> is passed and the model has not been quantized strictly following these constraints, various errors may be raised, where error messages can be unclear.",Ys,it,Os,ot,an="Nvidia Nsight Systems tool can be used to profile the execution time on GPU. Before profiling or measuring latency/throughput, it is a good practice to do a few <strong>warmup steps</strong>.",Ks,pt,on="Coming soon!",el,mt,tl;return U=new y({props:{title:"Accelerated inference on NVIDIA GPUs",local:"accelerated-inference-on-nvidia-gpus",headingTag:"h1"}}),g=new Jn({props:{warning:!0,$$slots:{default:[gn]},$$scope:{ctx:ct}}}),v=new y({props:{title:"CUDAExecutionProvider",local:"cudaexecutionprovider",headingTag:"h2"}}),C=new y({props:{title:"CUDA installation",local:"cuda-installation",headingTag:"h3"}}),N=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0lNUJvbm54cnVudGltZS1ncHUlNUQ=",highlighted:"pip install optimum[onnxruntime-gpu]",wrap:!1}}),R=new y({props:{title:"Checking the CUDA installation is successful",local:"checking-the-cuda-installation-is-successful",headingTag:"h3"}}),E=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiUyQyUwQSUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMEElMjAlMjBwcm92aWRlciUzRCUyMkNVREFFeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJwaGlsc2NobWlkJTJGdGlueS1iZXJ0LXNzdDItZGlzdGlsbGVkJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJleHBlY3RhdGlvbnMlMjB3ZXJlJTIwbG93JTJDJTIwYWN0dWFsJTIwZW5qb3ltZW50JTIwd2FzJTIwaGlnaCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFvdXRwdXRzJTIwJTNEJTIwb3J0X21vZGVsKCoqaW5wdXRzKSUwQWFzc2VydCUyMG9ydF9tb2RlbC5wcm92aWRlcnMlMjAlM0QlM0QlMjAlNUIlMjJDVURBRXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMjAlMjJDUFVFeGVjdXRpb25Qcm92aWRlciUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>,
<span class="hljs-meta">... </span>  export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;expectations were low, actual enjoyment was high&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = ort_model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> ort_model.providers == [<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CPUExecutionProvider&quot;</span>]`,wrap:!1}}),G=new h({props:{code:"VmFsdWVFcnJvciUzQSUyMEFza2VkJTIwdG8lMjB1c2UlMjBDVURBRXhlY3V0aW9uUHJvdmlkZXIlMjBhcyUyMGFuJTIwT05OWCUyMFJ1bnRpbWUlMjBleGVjdXRpb24lMjBwcm92aWRlciUyQyUyMGJ1dCUyMHRoZSUyMGF2YWlsYWJsZSUyMGV4ZWN1dGlvbiUyMHByb3ZpZGVycyUyMGFyZSUyMCU1QidDUFVFeGVjdXRpb25Qcm92aWRlciclNUQu",highlighted:'ValueError: Asked <span class="hljs-built_in">to</span> use CUDAExecutionProvider <span class="hljs-keyword">as</span> <span class="hljs-keyword">an</span> ONNX Runtime execution provider, but <span class="hljs-keyword">the</span> available execution providers are [<span class="hljs-string">&#x27;CPUExecutionProvider&#x27;</span>].',wrap:!1}}),$=new y({props:{title:"Use CUDA execution provider with floating-point models",local:"use-cuda-execution-provider-with-floating-point-models",headingTag:"h3"}}),W=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMHByb3ZpZGVyJTNEJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>  export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),k=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ucGlwZWxpbmVzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEb3J0X21vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUzQTAlMjIpJTBBcmVzdWx0JTIwJTNEJTIwcGlwZSglMjJCb3RoJTIwdGhlJTIwbXVzaWMlMjBhbmQlMjB2aXN1YWwlMjB3ZXJlJTIwYXN0b3VuZGluZyUyQyUyMG5vdCUyMHRvJTIwbWVudGlvbiUyMHRoZSUyMGFjdG9ycyUyMHBlcmZvcm1hbmNlLiUyMiklMEFwcmludChyZXN1bHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;text-classification&quot;</span>, model=ort_model, tokenizer=tokenizer, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = pipe(<span class="hljs-string">&quot;Both the music and visual were astounding, not to mention the actors performance.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)
<span class="hljs-comment"># printing: [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9997727274894714}]</span>`,wrap:!1}}),Q=new h({props:{code:"aW1wb3J0JTIwb25ueHJ1bnRpbWUlMEElMEFzZXNzaW9uX29wdGlvbnMlMjAlM0QlMjBvbm54cnVudGltZS5TZXNzaW9uT3B0aW9ucygpJTBBc2Vzc2lvbl9vcHRpb25zLmxvZ19zZXZlcml0eV9sZXZlbCUyMCUzRCUyMDAlMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2Vzc2lvbl9vcHRpb25zJTNEc2Vzc2lvbl9vcHRpb25zJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnxruntime

<span class="hljs-meta">&gt;&gt;&gt; </span>session_options = onnxruntime.SessionOptions()
<span class="hljs-meta">&gt;&gt;&gt; </span>session_options.log_severity_level = <span class="hljs-number">0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    session_options=session_options
<span class="hljs-meta">... </span>)`,wrap:!1}}),L=new h({props:{code:"MjAyMi0xMC0xOCUyMDE0JTNBNTklM0ExMy43Mjg4ODYwNDElMjAlNUJWJTNBb25ueHJ1bnRpbWUlM0ElMkMlMjBzZXNzaW9uX3N0YXRlLmNjJTNBMTE5MyUyMFZlcmlmeUVhY2hOJTBBb2RlSXNBc3NpZ25lZFRvQW5FcCU1RCUyMCUyMFByb3ZpZGVyJTNBJTIwJTVCQ1BVRXhlY3V0aW9uUHJvdmlkZXIlNUQlM0ElMjAlNUJHYXRoZXIlMjAoR2F0aGVyXzc2KSUyQyUyMFVucyUwQXF1ZWV6ZSUyMChVbnNxdWVlemVfNzgpJTJDJTIwR2F0aGVyJTIwKEdhdGhlcl85NyklMkMlMjBHYXRoZXIlMjAoR2F0aGVyXzEwMCklMkMlMjBDb25jYXQlMjAoQ29uY2F0XzElMEExMCklMkMlMjBVbnNxdWVlemUlMjAoVW5zcXVlZXplXzEyNSklMkMlMjAuLi4lNUQlMEEyMDIyLTEwLTE4JTIwMTQlM0E1OSUzQTEzLjcyODkwNjQzMSUyMCU1QlYlM0Fvbm54cnVudGltZSUzQSUyQyUyMHNlc3Npb25fc3RhdGUuY2MlM0ExMTkzJTIwVmVyaWZ5RWFjaE4lMEFvZGVJc0Fzc2lnbmVkVG9BbkVwJTVEJTIwJTIwUHJvdmlkZXIlM0ElMjAlNUJDVURBRXhlY3V0aW9uUHJvdmlkZXIlNUQlM0ElMjAlNUJTaGFwZSUyMChTaGFwZV83NCklMkMlMjBTbGljJTBBZSUyMChTbGljZV84MCklMkMlMjBHYXRoZXIlMjAoR2F0aGVyXzgxKSUyQyUyMEdhdGhlciUyMChHYXRoZXJfODIpJTJDJTIwQWRkJTIwKEFkZF84MyklMkMlMjBTaGFwZSUyMChTaGFwZSUwQV85NSklMkMlMjBNYXRNdWwlMjAoTWF0TXVsXzEwMSklMkMlMjAuLi4lNUQ=",highlighted:`<span class="hljs-attribute">2022</span>-<span class="hljs-number">10</span>-<span class="hljs-number">18</span> <span class="hljs-number">14</span>:<span class="hljs-number">59</span>:<span class="hljs-number">13</span>.<span class="hljs-number">728886041</span><span class="hljs-meta"> [V:onnxruntime:, session_state.cc:1193 VerifyEachN
odeIsAssignedToAnEp]  Provider: [CPUExecutionProvider]: [Gather (Gather_76), Uns
queeze (Unsqueeze_78), Gather (Gather_97), Gather (Gather_100), Concat (Concat_1
10), Unsqueeze (Unsqueeze_125), ...]</span>
<span class="hljs-attribute">2022</span>-<span class="hljs-number">10</span>-<span class="hljs-number">18</span> <span class="hljs-number">14</span>:<span class="hljs-number">59</span>:<span class="hljs-number">13</span>.<span class="hljs-number">728906431</span><span class="hljs-meta"> [V:onnxruntime:, session_state.cc:1193 VerifyEachN
odeIsAssignedToAnEp]  Provider: [CUDAExecutionProvider]: [Shape (Shape_74), Slic
e (Slice_80), Gather (Gather_81), Gather (Gather_82), Add (Add_83), Shape (Shape
_95), MatMul (MatMul_101), ...]</span>`,wrap:!1}}),q=new y({props:{title:"Use CUDA execution provider with quantized models",local:"use-cuda-execution-provider-with-quantized-models",headingTag:"h3"}}),P=new y({props:{title:"Reduce memory footprint with IOBinding",local:"reduce-memory-footprint-with-iobinding",headingTag:"h3"}}),K=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjB1c2VfaW9fYmluZGluZyUzREZhbHNlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19mciUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTNBMCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-comment"># Create a pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_fr&quot;</span>, model=model, tokenizer=tokenizer, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)`,wrap:!1}}),te=new y({props:{title:"Observed time gains",local:"observed-time-gains",headingTag:"h3"}}),pe=new h({props:{code:"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",highlighted:`+-----------------------------------------------------------------------------+
|<span class="hljs-string"> NVIDIA-SMI 440.33.01    Driver Version: 440.33.01    CUDA Version: 11.3     </span>|
|<span class="hljs-string">-------------------------------+----------------------+----------------------+
</span>|<span class="hljs-string"> GPU  Name        Persistence-M</span>|<span class="hljs-string"> Bus-Id        Disp.A </span>|<span class="hljs-string"> Volatile Uncorr. ECC </span>|
|<span class="hljs-string"> Fan  Temp  Perf  Pwr:Usage/Cap</span>|<span class="hljs-string">         Memory-Usage </span>|<span class="hljs-string"> GPU-Util  Compute M. </span>|
|<span class="hljs-string">===============================+======================+======================</span>|
|<span class="hljs-string">   0  Tesla T4            On   </span>|<span class="hljs-string"> 00000000:00:1E.0 Off </span>|<span class="hljs-string">                    0 </span>|
|<span class="hljs-string"> N/A   28C    P8     8W /  70W </span>|<span class="hljs-string">      0MiB / 15109MiB </span>|<span class="hljs-string">      0%      Default </span>|
+-------------------------------+----------------------+----------------------+

- Platform: Linux-5.4.0-1089-aws-x86_64-with-glibc2.29
- Python version: 3.8.10
- \`transformers\` version: 4.24.0
- \`optimum\` version: 1.5.0
- PyTorch version: 1.12.0+cu113`,wrap:!1}}),me=new y({props:{title:"TensorrtExecutionProvider",local:"tensorrtexecutionprovider",headingTag:"h2"}}),ue=new y({props:{title:"TensorRT installation",local:"tensorrt-installation",headingTag:"h3"}}),Je=new h({props:{code:"ZXhwb3J0JTIwQ1VEQV9QQVRIJTNEJTJGdXNyJTJGbG9jYWwlMkZjdWRhJTBBZXhwb3J0JTIwTERfTElCUkFSWV9QQVRIJTNEJTI0TERfTElCUkFSWV9QQVRIJTNBJTJGdXNyJTJGbG9jYWwlMkZjdWRhLXgueCUyRmxpYjY0JTNBJTJGcGF0aCUyRnRvJTJGVGVuc29yUlQtOC54LnglMkZsaWI=",highlighted:`<span class="hljs-built_in">export</span> CUDA_PATH=/usr/local/cuda
<span class="hljs-built_in">export</span> LD_LIBRARY_PATH=<span class="hljs-variable">$LD_LIBRARY_PATH</span>:/usr/local/cuda-x.x/lib64:/path/to/TensorRT-8.x.x/lib`,wrap:!1}}),ge=new y({props:{title:"Checking the TensorRT installation is successful",local:"checking-the-tensorrt-installation-is-successful",headingTag:"h3"}}),Ue=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMlRlbnNvcnJ0RXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMEEpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiklMEFpbnAlMjAlM0QlMjB0b2tlbml6ZXIoJTIyZXhwZWN0YXRpb25zJTIwd2VyZSUyMGxvdyUyQyUyMGFjdHVhbCUyMGVuam95bWVudCUyMHdhcyUyMGhpZ2glMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBJTBBcmVzdWx0JTIwJTNEJTIwb3J0X21vZGVsKCoqaW5wKSUwQWFzc2VydCUyMG9ydF9tb2RlbC5wcm92aWRlcnMlMjAlM0QlM0QlMjAlNUIlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTIwJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTIwJTIyQ1BVRXhlY3V0aW9uUHJvdmlkZXIlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inp = tokenizer(<span class="hljs-string">&quot;expectations were low, actual enjoyment was high&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>result = ort_model(**inp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> ort_model.providers == [<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CPUExecutionProvider&quot;</span>]`,wrap:!1}}),je=new h({props:{code:"RmFpbGVkJTIwdG8lMjBjcmVhdGUlMjBUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyLiUyMFBsZWFzZSUyMHJlZmVyZW5jZSUyMGh0dHBzJTNBJTJGJTJGb25ueHJ1bnRpbWUuYWklMkZkb2NzJTJGZXhlY3V0aW9uLXByb3ZpZGVycyUyRlRlbnNvclJULUV4ZWN1dGlvblByb3ZpZGVyLmh0bWwlMjNyZXF1aXJlbWVudHMlMjB0byUyMGVuc3VyZSUyMGFsbCUyMGRlcGVuZGVuY2llcyUyMGFyZSUyMG1ldC4=",highlighted:'Failed to create TensorrtExecutionProvider. Please reference https:<span class="hljs-regexp">//</span>onnxruntime.ai<span class="hljs-regexp">/docs/</span>execution-providers/TensorRT-ExecutionProvider.html<span class="hljs-comment">#requirements to ensure all dependencies are met.</span>',wrap:!1}}),Ce=new y({props:{title:"TensorRT engine build and warmup",local:"tensorrt-engine-build-and-warmup",headingTag:"h3"}}),Ie=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckNhdXNhbExNJTBBJTBBcHJvdmlkZXJfb3B0aW9ucyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRydF9lbmdpbmVfY2FjaGVfZW5hYmxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnRydF9lbmdpbmVfY2FjaGVfcGF0aCUyMiUzQSUyMCUyMnRtcCUyRnRydF9jYWNoZV9ncHQyX2V4YW1wbGUlMjIlMEElN0QlMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcHRpbXVtJTJGZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXJfb3B0aW9ucyUzRHByb3ZpZGVyX29wdGlvbnMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>provider_options = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_enable&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_path&quot;</span>: <span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>
<span class="hljs-meta">... </span>}

<span class="hljs-comment"># the TensorRT engine is not built here, it will be when doing inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/gpt2&quot;</span>,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    provider_options=provider_options
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ee=new h({props:{code:"cHJvdmlkZXJfb3B0aW9ucyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRydF9wcm9maWxlX21pbl9zaGFwZXMlMjIlM0ElMjAlMjJpbnB1dF9pZHMlM0ExeDElMkNhdHRlbnRpb25fbWFzayUzQTF4MSUyQ3Bvc2l0aW9uX2lkcyUzQTF4MSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRydF9wcm9maWxlX29wdF9zaGFwZXMlMjIlM0ElMjAlMjJpbnB1dF9pZHMlM0ExeDElMkNhdHRlbnRpb25fbWFzayUzQTF4MSUyQ3Bvc2l0aW9uX2lkcyUzQTF4MSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRydF9wcm9maWxlX21heF9zaGFwZXMlMjIlM0ElMjAlMjJpbnB1dF9pZHMlM0ExeDY0JTJDYXR0ZW50aW9uX21hc2slM0ExeDY0JTJDcG9zaXRpb25faWRzJTNBMXg2NCUyMiUyQyUwQSU3RA==",highlighted:`provider_options = {
    <span class="hljs-string">&quot;trt_profile_min_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x1,attention_mask:1x1,position_ids:1x1&quot;</span>,
    <span class="hljs-string">&quot;trt_profile_opt_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x1,attention_mask:1x1,position_ids:1x1&quot;</span>,
    <span class="hljs-string">&quot;trt_profile_max_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x64,attention_mask:1x64,position_ids:1x64&quot;</span>,
}`,wrap:!1}}),Be=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEElMEFvcy5tYWtlZGlycyglMjJ0bXAlMkZ0cnRfY2FjaGVfZ3B0Ml9leGFtcGxlJTIyJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQXByb3ZpZGVyX29wdGlvbnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0cnRfZW5naW5lX2NhY2hlX2VuYWJsZSUyMiUzQSUyMFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cnRfZW5naW5lX2NhY2hlX3BhdGglMjIlM0ElMjAlMjJ0bXAlMkZ0cnRfY2FjaGVfZ3B0Ml9leGFtcGxlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJ0X3Byb2ZpbGVfbWluX3NoYXBlcyUyMiUzQSUyMCUyMmlucHV0X2lkcyUzQTF4MSUyQ2F0dGVudGlvbl9tYXNrJTNBMXgxJTJDcG9zaXRpb25faWRzJTNBMXgxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJ0X3Byb2ZpbGVfb3B0X3NoYXBlcyUyMiUzQSUyMCUyMmlucHV0X2lkcyUzQTF4MSUyQ2F0dGVudGlvbl9tYXNrJTNBMXgxJTJDcG9zaXRpb25faWRzJTNBMXgxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJ0X3Byb2ZpbGVfbWF4X3NoYXBlcyUyMiUzQSUyMCUyMmlucHV0X2lkcyUzQTF4NjQlMkNhdHRlbnRpb25fbWFzayUzQTF4NjQlMkNwb3NpdGlvbl9pZHMlM0ExeDY0JTIyJTJDJTBBJTdEJTBBJTBBb3J0X21vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3B0aW11bSUyRmdwdDIlMjIlMkMlMEElMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyVGVuc29ycnRFeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyX29wdGlvbnMlM0Rwcm92aWRlcl9vcHRpb25zJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>os.makedirs(<span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>provider_options = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_enable&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_path&quot;</span>: <span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_profile_min_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x1,attention_mask:1x1,position_ids:1x1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_profile_opt_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x1,attention_mask:1x1,position_ids:1x1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_profile_max_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x64,attention_mask:1x64,position_ids:1x64&quot;</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/gpt2&quot;</span>,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    provider_options=provider_options,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Xe=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEElMEFwcm92aWRlcl9vcHRpb25zJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJ0X2VuZ2luZV9jYWNoZV9lbmFibGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJ0X2VuZ2luZV9jYWNoZV9wYXRoJTIyJTNBJTIwJTIydG1wJTJGdHJ0X2NhY2hlX2dwdDJfZXhhbXBsZSUyMiUwQSU3RCUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm9wdGltdW0lMkZncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2NhY2hlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMlRlbnNvcnJ0RXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlcl9vcHRpb25zJTNEcHJvdmlkZXJfb3B0aW9ucyUyQyUwQSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZ3B0MiUyMiklMEElMEF0ZXh0JTIwJTNEJTIwJTVCJTIyUmVwbGFjZSUyMG1lJTIwYnklMjBhbnklMjB0ZXh0JTIweW91J2QlMjBsaWtlLiUyMiU1RCUwQWVuY29kZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIodGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoMyklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBvcnRfbW9kZWwuZ2VuZXJhdGUoKiplbmNvZGVkX2lucHV0KSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCkpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQklHTk9SRV9SRVNVTFQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>provider_options = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_enable&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_path&quot;</span>: <span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/gpt2&quot;</span>,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    provider_options=provider_options,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = [<span class="hljs-string">&quot;Replace me by any text you&#x27;d like.&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_input = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
<span class="hljs-meta">... </span>    output = ort_model.generate(**encoded_input)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>]))  <span class="hljs-comment"># doctest: +IGNORE_RESULT</span>`,wrap:!1}}),ke=new y({props:{title:"Warmup",local:"warmup",headingTag:"h4"}}),Qe=new y({props:{title:"Use TensorRT execution provider with floating-point models",local:"use-tensorrt-execution-provider-with-floating-point-models",headingTag:"h3"}}),Le=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyVGVuc29ycnRFeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),qe=new h({props:{code:"MjAyMi0wOS0yMiUyMDE0JTNBMTIlM0E0OC4zNzE1MTM3NDElMjAlNUJWJTNBb25ueHJ1bnRpbWUlM0ElMkMlMjBzZXNzaW9uX3N0YXRlLmNjJTNBMTE4OCUyMFZlcmlmeUVhY2hOb2RlSXNBc3NpZ25lZFRvQW5FcCU1RCUyMEFsbCUyMG5vZGVzJTIwaGF2ZSUyMGJlZW4lMjBwbGFjZWQlMjBvbiUyMCU1QlRlbnNvcnJ0RXhlY3V0aW9uUHJvdmlkZXIlNUQ=",highlighted:'<span class="hljs-attribute">2022</span>-<span class="hljs-number">09</span>-<span class="hljs-number">22</span> <span class="hljs-number">14</span>:<span class="hljs-number">12</span>:<span class="hljs-number">48</span>.<span class="hljs-number">371513741</span><span class="hljs-meta"> [V:onnxruntime:, session_state.cc:1188 VerifyEachNodeIsAssignedToAnEp] All nodes have been placed on [TensorrtExecutionProvider]</span>',wrap:!1}}),Ae=new y({props:{title:"Use TensorRT execution provider with quantized models",local:"use-tensorrt-execution-provider-with-quantized-models",headingTag:"h3"}}),Ye=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBBdXRvUXVhbnRpemF0aW9uQ29uZmlnJTBBJTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcudGVuc29ycnQocGVyX2NoYW5uZWwlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> AutoQuantizationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.tensorrt(per_channel=<span class="hljs-literal">False</span>)`,wrap:!1}}),et=new h({props:{code:"aW1wb3J0JTIwb25ueHJ1bnRpbWUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBc2Vzc2lvbl9vcHRpb25zJTIwJTNEJTIwb25ueHJ1bnRpbWUuU2Vzc2lvbk9wdGlvbnMoKSUwQXNlc3Npb25fb3B0aW9ucy5ncmFwaF9vcHRpbWl6YXRpb25fbGV2ZWwlMjAlM0QlMjBvbm54cnVudGltZS5HcmFwaE9wdGltaXphdGlvbkxldmVsLk9SVF9ESVNBQkxFX0FMTCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZ4bWFydHklMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1zc3QyLW9ubngtaW50OC1mb3ItdGVuc29ycnQlMjIpJTBBb3J0X21vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmeG1hcnR5JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtc3N0Mi1vbm54LWludDgtZm9yLXRlbnNvcnJ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2Vzc2lvbl9vcHRpb25zJTNEc2Vzc2lvbl9vcHRpb25zJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXJfb3B0aW9ucyUzRCU3QiUyMnRydF9pbnQ4X2VuYWJsZSUyMiUzQSUyMFRydWUlN0QlMkMlMEEpJTBBJTBBaW5wJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRlbnNvclJUJTIwaXMlMjBhJTIwYml0JTIwcGFpbmZ1bCUyMHRvJTIwdXNlJTJDJTIwYnV0JTIwYXQlMjB0aGUlMjBlbmQlMjBvZiUyMGRheSUyMGl0JTIwcnVucyUyMHNtb290aGx5JTIwYW5kJTIwYmxhemluZ2x5JTIwZmFzdCElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQXJlcyUyMCUzRCUyMG9ydF9tb2RlbCgqKmlucCklMEElMEFwcmludChyZXMpJTBBcHJpbnQob3J0X21vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnJlcy5sb2dpdHMlNUIwJTVELmFyZ21heCgpJTVEKSUwQSUyMyUyMFNlcXVlbmNlQ2xhc3NpZmllck91dHB1dChsb3NzJTNETm9uZSUyQyUyMGxvZ2l0cyUzRGFycmF5KCU1QiU1Qi0wLjU0NTA2NiUyMCUyQyUyMCUyMDAuNTYwOTc2NCU1RCU1RCUyQyUyMGR0eXBlJTNEZmxvYXQzMiklMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKSUwQSUyMyUyMFBPU0lUSVZF",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnxruntime
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>session_options = onnxruntime.SessionOptions()
<span class="hljs-meta">&gt;&gt;&gt; </span>session_options.graph_optimization_level = onnxruntime.GraphOptimizationLevel.ORT_DISABLE_ALL

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;fxmarty/distilbert-base-uncased-sst2-onnx-int8-for-tensorrt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fxmarty/distilbert-base-uncased-sst2-onnx-int8-for-tensorrt&quot;</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    session_options=session_options,
<span class="hljs-meta">... </span>    provider_options={<span class="hljs-string">&quot;trt_int8_enable&quot;</span>: <span class="hljs-literal">True</span>},
<span class="hljs-meta">&gt;&gt;&gt; </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inp = tokenizer(<span class="hljs-string">&quot;TensorRT is a bit painful to use, but at the end of day it runs smoothly and blazingly fast!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>res = ort_model(**inp)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(res)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(ort_model.config.id2label[res.logits[<span class="hljs-number">0</span>].argmax()])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SequenceClassifierOutput(loss=None, logits=array([[-0.545066 ,  0.5609764]], dtype=float32), hidden_states=None, attentions=None)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># POSITIVE</span>`,wrap:!1}}),st=new y({props:{title:"TensorRT limitations for quantized models",local:"tensorrt-limitations-for-quantized-models",headingTag:"h3"}}),it=new y({props:{title:"Observed time gains",local:"observed-time-gains",headingTag:"h3"}}),{c(){T=i("meta"),w=n(),J=i("p"),rt=n(),r(U.$$.fragment),ut=n(),b=i("p"),b.textContent=sl,dt=n(),f=i("p"),f.textContent=ll,Mt=n(),j=i("ul"),j.innerHTML=nl,ht=n(),r(g.$$.fragment),Tt=n(),r(v.$$.fragment),yt=n(),r(C.$$.fragment),Jt=n(),x=i("p"),x.innerHTML=al,gt=n(),r(N.$$.fragment),wt=n(),I=i("p"),I.innerHTML=il,Ut=n(),r(R.$$.fragment),bt=n(),Z=i("p"),Z.textContent=ol,ft=n(),r(E.$$.fragment),jt=n(),V=i("p"),V.textContent=pl,vt=n(),r(G.$$.fragment),Ct=n(),B=i("p"),B.textContent=rl,xt=n(),r($.$$.fragment),Nt=n(),_=i("p"),_.innerHTML=ml,It=n(),r(W.$$.fragment),Rt=n(),X=i("p"),X.innerHTML=cl,Zt=n(),r(k.$$.fragment),Et=n(),z=i("p"),z.innerHTML=ul,Vt=n(),r(Q.$$.fragment),Gt=n(),S=i("p"),S.textContent=dl,Bt=n(),r(L.$$.fragment),$t=n(),F=i("p"),F.textContent=Ml,_t=n(),r(q.$$.fragment),Wt=n(),H=i("p"),H.innerHTML=hl,Xt=n(),A=i("ul"),A.innerHTML=Tl,kt=n(),r(P.$$.fragment),zt=n(),D=i("p"),D.innerHTML=yl,Qt=n(),Y=i("p"),Y.innerHTML=Jl,St=n(),O=i("p"),O.textContent=gl,Lt=n(),r(K.$$.fragment),Ft=n(),ee=i("p"),ee.textContent=wl,qt=n(),r(te.$$.fragment),Ht=n(),se=i("p"),se.innerHTML=Ul,At=n(),le=i("p"),le.innerHTML=bl,Pt=n(),ne=i("table"),ne.innerHTML=fl,Dt=n(),ae=i("p"),ae.textContent=jl,Yt=n(),ie=i("table"),ie.innerHTML=vl,Ot=n(),oe=i("p"),oe.textContent=Cl,Kt=n(),r(pe.$$.fragment),es=n(),re=i("p"),re.innerHTML=xl,ts=n(),r(me.$$.fragment),ss=n(),ce=i("p"),ce.innerHTML=Nl,ls=n(),r(ue.$$.fragment),ns=n(),de=i("p"),de.innerHTML=Il,as=n(),Me=i("p"),Me.textContent=Rl,is=n(),he=i("ul"),he.innerHTML=Zl,os=n(),Te=i("p"),Te.innerHTML=El,ps=n(),ye=i("p"),ye.textContent=Vl,rs=n(),r(Je.$$.fragment),ms=n(),r(ge.$$.fragment),cs=n(),we=i("p"),we.textContent=Gl,us=n(),r(Ue.$$.fragment),ds=n(),be=i("p"),be.textContent=Bl,Ms=n(),fe=i("p"),fe.innerHTML=$l,hs=n(),r(je.$$.fragment),Ts=n(),ve=i("p"),ve.textContent=_l,ys=n(),r(Ce.$$.fragment),Js=n(),xe=i("p"),xe.innerHTML=Wl,gs=n(),Ne=i("p"),Ne.innerHTML=Xl,ws=n(),r(Ie.$$.fragment),Us=n(),Re=i("p"),Re.textContent=kl,bs=n(),Ze=i("p"),Ze.innerHTML=zl,fs=n(),r(Ee.$$.fragment),js=n(),Ve=i("p"),Ve.textContent=Ql,vs=n(),Ge=i("p"),Ge.textContent=Sl,Cs=n(),r(Be.$$.fragment),xs=n(),$e=i("p"),$e.textContent=Ll,Ns=n(),_e=i("p"),_e.innerHTML=Fl,Is=n(),We=i("p"),We.textContent=ql,Rs=n(),r(Xe.$$.fragment),Zs=n(),r(ke.$$.fragment),Es=n(),ze=i("p"),ze.innerHTML=Hl,Vs=n(),r(Qe.$$.fragment),Gs=n(),Se=i("p"),Se.innerHTML=Al,Bs=n(),r(Le.$$.fragment),$s=n(),Fe=i("p"),Fe.innerHTML=Pl,_s=n(),r(qe.$$.fragment),Ws=n(),He=i("p"),He.innerHTML=Dl,Xs=n(),r(Ae.$$.fragment),ks=n(),Pe=i("p"),Pe.innerHTML=Yl,zs=n(),De=i("p"),De.innerHTML=Ol,Qs=n(),r(Ye.$$.fragment),Ss=n(),Oe=i("p"),Oe.innerHTML=Kl,Ls=n(),Ke=i("p"),Ke.innerHTML=en,Fs=n(),r(et.$$.fragment),qs=n(),tt=i("p"),tt.innerHTML=tn,Hs=n(),r(st.$$.fragment),As=n(),lt=i("p"),lt.textContent=sn,Ps=n(),nt=i("ul"),nt.innerHTML=ln,Ds=n(),at=i("p"),at.innerHTML=nn,Ys=n(),r(it.$$.fragment),Os=n(),ot=i("p"),ot.innerHTML=an,Ks=n(),pt=i("p"),pt.textContent=on,el=n(),mt=i("p"),this.h()},l(e){const t=Tn("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(s),w=a(e),J=o(e,"P",{}),rn(J).forEach(s),rt=a(e),m(U.$$.fragment,e),ut=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-domqad"&&(b.textContent=sl),dt=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-ww48at"&&(f.textContent=ll),Mt=a(e),j=o(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-1f150mv"&&(j.innerHTML=nl),ht=a(e),m(g.$$.fragment,e),Tt=a(e),m(v.$$.fragment,e),yt=a(e),m(C.$$.fragment,e),Jt=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-19ifj7n"&&(x.innerHTML=al),gt=a(e),m(N.$$.fragment,e),wt=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-uw46pi"&&(I.innerHTML=il),Ut=a(e),m(R.$$.fragment,e),bt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-ojb3z4"&&(Z.textContent=ol),ft=a(e),m(E.$$.fragment,e),jt=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-j2t2xg"&&(V.textContent=pl),vt=a(e),m(G.$$.fragment,e),Ct=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-f1x068"&&(B.textContent=rl),xt=a(e),m($.$$.fragment,e),Nt=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-8e3pil"&&(_.innerHTML=ml),It=a(e),m(W.$$.fragment,e),Rt=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1icvfx4"&&(X.innerHTML=cl),Zt=a(e),m(k.$$.fragment,e),Et=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1i8mx2m"&&(z.innerHTML=ul),Vt=a(e),m(Q.$$.fragment,e),Gt=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-gej35a"&&(S.textContent=dl),Bt=a(e),m(L.$$.fragment,e),$t=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1fiacx2"&&(F.textContent=Ml),_t=a(e),m(q.$$.fragment,e),Wt=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-bair0o"&&(H.innerHTML=hl),Xt=a(e),A=o(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-1530vj"&&(A.innerHTML=Tl),kt=a(e),m(P.$$.fragment,e),zt=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1weebfs"&&(D.innerHTML=yl),Qt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1uj5t80"&&(Y.innerHTML=Jl),St=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-5cnra5"&&(O.textContent=gl),Lt=a(e),m(K.$$.fragment,e),Ft=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-lbg3hy"&&(ee.textContent=wl),qt=a(e),m(te.$$.fragment,e),Ht=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-j6vk0b"&&(se.innerHTML=Ul),At=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-gwibyk"&&(le.innerHTML=bl),Pt=a(e),ne=o(e,"TABLE",{"data-svelte-h":!0}),p(ne)!=="svelte-kb5dzt"&&(ne.innerHTML=fl),Dt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1o7p4o2"&&(ae.textContent=jl),Yt=a(e),ie=o(e,"TABLE",{"data-svelte-h":!0}),p(ie)!=="svelte-1vr8f8j"&&(ie.innerHTML=vl),Ot=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1fkshtn"&&(oe.textContent=Cl),Kt=a(e),m(pe.$$.fragment,e),es=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1qw28p2"&&(re.innerHTML=xl),ts=a(e),m(me.$$.fragment,e),ss=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-jpss89"&&(ce.innerHTML=Nl),ls=a(e),m(ue.$$.fragment,e),ns=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1rs6298"&&(de.innerHTML=Il),as=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1ceem44"&&(Me.textContent=Rl),is=a(e),he=o(e,"UL",{"data-svelte-h":!0}),p(he)!=="svelte-dwey60"&&(he.innerHTML=Zl),os=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-73idjo"&&(Te.innerHTML=El),ps=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-rrllkl"&&(ye.textContent=Vl),rs=a(e),m(Je.$$.fragment,e),ms=a(e),m(ge.$$.fragment,e),cs=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-ojb3z4"&&(we.textContent=Gl),us=a(e),m(Ue.$$.fragment,e),ds=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-10vc8nx"&&(be.textContent=Bl),Ms=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-16mf5ei"&&(fe.innerHTML=$l),hs=a(e),m(je.$$.fragment,e),Ts=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-a4iqo7"&&(ve.textContent=_l),ys=a(e),m(Ce.$$.fragment,e),Js=a(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1w34bpb"&&(xe.innerHTML=Wl),gs=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1vctm96"&&(Ne.innerHTML=Xl),ws=a(e),m(Ie.$$.fragment,e),Us=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1adxaty"&&(Re.textContent=kl),bs=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1bgbv86"&&(Ze.innerHTML=zl),fs=a(e),m(Ee.$$.fragment,e),js=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-7tlbrr"&&(Ve.textContent=Ql),vs=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-10vd8g9"&&(Ge.textContent=Sl),Cs=a(e),m(Be.$$.fragment,e),xs=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1a6v242"&&($e.textContent=Ll),Ns=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-h7osbf"&&(_e.innerHTML=Fl),Is=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-19pgd5i"&&(We.textContent=ql),Rs=a(e),m(Xe.$$.fragment,e),Zs=a(e),m(ke.$$.fragment,e),Es=a(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1go7vzm"&&(ze.innerHTML=Hl),Vs=a(e),m(Qe.$$.fragment,e),Gs=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1wz9kqz"&&(Se.innerHTML=Al),Bs=a(e),m(Le.$$.fragment,e),$s=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-12c3zjv"&&(Fe.innerHTML=Pl),_s=a(e),m(qe.$$.fragment,e),Ws=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-16axcqn"&&(He.innerHTML=Dl),Xs=a(e),m(Ae.$$.fragment,e),ks=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1gmqa4f"&&(Pe.innerHTML=Yl),zs=a(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-obxhy4"&&(De.innerHTML=Ol),Qs=a(e),m(Ye.$$.fragment,e),Ss=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-qouywp"&&(Oe.innerHTML=Kl),Ls=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-1i62bc8"&&(Ke.innerHTML=en),Fs=a(e),m(et.$$.fragment,e),qs=a(e),tt=o(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-16axcqn"&&(tt.innerHTML=tn),Hs=a(e),m(st.$$.fragment,e),As=a(e),lt=o(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1oae55m"&&(lt.textContent=sn),Ps=a(e),nt=o(e,"UL",{"data-svelte-h":!0}),p(nt)!=="svelte-dbp0vn"&&(nt.innerHTML=ln),Ds=a(e),at=o(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1jqg7cl"&&(at.innerHTML=nn),Ys=a(e),m(it.$$.fragment,e),Os=a(e),ot=o(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-cgoioi"&&(ot.innerHTML=an),Ks=a(e),pt=o(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-15n2n4z"&&(pt.textContent=on),el=a(e),mt=o(e,"P",{}),rn(mt).forEach(s),this.h()},h(){mn(T,"name","hf:doc:metadata"),mn(T,"content",Un)},m(e,t){yn(document.head,T),l(e,w,t),l(e,J,t),l(e,rt,t),c(U,e,t),l(e,ut,t),l(e,b,t),l(e,dt,t),l(e,f,t),l(e,Mt,t),l(e,j,t),l(e,ht,t),c(g,e,t),l(e,Tt,t),c(v,e,t),l(e,yt,t),c(C,e,t),l(e,Jt,t),l(e,x,t),l(e,gt,t),c(N,e,t),l(e,wt,t),l(e,I,t),l(e,Ut,t),c(R,e,t),l(e,bt,t),l(e,Z,t),l(e,ft,t),c(E,e,t),l(e,jt,t),l(e,V,t),l(e,vt,t),c(G,e,t),l(e,Ct,t),l(e,B,t),l(e,xt,t),c($,e,t),l(e,Nt,t),l(e,_,t),l(e,It,t),c(W,e,t),l(e,Rt,t),l(e,X,t),l(e,Zt,t),c(k,e,t),l(e,Et,t),l(e,z,t),l(e,Vt,t),c(Q,e,t),l(e,Gt,t),l(e,S,t),l(e,Bt,t),c(L,e,t),l(e,$t,t),l(e,F,t),l(e,_t,t),c(q,e,t),l(e,Wt,t),l(e,H,t),l(e,Xt,t),l(e,A,t),l(e,kt,t),c(P,e,t),l(e,zt,t),l(e,D,t),l(e,Qt,t),l(e,Y,t),l(e,St,t),l(e,O,t),l(e,Lt,t),c(K,e,t),l(e,Ft,t),l(e,ee,t),l(e,qt,t),c(te,e,t),l(e,Ht,t),l(e,se,t),l(e,At,t),l(e,le,t),l(e,Pt,t),l(e,ne,t),l(e,Dt,t),l(e,ae,t),l(e,Yt,t),l(e,ie,t),l(e,Ot,t),l(e,oe,t),l(e,Kt,t),c(pe,e,t),l(e,es,t),l(e,re,t),l(e,ts,t),c(me,e,t),l(e,ss,t),l(e,ce,t),l(e,ls,t),c(ue,e,t),l(e,ns,t),l(e,de,t),l(e,as,t),l(e,Me,t),l(e,is,t),l(e,he,t),l(e,os,t),l(e,Te,t),l(e,ps,t),l(e,ye,t),l(e,rs,t),c(Je,e,t),l(e,ms,t),c(ge,e,t),l(e,cs,t),l(e,we,t),l(e,us,t),c(Ue,e,t),l(e,ds,t),l(e,be,t),l(e,Ms,t),l(e,fe,t),l(e,hs,t),c(je,e,t),l(e,Ts,t),l(e,ve,t),l(e,ys,t),c(Ce,e,t),l(e,Js,t),l(e,xe,t),l(e,gs,t),l(e,Ne,t),l(e,ws,t),c(Ie,e,t),l(e,Us,t),l(e,Re,t),l(e,bs,t),l(e,Ze,t),l(e,fs,t),c(Ee,e,t),l(e,js,t),l(e,Ve,t),l(e,vs,t),l(e,Ge,t),l(e,Cs,t),c(Be,e,t),l(e,xs,t),l(e,$e,t),l(e,Ns,t),l(e,_e,t),l(e,Is,t),l(e,We,t),l(e,Rs,t),c(Xe,e,t),l(e,Zs,t),c(ke,e,t),l(e,Es,t),l(e,ze,t),l(e,Vs,t),c(Qe,e,t),l(e,Gs,t),l(e,Se,t),l(e,Bs,t),c(Le,e,t),l(e,$s,t),l(e,Fe,t),l(e,_s,t),c(qe,e,t),l(e,Ws,t),l(e,He,t),l(e,Xs,t),c(Ae,e,t),l(e,ks,t),l(e,Pe,t),l(e,zs,t),l(e,De,t),l(e,Qs,t),c(Ye,e,t),l(e,Ss,t),l(e,Oe,t),l(e,Ls,t),l(e,Ke,t),l(e,Fs,t),c(et,e,t),l(e,qs,t),l(e,tt,t),l(e,Hs,t),c(st,e,t),l(e,As,t),l(e,lt,t),l(e,Ps,t),l(e,nt,t),l(e,Ds,t),l(e,at,t),l(e,Ys,t),c(it,e,t),l(e,Os,t),l(e,ot,t),l(e,Ks,t),l(e,pt,t),l(e,el,t),l(e,mt,t),tl=!0},p(e,[t]){const pn={};t&2&&(pn.$$scope={dirty:t,ctx:e}),g.$set(pn)},i(e){tl||(u(U.$$.fragment,e),u(g.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u(E.$$.fragment,e),u(G.$$.fragment,e),u($.$$.fragment,e),u(W.$$.fragment,e),u(k.$$.fragment,e),u(Q.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(ge.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(Ie.$$.fragment,e),u(Ee.$$.fragment,e),u(Be.$$.fragment,e),u(Xe.$$.fragment,e),u(ke.$$.fragment,e),u(Qe.$$.fragment,e),u(Le.$$.fragment,e),u(qe.$$.fragment,e),u(Ae.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),tl=!0)},o(e){d(U.$$.fragment,e),d(g.$$.fragment,e),d(v.$$.fragment,e),d(C.$$.fragment,e),d(N.$$.fragment,e),d(R.$$.fragment,e),d(E.$$.fragment,e),d(G.$$.fragment,e),d($.$$.fragment,e),d(W.$$.fragment,e),d(k.$$.fragment,e),d(Q.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(Je.$$.fragment,e),d(ge.$$.fragment,e),d(Ue.$$.fragment,e),d(je.$$.fragment,e),d(Ce.$$.fragment,e),d(Ie.$$.fragment,e),d(Ee.$$.fragment,e),d(Be.$$.fragment,e),d(Xe.$$.fragment,e),d(ke.$$.fragment,e),d(Qe.$$.fragment,e),d(Le.$$.fragment,e),d(qe.$$.fragment,e),d(Ae.$$.fragment,e),d(Ye.$$.fragment,e),d(et.$$.fragment,e),d(st.$$.fragment,e),d(it.$$.fragment,e),tl=!1},d(e){e&&(s(w),s(J),s(rt),s(ut),s(b),s(dt),s(f),s(Mt),s(j),s(ht),s(Tt),s(yt),s(Jt),s(x),s(gt),s(wt),s(I),s(Ut),s(bt),s(Z),s(ft),s(jt),s(V),s(vt),s(Ct),s(B),s(xt),s(Nt),s(_),s(It),s(Rt),s(X),s(Zt),s(Et),s(z),s(Vt),s(Gt),s(S),s(Bt),s($t),s(F),s(_t),s(Wt),s(H),s(Xt),s(A),s(kt),s(zt),s(D),s(Qt),s(Y),s(St),s(O),s(Lt),s(Ft),s(ee),s(qt),s(Ht),s(se),s(At),s(le),s(Pt),s(ne),s(Dt),s(ae),s(Yt),s(ie),s(Ot),s(oe),s(Kt),s(es),s(re),s(ts),s(ss),s(ce),s(ls),s(ns),s(de),s(as),s(Me),s(is),s(he),s(os),s(Te),s(ps),s(ye),s(rs),s(ms),s(cs),s(we),s(us),s(ds),s(be),s(Ms),s(fe),s(hs),s(Ts),s(ve),s(ys),s(Js),s(xe),s(gs),s(Ne),s(ws),s(Us),s(Re),s(bs),s(Ze),s(fs),s(js),s(Ve),s(vs),s(Ge),s(Cs),s(xs),s($e),s(Ns),s(_e),s(Is),s(We),s(Rs),s(Zs),s(Es),s(ze),s(Vs),s(Gs),s(Se),s(Bs),s($s),s(Fe),s(_s),s(Ws),s(He),s(Xs),s(ks),s(Pe),s(zs),s(De),s(Qs),s(Ss),s(Oe),s(Ls),s(Ke),s(Fs),s(qs),s(tt),s(Hs),s(As),s(lt),s(Ps),s(nt),s(Ds),s(at),s(Ys),s(Os),s(ot),s(Ks),s(pt),s(el),s(mt)),s(T),M(U,e),M(g,e),M(v,e),M(C,e),M(N,e),M(R,e),M(E,e),M(G,e),M($,e),M(W,e),M(k,e),M(Q,e),M(L,e),M(q,e),M(P,e),M(K,e),M(te,e),M(pe,e),M(me,e),M(ue,e),M(Je,e),M(ge,e),M(Ue,e),M(je,e),M(Ce,e),M(Ie,e),M(Ee,e),M(Be,e),M(Xe,e),M(ke,e),M(Qe,e),M(Le,e),M(qe,e),M(Ae,e),M(Ye,e),M(et,e),M(st,e),M(it,e)}}}const Un='{"title":"Accelerated inference on NVIDIA GPUs","local":"accelerated-inference-on-nvidia-gpus","sections":[{"title":"CUDAExecutionProvider","local":"cudaexecutionprovider","sections":[{"title":"CUDA installation","local":"cuda-installation","sections":[],"depth":3},{"title":"Checking the CUDA installation is successful","local":"checking-the-cuda-installation-is-successful","sections":[],"depth":3},{"title":"Use CUDA execution provider with floating-point models","local":"use-cuda-execution-provider-with-floating-point-models","sections":[],"depth":3},{"title":"Use CUDA execution provider with quantized models","local":"use-cuda-execution-provider-with-quantized-models","sections":[],"depth":3},{"title":"Reduce memory footprint with IOBinding","local":"reduce-memory-footprint-with-iobinding","sections":[],"depth":3},{"title":"Observed time gains","local":"observed-time-gains","sections":[],"depth":3}],"depth":2},{"title":"TensorrtExecutionProvider","local":"tensorrtexecutionprovider","sections":[{"title":"TensorRT installation","local":"tensorrt-installation","sections":[],"depth":3},{"title":"Checking the TensorRT installation is successful","local":"checking-the-tensorrt-installation-is-successful","sections":[],"depth":3},{"title":"TensorRT engine build and warmup","local":"tensorrt-engine-build-and-warmup","sections":[{"title":"Warmup","local":"warmup","sections":[],"depth":4}],"depth":3},{"title":"Use TensorRT execution provider with floating-point models","local":"use-tensorrt-execution-provider-with-floating-point-models","sections":[],"depth":3},{"title":"Use TensorRT execution provider with quantized models","local":"use-tensorrt-execution-provider-with-quantized-models","sections":[],"depth":3},{"title":"TensorRT limitations for quantized models","local":"tensorrt-limitations-for-quantized-models","sections":[],"depth":3},{"title":"Observed time gains","local":"observed-time-gains","sections":[],"depth":3}],"depth":2}],"depth":1}';function bn(ct){return un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nn extends Mn{constructor(T){super(),hn(this,T,bn,wn,cn,{})}}export{Nn as component};
