import{s as Fe,o as Le,n as Ve}from"../chunks/scheduler.b108d059.js";import{S as ze,i as Pe,g as o,s as a,r as m,A as De,h as p,f as t,c as n,j as Qe,u as h,x as c,k as Se,y as qe,a as l,v as w,d,t as u,w as f}from"../chunks/index.008de539.js";import{T as Ee}from"../chunks/Tip.aeb15ab7.js";import{C as L}from"../chunks/CodeBlock.3968c746.js";import{H as ve,E as Ke}from"../chunks/EditOnGithub.d1c48e3d.js";function Oe(z){let i,j='This tutorial will be written as an ES module, but you can easily adapt it to use CommonJS instead. For more information, see the <a href="https://huggingface.co/docs/transformers.js/tutorials/node" rel="nofollow">node tutorial</a>.';return{c(){i=o("p"),i.innerHTML=j},l(r){i=p(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-19bu2gi"&&(i.innerHTML=j)},m(r,M){l(r,i,M)},p:Ve,d(r){r&&t(i)}}}function es(z){let i,j="Remember to add <code>&quot;type&quot;: &quot;module&quot;</code> to your <code>package.json</code> to indicate that your project uses ECMAScript modules.";return{c(){i=o("p"),i.innerHTML=j},l(r){i=p(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1hk65wu"&&(i.innerHTML=j)},m(r,M){l(r,i,M)},p:Ve,d(r){r&&t(i)}}}function ss(z){let i,j,r,M,J,D,b,ge='A major benefit of writing code for the web is that you can access the multitude of APIs that are available in modern browsers. Unfortunately, when writing server-side code, we are not afforded such luxury, so we have to find another way. In this tutorial, we will design a simple Node.js application that uses Transformers.js for speech recognition with <a href="https://huggingface.co/Xenova/whisper-tiny.en" rel="nofollow">Whisper</a>, and in the process, learn how to process audio on the server.',q,$,Ie='The main problem we need to solve is that the <a href="https://developer.mozilla.org/en-US/docs/Web/API/Web_Audio_API" rel="nofollow">Web Audio API</a> is not available in Node.js, meaning we can’t use the <a href="https://developer.mozilla.org/en-US/docs/Web/API/AudioContext" rel="nofollow"><code>AudioContext</code></a> class to process audio. So, we will need to install third-party libraries to obtain the raw audio data. For this example, we will only consider <code>.wav</code> files, but the same principles apply to other audio formats.',K,T,O,U,Ce="<strong>Useful links:</strong>",ee,v,ke='<li><a href="https://github.com/xenova/transformers.js/tree/main/examples/node-audio-processing" rel="nofollow">Source code</a></li> <li><a href="https://huggingface.co/docs/transformers.js" rel="nofollow">Documentation</a></li>',se,g,te,I,Be='<li><a href="https://nodejs.org/en/" rel="nofollow">Node.js</a> version 18+</li> <li><a href="https://www.npmjs.com/" rel="nofollow">npm</a> version 9+</li>',le,C,ae,k,xe='Let’s start by creating a new Node.js project and installing Transformers.js via <a href="https://www.npmjs.com/package/@xenova/transformers" rel="nofollow">NPM</a>:',ne,B,ie,y,oe,x,Ze='Next, let’s install the <a href="https://www.npmjs.com/package/wavefile" rel="nofollow"><code>wavefile</code></a> package, which we will use for loading <code>.wav</code> files:',pe,Z,re,G,ce,W,Ge="Start by creating a new file called <code>index.js</code>, which will be the entry point for our application. Let’s also import the necessary modules:",me,_,he,N,We='For this tutorial, we will use the <code>Xenova/whisper-tiny.en</code> model, but feel free to choose one of the other whisper models from the <a href="https://huggingface.co/models?library=transformers.js&amp;search=whisper" rel="nofollow">Hugging Face Hub</a>. Let’s create our pipeline with:',we,R,de,Y,_e="Next, let’s load an audio file and convert it to the format required by Transformers.js:",ue,X,fe,A,Ne="Finally, let’s run the model and measure execution duration.",je,H,Me,Q,Re="You can now run the application with <code>node index.js</code>. Note that when running the script for the first time, it may take a while to download and cache the model. Subsequent requests will use the cached model, and model loading will be much faster.",Te,S,Ye="You should see output similar to:",ye,E,Je,V,Xe="That’s it! You’ve successfully created a Node.js application that uses Transformers.js for speech recognition with Whisper. You can now use this as a starting point for your own applications.",be,F,$e,P,Ue;return J=new ve({props:{title:"Server-side Audio Processing in Node.js",local:"server-side-audio-processing-in-nodejs",headingTag:"h1"}}),T=new Ee({props:{$$slots:{default:[Oe]},$$scope:{ctx:z}}}),g=new ve({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),C=new ve({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),B=new L({props:{code:"bnBtJTIwaW5pdCUyMC15JTBBbnBtJTIwaSUyMCU0MHhlbm92YSUyRnRyYW5zZm9ybWVycw==",highlighted:`npm init -y
npm i @xenova/transformers`,wrap:!1}}),y=new Ee({props:{$$slots:{default:[es]},$$scope:{ctx:z}}}),Z=new L({props:{code:"bnBtJTIwaSUyMHdhdmVmaWxl",highlighted:"npm i wavefile",wrap:!1}}),G=new ve({props:{title:"Creating the application",local:"creating-the-application",headingTag:"h2"}}),_=new L({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEFpbXBvcnQlMjB3YXZlZmlsZSUyMGZyb20lMjAnd2F2ZWZpbGUnJTNC",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;
<span class="hljs-keyword">import</span> wavefile <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;wavefile&#x27;</span>;`,wrap:!1}}),R=new L({props:{code:"bGV0JTIwdHJhbnNjcmliZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJyUyQyUyMCdYZW5vdmElMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQg==",highlighted:'<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);',wrap:!1}}),X=new L({props:{code:"JTJGJTJGJTIwTG9hZCUyMGF1ZGlvJTIwZGF0YSUwQWxldCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGamZrLndhdiclM0IlMEFsZXQlMjBidWZmZXIlMjAlM0QlMjBCdWZmZXIuZnJvbShhd2FpdCUyMGZldGNoKHVybCkudGhlbih4JTIwJTNEJTNFJTIweC5hcnJheUJ1ZmZlcigpKSklMEElMEElMkYlMkYlMjBSZWFkJTIwLndhdiUyMGZpbGUlMjBhbmQlMjBjb252ZXJ0JTIwaXQlMjB0byUyMHJlcXVpcmVkJTIwZm9ybWF0JTBBbGV0JTIwd2F2JTIwJTNEJTIwbmV3JTIwd2F2ZWZpbGUuV2F2ZUZpbGUoYnVmZmVyKSUzQiUwQXdhdi50b0JpdERlcHRoKCczMmYnKSUzQiUyMCUyRiUyRiUyMFBpcGVsaW5lJTIwZXhwZWN0cyUyMGlucHV0JTIwYXMlMjBhJTIwRmxvYXQzMkFycmF5JTBBd2F2LnRvU2FtcGxlUmF0ZSgxNjAwMCklM0IlMjAlMkYlMkYlMjBXaGlzcGVyJTIwZXhwZWN0cyUyMGF1ZGlvJTIwd2l0aCUyMGElMjBzYW1wbGluZyUyMHJhdGUlMjBvZiUyMDE2MDAwJTBBbGV0JTIwYXVkaW9EYXRhJTIwJTNEJTIwd2F2LmdldFNhbXBsZXMoKSUzQiUwQWlmJTIwKEFycmF5LmlzQXJyYXkoYXVkaW9EYXRhKSklMjAlN0IlMEElMjAlMjBpZiUyMChhdWRpb0RhdGEubGVuZ3RoJTIwJTNFJTIwMSklMjAlN0IlMEElMjAlMjAlMjAlMjBjb25zdCUyMFNDQUxJTkdfRkFDVE9SJTIwJTNEJTIwTWF0aC5zcXJ0KDIpJTNCJTBBJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwTWVyZ2UlMjBjaGFubmVscyUyMChpbnRvJTIwZmlyc3QlMjBjaGFubmVsJTIwdG8lMjBzYXZlJTIwbWVtb3J5KSUwQSUyMCUyMCUyMCUyMGZvciUyMChsZXQlMjBpJTIwJTNEJTIwMCUzQiUyMGklMjAlM0MlMjBhdWRpb0RhdGElNUIwJTVELmxlbmd0aCUzQiUyMCUyQiUyQmkpJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9EYXRhJTVCMCU1RCU1QmklNUQlMjAlM0QlMjBTQ0FMSU5HX0ZBQ1RPUiUyMColMjAoYXVkaW9EYXRhJTVCMCU1RCU1QmklNUQlMjAlMkIlMjBhdWRpb0RhdGElNUIxJTVEJTVCaSU1RCklMjAlMkYlMjAyJTNCJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTJGJTJGJTIwU2VsZWN0JTIwZmlyc3QlMjBjaGFubmVsJTBBJTIwJTIwYXVkaW9EYXRhJTIwJTNEJTIwYXVkaW9EYXRhJTVCMCU1RCUzQiUwQSU3RA==",highlighted:`<span class="hljs-comment">// Load audio data</span>
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> buffer = <span class="hljs-title class_">Buffer</span>.<span class="hljs-title function_">from</span>(<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(url).<span class="hljs-title function_">then</span>(<span class="hljs-function"><span class="hljs-params">x</span> =&gt;</span> x.<span class="hljs-title function_">arrayBuffer</span>()))

<span class="hljs-comment">// Read .wav file and convert it to required format</span>
<span class="hljs-keyword">let</span> wav = <span class="hljs-keyword">new</span> wavefile.<span class="hljs-title class_">WaveFile</span>(buffer);
wav.<span class="hljs-title function_">toBitDepth</span>(<span class="hljs-string">&#x27;32f&#x27;</span>); <span class="hljs-comment">// Pipeline expects input as a Float32Array</span>
wav.<span class="hljs-title function_">toSampleRate</span>(<span class="hljs-number">16000</span>); <span class="hljs-comment">// Whisper expects audio with a sampling rate of 16000</span>
<span class="hljs-keyword">let</span> audioData = wav.<span class="hljs-title function_">getSamples</span>();
<span class="hljs-keyword">if</span> (<span class="hljs-title class_">Array</span>.<span class="hljs-title function_">isArray</span>(audioData)) {
  <span class="hljs-keyword">if</span> (audioData.<span class="hljs-property">length</span> &gt; <span class="hljs-number">1</span>) {
    <span class="hljs-keyword">const</span> <span class="hljs-variable constant_">SCALING_FACTOR</span> = <span class="hljs-title class_">Math</span>.<span class="hljs-title function_">sqrt</span>(<span class="hljs-number">2</span>);

    <span class="hljs-comment">// Merge channels (into first channel to save memory)</span>
    <span class="hljs-keyword">for</span> (<span class="hljs-keyword">let</span> i = <span class="hljs-number">0</span>; i &lt; audioData[<span class="hljs-number">0</span>].<span class="hljs-property">length</span>; ++i) {
      audioData[<span class="hljs-number">0</span>][i] = <span class="hljs-variable constant_">SCALING_FACTOR</span> * (audioData[<span class="hljs-number">0</span>][i] + audioData[<span class="hljs-number">1</span>][i]) / <span class="hljs-number">2</span>;
    }
  }

  <span class="hljs-comment">// Select first channel</span>
  audioData = audioData[<span class="hljs-number">0</span>];
}`,wrap:!1}}),H=new L({props:{code:"bGV0JTIwc3RhcnQlMjAlM0QlMjBwZXJmb3JtYW5jZS5ub3coKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwdHJhbnNjcmliZXIoYXVkaW9EYXRhKSUzQiUwQWxldCUyMGVuZCUyMCUzRCUyMHBlcmZvcm1hbmNlLm5vdygpJTNCJTBBY29uc29sZS5sb2coJTYwRXhlY3V0aW9uJTIwZHVyYXRpb24lM0ElMjAlMjQlN0IoZW5kJTIwLSUyMHN0YXJ0KSUyMCUyRiUyMDEwMDAlN0QlMjBzZWNvbmRzJTYwKSUzQiUwQWNvbnNvbGUubG9nKG91dHB1dCklM0I=",highlighted:`<span class="hljs-keyword">let</span> start = performance.<span class="hljs-title function_">now</span>();
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(audioData);
<span class="hljs-keyword">let</span> end = performance.<span class="hljs-title function_">now</span>();
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`Execution duration: <span class="hljs-subst">\${(end - start) / <span class="hljs-number">1000</span>}</span> seconds\`</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output);`,wrap:!1}}),E=new L({props:{code:"RXhlY3V0aW9uJTIwZHVyYXRpb24lM0ElMjAwLjY0NjAzMTc5OTk3MjA1NzQlMjBzZWNvbmRzJTBBJTdCJTBBJTIwJTIwdGV4dCUzQSUyMCclMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UuJTIwQXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJyUwQSU3RA==",highlighted:`Execution duration: <span class="hljs-number">0.6460317999720574</span> seconds
{
  text: &#x27; And so my fellow Americans ask not what your country can <span class="hljs-keyword">do</span> <span class="hljs-keyword">for</span> <span class="hljs-title class_">you</span>. Ask what you can <span class="hljs-keyword">do</span> <span class="hljs-keyword">for</span> <span class="hljs-title class_">your</span> country.&#x27;
}`,wrap:!1}}),F=new Ke({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/guides/node-audio-processing.md"}}),{c(){i=o("meta"),j=a(),r=o("p"),M=a(),m(J.$$.fragment),D=a(),b=o("p"),b.innerHTML=ge,q=a(),$=o("p"),$.innerHTML=Ie,K=a(),m(T.$$.fragment),O=a(),U=o("p"),U.innerHTML=Ce,ee=a(),v=o("ul"),v.innerHTML=ke,se=a(),m(g.$$.fragment),te=a(),I=o("ul"),I.innerHTML=Be,le=a(),m(C.$$.fragment),ae=a(),k=o("p"),k.innerHTML=xe,ne=a(),m(B.$$.fragment),ie=a(),m(y.$$.fragment),oe=a(),x=o("p"),x.innerHTML=Ze,pe=a(),m(Z.$$.fragment),re=a(),m(G.$$.fragment),ce=a(),W=o("p"),W.innerHTML=Ge,me=a(),m(_.$$.fragment),he=a(),N=o("p"),N.innerHTML=We,we=a(),m(R.$$.fragment),de=a(),Y=o("p"),Y.textContent=_e,ue=a(),m(X.$$.fragment),fe=a(),A=o("p"),A.textContent=Ne,je=a(),m(H.$$.fragment),Me=a(),Q=o("p"),Q.innerHTML=Re,Te=a(),S=o("p"),S.textContent=Ye,ye=a(),m(E.$$.fragment),Je=a(),V=o("p"),V.textContent=Xe,be=a(),m(F.$$.fragment),$e=a(),P=o("p"),this.h()},l(e){const s=De("svelte-u9bgzb",document.head);i=p(s,"META",{name:!0,content:!0}),s.forEach(t),j=n(e),r=p(e,"P",{}),Qe(r).forEach(t),M=n(e),h(J.$$.fragment,e),D=n(e),b=p(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-ga23p1"&&(b.innerHTML=ge),q=n(e),$=p(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1p7qc0w"&&($.innerHTML=Ie),K=n(e),h(T.$$.fragment,e),O=n(e),U=p(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1kriz5m"&&(U.innerHTML=Ce),ee=n(e),v=p(e,"UL",{"data-svelte-h":!0}),c(v)!=="svelte-lnhmef"&&(v.innerHTML=ke),se=n(e),h(g.$$.fragment,e),te=n(e),I=p(e,"UL",{"data-svelte-h":!0}),c(I)!=="svelte-1qy4daj"&&(I.innerHTML=Be),le=n(e),h(C.$$.fragment,e),ae=n(e),k=p(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1w613qw"&&(k.innerHTML=xe),ne=n(e),h(B.$$.fragment,e),ie=n(e),h(y.$$.fragment,e),oe=n(e),x=p(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-e9y8ng"&&(x.innerHTML=Ze),pe=n(e),h(Z.$$.fragment,e),re=n(e),h(G.$$.fragment,e),ce=n(e),W=p(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-wc1j2"&&(W.innerHTML=Ge),me=n(e),h(_.$$.fragment,e),he=n(e),N=p(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-g3d4hf"&&(N.innerHTML=We),we=n(e),h(R.$$.fragment,e),de=n(e),Y=p(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1jpls9q"&&(Y.textContent=_e),ue=n(e),h(X.$$.fragment,e),fe=n(e),A=p(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1sjiopi"&&(A.textContent=Ne),je=n(e),h(H.$$.fragment,e),Me=n(e),Q=p(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-cx7eio"&&(Q.innerHTML=Re),Te=n(e),S=p(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-s5mxam"&&(S.textContent=Ye),ye=n(e),h(E.$$.fragment,e),Je=n(e),V=p(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1mxb03j"&&(V.textContent=Xe),be=n(e),h(F.$$.fragment,e),$e=n(e),P=p(e,"P",{}),Qe(P).forEach(t),this.h()},h(){Se(i,"name","hf:doc:metadata"),Se(i,"content",ts)},m(e,s){qe(document.head,i),l(e,j,s),l(e,r,s),l(e,M,s),w(J,e,s),l(e,D,s),l(e,b,s),l(e,q,s),l(e,$,s),l(e,K,s),w(T,e,s),l(e,O,s),l(e,U,s),l(e,ee,s),l(e,v,s),l(e,se,s),w(g,e,s),l(e,te,s),l(e,I,s),l(e,le,s),w(C,e,s),l(e,ae,s),l(e,k,s),l(e,ne,s),w(B,e,s),l(e,ie,s),w(y,e,s),l(e,oe,s),l(e,x,s),l(e,pe,s),w(Z,e,s),l(e,re,s),w(G,e,s),l(e,ce,s),l(e,W,s),l(e,me,s),w(_,e,s),l(e,he,s),l(e,N,s),l(e,we,s),w(R,e,s),l(e,de,s),l(e,Y,s),l(e,ue,s),w(X,e,s),l(e,fe,s),l(e,A,s),l(e,je,s),w(H,e,s),l(e,Me,s),l(e,Q,s),l(e,Te,s),l(e,S,s),l(e,ye,s),w(E,e,s),l(e,Je,s),l(e,V,s),l(e,be,s),w(F,e,s),l(e,$e,s),l(e,P,s),Ue=!0},p(e,[s]){const Ae={};s&2&&(Ae.$$scope={dirty:s,ctx:e}),T.$set(Ae);const He={};s&2&&(He.$$scope={dirty:s,ctx:e}),y.$set(He)},i(e){Ue||(d(J.$$.fragment,e),d(T.$$.fragment,e),d(g.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(y.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(_.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(H.$$.fragment,e),d(E.$$.fragment,e),d(F.$$.fragment,e),Ue=!0)},o(e){u(J.$$.fragment,e),u(T.$$.fragment,e),u(g.$$.fragment,e),u(C.$$.fragment,e),u(B.$$.fragment,e),u(y.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(_.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(H.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),Ue=!1},d(e){e&&(t(j),t(r),t(M),t(D),t(b),t(q),t($),t(K),t(O),t(U),t(ee),t(v),t(se),t(te),t(I),t(le),t(ae),t(k),t(ne),t(ie),t(oe),t(x),t(pe),t(re),t(ce),t(W),t(me),t(he),t(N),t(we),t(de),t(Y),t(ue),t(fe),t(A),t(je),t(Me),t(Q),t(Te),t(S),t(ye),t(Je),t(V),t(be),t($e),t(P)),t(i),f(J,e),f(T,e),f(g,e),f(C,e),f(B,e),f(y,e),f(Z,e),f(G,e),f(_,e),f(R,e),f(X,e),f(H,e),f(E,e),f(F,e)}}}const ts='{"title":"Server-side Audio Processing in Node.js","local":"server-side-audio-processing-in-nodejs","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Getting started","local":"getting-started","sections":[],"depth":2},{"title":"Creating the application","local":"creating-the-application","sections":[],"depth":2}],"depth":1}';function ls(z){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends ze{constructor(i){super(),Pe(this,i,ls,ss,Fe,{})}}export{rs as component};
