import{s as nm,n as im,o as mm}from"../chunks/scheduler.7bc62968.js";import{S as lm,i as rm,g as m,s as n,r as w,m as f,H as c,A as pm,h as l,f as t,c as i,j as o,u as x,x as p,n as u,B as g,k as $,l as h,y as r,a as e,v as _,d as b,t as L,w as C}from"../chunks/index.2f8492b0.js";import{H as M,E as om}from"../chunks/getInferenceSnippets.f5d646ec.js";function hm(gn){let V,Tt,dt,Pt,G,It,Z,dn="This section explains how stereo vision works and how it can be used to find the 3-dimensional structure of surrounding objects. Stereo vision involves capturing two or more images of the same scene from varying positions and viewpoints. These images can be obtained using multiple cameras or by repositioning the same camera.",Dt,J,Ht,Q,fn="Let’s understand the problem statement of finding the 3D structure of objects by understanding the geometry of image formation. As shown in Figure 1, we have a point P in 3D with x, y, z coordinates. Point P gets projected to the camera’s image plane via the pinhole. This can also be viewed as projecting a 3D point to a 2D image plane.",Ot,aa,un="Now, let’s say we are given this 2D image and the location of the pixel coordinates of point P in this image. We want to find the 3D coordinates of point P. Is this possible? Is point P unique, or are there other 3D points that also map to the same pixel coordinates as point P? Answer is that all 3D points that lie on the line joining point P, and the pinhole will map to the same pixel coordinates in the 2D image plane.",Rt,ta,vn="We aim to solve the problem of determining the 3D structure of objects. In our problem statement, we can represent an object in 3D as a set of 3D points. Finding the 3D coordinates of each of these points helps us determine the 3D structure of the object.",Et,T,yn='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/image_formation_single_camera.png?download=true" alt="Figure 1: Image formation using single camera"/> <p>Figure 1: Image formation using single camera</p>',qt,sa,At,ea,wn="Let’s assume we are given the following information:",jt,na,xn="<li>Single image of a scene point P</li> <li>Pixel coordinates of point P in the image</li> <li>Position and orientation of the camera used to capture the image. For simplicity, we can also place an XYZ coordinate system at the location of the pinhole, with the z-axis perpendicular to the image place and the x-axis, and y-axis parallel to the image plane like in Figure 1.</li> <li>Internal parameters of the camera, such as focal length and location of principal point. The principal point is where the optical axis intersects the image plane. Its location in the image plane is usually denoted as (Ox,Oy).</li>",St,ia,_n="With the information provided above, we can find a 3D line that originates from the pixel coordinates of point P (the projection of point P in the image plane), passes through the pinhole, and extends to infinity. Based on the principles of image formation geometry, we can conclude that point P must exist somewhere along this line.",Wt,ma,bn="<li>Initially (without an image) point P could have been present anywhere in the 3D space.</li> <li>Using a single image, we reduced possible locations of point P to a single line in 3D.</li> <li>Now, let’s consider whether we can further narrow down the potential locations to pinpoint the precise location of point P on this 3D line.</li> <li>Imagine moving the camera to a different position. Let the coordinate system remain fixed at the previous position. The 3D line we found also remains the same and point P still lies somewhere on this line.</li> <li>From this new location of the camera, capture another image of the same scene point P. Once more, utilizing the pixel coordinates of point P within this new image and considering the updated location of the camera pinhole, find the 3D line on which point P must lie.</li> <li>Now we have 2 lines in 3D and point P lies somewhere on both of these lines. So, point P must lie on the intersection of these 2 lines.</li>",Vt,la,Ln="Given 2 lines in 3D, there are are three possibilities for their intersection:",Ft,ra,Cn="<li>Intersect at exactly 1 point</li> <li>Intersect at infinite number of points</li> <li>Do not intersect</li>",Kt,pa,Mn="If both images (with original and new camera positions) contain point P, we can conclude that the 3D lines must intersect at least once and that the intersection point is point P. Furthermore, we can envision infinite points where both lines intersect only if the two lines are collinear. This is achievable if the pinhole at the new camera position lies somewhere on the original 3D line. For all other positions and orientations of the new camera location, the two 3D lines must intersect precisely at one point, where point P lies.",Ut,oa,kn="Therefore, using 2 images of the same scene point P, known positions and orientations of the camera locations, and known internal parameters of the camera, we can precisely find where point P lies in the 3D space.",Yt,ha,Bt,ca,$n="Since there are many different positions and orientations for the camera locations which can be selected, we can select a location that makes the math simpler, less complex, and reduces computational processing when running on a computer or an embedded device. One configuration that is popular and generally used is shown in Figure 2. We use 2 cameras in this configuration, which is equivalent to a single camera for capturing 2 images from 2 different locations.",Xt,P,zn='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/image_formation_simple_stereo.jpg?download=true" alt="Figure 2: Image formation using 2 cameras"/> <p>Figure 2: Image formation using 2 cameras</p>',Nt,ga,Tn="<li>Origin of the coordinate system is placed at the pinhole of the first camera which is usually the left camera.</li> <li>Z axis of the coordinate system is defined perpendicular to the image plane.</li> <li>X and Y axis of the coordinate system are defined parallel to the image plane.</li> <li>We also have X and Y directions in a 2D image. X is the horizontal direction and Y is the vertical direction. We will refer to these directions in the image plane as u and v respectively. Therefore, pixel coordinates of a point are defined using (u,v) values.</li> <li>X axis of the coordinate system is defined as the u direction / horizontal direction in the image plane.</li> <li>Similarly Y axis of the coordinate system is defined as the v direction / vertical direction in the image plane.</li> <li>Second camera (more precisely the pinhole of the second camera) is placed at a distance b called baseline in the positive x direction to the right of the first camera. Therefore, x,y,z coordinates of pinhole of second camera are (b,0,0).</li> <li>Image plane of the second camera is oriented parallel to the image plane of the first camera.</li> <li>u and v directions in the image plane of second/right camera are aligned with the u and v directions in the image plane of the first/left camera.</li> <li>Both left and right cameras are assumed to have the same intrinsic parameters like focal length and location of principal point.</li>",Gt,da,Pn="With the above configuration in place, we have the below equations which map a point in 3D to the image plane in 2D.",Zt,F,at,We,fa,ft,Jt,Ii='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo>∗</mo><mfrac><mi>x</mi><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">u\\_left = f\\_x * \\frac{x}{z} + O\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0404em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6954em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',Ve,ut,Qt,Di='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo>∗</mo><mfrac><mi>y</mi><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">v\\_left = f\\_y * \\frac{y}{z} + O\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0925em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7475em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.4461em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',Fe,tt,Ke,ua,vt,as,Hi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo>∗</mo><mfrac><mrow><mi>x</mi><mo>−</mo><mi>b</mi></mrow><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">u\\_right = f\\_x * \\frac{x-b}{z} + O\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.2251em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8801em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">b</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',Ue,yt,ts,Oi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo>∗</mo><mfrac><mi>y</mi><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">v\\_right = f\\_y * \\frac{y}{z} + O\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0925em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7475em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.4461em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',ss,va,In="Different symbols used in above equations are defined below:",es,v,K,ns,Ri='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',is,ms,Ei='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',ls,Ye,U,rs,qi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',ps,os,Ai='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',hs,Be,Y,cs,ji='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">f\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',gs,ds,Si='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">f\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',fs,Xe,st,Dn="x, y, z are 3D coordinates of the point P (any unit like cm, feet, etc can be used).",Ne,B,us,Wi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">O\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',vs,ys,Vi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">O\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',ws,Ge,et,Hn="b is called the baseline and refers to the distance between the left and right cameras. Same units are used for both b and x,y,z coordinates (any unit like cm, feet, etc can be used).",xs,ya,On="We have 4 equations above and 3 unknowns - x, y and z coordinates of a 3D point P. Intrinsic camera parameters - focal lengths and principal point are assumed to be known. Equations 1.2 and 2.2 indicate that the v coordinate value in the left and right images is the same.",_s,wa,wt,bs,Fi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_left = v\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Ls,xa,Rn="Using equations 1.1, 1.2 and 2.1 we can derive the x,y,z coordinates of point P.",Cs,z,xt,Ms,Ki='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>x</mi><mo>=</mo><mfrac><mrow><mi>b</mi><mo>∗</mo><mo stretchy="false">(</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo stretchy="false">)</mo></mrow><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow></mfrac></mrow><annotation encoding="application/x-tex">x = \\frac{b * (u\\_left - O\\_x)}{u\\_left - u\\_right}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.614em;vertical-align:-0.562em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.052em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span><span class="mord mathnormal mtight">i</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span><span class="mord mathnormal mtight">h</span><span class="mord mathnormal mtight">t</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.527em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mbin mtight">∗</span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">O</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight">x</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.562em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',Ze,_t,ks,Ui='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>y</mi><mo>=</mo><mfrac><mrow><mi>b</mi><mo>∗</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo>∗</mo><mo stretchy="false">(</mo><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo stretchy="false">)</mo></mrow><mrow><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo>∗</mo><mo stretchy="false">(</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi><mo stretchy="false">)</mo></mrow></mfrac></mrow><annotation encoding="application/x-tex">y = \\frac{b * f\\_x * (v\\_left - O\\_y)}{ f\\_y * (u\\_left - u\\_right)}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.614em;vertical-align:-0.562em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.052em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span><span class="mbin mtight">∗</span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span><span class="mord mathnormal mtight">i</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span><span class="mord mathnormal mtight">h</span><span class="mord mathnormal mtight">t</span><span class="mclose mtight">)</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.527em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mbin mtight">∗</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight">x</span><span class="mbin mtight">∗</span><span class="mopen mtight">(</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">v</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">O</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.562em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',Je,bt,$s,Yi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>z</mi><mo>=</mo><mfrac><mrow><mi>b</mi><mo>∗</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow></mfrac></mrow><annotation encoding="application/x-tex">z = \\frac{b * f\\_x}{u\\_left - u\\_right}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.5751em;vertical-align:-0.562em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.0131em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span><span class="mord mathnormal mtight">i</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span><span class="mord mathnormal mtight">h</span><span class="mord mathnormal mtight">t</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.527em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mbin mtight">∗</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.562em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',zs,_a,En="Note that the x and y values above concern the left camera since the origin of the coordinate system is aligned with the left camera. The above equations show that we can find 3D coordinates of a point P using its 2 images captured from 2 different camera locations. z value is also referred to as the depth value. Using this technique, we can find the depth values for different pixels within an image and their real-world x and y coordinates. We can also find real-world distances between different points in an image.",Ts,ba,Ps,La,Is,Ca,qn="We’ll work through an example, capture some images, and perform some calculations to find out if our above assumptions and math work out! For capturing the images we’ll use a hardware known as OAK-D Lite (OAK stands for OpenCV AI Kit). This device has 3 cameras - left and right mono (black and white) and a center color cameras. We’ll use the left and right mono cameras for our experiment. A regular smartphone camera could also be used, but OAK-D lite has some advantages listed below.",Ds,Ma,An="<li>Intrinsic camera parameters like focal length and location of principal point are known for an OAK-D Lite since the device comes pre-calibrated, and these parameters can be read from the device using its Python API. For a smartphone camera, intrinsic parameters need to be determined and could be found by performing camera calibration or sometimes present in the metadata of the image captured using the smartphone.</li> <li>One of the main assumptions above is that the position and orientation of the left and right cameras are known. Using a smartphone camera, it may be difficult to determine this information or additional calibration may be required.  On the other hand, for an OAK-D Lite device, the position and orientation of the left and right cameras are fixed, known, pre-calibrated, and very similar to the geometry of the simplified solution mentioned above. Although some post-processing/image rectification detailed below on the raw images is still required.</li>",Hs,ka,Os,$a,jn="The left and right cameras in OAK-D Lite are oriented similarly to the geometry of the simplified solution detailed above. The baseline distance between the left and right cameras is 7.5cm. Left and right images of a scene captured using this device are shown below. The figure also shows these images stacked horizontally with a red line drawn at a constant height (i.e. at a constant v value ). We’ll refer to the horizontal x-axis as u and the vertical y-axis as v.",Rs,za,Sn="Raw Left Image",Es,I,Wn='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_left_frame.jpg?download=true" alt="Raw Left Image"/>',qs,Ta,Vn="Raw Right Image",As,D,Fn='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_right_frame.jpg?download=true" alt="Raw Right Image"/>',js,Pa,Kn="Raw Stacked Left and Right Images",Ss,H,Un='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_stacked_frames.jpg?download=true" alt="Raw Stacked Left and Right Images"/>',Ws,X,Qe,Vs,Bi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_left = v\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Fs,Ks,Ia,Yn="<li>The intrinsic parameters for the left and right cameras are different. The principal point for the left camera is at (319.13, 233.86), whereas it is (298.85, 245.52) for the right camera. The focal length for the left camera is 450.9, whereas it is 452.9 for the right camera. The values of fx are equal to fy for both the left and right cameras. These intrinsic parameters were read from the device using it’s python API and could be different for different OAK-D Lite devices.</li> <li>Left and right camera orientations differ slightly from the geometry of the simplified solution detailed above.</li>",Us,Da,Ys,Ha,Bn='We can perform image rectification/post-processing to correct for differences in intrinsic parameters and orientations of the left and right cameras. This process involves performing 3x3 matrix transformations. In the OAK-D Lite API, a stereo node performs these calculations and outputs the rectified left and right images. Details and source code can be viewed <a href="https://github.com/luxonis/depthai-experiments/blob/master/gen2-stereo-on-host/main.py" rel="nofollow">here</a>. In this specific implementation, correction for intrinsic parameters is performed using intrinsic camera matrices, and correction for orientation is performed using rotation matrices(part of calibration parameters) for the left and right cameras. The rectified left image is transformed as if the left camera had the same intrinsic parameters as the right one. Therefore, in all our following calculations, we’ll use the intrinsic parameters for the right camera i.e. focal length of 452.9 and principal point at (298.85, 245.52). In the rectified and stacked images below, notice that the red line at constant v touches the top-left corner of the laptop in both the left and right images.',Bs,Oa,Xn="Rectified Left Image",Xs,O,Nn='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_left_frame.jpg?download=true" alt="Rectified Left Image"/>',Ns,Ra,Gn="Rectified Right Image",Gs,R,Zn='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_right_frame.jpg?download=true" alt="Rectified Right Image"/>',Zs,Ea,Jn="Rectified and Stacked Left and Right Images",Js,E,Qn='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_stacked_frames.jpg?download=true" alt="Rectified and Stacked Left and Right Images"/>',Qs,q,an,ae,Xi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left - u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',te,se,Ni='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left - u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',ee,ne,qa,ai="Rectified and Overlapped Left and Right Images",ie,A,ti='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_overlapping_frames.jpg?download=true" alt="Rectified and Overlapped Left and Right Images"/>',me,Aa,le,ja,si="Let’s find the 3D coordinates for some points in the scene. A few points are selected and manually annotated with their (u,v) values, as shown in the figures below. Instead of manual annotations, we can also use template-based matching, feature detection algorithms like SIFT, etc for finding corresponding points in left and right images.",re,Sa,ei="Annotated Left Image",pe,j,ni='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/annotated_left_img.jpg?download=true" alt="Annotated Left Image"/>',oe,Wa,ii="Annotated Right Image",he,S,mi='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/annotated_right_img.jpg?download=true" alt="Annotated Right Image"/>',ce,Va,ge,Fa,li="Twelve points are selected in the scene, and their (u,v) values in the left and right images are tabulated below. Using equations 4, 5, and 6, (x,y,z) coordinates for these points are also calculated and tabulated below. X and Y coordinates concerning the left camera, and the origin is at the left camera’s pinhole (or optical center of the lens). Therefore, 3D points left and above the pinhole have negative X and Y values, respectively.",de,N,Lt,d,Ka,ri="point",tn,nt,fe,Gi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',sn,it,ue,Zi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',en,mt,ve,Ji='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',nn,lt,ye,Qi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',mn,Ua,pi="depth/z(cm)",ln,rt,we,am='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>x</mi><mi mathvariant="normal">_</mi><mi>w</mi><mi>r</mi><mi>t</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">x\\_wrt\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">x</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">t</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',rn,pt,xe,tm='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>y</mi><mi mathvariant="normal">_</mi><mi>w</mi><mi>r</mi><mi>t</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">y\\_wrt\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">t</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',pn,ot,oi='<tr><td align="center">pt1</td> <td align="center">138</td> <td align="center">219</td> <td align="center">102</td> <td align="center">219</td> <td align="center">94.36</td> <td align="center">-33.51</td> <td align="center">-5.53</td></tr> <tr><td align="center">pt2</td> <td align="center">264</td> <td align="center">216</td> <td align="center">234</td> <td align="center">217</td> <td align="center">113.23</td> <td align="center">-8.72</td> <td align="center">-7.38</td></tr> <tr><td align="center">pt3</td> <td align="center">137</td> <td align="center">320</td> <td align="center">101</td> <td align="center">321</td> <td align="center">94.36</td> <td align="center">-33.72</td> <td align="center">15.52</td></tr> <tr><td align="center">pt4</td> <td align="center">263</td> <td align="center">303</td> <td align="center">233</td> <td align="center">302</td> <td align="center">113.23</td> <td align="center">-8.97</td> <td align="center">14.37</td></tr> <tr><td align="center">pt5</td> <td align="center">307</td> <td align="center">211</td> <td align="center">280</td> <td align="center">211</td> <td align="center">125.81</td> <td align="center">2.26</td> <td align="center">-9.59</td></tr> <tr><td align="center">pt6</td> <td align="center">367</td> <td align="center">212</td> <td align="center">339</td> <td align="center">212</td> <td align="center">121.32</td> <td align="center">18.25</td> <td align="center">-8.98</td></tr> <tr><td align="center">pt7</td> <td align="center">305</td> <td align="center">298</td> <td align="center">278</td> <td align="center">298</td> <td align="center">125.81</td> <td align="center">1.71</td> <td align="center">14.58</td></tr> <tr><td align="center">pt8</td> <td align="center">365</td> <td align="center">299</td> <td align="center">338</td> <td align="center">299</td> <td align="center">125.81</td> <td align="center">18.37</td> <td align="center">14.86</td></tr> <tr><td align="center">pt9</td> <td align="center">466</td> <td align="center">225</td> <td align="center">415</td> <td align="center">225</td> <td align="center">66.61</td> <td align="center">24.58</td> <td align="center">-3.02</td></tr> <tr><td align="center">pt10</td> <td align="center">581</td> <td align="center">225</td> <td align="center">530</td> <td align="center">226</td> <td align="center">66.61</td> <td align="center">41.49</td> <td align="center">-3.02</td></tr> <tr><td align="center">pt11</td> <td align="center">464</td> <td align="center">387</td> <td align="center">413</td> <td align="center">388</td> <td align="center">66.61</td> <td align="center">24.29</td> <td align="center">20.81</td></tr> <tr><td align="center">pt12</td> <td align="center">579</td> <td align="center">388</td> <td align="center">528</td> <td align="center">390</td> <td align="center">66.61</td> <td align="center">41.2</td> <td align="center">20.95</td></tr>',_e,Ya,be,W,on,Le,sm=`<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>d</mi><mi>i</mi><mi>s</mi><mi>t</mi><mi>a</mi><mi>n</mi><mi>c</mi><mi>e</mi><mo>=</mo><msqrt><mrow><mo stretchy="false">(</mo><mi>x</mi><mi mathvariant="normal">_</mi><mn>2</mn><mo>−</mo><mi>x</mi><mi mathvariant="normal">_</mi><mn>1</mn><msup><mo stretchy="false">)</mo><mn>2</mn></msup><mo>+</mo><mo stretchy="false">(</mo><mi>y</mi><mi mathvariant="normal">_</mi><mn>2</mn><mo>−</mo><mi>y</mi><mi mathvariant="normal">_</mi><mn>1</mn><msup><mo stretchy="false">)</mo><mn>2</mn></msup><mo>+</mo><mo stretchy="false">(</mo><mi>z</mi><mi mathvariant="normal">_</mi><mn>2</mn><mo>−</mo><mi>z</mi><mi mathvariant="normal">_</mi><mn>1</mn><msup><mo stretchy="false">)</mo><mn>2</mn></msup></mrow></msqrt></mrow><annotation encoding="application/x-tex">distance = \\sqrt{(x\\_2 - x\\_1)^2 + (y\\_2 - y\\_1)^2 + (z\\_2 - z\\_1)^2}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">d</span><span class="mord mathnormal">i</span><span class="mord mathnormal">s</span><span class="mord mathnormal">t</span><span class="mord mathnormal">an</span><span class="mord mathnormal">ce</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.24em;vertical-align:-0.335em;"></span><span class="mord sqrt"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.905em;"><span class="svg-align" style="top:-3.2em;"><span class="pstrut" style="height:3.2em;"></span><span class="mord" style="padding-left:1em;"><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mord">_2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal">x</span><span class="mord">_1</span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7401em;"><span style="top:-2.989em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mord">_2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mord">_1</span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7401em;"><span style="top:-2.989em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span><span class="mord">_2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span><span class="mord">_1</span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7401em;"><span style="top:-2.989em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span><span style="top:-2.865em;"><span class="pstrut" style="height:3.2em;"></span><span class="hide-tail" style="min-width:1.02em;height:1.28em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='1.28em' viewBox='0 0 400000 1296' preserveAspectRatio='xMinYMin slice'><path d='M263,681c0.7,0,18,39.7,52,119
c34,79.3,68.167,158.7,102.5,238c34.3,79.3,51.8,119.3,52.5,120
c340,-704.7,510.7,-1060.3,512,-1067
l0 -0
c4.7,-7.3,11,-11,19,-11
H40000v40H1012.3
s-271.3,567,-271.3,567c-38.7,80.7,-84,175,-136,283c-52,108,-89.167,185.3,-111.5,232
c-22.3,46.7,-33.8,70.3,-34.5,71c-4.7,4.7,-12.3,7,-23,7s-12,-1,-12,-1
s-109,-253,-109,-253c-72.7,-168,-109.3,-252,-110,-252c-10.7,8,-22,16.7,-34,26
c-22,17.3,-33.3,26,-34,26s-26,-26,-26,-26s76,-59,76,-59s76,-60,76,-60z
M1001 80h400000v40h-400000z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.335em;"><span></span></span></span></span></span></span></span></span>`,Ce,Me,em='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><mfrac><mrow><mo stretchy="false">(</mo><mi>a</mi><mi>c</mi><mi>t</mi><mi>u</mi><mi>a</mi><mi>l</mi><mo>−</mo><mi>m</mi><mi>e</mi><mi>a</mi><mi>s</mi><mi>u</mi><mi>r</mi><mi>e</mi><mi>d</mi><mo stretchy="false">)</mo><mo>∗</mo><mn>100</mn></mrow><mrow><mi>a</mi><mi>c</mi><mi>t</mi><mi>u</mi><mi>a</mi><mi>l</mi></mrow></mfrac></mrow><annotation encoding="application/x-tex">( \\frac{(actual-measured) * 100}{actual}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.355em;vertical-align:-0.345em;"></span><span class="mopen">(</span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.01em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight">c</span><span class="mord mathnormal mtight">t</span><span class="mord mathnormal mtight">u</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.485em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mopen mtight">(</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight">c</span><span class="mord mathnormal mtight">t</span><span class="mord mathnormal mtight">u</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">m</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight">s</span><span class="mord mathnormal mtight">u</span><span class="mord mathnormal mtight">re</span><span class="mord mathnormal mtight">d</span><span class="mclose mtight">)</span><span class="mbin mtight">∗</span><span class="mord mtight">100</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',ke,$e,Ba,hi='<thead><tr><th align="center">dimension</th> <th align="center">calculated(cm)</th> <th align="center">actual(cm)</th> <th align="center">% error</th></tr></thead> <tbody><tr><td align="center">d1(1-2)</td> <td align="center">31.2</td> <td align="center">31.2</td> <td align="center">0</td></tr> <tr><td align="center">d2(1-3)</td> <td align="center">21.1</td> <td align="center">21.3</td> <td align="center">0.94</td></tr> <tr><td align="center">d3(5-6)</td> <td align="center">16.6</td> <td align="center">16.7</td> <td align="center">0.6</td></tr> <tr><td align="center">d4(5-7)</td> <td align="center">24.2</td> <td align="center">24</td> <td align="center">0.83</td></tr> <tr><td align="center">d5(9-10)</td> <td align="center">16.9</td> <td align="center">16.7</td> <td align="center">1.2</td></tr> <tr><td align="center">d6(9-11)</td> <td align="center">23.8</td> <td align="center">24</td> <td align="center">0.83</td></tr></tbody>',ze,Xa,ci='Calculated Dimension Results<br/> <img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/calculated_dim_results.png?download=true" alt="Calculated Dimension Results"/>',Te,Na,Pe,Ga,gi="<li>In summary, we learned how stereo vision works, the equations used to find the real-world coordinates (x, y, z) of a point P given its two images captured from different viewpoints, and compared theoretical values with experimental results.</li> <li>We assumed that the intrinsic parameters - focal length and principal point of the cameras - are known, along with their position and orientation information. This is also referred to as calibrated stereo vision.</li> <li>Interestingly, it is also possible to find the 3D coordinates of a point, P, if the position and orientation of the cameras are unknown. In fact, the position and orientation of the cameras with respect to each other can be found using the images themselves. This is referred to as uncalibrated stereo vision!</li>",Ie,Za,De,Ja,di='<li>3D Reconstruction - Multiple Viewpoints <a href="https://www.coursera.org/learn/3d-reconstruction-multiple-viewpoints" rel="nofollow">Coursera</a></li> <li>Stereo Vision and Depth Estimation using OpenCV AI Kit <a href="https://learnopencv.com/stereo-vision-and-depth-estimation-using-opencv-ai-kit/" rel="nofollow">LearnOpenCV</a></li> <li>OAK-D Lite <a href="https://docs.luxonis.com/projects/hardware/en/latest/pages/DM9095/" rel="nofollow">Luxonics</a></li>',He,Qa,Oe,Ct,Re;return G=new M({props:{title:"Introduction",local:"introduction",headingTag:"h1"}}),J=new M({props:{title:"Problem Statement",local:"problem-statement",headingTag:"h2"}}),sa=new M({props:{title:"Solution",local:"solution",headingTag:"h2"}}),ha=new M({props:{title:"Simplified Solution",local:"simplified-solution",headingTag:"h2"}}),ba=new M({props:{title:"Demo",local:"demo",headingTag:"h2"}}),La=new M({props:{title:"Setup",local:"setup",headingTag:"h3"}}),ka=new M({props:{title:"Raw Left and Right Images",local:"raw-left-and-right-images",headingTag:"h3"}}),Da=new M({props:{title:"Rectified Left and Right Images",local:"rectified-left-and-right-images",headingTag:"h3"}}),Aa=new M({props:{title:"Annotated Left and Right Rectified Images",local:"annotated-left-and-right-rectified-images",headingTag:"h3"}}),Va=new M({props:{title:"3D Coordinate Calculations",local:"3d-coordinate-calculations",headingTag:"h3"}}),Ya=new M({props:{title:"Dimension Calculations and Accuracy",local:"dimension-calculations-and-accuracy",headingTag:"h3"}}),Na=new M({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Za=new M({props:{title:"References",local:"references",headingTag:"h2"}}),Qa=new om({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit8/3d_measurements_stereo_vision.mdx"}}),{c(){V=m("meta"),Tt=n(),dt=m("p"),Pt=n(),w(G.$$.fragment),It=n(),Z=m("p"),Z.textContent=dn,Dt=n(),w(J.$$.fragment),Ht=n(),Q=m("p"),Q.textContent=fn,Ot=n(),aa=m("p"),aa.textContent=un,Rt=n(),ta=m("p"),ta.textContent=vn,Et=n(),T=m("div"),T.innerHTML=yn,qt=n(),w(sa.$$.fragment),At=n(),ea=m("p"),ea.textContent=wn,jt=n(),na=m("ol"),na.innerHTML=xn,St=n(),ia=m("p"),ia.textContent=_n,Wt=n(),ma=m("ol"),ma.innerHTML=bn,Vt=n(),la=m("p"),la.textContent=Ln,Ft=n(),ra=m("ol"),ra.innerHTML=Cn,Kt=n(),pa=m("p"),pa.textContent=Mn,Ut=n(),oa=m("p"),oa.textContent=kn,Yt=n(),w(ha.$$.fragment),Bt=n(),ca=m("p"),ca.textContent=$n,Xt=n(),P=m("div"),P.innerHTML=zn,Nt=n(),ga=m("ol"),ga.innerHTML=Tn,Gt=n(),da=m("p"),da.textContent=Pn,Zt=n(),F=m("ol"),at=m("li"),We=f("Left camera  "),fa=m("ol"),ft=m("li"),Jt=new c(!1),Ve=n(),ut=m("li"),Qt=new c(!1),Fe=n(),tt=m("li"),Ke=f("Right camera   "),ua=m("ol"),vt=m("li"),as=new c(!1),Ue=n(),yt=m("li"),ts=new c(!1),ss=n(),va=m("p"),va.textContent=In,es=n(),v=m("ul"),K=m("li"),ns=new c(!1),is=f(","),ms=new c(!1),ls=f(" refer to pixel coordinates of point P in the left image."),Ye=n(),U=m("li"),rs=new c(!1),ps=f(", "),os=new c(!1),hs=f(" refer to pixel coordinates of point P in the right image."),Be=n(),Y=m("li"),cs=new c(!1),gs=f(" refers to the focal length (in pixels) in x direction and"),ds=new c(!1),fs=f(" refers to the focal length (in pixels) in y direction. Actually, there is only 1 focal length for a camera which is the distance between the pinhole (optical center of the lens) to the image plane. However, pixels may be rectangular and not perfect squares, resulting in different fx and fy values when we represent f in terms of pixels."),Xe=n(),st=m("li"),st.textContent=Dn,Ne=n(),B=m("li"),us=new c(!1),vs=f("  and "),ys=new c(!1),ws=f("  refer to pixel coordinates of the principal point."),Ge=n(),et=m("li"),et.textContent=Hn,xs=n(),ya=m("p"),ya.textContent=On,_s=n(),wa=m("ol"),wt=m("li"),bs=new c(!1),Ls=n(),xa=m("p"),xa.textContent=Rn,Cs=n(),z=m("ol"),xt=m("li"),Ms=new c(!1),Ze=n(),_t=m("li"),ks=new c(!1),Je=n(),bt=m("li"),$s=new c(!1),zs=n(),_a=m("p"),_a.textContent=En,Ts=n(),w(ba.$$.fragment),Ps=n(),w(La.$$.fragment),Is=n(),Ca=m("p"),Ca.textContent=qn,Ds=n(),Ma=m("ul"),Ma.innerHTML=An,Hs=n(),w(ka.$$.fragment),Os=n(),$a=m("p"),$a.textContent=jn,Rs=n(),za=m("p"),za.textContent=Sn,Es=n(),I=m("div"),I.innerHTML=Wn,qs=n(),Ta=m("p"),Ta.textContent=Vn,As=n(),D=m("div"),D.innerHTML=Fn,js=n(),Pa=m("p"),Pa.textContent=Kn,Ss=n(),H=m("div"),H.innerHTML=Un,Ws=n(),X=m("p"),Qe=f("Let’s focus on a single point - the top left corner of the laptop. As per equation 3 above, "),Vs=new c(!1),Fs=f("  for the same point in the left and right images. However, notice that the red line, which is at a constant v value, touches the top-left corner of the laptop in the left image but misses this point by a few pixels in the right image. There are two main reasons for this discrepancy:"),Ks=n(),Ia=m("ul"),Ia.innerHTML=Yn,Us=n(),w(Da.$$.fragment),Ys=n(),Ha=m("p"),Ha.innerHTML=Bn,Bs=n(),Oa=m("p"),Oa.textContent=Xn,Xs=n(),O=m("div"),O.innerHTML=Nn,Ns=n(),Ra=m("p"),Ra.textContent=Gn,Gs=n(),R=m("div"),R.innerHTML=Zn,Zs=n(),Ea=m("p"),Ea.textContent=Jn,Js=n(),E=m("div"),E.innerHTML=Qn,Qs=n(),q=m("p"),an=f("Let’s also overlap the rectified left and right images to see the difference. We can see that the v values for different points remain mostly constant in the left and right images. However, the u values change, and this difference in the u values helps us find the depth information for different points in the scene, as shown in Equation 6 above. This difference in ‘u’ values"),ae=new c(!1),te=f(" is called disparity, and we can notice that the disparity for points near the camera is greater compared to points further away. Depth z and disparity "),se=new c(!1),ee=f("  are inversely proportional, as shown in equation 6."),ne=n(),qa=m("p"),qa.textContent=ai,ie=n(),A=m("div"),A.innerHTML=ti,me=n(),w(Aa.$$.fragment),le=n(),ja=m("p"),ja.textContent=si,re=n(),Sa=m("p"),Sa.textContent=ei,pe=n(),j=m("div"),j.innerHTML=ni,oe=n(),Wa=m("p"),Wa.textContent=ii,he=n(),S=m("div"),S.innerHTML=mi,ce=n(),w(Va.$$.fragment),ge=n(),Fa=m("p"),Fa.textContent=li,de=n(),N=m("table"),Lt=m("thead"),d=m("tr"),Ka=m("th"),Ka.textContent=ri,tn=n(),nt=m("th"),fe=new c(!1),sn=n(),it=m("th"),ue=new c(!1),en=n(),mt=m("th"),ve=new c(!1),nn=n(),lt=m("th"),ye=new c(!1),mn=n(),Ua=m("th"),Ua.textContent=pi,ln=n(),rt=m("th"),we=new c(!1),rn=n(),pt=m("th"),xe=new c(!1),pn=n(),ot=m("tbody"),ot.innerHTML=oi,_e=n(),w(Ya.$$.fragment),be=n(),W=m("p"),on=f("We can also compute 3D distances between different points using their (x,y,z) values using the formulae"),Le=new c(!1),Ce=f(". Computed distances between some of the points are tabulated below along with their actual measured values. Percentage error"),Me=new c(!1),ke=f(") is also computed and tabulated. Notice that the calculated and actual values match very well with a percentage error of 1.2% or less."),$e=n(),Ba=m("table"),Ba.innerHTML=hi,ze=n(),Xa=m("p"),Xa.innerHTML=ci,Te=n(),w(Na.$$.fragment),Pe=n(),Ga=m("ol"),Ga.innerHTML=gi,Ie=n(),w(Za.$$.fragment),De=n(),Ja=m("ol"),Ja.innerHTML=di,He=n(),w(Qa.$$.fragment),Oe=n(),Ct=m("p"),this.h()},l(a){const s=pm("svelte-u9bgzb",document.head);V=l(s,"META",{name:!0,content:!0}),s.forEach(t),Tt=i(a),dt=l(a,"P",{}),o(dt).forEach(t),Pt=i(a),x(G.$$.fragment,a),It=i(a),Z=l(a,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-dalhkv"&&(Z.textContent=dn),Dt=i(a),x(J.$$.fragment,a),Ht=i(a),Q=l(a,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1uco4qc"&&(Q.textContent=fn),Ot=i(a),aa=l(a,"P",{"data-svelte-h":!0}),p(aa)!=="svelte-kimr6l"&&(aa.textContent=un),Rt=i(a),ta=l(a,"P",{"data-svelte-h":!0}),p(ta)!=="svelte-q94rlb"&&(ta.textContent=vn),Et=i(a),T=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(T)!=="svelte-1yj2u6"&&(T.innerHTML=yn),qt=i(a),x(sa.$$.fragment,a),At=i(a),ea=l(a,"P",{"data-svelte-h":!0}),p(ea)!=="svelte-1nrdwlc"&&(ea.textContent=wn),jt=i(a),na=l(a,"OL",{"data-svelte-h":!0}),p(na)!=="svelte-o6t2o7"&&(na.innerHTML=xn),St=i(a),ia=l(a,"P",{"data-svelte-h":!0}),p(ia)!=="svelte-16e7hw4"&&(ia.textContent=_n),Wt=i(a),ma=l(a,"OL",{"data-svelte-h":!0}),p(ma)!=="svelte-t58y5k"&&(ma.innerHTML=bn),Vt=i(a),la=l(a,"P",{"data-svelte-h":!0}),p(la)!=="svelte-iezcon"&&(la.textContent=Ln),Ft=i(a),ra=l(a,"OL",{"data-svelte-h":!0}),p(ra)!=="svelte-46wk7g"&&(ra.innerHTML=Cn),Kt=i(a),pa=l(a,"P",{"data-svelte-h":!0}),p(pa)!=="svelte-zaapl6"&&(pa.textContent=Mn),Ut=i(a),oa=l(a,"P",{"data-svelte-h":!0}),p(oa)!=="svelte-1t8agog"&&(oa.textContent=kn),Yt=i(a),x(ha.$$.fragment,a),Bt=i(a),ca=l(a,"P",{"data-svelte-h":!0}),p(ca)!=="svelte-qw6123"&&(ca.textContent=$n),Xt=i(a),P=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(P)!=="svelte-1nq48lb"&&(P.innerHTML=zn),Nt=i(a),ga=l(a,"OL",{"data-svelte-h":!0}),p(ga)!=="svelte-1skle5"&&(ga.innerHTML=Tn),Gt=i(a),da=l(a,"P",{"data-svelte-h":!0}),p(da)!=="svelte-1tijo6x"&&(da.textContent=Pn),Zt=i(a),F=l(a,"OL",{});var Ee=o(F);at=l(Ee,"LI",{});var hn=o(at);We=u(hn,"Left camera  "),fa=l(hn,"OL",{});var qe=o(fa);ft=l(qe,"LI",{});var fi=o(ft);Jt=g(fi,!1),fi.forEach(t),Ve=i(qe),ut=l(qe,"LI",{});var ui=o(ut);Qt=g(ui,!1),ui.forEach(t),qe.forEach(t),hn.forEach(t),Fe=i(Ee),tt=l(Ee,"LI",{});var cn=o(tt);Ke=u(cn,"Right camera   "),ua=l(cn,"OL",{});var Ae=o(ua);vt=l(Ae,"LI",{});var vi=o(vt);as=g(vi,!1),vi.forEach(t),Ue=i(Ae),yt=l(Ae,"LI",{});var yi=o(yt);ts=g(yi,!1),yi.forEach(t),Ae.forEach(t),cn.forEach(t),Ee.forEach(t),ss=i(a),va=l(a,"P",{"data-svelte-h":!0}),p(va)!=="svelte-qh7m8q"&&(va.textContent=In),es=i(a),v=l(a,"UL",{});var k=o(v);K=l(k,"LI",{});var Mt=o(K);ns=g(Mt,!1),is=u(Mt,","),ms=g(Mt,!1),ls=u(Mt," refer to pixel coordinates of point P in the left image."),Mt.forEach(t),Ye=i(k),U=l(k,"LI",{});var kt=o(U);rs=g(kt,!1),ps=u(kt,", "),os=g(kt,!1),hs=u(kt," refer to pixel coordinates of point P in the right image."),kt.forEach(t),Be=i(k),Y=l(k,"LI",{});var $t=o(Y);cs=g($t,!1),gs=u($t," refers to the focal length (in pixels) in x direction and"),ds=g($t,!1),fs=u($t," refers to the focal length (in pixels) in y direction. Actually, there is only 1 focal length for a camera which is the distance between the pinhole (optical center of the lens) to the image plane. However, pixels may be rectangular and not perfect squares, resulting in different fx and fy values when we represent f in terms of pixels."),$t.forEach(t),Xe=i(k),st=l(k,"LI",{"data-svelte-h":!0}),p(st)!=="svelte-mj7id9"&&(st.textContent=Dn),Ne=i(k),B=l(k,"LI",{});var zt=o(B);us=g(zt,!1),vs=u(zt,"  and "),ys=g(zt,!1),ws=u(zt,"  refer to pixel coordinates of the principal point."),zt.forEach(t),Ge=i(k),et=l(k,"LI",{"data-svelte-h":!0}),p(et)!=="svelte-1u3fbkk"&&(et.textContent=Hn),k.forEach(t),xs=i(a),ya=l(a,"P",{"data-svelte-h":!0}),p(ya)!=="svelte-uxu6gh"&&(ya.textContent=On),_s=i(a),wa=l(a,"OL",{start:!0});var wi=o(wa);wt=l(wi,"LI",{});var xi=o(wt);bs=g(xi,!1),xi.forEach(t),wi.forEach(t),Ls=i(a),xa=l(a,"P",{"data-svelte-h":!0}),p(xa)!=="svelte-xl9yi3"&&(xa.textContent=Rn),Cs=i(a),z=l(a,"OL",{start:!0});var ht=o(z);xt=l(ht,"LI",{});var _i=o(xt);Ms=g(_i,!1),_i.forEach(t),Ze=i(ht),_t=l(ht,"LI",{});var bi=o(_t);ks=g(bi,!1),bi.forEach(t),Je=i(ht),bt=l(ht,"LI",{});var Li=o(bt);$s=g(Li,!1),Li.forEach(t),ht.forEach(t),zs=i(a),_a=l(a,"P",{"data-svelte-h":!0}),p(_a)!=="svelte-6ra58q"&&(_a.textContent=En),Ts=i(a),x(ba.$$.fragment,a),Ps=i(a),x(La.$$.fragment,a),Is=i(a),Ca=l(a,"P",{"data-svelte-h":!0}),p(Ca)!=="svelte-1d7pwai"&&(Ca.textContent=qn),Ds=i(a),Ma=l(a,"UL",{"data-svelte-h":!0}),p(Ma)!=="svelte-woii1q"&&(Ma.innerHTML=An),Hs=i(a),x(ka.$$.fragment,a),Os=i(a),$a=l(a,"P",{"data-svelte-h":!0}),p($a)!=="svelte-1p5cc63"&&($a.textContent=jn),Rs=i(a),za=l(a,"P",{"data-svelte-h":!0}),p(za)!=="svelte-dgnx0u"&&(za.textContent=Sn),Es=i(a),I=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(I)!=="svelte-1c2ixyv"&&(I.innerHTML=Wn),qs=i(a),Ta=l(a,"P",{"data-svelte-h":!0}),p(Ta)!=="svelte-14q1ful"&&(Ta.textContent=Vn),As=i(a),D=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(D)!=="svelte-xdxujf"&&(D.innerHTML=Fn),js=i(a),Pa=l(a,"P",{"data-svelte-h":!0}),p(Pa)!=="svelte-1adsomb"&&(Pa.textContent=Kn),Ss=i(a),H=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(H)!=="svelte-j4gmyb"&&(H.innerHTML=Un),Ws=i(a),X=l(a,"P",{});var je=o(X);Qe=u(je,"Let’s focus on a single point - the top left corner of the laptop. As per equation 3 above, "),Vs=g(je,!1),Fs=u(je,"  for the same point in the left and right images. However, notice that the red line, which is at a constant v value, touches the top-left corner of the laptop in the left image but misses this point by a few pixels in the right image. There are two main reasons for this discrepancy:"),je.forEach(t),Ks=i(a),Ia=l(a,"UL",{"data-svelte-h":!0}),p(Ia)!=="svelte-1dzlzv2"&&(Ia.innerHTML=Yn),Us=i(a),x(Da.$$.fragment,a),Ys=i(a),Ha=l(a,"P",{"data-svelte-h":!0}),p(Ha)!=="svelte-7ct0rj"&&(Ha.innerHTML=Bn),Bs=i(a),Oa=l(a,"P",{"data-svelte-h":!0}),p(Oa)!=="svelte-485xi9"&&(Oa.textContent=Xn),Xs=i(a),O=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(O)!=="svelte-10k46qf"&&(O.innerHTML=Nn),Ns=i(a),Ra=l(a,"P",{"data-svelte-h":!0}),p(Ra)!=="svelte-1pnt0ma"&&(Ra.textContent=Gn),Gs=i(a),R=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(R)!=="svelte-vfcq19"&&(R.innerHTML=Zn),Zs=i(a),Ea=l(a,"P",{"data-svelte-h":!0}),p(Ea)!=="svelte-1djc7k1"&&(Ea.textContent=Jn),Js=i(a),E=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(E)!=="svelte-etsjqg"&&(E.innerHTML=Qn),Qs=i(a),q=l(a,"P",{});var ct=o(q);an=u(ct,"Let’s also overlap the rectified left and right images to see the difference. We can see that the v values for different points remain mostly constant in the left and right images. However, the u values change, and this difference in the u values helps us find the depth information for different points in the scene, as shown in Equation 6 above. This difference in ‘u’ values"),ae=g(ct,!1),te=u(ct," is called disparity, and we can notice that the disparity for points near the camera is greater compared to points further away. Depth z and disparity "),se=g(ct,!1),ee=u(ct,"  are inversely proportional, as shown in equation 6."),ct.forEach(t),ne=i(a),qa=l(a,"P",{"data-svelte-h":!0}),p(qa)!=="svelte-9t92fc"&&(qa.textContent=ai),ie=i(a),A=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(A)!=="svelte-1ql8703"&&(A.innerHTML=ti),me=i(a),x(Aa.$$.fragment,a),le=i(a),ja=l(a,"P",{"data-svelte-h":!0}),p(ja)!=="svelte-1qtzgo8"&&(ja.textContent=si),re=i(a),Sa=l(a,"P",{"data-svelte-h":!0}),p(Sa)!=="svelte-1vy6u0k"&&(Sa.textContent=ei),pe=i(a),j=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(j)!=="svelte-7oq37z"&&(j.innerHTML=ni),oe=i(a),Wa=l(a,"P",{"data-svelte-h":!0}),p(Wa)!=="svelte-56zx53"&&(Wa.textContent=ii),he=i(a),S=l(a,"DIV",{style:!0,"data-svelte-h":!0}),p(S)!=="svelte-1iy98v"&&(S.innerHTML=mi),ce=i(a),x(Va.$$.fragment,a),ge=i(a),Fa=l(a,"P",{"data-svelte-h":!0}),p(Fa)!=="svelte-g4rd26"&&(Fa.textContent=li),de=i(a),N=l(a,"TABLE",{});var Se=o(N);Lt=l(Se,"THEAD",{});var Ci=o(Lt);d=l(Ci,"TR",{});var y=o(d);Ka=l(y,"TH",{align:!0,"data-svelte-h":!0}),p(Ka)!=="svelte-7qkg13"&&(Ka.textContent=ri),tn=i(y),nt=l(y,"TH",{align:!0});var Mi=o(nt);fe=g(Mi,!1),Mi.forEach(t),sn=i(y),it=l(y,"TH",{align:!0});var ki=o(it);ue=g(ki,!1),ki.forEach(t),en=i(y),mt=l(y,"TH",{align:!0});var $i=o(mt);ve=g($i,!1),$i.forEach(t),nn=i(y),lt=l(y,"TH",{align:!0});var zi=o(lt);ye=g(zi,!1),zi.forEach(t),mn=i(y),Ua=l(y,"TH",{align:!0,"data-svelte-h":!0}),p(Ua)!=="svelte-ybkm9u"&&(Ua.textContent=pi),ln=i(y),rt=l(y,"TH",{align:!0});var Ti=o(rt);we=g(Ti,!1),Ti.forEach(t),rn=i(y),pt=l(y,"TH",{align:!0});var Pi=o(pt);xe=g(Pi,!1),Pi.forEach(t),y.forEach(t),Ci.forEach(t),pn=i(Se),ot=l(Se,"TBODY",{"data-svelte-h":!0}),p(ot)!=="svelte-1rt6yz"&&(ot.innerHTML=oi),Se.forEach(t),_e=i(a),x(Ya.$$.fragment,a),be=i(a),W=l(a,"P",{});var gt=o(W);on=u(gt,"We can also compute 3D distances between different points using their (x,y,z) values using the formulae"),Le=g(gt,!1),Ce=u(gt,". Computed distances between some of the points are tabulated below along with their actual measured values. Percentage error"),Me=g(gt,!1),ke=u(gt,") is also computed and tabulated. Notice that the calculated and actual values match very well with a percentage error of 1.2% or less."),gt.forEach(t),$e=i(a),Ba=l(a,"TABLE",{"data-svelte-h":!0}),p(Ba)!=="svelte-1mrocde"&&(Ba.innerHTML=hi),ze=i(a),Xa=l(a,"P",{"data-svelte-h":!0}),p(Xa)!=="svelte-7wv9fd"&&(Xa.innerHTML=ci),Te=i(a),x(Na.$$.fragment,a),Pe=i(a),Ga=l(a,"OL",{"data-svelte-h":!0}),p(Ga)!=="svelte-8n4kzy"&&(Ga.innerHTML=gi),Ie=i(a),x(Za.$$.fragment,a),De=i(a),Ja=l(a,"OL",{"data-svelte-h":!0}),p(Ja)!=="svelte-vggie1"&&(Ja.innerHTML=di),He=i(a),x(Qa.$$.fragment,a),Oe=i(a),Ct=l(a,"P",{}),o(Ct).forEach(t),this.h()},h(){$(V,"name","hf:doc:metadata"),$(V,"content",cm),h(T,"display","flex"),h(T,"flex-direction","column"),h(T,"align-items","center"),h(P,"display","flex"),h(P,"flex-direction","column"),h(P,"align-items","center"),Jt.a=null,Qt.a=null,as.a=null,ts.a=null,ns.a=is,ms.a=ls,rs.a=ps,os.a=hs,cs.a=gs,ds.a=fs,us.a=vs,ys.a=ws,bs.a=null,$(wa,"start","3"),Ms.a=null,ks.a=null,$s.a=null,$(z,"start","4"),h(I,"display","flex"),h(I,"flex-direction","column"),h(I,"align-items","center"),h(D,"display","flex"),h(D,"flex-direction","column"),h(D,"align-items","center"),h(H,"display","flex"),h(H,"flex-direction","column"),h(H,"align-items","center"),Vs.a=Fs,h(O,"display","flex"),h(O,"flex-direction","column"),h(O,"align-items","center"),h(R,"display","flex"),h(R,"flex-direction","column"),h(R,"align-items","center"),h(E,"display","flex"),h(E,"flex-direction","column"),h(E,"align-items","center"),ae.a=te,se.a=ee,h(A,"display","flex"),h(A,"flex-direction","column"),h(A,"align-items","center"),h(j,"display","flex"),h(j,"flex-direction","column"),h(j,"align-items","center"),h(S,"display","flex"),h(S,"flex-direction","column"),h(S,"align-items","center"),$(Ka,"align","center"),fe.a=null,$(nt,"align","center"),ue.a=null,$(it,"align","center"),ve.a=null,$(mt,"align","center"),ye.a=null,$(lt,"align","center"),$(Ua,"align","center"),we.a=null,$(rt,"align","center"),xe.a=null,$(pt,"align","center"),Le.a=Ce,Me.a=ke},m(a,s){r(document.head,V),e(a,Tt,s),e(a,dt,s),e(a,Pt,s),_(G,a,s),e(a,It,s),e(a,Z,s),e(a,Dt,s),_(J,a,s),e(a,Ht,s),e(a,Q,s),e(a,Ot,s),e(a,aa,s),e(a,Rt,s),e(a,ta,s),e(a,Et,s),e(a,T,s),e(a,qt,s),_(sa,a,s),e(a,At,s),e(a,ea,s),e(a,jt,s),e(a,na,s),e(a,St,s),e(a,ia,s),e(a,Wt,s),e(a,ma,s),e(a,Vt,s),e(a,la,s),e(a,Ft,s),e(a,ra,s),e(a,Kt,s),e(a,pa,s),e(a,Ut,s),e(a,oa,s),e(a,Yt,s),_(ha,a,s),e(a,Bt,s),e(a,ca,s),e(a,Xt,s),e(a,P,s),e(a,Nt,s),e(a,ga,s),e(a,Gt,s),e(a,da,s),e(a,Zt,s),e(a,F,s),r(F,at),r(at,We),r(at,fa),r(fa,ft),Jt.m(Ii,ft),r(fa,Ve),r(fa,ut),Qt.m(Di,ut),r(F,Fe),r(F,tt),r(tt,Ke),r(tt,ua),r(ua,vt),as.m(Hi,vt),r(ua,Ue),r(ua,yt),ts.m(Oi,yt),e(a,ss,s),e(a,va,s),e(a,es,s),e(a,v,s),r(v,K),ns.m(Ri,K),r(K,is),ms.m(Ei,K),r(K,ls),r(v,Ye),r(v,U),rs.m(qi,U),r(U,ps),os.m(Ai,U),r(U,hs),r(v,Be),r(v,Y),cs.m(ji,Y),r(Y,gs),ds.m(Si,Y),r(Y,fs),r(v,Xe),r(v,st),r(v,Ne),r(v,B),us.m(Wi,B),r(B,vs),ys.m(Vi,B),r(B,ws),r(v,Ge),r(v,et),e(a,xs,s),e(a,ya,s),e(a,_s,s),e(a,wa,s),r(wa,wt),bs.m(Fi,wt),e(a,Ls,s),e(a,xa,s),e(a,Cs,s),e(a,z,s),r(z,xt),Ms.m(Ki,xt),r(z,Ze),r(z,_t),ks.m(Ui,_t),r(z,Je),r(z,bt),$s.m(Yi,bt),e(a,zs,s),e(a,_a,s),e(a,Ts,s),_(ba,a,s),e(a,Ps,s),_(La,a,s),e(a,Is,s),e(a,Ca,s),e(a,Ds,s),e(a,Ma,s),e(a,Hs,s),_(ka,a,s),e(a,Os,s),e(a,$a,s),e(a,Rs,s),e(a,za,s),e(a,Es,s),e(a,I,s),e(a,qs,s),e(a,Ta,s),e(a,As,s),e(a,D,s),e(a,js,s),e(a,Pa,s),e(a,Ss,s),e(a,H,s),e(a,Ws,s),e(a,X,s),r(X,Qe),Vs.m(Bi,X),r(X,Fs),e(a,Ks,s),e(a,Ia,s),e(a,Us,s),_(Da,a,s),e(a,Ys,s),e(a,Ha,s),e(a,Bs,s),e(a,Oa,s),e(a,Xs,s),e(a,O,s),e(a,Ns,s),e(a,Ra,s),e(a,Gs,s),e(a,R,s),e(a,Zs,s),e(a,Ea,s),e(a,Js,s),e(a,E,s),e(a,Qs,s),e(a,q,s),r(q,an),ae.m(Xi,q),r(q,te),se.m(Ni,q),r(q,ee),e(a,ne,s),e(a,qa,s),e(a,ie,s),e(a,A,s),e(a,me,s),_(Aa,a,s),e(a,le,s),e(a,ja,s),e(a,re,s),e(a,Sa,s),e(a,pe,s),e(a,j,s),e(a,oe,s),e(a,Wa,s),e(a,he,s),e(a,S,s),e(a,ce,s),_(Va,a,s),e(a,ge,s),e(a,Fa,s),e(a,de,s),e(a,N,s),r(N,Lt),r(Lt,d),r(d,Ka),r(d,tn),r(d,nt),fe.m(Gi,nt),r(d,sn),r(d,it),ue.m(Zi,it),r(d,en),r(d,mt),ve.m(Ji,mt),r(d,nn),r(d,lt),ye.m(Qi,lt),r(d,mn),r(d,Ua),r(d,ln),r(d,rt),we.m(am,rt),r(d,rn),r(d,pt),xe.m(tm,pt),r(N,pn),r(N,ot),e(a,_e,s),_(Ya,a,s),e(a,be,s),e(a,W,s),r(W,on),Le.m(sm,W),r(W,Ce),Me.m(em,W),r(W,ke),e(a,$e,s),e(a,Ba,s),e(a,ze,s),e(a,Xa,s),e(a,Te,s),_(Na,a,s),e(a,Pe,s),e(a,Ga,s),e(a,Ie,s),_(Za,a,s),e(a,De,s),e(a,Ja,s),e(a,He,s),_(Qa,a,s),e(a,Oe,s),e(a,Ct,s),Re=!0},p:im,i(a){Re||(b(G.$$.fragment,a),b(J.$$.fragment,a),b(sa.$$.fragment,a),b(ha.$$.fragment,a),b(ba.$$.fragment,a),b(La.$$.fragment,a),b(ka.$$.fragment,a),b(Da.$$.fragment,a),b(Aa.$$.fragment,a),b(Va.$$.fragment,a),b(Ya.$$.fragment,a),b(Na.$$.fragment,a),b(Za.$$.fragment,a),b(Qa.$$.fragment,a),Re=!0)},o(a){L(G.$$.fragment,a),L(J.$$.fragment,a),L(sa.$$.fragment,a),L(ha.$$.fragment,a),L(ba.$$.fragment,a),L(La.$$.fragment,a),L(ka.$$.fragment,a),L(Da.$$.fragment,a),L(Aa.$$.fragment,a),L(Va.$$.fragment,a),L(Ya.$$.fragment,a),L(Na.$$.fragment,a),L(Za.$$.fragment,a),L(Qa.$$.fragment,a),Re=!1},d(a){a&&(t(Tt),t(dt),t(Pt),t(It),t(Z),t(Dt),t(Ht),t(Q),t(Ot),t(aa),t(Rt),t(ta),t(Et),t(T),t(qt),t(At),t(ea),t(jt),t(na),t(St),t(ia),t(Wt),t(ma),t(Vt),t(la),t(Ft),t(ra),t(Kt),t(pa),t(Ut),t(oa),t(Yt),t(Bt),t(ca),t(Xt),t(P),t(Nt),t(ga),t(Gt),t(da),t(Zt),t(F),t(ss),t(va),t(es),t(v),t(xs),t(ya),t(_s),t(wa),t(Ls),t(xa),t(Cs),t(z),t(zs),t(_a),t(Ts),t(Ps),t(Is),t(Ca),t(Ds),t(Ma),t(Hs),t(Os),t($a),t(Rs),t(za),t(Es),t(I),t(qs),t(Ta),t(As),t(D),t(js),t(Pa),t(Ss),t(H),t(Ws),t(X),t(Ks),t(Ia),t(Us),t(Ys),t(Ha),t(Bs),t(Oa),t(Xs),t(O),t(Ns),t(Ra),t(Gs),t(R),t(Zs),t(Ea),t(Js),t(E),t(Qs),t(q),t(ne),t(qa),t(ie),t(A),t(me),t(le),t(ja),t(re),t(Sa),t(pe),t(j),t(oe),t(Wa),t(he),t(S),t(ce),t(ge),t(Fa),t(de),t(N),t(_e),t(be),t(W),t($e),t(Ba),t(ze),t(Xa),t(Te),t(Pe),t(Ga),t(Ie),t(De),t(Ja),t(He),t(Oe),t(Ct)),t(V),C(G,a),C(J,a),C(sa,a),C(ha,a),C(ba,a),C(La,a),C(ka,a),C(Da,a),C(Aa,a),C(Va,a),C(Ya,a),C(Na,a),C(Za,a),C(Qa,a)}}}const cm='{"title":"Introduction","local":"introduction","sections":[{"title":"Problem Statement","local":"problem-statement","sections":[],"depth":2},{"title":"Solution","local":"solution","sections":[],"depth":2},{"title":"Simplified Solution","local":"simplified-solution","sections":[],"depth":2},{"title":"Demo","local":"demo","sections":[{"title":"Setup","local":"setup","sections":[],"depth":3},{"title":"Raw Left and Right Images","local":"raw-left-and-right-images","sections":[],"depth":3},{"title":"Rectified Left and Right Images","local":"rectified-left-and-right-images","sections":[],"depth":3},{"title":"Annotated Left and Right Rectified Images","local":"annotated-left-and-right-rectified-images","sections":[],"depth":3},{"title":"3D Coordinate Calculations","local":"3d-coordinate-calculations","sections":[],"depth":3},{"title":"Dimension Calculations and Accuracy","local":"dimension-calculations-and-accuracy","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function gm(gn){return mm(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vm extends lm{constructor(V){super(),rm(this,V,gm,hm,nm,{})}}export{vm as component};
