import{s as di,o as hi,n as Cs}from"../chunks/scheduler.25b97de1.js";import{S as Ji,i as Ti,g as o,s as a,r,A as Ui,h as i,f as s,c as n,j as ui,u as M,x as p,k as mi,y as wi,a as l,v as c,d as y,t as u,w as m,m as ji,n as fi}from"../chunks/index.d9030fc9.js";import{T as W}from"../chunks/Tip.baa67368.js";import{C as J}from"../chunks/CodeBlock.e6cd0d95.js";import{H as j,E as Ii}from"../chunks/EditOnGithub.91d95064.js";function gi(I){let d,T=`The default behaviour of <code>TextGenerationPipeline</code> is to set <code>add_generation_prompt=True</code> so that it starts a new
message. However, if the final message in the input chat has the “assistant” role, it will assume that this message is
a prefill and switch to <code>continue_final_message=True</code> instead, because most models do not support multiple
consecutive assistant messages. You can override this behaviour by explicitly passing the <code>continue_final_message</code>
argument when calling the pipeline.`;return{c(){d=o("p"),d.innerHTML=T},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-95bbxf"&&(d.innerHTML=T)},m(h,U){l(h,d,U)},p:Cs,d(h){h&&s(d)}}}function bi(I){let d,T=`By default, some tokenizers add special tokens like <code>&lt;bos&gt;</code> and <code>&lt;eos&gt;</code> to text they tokenize. Chat templates should
already include all the special tokens they need, and so additional special tokens will often be incorrect or
duplicated, which will hurt model performance.`,h,U,g=`Therefore, if you format text with <code>apply_chat_template(tokenize=False)</code>, you should set the argument
<code>add_special_tokens=False</code> when you tokenize that text later. If you use <code>apply_chat_template(tokenize=True)</code>, you don’t need to worry about this!`;return{c(){d=o("p"),d.innerHTML=T,h=a(),U=o("p"),U.innerHTML=g},l(f){d=i(f,"P",{"data-svelte-h":!0}),p(d)!=="svelte-148xjo3"&&(d.innerHTML=T),h=n(f),U=i(f,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1hgzema"&&(U.innerHTML=g)},m(f,$){l(f,d,$),l(f,h,$),l(f,U,$)},p:Cs,d(f){f&&(s(d),s(h),s(U))}}}function Ci(I){let d,T=`The output format above is specific to the <code>Hermes-2-Pro</code> model we’re using in this example. Other models may emit different
tool call formats, and you may need to do some manual parsing at this step. For example, <code>Llama-3.1</code> models will emit
slightly different JSON, with <code>parameters</code> instead of <code>arguments</code>. Regardless of the format the model outputs, you
should add the tool call to the conversation in the format below, with <code>tool_calls</code>, <code>function</code> and <code>arguments</code> keys.`;return{c(){d=o("p"),d.innerHTML=T},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-1wfdwuk"&&(d.innerHTML=T)},m(h,U){l(h,d,U)},p:Cs,d(h){h&&s(d)}}}function $i(I){let d,T=`If you’re familiar with the OpenAI API, you should pay attention to an important difference here - the <code>tool_call</code> is
a dict, but in the OpenAI API it’s a JSON string. Passing a string may cause errors or strange model behaviour!`;return{c(){d=o("p"),d.innerHTML=T},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-fq11ea"&&(d.innerHTML=T)},m(h,U){l(h,d,U)},p:Cs,d(h){h&&s(d)}}}function Gi(I){let d,T=`Some model architectures, notably Mistral/Mixtral, also require a <code>tool_call_id</code> here, which should be
9 randomly-generated alphanumeric characters, and assigned to the <code>id</code> key of the tool call
dictionary. The same key should also be assigned to the <code>tool_call_id</code> key of the tool response dictionary below, so
that tool calls can be matched to tool responses. So, for Mistral/Mixtral models, the code above would be:`,h,U,g,f,$="and",G,b,_;return U=new J({props:{code:"dG9vbF9jYWxsX2lkJTIwJTNEJTIwJTIyOUFlM2JEYzJGJTIyJTIwJTIwJTIzJTIwUmFuZG9tJTIwSUQlMkMlMjA5JTIwYWxwaGFudW1lcmljJTIwY2hhcmFjdGVycyUwQXRvb2xfY2FsbCUyMCUzRCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF90ZW1wZXJhdHVyZSUyMiUyQyUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyUGFyaXMlMkMlMjBGcmFuY2UlMjIlMkMlMjAlMjJ1bml0JTIyJTNBJTIwJTIyY2Vsc2l1cyUyMiU3RCU3RCUwQW1lc3NhZ2VzLmFwcGVuZCglN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIydG9vbF9jYWxscyUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUyMCUyMmlkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call_id = <span class="hljs-string">&quot;9Ae3bDc2F&quot;</span>  <span class="hljs-comment"># Random ID, 9 alphanumeric characters</span>
tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),b=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIydG9vbF9jYWxsX2lkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;tool_call_id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),{c(){d=o("p"),d.innerHTML=T,h=a(),r(U.$$.fragment),g=a(),f=o("p"),f.textContent=$,G=a(),r(b.$$.fragment)},l(w){d=i(w,"P",{"data-svelte-h":!0}),p(d)!=="svelte-70hqps"&&(d.innerHTML=T),h=n(w),M(U.$$.fragment,w),g=n(w),f=i(w,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1qlona5"&&(f.textContent=$),G=n(w),M(b.$$.fragment,w)},m(w,C){l(w,d,C),l(w,h,C),c(U,w,C),l(w,g,C),l(w,f,C),l(w,G,C),c(b,w,C),_=!0},p:Cs,i(w){_||(y(U.$$.fragment,w),y(b.$$.fragment,w),_=!0)},o(w){u(U.$$.fragment,w),u(b.$$.fragment,w),_=!1},d(w){w&&(s(d),s(h),s(g),s(f),s(G)),m(U,w),m(b,w)}}}function xi(I){let d;return{c(){d=ji(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(T){d=fi(T,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(T,h){l(T,d,h)},d(T){T&&s(d)}}}function vi(I){let d,T=`The easiest way to get started with writing Jinja templates is to take a look at some existing ones. You can use
<code>print(tokenizer.chat_template)</code> for any chat model to see what template it’s using. In general, models that support tool use have
much more complex templates than other models - so when you’re just getting started, they’re probably a bad example
to learn from! You can also take a look at the
<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#synopsis" rel="nofollow">Jinja documentation</a> for details
of general Jinja formatting and syntax.`;return{c(){d=o("p"),d.innerHTML=T},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-qy60pj"&&(d.innerHTML=T)},m(h,U){l(h,d,U)},p:Cs,d(h){h&&s(d)}}}function Bi(I){let d,T=`You can actually pass any <code>kwarg</code> to <code>apply_chat_template</code>, and it will be accessible inside the template as a variable. In general,
we recommend trying to stick to the core variables above, as it will make your model harder to use if users have
to write custom code to pass model-specific <code>kwargs</code>. However, we’re aware that this field moves quickly, so if you
have a new use-case that doesn’t fit in the core API, feel free to use a new <code>kwarg</code> for it! If a new <code>kwarg</code>
becomes common we may promote it into the core API and create a standard, documented format for it.`;return{c(){d=o("p"),d.innerHTML=T},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-cvlh0x"&&(d.innerHTML=T)},m(h,U){l(h,d,U)},p:Cs,d(h){h&&s(d)}}}function Zi(I){let d,T,h,U,g,f,$,G,b,_=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,w,C,Cn=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,Gs,V,$n="Let’s make this concrete with a quick example using the <code>mistralai/Mistral-7B-Instruct-v0.1</code> model:",xs,S,vs,z,Gn=`Notice how the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!), and the entire chat is condensed into a single string.
If we use <code>tokenize=True</code>, which is the default setting, that string will also be tokenized for us.`,Bs,A,xn="Now, try the same code, but swap in the <code>HuggingFaceH4/zephyr-7b-beta</code> model instead, and you should get:",Zs,R,ks,X,vn=`Both Zephyr and Mistral-Instruct were fine-tuned from the same base model, <code>Mistral-7B-v0.1</code>. However, they were trained
with totally different chat formats. Without chat templates, you would have to write manual formatting code for each
model, and it’s very easy to make minor errors that hurt performance! Chat templates handle the details of formatting
for you, allowing you to write universal code that works for any model.`,Ns,E,Qs,H,Bn=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> method. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,qs,Y,Zn="Here’s an example of preparing input for <code>model.generate()</code>, using <code>Zephyr</code> again:",Ws,F,_s,L,kn="This will yield a string in the input format that Zephyr expects.",Vs,P,Ss,D,Nn="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",zs,K,As,O,Qn="This will yield:",Rs,tt,Xs,et,qn="Arr, ‘twas easy after all!",Es,st,Hs,lt,Wn=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/pr_28250/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,Ys,at,Fs,nt,Ls,ot,_n=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,Ps,it,Ds,pt,Vn=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Ks,rt,Os,Mt,Sn="Here’s what this will look like without a generation prompt, for a model that uses standard “ChatML” formatting:",tl,ct,el,yt,zn="And here’s what it looks like <strong>with</strong> a generation prompt:",sl,ut,ll,mt,An=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,al,dt,Rn=`Not all models require generation prompts. Some models, like LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,nl,ht,ol,Jt,Xn=`When passing a list of messages to <code>apply_chat_template</code> or <code>TextGenerationPipeline</code>, you can choose
to format the chat so the model will continue the final message in the chat instead of starting a new one. This is done
by removing any end-of-sequence tokens that indicate the end of the final message, so that the model will simply
extend the final message when it begins to generate text. This is useful for “prefilling” the model’s response.`,il,Tt,En="Here’s an example:",pl,Ut,rl,wt,Hn=`The model will generate text that continues the JSON string, rather than starting a new message. This approach
can be very useful for improving the accuracy of the model’s instruction-following when you know how you want
it to start its replies.`,Ml,jt,Yn=`Because <code>add_generation_prompt</code> adds the tokens that start a new message, and <code>continue_final_message</code> removes any
end-of-message tokens from the final message, it does not make sense to use them together. As a result, you’ll
get an error if you try!`,cl,x,yl,ft,ul,It,Fn=`Yes! This is a good way to ensure that the chat template matches the tokens the model sees during training.
We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,ml,gt,dl,bt,Ln="And we get:",hl,Ct,Jl,$t,Pn="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",Tl,v,Ul,Gt,wl,xt,Dn=`The only argument that <code>apply_chat_template</code> requires is <code>messages</code>. However, you can pass any keyword
argument to <code>apply_chat_template</code> and it will be accessible inside the template. This gives you a lot of freedom to use
chat templates for many things. There are no restrictions on the names or the format of these arguments - you can pass
strings, lists, dicts or whatever else you want.`,jl,vt,Kn=`That said, there are some common use-cases for these extra arguments,
such as passing tools for function calling, or documents for retrieval-augmented generation. In these common cases,
we have some opinionated recommendations about what the names and formats of these arguments should be, which are
described in the sections below. We encourage model authors to make their chat templates compatible with this format,
to make it easy to transfer tool-calling code between models.`,fl,Bt,Il,Zt,On=`“Tool use” LLMs can choose to call functions as external tools before generating an answer. When passing tools
to a tool-use model, you can simply pass a list of functions to the <code>tools</code> argument:`,gl,kt,bl,Nt,to=`In order for this to work correctly, you should write your functions in the format above, so that they can be parsed
correctly as tools. Specifically, you should follow these rules:`,Cl,Qt,eo=`<li>The function should have a descriptive name</li> <li>Every argument must have a type hint</li> <li>The function must have a docstring in the standard Google style (in other words, an initial function description<br/>
followed by an <code>Args:</code> block that describes the arguments, unless the function does not have any arguments.</li> <li>Do not include types in the <code>Args:</code> block. In other words, write <code>a: The first number to multiply</code>, not
<code>a (int): The first number to multiply</code>. Type hints should go in the function header instead.</li> <li>The function can have a return type and a <code>Returns:</code> block in the docstring. However, these are optional
because most tool-use models ignore them.</li>`,$l,qt,Gl,Wt,so=`The sample code above is enough to list the available tools for your model, but what happens if it wants to actually use
one? If that happens, you should:`,xl,_t,lo="<li>Parse the model’s output to get the tool name(s) and arguments.</li> <li>Add the model’s tool call(s) to the conversation.</li> <li>Call the corresponding function(s) with those arguments.</li> <li>Add the result(s) to the conversation</li>",vl,Vt,Bl,St,ao=`Let’s walk through a tool use example, step by step. For this example, we will use an 8B <code>Hermes-2-Pro</code> model,
as it is one of the highest-performing tool-use models in its size category at the time of writing. If you have the
memory, you can consider using a larger model instead like <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">Command-R</a>
or <a href="https://huggingface.co/mistralai/Mixtral-8x22B-Instruct-v0.1" rel="nofollow">Mixtral-8x22B</a>, both of which also support tool use
and offer even stronger performance.`,Zl,zt,no="First, let’s load our model and tokenizer:",kl,At,Nl,Rt,oo="Next, let’s define a list of tools:",Ql,Xt,ql,Et,io="Now, let’s set up a conversation for our bot:",Wl,Ht,_l,Yt,po="Now, let’s apply the chat template and generate a response:",Vl,Ft,Sl,Lt,ro="And we get:",zl,Pt,Al,Dt,Mo=`The model has called the function with valid arguments, in the format requested by the function docstring. It has
inferred that we’re most likely referring to the Paris in France, and it remembered that, as the home of SI units,
the temperature in France should certainly be displayed in Celsius.`,Rl,B,Xl,Kt,co="Next, let’s append the model’s tool call to the conversation.",El,Ot,Hl,Z,Yl,te,yo=`Now that we’ve added the tool call to the conversation, we can call the function and append the result to the
conversation. Since we’re just using a dummy function for this example that always returns 22.0, we can just append
that result directly.`,Fl,ee,Ll,k,Pl,se,uo="Finally, let’s let the assistant read the function outputs and continue chatting with the user:",Dl,le,Kl,ae,mo="And we get:",Ol,ne,ta,oe,ho=`Although this was a simple demo with dummy tools and a single call, the same technique works with
multiple real tools and longer conversations. This can be a powerful way to extend the capabilities of conversational
agents with real-time information, computational tools like calculators, or access to large databases.`,ea,ie,sa,pe,Jo=`Each function you pass to the <code>tools</code> argument of <code>apply_chat_template</code> is converted into a
<a href="https://json-schema.org/learn/getting-started-step-by-step" rel="nofollow">JSON schema</a>. These schemas
are then passed to the model chat template. In other words, tool-use models do not see your functions directly, and they
never see the actual code inside them. What they care about is the function <strong>definitions</strong> and the <strong>arguments</strong> they
need to pass to them - they care about what the tools do and how to use them, not how they work! It is up to you
to read their outputs, detect if they have requested to use a tool, pass their arguments to the tool function, and
return the response in the chat.`,la,re,To=`Generating JSON schemas to pass to the template should be automatic and invisible as long as your functions
follow the specification above, but if you encounter problems, or you simply want more control over the conversion,
you can handle the conversion manually. Here is an example of a manual schema conversion.`,aa,Me,na,ce,Uo="This will yield:",oa,ye,ia,ue,wo=`If you wish, you can edit these schemas, or even write them from scratch yourself without using <code>get_json_schema</code> at
all. JSON schemas can be passed directly to the <code>tools</code> argument of
<code>apply_chat_template</code> - this gives you a lot of power to define precise schemas for more complex functions. Be careful,
though - the more complex your schemas, the more likely the model is to get confused when dealing with them! We
recommend simple function signatures where possible, keeping arguments (and especially complex, nested arguments)
to a minimum.`,pa,me,jo="Here is an example of defining schemas by hand, and passing them directly to <code>apply_chat_template</code>:",ra,de,Ma,he,ca,Je,fo=`“Retrieval-augmented generation” or “RAG” LLMs can search a corpus of documents for information before responding
to a query. This allows models to vastly expand their knowledge base beyond their limited context size. Our
recommendation for RAG models is that their template
should accept a <code>documents</code> argument. This should be a list of documents, where each “document”
is a single dict with <code>title</code> and <code>contents</code> keys, both of which are strings. Because this format is much simpler
than the JSON schemas used for tools, no helper functions are necessary.`,ya,Te,Io="Here’s an example of a RAG template in action:",ua,Ue,ma,we,da,je,go=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at a <code>Zephyr</code> chat template, though note this
one is a little simplified from the actual one!`,ha,fe,Ja,Ie,bo=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,Ta,ge,Ua,be,Co="Effectively, the template does three things:",wa,Ce,$o=`<li>For each message, print the role enclosed in <code>&lt;|</code> and <code>|&gt;</code>, like <code>&lt;|user|&gt;</code> or <code>&lt;|assistant|&gt;</code>.</li> <li>Next, print the content of the message, followed by the end-of-sequence token.</li> <li>Finally, if <code>add_generation_prompt</code> is set, print the assistant token, so that the model knows to start generating
an assistant response.</li>`,ja,$e,Go=`This is a pretty simple template but Jinja gives you a lot of flexibility to do more complex things! Let’s see a Jinja
template that can format inputs similarly to the way LLaMA formats them (note that the real LLaMA template includes
handling for default system messages and slightly different system message handling in general - don’t use this one
in your actual code!)`,fa,Ge,Ia,xe,xo=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens like
<code>[INST]</code> and <code>[/INST]</code> based on the role of each message. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,ga,ve,ba,Be,Ca,Ze,vo=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,$a,ke,Ga,Ne,Bo=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/pr_28250/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,xa,Qe,va,qe,Zo=`The method <a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/pr_28250/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/pr_28250/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,Ba,N,Za,We,ka,_e,ko=`Some models use different templates for different use cases. For example, they might use one template for normal chat
and another for tool-use, or retrieval-augmented generation. In these cases, <code>tokenizer.chat_template</code> is a dictionary.
This can cause some confusion, and where possible, we recommend using a single template for all use-cases. You can use
Jinja statements like <code>if tools is defined</code> and <code>{% macro %}</code> definitions to easily wrap multiple code paths in a
single template.`,Na,Ve,No=`When a tokenizer has multiple templates, <code>tokenizer.chat_template</code> will be a <code>dict</code>, where each key is the name
of a template. The <code>apply_chat_template</code> method has special handling for certain template names: Specifically, it will
look for a template named <code>default</code> in most cases, and will raise an error if it can’t find one. However, if a template
named <code>tool_use</code> exists when the user has passed a <code>tools</code> argument, it will use that instead. To access templates
with other names, pass the name of the template you want to the <code>chat_template</code> argument of
<code>apply_chat_template()</code>.`,Qa,Se,Qo=`We find that this can be a bit confusing for users, though - so if you’re writing a template yourself, we recommend
trying to put it all in a single template where possible!`,qa,ze,Wa,Ae,qo=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,_a,Re,Wo=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,Va,Xe,Sa,Ee,_o=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,za,He,Aa,Ye,Vo=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,Ra,Fe,Xa,Le,So=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/pr_28250/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,Ea,Pe,Ha,De,zo=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/pr_28250/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,Ya,Ke,Ao=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,Fa,Oe,Ro=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,La,ts,Pa,Q,Da,es,Xo=`Jinja templates in <code>transformers</code> are identical to Jinja templates elsewhere. The main thing to know is that
the conversation history will be accessible inside your template as a variable called <code>messages</code>.<br/>
You will be able to access <code>messages</code> in your template just like you can in Python, which means you can loop over
it with <code>{% for message in messages %}</code> or access individual messages with <code>{{ messages[0] }}</code>, for example.`,Ka,ss,Eo="You can also use the following tips to write clean, efficient Jinja templates:",Oa,ls,tn,as,Ho=`By default, Jinja will print any whitespace that comes before or after a block. This can be a problem for chat
templates, which generally want to be very precise with whitespace! To avoid this, we strongly recommend writing
your templates like this:`,en,ns,sn,os,Yo="rather than like this:",ln,is,an,ps,Fo=`Adding <code>-</code> will strip any whitespace that comes before the block. The second example looks innocent, but the newline
and indentation may end up being included in the output, which is probably not what you want!`,nn,rs,on,Ms,Lo=`Inside your template, you will have access several special variables. The most important of these is <code>messages</code>,
which contains the chat history as a list of message dicts. However, there are several others. Not every
variable will be used in every template. The most common other variables are:`,pn,cs,Po="<li><code>tools</code> contains a list of tools in JSON schema format. Will be <code>None</code> or undefined if no tools are passed.</li> <li><code>documents</code> contains a list of documents in the format <code>{&quot;title&quot;: &quot;Title&quot;, &quot;contents&quot;: &quot;Contents&quot;}</code>, used for retrieval-augmented generation. Will be <code>None</code> or undefined if no documents are passed.</li> <li><code>add_generation_prompt</code> is a bool that is <code>True</code> if the user has requested a generation prompt, and <code>False</code> otherwise. If this is set, your template should add the header for an assistant message to the end of the conversation. If your model doesn’t have a specific header for assistant messages, you can ignore this flag.</li> <li><strong>Special tokens</strong> like <code>bos_token</code> and <code>eos_token</code>. These are extracted from <code>tokenizer.special_tokens_map</code>. The exact tokens available inside each template will differ depending on the parent tokenizer.</li>",rn,q,Mn,ys,cn,us,Do="There is also a short list of callable functions available to you inside your templates. These are:",yn,ms,Ko=`<li><code>raise_exception(msg)</code>: Raises a <code>TemplateException</code>. This is useful for debugging, and for telling users when they’re
doing something that your template doesn’t support.</li> <li><code>strftime_now(format_str)</code>: Equivalent to <code>datetime.now().strftime(format_str)</code> in Python. This is used for getting
the current date/time in a specific format, which is sometimes included in system messages.</li>`,un,ds,mn,hs,Oo=`There are multiple implementations of Jinja in various languages. They generally have the same syntax,
but a key difference is that when you’re writing a template in Python you can use Python methods, such as
<code>.lower()</code> on strings or <code>.items()</code> on dicts. This will break if someone tries to use your template on a non-Python
implementation of Jinja. Non-Python implementations are particularly common in deployment environments, where JS
and Rust are very popular.`,dn,Js,ti=`Don’t panic, though! There are a few easy changes you can make to your templates to ensure they’re compatible across
all implementations of Jinja:`,hn,Ts,ei=`<li>Replace Python methods with Jinja filters. These usually have the same name, for example <code>string.lower()</code> becomes
<code>string|lower</code>, and <code>dict.items()</code> becomes <code>dict|items</code>. One notable change is that <code>string.strip()</code> becomes <code>string|trim</code>.
See the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#builtin-filters" rel="nofollow">list of built-in filters</a>
in the Jinja documentation for more.</li> <li>Replace <code>True</code>, <code>False</code> and <code>None</code>, which are Python-specific, with <code>true</code>, <code>false</code> and <code>none</code>.</li> <li>Directly rendering a dict or list may give different results in other implementations (for example, string entries
might change from single-quoted to double-quoted). Adding the <code>tojson</code> filter can help to ensure consistency here.</li>`,Jn,Us,Tn,ws,si=`When this feature was introduced, most templates were quite small, the Jinja equivalent of a “one-liner” script.
However, with new models and features like tool-use and RAG, some templates can be 100 lines long or more. When
writing templates like these, it’s a good idea to write them in a separate file, using a text editor. You can easily
extract a chat template to a file:`,Un,js,wn,fs,li="Or load the edited template back into the tokenizer:",jn,Is,fn,gs,ai=`As an added bonus, when you write a long, multi-line template in a separate file, line numbers in that file will
exactly correspond to line numbers in template parsing or execution errors. This will make it much easier to
identify the source of issues.`,In,bs,gn,$s,bn;return g=new j({props:{title:"Chat Templates",local:"chat-templates",headingTag:"h1"}}),$=new j({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),S=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),R=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQUknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBSSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTNDJTJGcyUzRQ==",highlighted:`&lt;|user|&gt;
Hello, how are you?&lt;/s&gt;
&lt;|assistant|&gt;
I&#x27;m doing great. How can I help you today?&lt;/s&gt;
&lt;|user|&gt;
I&#x27;d like to show off how chat templating works!&lt;/s&gt;`,wrap:!1}}),E=new j({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),F=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),P=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),K=new J({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),tt=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),st=new j({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),at=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),nt=new J({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),it=new j({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),rt=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),ct=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),ut=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),ht=new j({props:{title:"What does “continue_final_message” do?",local:"what-does-continuefinalmessage-do",headingTag:"h2"}}),Ut=new J({props:{code:"Y2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJyU3QiUyMm5hbWUlMjIlM0ElMjAlMjInJTdEJTJDJTBBJTVEJTBBJTBBZm9ybWF0dGVkX2NoYXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlJTJDJTIwY29udGludWVfZmluYWxfbWVzc2FnZSUzRFRydWUpJTBBbW9kZWwuZ2VuZXJhdGUoKipmb3JtYXR0ZWRfY2hhdCk=",highlighted:`chat = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you format the answer in JSON?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;name&quot;: &quot;&#x27;</span>},
]

formatted_chat = tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, continue_final_message=<span class="hljs-literal">True</span>)
model.generate(**formatted_chat)`,wrap:!1}}),x=new W({props:{$$slots:{default:[gi]},$$scope:{ctx:I}}}),ft=new j({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),gt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),Ct=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),v=new W({props:{$$slots:{default:[bi]},$$scope:{ctx:I}}}),Gt=new j({props:{title:"Advanced: Extra inputs to chat templates",local:"advanced-extra-inputs-to-chat-templates",headingTag:"h2"}}),Bt=new j({props:{title:"Advanced: Tool use / function calling",local:"advanced-tool-use--function-calling",headingTag:"h2"}}),kt=new J({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZWYlMjBjdXJyZW50X3RpbWUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGRhdGV0aW1lLm5vdygpKSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBdG9vbHMlMjAlM0QlMjAlNUJjdXJyZW50X3RpbWUlMkMlMjBtdWx0aXBseSU1RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime

<span class="hljs-keyword">def</span> <span class="hljs-title function_">current_time</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get the current local time as a string.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(datetime.now())

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

tools = [current_time, multiply]

model_input = tokenizer.apply_chat_template(
    messages,
    tools=tools
)`,wrap:!1}}),qt=new j({props:{title:"Passing tool results to the model",local:"passing-tool-results-to-the-model",headingTag:"h3"}}),Vt=new j({props:{title:"A complete tool use example",local:"a-complete-tool-use-example",headingTag:"h3"}}),At=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMk5vdXNSZXNlYXJjaCUyRkhlcm1lcy0yLVByby1MbGFtYS0zLThCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;NousResearch/Hermes-2-Pro-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Xt=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_temperature</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, unit: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current temperature at a location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
        unit: The unit to return the temperature in. (choices: [&quot;celsius&quot;, &quot;fahrenheit&quot;])
    Returns:
        The current temperature at the specified location in the specified units, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">22.</span>  <span class="hljs-comment"># A real function should probably actually get the temperature!</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_wind_speed</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current wind speed in km/h at a given location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
    Returns:
        The current wind speed at the given location in km/h, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">6.</span>  <span class="hljs-comment"># A real function should probably actually get the wind speed!</span>

tools = [get_current_temperature, get_current_wind_speed]`,wrap:!1}}),Ht=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVzcG9uZHMlMjB0byUyMHdlYXRoZXIlMjBxdWVyaWVzLiUyMFlvdSUyMHNob3VsZCUyMHJlcGx5JTIwd2l0aCUyMHRoZSUyMHVuaXQlMjB1c2VkJTIwaW4lMjB0aGUlMjBxdWVyaWVkJTIwbG9jYXRpb24uJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGV5JTJDJTIwd2hhdCdzJTIwdGhlJTIwdGVtcGVyYXR1cmUlMjBpbiUyMFBhcmlzJTIwcmlnaHQlMjBub3clM0YlMjIlN0QlMEElNUQ=",highlighted:`messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a bot that responds to weather queries. You should reply with the unit used in the queried location.&quot;</span>},
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hey, what&#x27;s the temperature in Paris right now?&quot;</span>}
]`,wrap:!1}}),Ft=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),Pt=new J({props:{code:"JTNDdG9vbF9jYWxsJTNFJTBBJTdCJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTdEJTBBJTNDJTJGdG9vbF9jYWxsJTNFJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;tool_call&gt;
{&quot;arguments&quot;: {&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}, &quot;name&quot;: &quot;get_current_temperature&quot;}
&lt;/tool_call&gt;&lt;|im_end|&gt;`,wrap:!1}}),B=new W({props:{$$slots:{default:[Ci]},$$scope:{ctx:I}}}),Ot=new J({props:{code:"dG9vbF9jYWxsJTIwJTNEJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTdEJTBBbWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJ0b29sX2NhbGxzJTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),Z=new W({props:{warning:!0,$$slots:{default:[$i]},$$scope:{ctx:I}}}),ee=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),k=new W({props:{$$slots:{default:[Gi]},$$scope:{ctx:I}}}),le=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),ne=new J({props:{code:"VGhlJTIwY3VycmVudCUyMHRlbXBlcmF0dXJlJTIwaW4lMjBQYXJpcyUyQyUyMEZyYW5jZSUyMGlzJTIwMjIuMCUyMCVDMiVCMCUyMENlbHNpdXMuJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:"The current temperature in Paris, France is 22.0 ° Celsius.&lt;|im_end|&gt;",wrap:!1}}),ie=new j({props:{title:"Understanding tool schemas",local:"understanding-tool-schemas",headingTag:"h3"}}),Me=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGdldF9qc29uX3NjaGVtYSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBc2NoZW1hJTIwJTNEJTIwZ2V0X2pzb25fc2NoZW1hKG11bHRpcGx5KSUwQXByaW50KHNjaGVtYSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> get_json_schema

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

schema = get_json_schema(multiply)
<span class="hljs-built_in">print</span>(schema)`,wrap:!1}}),ye=new J({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),de=new J({props:{code:"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",highlighted:`<span class="hljs-comment"># A simple function that takes no arguments</span>
current_time = {
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
  <span class="hljs-string">&quot;function&quot;</span>: {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;current_time&quot;</span>,
    <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current local time as a string.&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {}
    }
  }
}

<span class="hljs-comment"># A more complete function that takes two numerical arguments</span>
multiply = {
  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;function&#x27;</span>,
  <span class="hljs-string">&#x27;function&#x27;</span>: {
    <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;multiply&#x27;</span>,
    <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;A function that multiplies two numbers&#x27;</span>, 
    <span class="hljs-string">&#x27;parameters&#x27;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>, 
      <span class="hljs-string">&#x27;properties&#x27;</span>: {
        <span class="hljs-string">&#x27;a&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>,
          <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The first number to multiply&#x27;</span>
        }, 
        <span class="hljs-string">&#x27;b&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The second number to multiply&#x27;</span>
        }
      }, 
      <span class="hljs-string">&#x27;required&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>]
    }
  }
}

model_input = tokenizer.apply_chat_template(
    messages,
    tools = [current_time, multiply]
)`,wrap:!1}}),he=new j({props:{title:"Advanced: Retrieval-augmented generation",local:"advanced-retrieval-augmented-generation",headingTag:"h2"}}),Ue=new J({props:{code:"ZG9jdW1lbnQxJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJUaGUlMjBNb29uJTNBJTIwT3VyJTIwQWdlLU9sZCUyMEZvZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnRzJTIyJTNBJTIwJTIyTWFuJTIwaGFzJTIwYWx3YXlzJTIwZHJlYW1lZCUyMG9mJTIwZGVzdHJveWluZyUyMHRoZSUyMG1vb24uJTIwSW4lMjB0aGlzJTIwZXNzYXklMkMlMjBJJTIwc2hhbGwuLi4lMjIlMEElN0QlMEElMEFkb2N1bWVudDIlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0aXRsZSUyMiUzQSUyMCUyMlRoZSUyMFN1biUzQSUyME91ciUyMEFnZS1PbGQlMjBGcmllbmQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb250ZW50cyUyMiUzQSUyMCUyMkFsdGhvdWdoJTIwb2Z0ZW4lMjB1bmRlcmFwcHJlY2lhdGVkJTJDJTIwdGhlJTIwc3VuJTIwcHJvdmlkZXMlMjBzZXZlcmFsJTIwbm90YWJsZSUyMGJlbmVmaXRzLi4uJTIyJTBBJTdEJTBBJTBBbW9kZWxfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMGRvY3VtZW50cyUzRCU1QmRvY3VtZW50MSUyQyUyMGRvY3VtZW50MiU1RCUwQSk=",highlighted:`document1 = {
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Moon: Our Age-Old Foe&quot;</span>,
    <span class="hljs-string">&quot;contents&quot;</span>: <span class="hljs-string">&quot;Man has always dreamed of destroying the moon. In this essay, I shall...&quot;</span>
}

document2 = {
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Sun: Our Age-Old Friend&quot;</span>,
    <span class="hljs-string">&quot;contents&quot;</span>: <span class="hljs-string">&quot;Although often underappreciated, the sun provides several notable benefits...&quot;</span>
}

model_input = tokenizer.apply_chat_template(
    messages,
    documents=[document1, document2]
)`,wrap:!1}}),we=new j({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),fe=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0MnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCU3QyUzRSU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGlmJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0Nhc3Npc3RhbnQlN0MlM0UlNUNuJyUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- &#x27;&lt;|&#x27; + message[&#x27;role&#x27;] + |&gt;\\n&#x27; }}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- message[&#x27;content&#x27;] + eos_token }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">if</span></span> add_generation_prompt %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- &#x27;&lt;|assistant|&gt;\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),ge=new J({props:{code:"Zm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJyUzQyU3QyU3Qm1lc3NhZ2UlNUIlMjJyb2xlJTIyJTVEJTdEJTdDJTNFJyklMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuKSUwQWlmJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJyUzQyU3Q2Fzc2lzdGFudCU3QyUzRScp",highlighted:`<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;&lt;|<span class="hljs-subst">{message[<span class="hljs-string">&quot;role&quot;</span>]}</span>|&gt;&#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>] + eos_token)
<span class="hljs-keyword">if</span> add_generation_prompt:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;&lt;|assistant|&gt;&#x27;</span>)`,wrap:!1}}),Ge=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclNUMlNUNuJTNDJTNDJTJGU1lTJTNFJTNFJTVDJTVDbiU1QyU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUyMCclMjAlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),ve=new j({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),Be=new j({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),ke=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTNDU1lTJTNFJTNFJTVDJTVDbiclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclNUJBU1NUJTVEJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJTVCJTJGQVNTVCU1RCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),Qe=new J({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),N=new W({props:{$$slots:{default:[xi]},$$scope:{ctx:I}}}),We=new j({props:{title:"Why do some models have multiple templates?",local:"why-do-some-models-have-multiple-templates",headingTag:"h3"}}),ze=new j({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),Xe=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[&#x27;content&#x27;] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),He=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),Fe=new J({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),Pe=new j({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),ts=new j({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),Q=new W({props:{$$slots:{default:[vi]},$$scope:{ctx:I}}}),ls=new j({props:{title:"Trimming whitespace",local:"trimming-whitespace",headingTag:"h3"}}),ns=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),is=new J({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0IlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] + message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),rs=new j({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),q=new W({props:{$$slots:{default:[Bi]},$$scope:{ctx:I}}}),ys=new j({props:{title:"Callable functions",local:"callable-functions",headingTag:"h3"}}),ds=new j({props:{title:"Compatibility with non-Python Jinja",local:"compatibility-with-non-python-jinja",headingTag:"h3"}}),Us=new j({props:{title:"Writing and debugging larger templates",local:"writing-and-debugging-larger-templates",headingTag:"h3"}}),js=new J({props:{code:"b3BlbiglMjJ0ZW1wbGF0ZS5qaW5qYSUyMiUyQyUyMCUyMnclMjIpLndyaXRlKHRva2VuaXplci5jaGF0X3RlbXBsYXRlKQ==",highlighted:'<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>).write(tokenizer.chat_template)',wrap:!1}}),Is=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBvcGVuKCUyMnRlbXBsYXRlLmppbmphJTIyKS5yZWFkKCk=",highlighted:'tokenizer.chat_template = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>).read()',wrap:!1}}),bs=new Ii({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_templating.md"}}),{c(){d=o("meta"),T=a(),h=o("p"),U=a(),r(g.$$.fragment),f=a(),r($.$$.fragment),G=a(),b=o("p"),b.innerHTML=_,w=a(),C=o("p"),C.innerHTML=Cn,Gs=a(),V=o("p"),V.innerHTML=$n,xs=a(),r(S.$$.fragment),vs=a(),z=o("p"),z.innerHTML=Gn,Bs=a(),A=o("p"),A.innerHTML=xn,Zs=a(),r(R.$$.fragment),ks=a(),X=o("p"),X.innerHTML=vn,Ns=a(),r(E.$$.fragment),Qs=a(),H=o("p"),H.innerHTML=Bn,qs=a(),Y=o("p"),Y.innerHTML=Zn,Ws=a(),r(F.$$.fragment),_s=a(),L=o("p"),L.textContent=kn,Vs=a(),r(P.$$.fragment),Ss=a(),D=o("p"),D.textContent=Nn,zs=a(),r(K.$$.fragment),As=a(),O=o("p"),O.textContent=Qn,Rs=a(),r(tt.$$.fragment),Xs=a(),et=o("p"),et.textContent=qn,Es=a(),r(st.$$.fragment),Hs=a(),lt=o("p"),lt.innerHTML=Wn,Ys=a(),r(at.$$.fragment),Fs=a(),r(nt.$$.fragment),Ls=a(),ot=o("p"),ot.innerHTML=_n,Ps=a(),r(it.$$.fragment),Ds=a(),pt=o("p"),pt.innerHTML=Vn,Ks=a(),r(rt.$$.fragment),Os=a(),Mt=o("p"),Mt.textContent=Sn,tl=a(),r(ct.$$.fragment),el=a(),yt=o("p"),yt.innerHTML=zn,sl=a(),r(ut.$$.fragment),ll=a(),mt=o("p"),mt.textContent=An,al=a(),dt=o("p"),dt.innerHTML=Rn,nl=a(),r(ht.$$.fragment),ol=a(),Jt=o("p"),Jt.innerHTML=Xn,il=a(),Tt=o("p"),Tt.textContent=En,pl=a(),r(Ut.$$.fragment),rl=a(),wt=o("p"),wt.textContent=Hn,Ml=a(),jt=o("p"),jt.innerHTML=Yn,cl=a(),r(x.$$.fragment),yl=a(),r(ft.$$.fragment),ul=a(),It=o("p"),It.innerHTML=Fn,ml=a(),r(gt.$$.fragment),dl=a(),bt=o("p"),bt.textContent=Ln,hl=a(),r(Ct.$$.fragment),Jl=a(),$t=o("p"),$t.innerHTML=Pn,Tl=a(),r(v.$$.fragment),Ul=a(),r(Gt.$$.fragment),wl=a(),xt=o("p"),xt.innerHTML=Dn,jl=a(),vt=o("p"),vt.textContent=Kn,fl=a(),r(Bt.$$.fragment),Il=a(),Zt=o("p"),Zt.innerHTML=On,gl=a(),r(kt.$$.fragment),bl=a(),Nt=o("p"),Nt.textContent=to,Cl=a(),Qt=o("ul"),Qt.innerHTML=eo,$l=a(),r(qt.$$.fragment),Gl=a(),Wt=o("p"),Wt.textContent=so,xl=a(),_t=o("ol"),_t.innerHTML=lo,vl=a(),r(Vt.$$.fragment),Bl=a(),St=o("p"),St.innerHTML=ao,Zl=a(),zt=o("p"),zt.textContent=no,kl=a(),r(At.$$.fragment),Nl=a(),Rt=o("p"),Rt.textContent=oo,Ql=a(),r(Xt.$$.fragment),ql=a(),Et=o("p"),Et.textContent=io,Wl=a(),r(Ht.$$.fragment),_l=a(),Yt=o("p"),Yt.textContent=po,Vl=a(),r(Ft.$$.fragment),Sl=a(),Lt=o("p"),Lt.textContent=ro,zl=a(),r(Pt.$$.fragment),Al=a(),Dt=o("p"),Dt.textContent=Mo,Rl=a(),r(B.$$.fragment),Xl=a(),Kt=o("p"),Kt.textContent=co,El=a(),r(Ot.$$.fragment),Hl=a(),r(Z.$$.fragment),Yl=a(),te=o("p"),te.textContent=yo,Fl=a(),r(ee.$$.fragment),Ll=a(),r(k.$$.fragment),Pl=a(),se=o("p"),se.textContent=uo,Dl=a(),r(le.$$.fragment),Kl=a(),ae=o("p"),ae.textContent=mo,Ol=a(),r(ne.$$.fragment),ta=a(),oe=o("p"),oe.textContent=ho,ea=a(),r(ie.$$.fragment),sa=a(),pe=o("p"),pe.innerHTML=Jo,la=a(),re=o("p"),re.textContent=To,aa=a(),r(Me.$$.fragment),na=a(),ce=o("p"),ce.textContent=Uo,oa=a(),r(ye.$$.fragment),ia=a(),ue=o("p"),ue.innerHTML=wo,pa=a(),me=o("p"),me.innerHTML=jo,ra=a(),r(de.$$.fragment),Ma=a(),r(he.$$.fragment),ca=a(),Je=o("p"),Je.innerHTML=fo,ya=a(),Te=o("p"),Te.textContent=Io,ua=a(),r(Ue.$$.fragment),ma=a(),r(we.$$.fragment),da=a(),je=o("p"),je.innerHTML=go,ha=a(),r(fe.$$.fragment),Ja=a(),Ie=o("p"),Ie.innerHTML=bo,Ta=a(),r(ge.$$.fragment),Ua=a(),be=o("p"),be.textContent=Co,wa=a(),Ce=o("ol"),Ce.innerHTML=$o,ja=a(),$e=o("p"),$e.textContent=Go,fa=a(),r(Ge.$$.fragment),Ia=a(),xe=o("p"),xe.innerHTML=xo,ga=a(),r(ve.$$.fragment),ba=a(),r(Be.$$.fragment),Ca=a(),Ze=o("p"),Ze.innerHTML=vo,$a=a(),r(ke.$$.fragment),Ga=a(),Ne=o("p"),Ne.innerHTML=Bo,xa=a(),r(Qe.$$.fragment),va=a(),qe=o("p"),qe.innerHTML=Zo,Ba=a(),r(N.$$.fragment),Za=a(),r(We.$$.fragment),ka=a(),_e=o("p"),_e.innerHTML=ko,Na=a(),Ve=o("p"),Ve.innerHTML=No,Qa=a(),Se=o("p"),Se.textContent=Qo,qa=a(),r(ze.$$.fragment),Wa=a(),Ae=o("p"),Ae.textContent=qo,_a=a(),Re=o("p"),Re.innerHTML=Wo,Va=a(),r(Xe.$$.fragment),Sa=a(),Ee=o("p"),Ee.innerHTML=_o,za=a(),r(He.$$.fragment),Aa=a(),Ye=o("p"),Ye.innerHTML=Vo,Ra=a(),r(Fe.$$.fragment),Xa=a(),Le=o("p"),Le.innerHTML=So,Ea=a(),r(Pe.$$.fragment),Ha=a(),De=o("p"),De.innerHTML=zo,Ya=a(),Ke=o("p"),Ke.innerHTML=Ao,Fa=a(),Oe=o("p"),Oe.textContent=Ro,La=a(),r(ts.$$.fragment),Pa=a(),r(Q.$$.fragment),Da=a(),es=o("p"),es.innerHTML=Xo,Ka=a(),ss=o("p"),ss.textContent=Eo,Oa=a(),r(ls.$$.fragment),tn=a(),as=o("p"),as.textContent=Ho,en=a(),r(ns.$$.fragment),sn=a(),os=o("p"),os.textContent=Yo,ln=a(),r(is.$$.fragment),an=a(),ps=o("p"),ps.innerHTML=Fo,nn=a(),r(rs.$$.fragment),on=a(),Ms=o("p"),Ms.innerHTML=Lo,pn=a(),cs=o("ul"),cs.innerHTML=Po,rn=a(),r(q.$$.fragment),Mn=a(),r(ys.$$.fragment),cn=a(),us=o("p"),us.textContent=Do,yn=a(),ms=o("ul"),ms.innerHTML=Ko,un=a(),r(ds.$$.fragment),mn=a(),hs=o("p"),hs.innerHTML=Oo,dn=a(),Js=o("p"),Js.textContent=ti,hn=a(),Ts=o("ul"),Ts.innerHTML=ei,Jn=a(),r(Us.$$.fragment),Tn=a(),ws=o("p"),ws.textContent=si,Un=a(),r(js.$$.fragment),wn=a(),fs=o("p"),fs.textContent=li,jn=a(),r(Is.$$.fragment),fn=a(),gs=o("p"),gs.textContent=ai,In=a(),r(bs.$$.fragment),gn=a(),$s=o("p"),this.h()},l(t){const e=Ui("svelte-u9bgzb",document.head);d=i(e,"META",{name:!0,content:!0}),e.forEach(s),T=n(t),h=i(t,"P",{}),ui(h).forEach(s),U=n(t),M(g.$$.fragment,t),f=n(t),M($.$$.fragment,t),G=n(t),b=i(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-ydi30o"&&(b.innerHTML=_),w=n(t),C=i(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1p8dq8"&&(C.innerHTML=Cn),Gs=n(t),V=i(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-19ob0qf"&&(V.innerHTML=$n),xs=n(t),M(S.$$.fragment,t),vs=n(t),z=i(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-gwj0xd"&&(z.innerHTML=Gn),Bs=n(t),A=i(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-14wqu22"&&(A.innerHTML=xn),Zs=n(t),M(R.$$.fragment,t),ks=n(t),X=i(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1010uaq"&&(X.innerHTML=vn),Ns=n(t),M(E.$$.fragment,t),Qs=n(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-17iitdb"&&(H.innerHTML=Bn),qs=n(t),Y=i(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1vun9x2"&&(Y.innerHTML=Zn),Ws=n(t),M(F.$$.fragment,t),_s=n(t),L=i(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1vy7akj"&&(L.textContent=kn),Vs=n(t),M(P.$$.fragment,t),Ss=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-hj60o5"&&(D.textContent=Nn),zs=n(t),M(K.$$.fragment,t),As=n(t),O=i(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1bfcqd3"&&(O.textContent=Qn),Rs=n(t),M(tt.$$.fragment,t),Xs=n(t),et=i(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-k9m2iy"&&(et.textContent=qn),Es=n(t),M(st.$$.fragment,t),Hs=n(t),lt=i(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1uj1dxa"&&(lt.innerHTML=Wn),Ys=n(t),M(at.$$.fragment,t),Fs=n(t),M(nt.$$.fragment,t),Ls=n(t),ot=i(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-5umvde"&&(ot.innerHTML=_n),Ps=n(t),M(it.$$.fragment,t),Ds=n(t),pt=i(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-rhnu79"&&(pt.innerHTML=Vn),Ks=n(t),M(rt.$$.fragment,t),Os=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-jpbe39"&&(Mt.textContent=Sn),tl=n(t),M(ct.$$.fragment,t),el=n(t),yt=i(t,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-61bp3d"&&(yt.innerHTML=zn),sl=n(t),M(ut.$$.fragment,t),ll=n(t),mt=i(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-inq88f"&&(mt.textContent=An),al=n(t),dt=i(t,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-uz30n4"&&(dt.innerHTML=Rn),nl=n(t),M(ht.$$.fragment,t),ol=n(t),Jt=i(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-y1327w"&&(Jt.innerHTML=Xn),il=n(t),Tt=i(t,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-wwwyth"&&(Tt.textContent=En),pl=n(t),M(Ut.$$.fragment,t),rl=n(t),wt=i(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-j6m3wj"&&(wt.textContent=Hn),Ml=n(t),jt=i(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-hfpwig"&&(jt.innerHTML=Yn),cl=n(t),M(x.$$.fragment,t),yl=n(t),M(ft.$$.fragment,t),ul=n(t),It=i(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-i3l9c1"&&(It.innerHTML=Fn),ml=n(t),M(gt.$$.fragment,t),dl=n(t),bt=i(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-13505nn"&&(bt.textContent=Ln),hl=n(t),M(Ct.$$.fragment,t),Jl=n(t),$t=i(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-ziuqkt"&&($t.innerHTML=Pn),Tl=n(t),M(v.$$.fragment,t),Ul=n(t),M(Gt.$$.fragment,t),wl=n(t),xt=i(t,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-dd615e"&&(xt.innerHTML=Dn),jl=n(t),vt=i(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-dcun4m"&&(vt.textContent=Kn),fl=n(t),M(Bt.$$.fragment,t),Il=n(t),Zt=i(t,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-6sd0wq"&&(Zt.innerHTML=On),gl=n(t),M(kt.$$.fragment,t),bl=n(t),Nt=i(t,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-608o9m"&&(Nt.textContent=to),Cl=n(t),Qt=i(t,"UL",{"data-svelte-h":!0}),p(Qt)!=="svelte-n1b3zm"&&(Qt.innerHTML=eo),$l=n(t),M(qt.$$.fragment,t),Gl=n(t),Wt=i(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-11962fa"&&(Wt.textContent=so),xl=n(t),_t=i(t,"OL",{"data-svelte-h":!0}),p(_t)!=="svelte-1vd84s7"&&(_t.innerHTML=lo),vl=n(t),M(Vt.$$.fragment,t),Bl=n(t),St=i(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1oi0gsn"&&(St.innerHTML=ao),Zl=n(t),zt=i(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-o8n6v4"&&(zt.textContent=no),kl=n(t),M(At.$$.fragment,t),Nl=n(t),Rt=i(t,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1q7358y"&&(Rt.textContent=oo),Ql=n(t),M(Xt.$$.fragment,t),ql=n(t),Et=i(t,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-11hfyaa"&&(Et.textContent=io),Wl=n(t),M(Ht.$$.fragment,t),_l=n(t),Yt=i(t,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-1usrd3e"&&(Yt.textContent=po),Vl=n(t),M(Ft.$$.fragment,t),Sl=n(t),Lt=i(t,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-13505nn"&&(Lt.textContent=ro),zl=n(t),M(Pt.$$.fragment,t),Al=n(t),Dt=i(t,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-nxltbo"&&(Dt.textContent=Mo),Rl=n(t),M(B.$$.fragment,t),Xl=n(t),Kt=i(t,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-336ooj"&&(Kt.textContent=co),El=n(t),M(Ot.$$.fragment,t),Hl=n(t),M(Z.$$.fragment,t),Yl=n(t),te=i(t,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1mv1vl9"&&(te.textContent=yo),Fl=n(t),M(ee.$$.fragment,t),Ll=n(t),M(k.$$.fragment,t),Pl=n(t),se=i(t,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1qjybqz"&&(se.textContent=uo),Dl=n(t),M(le.$$.fragment,t),Kl=n(t),ae=i(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-13505nn"&&(ae.textContent=mo),Ol=n(t),M(ne.$$.fragment,t),ta=n(t),oe=i(t,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1evxmus"&&(oe.textContent=ho),ea=n(t),M(ie.$$.fragment,t),sa=n(t),pe=i(t,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-pl4mbs"&&(pe.innerHTML=Jo),la=n(t),re=i(t,"P",{"data-svelte-h":!0}),p(re)!=="svelte-37xmdz"&&(re.textContent=To),aa=n(t),M(Me.$$.fragment,t),na=n(t),ce=i(t,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1bfcqd3"&&(ce.textContent=Uo),oa=n(t),M(ye.$$.fragment,t),ia=n(t),ue=i(t,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-19t6fs5"&&(ue.innerHTML=wo),pa=n(t),me=i(t,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1nlyrys"&&(me.innerHTML=jo),ra=n(t),M(de.$$.fragment,t),Ma=n(t),M(he.$$.fragment,t),ca=n(t),Je=i(t,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1977j4z"&&(Je.innerHTML=fo),ya=n(t),Te=i(t,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1xmnzcc"&&(Te.textContent=Io),ua=n(t),M(Ue.$$.fragment,t),ma=n(t),M(we.$$.fragment,t),da=n(t),je=i(t,"P",{"data-svelte-h":!0}),p(je)!=="svelte-lanz4l"&&(je.innerHTML=go),ha=n(t),M(fe.$$.fragment,t),Ja=n(t),Ie=i(t,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-zet1qo"&&(Ie.innerHTML=bo),Ta=n(t),M(ge.$$.fragment,t),Ua=n(t),be=i(t,"P",{"data-svelte-h":!0}),p(be)!=="svelte-9bdwn1"&&(be.textContent=Co),wa=n(t),Ce=i(t,"OL",{"data-svelte-h":!0}),p(Ce)!=="svelte-1ax9ke1"&&(Ce.innerHTML=$o),ja=n(t),$e=i(t,"P",{"data-svelte-h":!0}),p($e)!=="svelte-4zn2hx"&&($e.textContent=Go),fa=n(t),M(Ge.$$.fragment,t),Ia=n(t),xe=i(t,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-prz4we"&&(xe.innerHTML=xo),ga=n(t),M(ve.$$.fragment,t),ba=n(t),M(Be.$$.fragment,t),Ca=n(t),Ze=i(t,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1ubxgh9"&&(Ze.innerHTML=vo),$a=n(t),M(ke.$$.fragment,t),Ga=n(t),Ne=i(t,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1yb2t3g"&&(Ne.innerHTML=Bo),xa=n(t),M(Qe.$$.fragment,t),va=n(t),qe=i(t,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-qhyuo3"&&(qe.innerHTML=Zo),Ba=n(t),M(N.$$.fragment,t),Za=n(t),M(We.$$.fragment,t),ka=n(t),_e=i(t,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1d7cql4"&&(_e.innerHTML=ko),Na=n(t),Ve=i(t,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1u88h1j"&&(Ve.innerHTML=No),Qa=n(t),Se=i(t,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1g7ri12"&&(Se.textContent=Qo),qa=n(t),M(ze.$$.fragment,t),Wa=n(t),Ae=i(t,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-5u6sqi"&&(Ae.textContent=qo),_a=n(t),Re=i(t,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-ffreiw"&&(Re.innerHTML=Wo),Va=n(t),M(Xe.$$.fragment,t),Sa=n(t),Ee=i(t,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1cj1ql7"&&(Ee.innerHTML=_o),za=n(t),M(He.$$.fragment,t),Aa=n(t),Ye=i(t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-soh9qu"&&(Ye.innerHTML=Vo),Ra=n(t),M(Fe.$$.fragment,t),Xa=n(t),Le=i(t,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-j9wzez"&&(Le.innerHTML=So),Ea=n(t),M(Pe.$$.fragment,t),Ha=n(t),De=i(t,"P",{"data-svelte-h":!0}),p(De)!=="svelte-dr7shw"&&(De.innerHTML=zo),Ya=n(t),Ke=i(t,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-kn2i6o"&&(Ke.innerHTML=Ao),Fa=n(t),Oe=i(t,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-197jyne"&&(Oe.textContent=Ro),La=n(t),M(ts.$$.fragment,t),Pa=n(t),M(Q.$$.fragment,t),Da=n(t),es=i(t,"P",{"data-svelte-h":!0}),p(es)!=="svelte-1eu5v04"&&(es.innerHTML=Xo),Ka=n(t),ss=i(t,"P",{"data-svelte-h":!0}),p(ss)!=="svelte-10wmjwo"&&(ss.textContent=Eo),Oa=n(t),M(ls.$$.fragment,t),tn=n(t),as=i(t,"P",{"data-svelte-h":!0}),p(as)!=="svelte-1ttgeg7"&&(as.textContent=Ho),en=n(t),M(ns.$$.fragment,t),sn=n(t),os=i(t,"P",{"data-svelte-h":!0}),p(os)!=="svelte-qihux6"&&(os.textContent=Yo),ln=n(t),M(is.$$.fragment,t),an=n(t),ps=i(t,"P",{"data-svelte-h":!0}),p(ps)!=="svelte-pefrh0"&&(ps.innerHTML=Fo),nn=n(t),M(rs.$$.fragment,t),on=n(t),Ms=i(t,"P",{"data-svelte-h":!0}),p(Ms)!=="svelte-1s7e55r"&&(Ms.innerHTML=Lo),pn=n(t),cs=i(t,"UL",{"data-svelte-h":!0}),p(cs)!=="svelte-1rdzqgp"&&(cs.innerHTML=Po),rn=n(t),M(q.$$.fragment,t),Mn=n(t),M(ys.$$.fragment,t),cn=n(t),us=i(t,"P",{"data-svelte-h":!0}),p(us)!=="svelte-w29vry"&&(us.textContent=Do),yn=n(t),ms=i(t,"UL",{"data-svelte-h":!0}),p(ms)!=="svelte-1fmzhdy"&&(ms.innerHTML=Ko),un=n(t),M(ds.$$.fragment,t),mn=n(t),hs=i(t,"P",{"data-svelte-h":!0}),p(hs)!=="svelte-jvvtjt"&&(hs.innerHTML=Oo),dn=n(t),Js=i(t,"P",{"data-svelte-h":!0}),p(Js)!=="svelte-f0ucf0"&&(Js.textContent=ti),hn=n(t),Ts=i(t,"UL",{"data-svelte-h":!0}),p(Ts)!=="svelte-doa6oc"&&(Ts.innerHTML=ei),Jn=n(t),M(Us.$$.fragment,t),Tn=n(t),ws=i(t,"P",{"data-svelte-h":!0}),p(ws)!=="svelte-180ap61"&&(ws.textContent=si),Un=n(t),M(js.$$.fragment,t),wn=n(t),fs=i(t,"P",{"data-svelte-h":!0}),p(fs)!=="svelte-1bv602"&&(fs.textContent=li),jn=n(t),M(Is.$$.fragment,t),fn=n(t),gs=i(t,"P",{"data-svelte-h":!0}),p(gs)!=="svelte-1mq7g8k"&&(gs.textContent=ai),In=n(t),M(bs.$$.fragment,t),gn=n(t),$s=i(t,"P",{}),ui($s).forEach(s),this.h()},h(){mi(d,"name","hf:doc:metadata"),mi(d,"content",ki)},m(t,e){wi(document.head,d),l(t,T,e),l(t,h,e),l(t,U,e),c(g,t,e),l(t,f,e),c($,t,e),l(t,G,e),l(t,b,e),l(t,w,e),l(t,C,e),l(t,Gs,e),l(t,V,e),l(t,xs,e),c(S,t,e),l(t,vs,e),l(t,z,e),l(t,Bs,e),l(t,A,e),l(t,Zs,e),c(R,t,e),l(t,ks,e),l(t,X,e),l(t,Ns,e),c(E,t,e),l(t,Qs,e),l(t,H,e),l(t,qs,e),l(t,Y,e),l(t,Ws,e),c(F,t,e),l(t,_s,e),l(t,L,e),l(t,Vs,e),c(P,t,e),l(t,Ss,e),l(t,D,e),l(t,zs,e),c(K,t,e),l(t,As,e),l(t,O,e),l(t,Rs,e),c(tt,t,e),l(t,Xs,e),l(t,et,e),l(t,Es,e),c(st,t,e),l(t,Hs,e),l(t,lt,e),l(t,Ys,e),c(at,t,e),l(t,Fs,e),c(nt,t,e),l(t,Ls,e),l(t,ot,e),l(t,Ps,e),c(it,t,e),l(t,Ds,e),l(t,pt,e),l(t,Ks,e),c(rt,t,e),l(t,Os,e),l(t,Mt,e),l(t,tl,e),c(ct,t,e),l(t,el,e),l(t,yt,e),l(t,sl,e),c(ut,t,e),l(t,ll,e),l(t,mt,e),l(t,al,e),l(t,dt,e),l(t,nl,e),c(ht,t,e),l(t,ol,e),l(t,Jt,e),l(t,il,e),l(t,Tt,e),l(t,pl,e),c(Ut,t,e),l(t,rl,e),l(t,wt,e),l(t,Ml,e),l(t,jt,e),l(t,cl,e),c(x,t,e),l(t,yl,e),c(ft,t,e),l(t,ul,e),l(t,It,e),l(t,ml,e),c(gt,t,e),l(t,dl,e),l(t,bt,e),l(t,hl,e),c(Ct,t,e),l(t,Jl,e),l(t,$t,e),l(t,Tl,e),c(v,t,e),l(t,Ul,e),c(Gt,t,e),l(t,wl,e),l(t,xt,e),l(t,jl,e),l(t,vt,e),l(t,fl,e),c(Bt,t,e),l(t,Il,e),l(t,Zt,e),l(t,gl,e),c(kt,t,e),l(t,bl,e),l(t,Nt,e),l(t,Cl,e),l(t,Qt,e),l(t,$l,e),c(qt,t,e),l(t,Gl,e),l(t,Wt,e),l(t,xl,e),l(t,_t,e),l(t,vl,e),c(Vt,t,e),l(t,Bl,e),l(t,St,e),l(t,Zl,e),l(t,zt,e),l(t,kl,e),c(At,t,e),l(t,Nl,e),l(t,Rt,e),l(t,Ql,e),c(Xt,t,e),l(t,ql,e),l(t,Et,e),l(t,Wl,e),c(Ht,t,e),l(t,_l,e),l(t,Yt,e),l(t,Vl,e),c(Ft,t,e),l(t,Sl,e),l(t,Lt,e),l(t,zl,e),c(Pt,t,e),l(t,Al,e),l(t,Dt,e),l(t,Rl,e),c(B,t,e),l(t,Xl,e),l(t,Kt,e),l(t,El,e),c(Ot,t,e),l(t,Hl,e),c(Z,t,e),l(t,Yl,e),l(t,te,e),l(t,Fl,e),c(ee,t,e),l(t,Ll,e),c(k,t,e),l(t,Pl,e),l(t,se,e),l(t,Dl,e),c(le,t,e),l(t,Kl,e),l(t,ae,e),l(t,Ol,e),c(ne,t,e),l(t,ta,e),l(t,oe,e),l(t,ea,e),c(ie,t,e),l(t,sa,e),l(t,pe,e),l(t,la,e),l(t,re,e),l(t,aa,e),c(Me,t,e),l(t,na,e),l(t,ce,e),l(t,oa,e),c(ye,t,e),l(t,ia,e),l(t,ue,e),l(t,pa,e),l(t,me,e),l(t,ra,e),c(de,t,e),l(t,Ma,e),c(he,t,e),l(t,ca,e),l(t,Je,e),l(t,ya,e),l(t,Te,e),l(t,ua,e),c(Ue,t,e),l(t,ma,e),c(we,t,e),l(t,da,e),l(t,je,e),l(t,ha,e),c(fe,t,e),l(t,Ja,e),l(t,Ie,e),l(t,Ta,e),c(ge,t,e),l(t,Ua,e),l(t,be,e),l(t,wa,e),l(t,Ce,e),l(t,ja,e),l(t,$e,e),l(t,fa,e),c(Ge,t,e),l(t,Ia,e),l(t,xe,e),l(t,ga,e),c(ve,t,e),l(t,ba,e),c(Be,t,e),l(t,Ca,e),l(t,Ze,e),l(t,$a,e),c(ke,t,e),l(t,Ga,e),l(t,Ne,e),l(t,xa,e),c(Qe,t,e),l(t,va,e),l(t,qe,e),l(t,Ba,e),c(N,t,e),l(t,Za,e),c(We,t,e),l(t,ka,e),l(t,_e,e),l(t,Na,e),l(t,Ve,e),l(t,Qa,e),l(t,Se,e),l(t,qa,e),c(ze,t,e),l(t,Wa,e),l(t,Ae,e),l(t,_a,e),l(t,Re,e),l(t,Va,e),c(Xe,t,e),l(t,Sa,e),l(t,Ee,e),l(t,za,e),c(He,t,e),l(t,Aa,e),l(t,Ye,e),l(t,Ra,e),c(Fe,t,e),l(t,Xa,e),l(t,Le,e),l(t,Ea,e),c(Pe,t,e),l(t,Ha,e),l(t,De,e),l(t,Ya,e),l(t,Ke,e),l(t,Fa,e),l(t,Oe,e),l(t,La,e),c(ts,t,e),l(t,Pa,e),c(Q,t,e),l(t,Da,e),l(t,es,e),l(t,Ka,e),l(t,ss,e),l(t,Oa,e),c(ls,t,e),l(t,tn,e),l(t,as,e),l(t,en,e),c(ns,t,e),l(t,sn,e),l(t,os,e),l(t,ln,e),c(is,t,e),l(t,an,e),l(t,ps,e),l(t,nn,e),c(rs,t,e),l(t,on,e),l(t,Ms,e),l(t,pn,e),l(t,cs,e),l(t,rn,e),c(q,t,e),l(t,Mn,e),c(ys,t,e),l(t,cn,e),l(t,us,e),l(t,yn,e),l(t,ms,e),l(t,un,e),c(ds,t,e),l(t,mn,e),l(t,hs,e),l(t,dn,e),l(t,Js,e),l(t,hn,e),l(t,Ts,e),l(t,Jn,e),c(Us,t,e),l(t,Tn,e),l(t,ws,e),l(t,Un,e),c(js,t,e),l(t,wn,e),l(t,fs,e),l(t,jn,e),c(Is,t,e),l(t,fn,e),l(t,gs,e),l(t,In,e),c(bs,t,e),l(t,gn,e),l(t,$s,e),bn=!0},p(t,[e]){const ni={};e&2&&(ni.$$scope={dirty:e,ctx:t}),x.$set(ni);const oi={};e&2&&(oi.$$scope={dirty:e,ctx:t}),v.$set(oi);const ii={};e&2&&(ii.$$scope={dirty:e,ctx:t}),B.$set(ii);const pi={};e&2&&(pi.$$scope={dirty:e,ctx:t}),Z.$set(pi);const ri={};e&2&&(ri.$$scope={dirty:e,ctx:t}),k.$set(ri);const Mi={};e&2&&(Mi.$$scope={dirty:e,ctx:t}),N.$set(Mi);const ci={};e&2&&(ci.$$scope={dirty:e,ctx:t}),Q.$set(ci);const yi={};e&2&&(yi.$$scope={dirty:e,ctx:t}),q.$set(yi)},i(t){bn||(y(g.$$.fragment,t),y($.$$.fragment,t),y(S.$$.fragment,t),y(R.$$.fragment,t),y(E.$$.fragment,t),y(F.$$.fragment,t),y(P.$$.fragment,t),y(K.$$.fragment,t),y(tt.$$.fragment,t),y(st.$$.fragment,t),y(at.$$.fragment,t),y(nt.$$.fragment,t),y(it.$$.fragment,t),y(rt.$$.fragment,t),y(ct.$$.fragment,t),y(ut.$$.fragment,t),y(ht.$$.fragment,t),y(Ut.$$.fragment,t),y(x.$$.fragment,t),y(ft.$$.fragment,t),y(gt.$$.fragment,t),y(Ct.$$.fragment,t),y(v.$$.fragment,t),y(Gt.$$.fragment,t),y(Bt.$$.fragment,t),y(kt.$$.fragment,t),y(qt.$$.fragment,t),y(Vt.$$.fragment,t),y(At.$$.fragment,t),y(Xt.$$.fragment,t),y(Ht.$$.fragment,t),y(Ft.$$.fragment,t),y(Pt.$$.fragment,t),y(B.$$.fragment,t),y(Ot.$$.fragment,t),y(Z.$$.fragment,t),y(ee.$$.fragment,t),y(k.$$.fragment,t),y(le.$$.fragment,t),y(ne.$$.fragment,t),y(ie.$$.fragment,t),y(Me.$$.fragment,t),y(ye.$$.fragment,t),y(de.$$.fragment,t),y(he.$$.fragment,t),y(Ue.$$.fragment,t),y(we.$$.fragment,t),y(fe.$$.fragment,t),y(ge.$$.fragment,t),y(Ge.$$.fragment,t),y(ve.$$.fragment,t),y(Be.$$.fragment,t),y(ke.$$.fragment,t),y(Qe.$$.fragment,t),y(N.$$.fragment,t),y(We.$$.fragment,t),y(ze.$$.fragment,t),y(Xe.$$.fragment,t),y(He.$$.fragment,t),y(Fe.$$.fragment,t),y(Pe.$$.fragment,t),y(ts.$$.fragment,t),y(Q.$$.fragment,t),y(ls.$$.fragment,t),y(ns.$$.fragment,t),y(is.$$.fragment,t),y(rs.$$.fragment,t),y(q.$$.fragment,t),y(ys.$$.fragment,t),y(ds.$$.fragment,t),y(Us.$$.fragment,t),y(js.$$.fragment,t),y(Is.$$.fragment,t),y(bs.$$.fragment,t),bn=!0)},o(t){u(g.$$.fragment,t),u($.$$.fragment,t),u(S.$$.fragment,t),u(R.$$.fragment,t),u(E.$$.fragment,t),u(F.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(st.$$.fragment,t),u(at.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(rt.$$.fragment,t),u(ct.$$.fragment,t),u(ut.$$.fragment,t),u(ht.$$.fragment,t),u(Ut.$$.fragment,t),u(x.$$.fragment,t),u(ft.$$.fragment,t),u(gt.$$.fragment,t),u(Ct.$$.fragment,t),u(v.$$.fragment,t),u(Gt.$$.fragment,t),u(Bt.$$.fragment,t),u(kt.$$.fragment,t),u(qt.$$.fragment,t),u(Vt.$$.fragment,t),u(At.$$.fragment,t),u(Xt.$$.fragment,t),u(Ht.$$.fragment,t),u(Ft.$$.fragment,t),u(Pt.$$.fragment,t),u(B.$$.fragment,t),u(Ot.$$.fragment,t),u(Z.$$.fragment,t),u(ee.$$.fragment,t),u(k.$$.fragment,t),u(le.$$.fragment,t),u(ne.$$.fragment,t),u(ie.$$.fragment,t),u(Me.$$.fragment,t),u(ye.$$.fragment,t),u(de.$$.fragment,t),u(he.$$.fragment,t),u(Ue.$$.fragment,t),u(we.$$.fragment,t),u(fe.$$.fragment,t),u(ge.$$.fragment,t),u(Ge.$$.fragment,t),u(ve.$$.fragment,t),u(Be.$$.fragment,t),u(ke.$$.fragment,t),u(Qe.$$.fragment,t),u(N.$$.fragment,t),u(We.$$.fragment,t),u(ze.$$.fragment,t),u(Xe.$$.fragment,t),u(He.$$.fragment,t),u(Fe.$$.fragment,t),u(Pe.$$.fragment,t),u(ts.$$.fragment,t),u(Q.$$.fragment,t),u(ls.$$.fragment,t),u(ns.$$.fragment,t),u(is.$$.fragment,t),u(rs.$$.fragment,t),u(q.$$.fragment,t),u(ys.$$.fragment,t),u(ds.$$.fragment,t),u(Us.$$.fragment,t),u(js.$$.fragment,t),u(Is.$$.fragment,t),u(bs.$$.fragment,t),bn=!1},d(t){t&&(s(T),s(h),s(U),s(f),s(G),s(b),s(w),s(C),s(Gs),s(V),s(xs),s(vs),s(z),s(Bs),s(A),s(Zs),s(ks),s(X),s(Ns),s(Qs),s(H),s(qs),s(Y),s(Ws),s(_s),s(L),s(Vs),s(Ss),s(D),s(zs),s(As),s(O),s(Rs),s(Xs),s(et),s(Es),s(Hs),s(lt),s(Ys),s(Fs),s(Ls),s(ot),s(Ps),s(Ds),s(pt),s(Ks),s(Os),s(Mt),s(tl),s(el),s(yt),s(sl),s(ll),s(mt),s(al),s(dt),s(nl),s(ol),s(Jt),s(il),s(Tt),s(pl),s(rl),s(wt),s(Ml),s(jt),s(cl),s(yl),s(ul),s(It),s(ml),s(dl),s(bt),s(hl),s(Jl),s($t),s(Tl),s(Ul),s(wl),s(xt),s(jl),s(vt),s(fl),s(Il),s(Zt),s(gl),s(bl),s(Nt),s(Cl),s(Qt),s($l),s(Gl),s(Wt),s(xl),s(_t),s(vl),s(Bl),s(St),s(Zl),s(zt),s(kl),s(Nl),s(Rt),s(Ql),s(ql),s(Et),s(Wl),s(_l),s(Yt),s(Vl),s(Sl),s(Lt),s(zl),s(Al),s(Dt),s(Rl),s(Xl),s(Kt),s(El),s(Hl),s(Yl),s(te),s(Fl),s(Ll),s(Pl),s(se),s(Dl),s(Kl),s(ae),s(Ol),s(ta),s(oe),s(ea),s(sa),s(pe),s(la),s(re),s(aa),s(na),s(ce),s(oa),s(ia),s(ue),s(pa),s(me),s(ra),s(Ma),s(ca),s(Je),s(ya),s(Te),s(ua),s(ma),s(da),s(je),s(ha),s(Ja),s(Ie),s(Ta),s(Ua),s(be),s(wa),s(Ce),s(ja),s($e),s(fa),s(Ia),s(xe),s(ga),s(ba),s(Ca),s(Ze),s($a),s(Ga),s(Ne),s(xa),s(va),s(qe),s(Ba),s(Za),s(ka),s(_e),s(Na),s(Ve),s(Qa),s(Se),s(qa),s(Wa),s(Ae),s(_a),s(Re),s(Va),s(Sa),s(Ee),s(za),s(Aa),s(Ye),s(Ra),s(Xa),s(Le),s(Ea),s(Ha),s(De),s(Ya),s(Ke),s(Fa),s(Oe),s(La),s(Pa),s(Da),s(es),s(Ka),s(ss),s(Oa),s(tn),s(as),s(en),s(sn),s(os),s(ln),s(an),s(ps),s(nn),s(on),s(Ms),s(pn),s(cs),s(rn),s(Mn),s(cn),s(us),s(yn),s(ms),s(un),s(mn),s(hs),s(dn),s(Js),s(hn),s(Ts),s(Jn),s(Tn),s(ws),s(Un),s(wn),s(fs),s(jn),s(fn),s(gs),s(In),s(gn),s($s)),s(d),m(g,t),m($,t),m(S,t),m(R,t),m(E,t),m(F,t),m(P,t),m(K,t),m(tt,t),m(st,t),m(at,t),m(nt,t),m(it,t),m(rt,t),m(ct,t),m(ut,t),m(ht,t),m(Ut,t),m(x,t),m(ft,t),m(gt,t),m(Ct,t),m(v,t),m(Gt,t),m(Bt,t),m(kt,t),m(qt,t),m(Vt,t),m(At,t),m(Xt,t),m(Ht,t),m(Ft,t),m(Pt,t),m(B,t),m(Ot,t),m(Z,t),m(ee,t),m(k,t),m(le,t),m(ne,t),m(ie,t),m(Me,t),m(ye,t),m(de,t),m(he,t),m(Ue,t),m(we,t),m(fe,t),m(ge,t),m(Ge,t),m(ve,t),m(Be,t),m(ke,t),m(Qe,t),m(N,t),m(We,t),m(ze,t),m(Xe,t),m(He,t),m(Fe,t),m(Pe,t),m(ts,t),m(Q,t),m(ls,t),m(ns,t),m(is,t),m(rs,t),m(q,t),m(ys,t),m(ds,t),m(Us,t),m(js,t),m(Is,t),m(bs,t)}}}const ki='{"title":"Chat Templates","local":"chat-templates","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"What does “continue_final_message” do?","local":"what-does-continuefinalmessage-do","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: Extra inputs to chat templates","local":"advanced-extra-inputs-to-chat-templates","sections":[],"depth":2},{"title":"Advanced: Tool use / function calling","local":"advanced-tool-use--function-calling","sections":[{"title":"Passing tool results to the model","local":"passing-tool-results-to-the-model","sections":[],"depth":3},{"title":"A complete tool use example","local":"a-complete-tool-use-example","sections":[],"depth":3},{"title":"Understanding tool schemas","local":"understanding-tool-schemas","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Retrieval-augmented generation","local":"advanced-retrieval-augmented-generation","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"Why do some models have multiple templates?","local":"why-do-some-models-have-multiple-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"Trimming whitespace","local":"trimming-whitespace","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Callable functions","local":"callable-functions","sections":[],"depth":3},{"title":"Compatibility with non-Python Jinja","local":"compatibility-with-non-python-jinja","sections":[],"depth":3},{"title":"Writing and debugging larger templates","local":"writing-and-debugging-larger-templates","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ni(I){return hi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Si extends Ji{constructor(d){super(),Ti(this,d,Ni,Zi,di,{})}}export{Si as component};
