import{s as ru,o as iu,n as j}from"../chunks/scheduler.6062bdaf.js";import{S as pu,i as mu,g as m,s as a,r as u,A as du,h as d,f as i,c as l,j as x,u as g,x as T,k as $,y as o,a as c,v as f,d as h,t as _,w as b}from"../chunks/index.4bca734e.js";import{T as Z}from"../chunks/Tip.b9ac1f03.js";import{D as k}from"../chunks/Docstring.d7918b6d.js";import{C as U}from"../chunks/CodeBlock.fa01571c.js";import{E as R}from"../chunks/ExampleCodeBlock.d27cbfa4.js";import{H as J,E as cu}from"../chunks/EditOnGithub.74ab2baa.js";function uu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function gu(w){let n,M="Example of text generation:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function fu(w){let n,M="Example using <code>transformers.pipelines</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function hu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function _u(w){let n,M="Example of feature extraction:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12vwt80"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function bu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function yu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Tu(w){let n,M="Example of text generation:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Mu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function vu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function wu(w){let n,M="Example of single-label classification:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-ykxpe4"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function xu(w){let n,M="Example using <code>transformers.pipelines</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function $u(w){let n,M="Example using zero-shot-classification <code>transformers.pipelines</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1vtj8d2"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function ku(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function ju(w){let n,M="Example of token classification:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-rtgw80"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Ju(w){let n,M="Example using <code>transformers.pipelines</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Ru(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Uu(w){let n,M="Example of mutliple choice:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-lfckvi"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Iu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Cu(w){let n,M="Example of question answering:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ml1brl"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Zu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Wu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Nu(w){let n,M="Example of image classification:",r,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1nh3zco"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Su(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Fu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Gu(w){let n,M="Example of semantic segmentation:",r,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wzzaup"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Ou(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Xu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Vu(w){let n,M="Example of audio classification:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1mp8f15"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function qu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function zu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Lu(w){let n,M="Example of audio frame classification:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12boqdm"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Bu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Hu(w){let n,M="Example of CTC:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mdyxnj"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Eu(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Pu(w){let n,M="Example of text generation:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Qu(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Du(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Yu(w){let n,M="Example of Audio XVector:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1kzdm5c"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function Au(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Ku(w){let n,M="Example of text generation:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function eg(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function tg(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function ng(w){let n,M="Example of pix2struct:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11ikyn3"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function og(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function sg(w){let n,M="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-6kynse"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function ag(w){let n,M="Example using <code>transformers.pipelines</code>(only if the task is supported):",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-xxeb0k"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function lg(w){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function rg(w){let n,M="Example of feature extraction:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12vwt80"&&(n.textContent=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function ig(w){let n,M="Example using <code>transformers.pipeline</code>:",r,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),g(s.$$.fragment,t)},m(t,v){c(t,n,v),c(t,r,v),f(s,t,v),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(r)),b(s,t)}}}function pg(w){let n,M,r,s,y,t,v,fl,yn,td="The following ORT classes are available for instantiating a base model class without a specific head.",hl,Tn,_l,I,Mn,Rr,gs,nd="Base class for implementing models using ONNX Runtime.",Ur,fs,od=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,Ir,hs,sd="Class attributes:",Cr,_s,ad=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,Zr,bs,ld="Common attributes:",Wr,ys,rd=`<li>model (<code>ort.InferenceSession</code>) — The ONNX Runtime InferenceSession that is running the model.</li> <li>config (<a href="https://huggingface.co/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> — The configuration of the model.</li> <li>use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) — Whether to use I/O bindings with <strong>ONNX Runtime
with the CUDAExecutionProvider</strong>, this can significantly speedup inference depending on the task.</li> <li>model_save_dir (<code>Path</code>) — The directory where the model exported to ONNX is saved.
By defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the
cache directory is used.</li> <li>providers (\`List[str]) — The list of execution providers available to ONNX Runtime.</li>`,Nr,mt,vn,Sr,Ts,id="Returns whether this model can generate sequences with <code>.generate()</code>.",Fr,dt,wn,Gr,Ms,pd="Instantiate a pretrained model from a pre-trained model configuration.",Or,ct,xn,Xr,vs,md=`Loads an ONNX Inference session with a given provider. Default provider is <code>CPUExecutionProvider</code> to match the
default behaviour in PyTorch/TensorFlow/JAX.`,Vr,ut,$n,qr,ws,dd="Raises an error if IO Binding is requested although the tensor used are numpy arrays.",zr,gt,kn,Lr,xs,cd="Initializes attributes that may be shared among several ONNX Runtime inference sesssions.",Br,ft,jn,Hr,$s,ud="Changes the ONNX Runtime provider according to the device.",bl,Jn,yl,Rn,gd="The following ORT classes are available for the following natural language processing tasks.",Tl,Un,Ml,N,In,Er,ks,fd="ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt_bigcode, gpt_neo, gpt_neox, gptj, llama.",Pr,js,hd=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Qr,Js,_d='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Dr,le,Cn,Yr,Rs,bd="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",Ar,ht,Kr,_t,ei,bt,vl,Zn,wl,S,Wn,ti,Us,yd="ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.",ni,Is,Td=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,oi,Cs,Md='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',si,re,Nn,ai,Zs,vd="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",li,yt,ri,Tt,ii,Mt,xl,Sn,$l,F,Fn,pi,Ws,wd="Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot_small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.",mi,Ns,xd=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,di,Ss,$d='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ci,ie,Gn,ui,Fs,kd="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",gi,vt,fi,wt,hi,xt,kl,On,jl,G,Xn,_i,Gs,jd=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,bi,Os,Jd=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,yi,Xs,Rd='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ti,W,Vn,Mi,Vs,Ud="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",vi,$t,wi,kt,xi,jt,$i,Jt,Jl,qn,Rl,O,zn,ki,qs,Id=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,ji,zs,Cd=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ji,Ls,Zd='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ri,pe,Ln,Ui,Bs,Wd="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",Ii,Rt,Ci,Ut,Zi,It,Ul,Bn,Il,X,Hn,Wi,Hs,Nd=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Ni,Es,Sd=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Si,Ps,Fd='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Fi,Ae,En,Gi,Qs,Gd="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",Oi,Ct,Xi,Zt,Cl,Pn,Zl,V,Qn,Vi,Ds,Od="ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.",qi,Ys,Xd=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,zi,As,Vd='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Li,me,Dn,Bi,Ks,qd="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",Hi,Wt,Ei,Nt,Pi,St,Wl,Yn,Nl,An,zd="The following ORT classes are available for the following computer vision tasks.",Sl,Kn,Fl,q,eo,Qi,ea,Ld="ONNX Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, data2vec_vision, deit, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, vit.",Di,ta,Bd=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Yi,na,Hd='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ai,de,to,Ki,oa,Ed="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",ep,Ft,tp,Gt,np,Ot,Gl,no,Ol,z,oo,op,sa,Pd="ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports segformer.",sp,aa,Qd=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ap,la,Dd='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',lp,ce,so,rp,ra,Yd="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",ip,Xt,pp,Vt,mp,qt,Xl,ao,Vl,lo,Ad="The following ORT classes are available for the following audio tasks.",ql,ro,zl,L,io,dp,ia,Kd=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,cp,pa,ec=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,up,ma,tc='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',gp,ue,po,fp,da,nc="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",hp,zt,_p,Lt,bp,Bt,Ll,mo,Bl,B,co,yp,ca,oc="ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Tp,ua,sc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Mp,ga,ac='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',vp,Ke,uo,wp,fa,lc="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",xp,Ht,$p,Et,Hl,go,El,H,fo,kp,ha,rc="ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",jp,_a,ic=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Jp,ba,pc='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Rp,et,ho,Up,ya,mc="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",Ip,Pt,Cp,Qt,Pl,_o,Ql,E,bo,Zp,Ta,dc="Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.",Wp,Ma,cc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Np,va,uc='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Sp,ge,yo,Fp,wa,gc="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",Gp,Dt,Op,Yt,Xp,At,Dl,To,Yl,P,Mo,Vp,xa,fc="ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",qp,$a,hc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,zp,ka,_c='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Lp,tt,vo,Bp,ja,bc="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",Hp,Kt,Ep,en,Al,wo,Kl,xo,yc="The following ORT classes are available for the following multimodal tasks.",er,$o,tr,Q,ko,Pp,Ja,Tc="VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.",Qp,Ra,Mc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Dp,Ua,vc='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Yp,fe,jo,Ap,Ia,wc="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",Kp,tn,em,nn,tm,on,nr,Jo,or,D,Ro,nm,Ca,xc="Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.",om,Za,$c=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,sm,Wa,kc='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',am,nt,Uo,lm,Na,jc="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",rm,sn,im,an,sr,Io,ar,Co,Jc="The following ORT classes are available for the following custom tasks.",lr,Zo,rr,Y,Wo,pm,Sa,Rc="ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.",mm,Fa,Uc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,dm,Ga,Ic='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',cm,he,No,um,Oa,Cc="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",gm,ln,fm,rn,hm,pn,ir,So,pr,A,Fo,_m,Xa,Zc="ONNX Model for feature-extraction task.",bm,Va,Wc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ym,qa,Nc='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Tm,_e,Go,Mm,za,Sc="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",vm,mn,wm,dn,xm,cn,mr,Oo,dr,Xo,cr,K,Vo,$m,La,Fc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline" rel="nofollow">diffusers.StableDiffusionPipeline</a>.',km,Ba,Gc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,jm,Ha,Oc='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Jm,un,qo,Rm,Ea,Xc="Function invoked when calling the pipeline for generation.",ur,zo,gr,ee,Lo,Um,Pa,Vc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionImg2ImgPipeline</a>.',Im,Qa,qc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Cm,Da,zc='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Zm,gn,Bo,Wm,Ya,Lc="Function invoked when calling the pipeline for generation.",fr,Ho,hr,te,Eo,Nm,Aa,Bc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline" rel="nofollow">diffusers.StableDiffusionInpaintPipeline</a>.',Sm,Ka,Hc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Fm,el,Ec='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Gm,fn,Po,Om,tl,Pc="Function invoked when calling the pipeline for generation.",_r,Qo,br,ne,Do,Xm,nl,Qc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline" rel="nofollow">diffusers.StableDiffusionXLPipeline</a>.',Vm,ol,Dc=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,qm,sl,Yc='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',zm,hn,Yo,Lm,al,Ac="Function invoked when calling the pipeline for generation.",yr,Ao,Tr,oe,Ko,Bm,ll,Kc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionXLImg2ImgPipeline</a>.',Hm,rl,eu=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Em,il,tu='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Pm,_n,es,Qm,pl,nu="Function invoked when calling the pipeline for generation.",Mr,ts,vr,se,ns,Dm,ml,ou='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/latent_consistency#diffusers.LatentConsistencyModelPipeline" rel="nofollow">diffusers.LatentConsistencyModelPipeline</a>.',Ym,dl,su=`This model inherits from <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Am,cl,au='This class should be initialized using the <a href="/docs/optimum/pr_1939/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Km,bn,os,ed,ul,lu="Function invoked when calling the pipeline for generation.",wr,ss,xr,gl,$r;return y=new J({props:{title:"Models",local:"models",headingTag:"h1"}}),v=new J({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),Tn=new J({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),Mn=new k({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L141"}}),vn=new k({props:{name:"can_generate",anchor:"optimum.onnxruntime.ORTModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1005"}}),wn=new k({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": typing.Union[str, pathlib.Path]"},{name:"export",val:": bool = False"},{name:"force_download",val:": bool = False"},{name:"use_auth_token",val:": typing.Union[bool, str, NoneType] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"subfolder",val:": str = ''"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"},{name:"local_files_only",val:": bool = False"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.from_transformers",description:`<strong>from_transformers</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> contains a vanilla Transformers checkpoint.`,name:"from_transformers"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
Deprecated. Please use the <code>token</code> argument instead.`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for
possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>), &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_io_binding",description:`<strong>use_io_binding</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.`,name:"use_io_binding"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Will be passed to the underlying model loading methods.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L660",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`,parameterGroups:[{title:"Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_cache",description:`<strong>use_cache</strong> (<code>Optional[bool]</code>, defaults to <code>True</code>) &#x2014;
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,name:"use_cache"}]},{title:"Parameters for ORTModelForCausalLM",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_merged",description:`<strong>use_merged</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,name:"use_merged"}]}]}}),xn=new k({props:{name:"load_model",anchor:"optimum.onnxruntime.ORTModel.load_model",parameters:[{name:"path",val:": typing.Union[str, pathlib.Path]"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.load_model.path",description:`<strong>path</strong> (<code>Union[str, Path]</code>) &#x2014;
Path of the ONNX model.`,name:"path"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a>
for possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.load_model.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>) &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionary corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L340"}}),$n=new k({props:{name:"raise_on_numpy_input_io_binding",anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding",parameters:[{name:"use_torch",val:": bool"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding.use_torch",description:`<strong>use_torch</strong> (<code>bool</code>) &#x2014;
Whether the tensor used during inference are of type torch.Tensor or not.`,name:"use_torch"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L899"}}),kn=new k({props:{name:"shared_attributes_init",anchor:"optimum.onnxruntime.ORTModel.shared_attributes_init",parameters:[{name:"model",val:": InferenceSession"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L184"}}),jn=new k({props:{name:"to",anchor:"optimum.onnxruntime.ORTModel.to",parameters:[{name:"device",val:": typing.Union[torch.device, str, int]"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.to.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code> or <code>int</code>) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run
the model on the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too.`,name:"device"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L300",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the model placed on the requested device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`}}),Jn=new J({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),Un=new J({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),In=new k({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_decoder.py#L117"}}),Cn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache_branch",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_decoder.py#L186"}}),ht=new Z({props:{$$slots:{default:[uu]},$$scope:{ctx:w}}}),_t=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[gu]},$$scope:{ctx:w}}}),bt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[fu]},$$scope:{ctx:w}}}),Zn=new J({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),Wn=new k({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1204"}}),Nn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1211"}}),yt=new Z({props:{$$slots:{default:[hu]},$$scope:{ctx:w}}}),Tt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[_u]},$$scope:{ctx:w}}}),Mt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[bu]},$$scope:{ctx:w}}}),Sn=new J({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),Fn=new k({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_seq2seq.py#L1138"}}),Gn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_seq2seq.py#L1192"}}),vt=new Z({props:{$$slots:{default:[yu]},$$scope:{ctx:w}}}),wt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[Tu]},$$scope:{ctx:w}}}),xt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[Mu]},$$scope:{ctx:w}}}),On=new J({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),Xn=new k({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1399"}}),Vn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1407"}}),$t=new Z({props:{$$slots:{default:[vu]},$$scope:{ctx:w}}}),kt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[wu]},$$scope:{ctx:w}}}),jt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[xu]},$$scope:{ctx:w}}}),Jt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[$u]},$$scope:{ctx:w}}}),qn=new J({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),zn=new k({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1488"}}),Ln=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1497"}}),Rt=new Z({props:{$$slots:{default:[ku]},$$scope:{ctx:w}}}),Ut=new R({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[ju]},$$scope:{ctx:w}}}),It=new R({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[Ju]},$$scope:{ctx:w}}}),Bn=new J({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),Hn=new k({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1572"}}),En=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1580"}}),Ct=new Z({props:{$$slots:{default:[Ru]},$$scope:{ctx:w}}}),Zt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[Uu]},$$scope:{ctx:w}}}),Pn=new J({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),Qn=new k({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1293"}}),Dn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1300"}}),Wt=new Z({props:{$$slots:{default:[Iu]},$$scope:{ctx:w}}}),Nt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[Cu]},$$scope:{ctx:w}}}),St=new R({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[Zu]},$$scope:{ctx:w}}}),Yn=new J({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),Kn=new J({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),eo=new k({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1665"}}),to=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1672"}}),Ft=new Z({props:{$$slots:{default:[Wu]},$$scope:{ctx:w}}}),Gt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[Nu]},$$scope:{ctx:w}}}),Ot=new R({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[Su]},$$scope:{ctx:w}}}),no=new J({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),oo=new k({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1753"}}),so=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1760"}}),Xt=new Z({props:{$$slots:{default:[Fu]},$$scope:{ctx:w}}}),Vt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[Gu]},$$scope:{ctx:w}}}),qt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[Ou]},$$scope:{ctx:w}}}),ao=new J({props:{title:"Audio",local:"audio",headingTag:"h2"}}),ro=new J({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),io=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1845"}}),po=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_features",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1876"}}),zt=new Z({props:{$$slots:{default:[Xu]},$$scope:{ctx:w}}}),Lt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[Vu]},$$scope:{ctx:w}}}),Bt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[qu]},$$scope:{ctx:w}}}),mo=new J({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),co=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L2130"}}),uo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L2137"}}),Ht=new Z({props:{$$slots:{default:[zu]},$$scope:{ctx:w}}}),Et=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[Lu]},$$scope:{ctx:w}}}),go=new J({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),fo=new k({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1957"}}),ho=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1964"}}),Pt=new Z({props:{$$slots:{default:[Bu]},$$scope:{ctx:w}}}),Qt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[Hu]},$$scope:{ctx:w}}}),_o=new J({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),bo=new k({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_seq2seq.py#L1283"}}),yo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_seq2seq.py#L1325"}}),Dt=new Z({props:{$$slots:{default:[Eu]},$$scope:{ctx:w}}}),Yt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[Pu]},$$scope:{ctx:w}}}),At=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[Qu]},$$scope:{ctx:w}}}),To=new J({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),Mo=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L2052"}}),vo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L2059"}}),Kt=new Z({props:{$$slots:{default:[Du]},$$scope:{ctx:w}}}),en=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[Yu]},$$scope:{ctx:w}}}),wo=new J({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),$o=new J({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),ko=new k({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_seq2seq.py#L1854"}}),jo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_seq2seq.py#L1912"}}),tn=new Z({props:{$$slots:{default:[Au]},$$scope:{ctx:w}}}),nn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[Ku]},$$scope:{ctx:w}}}),on=new R({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[eg]},$$scope:{ctx:w}}}),Jo=new J({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),Ro=new k({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_seq2seq.py#L1999"}}),Uo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_seq2seq.py#L2011"}}),sn=new Z({props:{$$slots:{default:[tg]},$$scope:{ctx:w}}}),an=new R({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[ng]},$$scope:{ctx:w}}}),Io=new J({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),Zo=new J({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),Wo=new k({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L2202"}}),No=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**model_inputs",val:": typing.Union[torch.Tensor, numpy.ndarray]"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L2207"}}),ln=new Z({props:{$$slots:{default:[og]},$$scope:{ctx:w}}}),rn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[sg]},$$scope:{ctx:w}}}),pn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[ag]},$$scope:{ctx:w}}}),So=new J({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),Fo=new k({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1048"}}),Go=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_ort.py#L1055"}}),mn=new Z({props:{$$slots:{default:[lg]},$$scope:{ctx:w}}}),dn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[rg]},$$scope:{ctx:w}}}),cn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[ig]},$$scope:{ctx:w}}}),Oo=new J({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),Xo=new J({props:{title:"ORTStableDiffusionPipeline",local:"optimum.onnxruntime.ORTStableDiffusionPipeline",headingTag:"h4"}}),Vo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_diffusion.py#L564"}}),qo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"guidance_rescale",val:": float = 0.0"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/pipelines/diffusers/pipeline_stable_diffusion.py#L202",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),zo=new J({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),Lo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_diffusion.py#L573"}}),Bo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[numpy.ndarray, PIL.Image.Image] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>Union[np.ndarray, PIL.Image.Image]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/pipelines/diffusers/pipeline_stable_diffusion_img2img.py#L76",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Ho=new J({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),Eo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_diffusion.py#L582"}}),Po=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": Image"},{name:"mask_image",val:": Image"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing a masked image batch which will be upscaled.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/pipelines/diffusers/pipeline_stable_diffusion_inpaint.py#L98",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Qo=new J({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),Do=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_diffusion.py#L649"}}),Yo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/pipelines/diffusers/pipeline_stable_diffusion_xl.py#L263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Ao=new J({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),Ko=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_diffusion.py#L658"}}),es=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[numpy.ndarray, PIL.Image.Image] = None"},{name:"strength",val:": float = 0.3"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>Union[np.ndarray, PIL.Image.Image]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/pipelines/diffusers/pipeline_stable_diffusion_xl_img2img.py#L267",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),ts=new J({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",headingTag:"h4"}}),ns=new k({props:{name:"class optimum.onnxruntime.ORTLatentConsistencyModelPipeline",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/onnxruntime/modeling_diffusion.py#L591"}}),os=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 4"},{name:"original_inference_steps",val:": int = None"},{name:"guidance_scale",val:": float = 8.5"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/vr_1939/optimum/pipelines/diffusers/pipeline_latent_consistency.py#L30",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),ss=new cu({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/onnxruntime/package_reference/modeling_ort.mdx"}}),{c(){n=m("meta"),M=a(),r=m("p"),s=a(),u(y.$$.fragment),t=a(),u(v.$$.fragment),fl=a(),yn=m("p"),yn.textContent=td,hl=a(),u(Tn.$$.fragment),_l=a(),I=m("div"),u(Mn.$$.fragment),Rr=a(),gs=m("p"),gs.textContent=nd,Ur=a(),fs=m("p"),fs.innerHTML=od,Ir=a(),hs=m("p"),hs.textContent=sd,Cr=a(),_s=m("ul"),_s.innerHTML=ad,Zr=a(),bs=m("p"),bs.textContent=ld,Wr=a(),ys=m("ul"),ys.innerHTML=rd,Nr=a(),mt=m("div"),u(vn.$$.fragment),Sr=a(),Ts=m("p"),Ts.innerHTML=id,Fr=a(),dt=m("div"),u(wn.$$.fragment),Gr=a(),Ms=m("p"),Ms.textContent=pd,Or=a(),ct=m("div"),u(xn.$$.fragment),Xr=a(),vs=m("p"),vs.innerHTML=md,Vr=a(),ut=m("div"),u($n.$$.fragment),qr=a(),ws=m("p"),ws.textContent=dd,zr=a(),gt=m("div"),u(kn.$$.fragment),Lr=a(),xs=m("p"),xs.textContent=cd,Br=a(),ft=m("div"),u(jn.$$.fragment),Hr=a(),$s=m("p"),$s.textContent=ud,bl=a(),u(Jn.$$.fragment),yl=a(),Rn=m("p"),Rn.textContent=gd,Tl=a(),u(Un.$$.fragment),Ml=a(),N=m("div"),u(In.$$.fragment),Er=a(),ks=m("p"),ks.textContent=fd,Pr=a(),js=m("p"),js.innerHTML=hd,Qr=a(),Js=m("p"),Js.innerHTML=_d,Dr=a(),le=m("div"),u(Cn.$$.fragment),Yr=a(),Rs=m("p"),Rs.innerHTML=bd,Ar=a(),u(ht.$$.fragment),Kr=a(),u(_t.$$.fragment),ei=a(),u(bt.$$.fragment),vl=a(),u(Zn.$$.fragment),wl=a(),S=m("div"),u(Wn.$$.fragment),ti=a(),Us=m("p"),Us.textContent=yd,ni=a(),Is=m("p"),Is.innerHTML=Td,oi=a(),Cs=m("p"),Cs.innerHTML=Md,si=a(),re=m("div"),u(Nn.$$.fragment),ai=a(),Zs=m("p"),Zs.innerHTML=vd,li=a(),u(yt.$$.fragment),ri=a(),u(Tt.$$.fragment),ii=a(),u(Mt.$$.fragment),xl=a(),u(Sn.$$.fragment),$l=a(),F=m("div"),u(Fn.$$.fragment),pi=a(),Ws=m("p"),Ws.textContent=wd,mi=a(),Ns=m("p"),Ns.innerHTML=xd,di=a(),Ss=m("p"),Ss.innerHTML=$d,ci=a(),ie=m("div"),u(Gn.$$.fragment),ui=a(),Fs=m("p"),Fs.innerHTML=kd,gi=a(),u(vt.$$.fragment),fi=a(),u(wt.$$.fragment),hi=a(),u(xt.$$.fragment),kl=a(),u(On.$$.fragment),jl=a(),G=m("div"),u(Xn.$$.fragment),_i=a(),Gs=m("p"),Gs.textContent=jd,bi=a(),Os=m("p"),Os.innerHTML=Jd,yi=a(),Xs=m("p"),Xs.innerHTML=Rd,Ti=a(),W=m("div"),u(Vn.$$.fragment),Mi=a(),Vs=m("p"),Vs.innerHTML=Ud,vi=a(),u($t.$$.fragment),wi=a(),u(kt.$$.fragment),xi=a(),u(jt.$$.fragment),$i=a(),u(Jt.$$.fragment),Jl=a(),u(qn.$$.fragment),Rl=a(),O=m("div"),u(zn.$$.fragment),ki=a(),qs=m("p"),qs.textContent=Id,ji=a(),zs=m("p"),zs.innerHTML=Cd,Ji=a(),Ls=m("p"),Ls.innerHTML=Zd,Ri=a(),pe=m("div"),u(Ln.$$.fragment),Ui=a(),Bs=m("p"),Bs.innerHTML=Wd,Ii=a(),u(Rt.$$.fragment),Ci=a(),u(Ut.$$.fragment),Zi=a(),u(It.$$.fragment),Ul=a(),u(Bn.$$.fragment),Il=a(),X=m("div"),u(Hn.$$.fragment),Wi=a(),Hs=m("p"),Hs.textContent=Nd,Ni=a(),Es=m("p"),Es.innerHTML=Sd,Si=a(),Ps=m("p"),Ps.innerHTML=Fd,Fi=a(),Ae=m("div"),u(En.$$.fragment),Gi=a(),Qs=m("p"),Qs.innerHTML=Gd,Oi=a(),u(Ct.$$.fragment),Xi=a(),u(Zt.$$.fragment),Cl=a(),u(Pn.$$.fragment),Zl=a(),V=m("div"),u(Qn.$$.fragment),Vi=a(),Ds=m("p"),Ds.textContent=Od,qi=a(),Ys=m("p"),Ys.innerHTML=Xd,zi=a(),As=m("p"),As.innerHTML=Vd,Li=a(),me=m("div"),u(Dn.$$.fragment),Bi=a(),Ks=m("p"),Ks.innerHTML=qd,Hi=a(),u(Wt.$$.fragment),Ei=a(),u(Nt.$$.fragment),Pi=a(),u(St.$$.fragment),Wl=a(),u(Yn.$$.fragment),Nl=a(),An=m("p"),An.textContent=zd,Sl=a(),u(Kn.$$.fragment),Fl=a(),q=m("div"),u(eo.$$.fragment),Qi=a(),ea=m("p"),ea.textContent=Ld,Di=a(),ta=m("p"),ta.innerHTML=Bd,Yi=a(),na=m("p"),na.innerHTML=Hd,Ai=a(),de=m("div"),u(to.$$.fragment),Ki=a(),oa=m("p"),oa.innerHTML=Ed,ep=a(),u(Ft.$$.fragment),tp=a(),u(Gt.$$.fragment),np=a(),u(Ot.$$.fragment),Gl=a(),u(no.$$.fragment),Ol=a(),z=m("div"),u(oo.$$.fragment),op=a(),sa=m("p"),sa.textContent=Pd,sp=a(),aa=m("p"),aa.innerHTML=Qd,ap=a(),la=m("p"),la.innerHTML=Dd,lp=a(),ce=m("div"),u(so.$$.fragment),rp=a(),ra=m("p"),ra.innerHTML=Yd,ip=a(),u(Xt.$$.fragment),pp=a(),u(Vt.$$.fragment),mp=a(),u(qt.$$.fragment),Xl=a(),u(ao.$$.fragment),Vl=a(),lo=m("p"),lo.textContent=Ad,ql=a(),u(ro.$$.fragment),zl=a(),L=m("div"),u(io.$$.fragment),dp=a(),ia=m("p"),ia.textContent=Kd,cp=a(),pa=m("p"),pa.innerHTML=ec,up=a(),ma=m("p"),ma.innerHTML=tc,gp=a(),ue=m("div"),u(po.$$.fragment),fp=a(),da=m("p"),da.innerHTML=nc,hp=a(),u(zt.$$.fragment),_p=a(),u(Lt.$$.fragment),bp=a(),u(Bt.$$.fragment),Ll=a(),u(mo.$$.fragment),Bl=a(),B=m("div"),u(co.$$.fragment),yp=a(),ca=m("p"),ca.textContent=oc,Tp=a(),ua=m("p"),ua.innerHTML=sc,Mp=a(),ga=m("p"),ga.innerHTML=ac,vp=a(),Ke=m("div"),u(uo.$$.fragment),wp=a(),fa=m("p"),fa.innerHTML=lc,xp=a(),u(Ht.$$.fragment),$p=a(),u(Et.$$.fragment),Hl=a(),u(go.$$.fragment),El=a(),H=m("div"),u(fo.$$.fragment),kp=a(),ha=m("p"),ha.textContent=rc,jp=a(),_a=m("p"),_a.innerHTML=ic,Jp=a(),ba=m("p"),ba.innerHTML=pc,Rp=a(),et=m("div"),u(ho.$$.fragment),Up=a(),ya=m("p"),ya.innerHTML=mc,Ip=a(),u(Pt.$$.fragment),Cp=a(),u(Qt.$$.fragment),Pl=a(),u(_o.$$.fragment),Ql=a(),E=m("div"),u(bo.$$.fragment),Zp=a(),Ta=m("p"),Ta.textContent=dc,Wp=a(),Ma=m("p"),Ma.innerHTML=cc,Np=a(),va=m("p"),va.innerHTML=uc,Sp=a(),ge=m("div"),u(yo.$$.fragment),Fp=a(),wa=m("p"),wa.innerHTML=gc,Gp=a(),u(Dt.$$.fragment),Op=a(),u(Yt.$$.fragment),Xp=a(),u(At.$$.fragment),Dl=a(),u(To.$$.fragment),Yl=a(),P=m("div"),u(Mo.$$.fragment),Vp=a(),xa=m("p"),xa.textContent=fc,qp=a(),$a=m("p"),$a.innerHTML=hc,zp=a(),ka=m("p"),ka.innerHTML=_c,Lp=a(),tt=m("div"),u(vo.$$.fragment),Bp=a(),ja=m("p"),ja.innerHTML=bc,Hp=a(),u(Kt.$$.fragment),Ep=a(),u(en.$$.fragment),Al=a(),u(wo.$$.fragment),Kl=a(),xo=m("p"),xo.textContent=yc,er=a(),u($o.$$.fragment),tr=a(),Q=m("div"),u(ko.$$.fragment),Pp=a(),Ja=m("p"),Ja.textContent=Tc,Qp=a(),Ra=m("p"),Ra.innerHTML=Mc,Dp=a(),Ua=m("p"),Ua.innerHTML=vc,Yp=a(),fe=m("div"),u(jo.$$.fragment),Ap=a(),Ia=m("p"),Ia.innerHTML=wc,Kp=a(),u(tn.$$.fragment),em=a(),u(nn.$$.fragment),tm=a(),u(on.$$.fragment),nr=a(),u(Jo.$$.fragment),or=a(),D=m("div"),u(Ro.$$.fragment),nm=a(),Ca=m("p"),Ca.textContent=xc,om=a(),Za=m("p"),Za.innerHTML=$c,sm=a(),Wa=m("p"),Wa.innerHTML=kc,am=a(),nt=m("div"),u(Uo.$$.fragment),lm=a(),Na=m("p"),Na.innerHTML=jc,rm=a(),u(sn.$$.fragment),im=a(),u(an.$$.fragment),sr=a(),u(Io.$$.fragment),ar=a(),Co=m("p"),Co.textContent=Jc,lr=a(),u(Zo.$$.fragment),rr=a(),Y=m("div"),u(Wo.$$.fragment),pm=a(),Sa=m("p"),Sa.textContent=Rc,mm=a(),Fa=m("p"),Fa.innerHTML=Uc,dm=a(),Ga=m("p"),Ga.innerHTML=Ic,cm=a(),he=m("div"),u(No.$$.fragment),um=a(),Oa=m("p"),Oa.innerHTML=Cc,gm=a(),u(ln.$$.fragment),fm=a(),u(rn.$$.fragment),hm=a(),u(pn.$$.fragment),ir=a(),u(So.$$.fragment),pr=a(),A=m("div"),u(Fo.$$.fragment),_m=a(),Xa=m("p"),Xa.textContent=Zc,bm=a(),Va=m("p"),Va.innerHTML=Wc,ym=a(),qa=m("p"),qa.innerHTML=Nc,Tm=a(),_e=m("div"),u(Go.$$.fragment),Mm=a(),za=m("p"),za.innerHTML=Sc,vm=a(),u(mn.$$.fragment),wm=a(),u(dn.$$.fragment),xm=a(),u(cn.$$.fragment),mr=a(),u(Oo.$$.fragment),dr=a(),u(Xo.$$.fragment),cr=a(),K=m("div"),u(Vo.$$.fragment),$m=a(),La=m("p"),La.innerHTML=Fc,km=a(),Ba=m("p"),Ba.innerHTML=Gc,jm=a(),Ha=m("p"),Ha.innerHTML=Oc,Jm=a(),un=m("div"),u(qo.$$.fragment),Rm=a(),Ea=m("p"),Ea.textContent=Xc,ur=a(),u(zo.$$.fragment),gr=a(),ee=m("div"),u(Lo.$$.fragment),Um=a(),Pa=m("p"),Pa.innerHTML=Vc,Im=a(),Qa=m("p"),Qa.innerHTML=qc,Cm=a(),Da=m("p"),Da.innerHTML=zc,Zm=a(),gn=m("div"),u(Bo.$$.fragment),Wm=a(),Ya=m("p"),Ya.textContent=Lc,fr=a(),u(Ho.$$.fragment),hr=a(),te=m("div"),u(Eo.$$.fragment),Nm=a(),Aa=m("p"),Aa.innerHTML=Bc,Sm=a(),Ka=m("p"),Ka.innerHTML=Hc,Fm=a(),el=m("p"),el.innerHTML=Ec,Gm=a(),fn=m("div"),u(Po.$$.fragment),Om=a(),tl=m("p"),tl.textContent=Pc,_r=a(),u(Qo.$$.fragment),br=a(),ne=m("div"),u(Do.$$.fragment),Xm=a(),nl=m("p"),nl.innerHTML=Qc,Vm=a(),ol=m("p"),ol.innerHTML=Dc,qm=a(),sl=m("p"),sl.innerHTML=Yc,zm=a(),hn=m("div"),u(Yo.$$.fragment),Lm=a(),al=m("p"),al.textContent=Ac,yr=a(),u(Ao.$$.fragment),Tr=a(),oe=m("div"),u(Ko.$$.fragment),Bm=a(),ll=m("p"),ll.innerHTML=Kc,Hm=a(),rl=m("p"),rl.innerHTML=eu,Em=a(),il=m("p"),il.innerHTML=tu,Pm=a(),_n=m("div"),u(es.$$.fragment),Qm=a(),pl=m("p"),pl.textContent=nu,Mr=a(),u(ts.$$.fragment),vr=a(),se=m("div"),u(ns.$$.fragment),Dm=a(),ml=m("p"),ml.innerHTML=ou,Ym=a(),dl=m("p"),dl.innerHTML=su,Am=a(),cl=m("p"),cl.innerHTML=au,Km=a(),bn=m("div"),u(os.$$.fragment),ed=a(),ul=m("p"),ul.textContent=lu,wr=a(),u(ss.$$.fragment),xr=a(),gl=m("p"),this.h()},l(e){const p=du("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(i),M=l(e),r=d(e,"P",{}),x(r).forEach(i),s=l(e),g(y.$$.fragment,e),t=l(e),g(v.$$.fragment,e),fl=l(e),yn=d(e,"P",{"data-svelte-h":!0}),T(yn)!=="svelte-uyecg"&&(yn.textContent=td),hl=l(e),g(Tn.$$.fragment,e),_l=l(e),I=d(e,"DIV",{class:!0});var C=x(I);g(Mn.$$.fragment,C),Rr=l(C),gs=d(C,"P",{"data-svelte-h":!0}),T(gs)!=="svelte-12yueui"&&(gs.textContent=nd),Ur=l(C),fs=d(C,"P",{"data-svelte-h":!0}),T(fs)!=="svelte-zarm0s"&&(fs.innerHTML=od),Ir=l(C),hs=d(C,"P",{"data-svelte-h":!0}),T(hs)!=="svelte-wz8va1"&&(hs.textContent=sd),Cr=l(C),_s=d(C,"UL",{"data-svelte-h":!0}),T(_s)!=="svelte-qpxha0"&&(_s.innerHTML=ad),Zr=l(C),bs=d(C,"P",{"data-svelte-h":!0}),T(bs)!=="svelte-86gko0"&&(bs.textContent=ld),Wr=l(C),ys=d(C,"UL",{"data-svelte-h":!0}),T(ys)!=="svelte-1hugf7m"&&(ys.innerHTML=rd),Nr=l(C),mt=d(C,"DIV",{class:!0});var as=x(mt);g(vn.$$.fragment,as),Sr=l(as),Ts=d(as,"P",{"data-svelte-h":!0}),T(Ts)!=="svelte-1r2xt0l"&&(Ts.innerHTML=id),as.forEach(i),Fr=l(C),dt=d(C,"DIV",{class:!0});var ls=x(dt);g(wn.$$.fragment,ls),Gr=l(ls),Ms=d(ls,"P",{"data-svelte-h":!0}),T(Ms)!=="svelte-18vxhwp"&&(Ms.textContent=pd),ls.forEach(i),Or=l(C),ct=d(C,"DIV",{class:!0});var rs=x(ct);g(xn.$$.fragment,rs),Xr=l(rs),vs=d(rs,"P",{"data-svelte-h":!0}),T(vs)!=="svelte-1sb2z5w"&&(vs.innerHTML=md),rs.forEach(i),Vr=l(C),ut=d(C,"DIV",{class:!0});var is=x(ut);g($n.$$.fragment,is),qr=l(is),ws=d(is,"P",{"data-svelte-h":!0}),T(ws)!=="svelte-h8ck7o"&&(ws.textContent=dd),is.forEach(i),zr=l(C),gt=d(C,"DIV",{class:!0});var ps=x(gt);g(kn.$$.fragment,ps),Lr=l(ps),xs=d(ps,"P",{"data-svelte-h":!0}),T(xs)!=="svelte-1b4tey4"&&(xs.textContent=cd),ps.forEach(i),Br=l(C),ft=d(C,"DIV",{class:!0});var ms=x(ft);g(jn.$$.fragment,ms),Hr=l(ms),$s=d(ms,"P",{"data-svelte-h":!0}),T($s)!=="svelte-1tdm1u4"&&($s.textContent=ud),ms.forEach(i),C.forEach(i),bl=l(e),g(Jn.$$.fragment,e),yl=l(e),Rn=d(e,"P",{"data-svelte-h":!0}),T(Rn)!=="svelte-1tlroh"&&(Rn.textContent=gd),Tl=l(e),g(Un.$$.fragment,e),Ml=l(e),N=d(e,"DIV",{class:!0});var be=x(N);g(In.$$.fragment,be),Er=l(be),ks=d(be,"P",{"data-svelte-h":!0}),T(ks)!=="svelte-pig4vj"&&(ks.textContent=fd),Pr=l(be),js=d(be,"P",{"data-svelte-h":!0}),T(js)!=="svelte-juaqsv"&&(js.innerHTML=hd),Qr=l(be),Js=d(be,"P",{"data-svelte-h":!0}),T(Js)!=="svelte-1uq7qf6"&&(Js.innerHTML=_d),Dr=l(be),le=d(be,"DIV",{class:!0});var ye=x(le);g(Cn.$$.fragment,ye),Yr=l(ye),Rs=d(ye,"P",{"data-svelte-h":!0}),T(Rs)!=="svelte-1ox9av6"&&(Rs.innerHTML=bd),Ar=l(ye),g(ht.$$.fragment,ye),Kr=l(ye),g(_t.$$.fragment,ye),ei=l(ye),g(bt.$$.fragment,ye),ye.forEach(i),be.forEach(i),vl=l(e),g(Zn.$$.fragment,e),wl=l(e),S=d(e,"DIV",{class:!0});var Te=x(S);g(Wn.$$.fragment,Te),ti=l(Te),Us=d(Te,"P",{"data-svelte-h":!0}),T(Us)!=="svelte-lnzl0e"&&(Us.textContent=yd),ni=l(Te),Is=d(Te,"P",{"data-svelte-h":!0}),T(Is)!=="svelte-juaqsv"&&(Is.innerHTML=Td),oi=l(Te),Cs=d(Te,"P",{"data-svelte-h":!0}),T(Cs)!=="svelte-1uq7qf6"&&(Cs.innerHTML=Md),si=l(Te),re=d(Te,"DIV",{class:!0});var Me=x(re);g(Nn.$$.fragment,Me),ai=l(Me),Zs=d(Me,"P",{"data-svelte-h":!0}),T(Zs)!=="svelte-1xqof9m"&&(Zs.innerHTML=vd),li=l(Me),g(yt.$$.fragment,Me),ri=l(Me),g(Tt.$$.fragment,Me),ii=l(Me),g(Mt.$$.fragment,Me),Me.forEach(i),Te.forEach(i),xl=l(e),g(Sn.$$.fragment,e),$l=l(e),F=d(e,"DIV",{class:!0});var ve=x(F);g(Fn.$$.fragment,ve),pi=l(ve),Ws=d(ve,"P",{"data-svelte-h":!0}),T(Ws)!=="svelte-t6z30i"&&(Ws.textContent=wd),mi=l(ve),Ns=d(ve,"P",{"data-svelte-h":!0}),T(Ns)!=="svelte-juaqsv"&&(Ns.innerHTML=xd),di=l(ve),Ss=d(ve,"P",{"data-svelte-h":!0}),T(Ss)!=="svelte-1uq7qf6"&&(Ss.innerHTML=$d),ci=l(ve),ie=d(ve,"DIV",{class:!0});var we=x(ie);g(Gn.$$.fragment,we),ui=l(we),Fs=d(we,"P",{"data-svelte-h":!0}),T(Fs)!=="svelte-n65k7h"&&(Fs.innerHTML=kd),gi=l(we),g(vt.$$.fragment,we),fi=l(we),g(wt.$$.fragment,we),hi=l(we),g(xt.$$.fragment,we),we.forEach(i),ve.forEach(i),kl=l(e),g(On.$$.fragment,e),jl=l(e),G=d(e,"DIV",{class:!0});var xe=x(G);g(Xn.$$.fragment,xe),_i=l(xe),Gs=d(xe,"P",{"data-svelte-h":!0}),T(Gs)!=="svelte-ixbo5n"&&(Gs.textContent=jd),bi=l(xe),Os=d(xe,"P",{"data-svelte-h":!0}),T(Os)!=="svelte-juaqsv"&&(Os.innerHTML=Jd),yi=l(xe),Xs=d(xe,"P",{"data-svelte-h":!0}),T(Xs)!=="svelte-1uq7qf6"&&(Xs.innerHTML=Rd),Ti=l(xe),W=d(xe,"DIV",{class:!0});var ae=x(W);g(Vn.$$.fragment,ae),Mi=l(ae),Vs=d(ae,"P",{"data-svelte-h":!0}),T(Vs)!=="svelte-1plx9t"&&(Vs.innerHTML=Ud),vi=l(ae),g($t.$$.fragment,ae),wi=l(ae),g(kt.$$.fragment,ae),xi=l(ae),g(jt.$$.fragment,ae),$i=l(ae),g(Jt.$$.fragment,ae),ae.forEach(i),xe.forEach(i),Jl=l(e),g(qn.$$.fragment,e),Rl=l(e),O=d(e,"DIV",{class:!0});var $e=x(O);g(zn.$$.fragment,$e),ki=l($e),qs=d($e,"P",{"data-svelte-h":!0}),T(qs)!=="svelte-1l2d2mz"&&(qs.textContent=Id),ji=l($e),zs=d($e,"P",{"data-svelte-h":!0}),T(zs)!=="svelte-juaqsv"&&(zs.innerHTML=Cd),Ji=l($e),Ls=d($e,"P",{"data-svelte-h":!0}),T(Ls)!=="svelte-1uq7qf6"&&(Ls.innerHTML=Zd),Ri=l($e),pe=d($e,"DIV",{class:!0});var ke=x(pe);g(Ln.$$.fragment,ke),Ui=l(ke),Bs=d(ke,"P",{"data-svelte-h":!0}),T(Bs)!=="svelte-xk2xch"&&(Bs.innerHTML=Wd),Ii=l(ke),g(Rt.$$.fragment,ke),Ci=l(ke),g(Ut.$$.fragment,ke),Zi=l(ke),g(It.$$.fragment,ke),ke.forEach(i),$e.forEach(i),Ul=l(e),g(Bn.$$.fragment,e),Il=l(e),X=d(e,"DIV",{class:!0});var je=x(X);g(Hn.$$.fragment,je),Wi=l(je),Hs=d(je,"P",{"data-svelte-h":!0}),T(Hs)!=="svelte-1oobrgk"&&(Hs.textContent=Nd),Ni=l(je),Es=d(je,"P",{"data-svelte-h":!0}),T(Es)!=="svelte-juaqsv"&&(Es.innerHTML=Sd),Si=l(je),Ps=d(je,"P",{"data-svelte-h":!0}),T(Ps)!=="svelte-1uq7qf6"&&(Ps.innerHTML=Fd),Fi=l(je),Ae=d(je,"DIV",{class:!0});var ot=x(Ae);g(En.$$.fragment,ot),Gi=l(ot),Qs=d(ot,"P",{"data-svelte-h":!0}),T(Qs)!=="svelte-qesv8n"&&(Qs.innerHTML=Gd),Oi=l(ot),g(Ct.$$.fragment,ot),Xi=l(ot),g(Zt.$$.fragment,ot),ot.forEach(i),je.forEach(i),Cl=l(e),g(Pn.$$.fragment,e),Zl=l(e),V=d(e,"DIV",{class:!0});var Je=x(V);g(Qn.$$.fragment,Je),Vi=l(Je),Ds=d(Je,"P",{"data-svelte-h":!0}),T(Ds)!=="svelte-1hsozsl"&&(Ds.textContent=Od),qi=l(Je),Ys=d(Je,"P",{"data-svelte-h":!0}),T(Ys)!=="svelte-juaqsv"&&(Ys.innerHTML=Xd),zi=l(Je),As=d(Je,"P",{"data-svelte-h":!0}),T(As)!=="svelte-1uq7qf6"&&(As.innerHTML=Vd),Li=l(Je),me=d(Je,"DIV",{class:!0});var Re=x(me);g(Dn.$$.fragment,Re),Bi=l(Re),Ks=d(Re,"P",{"data-svelte-h":!0}),T(Ks)!=="svelte-1dng7rw"&&(Ks.innerHTML=qd),Hi=l(Re),g(Wt.$$.fragment,Re),Ei=l(Re),g(Nt.$$.fragment,Re),Pi=l(Re),g(St.$$.fragment,Re),Re.forEach(i),Je.forEach(i),Wl=l(e),g(Yn.$$.fragment,e),Nl=l(e),An=d(e,"P",{"data-svelte-h":!0}),T(An)!=="svelte-1h2y3wu"&&(An.textContent=zd),Sl=l(e),g(Kn.$$.fragment,e),Fl=l(e),q=d(e,"DIV",{class:!0});var Ue=x(q);g(eo.$$.fragment,Ue),Qi=l(Ue),ea=d(Ue,"P",{"data-svelte-h":!0}),T(ea)!=="svelte-lp0at6"&&(ea.textContent=Ld),Di=l(Ue),ta=d(Ue,"P",{"data-svelte-h":!0}),T(ta)!=="svelte-juaqsv"&&(ta.innerHTML=Bd),Yi=l(Ue),na=d(Ue,"P",{"data-svelte-h":!0}),T(na)!=="svelte-1uq7qf6"&&(na.innerHTML=Hd),Ai=l(Ue),de=d(Ue,"DIV",{class:!0});var Ie=x(de);g(to.$$.fragment,Ie),Ki=l(Ie),oa=d(Ie,"P",{"data-svelte-h":!0}),T(oa)!=="svelte-1azuqx"&&(oa.innerHTML=Ed),ep=l(Ie),g(Ft.$$.fragment,Ie),tp=l(Ie),g(Gt.$$.fragment,Ie),np=l(Ie),g(Ot.$$.fragment,Ie),Ie.forEach(i),Ue.forEach(i),Gl=l(e),g(no.$$.fragment,e),Ol=l(e),z=d(e,"DIV",{class:!0});var Ce=x(z);g(oo.$$.fragment,Ce),op=l(Ce),sa=d(Ce,"P",{"data-svelte-h":!0}),T(sa)!=="svelte-mw2y5y"&&(sa.textContent=Pd),sp=l(Ce),aa=d(Ce,"P",{"data-svelte-h":!0}),T(aa)!=="svelte-juaqsv"&&(aa.innerHTML=Qd),ap=l(Ce),la=d(Ce,"P",{"data-svelte-h":!0}),T(la)!=="svelte-1uq7qf6"&&(la.innerHTML=Dd),lp=l(Ce),ce=d(Ce,"DIV",{class:!0});var Ze=x(ce);g(so.$$.fragment,Ze),rp=l(Ze),ra=d(Ze,"P",{"data-svelte-h":!0}),T(ra)!=="svelte-1s27jle"&&(ra.innerHTML=Yd),ip=l(Ze),g(Xt.$$.fragment,Ze),pp=l(Ze),g(Vt.$$.fragment,Ze),mp=l(Ze),g(qt.$$.fragment,Ze),Ze.forEach(i),Ce.forEach(i),Xl=l(e),g(ao.$$.fragment,e),Vl=l(e),lo=d(e,"P",{"data-svelte-h":!0}),T(lo)!=="svelte-liyjdz"&&(lo.textContent=Ad),ql=l(e),g(ro.$$.fragment,e),zl=l(e),L=d(e,"DIV",{class:!0});var We=x(L);g(io.$$.fragment,We),dp=l(We),ia=d(We,"P",{"data-svelte-h":!0}),T(ia)!=="svelte-yleggj"&&(ia.textContent=Kd),cp=l(We),pa=d(We,"P",{"data-svelte-h":!0}),T(pa)!=="svelte-juaqsv"&&(pa.innerHTML=ec),up=l(We),ma=d(We,"P",{"data-svelte-h":!0}),T(ma)!=="svelte-1uq7qf6"&&(ma.innerHTML=tc),gp=l(We),ue=d(We,"DIV",{class:!0});var Ne=x(ue);g(po.$$.fragment,Ne),fp=l(Ne),da=d(Ne,"P",{"data-svelte-h":!0}),T(da)!=="svelte-p67kxo"&&(da.innerHTML=nc),hp=l(Ne),g(zt.$$.fragment,Ne),_p=l(Ne),g(Lt.$$.fragment,Ne),bp=l(Ne),g(Bt.$$.fragment,Ne),Ne.forEach(i),We.forEach(i),Ll=l(e),g(mo.$$.fragment,e),Bl=l(e),B=d(e,"DIV",{class:!0});var Se=x(B);g(co.$$.fragment,Se),yp=l(Se),ca=d(Se,"P",{"data-svelte-h":!0}),T(ca)!=="svelte-lyybxc"&&(ca.textContent=oc),Tp=l(Se),ua=d(Se,"P",{"data-svelte-h":!0}),T(ua)!=="svelte-juaqsv"&&(ua.innerHTML=sc),Mp=l(Se),ga=d(Se,"P",{"data-svelte-h":!0}),T(ga)!=="svelte-1uq7qf6"&&(ga.innerHTML=ac),vp=l(Se),Ke=d(Se,"DIV",{class:!0});var st=x(Ke);g(uo.$$.fragment,st),wp=l(st),fa=d(st,"P",{"data-svelte-h":!0}),T(fa)!=="svelte-18aced7"&&(fa.innerHTML=lc),xp=l(st),g(Ht.$$.fragment,st),$p=l(st),g(Et.$$.fragment,st),st.forEach(i),Se.forEach(i),Hl=l(e),g(go.$$.fragment,e),El=l(e),H=d(e,"DIV",{class:!0});var Fe=x(H);g(fo.$$.fragment,Fe),kp=l(Fe),ha=d(Fe,"P",{"data-svelte-h":!0}),T(ha)!=="svelte-xbkga4"&&(ha.textContent=rc),jp=l(Fe),_a=d(Fe,"P",{"data-svelte-h":!0}),T(_a)!=="svelte-juaqsv"&&(_a.innerHTML=ic),Jp=l(Fe),ba=d(Fe,"P",{"data-svelte-h":!0}),T(ba)!=="svelte-1uq7qf6"&&(ba.innerHTML=pc),Rp=l(Fe),et=d(Fe,"DIV",{class:!0});var at=x(et);g(ho.$$.fragment,at),Up=l(at),ya=d(at,"P",{"data-svelte-h":!0}),T(ya)!=="svelte-1szjv6u"&&(ya.innerHTML=mc),Ip=l(at),g(Pt.$$.fragment,at),Cp=l(at),g(Qt.$$.fragment,at),at.forEach(i),Fe.forEach(i),Pl=l(e),g(_o.$$.fragment,e),Ql=l(e),E=d(e,"DIV",{class:!0});var Ge=x(E);g(bo.$$.fragment,Ge),Zp=l(Ge),Ta=d(Ge,"P",{"data-svelte-h":!0}),T(Ta)!=="svelte-135bhh9"&&(Ta.textContent=dc),Wp=l(Ge),Ma=d(Ge,"P",{"data-svelte-h":!0}),T(Ma)!=="svelte-juaqsv"&&(Ma.innerHTML=cc),Np=l(Ge),va=d(Ge,"P",{"data-svelte-h":!0}),T(va)!=="svelte-1uq7qf6"&&(va.innerHTML=uc),Sp=l(Ge),ge=d(Ge,"DIV",{class:!0});var Oe=x(ge);g(yo.$$.fragment,Oe),Fp=l(Oe),wa=d(Oe,"P",{"data-svelte-h":!0}),T(wa)!=="svelte-1e3zkhy"&&(wa.innerHTML=gc),Gp=l(Oe),g(Dt.$$.fragment,Oe),Op=l(Oe),g(Yt.$$.fragment,Oe),Xp=l(Oe),g(At.$$.fragment,Oe),Oe.forEach(i),Ge.forEach(i),Dl=l(e),g(To.$$.fragment,e),Yl=l(e),P=d(e,"DIV",{class:!0});var Xe=x(P);g(Mo.$$.fragment,Xe),Vp=l(Xe),xa=d(Xe,"P",{"data-svelte-h":!0}),T(xa)!=="svelte-1bhc8y0"&&(xa.textContent=fc),qp=l(Xe),$a=d(Xe,"P",{"data-svelte-h":!0}),T($a)!=="svelte-juaqsv"&&($a.innerHTML=hc),zp=l(Xe),ka=d(Xe,"P",{"data-svelte-h":!0}),T(ka)!=="svelte-1uq7qf6"&&(ka.innerHTML=_c),Lp=l(Xe),tt=d(Xe,"DIV",{class:!0});var lt=x(tt);g(vo.$$.fragment,lt),Bp=l(lt),ja=d(lt,"P",{"data-svelte-h":!0}),T(ja)!=="svelte-1fuxgrl"&&(ja.innerHTML=bc),Hp=l(lt),g(Kt.$$.fragment,lt),Ep=l(lt),g(en.$$.fragment,lt),lt.forEach(i),Xe.forEach(i),Al=l(e),g(wo.$$.fragment,e),Kl=l(e),xo=d(e,"P",{"data-svelte-h":!0}),T(xo)!=="svelte-1gk58z"&&(xo.textContent=yc),er=l(e),g($o.$$.fragment,e),tr=l(e),Q=d(e,"DIV",{class:!0});var Ve=x(Q);g(ko.$$.fragment,Ve),Pp=l(Ve),Ja=d(Ve,"P",{"data-svelte-h":!0}),T(Ja)!=="svelte-1yhfevg"&&(Ja.textContent=Tc),Qp=l(Ve),Ra=d(Ve,"P",{"data-svelte-h":!0}),T(Ra)!=="svelte-juaqsv"&&(Ra.innerHTML=Mc),Dp=l(Ve),Ua=d(Ve,"P",{"data-svelte-h":!0}),T(Ua)!=="svelte-1uq7qf6"&&(Ua.innerHTML=vc),Yp=l(Ve),fe=d(Ve,"DIV",{class:!0});var qe=x(fe);g(jo.$$.fragment,qe),Ap=l(qe),Ia=d(qe,"P",{"data-svelte-h":!0}),T(Ia)!=="svelte-11xalzp"&&(Ia.innerHTML=wc),Kp=l(qe),g(tn.$$.fragment,qe),em=l(qe),g(nn.$$.fragment,qe),tm=l(qe),g(on.$$.fragment,qe),qe.forEach(i),Ve.forEach(i),nr=l(e),g(Jo.$$.fragment,e),or=l(e),D=d(e,"DIV",{class:!0});var ze=x(D);g(Ro.$$.fragment,ze),nm=l(ze),Ca=d(ze,"P",{"data-svelte-h":!0}),T(Ca)!=="svelte-80a148"&&(Ca.textContent=xc),om=l(ze),Za=d(ze,"P",{"data-svelte-h":!0}),T(Za)!=="svelte-juaqsv"&&(Za.innerHTML=$c),sm=l(ze),Wa=d(ze,"P",{"data-svelte-h":!0}),T(Wa)!=="svelte-1uq7qf6"&&(Wa.innerHTML=kc),am=l(ze),nt=d(ze,"DIV",{class:!0});var rt=x(nt);g(Uo.$$.fragment,rt),lm=l(rt),Na=d(rt,"P",{"data-svelte-h":!0}),T(Na)!=="svelte-eywb10"&&(Na.innerHTML=jc),rm=l(rt),g(sn.$$.fragment,rt),im=l(rt),g(an.$$.fragment,rt),rt.forEach(i),ze.forEach(i),sr=l(e),g(Io.$$.fragment,e),ar=l(e),Co=d(e,"P",{"data-svelte-h":!0}),T(Co)!=="svelte-1n8n3ms"&&(Co.textContent=Jc),lr=l(e),g(Zo.$$.fragment,e),rr=l(e),Y=d(e,"DIV",{class:!0});var Le=x(Y);g(Wo.$$.fragment,Le),pm=l(Le),Sa=d(Le,"P",{"data-svelte-h":!0}),T(Sa)!=="svelte-5pmyjn"&&(Sa.textContent=Rc),mm=l(Le),Fa=d(Le,"P",{"data-svelte-h":!0}),T(Fa)!=="svelte-juaqsv"&&(Fa.innerHTML=Uc),dm=l(Le),Ga=d(Le,"P",{"data-svelte-h":!0}),T(Ga)!=="svelte-1uq7qf6"&&(Ga.innerHTML=Ic),cm=l(Le),he=d(Le,"DIV",{class:!0});var Be=x(he);g(No.$$.fragment,Be),um=l(Be),Oa=d(Be,"P",{"data-svelte-h":!0}),T(Oa)!=="svelte-1usnw5b"&&(Oa.innerHTML=Cc),gm=l(Be),g(ln.$$.fragment,Be),fm=l(Be),g(rn.$$.fragment,Be),hm=l(Be),g(pn.$$.fragment,Be),Be.forEach(i),Le.forEach(i),ir=l(e),g(So.$$.fragment,e),pr=l(e),A=d(e,"DIV",{class:!0});var He=x(A);g(Fo.$$.fragment,He),_m=l(He),Xa=d(He,"P",{"data-svelte-h":!0}),T(Xa)!=="svelte-1rhquq6"&&(Xa.textContent=Zc),bm=l(He),Va=d(He,"P",{"data-svelte-h":!0}),T(Va)!=="svelte-juaqsv"&&(Va.innerHTML=Wc),ym=l(He),qa=d(He,"P",{"data-svelte-h":!0}),T(qa)!=="svelte-1uq7qf6"&&(qa.innerHTML=Nc),Tm=l(He),_e=d(He,"DIV",{class:!0});var Ee=x(_e);g(Go.$$.fragment,Ee),Mm=l(Ee),za=d(Ee,"P",{"data-svelte-h":!0}),T(za)!=="svelte-iqwqsz"&&(za.innerHTML=Sc),vm=l(Ee),g(mn.$$.fragment,Ee),wm=l(Ee),g(dn.$$.fragment,Ee),xm=l(Ee),g(cn.$$.fragment,Ee),Ee.forEach(i),He.forEach(i),mr=l(e),g(Oo.$$.fragment,e),dr=l(e),g(Xo.$$.fragment,e),cr=l(e),K=d(e,"DIV",{class:!0});var Pe=x(K);g(Vo.$$.fragment,Pe),$m=l(Pe),La=d(Pe,"P",{"data-svelte-h":!0}),T(La)!=="svelte-o3cjct"&&(La.innerHTML=Fc),km=l(Pe),Ba=d(Pe,"P",{"data-svelte-h":!0}),T(Ba)!=="svelte-juaqsv"&&(Ba.innerHTML=Gc),jm=l(Pe),Ha=d(Pe,"P",{"data-svelte-h":!0}),T(Ha)!=="svelte-1uq7qf6"&&(Ha.innerHTML=Oc),Jm=l(Pe),un=d(Pe,"DIV",{class:!0});var ds=x(un);g(qo.$$.fragment,ds),Rm=l(ds),Ea=d(ds,"P",{"data-svelte-h":!0}),T(Ea)!=="svelte-v78lg8"&&(Ea.textContent=Xc),ds.forEach(i),Pe.forEach(i),ur=l(e),g(zo.$$.fragment,e),gr=l(e),ee=d(e,"DIV",{class:!0});var Qe=x(ee);g(Lo.$$.fragment,Qe),Um=l(Qe),Pa=d(Qe,"P",{"data-svelte-h":!0}),T(Pa)!=="svelte-1ds9yih"&&(Pa.innerHTML=Vc),Im=l(Qe),Qa=d(Qe,"P",{"data-svelte-h":!0}),T(Qa)!=="svelte-juaqsv"&&(Qa.innerHTML=qc),Cm=l(Qe),Da=d(Qe,"P",{"data-svelte-h":!0}),T(Da)!=="svelte-1uq7qf6"&&(Da.innerHTML=zc),Zm=l(Qe),gn=d(Qe,"DIV",{class:!0});var cs=x(gn);g(Bo.$$.fragment,cs),Wm=l(cs),Ya=d(cs,"P",{"data-svelte-h":!0}),T(Ya)!=="svelte-v78lg8"&&(Ya.textContent=Lc),cs.forEach(i),Qe.forEach(i),fr=l(e),g(Ho.$$.fragment,e),hr=l(e),te=d(e,"DIV",{class:!0});var De=x(te);g(Eo.$$.fragment,De),Nm=l(De),Aa=d(De,"P",{"data-svelte-h":!0}),T(Aa)!=="svelte-1jlenwy"&&(Aa.innerHTML=Bc),Sm=l(De),Ka=d(De,"P",{"data-svelte-h":!0}),T(Ka)!=="svelte-juaqsv"&&(Ka.innerHTML=Hc),Fm=l(De),el=d(De,"P",{"data-svelte-h":!0}),T(el)!=="svelte-1uq7qf6"&&(el.innerHTML=Ec),Gm=l(De),fn=d(De,"DIV",{class:!0});var us=x(fn);g(Po.$$.fragment,us),Om=l(us),tl=d(us,"P",{"data-svelte-h":!0}),T(tl)!=="svelte-v78lg8"&&(tl.textContent=Pc),us.forEach(i),De.forEach(i),_r=l(e),g(Qo.$$.fragment,e),br=l(e),ne=d(e,"DIV",{class:!0});var Ye=x(ne);g(Do.$$.fragment,Ye),Xm=l(Ye),nl=d(Ye,"P",{"data-svelte-h":!0}),T(nl)!=="svelte-tg08kp"&&(nl.innerHTML=Qc),Vm=l(Ye),ol=d(Ye,"P",{"data-svelte-h":!0}),T(ol)!=="svelte-juaqsv"&&(ol.innerHTML=Dc),qm=l(Ye),sl=d(Ye,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-1uq7qf6"&&(sl.innerHTML=Yc),zm=l(Ye),hn=d(Ye,"DIV",{class:!0});var kr=x(hn);g(Yo.$$.fragment,kr),Lm=l(kr),al=d(kr,"P",{"data-svelte-h":!0}),T(al)!=="svelte-v78lg8"&&(al.textContent=Ac),kr.forEach(i),Ye.forEach(i),yr=l(e),g(Ao.$$.fragment,e),Tr=l(e),oe=d(e,"DIV",{class:!0});var it=x(oe);g(Ko.$$.fragment,it),Bm=l(it),ll=d(it,"P",{"data-svelte-h":!0}),T(ll)!=="svelte-zcp8nz"&&(ll.innerHTML=Kc),Hm=l(it),rl=d(it,"P",{"data-svelte-h":!0}),T(rl)!=="svelte-juaqsv"&&(rl.innerHTML=eu),Em=l(it),il=d(it,"P",{"data-svelte-h":!0}),T(il)!=="svelte-1uq7qf6"&&(il.innerHTML=tu),Pm=l(it),_n=d(it,"DIV",{class:!0});var jr=x(_n);g(es.$$.fragment,jr),Qm=l(jr),pl=d(jr,"P",{"data-svelte-h":!0}),T(pl)!=="svelte-v78lg8"&&(pl.textContent=nu),jr.forEach(i),it.forEach(i),Mr=l(e),g(ts.$$.fragment,e),vr=l(e),se=d(e,"DIV",{class:!0});var pt=x(se);g(ns.$$.fragment,pt),Dm=l(pt),ml=d(pt,"P",{"data-svelte-h":!0}),T(ml)!=="svelte-1d0xpim"&&(ml.innerHTML=ou),Ym=l(pt),dl=d(pt,"P",{"data-svelte-h":!0}),T(dl)!=="svelte-juaqsv"&&(dl.innerHTML=su),Am=l(pt),cl=d(pt,"P",{"data-svelte-h":!0}),T(cl)!=="svelte-1uq7qf6"&&(cl.innerHTML=au),Km=l(pt),bn=d(pt,"DIV",{class:!0});var Jr=x(bn);g(os.$$.fragment,Jr),ed=l(Jr),ul=d(Jr,"P",{"data-svelte-h":!0}),T(ul)!=="svelte-v78lg8"&&(ul.textContent=lu),Jr.forEach(i),pt.forEach(i),wr=l(e),g(ss.$$.fragment,e),xr=l(e),gl=d(e,"P",{}),x(gl).forEach(i),this.h()},h(){$(n,"name","hf:doc:metadata"),$(n,"content",mg),$(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){o(document.head,n),c(e,M,p),c(e,r,p),c(e,s,p),f(y,e,p),c(e,t,p),f(v,e,p),c(e,fl,p),c(e,yn,p),c(e,hl,p),f(Tn,e,p),c(e,_l,p),c(e,I,p),f(Mn,I,null),o(I,Rr),o(I,gs),o(I,Ur),o(I,fs),o(I,Ir),o(I,hs),o(I,Cr),o(I,_s),o(I,Zr),o(I,bs),o(I,Wr),o(I,ys),o(I,Nr),o(I,mt),f(vn,mt,null),o(mt,Sr),o(mt,Ts),o(I,Fr),o(I,dt),f(wn,dt,null),o(dt,Gr),o(dt,Ms),o(I,Or),o(I,ct),f(xn,ct,null),o(ct,Xr),o(ct,vs),o(I,Vr),o(I,ut),f($n,ut,null),o(ut,qr),o(ut,ws),o(I,zr),o(I,gt),f(kn,gt,null),o(gt,Lr),o(gt,xs),o(I,Br),o(I,ft),f(jn,ft,null),o(ft,Hr),o(ft,$s),c(e,bl,p),f(Jn,e,p),c(e,yl,p),c(e,Rn,p),c(e,Tl,p),f(Un,e,p),c(e,Ml,p),c(e,N,p),f(In,N,null),o(N,Er),o(N,ks),o(N,Pr),o(N,js),o(N,Qr),o(N,Js),o(N,Dr),o(N,le),f(Cn,le,null),o(le,Yr),o(le,Rs),o(le,Ar),f(ht,le,null),o(le,Kr),f(_t,le,null),o(le,ei),f(bt,le,null),c(e,vl,p),f(Zn,e,p),c(e,wl,p),c(e,S,p),f(Wn,S,null),o(S,ti),o(S,Us),o(S,ni),o(S,Is),o(S,oi),o(S,Cs),o(S,si),o(S,re),f(Nn,re,null),o(re,ai),o(re,Zs),o(re,li),f(yt,re,null),o(re,ri),f(Tt,re,null),o(re,ii),f(Mt,re,null),c(e,xl,p),f(Sn,e,p),c(e,$l,p),c(e,F,p),f(Fn,F,null),o(F,pi),o(F,Ws),o(F,mi),o(F,Ns),o(F,di),o(F,Ss),o(F,ci),o(F,ie),f(Gn,ie,null),o(ie,ui),o(ie,Fs),o(ie,gi),f(vt,ie,null),o(ie,fi),f(wt,ie,null),o(ie,hi),f(xt,ie,null),c(e,kl,p),f(On,e,p),c(e,jl,p),c(e,G,p),f(Xn,G,null),o(G,_i),o(G,Gs),o(G,bi),o(G,Os),o(G,yi),o(G,Xs),o(G,Ti),o(G,W),f(Vn,W,null),o(W,Mi),o(W,Vs),o(W,vi),f($t,W,null),o(W,wi),f(kt,W,null),o(W,xi),f(jt,W,null),o(W,$i),f(Jt,W,null),c(e,Jl,p),f(qn,e,p),c(e,Rl,p),c(e,O,p),f(zn,O,null),o(O,ki),o(O,qs),o(O,ji),o(O,zs),o(O,Ji),o(O,Ls),o(O,Ri),o(O,pe),f(Ln,pe,null),o(pe,Ui),o(pe,Bs),o(pe,Ii),f(Rt,pe,null),o(pe,Ci),f(Ut,pe,null),o(pe,Zi),f(It,pe,null),c(e,Ul,p),f(Bn,e,p),c(e,Il,p),c(e,X,p),f(Hn,X,null),o(X,Wi),o(X,Hs),o(X,Ni),o(X,Es),o(X,Si),o(X,Ps),o(X,Fi),o(X,Ae),f(En,Ae,null),o(Ae,Gi),o(Ae,Qs),o(Ae,Oi),f(Ct,Ae,null),o(Ae,Xi),f(Zt,Ae,null),c(e,Cl,p),f(Pn,e,p),c(e,Zl,p),c(e,V,p),f(Qn,V,null),o(V,Vi),o(V,Ds),o(V,qi),o(V,Ys),o(V,zi),o(V,As),o(V,Li),o(V,me),f(Dn,me,null),o(me,Bi),o(me,Ks),o(me,Hi),f(Wt,me,null),o(me,Ei),f(Nt,me,null),o(me,Pi),f(St,me,null),c(e,Wl,p),f(Yn,e,p),c(e,Nl,p),c(e,An,p),c(e,Sl,p),f(Kn,e,p),c(e,Fl,p),c(e,q,p),f(eo,q,null),o(q,Qi),o(q,ea),o(q,Di),o(q,ta),o(q,Yi),o(q,na),o(q,Ai),o(q,de),f(to,de,null),o(de,Ki),o(de,oa),o(de,ep),f(Ft,de,null),o(de,tp),f(Gt,de,null),o(de,np),f(Ot,de,null),c(e,Gl,p),f(no,e,p),c(e,Ol,p),c(e,z,p),f(oo,z,null),o(z,op),o(z,sa),o(z,sp),o(z,aa),o(z,ap),o(z,la),o(z,lp),o(z,ce),f(so,ce,null),o(ce,rp),o(ce,ra),o(ce,ip),f(Xt,ce,null),o(ce,pp),f(Vt,ce,null),o(ce,mp),f(qt,ce,null),c(e,Xl,p),f(ao,e,p),c(e,Vl,p),c(e,lo,p),c(e,ql,p),f(ro,e,p),c(e,zl,p),c(e,L,p),f(io,L,null),o(L,dp),o(L,ia),o(L,cp),o(L,pa),o(L,up),o(L,ma),o(L,gp),o(L,ue),f(po,ue,null),o(ue,fp),o(ue,da),o(ue,hp),f(zt,ue,null),o(ue,_p),f(Lt,ue,null),o(ue,bp),f(Bt,ue,null),c(e,Ll,p),f(mo,e,p),c(e,Bl,p),c(e,B,p),f(co,B,null),o(B,yp),o(B,ca),o(B,Tp),o(B,ua),o(B,Mp),o(B,ga),o(B,vp),o(B,Ke),f(uo,Ke,null),o(Ke,wp),o(Ke,fa),o(Ke,xp),f(Ht,Ke,null),o(Ke,$p),f(Et,Ke,null),c(e,Hl,p),f(go,e,p),c(e,El,p),c(e,H,p),f(fo,H,null),o(H,kp),o(H,ha),o(H,jp),o(H,_a),o(H,Jp),o(H,ba),o(H,Rp),o(H,et),f(ho,et,null),o(et,Up),o(et,ya),o(et,Ip),f(Pt,et,null),o(et,Cp),f(Qt,et,null),c(e,Pl,p),f(_o,e,p),c(e,Ql,p),c(e,E,p),f(bo,E,null),o(E,Zp),o(E,Ta),o(E,Wp),o(E,Ma),o(E,Np),o(E,va),o(E,Sp),o(E,ge),f(yo,ge,null),o(ge,Fp),o(ge,wa),o(ge,Gp),f(Dt,ge,null),o(ge,Op),f(Yt,ge,null),o(ge,Xp),f(At,ge,null),c(e,Dl,p),f(To,e,p),c(e,Yl,p),c(e,P,p),f(Mo,P,null),o(P,Vp),o(P,xa),o(P,qp),o(P,$a),o(P,zp),o(P,ka),o(P,Lp),o(P,tt),f(vo,tt,null),o(tt,Bp),o(tt,ja),o(tt,Hp),f(Kt,tt,null),o(tt,Ep),f(en,tt,null),c(e,Al,p),f(wo,e,p),c(e,Kl,p),c(e,xo,p),c(e,er,p),f($o,e,p),c(e,tr,p),c(e,Q,p),f(ko,Q,null),o(Q,Pp),o(Q,Ja),o(Q,Qp),o(Q,Ra),o(Q,Dp),o(Q,Ua),o(Q,Yp),o(Q,fe),f(jo,fe,null),o(fe,Ap),o(fe,Ia),o(fe,Kp),f(tn,fe,null),o(fe,em),f(nn,fe,null),o(fe,tm),f(on,fe,null),c(e,nr,p),f(Jo,e,p),c(e,or,p),c(e,D,p),f(Ro,D,null),o(D,nm),o(D,Ca),o(D,om),o(D,Za),o(D,sm),o(D,Wa),o(D,am),o(D,nt),f(Uo,nt,null),o(nt,lm),o(nt,Na),o(nt,rm),f(sn,nt,null),o(nt,im),f(an,nt,null),c(e,sr,p),f(Io,e,p),c(e,ar,p),c(e,Co,p),c(e,lr,p),f(Zo,e,p),c(e,rr,p),c(e,Y,p),f(Wo,Y,null),o(Y,pm),o(Y,Sa),o(Y,mm),o(Y,Fa),o(Y,dm),o(Y,Ga),o(Y,cm),o(Y,he),f(No,he,null),o(he,um),o(he,Oa),o(he,gm),f(ln,he,null),o(he,fm),f(rn,he,null),o(he,hm),f(pn,he,null),c(e,ir,p),f(So,e,p),c(e,pr,p),c(e,A,p),f(Fo,A,null),o(A,_m),o(A,Xa),o(A,bm),o(A,Va),o(A,ym),o(A,qa),o(A,Tm),o(A,_e),f(Go,_e,null),o(_e,Mm),o(_e,za),o(_e,vm),f(mn,_e,null),o(_e,wm),f(dn,_e,null),o(_e,xm),f(cn,_e,null),c(e,mr,p),f(Oo,e,p),c(e,dr,p),f(Xo,e,p),c(e,cr,p),c(e,K,p),f(Vo,K,null),o(K,$m),o(K,La),o(K,km),o(K,Ba),o(K,jm),o(K,Ha),o(K,Jm),o(K,un),f(qo,un,null),o(un,Rm),o(un,Ea),c(e,ur,p),f(zo,e,p),c(e,gr,p),c(e,ee,p),f(Lo,ee,null),o(ee,Um),o(ee,Pa),o(ee,Im),o(ee,Qa),o(ee,Cm),o(ee,Da),o(ee,Zm),o(ee,gn),f(Bo,gn,null),o(gn,Wm),o(gn,Ya),c(e,fr,p),f(Ho,e,p),c(e,hr,p),c(e,te,p),f(Eo,te,null),o(te,Nm),o(te,Aa),o(te,Sm),o(te,Ka),o(te,Fm),o(te,el),o(te,Gm),o(te,fn),f(Po,fn,null),o(fn,Om),o(fn,tl),c(e,_r,p),f(Qo,e,p),c(e,br,p),c(e,ne,p),f(Do,ne,null),o(ne,Xm),o(ne,nl),o(ne,Vm),o(ne,ol),o(ne,qm),o(ne,sl),o(ne,zm),o(ne,hn),f(Yo,hn,null),o(hn,Lm),o(hn,al),c(e,yr,p),f(Ao,e,p),c(e,Tr,p),c(e,oe,p),f(Ko,oe,null),o(oe,Bm),o(oe,ll),o(oe,Hm),o(oe,rl),o(oe,Em),o(oe,il),o(oe,Pm),o(oe,_n),f(es,_n,null),o(_n,Qm),o(_n,pl),c(e,Mr,p),f(ts,e,p),c(e,vr,p),c(e,se,p),f(ns,se,null),o(se,Dm),o(se,ml),o(se,Ym),o(se,dl),o(se,Am),o(se,cl),o(se,Km),o(se,bn),f(os,bn,null),o(bn,ed),o(bn,ul),c(e,wr,p),f(ss,e,p),c(e,xr,p),c(e,gl,p),$r=!0},p(e,[p]){const C={};p&2&&(C.$$scope={dirty:p,ctx:e}),ht.$set(C);const as={};p&2&&(as.$$scope={dirty:p,ctx:e}),_t.$set(as);const ls={};p&2&&(ls.$$scope={dirty:p,ctx:e}),bt.$set(ls);const rs={};p&2&&(rs.$$scope={dirty:p,ctx:e}),yt.$set(rs);const is={};p&2&&(is.$$scope={dirty:p,ctx:e}),Tt.$set(is);const ps={};p&2&&(ps.$$scope={dirty:p,ctx:e}),Mt.$set(ps);const ms={};p&2&&(ms.$$scope={dirty:p,ctx:e}),vt.$set(ms);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),wt.$set(be);const ye={};p&2&&(ye.$$scope={dirty:p,ctx:e}),xt.$set(ye);const Te={};p&2&&(Te.$$scope={dirty:p,ctx:e}),$t.$set(Te);const Me={};p&2&&(Me.$$scope={dirty:p,ctx:e}),kt.$set(Me);const ve={};p&2&&(ve.$$scope={dirty:p,ctx:e}),jt.$set(ve);const we={};p&2&&(we.$$scope={dirty:p,ctx:e}),Jt.$set(we);const xe={};p&2&&(xe.$$scope={dirty:p,ctx:e}),Rt.$set(xe);const ae={};p&2&&(ae.$$scope={dirty:p,ctx:e}),Ut.$set(ae);const $e={};p&2&&($e.$$scope={dirty:p,ctx:e}),It.$set($e);const ke={};p&2&&(ke.$$scope={dirty:p,ctx:e}),Ct.$set(ke);const je={};p&2&&(je.$$scope={dirty:p,ctx:e}),Zt.$set(je);const ot={};p&2&&(ot.$$scope={dirty:p,ctx:e}),Wt.$set(ot);const Je={};p&2&&(Je.$$scope={dirty:p,ctx:e}),Nt.$set(Je);const Re={};p&2&&(Re.$$scope={dirty:p,ctx:e}),St.$set(Re);const Ue={};p&2&&(Ue.$$scope={dirty:p,ctx:e}),Ft.$set(Ue);const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:e}),Gt.$set(Ie);const Ce={};p&2&&(Ce.$$scope={dirty:p,ctx:e}),Ot.$set(Ce);const Ze={};p&2&&(Ze.$$scope={dirty:p,ctx:e}),Xt.$set(Ze);const We={};p&2&&(We.$$scope={dirty:p,ctx:e}),Vt.$set(We);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),qt.$set(Ne);const Se={};p&2&&(Se.$$scope={dirty:p,ctx:e}),zt.$set(Se);const st={};p&2&&(st.$$scope={dirty:p,ctx:e}),Lt.$set(st);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:e}),Bt.$set(Fe);const at={};p&2&&(at.$$scope={dirty:p,ctx:e}),Ht.$set(at);const Ge={};p&2&&(Ge.$$scope={dirty:p,ctx:e}),Et.$set(Ge);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:e}),Pt.$set(Oe);const Xe={};p&2&&(Xe.$$scope={dirty:p,ctx:e}),Qt.$set(Xe);const lt={};p&2&&(lt.$$scope={dirty:p,ctx:e}),Dt.$set(lt);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),Yt.$set(Ve);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:e}),At.$set(qe);const ze={};p&2&&(ze.$$scope={dirty:p,ctx:e}),Kt.$set(ze);const rt={};p&2&&(rt.$$scope={dirty:p,ctx:e}),en.$set(rt);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:e}),tn.$set(Le);const Be={};p&2&&(Be.$$scope={dirty:p,ctx:e}),nn.$set(Be);const He={};p&2&&(He.$$scope={dirty:p,ctx:e}),on.$set(He);const Ee={};p&2&&(Ee.$$scope={dirty:p,ctx:e}),sn.$set(Ee);const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:e}),an.$set(Pe);const ds={};p&2&&(ds.$$scope={dirty:p,ctx:e}),ln.$set(ds);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:e}),rn.$set(Qe);const cs={};p&2&&(cs.$$scope={dirty:p,ctx:e}),pn.$set(cs);const De={};p&2&&(De.$$scope={dirty:p,ctx:e}),mn.$set(De);const us={};p&2&&(us.$$scope={dirty:p,ctx:e}),dn.$set(us);const Ye={};p&2&&(Ye.$$scope={dirty:p,ctx:e}),cn.$set(Ye)},i(e){$r||(h(y.$$.fragment,e),h(v.$$.fragment,e),h(Tn.$$.fragment,e),h(Mn.$$.fragment,e),h(vn.$$.fragment,e),h(wn.$$.fragment,e),h(xn.$$.fragment,e),h($n.$$.fragment,e),h(kn.$$.fragment,e),h(jn.$$.fragment,e),h(Jn.$$.fragment,e),h(Un.$$.fragment,e),h(In.$$.fragment,e),h(Cn.$$.fragment,e),h(ht.$$.fragment,e),h(_t.$$.fragment,e),h(bt.$$.fragment,e),h(Zn.$$.fragment,e),h(Wn.$$.fragment,e),h(Nn.$$.fragment,e),h(yt.$$.fragment,e),h(Tt.$$.fragment,e),h(Mt.$$.fragment,e),h(Sn.$$.fragment,e),h(Fn.$$.fragment,e),h(Gn.$$.fragment,e),h(vt.$$.fragment,e),h(wt.$$.fragment,e),h(xt.$$.fragment,e),h(On.$$.fragment,e),h(Xn.$$.fragment,e),h(Vn.$$.fragment,e),h($t.$$.fragment,e),h(kt.$$.fragment,e),h(jt.$$.fragment,e),h(Jt.$$.fragment,e),h(qn.$$.fragment,e),h(zn.$$.fragment,e),h(Ln.$$.fragment,e),h(Rt.$$.fragment,e),h(Ut.$$.fragment,e),h(It.$$.fragment,e),h(Bn.$$.fragment,e),h(Hn.$$.fragment,e),h(En.$$.fragment,e),h(Ct.$$.fragment,e),h(Zt.$$.fragment,e),h(Pn.$$.fragment,e),h(Qn.$$.fragment,e),h(Dn.$$.fragment,e),h(Wt.$$.fragment,e),h(Nt.$$.fragment,e),h(St.$$.fragment,e),h(Yn.$$.fragment,e),h(Kn.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(Ft.$$.fragment,e),h(Gt.$$.fragment,e),h(Ot.$$.fragment,e),h(no.$$.fragment,e),h(oo.$$.fragment,e),h(so.$$.fragment,e),h(Xt.$$.fragment,e),h(Vt.$$.fragment,e),h(qt.$$.fragment,e),h(ao.$$.fragment,e),h(ro.$$.fragment,e),h(io.$$.fragment,e),h(po.$$.fragment,e),h(zt.$$.fragment,e),h(Lt.$$.fragment,e),h(Bt.$$.fragment,e),h(mo.$$.fragment,e),h(co.$$.fragment,e),h(uo.$$.fragment,e),h(Ht.$$.fragment,e),h(Et.$$.fragment,e),h(go.$$.fragment,e),h(fo.$$.fragment,e),h(ho.$$.fragment,e),h(Pt.$$.fragment,e),h(Qt.$$.fragment,e),h(_o.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(Dt.$$.fragment,e),h(Yt.$$.fragment,e),h(At.$$.fragment,e),h(To.$$.fragment,e),h(Mo.$$.fragment,e),h(vo.$$.fragment,e),h(Kt.$$.fragment,e),h(en.$$.fragment,e),h(wo.$$.fragment,e),h($o.$$.fragment,e),h(ko.$$.fragment,e),h(jo.$$.fragment,e),h(tn.$$.fragment,e),h(nn.$$.fragment,e),h(on.$$.fragment,e),h(Jo.$$.fragment,e),h(Ro.$$.fragment,e),h(Uo.$$.fragment,e),h(sn.$$.fragment,e),h(an.$$.fragment,e),h(Io.$$.fragment,e),h(Zo.$$.fragment,e),h(Wo.$$.fragment,e),h(No.$$.fragment,e),h(ln.$$.fragment,e),h(rn.$$.fragment,e),h(pn.$$.fragment,e),h(So.$$.fragment,e),h(Fo.$$.fragment,e),h(Go.$$.fragment,e),h(mn.$$.fragment,e),h(dn.$$.fragment,e),h(cn.$$.fragment,e),h(Oo.$$.fragment,e),h(Xo.$$.fragment,e),h(Vo.$$.fragment,e),h(qo.$$.fragment,e),h(zo.$$.fragment,e),h(Lo.$$.fragment,e),h(Bo.$$.fragment,e),h(Ho.$$.fragment,e),h(Eo.$$.fragment,e),h(Po.$$.fragment,e),h(Qo.$$.fragment,e),h(Do.$$.fragment,e),h(Yo.$$.fragment,e),h(Ao.$$.fragment,e),h(Ko.$$.fragment,e),h(es.$$.fragment,e),h(ts.$$.fragment,e),h(ns.$$.fragment,e),h(os.$$.fragment,e),h(ss.$$.fragment,e),$r=!0)},o(e){_(y.$$.fragment,e),_(v.$$.fragment,e),_(Tn.$$.fragment,e),_(Mn.$$.fragment,e),_(vn.$$.fragment,e),_(wn.$$.fragment,e),_(xn.$$.fragment,e),_($n.$$.fragment,e),_(kn.$$.fragment,e),_(jn.$$.fragment,e),_(Jn.$$.fragment,e),_(Un.$$.fragment,e),_(In.$$.fragment,e),_(Cn.$$.fragment,e),_(ht.$$.fragment,e),_(_t.$$.fragment,e),_(bt.$$.fragment,e),_(Zn.$$.fragment,e),_(Wn.$$.fragment,e),_(Nn.$$.fragment,e),_(yt.$$.fragment,e),_(Tt.$$.fragment,e),_(Mt.$$.fragment,e),_(Sn.$$.fragment,e),_(Fn.$$.fragment,e),_(Gn.$$.fragment,e),_(vt.$$.fragment,e),_(wt.$$.fragment,e),_(xt.$$.fragment,e),_(On.$$.fragment,e),_(Xn.$$.fragment,e),_(Vn.$$.fragment,e),_($t.$$.fragment,e),_(kt.$$.fragment,e),_(jt.$$.fragment,e),_(Jt.$$.fragment,e),_(qn.$$.fragment,e),_(zn.$$.fragment,e),_(Ln.$$.fragment,e),_(Rt.$$.fragment,e),_(Ut.$$.fragment,e),_(It.$$.fragment,e),_(Bn.$$.fragment,e),_(Hn.$$.fragment,e),_(En.$$.fragment,e),_(Ct.$$.fragment,e),_(Zt.$$.fragment,e),_(Pn.$$.fragment,e),_(Qn.$$.fragment,e),_(Dn.$$.fragment,e),_(Wt.$$.fragment,e),_(Nt.$$.fragment,e),_(St.$$.fragment,e),_(Yn.$$.fragment,e),_(Kn.$$.fragment,e),_(eo.$$.fragment,e),_(to.$$.fragment,e),_(Ft.$$.fragment,e),_(Gt.$$.fragment,e),_(Ot.$$.fragment,e),_(no.$$.fragment,e),_(oo.$$.fragment,e),_(so.$$.fragment,e),_(Xt.$$.fragment,e),_(Vt.$$.fragment,e),_(qt.$$.fragment,e),_(ao.$$.fragment,e),_(ro.$$.fragment,e),_(io.$$.fragment,e),_(po.$$.fragment,e),_(zt.$$.fragment,e),_(Lt.$$.fragment,e),_(Bt.$$.fragment,e),_(mo.$$.fragment,e),_(co.$$.fragment,e),_(uo.$$.fragment,e),_(Ht.$$.fragment,e),_(Et.$$.fragment,e),_(go.$$.fragment,e),_(fo.$$.fragment,e),_(ho.$$.fragment,e),_(Pt.$$.fragment,e),_(Qt.$$.fragment,e),_(_o.$$.fragment,e),_(bo.$$.fragment,e),_(yo.$$.fragment,e),_(Dt.$$.fragment,e),_(Yt.$$.fragment,e),_(At.$$.fragment,e),_(To.$$.fragment,e),_(Mo.$$.fragment,e),_(vo.$$.fragment,e),_(Kt.$$.fragment,e),_(en.$$.fragment,e),_(wo.$$.fragment,e),_($o.$$.fragment,e),_(ko.$$.fragment,e),_(jo.$$.fragment,e),_(tn.$$.fragment,e),_(nn.$$.fragment,e),_(on.$$.fragment,e),_(Jo.$$.fragment,e),_(Ro.$$.fragment,e),_(Uo.$$.fragment,e),_(sn.$$.fragment,e),_(an.$$.fragment,e),_(Io.$$.fragment,e),_(Zo.$$.fragment,e),_(Wo.$$.fragment,e),_(No.$$.fragment,e),_(ln.$$.fragment,e),_(rn.$$.fragment,e),_(pn.$$.fragment,e),_(So.$$.fragment,e),_(Fo.$$.fragment,e),_(Go.$$.fragment,e),_(mn.$$.fragment,e),_(dn.$$.fragment,e),_(cn.$$.fragment,e),_(Oo.$$.fragment,e),_(Xo.$$.fragment,e),_(Vo.$$.fragment,e),_(qo.$$.fragment,e),_(zo.$$.fragment,e),_(Lo.$$.fragment,e),_(Bo.$$.fragment,e),_(Ho.$$.fragment,e),_(Eo.$$.fragment,e),_(Po.$$.fragment,e),_(Qo.$$.fragment,e),_(Do.$$.fragment,e),_(Yo.$$.fragment,e),_(Ao.$$.fragment,e),_(Ko.$$.fragment,e),_(es.$$.fragment,e),_(ts.$$.fragment,e),_(ns.$$.fragment,e),_(os.$$.fragment,e),_(ss.$$.fragment,e),$r=!1},d(e){e&&(i(M),i(r),i(s),i(t),i(fl),i(yn),i(hl),i(_l),i(I),i(bl),i(yl),i(Rn),i(Tl),i(Ml),i(N),i(vl),i(wl),i(S),i(xl),i($l),i(F),i(kl),i(jl),i(G),i(Jl),i(Rl),i(O),i(Ul),i(Il),i(X),i(Cl),i(Zl),i(V),i(Wl),i(Nl),i(An),i(Sl),i(Fl),i(q),i(Gl),i(Ol),i(z),i(Xl),i(Vl),i(lo),i(ql),i(zl),i(L),i(Ll),i(Bl),i(B),i(Hl),i(El),i(H),i(Pl),i(Ql),i(E),i(Dl),i(Yl),i(P),i(Al),i(Kl),i(xo),i(er),i(tr),i(Q),i(nr),i(or),i(D),i(sr),i(ar),i(Co),i(lr),i(rr),i(Y),i(ir),i(pr),i(A),i(mr),i(dr),i(cr),i(K),i(ur),i(gr),i(ee),i(fr),i(hr),i(te),i(_r),i(br),i(ne),i(yr),i(Tr),i(oe),i(Mr),i(vr),i(se),i(wr),i(xr),i(gl)),i(n),b(y,e),b(v,e),b(Tn,e),b(Mn),b(vn),b(wn),b(xn),b($n),b(kn),b(jn),b(Jn,e),b(Un,e),b(In),b(Cn),b(ht),b(_t),b(bt),b(Zn,e),b(Wn),b(Nn),b(yt),b(Tt),b(Mt),b(Sn,e),b(Fn),b(Gn),b(vt),b(wt),b(xt),b(On,e),b(Xn),b(Vn),b($t),b(kt),b(jt),b(Jt),b(qn,e),b(zn),b(Ln),b(Rt),b(Ut),b(It),b(Bn,e),b(Hn),b(En),b(Ct),b(Zt),b(Pn,e),b(Qn),b(Dn),b(Wt),b(Nt),b(St),b(Yn,e),b(Kn,e),b(eo),b(to),b(Ft),b(Gt),b(Ot),b(no,e),b(oo),b(so),b(Xt),b(Vt),b(qt),b(ao,e),b(ro,e),b(io),b(po),b(zt),b(Lt),b(Bt),b(mo,e),b(co),b(uo),b(Ht),b(Et),b(go,e),b(fo),b(ho),b(Pt),b(Qt),b(_o,e),b(bo),b(yo),b(Dt),b(Yt),b(At),b(To,e),b(Mo),b(vo),b(Kt),b(en),b(wo,e),b($o,e),b(ko),b(jo),b(tn),b(nn),b(on),b(Jo,e),b(Ro),b(Uo),b(sn),b(an),b(Io,e),b(Zo,e),b(Wo),b(No),b(ln),b(rn),b(pn),b(So,e),b(Fo),b(Go),b(mn),b(dn),b(cn),b(Oo,e),b(Xo,e),b(Vo),b(qo),b(zo,e),b(Lo),b(Bo),b(Ho,e),b(Eo),b(Po),b(Qo,e),b(Do),b(Yo),b(Ao,e),b(Ko),b(es),b(ts,e),b(ns),b(os),b(ss,e)}}}const mg='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"ORTStableDiffusionPipeline","local":"optimum.onnxruntime.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.onnxruntime.ORTLatentConsistencyModelPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function dg(w){return iu(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yg extends pu{constructor(n){super(),mu(this,n,dg,pg,ru,{})}}export{yg as component};
