import{s as Lt,f as at,n as Qt,o as St}from"../chunks/scheduler.37c15a92.js";import{S as Rt,i as Vt,g as o,s as a,r as m,A as Xt,h as i,f as l,c as n,j as ue,u as M,x as p,k as r,y as Nt,a as s,v as h,d as y,t as w,w as f}from"../chunks/index.2bf4358c.js";import{C as nt}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Yt}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as ie,E as Pt}from"../chunks/EditOnGithub.8916dc7c.js";function zt(ot){let T,ce,pe,de,j,me,J,Me,b,it=`In this section, we will take a closer look at the <code>Interface</code> class, and understand the
main parameters used to create one.`,he,U,ye,I,pt="You’ll notice that the <code>Interface</code> class has 3 required parameters:",we,g,rt="<code>Interface(fn, inputs, outputs, ...)</code>",fe,v,ut="These parameters are:",Te,k,ct="<li><code>fn</code>: the prediction function that is wrapped by the Gradio interface. This function can take one or more parameters and return one or more values</li> <li><code>inputs</code>: the input component type(s). Gradio provides many pre-built components such as<code>&quot;image&quot;</code> or <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: the output component type(s). Again, Gradio provides many pre-built components e.g. <code>&quot;image&quot;</code> or <code>&quot;label&quot;</code>.</li>",je,C,dt='For a complete list of components, <a href="https://gradio.app/docs" rel="nofollow">see the Gradio docs </a>. Each pre-built component can be customized by instantiating the class corresponding to the component.',Je,A,mt=`For example, as we saw in the <a href="/course/chapter9/2">previous section</a>,
instead of passing in <code>&quot;textbox&quot;</code> to the <code>inputs</code> parameter, you can pass in a <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> component to create a textbox with 7 lines and a label.`,be,x,Mt="Let’s take a look at another example, this time with an <code>Audio</code> component.",Ue,$,Ie,q,ht=`As mentioned earlier, Gradio provides many different inputs and outputs.
So let’s build an <code>Interface</code> that works with audio.`,ge,B,yt=`In this example, we’ll build an audio-to-audio function that takes an
audio file and simply reverses it.`,ve,G,wt=`We will use for the input the <code>Audio</code> component. When using the <code>Audio</code> component,
you can specify whether you want the <code>source</code> of the audio to be a file that the user
uploads or a microphone that the user records their voice with. In this case, let’s
set it to a <code>&quot;microphone&quot;</code>. Just for fun, we’ll add a label to our <code>Audio</code> that says
“Speak here…“.`,ke,_,ft=`In addition, we’d like to receive the audio as a numpy array so that we can easily
“reverse” it. So we’ll set the <code>&quot;type&quot;</code> to be <code>&quot;numpy&quot;</code>, which passes the input
data as a tuple of (<code>sample_rate</code>, <code>data</code>) into our function.`,Ce,H,Tt=`We will also use the <code>Audio</code> output component which can automatically
render a tuple with a sample rate and numpy array of data as a playable audio file.
In this case, we do not need to do any customization, so we will use the string
shortcut <code>&quot;audio&quot;</code>.`,Ae,E,xe,Z,jt=`The code above will produce an interface like the one below (if your browser doesn’t
ask you for microphone permissions, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in  a separate tab</a>.)`,$e,u,Jt,qe,W,bt="You should now be able to record your voice and hear yourself speaking in reverse - spooky 👻!",Be,L,Ge,Q,Ut=`Let’s say we had a more complicated function, with multiple inputs and outputs.
In the example below, we have a function that takes a dropdown index, a slider value, and number,
and returns an audio sample of a musical tone.`,_e,S,It=`Take a look how we pass a list of input and output components,
and see if you can follow along what’s happening.`,He,R,gt="The key here is that when you pass:",Ee,V,vt="<li>a list of input components, each component corresponds to a parameter in order.</li> <li>a list of output coponents, each component corresponds to a returned value.</li>",Ze,X,kt="The code snippet below shows how three input components line up with the three arguments of the <code>generate_tone()</code> function:",We,N,Le,c,Ct,Qe,Y,Se,P,At=`So far, we have used the <code>launch()</code> method to launch the interface, but we
haven’t really discussed what it does.`,Re,z,xt=`By default, the <code>launch()</code> method will launch the demo in a web server that
is running locally. If you are running your code in a Jupyter or Colab notebook, then
Gradio will embed the demo GUI in the notebook so you can easily use it.`,Ve,F,$t="You can customize the behavior of <code>launch()</code> through different parameters:",Xe,K,qt="<li><code>inline</code> - whether to display the interface inline on Python notebooks.</li> <li><code>inbrowser</code> - whether to automatically launch the interface in a new tab on the default browser.</li> <li><code>share</code> - whether to create a publicly shareable link from your computer for the interface. Kind of like a Google Drive link!</li>",Ne,D,Bt="We’ll cover the <code>share</code> parameter in a lot more detail in the next section!",Ye,O,Pe,ee,Gt=`Let’s build an interface that allows you to demo a <strong>speech-recognition</strong> model.
To make it interesting, we will accept <em>either</em> a mic input or an uploaded file.`,ze,te,_t=`As usual, we’ll load our speech recognition model using the <code>pipeline()</code> function from 🤗 Transformers.
If you need a quick refresher, you can go back to <a href="/course/chapter1/3">that section in Chapter 1</a>.   Next, we’ll implement a <code>transcribe_audio()</code> function that processes the audio and returns the transcription. Finally, we’ll wrap this function in an <code>Interface</code> with the <code>Audio</code> components for the inputs and just text for the output. Altogether, the code for this application is the following:`,Fe,le,Ke,se,Ht='If your browser doesn’t ask you for microphone permissions, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in a separate tab</a>.',De,d,Et,Oe,ae,Zt=`That’s it! You can now use this interface to transcribe audio. Notice here that
by passing in the <code>optional</code> parameter as <code>True</code>, we allow the user to either
provide a microphone or an audio file (or neither, but that will return an error message).`,et,ne,Wt="Keep going to see how to share your interface with others!",tt,oe,lt,re,st;return j=new ie({props:{title:"Understanding the Interface class",local:"understanding-the-interface-class",headingTag:"h1"}}),J=new Yt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"}]}}),U=new ie({props:{title:"How to create an Interface",local:"how-to-create-an-interface",headingTag:"h2"}}),$=new ie({props:{title:"A simple example with audio",local:"a-simple-example-with-audio",headingTag:"h2"}}),E=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZXMlM0QlNUIlMjJtaWNyb3Bob25lJTIyJTVEJTJDJTIwdHlwZSUzRCUyMm51bXB5JTIyJTJDJTIwbGFiZWwlM0QlMjJTcGVhayUyMGhlcmUuLi4lMjIpJTBBZ3IuSW50ZXJmYWNlKHJldmVyc2VfYXVkaW8lMkMlMjBtaWMlMkMlMjAlMjJhdWRpbyUyMikubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(sources=[<span class="hljs-string">&quot;microphone&quot;</span>], <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),L=new ie({props:{title:"Handling multiple inputs and outputs",local:"handling-multiple-inputs-and-outputs",headingTag:"h2"}}),N=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godmFsdWUlM0QxJTJDJTIwbGFiZWwlM0QlMjJEdXJhdGlvbiUyMGluJTIwc2Vjb25kcyUyMiklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new ie({props:{title:"The launch() method",local:"the-launch-method",headingTag:"h3"}}),O=new ie({props:{title:"✏️ Let’s apply it!",local:"lets-apply-it",headingTag:"h2"}}),le=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2VzJTNEJTVCJTIybWljcm9waG9uZSUyMiU1RCUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2VzJTNEJTVCJTIydXBsb2FkJTIyJTVEJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlMjJ0ZXh0JTIyJTJDJTBBKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(sources=[<span class="hljs-string">&quot;microphone&quot;</span>], <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
        gr.Audio(sources=[<span class="hljs-string">&quot;upload&quot;</span>], <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),oe=new Pt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter9/3.mdx"}}),{c(){T=o("meta"),ce=a(),pe=o("p"),de=a(),m(j.$$.fragment),me=a(),m(J.$$.fragment),Me=a(),b=o("p"),b.innerHTML=it,he=a(),m(U.$$.fragment),ye=a(),I=o("p"),I.innerHTML=pt,we=a(),g=o("p"),g.innerHTML=rt,fe=a(),v=o("p"),v.textContent=ut,Te=a(),k=o("ul"),k.innerHTML=ct,je=a(),C=o("p"),C.innerHTML=dt,Je=a(),A=o("p"),A.innerHTML=mt,be=a(),x=o("p"),x.innerHTML=Mt,Ue=a(),m($.$$.fragment),Ie=a(),q=o("p"),q.innerHTML=ht,ge=a(),B=o("p"),B.textContent=yt,ve=a(),G=o("p"),G.innerHTML=wt,ke=a(),_=o("p"),_.innerHTML=ft,Ce=a(),H=o("p"),H.innerHTML=Tt,Ae=a(),m(E.$$.fragment),xe=a(),Z=o("p"),Z.innerHTML=jt,$e=a(),u=o("iframe"),qe=a(),W=o("p"),W.textContent=bt,Be=a(),m(L.$$.fragment),Ge=a(),Q=o("p"),Q.textContent=Ut,_e=a(),S=o("p"),S.textContent=It,He=a(),R=o("p"),R.textContent=gt,Ee=a(),V=o("ul"),V.innerHTML=vt,Ze=a(),X=o("p"),X.innerHTML=kt,We=a(),m(N.$$.fragment),Le=a(),c=o("iframe"),Qe=a(),m(Y.$$.fragment),Se=a(),P=o("p"),P.innerHTML=At,Re=a(),z=o("p"),z.innerHTML=xt,Ve=a(),F=o("p"),F.innerHTML=$t,Xe=a(),K=o("ul"),K.innerHTML=qt,Ne=a(),D=o("p"),D.innerHTML=Bt,Ye=a(),m(O.$$.fragment),Pe=a(),ee=o("p"),ee.innerHTML=Gt,ze=a(),te=o("p"),te.innerHTML=_t,Fe=a(),m(le.$$.fragment),Ke=a(),se=o("p"),se.innerHTML=Ht,De=a(),d=o("iframe"),Oe=a(),ae=o("p"),ae.innerHTML=Zt,et=a(),ne=o("p"),ne.textContent=Wt,tt=a(),m(oe.$$.fragment),lt=a(),re=o("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(l),ce=n(e),pe=i(e,"P",{}),ue(pe).forEach(l),de=n(e),M(j.$$.fragment,e),me=n(e),M(J.$$.fragment,e),Me=n(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-lkknik"&&(b.innerHTML=it),he=n(e),M(U.$$.fragment,e),ye=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1gqpygy"&&(I.innerHTML=pt),we=n(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-5xxju6"&&(g.innerHTML=rt),fe=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1srf6cz"&&(v.textContent=ut),Te=n(e),k=i(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-1cwo97x"&&(k.innerHTML=ct),je=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-a2tvbr"&&(C.innerHTML=dt),Je=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-fgatqp"&&(A.innerHTML=mt),be=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1lphv0c"&&(x.innerHTML=Mt),Ue=n(e),M($.$$.fragment,e),Ie=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-ul4i2u"&&(q.innerHTML=ht),ge=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1i37re5"&&(B.textContent=yt),ve=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-172zvxz"&&(G.innerHTML=wt),ke=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-4wa24d"&&(_.innerHTML=ft),Ce=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-13zmab1"&&(H.innerHTML=Tt),Ae=n(e),M(E.$$.fragment,e),xe=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-221tzw"&&(Z.innerHTML=jt),$e=n(e),u=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(u).forEach(l),qe=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-12uox4i"&&(W.textContent=bt),Be=n(e),M(L.$$.fragment,e),Ge=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-185l475"&&(Q.textContent=Ut),_e=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-wn7sdm"&&(S.textContent=It),He=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-15txj5f"&&(R.textContent=gt),Ee=n(e),V=i(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-1yoqjoi"&&(V.innerHTML=vt),Ze=n(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-rsacrc"&&(X.innerHTML=kt),We=n(e),M(N.$$.fragment,e),Le=n(e),c=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(c).forEach(l),Qe=n(e),M(Y.$$.fragment,e),Se=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1drgann"&&(P.innerHTML=At),Re=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-j2w7rs"&&(z.innerHTML=xt),Ve=n(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-yl79n1"&&(F.innerHTML=$t),Xe=n(e),K=i(e,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-f1qyss"&&(K.innerHTML=qt),Ne=n(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-fugi8a"&&(D.innerHTML=Bt),Ye=n(e),M(O.$$.fragment,e),Pe=n(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-433a1m"&&(ee.innerHTML=Gt),ze=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1cy2oyt"&&(te.innerHTML=_t),Fe=n(e),M(le.$$.fragment,e),Ke=n(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-16m1pd5"&&(se.innerHTML=Ht),De=n(e),d=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(d).forEach(l),Oe=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1hnmjbo"&&(ae.innerHTML=Zt),et=n(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1egous1"&&(ne.textContent=Wt),tt=n(e),M(oe.$$.fragment,e),lt=n(e),re=i(e,"P",{}),ue(re).forEach(l),this.h()},h(){r(T,"name","hf:doc:metadata"),r(T,"content",Ft),at(u.src,Jt="https://course-demos-audio-reverse.hf.space")||r(u,"src",Jt),r(u,"frameborder","0"),r(u,"height","250"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),at(c.src,Ct="https://course-demos-generate-tone.hf.space")||r(c,"src",Ct),r(c,"frameborder","0"),r(c,"height","450"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),at(d.src,Et="https://course-demos-asr.hf.space")||r(d,"src",Et),r(d,"frameborder","0"),r(d,"height","550"),r(d,"title","Gradio app"),r(d,"class","container p-0 flex-grow space-iframe"),r(d,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(d,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Nt(document.head,T),s(e,ce,t),s(e,pe,t),s(e,de,t),h(j,e,t),s(e,me,t),h(J,e,t),s(e,Me,t),s(e,b,t),s(e,he,t),h(U,e,t),s(e,ye,t),s(e,I,t),s(e,we,t),s(e,g,t),s(e,fe,t),s(e,v,t),s(e,Te,t),s(e,k,t),s(e,je,t),s(e,C,t),s(e,Je,t),s(e,A,t),s(e,be,t),s(e,x,t),s(e,Ue,t),h($,e,t),s(e,Ie,t),s(e,q,t),s(e,ge,t),s(e,B,t),s(e,ve,t),s(e,G,t),s(e,ke,t),s(e,_,t),s(e,Ce,t),s(e,H,t),s(e,Ae,t),h(E,e,t),s(e,xe,t),s(e,Z,t),s(e,$e,t),s(e,u,t),s(e,qe,t),s(e,W,t),s(e,Be,t),h(L,e,t),s(e,Ge,t),s(e,Q,t),s(e,_e,t),s(e,S,t),s(e,He,t),s(e,R,t),s(e,Ee,t),s(e,V,t),s(e,Ze,t),s(e,X,t),s(e,We,t),h(N,e,t),s(e,Le,t),s(e,c,t),s(e,Qe,t),h(Y,e,t),s(e,Se,t),s(e,P,t),s(e,Re,t),s(e,z,t),s(e,Ve,t),s(e,F,t),s(e,Xe,t),s(e,K,t),s(e,Ne,t),s(e,D,t),s(e,Ye,t),h(O,e,t),s(e,Pe,t),s(e,ee,t),s(e,ze,t),s(e,te,t),s(e,Fe,t),h(le,e,t),s(e,Ke,t),s(e,se,t),s(e,De,t),s(e,d,t),s(e,Oe,t),s(e,ae,t),s(e,et,t),s(e,ne,t),s(e,tt,t),h(oe,e,t),s(e,lt,t),s(e,re,t),st=!0},p:Qt,i(e){st||(y(j.$$.fragment,e),y(J.$$.fragment,e),y(U.$$.fragment,e),y($.$$.fragment,e),y(E.$$.fragment,e),y(L.$$.fragment,e),y(N.$$.fragment,e),y(Y.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(oe.$$.fragment,e),st=!0)},o(e){w(j.$$.fragment,e),w(J.$$.fragment,e),w(U.$$.fragment,e),w($.$$.fragment,e),w(E.$$.fragment,e),w(L.$$.fragment,e),w(N.$$.fragment,e),w(Y.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),w(oe.$$.fragment,e),st=!1},d(e){e&&(l(ce),l(pe),l(de),l(me),l(Me),l(b),l(he),l(ye),l(I),l(we),l(g),l(fe),l(v),l(Te),l(k),l(je),l(C),l(Je),l(A),l(be),l(x),l(Ue),l(Ie),l(q),l(ge),l(B),l(ve),l(G),l(ke),l(_),l(Ce),l(H),l(Ae),l(xe),l(Z),l($e),l(u),l(qe),l(W),l(Be),l(Ge),l(Q),l(_e),l(S),l(He),l(R),l(Ee),l(V),l(Ze),l(X),l(We),l(Le),l(c),l(Qe),l(Se),l(P),l(Re),l(z),l(Ve),l(F),l(Xe),l(K),l(Ne),l(D),l(Ye),l(Pe),l(ee),l(ze),l(te),l(Fe),l(Ke),l(se),l(De),l(d),l(Oe),l(ae),l(et),l(ne),l(tt),l(lt),l(re)),l(T),f(j,e),f(J,e),f(U,e),f($,e),f(E,e),f(L,e),f(N,e),f(Y,e),f(O,e),f(le,e),f(oe,e)}}}const Ft='{"title":"Understanding the Interface class","local":"understanding-the-interface-class","sections":[{"title":"How to create an Interface","local":"how-to-create-an-interface","sections":[],"depth":2},{"title":"A simple example with audio","local":"a-simple-example-with-audio","sections":[],"depth":2},{"title":"Handling multiple inputs and outputs","local":"handling-multiple-inputs-and-outputs","sections":[{"title":"The launch() method","local":"the-launch-method","sections":[],"depth":3}],"depth":2},{"title":"✏️ Let’s apply it!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function Kt(ot){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends Rt{constructor(T){super(),Vt(this,T,Kt,zt,Lt,{})}}export{sl as component};
