import{s as es,o as ts}from"../chunks/scheduler.f7e1785c.js";import{S as as,i as ss,g as l,s as i,r as m,A as is,h as o,f as a,c as n,j as Qa,u as h,x as r,k as qe,y as ns,a as s,v as c,d,t as f,w as g,m as Ka,n as Oa}from"../chunks/index.9f8f0838.js";import{T as Aa}from"../chunks/Tip.4575d9cf.js";import{C as Be}from"../chunks/CodeBlock.4baef5d7.js";import{H as ze,E as ls}from"../chunks/getInferenceSnippets.ba5f4cd0.js";function os(Ge){let p;return{c(){p=Ka(`💡 In practice, people use the term FFT interchangeably with DFT, as the FFT or Fast Fourier Transform is the only efficient
way to calculate the DFT on a computer.`)},l(u){p=Oa(u,`💡 In practice, people use the term FFT interchangeably with DFT, as the FFT or Fast Fourier Transform is the only efficient
way to calculate the DFT on a computer.`)},m(u,w){s(u,p,w)},d(u){u&&a(p)}}}function rs(Ge){let p;return{c(){p=Ka(`💡 Not all mel spectrograms are the same! There are two different mel scales in common use ("htk" and "slaney"),
and instead of the power spectrogram the amplitude spectrogram may be used. The conversion to a log-mel spectrogram doesn't
always compute true decibels but may simply take the \`log\`. Therefore, if a machine learning model expects a mel spectrogram
as input, double check to make sure you're computing it the same way.`)},l(u){p=Oa(u,`💡 Not all mel spectrograms are the same! There are two different mel scales in common use ("htk" and "slaney"),
and instead of the power spectrogram the amplitude spectrogram may be used. The conversion to a log-mel spectrogram doesn't
always compute true decibels but may simply take the \`log\`. Therefore, if a machine learning model expects a mel spectrogram
as input, double check to make sure you're computing it the same way.`)},m(u,w){s(u,p,w)},d(u){u&&a(p)}}}function ps(Ge){let p,u,w,Fe,$,Le,k,At=`By nature, a sound wave is a continuous signal, meaning it contains an infinite number of signal values in a given time.
This poses problems for digital devices which expect finite arrays. To be processed, stored, and transmitted by digital
devices, the continuous sound wave needs to be converted into a series of discrete values, known as a digital representation.`,Ze,_,Kt=`If you look at any audio dataset, you’ll find digital files with sound excerpts, such as text narration or music.
You may encounter different file formats such as <code>.wav</code> (Waveform Audio File), <code>.flac</code> (Free Lossless Audio Codec)
and <code>.mp3</code> (MPEG-1 Audio Layer 3). These formats mainly differ in how they compress the digital representation of the audio signal.`,Se,J,Ot=`Let’s take a look at how we arrive from a continuous signal to this representation. The analog signal is first captured by
a microphone, which converts the sound waves into an electrical signal. The electrical signal is then digitized by an
Analog-to-Digital Converter to get the digital representation through sampling.`,Ue,H,Pe,j,ea=`Sampling is the process of measuring the value of a continuous signal at fixed time steps. The sampled waveform is <em>discrete</em>,
since it contains a finite number of signal values at uniform intervals.`,Xe,v,ta='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/Signal_Sampling.png" alt="Signal sampling illustration"/>',Ee,q,aa='<em>Illustration from Wikipedia article: <a href="https://en.wikipedia.org/wiki/Sampling_(signal_processing)" rel="nofollow">Sampling (signal processing)</a></em>',We,z,sa=`The <strong>sampling rate</strong> (also called sampling frequency) is the number of samples taken in one second and is measured in
hertz (Hz). To give you a point of reference, CD-quality audio has a sampling rate of 44,100 Hz, meaning samples are taken
44,100 times per second. For comparison, high-resolution audio has a sampling rate of 192,000 Hz or 192 kHz. A common
sampling rate used in training speech models is 16,000 Hz or 16 kHz.`,Ye,G,ia=`The choice of sampling rate primarily determines the highest frequency that can be captured from the signal. This is also
known as the Nyquist limit and is exactly half the sampling rate. The audible frequencies in human speech are below 8 kHz
and therefore sampling speech at 16 kHz is sufficient. Using a higher sampling rate will not capture more information and
merely leads to an increase in the computational cost of processing such files. On the other hand, sampling audio at too
low a sampling rate will result in information loss. Speech sampled at 8 kHz will sound muffled, as the higher frequencies
cannot be captured at this rate.`,Re,B,na=`It’s important to ensure that all audio examples in your dataset have the same sampling rate when working on any audio task.
If you plan to use custom audio data to fine-tune a pre-trained model, the sampling rate of your data should match the
sampling rate of the data the model was pre-trained on. The sampling rate determines the time interval between successive
audio samples, which impacts the temporal resolution of the audio data. Consider an example: a 5-second sound at a sampling
rate of 16,000 Hz will be represented as a series of 80,000 values, while the same 5-second sound at a sampling rate of
8,000 Hz will be represented as a series of 40,000 values. Transformer models that solve audio tasks treat examples as
sequences and rely on attention mechanisms to learn audio or multimodal representation. Since sequences are different for
audio examples at different sampling rates, it will be challenging for models to generalize between sampling rates.
<strong>Resampling</strong> is the process of making the sampling rates match, and is part of <a href="preprocessing#resampling-the-audio-data">preprocessing</a> the audio data.`,Ve,I,Ne,F,la="While the sampling rate tells you how often the samples are taken, what exactly are the values in each sample?",De,L,oa=`Sound is made by changes in air pressure at frequencies that are audible to humans. The <strong>amplitude</strong> of a sound describes
the sound pressure level at any given instant and is measured in decibels (dB). We perceive the amplitude as loudness.
To give you an example, a normal speaking voice is under 60 dB, and a rock concert can be at around 125 dB, pushing the
limits of human hearing.`,Qe,Z,ra=`In digital audio, each audio sample records the amplitude of the audio wave at a point in time. The <strong>bit depth</strong> of the
sample determines with how much precision this amplitude value can be described. The higher the bit depth, the more
faithfully the digital representation approximates the original continuous sound wave.`,Ae,S,pa=`The most common audio bit depths are 16-bit and 24-bit. Each is a binary term, representing the number of possible steps
to which the amplitude value can be quantized when it’s converted from continuous to discrete: 65,536 steps for 16-bit audio,
a whopping 16,777,216 steps for 24-bit audio. Because quantizing involves rounding off the continuous value to a discrete
value, the sampling process introduces noise. The higher the bit depth, the smaller this quantization noise. In practice,
the quantization noise of 16-bit audio is already small enough to be audible, and using higher bit depths is generally
not necessary.`,Ke,U,ua=`You may also come across 32-bit audio. This stores the samples as floating-point values, whereas 16-bit and 24-bit audio
use integer samples. The precision of a 32-bit floating-point value is 24 bits, giving it the same bit depth as 24-bit audio.
Floating-point audio samples are expected to lie within the [-1.0, 1.0] range. Since machine learning models naturally
work on floating-point data, the audio must first be converted into floating-point format before it can be used to train
the model. We’ll see how to do this in the next section on <a href="preprocessing">Preprocessing</a>.`,Oe,P,ma=`Just as with continuous audio signals, the amplitude of digital audio is typically expressed in decibels (dB). Since
human hearing is logarithmic in nature — our ears are more sensitive to small fluctuations in quiet sounds than in loud
sounds — the loudness of a sound is easier to interpret if the amplitudes are in decibels, which are also logarithmic.
The decibel scale for real-world audio starts at 0 dB, which represents the quietest possible sound humans can hear, and
louder sounds have larger values. However, for digital audio signals, 0 dB is the loudest possible amplitude, while all
other amplitudes are negative. As a quick rule of thumb: every -6 dB is a halving of the amplitude, and anything below -60 dB
is generally inaudible unless you really crank up the volume.`,et,X,tt,E,ha=`You may have seen sounds visualized as a <strong>waveform</strong>, which plots the sample values over time and illustrates the changes
in the sound’s amplitude. This is also known as the <em>time domain</em> representation of sound.`,at,W,ca=`This type of visualization is useful for identifying specific features of the audio signal such as the timing of individual
sound events, the overall loudness of the signal, and any irregularities or noise present in the audio.`,st,Y,da="To plot the waveform for an audio signal, we can use a Python library called <code>librosa</code>:",it,R,nt,V,fa="Let’s take an example sound called “trumpet” that comes with the library:",lt,N,ot,D,ga=`The example is loaded as a tuple of audio time series (here we call it <code>array</code>), and sampling rate (<code>sampling_rate</code>).
Let’s take a look at this sound’s waveform by using librosa’s <code>waveshow()</code> function:`,rt,Q,pt,b,wa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_plot.png" alt="Waveform plot"/>',ut,A,va=`This plots the amplitude of the signal on the y-axis and time along the x-axis. In other words, each point corresponds
to a single sample value that was taken when this sound was sampled. Also note that librosa returns the audio as
floating-point values already, and that the amplitude values are indeed within the [-1.0, 1.0] range.`,mt,K,ba=`Visualizing the audio along with listening to it can be a useful tool for understanding the data you are working with.
You can see the shape of the signal, observe patterns, learn to spot noise or distortion. If you preprocess data in some
ways, such as normalization, resampling, or filtering, you can visually confirm that preprocessing steps have been applied as expected.
After training a model, you can also visualize samples where errors occur (e.g. in audio classification task) to debug
the issue.`,ht,O,ct,ee,ya=`Another way to visualize audio data is to plot the <strong>frequency spectrum</strong> of an audio signal, also known as the <em>frequency domain</em>
representation. The spectrum is computed using the discrete Fourier transform or DFT. It describes the individual frequencies
that make up the signal and how strong they are.`,dt,te,Ta=`Let’s plot the frequency spectrum for the same trumpet sound by taking the DFT using numpy’s <code>rfft()</code> function. While it
is possible to plot the spectrum of the entire sound, it’s more useful to look at a small region instead. Here we’ll take
the DFT over the first 4096 samples, which is roughly the length of the first note being played:`,ft,ae,gt,y,xa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/spectrum_plot.png" alt="Spectrum plot"/>',wt,se,Ma=`This plots the strength of the various frequency components that are present in this audio segment. The frequency values are on
the x-axis, usually plotted on a logarithmic scale, while their amplitudes are on the y-axis.`,vt,ie,Ca=`The frequency spectrum that we plotted shows several peaks. These peaks correspond to the harmonics of the note that’s
being played, with the higher harmonics being quieter. Since the first peak is at around 620 Hz, this is the frequency spectrum of an E♭ note.`,bt,ne,$a=`The output of the DFT is an array of complex numbers, made up of real and imaginary components. Taking
the magnitude with <code>np.abs(dft)</code> extracts the amplitude information from the spectrogram. The angle between the real and
imaginary components provides the so-called phase spectrum, but this is often discarded in machine learning applications.`,yt,le,ka=`You used <code>librosa.amplitude_to_db()</code> to convert the amplitude values to the decibel scale, making it easier to see
the finer details in the spectrum. Sometimes people use the <strong>power spectrum</strong>, which measures energy rather than amplitude;
this is simply a spectrum with the amplitude values squared.`,Tt,T,xt,oe,_a=`The frequency spectrum of an audio signal contains the exact same information as its waveform — they are simply two different
ways of looking at the same data (here, the first 4096 samples from the trumpet sound). Where the waveform plots the amplitude
of the audio signal over time, the spectrum visualizes the amplitudes of the individual frequencies at a fixed point in time.`,Mt,re,Ct,pe,Ja=`What if we want to see how the frequencies in an audio signal change? The trumpet plays several notes and they all have
different frequencies. The problem is that the spectrum only shows a frozen snapshot of the frequencies at a given instant.
The solution is to take multiple DFTs, each covering only a small slice of time, and stack the resulting spectra together
into a <strong>spectrogram</strong>.`,$t,ue,Ha=`A spectrogram plots the frequency content of an audio signal as it changes over time. It allows you to see time, frequency,
and amplitude all on one graph. The algorithm that performs this computation is the STFT or Short Time Fourier Transform.`,kt,me,ja=`The spectrogram is one of the most informative audio tools available to you. For example, when working with a music recording,
you can see the various instruments and vocal tracks and how they contribute to the overall sound. In speech, you can
identify different vowel sounds as each vowel is characterized by particular frequencies.`,_t,he,qa="Let’s plot a spectrogram for the same trumpet sound, using librosa’s <code>stft()</code> and <code>specshow()</code> functions:",Jt,ce,Ht,x,za='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/spectrogram_plot.png" alt="Spectrogram plot"/>',jt,de,Ga=`In this plot, the x-axis represents time as in the waveform visualization but now the y-axis represents frequency in Hz.
The intensity of the color gives the amplitude or power of the frequency component at each point in time, measured in decibels (dB).`,qt,fe,Ba=`The spectrogram is created by taking short segments of the audio signal, typically lasting a few milliseconds, and calculating
the discrete Fourier transform of each segment to obtain its frequency spectrum. The resulting spectra are then stacked
together on the time axis to create the spectrogram. Each vertical slice in this image corresponds to a single frequency
spectrum, seen from the top. By default, <code>librosa.stft()</code> splits the audio signal into segments of 2048 samples, which
gives a good trade-off between frequency resolution and time resolution.`,zt,ge,Ia=`Since the spectrogram and the waveform are different views of the same data, it’s possible to turn the spectrogram back
into the original waveform using the inverse STFT. However, this requires the phase information in addition to the amplitude
information. If the spectrogram was generated by a machine learning model, it typically only outputs the amplitudes. In
that case, we can use a phase reconstruction algorithm such as the classic Griffin-Lim algorithm, or using a neural network
called a vocoder, to reconstruct a waveform from the spectrogram.`,Gt,we,Fa=`Spectrograms aren’t just used for visualization. Many machine learning models will take spectrograms as input — as opposed
to waveforms — and produce spectrograms as output.`,Bt,ve,La="Now that we know what a spectrogram is and how it’s made, let’s take a look at a variant of it widely used for speech processing: the mel spectrogram.",It,be,Ft,ye,Za=`A mel spectrogram is a variation of the spectrogram that is commonly used in speech processing and machine learning tasks.
It is similar to a spectrogram in that it shows the frequency content of an audio signal over time, but on a different frequency axis.`,Lt,Te,Sa=`In a standard spectrogram, the frequency axis is linear and is measured in hertz (Hz). However, the human auditory system
is more sensitive to changes in lower frequencies than higher frequencies, and this sensitivity decreases logarithmically
as frequency increases. The mel scale is a perceptual scale that approximates the non-linear frequency response of the human ear.`,Zt,xe,Ua=`To create a mel spectrogram, the STFT is used just like before, splitting the audio into short segments to obtain a sequence
of frequency spectra. Additionally, each spectrum is sent through a set of filters, the so-called mel filterbank, to
transform the frequencies to the mel scale.`,St,Me,Pa="Let’s see how we can plot a mel spectrogram using librosa’s <code>melspectrogram()</code> function, which performs all of those steps for us:",Ut,Ce,Pt,M,Xa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/mel-spectrogram.png" alt="Mel spectrogram plot"/>',Xt,$e,Ea=`In the example above, <code>n_mels</code> stands for the number of mel bands to generate. The mel bands define a set of frequency
ranges that divide the spectrum into perceptually meaningful components, using a set of filters whose shape and spacing
are chosen to mimic the way the human ear responds to different frequencies. Common values for <code>n_mels</code> are 40 or 80. <code>fmax</code>
indicates the highest frequency (in Hz) we care about.`,Et,ke,Wa=`Just as with a regular spectrogram, it’s common practice to express the strength of the mel frequency components in
decibels. This is commonly referred to as a <strong>log-mel spectrogram</strong>, because the conversion to decibels involves a
logarithmic operation. The above example used <code>librosa.power_to_db()</code> as <code>librosa.feature.melspectrogram()</code> creates a power spectrogram.`,Wt,C,Yt,_e,Ya=`Creating a mel spectrogram is a lossy operation as it involves filtering the signal. Converting a mel spectrogram back
into a waveform is more difficult than doing this for a regular spectrogram, as it requires estimating the frequencies
that were thrown away. This is why machine learning models such as HiFiGAN vocoder are needed to produce a waveform from a mel
spectrogram.`,Rt,Je,Ra=`Compared to a standard spectrogram, a mel spectrogram can capture more meaningful features of the audio signal for
human perception, making it a popular choice in tasks such as speech recognition, speaker identification, and music genre classification.`,Vt,He,Va="Now that you know how to visualize audio data examples, go ahead and try to see what your favorite sounds look like. :)",Nt,je,Dt,Ie,Qt;return $=new ze({props:{title:"Introduction to audio data",local:"introduction-to-audio-data",headingTag:"h1"}}),H=new ze({props:{title:"Sampling and sampling rate",local:"sampling-and-sampling-rate",headingTag:"h2"}}),I=new ze({props:{title:"Amplitude and bit depth",local:"amplitude-and-bit-depth",headingTag:"h2"}}),X=new ze({props:{title:"Audio as a waveform",local:"audio-as-a-waveform",headingTag:"h2"}}),R=new Be({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxpYnJvc2E=",highlighted:"pip install librosa",wrap:!1}}),N=new Be({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQSUwQWFycmF5JTJDJTIwc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGxpYnJvc2EubG9hZChsaWJyb3NhLmV4KCUyMnRydW1wZXQlMjIpKQ==",highlighted:`<span class="hljs-keyword">import</span> librosa

array, sampling_rate = librosa.load(librosa.ex(<span class="hljs-string">&quot;trumpet&quot;</span>))`,wrap:!1}}),Q=new Be({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMGxpYnJvc2EuZGlzcGxheSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LndhdmVzaG93KGFycmF5JTJDJTIwc3IlM0RzYW1wbGluZ19yYXRlKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),O=new ze({props:{title:"The frequency spectrum",local:"the-frequency-spectrum",headingTag:"h2"}}),ae=new Be({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZGZ0X2lucHV0JTIwJTNEJTIwYXJyYXklNUIlM0E0MDk2JTVEJTBBJTBBJTIzJTIwY2FsY3VsYXRlJTIwdGhlJTIwREZUJTBBd2luZG93JTIwJTNEJTIwbnAuaGFubmluZyhsZW4oZGZ0X2lucHV0KSklMEF3aW5kb3dlZF9pbnB1dCUyMCUzRCUyMGRmdF9pbnB1dCUyMColMjB3aW5kb3clMEFkZnQlMjAlM0QlMjBucC5mZnQucmZmdCh3aW5kb3dlZF9pbnB1dCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBhbXBsaXR1ZGUlMjBzcGVjdHJ1bSUyMGluJTIwZGVjaWJlbHMlMEFhbXBsaXR1ZGUlMjAlM0QlMjBucC5hYnMoZGZ0KSUwQWFtcGxpdHVkZV9kYiUyMCUzRCUyMGxpYnJvc2EuYW1wbGl0dWRlX3RvX2RiKGFtcGxpdHVkZSUyQyUyMHJlZiUzRG5wLm1heCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBmcmVxdWVuY3klMjBiaW5zJTBBZnJlcXVlbmN5JTIwJTNEJTIwbGlicm9zYS5mZnRfZnJlcXVlbmNpZXMoc3IlM0RzYW1wbGluZ19yYXRlJTJDJTIwbl9mZnQlM0RsZW4oZGZ0X2lucHV0KSklMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQXBsdC5wbG90KGZyZXF1ZW5jeSUyQyUyMGFtcGxpdHVkZV9kYiklMEFwbHQueGxhYmVsKCUyMkZyZXF1ZW5jeSUyMChIeiklMjIpJTBBcGx0LnlsYWJlbCglMjJBbXBsaXR1ZGUlMjAoZEIpJTIyKSUwQXBsdC54c2NhbGUoJTIybG9nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

dft_input = array[:<span class="hljs-number">4096</span>]

<span class="hljs-comment"># calculate the DFT</span>
window = np.hanning(<span class="hljs-built_in">len</span>(dft_input))
windowed_input = dft_input * window
dft = np.fft.rfft(windowed_input)

<span class="hljs-comment"># get the amplitude spectrum in decibels</span>
amplitude = np.<span class="hljs-built_in">abs</span>(dft)
amplitude_db = librosa.amplitude_to_db(amplitude, ref=np.<span class="hljs-built_in">max</span>)

<span class="hljs-comment"># get the frequency bins</span>
frequency = librosa.fft_frequencies(sr=sampling_rate, n_fft=<span class="hljs-built_in">len</span>(dft_input))

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
plt.plot(frequency, amplitude_db)
plt.xlabel(<span class="hljs-string">&quot;Frequency (Hz)&quot;</span>)
plt.ylabel(<span class="hljs-string">&quot;Amplitude (dB)&quot;</span>)
plt.xscale(<span class="hljs-string">&quot;log&quot;</span>)`,wrap:!1}}),T=new Aa({props:{$$slots:{default:[os]},$$scope:{ctx:Ge}}}),re=new ze({props:{title:"Spectrogram",local:"spectrogram",headingTag:"h2"}}),ce=new Be({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBRCUyMCUzRCUyMGxpYnJvc2Euc3RmdChhcnJheSklMEFTX2RiJTIwJTNEJTIwbGlicm9zYS5hbXBsaXR1ZGVfdG9fZGIobnAuYWJzKEQpJTJDJTIwcmVmJTNEbnAubWF4KSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LnNwZWNzaG93KFNfZGIlMkMlMjB4X2F4aXMlM0QlMjJ0aW1lJTIyJTJDJTIweV9heGlzJTNEJTIyaHolMjIpJTBBcGx0LmNvbG9yYmFyKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

D = librosa.stft(array)
S_db = librosa.amplitude_to_db(np.<span class="hljs-built_in">abs</span>(D), ref=np.<span class="hljs-built_in">max</span>)

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(S_db, x_axis=<span class="hljs-string">&quot;time&quot;</span>, y_axis=<span class="hljs-string">&quot;hz&quot;</span>)
plt.colorbar()`,wrap:!1}}),be=new ze({props:{title:"Mel spectrogram",local:"mel-spectrogram",headingTag:"h2"}}),Ce=new Be({props:{code:"UyUyMCUzRCUyMGxpYnJvc2EuZmVhdHVyZS5tZWxzcGVjdHJvZ3JhbSh5JTNEYXJyYXklMkMlMjBzciUzRHNhbXBsaW5nX3JhdGUlMkMlMjBuX21lbHMlM0QxMjglMkMlMjBmbWF4JTNEODAwMCklMEFTX2RCJTIwJTNEJTIwbGlicm9zYS5wb3dlcl90b19kYihTJTJDJTIwcmVmJTNEbnAubWF4KSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LnNwZWNzaG93KFNfZEIlMkMlMjB4X2F4aXMlM0QlMjJ0aW1lJTIyJTJDJTIweV9heGlzJTNEJTIybWVsJTIyJTJDJTIwc3IlM0RzYW1wbGluZ19yYXRlJTJDJTIwZm1heCUzRDgwMDApJTBBcGx0LmNvbG9yYmFyKCk=",highlighted:`S = librosa.feature.melspectrogram(y=array, sr=sampling_rate, n_mels=<span class="hljs-number">128</span>, fmax=<span class="hljs-number">8000</span>)
S_dB = librosa.power_to_db(S, ref=np.<span class="hljs-built_in">max</span>)

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(S_dB, x_axis=<span class="hljs-string">&quot;time&quot;</span>, y_axis=<span class="hljs-string">&quot;mel&quot;</span>, sr=sampling_rate, fmax=<span class="hljs-number">8000</span>)
plt.colorbar()`,wrap:!1}}),C=new Aa({props:{$$slots:{default:[rs]},$$scope:{ctx:Ge}}}),je=new ls({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter1/audio_data.mdx"}}),{c(){p=l("meta"),u=i(),w=l("p"),Fe=i(),m($.$$.fragment),Le=i(),k=l("p"),k.textContent=At,Ze=i(),_=l("p"),_.innerHTML=Kt,Se=i(),J=l("p"),J.textContent=Ot,Ue=i(),m(H.$$.fragment),Pe=i(),j=l("p"),j.innerHTML=ea,Xe=i(),v=l("div"),v.innerHTML=ta,Ee=i(),q=l("p"),q.innerHTML=aa,We=i(),z=l("p"),z.innerHTML=sa,Ye=i(),G=l("p"),G.textContent=ia,Re=i(),B=l("p"),B.innerHTML=na,Ve=i(),m(I.$$.fragment),Ne=i(),F=l("p"),F.textContent=la,De=i(),L=l("p"),L.innerHTML=oa,Qe=i(),Z=l("p"),Z.innerHTML=ra,Ae=i(),S=l("p"),S.textContent=pa,Ke=i(),U=l("p"),U.innerHTML=ua,Oe=i(),P=l("p"),P.textContent=ma,et=i(),m(X.$$.fragment),tt=i(),E=l("p"),E.innerHTML=ha,at=i(),W=l("p"),W.textContent=ca,st=i(),Y=l("p"),Y.innerHTML=da,it=i(),m(R.$$.fragment),nt=i(),V=l("p"),V.textContent=fa,lt=i(),m(N.$$.fragment),ot=i(),D=l("p"),D.innerHTML=ga,rt=i(),m(Q.$$.fragment),pt=i(),b=l("div"),b.innerHTML=wa,ut=i(),A=l("p"),A.textContent=va,mt=i(),K=l("p"),K.textContent=ba,ht=i(),m(O.$$.fragment),ct=i(),ee=l("p"),ee.innerHTML=ya,dt=i(),te=l("p"),te.innerHTML=Ta,ft=i(),m(ae.$$.fragment),gt=i(),y=l("div"),y.innerHTML=xa,wt=i(),se=l("p"),se.textContent=Ma,vt=i(),ie=l("p"),ie.textContent=Ca,bt=i(),ne=l("p"),ne.innerHTML=$a,yt=i(),le=l("p"),le.innerHTML=ka,Tt=i(),m(T.$$.fragment),xt=i(),oe=l("p"),oe.textContent=_a,Mt=i(),m(re.$$.fragment),Ct=i(),pe=l("p"),pe.innerHTML=Ja,$t=i(),ue=l("p"),ue.textContent=Ha,kt=i(),me=l("p"),me.textContent=ja,_t=i(),he=l("p"),he.innerHTML=qa,Jt=i(),m(ce.$$.fragment),Ht=i(),x=l("div"),x.innerHTML=za,jt=i(),de=l("p"),de.textContent=Ga,qt=i(),fe=l("p"),fe.innerHTML=Ba,zt=i(),ge=l("p"),ge.textContent=Ia,Gt=i(),we=l("p"),we.textContent=Fa,Bt=i(),ve=l("p"),ve.textContent=La,It=i(),m(be.$$.fragment),Ft=i(),ye=l("p"),ye.textContent=Za,Lt=i(),Te=l("p"),Te.textContent=Sa,Zt=i(),xe=l("p"),xe.textContent=Ua,St=i(),Me=l("p"),Me.innerHTML=Pa,Ut=i(),m(Ce.$$.fragment),Pt=i(),M=l("div"),M.innerHTML=Xa,Xt=i(),$e=l("p"),$e.innerHTML=Ea,Et=i(),ke=l("p"),ke.innerHTML=Wa,Wt=i(),m(C.$$.fragment),Yt=i(),_e=l("p"),_e.textContent=Ya,Rt=i(),Je=l("p"),Je.textContent=Ra,Vt=i(),He=l("p"),He.textContent=Va,Nt=i(),m(je.$$.fragment),Dt=i(),Ie=l("p"),this.h()},l(e){const t=is("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(a),u=n(e),w=o(e,"P",{}),Qa(w).forEach(a),Fe=n(e),h($.$$.fragment,e),Le=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1pmkh95"&&(k.textContent=At),Ze=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-bb9jdf"&&(_.innerHTML=Kt),Se=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1nxlqp8"&&(J.textContent=Ot),Ue=n(e),h(H.$$.fragment,e),Pe=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ou5bn8"&&(j.innerHTML=ea),Xe=n(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1g809yq"&&(v.innerHTML=ta),Ee=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-42toji"&&(q.innerHTML=aa),We=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1bavgg"&&(z.innerHTML=sa),Ye=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-erenf"&&(G.textContent=ia),Re=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-vwfzx1"&&(B.innerHTML=na),Ve=n(e),h(I.$$.fragment,e),Ne=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-aeraln"&&(F.textContent=la),De=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-c1topq"&&(L.innerHTML=oa),Qe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-17m5t67"&&(Z.innerHTML=ra),Ae=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1zj4fu"&&(S.textContent=pa),Ke=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1mkb3me"&&(U.innerHTML=ua),Oe=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1vo81sc"&&(P.textContent=ma),et=n(e),h(X.$$.fragment,e),tt=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1cl8jes"&&(E.innerHTML=ha),at=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1ef6fws"&&(W.textContent=ca),st=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-7fbxqn"&&(Y.innerHTML=da),it=n(e),h(R.$$.fragment,e),nt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-4c289b"&&(V.textContent=fa),lt=n(e),h(N.$$.fragment,e),ot=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1uo32p8"&&(D.innerHTML=ga),rt=n(e),h(Q.$$.fragment,e),pt=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1cse5se"&&(b.innerHTML=wa),ut=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-4i4t88"&&(A.textContent=va),mt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-15w4tcn"&&(K.textContent=ba),ht=n(e),h(O.$$.fragment,e),ct=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-zbggm7"&&(ee.innerHTML=ya),dt=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-pcmpy3"&&(te.innerHTML=Ta),ft=n(e),h(ae.$$.fragment,e),gt=n(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1eg4i6m"&&(y.innerHTML=xa),wt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-2gktww"&&(se.textContent=Ma),vt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1iiz53k"&&(ie.textContent=Ca),bt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1djmz7i"&&(ne.innerHTML=$a),yt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1bt1xj3"&&(le.innerHTML=ka),Tt=n(e),h(T.$$.fragment,e),xt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-59fha7"&&(oe.textContent=_a),Mt=n(e),h(re.$$.fragment,e),Ct=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-196s45l"&&(pe.innerHTML=Ja),$t=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1l55l7k"&&(ue.textContent=Ha),kt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-u0c2pj"&&(me.textContent=ja),_t=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-rcbtf3"&&(he.innerHTML=qa),Jt=n(e),h(ce.$$.fragment,e),Ht=n(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-b6kbs6"&&(x.innerHTML=za),jt=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1fap1oe"&&(de.textContent=Ga),qt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1v7yz7v"&&(fe.innerHTML=Ba),zt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-13z5f9l"&&(ge.textContent=Ia),Gt=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-fc7u1p"&&(we.textContent=Fa),Bt=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-tu7x1"&&(ve.textContent=La),It=n(e),h(be.$$.fragment,e),Ft=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-naa7dr"&&(ye.textContent=Za),Lt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1x7yj9g"&&(Te.textContent=Sa),Zt=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-9z7nz9"&&(xe.textContent=Ua),St=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1bkzq64"&&(Me.innerHTML=Pa),Ut=n(e),h(Ce.$$.fragment,e),Pt=n(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1soplef"&&(M.innerHTML=Xa),Xt=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-otxgpj"&&($e.innerHTML=Ea),Et=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-fposmi"&&(ke.innerHTML=Wa),Wt=n(e),h(C.$$.fragment,e),Yt=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-ph55g"&&(_e.textContent=Ya),Rt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-lsf6hk"&&(Je.textContent=Ra),Vt=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1xaydvu"&&(He.textContent=Va),Nt=n(e),h(je.$$.fragment,e),Dt=n(e),Ie=o(e,"P",{}),Qa(Ie).forEach(a),this.h()},h(){qe(p,"name","hf:doc:metadata"),qe(p,"content",us),qe(v,"class","flex justify-center"),qe(b,"class","flex justify-center"),qe(y,"class","flex justify-center"),qe(x,"class","flex justify-center"),qe(M,"class","flex justify-center")},m(e,t){ns(document.head,p),s(e,u,t),s(e,w,t),s(e,Fe,t),c($,e,t),s(e,Le,t),s(e,k,t),s(e,Ze,t),s(e,_,t),s(e,Se,t),s(e,J,t),s(e,Ue,t),c(H,e,t),s(e,Pe,t),s(e,j,t),s(e,Xe,t),s(e,v,t),s(e,Ee,t),s(e,q,t),s(e,We,t),s(e,z,t),s(e,Ye,t),s(e,G,t),s(e,Re,t),s(e,B,t),s(e,Ve,t),c(I,e,t),s(e,Ne,t),s(e,F,t),s(e,De,t),s(e,L,t),s(e,Qe,t),s(e,Z,t),s(e,Ae,t),s(e,S,t),s(e,Ke,t),s(e,U,t),s(e,Oe,t),s(e,P,t),s(e,et,t),c(X,e,t),s(e,tt,t),s(e,E,t),s(e,at,t),s(e,W,t),s(e,st,t),s(e,Y,t),s(e,it,t),c(R,e,t),s(e,nt,t),s(e,V,t),s(e,lt,t),c(N,e,t),s(e,ot,t),s(e,D,t),s(e,rt,t),c(Q,e,t),s(e,pt,t),s(e,b,t),s(e,ut,t),s(e,A,t),s(e,mt,t),s(e,K,t),s(e,ht,t),c(O,e,t),s(e,ct,t),s(e,ee,t),s(e,dt,t),s(e,te,t),s(e,ft,t),c(ae,e,t),s(e,gt,t),s(e,y,t),s(e,wt,t),s(e,se,t),s(e,vt,t),s(e,ie,t),s(e,bt,t),s(e,ne,t),s(e,yt,t),s(e,le,t),s(e,Tt,t),c(T,e,t),s(e,xt,t),s(e,oe,t),s(e,Mt,t),c(re,e,t),s(e,Ct,t),s(e,pe,t),s(e,$t,t),s(e,ue,t),s(e,kt,t),s(e,me,t),s(e,_t,t),s(e,he,t),s(e,Jt,t),c(ce,e,t),s(e,Ht,t),s(e,x,t),s(e,jt,t),s(e,de,t),s(e,qt,t),s(e,fe,t),s(e,zt,t),s(e,ge,t),s(e,Gt,t),s(e,we,t),s(e,Bt,t),s(e,ve,t),s(e,It,t),c(be,e,t),s(e,Ft,t),s(e,ye,t),s(e,Lt,t),s(e,Te,t),s(e,Zt,t),s(e,xe,t),s(e,St,t),s(e,Me,t),s(e,Ut,t),c(Ce,e,t),s(e,Pt,t),s(e,M,t),s(e,Xt,t),s(e,$e,t),s(e,Et,t),s(e,ke,t),s(e,Wt,t),c(C,e,t),s(e,Yt,t),s(e,_e,t),s(e,Rt,t),s(e,Je,t),s(e,Vt,t),s(e,He,t),s(e,Nt,t),c(je,e,t),s(e,Dt,t),s(e,Ie,t),Qt=!0},p(e,[t]){const Na={};t&2&&(Na.$$scope={dirty:t,ctx:e}),T.$set(Na);const Da={};t&2&&(Da.$$scope={dirty:t,ctx:e}),C.$set(Da)},i(e){Qt||(d($.$$.fragment,e),d(H.$$.fragment,e),d(I.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(O.$$.fragment,e),d(ae.$$.fragment,e),d(T.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(be.$$.fragment,e),d(Ce.$$.fragment,e),d(C.$$.fragment,e),d(je.$$.fragment,e),Qt=!0)},o(e){f($.$$.fragment,e),f(H.$$.fragment,e),f(I.$$.fragment,e),f(X.$$.fragment,e),f(R.$$.fragment,e),f(N.$$.fragment,e),f(Q.$$.fragment,e),f(O.$$.fragment,e),f(ae.$$.fragment,e),f(T.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(be.$$.fragment,e),f(Ce.$$.fragment,e),f(C.$$.fragment,e),f(je.$$.fragment,e),Qt=!1},d(e){e&&(a(u),a(w),a(Fe),a(Le),a(k),a(Ze),a(_),a(Se),a(J),a(Ue),a(Pe),a(j),a(Xe),a(v),a(Ee),a(q),a(We),a(z),a(Ye),a(G),a(Re),a(B),a(Ve),a(Ne),a(F),a(De),a(L),a(Qe),a(Z),a(Ae),a(S),a(Ke),a(U),a(Oe),a(P),a(et),a(tt),a(E),a(at),a(W),a(st),a(Y),a(it),a(nt),a(V),a(lt),a(ot),a(D),a(rt),a(pt),a(b),a(ut),a(A),a(mt),a(K),a(ht),a(ct),a(ee),a(dt),a(te),a(ft),a(gt),a(y),a(wt),a(se),a(vt),a(ie),a(bt),a(ne),a(yt),a(le),a(Tt),a(xt),a(oe),a(Mt),a(Ct),a(pe),a($t),a(ue),a(kt),a(me),a(_t),a(he),a(Jt),a(Ht),a(x),a(jt),a(de),a(qt),a(fe),a(zt),a(ge),a(Gt),a(we),a(Bt),a(ve),a(It),a(Ft),a(ye),a(Lt),a(Te),a(Zt),a(xe),a(St),a(Me),a(Ut),a(Pt),a(M),a(Xt),a($e),a(Et),a(ke),a(Wt),a(Yt),a(_e),a(Rt),a(Je),a(Vt),a(He),a(Nt),a(Dt),a(Ie)),a(p),g($,e),g(H,e),g(I,e),g(X,e),g(R,e),g(N,e),g(Q,e),g(O,e),g(ae,e),g(T,e),g(re,e),g(ce,e),g(be,e),g(Ce,e),g(C,e),g(je,e)}}}const us='{"title":"Introduction to audio data","local":"introduction-to-audio-data","sections":[{"title":"Sampling and sampling rate","local":"sampling-and-sampling-rate","sections":[],"depth":2},{"title":"Amplitude and bit depth","local":"amplitude-and-bit-depth","sections":[],"depth":2},{"title":"Audio as a waveform","local":"audio-as-a-waveform","sections":[],"depth":2},{"title":"The frequency spectrum","local":"the-frequency-spectrum","sections":[],"depth":2},{"title":"Spectrogram","local":"spectrogram","sections":[],"depth":2},{"title":"Mel spectrogram","local":"mel-spectrogram","sections":[],"depth":2}],"depth":1}';function ms(Ge){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ws extends as{constructor(p){super(),ss(this,p,ms,ps,es,{})}}export{ws as component};
