import{s as fs,n as Es,o as Ss}from"../chunks/scheduler.f7e1785c.js";import{S as bs,i as Qs,g as n,s as a,r as Q,A as Ds,h as y,f as t,c as e,j as gs,u as D,x as U,k as qs,y as Bs,a as l,v as B,d as N,t as k,w as v}from"../chunks/index.9f8f0838.js";import{C as Z}from"../chunks/CodeBlock.4baef5d7.js";import{H as Ns,E as ks}from"../chunks/getInferenceSnippets.00780c44.js";function vs(Ts){let o,_,x,z,T,R,J,Js=`One of the biggest challenges faced with audio datasets is their sheer size. A single minute of uncompressed CD-quality audio (44.1kHz, 16-bit)
takes up  a bit more than 5 MB of storage. Typically, an audio dataset would contains hours of recordings.`,F,i,is=`In the previous sections we used a very small subset of MINDS-14 audio dataset, however, typical audio datasets are much larger.
For example, the <code>xs</code> (smallest) configuration of <a href="https://huggingface.co/datasets/speechcolab/gigaspeech" rel="nofollow">GigaSpeech from SpeechColab</a>
contains only 10 hours of training data, but takes over 13GB of storage space for download and preparation. So what
happens when we want to train on a larger split? The full <code>xl</code> configuration of the same dataset contains 10,000 hours of
training data, requiring over 1TB of storage space. For most of us, this well exceeds the specifications of a typical
hard drive disk. Do we need to fork out and buy additional storage? Or is there a way we can train on these datasets with no disk space constraints?`,W,w,ws=`🤗 Datasets comes to the rescue by offering the <a href="https://huggingface.co/docs/datasets/stream" rel="nofollow">streaming mode</a>. Streaming allows us to load the data progressively as
we iterate over the dataset. Rather than downloading the whole dataset at once, we load the dataset one example at a time.
We iterate over the dataset, loading and preparing examples on the fly when they are needed. This way, we only ever
load the examples that we’re using, and not the ones that we’re not!
Once we’re done with an example sample, we continue iterating over the dataset and load the next one.`,Y,C,Cs="Streaming mode has three primary advantages over downloading the entire dataset at once:",$,j,js=`<li>Disk space: examples are loaded to memory one-by-one as we iterate over the dataset. Since the data is not downloaded
locally, there are no disk space requirements, so you can use datasets of arbitrary size.</li> <li>Download and processing time: audio datasets are large and need a significant amount of time to download and process.
With streaming, loading and processing is done on the fly, meaning you can start using the dataset as soon as the first
example is ready.</li> <li>Easy experimentation: you can experiment on a handful of examples to check that your script works without having to
download the entire dataset.</li>`,G,p,ps=`There is one caveat to streaming mode. When downloading a full dataset without streaming, both the raw data and processed
data are saved locally to disk. If we want to re-use this dataset, we can directly load the processed data from disk,
skipping the download and processing steps.  Consequently, we only have to perform the downloading and processing
operations once, after which we can re-use the prepared data.`,X,r,rs=`With streaming mode, the data is not downloaded to disk. Thus, neither the downloaded nor pre-processed data are cached.
If we want to re-use the dataset, the streaming steps must be repeated, with the audio files loaded and processed on
the fly again. For this reason, it is advised to download datasets that you are likely to use multiple times.`,L,u,us=`How can you enable streaming mode? Easy! Just set <code>streaming=True</code> when you load your dataset. The rest will be taken
care for you:`,O,I,H,A,Is=`Just like we applied preprocessing steps to a downloaded subset of MINDS-14, you can do the same preprocessing with a
streaming dataset in the exactly the same manner.`,P,h,As=`The only difference is that you can no longer access individual samples using Python indexing (i.e. <code>gigaspeech[&quot;train&quot;][sample_idx]</code>).
Instead, you have to iterate over the dataset. Here’s how you can access an example when streaming a dataset:`,K,c,ss,d,hs="<strong>Output:</strong>",Ms,m,ts,g,cs=`If you’d like to preview several examples from a large dataset, use the <code>take()</code> to get the first n elements. Let’s grab
the first two examples in the gigaspeech dataset:`,ls,q,as,f,ds="<strong>Output:</strong>",es,E,ns,S,ms=`Streaming mode can take your research to the next level: not only are the biggest datasets accessible to you, but you
can easily evaluate systems over multiple datasets in one go without worrying about your disk space. Compared to
evaluating on a single dataset, multi-dataset evaluation gives a better metric for the generalisation abilities of a
speech recognition system (c.f. End-to-end Speech Benchmark (ESB)).`,ys,b,Us,V,os;return T=new Ns({props:{title:"Streaming audio data",local:"streaming-audio-data",headingTag:"h1"}}),I=new Z({props:{code:"Z2lnYXNwZWVjaCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzcGVlY2hjb2xhYiUyRmdpZ2FzcGVlY2glMjIlMkMlMjAlMjJ4cyUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUp",highlighted:'gigaspeech = load_dataset(<span class="hljs-string">&quot;speechcolab/gigaspeech&quot;</span>, <span class="hljs-string">&quot;xs&quot;</span>, streaming=<span class="hljs-literal">True</span>)',wrap:!1}}),c=new Z({props:{code:"bmV4dChpdGVyKGdpZ2FzcGVlY2glNUIlMjJ0cmFpbiUyMiU1RCkp",highlighted:'<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(gigaspeech[<span class="hljs-string">&quot;train&quot;</span>]))',wrap:!1}}),m=new Z({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyc2VnbWVudF9pZCUyMiUzQSUyMCUyMllPVTAwMDAwMDAzMTVfUzAwMDA2NjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJzcGVha2VyJTIyJTNBJTIwJTIyTiUyRkElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyQVMlMjBUSEVZJ1JFJTIwTEVBVklORyUyMCUzQ0NPTU1BJTNFJTIwQ0FOJTIwS0FTSCUyMFBVTEwlMjBaQUhSQSUyMEFTSURFJTIwUkVBTExZJTIwUVVJQ0tMWSUyMCUzQ1FVRVNUSU9OTUFSSyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMnhzX2NodW5rc18wMDAwJTJGWU9VMDAwMDAwMDMxNV9TMDAwMDY2MC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjAuMDAwNTE4OCUyQyUyMDAuMDAwODU0NDklMkMlMjAwLjAwMDEyMjA3JTJDJTIwLi4uJTJDJTIwMC4wMDEyNTEyMiUyQyUyMDAuMDAwNzYyOTQlMkMlMjAwLjAwMDM2NjIxJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjAxNjAwMCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmJlZ2luX3RpbWUlMjIlM0ElMjAyOTQxLjg5JTJDJTBBJTIwJTIwJTIwJTIwJTIyZW5kX3RpbWUlMjIlM0ElMjAyOTQ1LjA3JTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW9faWQlMjIlM0ElMjAlMjJZT1UwMDAwMDAwMzE1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJSZXR1cm4lMjB0byUyMFZhc3NlbGhlaW0lMjAlN0MlMjBDcml0aWNhbCUyMFJvbGUlM0ElMjBWT1glMjBNQUNISU5BJTIwJTdDJTIwRXBpc29kZSUyMDQzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cueW91dHViZS5jb20lMkZ3YXRjaCUzRnYlM0R6cjJuMWZMVmFzVSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnNvdXJjZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJjYXRlZ29yeSUyMiUzQSUyMDI0JTJDJTBBJTIwJTIwJTIwJTIwJTIyb3JpZ2luYWxfZnVsbF9wYXRoJTIyJTNBJTIwJTIyYXVkaW8lMkZ5b3V0dWJlJTJGUDAwMDQlMkZZT1UwMDAwMDAwMzE1Lm9wdXMlMjIlMkMlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&quot;segment_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315_S0000660&quot;</span>,
    <span class="hljs-string">&quot;speaker&quot;</span>: <span class="hljs-string">&quot;N/A&quot;</span>,
    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;AS THEY&#x27;RE LEAVING &lt;COMMA&gt; CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY &lt;QUESTIONMARK&gt;&quot;</span>,
    <span class="hljs-string">&quot;audio&quot;</span>: {
        <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;xs_chunks_0000/YOU0000000315_S0000660.wav&quot;</span>,
        <span class="hljs-string">&quot;array&quot;</span>: <span class="hljs-built_in">array</span>(
            <span class="hljs-selector-attr">[0.0005188, 0.00085449, 0.00012207, ..., 0.00125122, 0.00076294, 0.00036621]</span>
        ),
        <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-string">&quot;begin_time&quot;</span>: <span class="hljs-number">2941.89</span>,
    <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-number">2945.07</span>,
    <span class="hljs-string">&quot;audio_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315&quot;</span>,
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43&quot;</span>,
    <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.youtube.com/watch?v=zr2n1fLVasU&quot;</span>,
    <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-number">24</span>,
    <span class="hljs-string">&quot;original_full_path&quot;</span>: <span class="hljs-string">&quot;audio/youtube/P0004/YOU0000000315.opus&quot;</span>,
}`,wrap:!1}}),q=new Z({props:{code:"Z2lnYXNwZWVjaF9oZWFkJTIwJTNEJTIwZ2lnYXNwZWVjaCU1QiUyMnRyYWluJTIyJTVELnRha2UoMiklMEFsaXN0KGdpZ2FzcGVlY2hfaGVhZCk=",highlighted:`gigaspeech_head = gigaspeech[<span class="hljs-string">&quot;train&quot;</span>].take(<span class="hljs-number">2</span>)
<span class="hljs-built_in">list</span>(gigaspeech_head)`,wrap:!1}}),E=new Z({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2VnbWVudF9pZCUyMiUzQSUyMCUyMllPVTAwMDAwMDAzMTVfUzAwMDA2NjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGVha2VyJTIyJTNBJTIwJTIyTiUyRkElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyQVMlMjBUSEVZJ1JFJTIwTEVBVklORyUyMCUzQ0NPTU1BJTNFJTIwQ0FOJTIwS0FTSCUyMFBVTEwlMjBaQUhSQSUyMEFTSURFJTIwUkVBTExZJTIwUVVJQ0tMWSUyMCUzQ1FVRVNUSU9OTUFSSyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMnhzX2NodW5rc18wMDAwJTJGWU9VMDAwMDAwMDMxNV9TMDAwMDY2MC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAuMDAwNTE4OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAuMDAwODU0NDklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwLjAwMDEyMjA3JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMC4wMDEyNTEyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAuMDAwNzYyOTQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwLjAwMDM2NjIxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjAxNjAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmJlZ2luX3RpbWUlMjIlM0ElMjAyOTQxLjg5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5kX3RpbWUlMjIlM0ElMjAyOTQ1LjA3JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXVkaW9faWQlMjIlM0ElMjAlMjJZT1UwMDAwMDAwMzE1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJSZXR1cm4lMjB0byUyMFZhc3NlbGhlaW0lMjAlN0MlMjBDcml0aWNhbCUyMFJvbGUlM0ElMjBWT1glMjBNQUNISU5BJTIwJTdDJTIwRXBpc29kZSUyMDQzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cueW91dHViZS5jb20lMkZ3YXRjaCUzRnYlM0R6cjJuMWZMVmFzVSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNvdXJjZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeSUyMiUzQSUyMDI0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3JpZ2luYWxfZnVsbF9wYXRoJTIyJTNBJTIwJTIyYXVkaW8lMkZ5b3V0dWJlJTJGUDAwMDQlMkZZT1UwMDAwMDAwMzE1Lm9wdXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZWdtZW50X2lkJTIyJTNBJTIwJTIyQVVEMDAwMDAwMTA0M19TMDAwMDc3NSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNwZWFrZXIlMjIlM0ElMjAlMjJOJTJGQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjJTSVglMjBUT01BVE9FUyUyMCUzQ1BFUklPRCUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMnhzX2NodW5rc18wMDAwJTJGQVVEMDAwMDAwMTA0M19TMDAwMDc3NS53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDEuNDM0MzI2MTdlLTAzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4zNzMyOTEwMmUtMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxLjMxMjI1NTg2ZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC02LjEwMzUxNTYyZS0wNSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0xLjIyMDcwMzEyZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0xLjgzMTA1NDY5ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzYW1wbGluZ19yYXRlJTIyJTNBJTIwMTYwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiZWdpbl90aW1lJTIyJTNBJTIwMzY3My45NiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuZF90aW1lJTIyJTNBJTIwMzY3NS4yNiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmF1ZGlvX2lkJTIyJTNBJTIwJTIyQVVEMDAwMDAwMTA0MyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRpdGxlJTIyJTNBJTIwJTIyQXN0ZXJvaWQlMjBvZiUyMEZlYXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTJGJTJGd3d3LmFyY2hpdmUub3JnJTJGZG93bmxvYWQlMkZhc3Rlcm9pZF9vZl9mZWFyXzEwMTJfbGlicml2b3glMkZhc3Rlcm9pZF9vZl9mZWFyXzEwMTJfbGlicml2b3hfNjRrYl9tcDMuemlwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc291cmNlJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNhdGVnb3J5JTIyJTNBJTIwMjglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvcmlnaW5hbF9mdWxsX3BhdGglMjIlM0ElMjAlMjJhdWRpbyUyRmF1ZGlvYm9vayUyRlAwMDExJTJGQVVEMDAwMDAwMTA0My5vcHVzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVE",highlighted:`[
    {
        <span class="hljs-string">&quot;segment_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315_S0000660&quot;</span>,
        <span class="hljs-string">&quot;speaker&quot;</span>: <span class="hljs-string">&quot;N/A&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;AS THEY&#x27;RE LEAVING &lt;COMMA&gt; CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY &lt;QUESTIONMARK&gt;&quot;</span>,
        <span class="hljs-string">&quot;audio&quot;</span>: {
            <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;xs_chunks_0000/YOU0000000315_S0000660.wav&quot;</span>,
            <span class="hljs-string">&quot;array&quot;</span>: array(
                [
                    <span class="hljs-number">0.0005188</span>,
                    <span class="hljs-number">0.00085449</span>,
                    <span class="hljs-number">0.00012207</span>,
                    ...,
                    <span class="hljs-number">0.00125122</span>,
                    <span class="hljs-number">0.00076294</span>,
                    <span class="hljs-number">0.00036621</span>,
                ]
            ),
            <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
        },
        <span class="hljs-string">&quot;begin_time&quot;</span>: <span class="hljs-number">2941.89</span>,
        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-number">2945.07</span>,
        <span class="hljs-string">&quot;audio_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315&quot;</span>,
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43&quot;</span>,
        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.youtube.com/watch?v=zr2n1fLVasU&quot;</span>,
        <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-number">2</span>,
        <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-number">24</span>,
        <span class="hljs-string">&quot;original_full_path&quot;</span>: <span class="hljs-string">&quot;audio/youtube/P0004/YOU0000000315.opus&quot;</span>,
    },
    {
        <span class="hljs-string">&quot;segment_id&quot;</span>: <span class="hljs-string">&quot;AUD0000001043_S0000775&quot;</span>,
        <span class="hljs-string">&quot;speaker&quot;</span>: <span class="hljs-string">&quot;N/A&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;SIX TOMATOES &lt;PERIOD&gt;&quot;</span>,
        <span class="hljs-string">&quot;audio&quot;</span>: {
            <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;xs_chunks_0000/AUD0000001043_S0000775.wav&quot;</span>,
            <span class="hljs-string">&quot;array&quot;</span>: array(
                [
                    <span class="hljs-number">1.43432617</span>e-03,
                    <span class="hljs-number">1.37329102</span>e-03,
                    <span class="hljs-number">1.31225586</span>e-03,
                    ...,
                    <span class="hljs-number">-6.10351562</span>e-05,
                    <span class="hljs-number">-1.22070312</span>e-04,
                    <span class="hljs-number">-1.83105469</span>e-04,
                ]
            ),
            <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
        },
        <span class="hljs-string">&quot;begin_time&quot;</span>: <span class="hljs-number">3673.96</span>,
        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-number">3675.26</span>,
        <span class="hljs-string">&quot;audio_id&quot;</span>: <span class="hljs-string">&quot;AUD0000001043&quot;</span>,
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Asteroid of Fear&quot;</span>,
        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http//www.archive.org/download/asteroid_of_fear_1012_librivox/asteroid_of_fear_1012_librivox_64kb_mp3.zip&quot;</span>,
        <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-number">0</span>,
        <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-number">28</span>,
        <span class="hljs-string">&quot;original_full_path&quot;</span>: <span class="hljs-string">&quot;audio/audiobook/P0011/AUD0000001043.opus&quot;</span>,
    },
]`,wrap:!1}}),b=new ks({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter1/streaming.mdx"}}),{c(){o=n("meta"),_=a(),x=n("p"),z=a(),Q(T.$$.fragment),R=a(),J=n("p"),J.textContent=Js,F=a(),i=n("p"),i.innerHTML=is,W=a(),w=n("p"),w.innerHTML=ws,Y=a(),C=n("p"),C.textContent=Cs,$=a(),j=n("ul"),j.innerHTML=js,G=a(),p=n("p"),p.textContent=ps,X=a(),r=n("p"),r.textContent=rs,L=a(),u=n("p"),u.innerHTML=us,O=a(),Q(I.$$.fragment),H=a(),A=n("p"),A.textContent=Is,P=a(),h=n("p"),h.innerHTML=As,K=a(),Q(c.$$.fragment),ss=a(),d=n("p"),d.innerHTML=hs,Ms=a(),Q(m.$$.fragment),ts=a(),g=n("p"),g.innerHTML=cs,ls=a(),Q(q.$$.fragment),as=a(),f=n("p"),f.innerHTML=ds,es=a(),Q(E.$$.fragment),ns=a(),S=n("p"),S.textContent=ms,ys=a(),Q(b.$$.fragment),Us=a(),V=n("p"),this.h()},l(s){const M=Ds("svelte-u9bgzb",document.head);o=y(M,"META",{name:!0,content:!0}),M.forEach(t),_=e(s),x=y(s,"P",{}),gs(x).forEach(t),z=e(s),D(T.$$.fragment,s),R=e(s),J=y(s,"P",{"data-svelte-h":!0}),U(J)!=="svelte-n8v3tf"&&(J.textContent=Js),F=e(s),i=y(s,"P",{"data-svelte-h":!0}),U(i)!=="svelte-nayksx"&&(i.innerHTML=is),W=e(s),w=y(s,"P",{"data-svelte-h":!0}),U(w)!=="svelte-1cmn14y"&&(w.innerHTML=ws),Y=e(s),C=y(s,"P",{"data-svelte-h":!0}),U(C)!=="svelte-1doba0z"&&(C.textContent=Cs),$=e(s),j=y(s,"UL",{"data-svelte-h":!0}),U(j)!=="svelte-dy12ia"&&(j.innerHTML=js),G=e(s),p=y(s,"P",{"data-svelte-h":!0}),U(p)!=="svelte-dhhyuw"&&(p.textContent=ps),X=e(s),r=y(s,"P",{"data-svelte-h":!0}),U(r)!=="svelte-1b0tiu9"&&(r.textContent=rs),L=e(s),u=y(s,"P",{"data-svelte-h":!0}),U(u)!=="svelte-16vl0hj"&&(u.innerHTML=us),O=e(s),D(I.$$.fragment,s),H=e(s),A=y(s,"P",{"data-svelte-h":!0}),U(A)!=="svelte-182p0qe"&&(A.textContent=Is),P=e(s),h=y(s,"P",{"data-svelte-h":!0}),U(h)!=="svelte-1e6b0ye"&&(h.innerHTML=As),K=e(s),D(c.$$.fragment,s),ss=e(s),d=y(s,"P",{"data-svelte-h":!0}),U(d)!=="svelte-1mvdyro"&&(d.innerHTML=hs),Ms=e(s),D(m.$$.fragment,s),ts=e(s),g=y(s,"P",{"data-svelte-h":!0}),U(g)!=="svelte-k3iau9"&&(g.innerHTML=cs),ls=e(s),D(q.$$.fragment,s),as=e(s),f=y(s,"P",{"data-svelte-h":!0}),U(f)!=="svelte-1mvdyro"&&(f.innerHTML=ds),es=e(s),D(E.$$.fragment,s),ns=e(s),S=y(s,"P",{"data-svelte-h":!0}),U(S)!=="svelte-1jjur40"&&(S.textContent=ms),ys=e(s),D(b.$$.fragment,s),Us=e(s),V=y(s,"P",{}),gs(V).forEach(t),this.h()},h(){qs(o,"name","hf:doc:metadata"),qs(o,"content",xs)},m(s,M){Bs(document.head,o),l(s,_,M),l(s,x,M),l(s,z,M),B(T,s,M),l(s,R,M),l(s,J,M),l(s,F,M),l(s,i,M),l(s,W,M),l(s,w,M),l(s,Y,M),l(s,C,M),l(s,$,M),l(s,j,M),l(s,G,M),l(s,p,M),l(s,X,M),l(s,r,M),l(s,L,M),l(s,u,M),l(s,O,M),B(I,s,M),l(s,H,M),l(s,A,M),l(s,P,M),l(s,h,M),l(s,K,M),B(c,s,M),l(s,ss,M),l(s,d,M),l(s,Ms,M),B(m,s,M),l(s,ts,M),l(s,g,M),l(s,ls,M),B(q,s,M),l(s,as,M),l(s,f,M),l(s,es,M),B(E,s,M),l(s,ns,M),l(s,S,M),l(s,ys,M),B(b,s,M),l(s,Us,M),l(s,V,M),os=!0},p:Es,i(s){os||(N(T.$$.fragment,s),N(I.$$.fragment,s),N(c.$$.fragment,s),N(m.$$.fragment,s),N(q.$$.fragment,s),N(E.$$.fragment,s),N(b.$$.fragment,s),os=!0)},o(s){k(T.$$.fragment,s),k(I.$$.fragment,s),k(c.$$.fragment,s),k(m.$$.fragment,s),k(q.$$.fragment,s),k(E.$$.fragment,s),k(b.$$.fragment,s),os=!1},d(s){s&&(t(_),t(x),t(z),t(R),t(J),t(F),t(i),t(W),t(w),t(Y),t(C),t($),t(j),t(G),t(p),t(X),t(r),t(L),t(u),t(O),t(H),t(A),t(P),t(h),t(K),t(ss),t(d),t(Ms),t(ts),t(g),t(ls),t(as),t(f),t(es),t(ns),t(S),t(ys),t(Us),t(V)),t(o),v(T,s),v(I,s),v(c,s),v(m,s),v(q,s),v(E,s),v(b,s)}}}const xs='{"title":"Streaming audio data","local":"streaming-audio-data","sections":[],"depth":1}';function Vs(Ts){return Ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fs extends bs{constructor(o){super(),Qs(this,o,Vs,vs,fs,{})}}export{Fs as component};
