import{s as Sl,n as Bl,o as Cl}from"../chunks/scheduler.f7e1785c.js";import{S as xl,i as El,g as i,s as l,r as p,m as J,H as oa,A as Gl,h as o,f as s,c as n,j as ma,u as h,x as r,n as b,E as ra,k as ht,y as T,a,v as c,d,t as m,w as M}from"../chunks/index.9f8f0838.js";import{C as u}from"../chunks/CodeBlock.4baef5d7.js";import{H as ct,E as Rl}from"../chunks/getInferenceSnippets.00780c44.js";function Vl(Ma){let U,dt,rt,mt,j,Mt,I,ua=`In this section, we’ll cover how to use the <code>pipeline()</code> to leverage pre-trained models for speech recognition. In <a href="../chapter2/asr_pipeline">Unit 2</a>,
we introduced the <code>pipeline()</code> as an easy way of running speech recognition tasks, with all pre- and post-processing handled under-the-hood
and the flexibility to quickly experiment with any pre-trained checkpoint on the Hugging Face Hub. In this Unit, we’ll go a
level deeper and explore the different attributes of speech recognition models and how we can use them to tackle a range
of different tasks.`,ut,k,ya="As detailed in Unit 3, speech recognition model broadly fall into one of two categories:",yt,v,wa="<li>Connectionist Temporal Classification (CTC): <em>encoder-only</em> models with a linear classification (CTC) head on top</li> <li>Sequence-to-sequence (Seq2Seq): <em>encoder-decoder</em> models, with a cross-attention mechanism between the encoder and decoder</li>",wt,S,Ta=`Prior to 2022, CTC was the more popular of the two architectures, with encoder-only models such as Wav2Vec2, HuBERT and XLSR achieving
breakthoughs in the pre-training / fine-tuning paradigm for speech. Big corporations, such as Meta and Microsoft, pre-trained
the encoder on vast amounts of unlabelled audio data for many days or weeks. Users could then take a pre-trained checkpoint, and
fine-tune it with a CTC head on as little as <strong>10 minutes</strong> of labelled speech data to achieve strong performance on a downstream
speech recognition task.`,Tt,B,Ua=`However, CTC models have their shortcomings. Appending a simple linear layer to an encoder gives a small, fast overall model, but can
be prone to phonetic spelling errors. We’ll demonstrate this for the Wav2Vec2 model below.`,Ut,C,ft,x,fa=`Let’s load a small excerpt of the <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> dataset to demonstrate
Wav2Vec2’s speech transcription capabilities:`,gt,E,Jt,G,ga="<strong>Output:</strong>",bt,R,jt,V,Ja="We can pick one of the 73 audio samples and inspect the audio sample as well as the transcription:",It,$,kt,H,ba="<strong>Output:</strong>",vt,W,St,F,ja=`Alright! Christmas and roast beef, sounds great! 🎄 Having chosen a data sample, we now load a fine-tuned checkpoint into
the <code>pipeline()</code>. For this, we’ll use the official <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a> checkpoint fine-tuned on
100 hours of LibriSpeech data:`,Bt,Z,Ct,N,Ia=`Next, we’ll take an example from the dataset and pass its raw data to the pipeline. Since the <code>pipeline</code> <em>consumes</em> any
dictionary that we pass it (meaning it cannot be re-used), we’ll pass a copy of the data. This way, we can safely re-use
the same audio sample in the following examples:`,xt,_,Et,Y,ka="<strong>Output:</strong>",Gt,L,Rt,Q,va=`We can see that the Wav2Vec2 model does a pretty good job at transcribing this sample - at a first glance it looks generally correct.
Let’s put the target and prediction side-by-side and highlight the differences:`,Vt,A,$t,q,Sa="Comparing the target text to the predicted transcription, we can see that all words <em>sound</em> correct, but some are not spelled accurately. For example:",Ht,X,Ba="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",Wt,z,Ca=`This highlights the shortcoming of a CTC model. A CTC model is essentially an ‘acoustic-only’ model: it consists of an encoder
which forms hidden-state representations from the audio inputs, and a linear layer which maps the hidden-states to characters:`,Ft,P,xa=`This means that the system almost entirely bases its prediction on the acoustic input it was given (the phonetic sounds of the audio),
and so has a tendency to transcribe the audio in a phonetic way (e.g. <em>CHRISTMAUS</em>). It gives less importance to the
language modelling context of previous and successive letters, and so is prone to phonetic spelling errors. A more intelligent model
would identify that <em>CHRISTMAUS</em> is not a valid word in the English vocabulary, and correct it to <em>CHRISTMAS</em> when making
its predictions. We’re also missing two big features in our prediction - casing and punctuation - which limits the usefulness of
the model’s transcriptions to real-world applications.`,Zt,O,Nt,D,Ea=`Cue Seq2Seq models! As outlined in Unit 3, Seq2Seq models are formed of an encoder and decoder linked via a cross-attention
mechanism. The encoder plays the same role as before, computing hidden-state representations of the audio inputs, while the decoder
plays the role of a <strong>language model</strong>. The decoder processes the entire sequence of hidden-state representations
from the encoder and generates the corresponding text transcriptions. With global context of the audio input, the decoder
is able to use language modelling context as it makes its predictions, correcting for spelling mistakes on-the-fly and thus
circumventing the issue of phonetic predictions.`,_t,K,Ga="There are two downsides to Seq2Seq models:",Yt,ee,Ra="<li>They are inherently slower at decoding, since the decoding process happens one step at a time, rather than all at once</li> <li>They are more data hungry, requiring significantly more training data to reach convergence</li>",Lt,te,Va=`In particular, the need for large amounts of training data has been a bottleneck in the advancement of Seq2Seq architectures for
speech. Labelled speech data is difficult to come by, with the largest annotated datasets at the time clocking in at just
10,000 hours. This all changed in 2022 upon the release of <strong>Whisper</strong>. Whisper is a pre-trained model for speech recognition
published in <a href="https://openai.com/blog/whisper/" rel="nofollow">September 2022</a> by the authors Alec Radford et al. from OpenAI. Unlike
its CTC predecessors, which were pre-trained entirely on <strong>un-labelled</strong> audio data, Whisper is pre-trained on a vast quantity of
<strong>labelled</strong> audio-transcription data, 680,000 hours to be precise.`,Qt,se,$a=`This is an order of magnitude more data than the un-labelled audio data used to train Wav2Vec 2.0 (60,000 hours). What is
more, 117,000 hours of this pre-training data is multilingual (or “non-English”) data. This results in checkpoints that can be applied to
over 96 languages, many of which are considered <em>low-resource</em>, meaning the language lacks a large corpus of data suitable for training.`,At,ae,Ha=`When scaled to 680,000 hours of labelled pre-training data, Whisper models demonstrate a strong ability to generalise to
many datasets and domains. The pre-trained checkpoints achieve competitive results to state-of-the-art pipe systems, with
near 3% word error rate (WER) on the test-clean subset of LibriSpeech pipe and a new state-of-the-art on TED-LIUM with
4.7% WER (<em>c.f.</em> Table 8 of the <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper paper</a>).`,qt,le,Wa=`Of particular importance is Whisper’s ability to handle long-form audio samples, its robustness to input noise and ability
to predict cased and punctuated transcriptions. This makes it a viable candidate for real-world speech recognition systems.`,Xt,ne,Fa=`The remainder of this section will show you how to use the pre-trained Whisper models for speech recognition using 🤗
Transformers. In many situations, the pre-trained Whisper checkpoints are extremely performant and give great results,
thus we encourage you to try using the pre-trained checkpoints as a first step to solving any speech recognition problem.
Through fine-tuning, the pre-trained checkpoints can be adapted for specific datasets and languages to further improve
upon these results. We’ll demonstrate how to do this in the upcoming subsection on <a href="fine-tuning">fine-tuning</a>.`,zt,ie,Za=`The Whisper checkpoints come in five configurations of varying model sizes. The smallest four are trained on either
English-only or multilingual data. The largest checkpoint is multilingual only. All nine of the pre-trained checkpoints
are available on the <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a>. The checkpoints are
summarised in the following table with links to the models on the Hub. “VRAM” denotes the required GPU memory to run the
model with the minimum batch size of 1. “Rel Speed” is the relative speed of a checkpoint compared to the largest model.
Based on this information, you can select a checkpoint that is best suited to your hardware.`,Pt,oe,Na='<thead><tr><th>Size</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Rel Speed</th> <th>English-only</th> <th>Multilingual</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Ot,re,_a=`Let’s load the <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, which is of comparable size to the
Wav2Vec2 checkpoint we used previously. Preempting our move to multilingual speech recognition, we’ll load the multilingual
variant of the base checkpoint. We’ll also load the model on the GPU if available, or CPU otherwise. The <code>pipeline()</code> will
subsequently take care of moving all inputs / outputs from the CPU to the GPU as required:`,Dt,pe,Kt,he,Ya=`Great! Now let’s transcribe the audio as before. The only change we make is passing an extra argument, <code>max_new_tokens</code>,
which tells the model the maximum number of tokens to generate when making its prediction:`,es,ce,ts,de,La="<strong>Output:</strong>",ss,me,as,Me,Qa=`Easy enough! The first thing you’ll notice is the presence of both casing and punctuation. Immediately this makes the
transcription easier to read compared to the un-cased and un-punctuated transcription from Wav2Vec2. Let’s put the transcription
side-by-side with the target:`,ls,ue,ns,ye,Aa=`Whisper has done a great job at correcting the phonetic errors we saw from Wav2Vec2 - both <em>Christmas</em> and <em>roast</em> are
spelled correctly. We see that the model still struggles with <em>SIMILES</em>, being incorrectly transcribed as <em>similarly</em>, but
this time the prediction is a valid word from the English vocabulary. Using a larger Whisper checkpoint can help further
reduce transcription errors, at the expense of requiring more compute and a longer transcription time.`,is,we,qa=`We’ve been promised a model that can handle 96 languages, so lets leave English speech recognition for now and go global 🌎!
The <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) dataset is
the multilingual equivalent of the LibriSpeech dataset, with labelled audio data in six languages. We’ll load one sample
from the Spanish split of the MLS dataset, making use of <em>streaming</em> mode so that we don’t have to download the entire dataset:`,os,Te,rs,Ue,Xa="Again, we’ll inspect the text transcription and take a listen to the audio segment:",ps,fe,hs,ge,za="<strong>Output:</strong>",cs,Je,ds,be,Pa=`This is the target text that we’re aiming for with our Whisper transcription. Although we now know that we can
probably do better this, since our model is also going to predict punctuation and casing, neither of which are present in the
reference. Let’s forward the audio sample to the pipeline to get our text prediction. One thing to note is that the
pipeline <em>consumes</em> the dictionary of audio inputs that we input, meaning the dictionary can’t be re-used. To circumvent
this, we’ll pass a <em>copy</em> of the audio sample, so that we can re-use the same audio sample in the proceeding code examples:`,ms,je,Ms,Ie,Oa="<strong>Output:</strong>",us,ke,ys,ve,Da=`Great - this looks very similar to our reference text (arguably better since it has punctuation and casing!). You’ll notice
that we forwarded the <code>&quot;task&quot;</code> as a <em>generate key-word argument</em> (generate kwarg). Setting the <code>&quot;task&quot;</code> to <code>&quot;transcribe&quot;</code>
forces Whisper to perform the task of <em>speech recognition</em>, where the audio is transcribed in the same language that the
speech was spoken in. Whisper is also capable of performing the closely related task of <em>speech translation</em>, where the
audio in Spanish can be translated to text in English. To achieve this, we set the <code>&quot;task&quot;</code> to <code>&quot;translate&quot;</code>:`,ws,Se,Ts,Be,Ka="<strong>Output:</strong>",Us,Ce,fs,xe,el=`Now that we know we can toggle between speech recognition and speech translation, we can pick our task depending on our
needs. Either we recognise from audio in language X to text in the same language X (e.g. Spanish audio to Spanish text),
or we translate from audio in any language X to text in English (e.g. Spanish audio to English text).`,gs,Ee,tl=`To read more about how the <code>&quot;task&quot;</code> argument is used to control the properties of the generated text, refer to the
<a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">model card</a> for the Whisper base model.`,Js,Ge,bs,Re,sl=`So far, we’ve focussed on transcribing short audio samples of less than 30 seconds. We mentioned that one of the appeals
of Whisper was its ability to work on long audio samples. We’ll tackle this task here!`,js,Ve,al=`Let’s create a long audio file by concatenating sequential samples from the MLS dataset. Since the MLS dataset is
curated by splitting long audiobook recordings into shorter segments, concatenating samples is one way of reconstructing
longer audiobook passages. Consequently, the resulting audio should be coherent across the entire sample.`,Is,$e,ll="We’ll set our target audio length to 5 minutes, and stop concatenating samples once we hit this value:",ks,He,vs,We,nl="<strong>Output:</strong>",Ss,Fe,Bs,Ze,il=`Alright! 5 minutes and 17 seconds of audio to transcribe. There are two problems with forwarding this long audio sample
directly to the model:`,Cs,Ne,ol="<li>Whisper is inherently designed to work with 30 second samples: anything shorter than 30s is padded to 30s with silence, anything longer than 30s is truncated to 30s by cutting of the extra audio, so if we pass our audio directly we’ll only get the transcription for the first 30s</li> <li>Memory in a transformer network scales with the sequence length squared: doubling the input length quadruples the memory requirement, so passing super long audio files is bound to lead to an out-of-memory (OOM) error</li>",xs,_e,rl=`The way long-form transcription works in 🤗 Transformers is by <em>chunking</em> the input audio into smaller, more manageable segments.
Each segment has a small amount of overlap with the previous one. This allows us to accurately stitch the segments back together
at the boundaries, since we can find the overlap between segments and merge the transcriptions accordingly:`,Es,f,pl='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',Gs,y,pa,Rs,jl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Vs,$s,Il='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Hs,it,hl="stateless",ha,Ws,kl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Fs,Zs,vl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Ns,ot,cl="batch",ca,g,dl="blog post",da,_s,Ye,ml=`To activate long-form transcriptions, we have to add one additional argument when we call the pipeline. This argument,
<code>chunk_length_s</code>, controls the length of the chunked segments in seconds. For Whisper, 30 second chunks are optimal,
since this matches the input length Whisper expects.`,Ys,Le,Ml=`To activate batching, we need to pass the argument <code>batch_size</code> to the pipeline. Putting it all together, we can transcribe the
long audio sample with chunking and batching as follows:`,Ls,Qe,Qs,Ae,ul="<strong>Output:</strong>",As,qe,qs,Xe,yl=`We won’t print the entire output here since it’s pretty long (312 words total)! On a 16GB V100 GPU, you can expect the above
line to take approximately 3.45 seconds to run, which is pretty good for a 317 second audio sample. On a CPU, expect
closer to 30 seconds.`,Xs,ze,wl=`Whisper is also able to predict segment-level <em>timestamps</em> for the audio data. These timestamps indicate the start and end
time for a short passage of audio, and are particularly useful for aligning a transcription with the input audio. Suppose
we want to provide closed captions for a video - we need these timestamps to know which part of the transcription corresponds
to a certain segment of video, in order to display the correct transcription for that time.`,zs,Pe,Tl=`Activating timestamp prediction is straightforward, we just need to set the argument <code>return_timestamps=True</code>. Timestamps
are compatible with both the chunking and batching methods we used previously, so we can simply append the timestamp
argument to our previous call:`,Ps,Oe,Os,De,Ul="<strong>Output:</strong>",Ds,Ke,Ks,et,fl="And voila! We have our predicted text as well as corresponding timestamps.",ea,tt,ta,st,gl=`Whisper is a strong pre-trained model for speech recognition and translation. Compared to Wav2Vec2, it has higher
transcription accuracy, with outputs that contain punctuation and casing. It can be used to transcribe speech in English
as well as 96 other languages, both on short audio segments and longer ones through <em>chunking</em>. These attributes make it
a viable model for many speech recognition and translation tasks without the need for fine-tuning. The <code>pipeline()</code> method
provides an easy way of running inference in one-line API calls with control over the generated predictions.`,sa,at,Jl=`While the Whisper model performs extremely well on many high-resource languages, it has lower transcription and translation
accuracy on low-resource languages, i.e. those with less readily available training data. There is also varying performance
across different accents and dialects of certain languages, including lower accuracy for speakers of different genders,
races, ages or other demographic criteria (<em>c.f.</em> <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper paper</a>).`,aa,lt,bl=`To boost the performance on low-resource languages, accents or dialects, we can take the pre-trained Whisper model and
train it on a small corpus of appropriately selected data, in a process called <em>fine-tuning</em>. We’ll show that with
as little as ten hours of additional data, we can improve the performance of the Whisper model by over 100% on a low-resource
language. In the next section, we’ll cover the process behind selecting a dataset for fine-tuning.`,la,nt,na,pt,ia;return j=new ct({props:{title:"Pre-trained models for automatic speech recognition",local:"pre-trained-models-for-automatic-speech-recognition",headingTag:"h1"}}),C=new ct({props:{title:"Probing CTC Models",local:"probing-ctc-models",headingTag:"h2"}}),E=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),R=new u({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),$=new u({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),W=new u({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),Z=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),_=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),L=new u({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>',wrap:!1}}),A=new u({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),O=new ct({props:{title:"Graduation to Seq2Seq",local:"graduation-to-seq2seq",headingTag:"h2"}}),pe=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),ce=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),me=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),ue=new u({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),Te=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),fe=new u({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Je=new u({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),je=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),ke=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),Se=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),Ce=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),Ge=new ct({props:{title:"Long-Form Transcription and Timestamps",local:"long-form-transcription-and-timestamps",headingTag:"h2"}}),He=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBmcm9tJTIwbWludXRlcyUyMHRvJTIwc2Vjb25kcyUyMCgqJTIwNjApJTIwdG8lMjBudW0lMjBzYW1wbGVzJTIwKColMjBzYW1wbGluZyUyMHJhdGUpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMHBpcGUuZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUwQXRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUyMCUzRCUyMHRhcmdldF9sZW5ndGhfaW5fbSUyMColMjA2MCUyMColMjBzYW1wbGluZ19yYXRlJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMG92ZXIlMjBvdXIlMjBzdHJlYW1pbmclMjBkYXRhc2V0JTJDJTIwY29uY2F0ZW5hdGluZyUyMHNhbXBsZXMlMjB1bnRpbCUyMHdlJTIwaGl0JTIwb3VyJTIwdGFyZ2V0JTBBbG9uZ19hdWRpbyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMHNhbXBsZSUyMGluJTIwZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMGxvbmdfYXVkaW8uZXh0ZW5kKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4obG9uZ19hdWRpbyklMjAlM0UlMjB0YXJnZXRfbGVuZ3RoX2luX3NhbXBsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUwQWxvbmdfYXVkaW8lMjAlM0QlMjBucC5hc2FycmF5KGxvbmdfYXVkaW8pJTBBJTBBJTIzJTIwaG93JTIwZGlkJTIwd2UlMjBkbyUzRiUwQXNlY29uZHMlMjAlM0QlMjBsZW4obG9uZ19hdWRpbyklMjAlMkYlMjAxNjAwMCUwQW1pbnV0ZXMlMkMlMjBzZWNvbmRzJTIwJTNEJTIwZGl2bW9kKHNlY29uZHMlMkMlMjA2MCklMEFwcmludChmJTIyTGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwJTdCbWludXRlcyU3RCUyMG1pbnV0ZXMlMjAlN0JzZWNvbmRzJTNBLjJmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># convert from minutes to seconds (* 60) to num samples (* sampling rate)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># iterate over our streaming dataset, concatenating samples until we hit our target</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># how did we do?</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Fe=new u({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),Qe=new u({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),qe=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),Oe=new u({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),Ke=new u({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),tt=new ct({props:{title:"Summary",local:"summary",headingTag:"h2"}}),nt=new Rl({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter5/asr_models.mdx"}}),{c(){U=i("meta"),dt=l(),rt=i("p"),mt=l(),p(j.$$.fragment),Mt=l(),I=i("p"),I.innerHTML=ua,ut=l(),k=i("p"),k.textContent=ya,yt=l(),v=i("ol"),v.innerHTML=wa,wt=l(),S=i("p"),S.innerHTML=Ta,Tt=l(),B=i("p"),B.textContent=Ua,Ut=l(),p(C.$$.fragment),ft=l(),x=i("p"),x.innerHTML=fa,gt=l(),p(E.$$.fragment),Jt=l(),G=i("p"),G.innerHTML=ga,bt=l(),p(R.$$.fragment),jt=l(),V=i("p"),V.textContent=Ja,It=l(),p($.$$.fragment),kt=l(),H=i("p"),H.innerHTML=ba,vt=l(),p(W.$$.fragment),St=l(),F=i("p"),F.innerHTML=ja,Bt=l(),p(Z.$$.fragment),Ct=l(),N=i("p"),N.innerHTML=Ia,xt=l(),p(_.$$.fragment),Et=l(),Y=i("p"),Y.innerHTML=ka,Gt=l(),p(L.$$.fragment),Rt=l(),Q=i("p"),Q.textContent=va,Vt=l(),p(A.$$.fragment),$t=l(),q=i("p"),q.innerHTML=Sa,Ht=l(),X=i("ul"),X.innerHTML=Ba,Wt=l(),z=i("p"),z.textContent=Ca,Ft=l(),P=i("p"),P.innerHTML=xa,Zt=l(),p(O.$$.fragment),Nt=l(),D=i("p"),D.innerHTML=Ea,_t=l(),K=i("p"),K.textContent=Ga,Yt=l(),ee=i("ol"),ee.innerHTML=Ra,Lt=l(),te=i("p"),te.innerHTML=Va,Qt=l(),se=i("p"),se.innerHTML=$a,At=l(),ae=i("p"),ae.innerHTML=Ha,qt=l(),le=i("p"),le.textContent=Wa,Xt=l(),ne=i("p"),ne.innerHTML=Fa,zt=l(),ie=i("p"),ie.innerHTML=Za,Pt=l(),oe=i("table"),oe.innerHTML=Na,Ot=l(),re=i("p"),re.innerHTML=_a,Dt=l(),p(pe.$$.fragment),Kt=l(),he=i("p"),he.innerHTML=Ya,es=l(),p(ce.$$.fragment),ts=l(),de=i("p"),de.innerHTML=La,ss=l(),p(me.$$.fragment),as=l(),Me=i("p"),Me.textContent=Qa,ls=l(),p(ue.$$.fragment),ns=l(),ye=i("p"),ye.innerHTML=Aa,is=l(),we=i("p"),we.innerHTML=qa,os=l(),p(Te.$$.fragment),rs=l(),Ue=i("p"),Ue.textContent=Xa,ps=l(),p(fe.$$.fragment),hs=l(),ge=i("p"),ge.innerHTML=za,cs=l(),p(Je.$$.fragment),ds=l(),be=i("p"),be.innerHTML=Pa,ms=l(),p(je.$$.fragment),Ms=l(),Ie=i("p"),Ie.innerHTML=Oa,us=l(),p(ke.$$.fragment),ys=l(),ve=i("p"),ve.innerHTML=Da,ws=l(),p(Se.$$.fragment),Ts=l(),Be=i("p"),Be.innerHTML=Ka,Us=l(),p(Ce.$$.fragment),fs=l(),xe=i("p"),xe.textContent=el,gs=l(),Ee=i("p"),Ee.innerHTML=tl,Js=l(),p(Ge.$$.fragment),bs=l(),Re=i("p"),Re.textContent=sl,js=l(),Ve=i("p"),Ve.textContent=al,Is=l(),$e=i("p"),$e.textContent=ll,ks=l(),p(He.$$.fragment),vs=l(),We=i("p"),We.innerHTML=nl,Ss=l(),p(Fe.$$.fragment),Bs=l(),Ze=i("p"),Ze.textContent=il,Cs=l(),Ne=i("ol"),Ne.innerHTML=ol,xs=l(),_e=i("p"),_e.innerHTML=rl,Es=l(),f=i("div"),f.innerHTML=pl,Gs=l(),y=i("p"),pa=J("The advantage of chunking the samples is that we don’t need the result of chunk"),Rs=new oa(!1),Vs=J(` to transcribe the subsequent
chunk`),$s=new oa(!1),Hs=J(`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),it=i("strong"),it.textContent=hl,ha=J(", so we can even do chunk"),Ws=new oa(!1),Fs=J(`
at the same time as chunk`),Zs=new oa(!1),Ns=J("! This allows us to "),ot=i("em"),ot.textContent=cl,ca=J(` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),g=i("a"),g.textContent=dl,da=J("."),_s=l(),Ye=i("p"),Ye.innerHTML=ml,Ys=l(),Le=i("p"),Le.innerHTML=Ml,Ls=l(),p(Qe.$$.fragment),Qs=l(),Ae=i("p"),Ae.innerHTML=ul,As=l(),p(qe.$$.fragment),qs=l(),Xe=i("p"),Xe.textContent=yl,Xs=l(),ze=i("p"),ze.innerHTML=wl,zs=l(),Pe=i("p"),Pe.innerHTML=Tl,Ps=l(),p(Oe.$$.fragment),Os=l(),De=i("p"),De.innerHTML=Ul,Ds=l(),p(Ke.$$.fragment),Ks=l(),et=i("p"),et.textContent=fl,ea=l(),p(tt.$$.fragment),ta=l(),st=i("p"),st.innerHTML=gl,sa=l(),at=i("p"),at.innerHTML=Jl,aa=l(),lt=i("p"),lt.innerHTML=bl,la=l(),p(nt.$$.fragment),na=l(),pt=i("p"),this.h()},l(e){const t=Gl("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(s),dt=n(e),rt=o(e,"P",{}),ma(rt).forEach(s),mt=n(e),h(j.$$.fragment,e),Mt=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-qu6ugv"&&(I.innerHTML=ua),ut=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1lo7cg7"&&(k.textContent=ya),yt=n(e),v=o(e,"OL",{"data-svelte-h":!0}),r(v)!=="svelte-4r9go5"&&(v.innerHTML=wa),wt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-7bh989"&&(S.innerHTML=Ta),Tt=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1y7wlps"&&(B.textContent=Ua),Ut=n(e),h(C.$$.fragment,e),ft=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-6p3rx4"&&(x.innerHTML=fa),gt=n(e),h(E.$$.fragment,e),Jt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1mvdyro"&&(G.innerHTML=ga),bt=n(e),h(R.$$.fragment,e),jt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1f14qa5"&&(V.textContent=Ja),It=n(e),h($.$$.fragment,e),kt=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1mvdyro"&&(H.innerHTML=ba),vt=n(e),h(W.$$.fragment,e),St=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-zwb92k"&&(F.innerHTML=ja),Bt=n(e),h(Z.$$.fragment,e),Ct=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-160y70r"&&(N.innerHTML=Ia),xt=n(e),h(_.$$.fragment,e),Et=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=ka),Gt=n(e),h(L.$$.fragment,e),Rt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1n1tyml"&&(Q.textContent=va),Vt=n(e),h(A.$$.fragment,e),$t=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-fjdtrw"&&(q.innerHTML=Sa),Ht=n(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-11mc7qy"&&(X.innerHTML=Ba),Wt=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-18hr596"&&(z.textContent=Ca),Ft=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-mwf7be"&&(P.innerHTML=xa),Zt=n(e),h(O.$$.fragment,e),Nt=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-55oy83"&&(D.innerHTML=Ea),_t=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-969zyv"&&(K.textContent=Ga),Yt=n(e),ee=o(e,"OL",{"data-svelte-h":!0}),r(ee)!=="svelte-osi73t"&&(ee.innerHTML=Ra),Lt=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1bn96on"&&(te.innerHTML=Va),Qt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-zyrdbw"&&(se.innerHTML=$a),At=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-em8jox"&&(ae.innerHTML=Ha),qt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1g5392c"&&(le.textContent=Wa),Xt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-5h4os6"&&(ne.innerHTML=Fa),zt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-uy2cuy"&&(ie.innerHTML=Za),Pt=n(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),r(oe)!=="svelte-leifmh"&&(oe.innerHTML=Na),Ot=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-efpzbz"&&(re.innerHTML=_a),Dt=n(e),h(pe.$$.fragment,e),Kt=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1feq0tt"&&(he.innerHTML=Ya),es=n(e),h(ce.$$.fragment,e),ts=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1mvdyro"&&(de.innerHTML=La),ss=n(e),h(me.$$.fragment,e),as=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-18db65j"&&(Me.textContent=Qa),ls=n(e),h(ue.$$.fragment,e),ns=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-mm1pes"&&(ye.innerHTML=Aa),is=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1ol57p5"&&(we.innerHTML=qa),os=n(e),h(Te.$$.fragment,e),rs=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1f9nh4o"&&(Ue.textContent=Xa),ps=n(e),h(fe.$$.fragment,e),hs=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1mvdyro"&&(ge.innerHTML=za),cs=n(e),h(Je.$$.fragment,e),ds=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-75q7fw"&&(be.innerHTML=Pa),ms=n(e),h(je.$$.fragment,e),Ms=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1mvdyro"&&(Ie.innerHTML=Oa),us=n(e),h(ke.$$.fragment,e),ys=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-uzlabu"&&(ve.innerHTML=Da),ws=n(e),h(Se.$$.fragment,e),Ts=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1mvdyro"&&(Be.innerHTML=Ka),Us=n(e),h(Ce.$$.fragment,e),fs=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-joibr"&&(xe.textContent=el),gs=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1aecqb1"&&(Ee.innerHTML=tl),Js=n(e),h(Ge.$$.fragment,e),bs=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-ad6ien"&&(Re.textContent=sl),js=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1atykwj"&&(Ve.textContent=al),Is=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-8fkb86"&&($e.textContent=ll),ks=n(e),h(He.$$.fragment,e),vs=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1mvdyro"&&(We.innerHTML=nl),Ss=n(e),h(Fe.$$.fragment,e),Bs=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-rlobar"&&(Ze.textContent=il),Cs=n(e),Ne=o(e,"OL",{"data-svelte-h":!0}),r(Ne)!=="svelte-xow7at"&&(Ne.innerHTML=ol),xs=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1kl6cah"&&(_e.innerHTML=rl),Es=n(e),f=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-dbmn5s"&&(f.innerHTML=pl),Gs=n(e),y=o(e,"P",{});var w=ma(y);pa=b(w,"The advantage of chunking the samples is that we don’t need the result of chunk"),Rs=ra(w,!1),Vs=b(w,` to transcribe the subsequent
chunk`),$s=ra(w,!1),Hs=b(w,`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),it=o(w,"STRONG",{"data-svelte-h":!0}),r(it)!=="svelte-1caf2ri"&&(it.textContent=hl),ha=b(w,", so we can even do chunk"),Ws=ra(w,!1),Fs=b(w,`
at the same time as chunk`),Zs=ra(w,!1),Ns=b(w,"! This allows us to "),ot=o(w,"EM",{"data-svelte-h":!0}),r(ot)!=="svelte-1swb9sm"&&(ot.textContent=cl),ca=b(w,` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),g=o(w,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(g)!=="svelte-1d46t8h"&&(g.textContent=dl),da=b(w,"."),w.forEach(s),_s=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1bfrg8c"&&(Ye.innerHTML=ml),Ys=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ldveni"&&(Le.innerHTML=Ml),Ls=n(e),h(Qe.$$.fragment,e),Qs=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1mvdyro"&&(Ae.innerHTML=ul),As=n(e),h(qe.$$.fragment,e),qs=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-wy7qyj"&&(Xe.textContent=yl),Xs=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1pdqzp1"&&(ze.innerHTML=wl),zs=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1kodbk1"&&(Pe.innerHTML=Tl),Ps=n(e),h(Oe.$$.fragment,e),Os=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1mvdyro"&&(De.innerHTML=Ul),Ds=n(e),h(Ke.$$.fragment,e),Ks=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-7n3xc4"&&(et.textContent=fl),ea=n(e),h(tt.$$.fragment,e),ta=n(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1t35nks"&&(st.innerHTML=gl),sa=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1eiih7q"&&(at.innerHTML=Jl),aa=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-a24nm6"&&(lt.innerHTML=bl),la=n(e),h(nt.$$.fragment,e),na=n(e),pt=o(e,"P",{}),ma(pt).forEach(s),this.h()},h(){ht(U,"name","hf:doc:metadata"),ht(U,"content",$l),ht(f,"class","flex justify-center"),Rs.a=Vs,$s.a=Hs,Ws.a=Fs,Zs.a=Ns,ht(g,"href","https://huggingface.co/blog/asr-chunking"),ht(g,"rel","nofollow")},m(e,t){T(document.head,U),a(e,dt,t),a(e,rt,t),a(e,mt,t),c(j,e,t),a(e,Mt,t),a(e,I,t),a(e,ut,t),a(e,k,t),a(e,yt,t),a(e,v,t),a(e,wt,t),a(e,S,t),a(e,Tt,t),a(e,B,t),a(e,Ut,t),c(C,e,t),a(e,ft,t),a(e,x,t),a(e,gt,t),c(E,e,t),a(e,Jt,t),a(e,G,t),a(e,bt,t),c(R,e,t),a(e,jt,t),a(e,V,t),a(e,It,t),c($,e,t),a(e,kt,t),a(e,H,t),a(e,vt,t),c(W,e,t),a(e,St,t),a(e,F,t),a(e,Bt,t),c(Z,e,t),a(e,Ct,t),a(e,N,t),a(e,xt,t),c(_,e,t),a(e,Et,t),a(e,Y,t),a(e,Gt,t),c(L,e,t),a(e,Rt,t),a(e,Q,t),a(e,Vt,t),c(A,e,t),a(e,$t,t),a(e,q,t),a(e,Ht,t),a(e,X,t),a(e,Wt,t),a(e,z,t),a(e,Ft,t),a(e,P,t),a(e,Zt,t),c(O,e,t),a(e,Nt,t),a(e,D,t),a(e,_t,t),a(e,K,t),a(e,Yt,t),a(e,ee,t),a(e,Lt,t),a(e,te,t),a(e,Qt,t),a(e,se,t),a(e,At,t),a(e,ae,t),a(e,qt,t),a(e,le,t),a(e,Xt,t),a(e,ne,t),a(e,zt,t),a(e,ie,t),a(e,Pt,t),a(e,oe,t),a(e,Ot,t),a(e,re,t),a(e,Dt,t),c(pe,e,t),a(e,Kt,t),a(e,he,t),a(e,es,t),c(ce,e,t),a(e,ts,t),a(e,de,t),a(e,ss,t),c(me,e,t),a(e,as,t),a(e,Me,t),a(e,ls,t),c(ue,e,t),a(e,ns,t),a(e,ye,t),a(e,is,t),a(e,we,t),a(e,os,t),c(Te,e,t),a(e,rs,t),a(e,Ue,t),a(e,ps,t),c(fe,e,t),a(e,hs,t),a(e,ge,t),a(e,cs,t),c(Je,e,t),a(e,ds,t),a(e,be,t),a(e,ms,t),c(je,e,t),a(e,Ms,t),a(e,Ie,t),a(e,us,t),c(ke,e,t),a(e,ys,t),a(e,ve,t),a(e,ws,t),c(Se,e,t),a(e,Ts,t),a(e,Be,t),a(e,Us,t),c(Ce,e,t),a(e,fs,t),a(e,xe,t),a(e,gs,t),a(e,Ee,t),a(e,Js,t),c(Ge,e,t),a(e,bs,t),a(e,Re,t),a(e,js,t),a(e,Ve,t),a(e,Is,t),a(e,$e,t),a(e,ks,t),c(He,e,t),a(e,vs,t),a(e,We,t),a(e,Ss,t),c(Fe,e,t),a(e,Bs,t),a(e,Ze,t),a(e,Cs,t),a(e,Ne,t),a(e,xs,t),a(e,_e,t),a(e,Es,t),a(e,f,t),a(e,Gs,t),a(e,y,t),T(y,pa),Rs.m(jl,y),T(y,Vs),$s.m(Il,y),T(y,Hs),T(y,it),T(y,ha),Ws.m(kl,y),T(y,Fs),Zs.m(vl,y),T(y,Ns),T(y,ot),T(y,ca),T(y,g),T(y,da),a(e,_s,t),a(e,Ye,t),a(e,Ys,t),a(e,Le,t),a(e,Ls,t),c(Qe,e,t),a(e,Qs,t),a(e,Ae,t),a(e,As,t),c(qe,e,t),a(e,qs,t),a(e,Xe,t),a(e,Xs,t),a(e,ze,t),a(e,zs,t),a(e,Pe,t),a(e,Ps,t),c(Oe,e,t),a(e,Os,t),a(e,De,t),a(e,Ds,t),c(Ke,e,t),a(e,Ks,t),a(e,et,t),a(e,ea,t),c(tt,e,t),a(e,ta,t),a(e,st,t),a(e,sa,t),a(e,at,t),a(e,aa,t),a(e,lt,t),a(e,la,t),c(nt,e,t),a(e,na,t),a(e,pt,t),ia=!0},p:Bl,i(e){ia||(d(j.$$.fragment,e),d(C.$$.fragment,e),d(E.$$.fragment,e),d(R.$$.fragment,e),d($.$$.fragment,e),d(W.$$.fragment,e),d(Z.$$.fragment,e),d(_.$$.fragment,e),d(L.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d(ke.$$.fragment,e),d(Se.$$.fragment,e),d(Ce.$$.fragment,e),d(Ge.$$.fragment,e),d(He.$$.fragment,e),d(Fe.$$.fragment,e),d(Qe.$$.fragment,e),d(qe.$$.fragment,e),d(Oe.$$.fragment,e),d(Ke.$$.fragment,e),d(tt.$$.fragment,e),d(nt.$$.fragment,e),ia=!0)},o(e){m(j.$$.fragment,e),m(C.$$.fragment,e),m(E.$$.fragment,e),m(R.$$.fragment,e),m($.$$.fragment,e),m(W.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(L.$$.fragment,e),m(A.$$.fragment,e),m(O.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(Je.$$.fragment,e),m(je.$$.fragment,e),m(ke.$$.fragment,e),m(Se.$$.fragment,e),m(Ce.$$.fragment,e),m(Ge.$$.fragment,e),m(He.$$.fragment,e),m(Fe.$$.fragment,e),m(Qe.$$.fragment,e),m(qe.$$.fragment,e),m(Oe.$$.fragment,e),m(Ke.$$.fragment,e),m(tt.$$.fragment,e),m(nt.$$.fragment,e),ia=!1},d(e){e&&(s(dt),s(rt),s(mt),s(Mt),s(I),s(ut),s(k),s(yt),s(v),s(wt),s(S),s(Tt),s(B),s(Ut),s(ft),s(x),s(gt),s(Jt),s(G),s(bt),s(jt),s(V),s(It),s(kt),s(H),s(vt),s(St),s(F),s(Bt),s(Ct),s(N),s(xt),s(Et),s(Y),s(Gt),s(Rt),s(Q),s(Vt),s($t),s(q),s(Ht),s(X),s(Wt),s(z),s(Ft),s(P),s(Zt),s(Nt),s(D),s(_t),s(K),s(Yt),s(ee),s(Lt),s(te),s(Qt),s(se),s(At),s(ae),s(qt),s(le),s(Xt),s(ne),s(zt),s(ie),s(Pt),s(oe),s(Ot),s(re),s(Dt),s(Kt),s(he),s(es),s(ts),s(de),s(ss),s(as),s(Me),s(ls),s(ns),s(ye),s(is),s(we),s(os),s(rs),s(Ue),s(ps),s(hs),s(ge),s(cs),s(ds),s(be),s(ms),s(Ms),s(Ie),s(us),s(ys),s(ve),s(ws),s(Ts),s(Be),s(Us),s(fs),s(xe),s(gs),s(Ee),s(Js),s(bs),s(Re),s(js),s(Ve),s(Is),s($e),s(ks),s(vs),s(We),s(Ss),s(Bs),s(Ze),s(Cs),s(Ne),s(xs),s(_e),s(Es),s(f),s(Gs),s(y),s(_s),s(Ye),s(Ys),s(Le),s(Ls),s(Qs),s(Ae),s(As),s(qs),s(Xe),s(Xs),s(ze),s(zs),s(Pe),s(Ps),s(Os),s(De),s(Ds),s(Ks),s(et),s(ea),s(ta),s(st),s(sa),s(at),s(aa),s(lt),s(la),s(na),s(pt)),s(U),M(j,e),M(C,e),M(E,e),M(R,e),M($,e),M(W,e),M(Z,e),M(_,e),M(L,e),M(A,e),M(O,e),M(pe,e),M(ce,e),M(me,e),M(ue,e),M(Te,e),M(fe,e),M(Je,e),M(je,e),M(ke,e),M(Se,e),M(Ce,e),M(Ge,e),M(He,e),M(Fe,e),M(Qe,e),M(qe,e),M(Oe,e),M(Ke,e),M(tt,e),M(nt,e)}}}const $l='{"title":"Pre-trained models for automatic speech recognition","local":"pre-trained-models-for-automatic-speech-recognition","sections":[{"title":"Probing CTC Models","local":"probing-ctc-models","sections":[],"depth":2},{"title":"Graduation to Seq2Seq","local":"graduation-to-seq2seq","sections":[],"depth":2},{"title":"Long-Form Transcription and Timestamps","local":"long-form-transcription-and-timestamps","sections":[],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function Hl(Ma){return Cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends xl{constructor(U){super(),El(this,U,Hl,Vl,Sl,{})}}export{_l as component};
