import{s as st,n as at,o as nt}from"../chunks/scheduler.f7e1785c.js";import{S as Mt,i as it,g as M,s as a,r as p,A as ot,h as i,f as e,c as n,j as et,u,x as o,k as El,y as pt,a as s,v as y,d,t as r,w as c}from"../chunks/index.9f8f0838.js";import{C as j}from"../chunks/CodeBlock.4baef5d7.js";import{H as ut,E as yt}from"../chunks/getInferenceSnippets.00780c44.js";function dt(ql){let m,O,D,K,U,ll,w,Wl=`In this course we will use the 🤗 Datasets library to work with audio datasets. 🤗 Datasets is an open-source library for
downloading and preparing datasets from all modalities including audio. The library offers easy access to an unparalleled
selection of machine learning datasets publicly available on Hugging Face Hub. Moreover, 🤗 Datasets includes multiple
features tailored to audio datasets that simplify working with such datasets for both researchers and practitioners.`,tl,J,Bl="To begin working with audio datasets, make sure you have the 🤗 Datasets library installed:",el,f,sl,T,_l=`One of the key defining features of 🤗 Datasets is the ability to download and prepare a dataset in just one line of
Python code using the <code>load_dataset()</code> function.`,al,b,Ql=`Let’s load and explore and audio dataset called <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, which contains
recordings of people asking an e-banking system questions in several languages and dialects.`,nl,A,Rl=`To load the MINDS-14 dataset, we need to copy the dataset’s identifier on the Hub (<code>PolyAI/minds14</code>) and pass it
to the <code>load_dataset</code> function. We’ll also specify that we’re only interested in the Australian subset (<code>en-AU</code>) of
the data, and limit it to the training split:`,Ml,C,il,I,Fl="<strong>Output:</strong>",ol,g,pl,k,Yl=`The dataset contains 654 audio files, each of which is accompanied by a transcription, an English translation, and a label
indicating the intent behind the person’s query. The audio column contains the raw audio data. Let’s take a closer look
at one of the examples:`,ul,$,yl,v,Hl="<strong>Output:</strong>",dl,G,rl,x,zl="You may notice that the audio column contains several features. Here’s what they are:",cl,Z,Nl="<li><code>path</code>: the path to the audio file (<code>*.wav</code> in this case).</li> <li><code>array</code>: The decoded audio data, represented as a 1-dimensional NumPy array.</li> <li><code>sampling_rate</code>. The sampling rate of the audio file (8,000 Hz in this example).</li>",jl,E,Sl=`The <code>intent_class</code> is a classification category of the audio recording. To convert this number into a meaningful string,
we can use the <code>int2str()</code> method:`,ml,q,hl,W,Xl="<strong>Output:</strong>",Ul,B,wl,_,Ll=`If you look at the transcription feature, you can see that the audio file indeed has recorded a person asking a question
about paying a bill.`,Jl,Q,Vl=`If you plan to train an audio classifier on this subset of data, you may not necessarily need all of the features. For example,
the <code>lang_id</code> is going to have the same value for all examples, and won’t be useful. The <code>english_transcription</code> will likely
duplicate the <code>transcription</code> in this subset, so we can safely remove them.`,fl,R,Dl="You can easily remove irrelevant features using 🤗 Datasets’ <code>remove_columns</code> method:",Tl,F,bl,Y,Pl="<strong>Output:</strong>",Al,H,Cl,z,Ol=`Now that we’ve loaded and inspected the raw contents of the dataset, let’s listen to a few examples! We’ll use the <code>Blocks</code>
and <code>Audio</code> features from <code>Gradio</code> to decode a few random samples from the dataset:`,Il,N,gl,S,Kl="If you’d like to, you can also visualize some of the examples. Let’s plot the waveform for the first example.",kl,X,$l,h,lt='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',vl,L,tt=`Try it out! Download another dialect or language of the MINDS-14 dataset, listen and visualize some examples to get a sense
of the variation in the whole dataset. You can find the full list of available languages <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">here</a>.`,Gl,V,xl,P,Zl;return U=new ut({props:{title:"Load and explore an audio dataset",local:"load-and-explore-an-audio-dataset",headingTag:"h1"}}),f=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),C=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),g=new j({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),$=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),G=new j({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),q=new j({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),B=new j({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),F=new j({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),H=new j({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),N=new j({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new j({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),V=new yt({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter1/load_and_explore.mdx"}}),{c(){m=M("meta"),O=a(),D=M("p"),K=a(),p(U.$$.fragment),ll=a(),w=M("p"),w.textContent=Wl,tl=a(),J=M("p"),J.textContent=Bl,el=a(),p(f.$$.fragment),sl=a(),T=M("p"),T.innerHTML=_l,al=a(),b=M("p"),b.innerHTML=Ql,nl=a(),A=M("p"),A.innerHTML=Rl,Ml=a(),p(C.$$.fragment),il=a(),I=M("p"),I.innerHTML=Fl,ol=a(),p(g.$$.fragment),pl=a(),k=M("p"),k.textContent=Yl,ul=a(),p($.$$.fragment),yl=a(),v=M("p"),v.innerHTML=Hl,dl=a(),p(G.$$.fragment),rl=a(),x=M("p"),x.textContent=zl,cl=a(),Z=M("ul"),Z.innerHTML=Nl,jl=a(),E=M("p"),E.innerHTML=Sl,ml=a(),p(q.$$.fragment),hl=a(),W=M("p"),W.innerHTML=Xl,Ul=a(),p(B.$$.fragment),wl=a(),_=M("p"),_.textContent=Ll,Jl=a(),Q=M("p"),Q.innerHTML=Vl,fl=a(),R=M("p"),R.innerHTML=Dl,Tl=a(),p(F.$$.fragment),bl=a(),Y=M("p"),Y.innerHTML=Pl,Al=a(),p(H.$$.fragment),Cl=a(),z=M("p"),z.innerHTML=Ol,Il=a(),p(N.$$.fragment),gl=a(),S=M("p"),S.textContent=Kl,kl=a(),p(X.$$.fragment),$l=a(),h=M("div"),h.innerHTML=lt,vl=a(),L=M("p"),L.innerHTML=tt,Gl=a(),p(V.$$.fragment),xl=a(),P=M("p"),this.h()},l(l){const t=ot("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(e),O=n(l),D=i(l,"P",{}),et(D).forEach(e),K=n(l),u(U.$$.fragment,l),ll=n(l),w=i(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-14tdruz"&&(w.textContent=Wl),tl=n(l),J=i(l,"P",{"data-svelte-h":!0}),o(J)!=="svelte-16weaia"&&(J.textContent=Bl),el=n(l),u(f.$$.fragment,l),sl=n(l),T=i(l,"P",{"data-svelte-h":!0}),o(T)!=="svelte-vy8pv5"&&(T.innerHTML=_l),al=n(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1ibmxou"&&(b.innerHTML=Ql),nl=n(l),A=i(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-11xjat8"&&(A.innerHTML=Rl),Ml=n(l),u(C.$$.fragment,l),il=n(l),I=i(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1mvdyro"&&(I.innerHTML=Fl),ol=n(l),u(g.$$.fragment,l),pl=n(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-7t6f49"&&(k.textContent=Yl),ul=n(l),u($.$$.fragment,l),yl=n(l),v=i(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1mvdyro"&&(v.innerHTML=Hl),dl=n(l),u(G.$$.fragment,l),rl=n(l),x=i(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1xpct0w"&&(x.textContent=zl),cl=n(l),Z=i(l,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-n6enht"&&(Z.innerHTML=Nl),jl=n(l),E=i(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1wz2ihr"&&(E.innerHTML=Sl),ml=n(l),u(q.$$.fragment,l),hl=n(l),W=i(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1mvdyro"&&(W.innerHTML=Xl),Ul=n(l),u(B.$$.fragment,l),wl=n(l),_=i(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1a1ybip"&&(_.textContent=Ll),Jl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-11cpnca"&&(Q.innerHTML=Vl),fl=n(l),R=i(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-gmqz2q"&&(R.innerHTML=Dl),Tl=n(l),u(F.$$.fragment,l),bl=n(l),Y=i(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=Pl),Al=n(l),u(H.$$.fragment,l),Cl=n(l),z=i(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1iz3f0u"&&(z.innerHTML=Ol),Il=n(l),u(N.$$.fragment,l),gl=n(l),S=i(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-14zloga"&&(S.textContent=Kl),kl=n(l),u(X.$$.fragment,l),$l=n(l),h=i(l,"DIV",{class:!0,"data-svelte-h":!0}),o(h)!=="svelte-1ym6zda"&&(h.innerHTML=lt),vl=n(l),L=i(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1frcml4"&&(L.innerHTML=tt),Gl=n(l),u(V.$$.fragment,l),xl=n(l),P=i(l,"P",{}),et(P).forEach(e),this.h()},h(){El(m,"name","hf:doc:metadata"),El(m,"content",rt),El(h,"class","flex justify-center")},m(l,t){pt(document.head,m),s(l,O,t),s(l,D,t),s(l,K,t),y(U,l,t),s(l,ll,t),s(l,w,t),s(l,tl,t),s(l,J,t),s(l,el,t),y(f,l,t),s(l,sl,t),s(l,T,t),s(l,al,t),s(l,b,t),s(l,nl,t),s(l,A,t),s(l,Ml,t),y(C,l,t),s(l,il,t),s(l,I,t),s(l,ol,t),y(g,l,t),s(l,pl,t),s(l,k,t),s(l,ul,t),y($,l,t),s(l,yl,t),s(l,v,t),s(l,dl,t),y(G,l,t),s(l,rl,t),s(l,x,t),s(l,cl,t),s(l,Z,t),s(l,jl,t),s(l,E,t),s(l,ml,t),y(q,l,t),s(l,hl,t),s(l,W,t),s(l,Ul,t),y(B,l,t),s(l,wl,t),s(l,_,t),s(l,Jl,t),s(l,Q,t),s(l,fl,t),s(l,R,t),s(l,Tl,t),y(F,l,t),s(l,bl,t),s(l,Y,t),s(l,Al,t),y(H,l,t),s(l,Cl,t),s(l,z,t),s(l,Il,t),y(N,l,t),s(l,gl,t),s(l,S,t),s(l,kl,t),y(X,l,t),s(l,$l,t),s(l,h,t),s(l,vl,t),s(l,L,t),s(l,Gl,t),y(V,l,t),s(l,xl,t),s(l,P,t),Zl=!0},p:at,i(l){Zl||(d(U.$$.fragment,l),d(f.$$.fragment,l),d(C.$$.fragment,l),d(g.$$.fragment,l),d($.$$.fragment,l),d(G.$$.fragment,l),d(q.$$.fragment,l),d(B.$$.fragment,l),d(F.$$.fragment,l),d(H.$$.fragment,l),d(N.$$.fragment,l),d(X.$$.fragment,l),d(V.$$.fragment,l),Zl=!0)},o(l){r(U.$$.fragment,l),r(f.$$.fragment,l),r(C.$$.fragment,l),r(g.$$.fragment,l),r($.$$.fragment,l),r(G.$$.fragment,l),r(q.$$.fragment,l),r(B.$$.fragment,l),r(F.$$.fragment,l),r(H.$$.fragment,l),r(N.$$.fragment,l),r(X.$$.fragment,l),r(V.$$.fragment,l),Zl=!1},d(l){l&&(e(O),e(D),e(K),e(ll),e(w),e(tl),e(J),e(el),e(sl),e(T),e(al),e(b),e(nl),e(A),e(Ml),e(il),e(I),e(ol),e(pl),e(k),e(ul),e(yl),e(v),e(dl),e(rl),e(x),e(cl),e(Z),e(jl),e(E),e(ml),e(hl),e(W),e(Ul),e(wl),e(_),e(Jl),e(Q),e(fl),e(R),e(Tl),e(bl),e(Y),e(Al),e(Cl),e(z),e(Il),e(gl),e(S),e(kl),e($l),e(h),e(vl),e(L),e(Gl),e(xl),e(P)),e(m),c(U,l),c(f,l),c(C,l),c(g,l),c($,l),c(G,l),c(q,l),c(B,l),c(F,l),c(H,l),c(N,l),c(X,l),c(V,l)}}}const rt='{"title":"Load and explore an audio dataset","local":"load-and-explore-an-audio-dataset","sections":[],"depth":1}';function ct(ql){return nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends Mt{constructor(m){super(),it(this,m,ct,dt,st,{})}}export{wt as component};
