import{s as Da,o as Ta,n as Y}from"../chunks/scheduler.8c3d61f6.js";import{S as Sa,i as ka,g as a,s as o,r as _,A as Aa,h as n,f as d,c as r,j as $,u as m,x as p,k as M,y as t,a as b,v as u,d as h,t as g,w as x}from"../chunks/index.da70eac4.js";import{T as Ft}from"../chunks/Tip.1d9b8c37.js";import{D as y}from"../chunks/Docstring.6b390b9a.js";import{C as Nr}from"../chunks/CodeBlock.00a903b3.js";import{E as Er}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as Yt,E as Ca}from"../chunks/EditOnGithub.1e64e623.js";function Ra(S){let s,L='To learn more about how to load LoRA weights, see the <a href="../../using-diffusers/loading_adapters#lora">LoRA</a> loading guide.';return{c(){s=a("p"),s.innerHTML=L},l(f){s=n(f,"P",{"data-svelte-h":!0}),p(s)!=="svelte-1fw6lx1"&&(s.innerHTML=L)},m(f,l){b(f,s,l)},p:Y,d(f){f&&d(s)}}}function Pa(S){let s,L="We support loading A1111 formatted LoRA checkpoints in a limited capacity.",f,l,v="This function is experimental and might change in the future.";return{c(){s=a("p"),s.textContent=L,f=o(),l=a("p"),l.textContent=v},l(i){s=n(i,"P",{"data-svelte-h":!0}),p(s)!=="svelte-15l1sdn"&&(s.textContent=L),f=r(i),l=n(i,"P",{"data-svelte-h":!0}),p(l)!=="svelte-3fufvn"&&(l.textContent=v)},m(i,w){b(i,s,w),b(i,f,w),b(i,l,w)},p:Y,d(i){i&&(d(s),d(f),d(l))}}}function Ia(S){let s,L="We support loading A1111 formatted LoRA checkpoints in a limited capacity.",f,l,v="This function is experimental and might change in the future.";return{c(){s=a("p"),s.textContent=L,f=o(),l=a("p"),l.textContent=v},l(i){s=n(i,"P",{"data-svelte-h":!0}),p(s)!=="svelte-15l1sdn"&&(s.textContent=L),f=r(i),l=n(i,"P",{"data-svelte-h":!0}),p(l)!=="svelte-3fufvn"&&(l.textContent=v)},m(i,w){b(i,s,w),b(i,f,w),b(i,l,w)},p:Y,d(i){i&&(d(s),d(f),d(l))}}}function Ha(S){let s,L="We support loading A1111 formatted LoRA checkpoints in a limited capacity.",f,l,v="This function is experimental and might change in the future.";return{c(){s=a("p"),s.textContent=L,f=o(),l=a("p"),l.textContent=v},l(i){s=n(i,"P",{"data-svelte-h":!0}),p(s)!=="svelte-15l1sdn"&&(s.textContent=L),f=r(i),l=n(i,"P",{"data-svelte-h":!0}),p(l)!=="svelte-3fufvn"&&(l.textContent=v)},m(i,w){b(i,s,w),b(i,f,w),b(i,l,w)},p:Y,d(i){i&&(d(s),d(f),d(l))}}}function Ua(S){let s,L="This is an experimental API.";return{c(){s=a("p"),s.textContent=L},l(f){s=n(f,"P",{"data-svelte-h":!0}),p(s)!=="svelte-8w79b9"&&(s.textContent=L)},m(f,l){b(f,s,l)},p:Y,d(f){f&&d(s)}}}function Ea(S){let s,L="Example:",f,l,v;return l=new Nr({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTIybmVyaWpzJTJGcGl4ZWwtYXJ0LXhsJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJwaXhlbC1hcnQteGwuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJwaXhlbCUyMiklMEFwaXBlbGluZS5mdXNlX2xvcmEobG9yYV9zY2FsZSUzRDAuNyk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;nerijs/pixel-art-xl&quot;</span>, weight_name=<span class="hljs-string">&quot;pixel-art-xl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipeline.fuse_lora(lora_scale=<span class="hljs-number">0.7</span>)`,wrap:!1}}),{c(){s=a("p"),s.textContent=L,f=o(),_(l.$$.fragment)},l(i){s=n(i,"P",{"data-svelte-h":!0}),p(s)!=="svelte-11lpom8"&&(s.textContent=L),f=r(i),m(l.$$.fragment,i)},m(i,w){b(i,s,w),b(i,f,w),u(l,i,w),v=!0},p:Y,i(i){v||(h(l.$$.fragment,i),v=!0)},o(i){g(l.$$.fragment,i),v=!1},d(i){i&&(d(s),d(f)),x(l,i)}}}function Na(S){let s,L="Example:",f,l,v;return l=new Nr({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKCUyMkNpcm9OMjAyMiUyRnRveS1mYWNlJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJ0b3lfZmFjZV9zZHhsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIydG95JTIyKSUwQXBpcGVsaW5lLmdldF9hY3RpdmVfYWRhcHRlcnMoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;CiroN2022/toy-face&quot;</span>, weight_name=<span class="hljs-string">&quot;toy_face_sdxl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;toy&quot;</span>)
pipeline.get_active_adapters()`,wrap:!1}}),{c(){s=a("p"),s.textContent=L,f=o(),_(l.$$.fragment)},l(i){s=n(i,"P",{"data-svelte-h":!0}),p(s)!=="svelte-11lpom8"&&(s.textContent=L),f=r(i),m(l.$$.fragment,i)},m(i,w){b(i,s,w),b(i,f,w),u(l,i,w),v=!0},p:Y,i(i){v||(h(l.$$.fragment,i),v=!0)},o(i){g(l.$$.fragment,i),v=!1},d(i){i&&(d(s),d(f)),x(l,i)}}}function Xa(S){let s,L="This is an experimental API.";return{c(){s=a("p"),s.textContent=L},l(f){s=n(f,"P",{"data-svelte-h":!0}),p(s)!=="svelte-8w79b9"&&(s.textContent=L)},m(f,l){b(f,s,l)},p:Y,d(f){f&&d(s)}}}function Wa(S){let s,L="Examples:",f,l,v;return l=new Nr({props:{code:"JTIzJTIwQXNzdW1pbmclMjAlNjBwaXBlbGluZSU2MCUyMGlzJTIwYWxyZWFkeSUyMGxvYWRlZCUyMHdpdGglMjB0aGUlMjBMb1JBJTIwcGFyYW1ldGVycy4lMEFwaXBlbGluZS51bmxvYWRfbG9yYV93ZWlnaHRzKCklMEEuLi4=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming `pipeline` is already loaded with the LoRA parameters.</span>\n<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.unload_lora_weights()\n<span class="hljs-meta">&gt;&gt;&gt; </span>...',wrap:!1}}),{c(){s=a("p"),s.textContent=L,f=o(),_(l.$$.fragment)},l(i){s=n(i,"P",{"data-svelte-h":!0}),p(s)!=="svelte-kvfsh7"&&(s.textContent=L),f=r(i),m(l.$$.fragment,i)},m(i,w){b(i,s,w),b(i,f,w),u(l,i,w),v=!0},p:Y,i(i){v||(h(l.$$.fragment,i),v=!0)},o(i){g(l.$$.fragment,i),v=!1},d(i){i&&(d(s),d(f)),x(l,i)}}}function Ba(S){let s,L,f,l,v,i,w,Xr='LoRA is a fast and lightweight training method that inserts and trains a significantly smaller number of parameters instead of all the model parameters. This produces a smaller file (~100 MBs) and makes it easier to quickly train a model to learn a new concept. LoRA weights are typically loaded into the denoiser, text encoder or both. The denoiser usually corresponds to a UNet (<a href="/docs/diffusers/pr_10005/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>, for example) or a Transformer (<a href="/docs/diffusers/pr_10005/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>, for example). There are several classes for loading LoRA weights:',Kt,be,Wr='<li><code>StableDiffusionLoraLoaderMixin</code> provides functions for loading and unloading, fusing and unfusing, enabling and disabling, and more functions for managing LoRA weights. This class can be used with any model.</li> <li><code>StableDiffusionXLLoraLoaderMixin</code> is a <a href="../../api/pipelines/stable_diffusion/stable_diffusion_xl">Stable Diffusion (SDXL)</a> version of the <code>StableDiffusionLoraLoaderMixin</code> class for loading and saving LoRA weights. It can only be used with the SDXL model.</li> <li><code>SD3LoraLoaderMixin</code> provides similar functions for <a href="https://huggingface.co/blog/sd3" rel="nofollow">Stable Diffusion 3</a>.</li> <li><code>AmusedLoraLoaderMixin</code> is for the <a href="/docs/diffusers/pr_10005/en/api/pipelines/amused#diffusers.AmusedPipeline">AmusedPipeline</a>.</li> <li><code>LoraBaseMixin</code> provides a base class with several utility methods to fuse, unfuse, unload, LoRAs and more.</li>',Ot,Q,eo,Le,to,k,ve,wo,nt,Br=`Load LoRA layers into Stable Diffusion <a href="/docs/diffusers/pr_10005/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow"><code>CLIPTextModel</code></a>.`,$o,K,we,Mo,st,jr="This will load the LoRA layers specified in <code>state_dict</code> into <code>text_encoder</code>",yo,O,$e,Do,it,Jr="This will load the LoRA layers specified in <code>state_dict</code> into <code>unet</code>.",To,I,Me,So,dt,zr=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,ko,lt,qr="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Ao,ct,Vr=`See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is
loaded.`,Co,ft,Zr=`See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is
loaded into <code>self.unet</code>.`,Ro,pt,Gr=`See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state
dict is loaded into <code>self.text_encoder</code>.`,Po,B,ye,Io,_t,Fr="Return state dict for lora weights and the network alphas.",Ho,ee,Uo,te,De,Eo,mt,Yr="Save the LoRA parameters corresponding to the UNet and text encoder.",oo,Te,ro,A,Se,No,ut,Qr=`Load LoRA layers into Stable Diffusion XL <a href="/docs/diffusers/pr_10005/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>,
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow"><code>CLIPTextModel</code></a>, and
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow"><code>CLIPTextModelWithProjection</code></a>.`,Xo,oe,ke,Wo,ht,Kr="This will load the LoRA layers specified in <code>state_dict</code> into <code>text_encoder</code>",Bo,re,Ae,jo,gt,Or="This will load the LoRA layers specified in <code>state_dict</code> into <code>unet</code>.",Jo,H,Ce,zo,xt,ea=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,qo,bt,ta="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Vo,Lt,oa=`See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is
loaded.`,Zo,vt,ra=`See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is
loaded into <code>self.unet</code>.`,Go,wt,aa=`See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state
dict is loaded into <code>self.text_encoder</code>.`,Fo,j,Re,Yo,$t,na="Return state dict for lora weights and the network alphas.",Qo,ae,Ko,ne,Pe,Oo,Mt,sa="Save the LoRA parameters corresponding to the UNet and text encoder.",ao,Ie,no,T,He,er,yt,ia=`Load LoRA layers into <a href="/docs/diffusers/pr_10005/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>,
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow"><code>CLIPTextModel</code></a>, and
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow"><code>CLIPTextModelWithProjection</code></a>.`,tr,Dt,da='Specific to <a href="/docs/diffusers/pr_10005/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline">StableDiffusion3Pipeline</a>.',or,se,Ue,rr,Tt,la="This will load the LoRA layers specified in <code>state_dict</code> into <code>text_encoder</code>",ar,ie,Ee,nr,St,ca="This will load the LoRA layers specified in <code>state_dict</code> into <code>transformer</code>.",sr,N,Ne,ir,kt,fa=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,dr,At,pa="All kwargs are forwarded to <code>self.lora_state_dict</code>.",lr,Ct,_a=`See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is
loaded.`,cr,Rt,ma=`See <code>~loaders.StableDiffusionLoraLoaderMixin.load_lora_into_transformer</code> for more details on how the state
dict is loaded into <code>self.transformer</code>.`,fr,J,Xe,pr,Pt,ua="Return state dict for lora weights and the network alphas.",_r,de,mr,le,We,ur,It,ha="Save the LoRA parameters corresponding to the UNet and text encoder.",so,Be,io,G,je,hr,ce,Je,gr,Ht,ga="This will load the LoRA layers specified in <code>state_dict</code> into <code>transformer</code>.",lo,ze,co,D,qe,xr,Ut,xa="Utility class for handling LoRAs.",br,Et,Ve,Lr,X,Ze,vr,Nt,ba="Fuses the LoRA parameters into the original parameters of the corresponding blocks.",wr,fe,$r,pe,Mr,z,Ge,yr,Xt,La="Gets the list of the current active adapters.",Dr,_e,Tr,me,Fe,Sr,Wt,va="Gets the current list of all available adapters in the pipeline.",kr,ue,Ye,Ar,Bt,wa=`Moves the LoRAs listed in <code>adapter_names</code> to a target device. Useful for offloading the LoRA to the CPU in case
you want to load multiple adapters and free some GPU memory.`,Cr,q,Qe,Rr,jt,$a=`Reverses the effect of
<a href="https://huggingface.co/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraBaseMixin.fuse_lora" rel="nofollow"><code>pipe.fuse_lora()</code></a>.`,Pr,he,Ir,V,Ke,Hr,Jt,Ma="Unloads the LoRA parameters.",Ur,ge,fo,Oe,po,Qt,_o;return v=new Yt({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),Q=new Ft({props:{$$slots:{default:[Ra]},$$scope:{ctx:S}}}),Le=new Yt({props:{title:"StableDiffusionLoraLoaderMixin",local:"diffusers.loaders.StableDiffusionLoraLoaderMixin",headingTag:"h2"}}),ve=new y({props:{name:"class diffusers.loaders.StableDiffusionLoraLoaderMixin",anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L65"}}),we=new y({props:{name:"load_lora_into_text_encoder",anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"text_encoder",val:""},{name:"prefix",val:" = None"},{name:"lora_scale",val:" = 1.0"},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"},{name:"low_cpu_mem_usage",val:" = False"}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The key should be prefixed with an
additional <code>text_encoder</code> to distinguish between unet lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
The value of the network alpha used for stable learning and preventing underflow. This value has the
same meaning as the <code>--network_alpha</code> option in the kohya-ss trainer script. Refer to <a href="https://github.com/darkstorm2150/sd-scripts/blob/main/docs/train_network_README-en.md#execute-learning" rel="nofollow">this
link</a>.`,name:"network_alphas"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The text encoder model to load the LoRA layers into.`,name:"text_encoder"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder.prefix",description:`<strong>prefix</strong> (<code>str</code>) &#x2014;
Expected prefix of the <code>text_encoder</code> in the <code>state_dict</code>.`,name:"prefix"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>) &#x2014;
How much to scale the output of the lora linear layer before it is added with the output of the regular
lora layer.`,name:"lora_scale"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading by only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L310"}}),$e=new y({props:{name:"load_lora_into_unet",anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_unet",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"unet",val:""},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"},{name:"low_cpu_mem_usage",val:" = False"}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_unet.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The keys can either be indexed directly
into the unet or prefixed with an additional <code>unet</code> which can be used to distinguish between text
encoder lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_unet.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
The value of the network alpha used for stable learning and preventing underflow. This value has the
same meaning as the <code>--network_alpha</code> option in the kohya-ss trainer script. Refer to <a href="https://github.com/darkstorm2150/sd-scripts/blob/main/docs/train_network_README-en.md#execute-learning" rel="nofollow">this
link</a>.`,name:"network_alphas"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_unet.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
The UNet model to load the LoRA layers into.`,name:"unet"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_unet.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_unet.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L260"}}),Me=new y({props:{name:"load_lora_weights",anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading by only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L75"}}),ye=new y({props:{name:"lora_state_dict",anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/pr_10005/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>, defaults to None) &#x2014;
Name of the serialized state dict file.`,name:"weight_name"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L145"}}),ee=new Ft({props:{warning:!0,$$slots:{default:[Pa]},$$scope:{ctx:S}}}),De=new y({props:{name:"save_lora_weights",anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L449"}}),Te=new Yt({props:{title:"StableDiffusionXLLoraLoaderMixin",local:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin",headingTag:"h2"}}),Se=new y({props:{name:"class diffusers.loaders.StableDiffusionXLLoraLoaderMixin",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L567"}}),ke=new y({props:{name:"load_lora_into_text_encoder",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_text_encoder",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"text_encoder",val:""},{name:"prefix",val:" = None"},{name:"lora_scale",val:" = 1.0"},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"},{name:"low_cpu_mem_usage",val:" = False"}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_text_encoder.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The key should be prefixed with an
additional <code>text_encoder</code> to distinguish between unet lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_text_encoder.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
The value of the network alpha used for stable learning and preventing underflow. This value has the
same meaning as the <code>--network_alpha</code> option in the kohya-ss trainer script. Refer to <a href="https://github.com/darkstorm2150/sd-scripts/blob/main/docs/train_network_README-en.md#execute-learning" rel="nofollow">this
link</a>.`,name:"network_alphas"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The text encoder model to load the LoRA layers into.`,name:"text_encoder"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_text_encoder.prefix",description:`<strong>prefix</strong> (<code>str</code>) &#x2014;
Expected prefix of the <code>text_encoder</code> in the <code>state_dict</code>.`,name:"prefix"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_text_encoder.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>) &#x2014;
How much to scale the output of the lora linear layer before it is added with the output of the regular
lora layer.`,name:"lora_scale"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_text_encoder.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_text_encoder.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading by only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L840"}}),Ae=new y({props:{name:"load_lora_into_unet",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_unet",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"unet",val:""},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"},{name:"low_cpu_mem_usage",val:" = False"}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_unet.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The keys can either be indexed directly
into the unet or prefixed with an additional <code>unet</code> which can be used to distinguish between text
encoder lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_unet.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
The value of the network alpha used for stable learning and preventing underflow. This value has the
same meaning as the <code>--network_alpha</code> option in the kohya-ss trainer script. Refer to <a href="https://github.com/darkstorm2150/sd-scripts/blob/main/docs/train_network_README-en.md#execute-learning" rel="nofollow">this
link</a>.`,name:"network_alphas"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_unet.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
The UNet model to load the LoRA layers into.`,name:"unet"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_unet.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_into_unet.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L789"}}),Ce=new y({props:{name:"load_lora_weights",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading by only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L578"}}),Re=new y({props:{name:"lora_state_dict",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/pr_10005/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.lora_state_dict.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>, defaults to None) &#x2014;
Name of the serialized state dict file.`,name:"weight_name"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L673"}}),ae=new Ft({props:{warning:!0,$$slots:{default:[Ia]},$$scope:{ctx:S}}}),Pe=new y({props:{name:"save_lora_weights",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_2_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights.text_encoder_2_lora_layers",description:`<strong>text_encoder_2_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder_2</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_2_lora_layers"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L980"}}),Ie=new Yt({props:{title:"SD3LoraLoaderMixin",local:"diffusers.loaders.SD3LoraLoaderMixin",headingTag:"h2"}}),He=new y({props:{name:"class diffusers.loaders.SD3LoraLoaderMixin",anchor:"diffusers.loaders.SD3LoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L1106"}}),Ue=new y({props:{name:"load_lora_into_text_encoder",anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_text_encoder",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"text_encoder",val:""},{name:"prefix",val:" = None"},{name:"lora_scale",val:" = 1.0"},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"},{name:"low_cpu_mem_usage",val:" = False"}],parametersDescription:[{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_text_encoder.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The key should be prefixed with an
additional <code>text_encoder</code> to distinguish between unet lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_text_encoder.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
The value of the network alpha used for stable learning and preventing underflow. This value has the
same meaning as the <code>--network_alpha</code> option in the kohya-ss trainer script. Refer to <a href="https://github.com/darkstorm2150/sd-scripts/blob/main/docs/train_network_README-en.md#execute-learning" rel="nofollow">this
link</a>.`,name:"network_alphas"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The text encoder model to load the LoRA layers into.`,name:"text_encoder"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_text_encoder.prefix",description:`<strong>prefix</strong> (<code>str</code>) &#x2014;
Expected prefix of the <code>text_encoder</code> in the <code>state_dict</code>.`,name:"prefix"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_text_encoder.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>) &#x2014;
How much to scale the output of the lora linear layer before it is added with the output of the regular
lora layer.`,name:"lora_scale"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_text_encoder.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_text_encoder.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading by only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L1337"}}),Ee=new y({props:{name:"load_lora_into_transformer",anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_transformer",parameters:[{name:"state_dict",val:""},{name:"transformer",val:""},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"},{name:"low_cpu_mem_usage",val:" = False"}],parametersDescription:[{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_transformer.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The keys can either be indexed directly
into the unet or prefixed with an additional <code>unet</code> which can be used to distinguish between text
encoder lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_transformer.transformer",description:`<strong>transformer</strong> (<code>SD3Transformer2DModel</code>) &#x2014;
The Transformer model to load the LoRA layers into.`,name:"transformer"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_transformer.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_into_transformer.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading by only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L1301"}}),Ne=new y({props:{name:"load_lora_weights",anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_weights.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading by only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/pr_10005/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L1216"}}),Xe=new y({props:{name:"lora_state_dict",anchor:"diffusers.loaders.SD3LoraLoaderMixin.lora_state_dict",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.SD3LoraLoaderMixin.lora_state_dict.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/pr_10005/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.lora_state_dict.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.lora_state_dict.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.lora_state_dict.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.lora_state_dict.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.lora_state_dict.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.lora_state_dict.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.lora_state_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L1119"}}),de=new Ft({props:{warning:!0,$$slots:{default:[Ha]},$$scope:{ctx:S}}}),We=new y({props:{name:"save_lora_weights",anchor:"diffusers.loaders.SD3LoraLoaderMixin.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"transformer_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_2_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.loaders.SD3LoraLoaderMixin.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.save_lora_weights.transformer_lora_layers",description:`<strong>transformer_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>transformer</code>.`,name:"transformer_lora_layers"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.save_lora_weights.text_encoder_2_lora_layers",description:`<strong>text_encoder_2_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder_2</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_2_lora_layers"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.loaders.SD3LoraLoaderMixin.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L1477"}}),Be=new Yt({props:{title:"AmusedLoraLoaderMixin",local:"diffusers.loaders.AmusedLoraLoaderMixin",headingTag:"h2"}}),je=new y({props:{name:"class diffusers.loaders.AmusedLoraLoaderMixin",anchor:"diffusers.loaders.AmusedLoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L2121"}}),Je=new y({props:{name:"load_lora_into_transformer",anchor:"diffusers.loaders.AmusedLoraLoaderMixin.load_lora_into_transformer",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"transformer",val:""},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"},{name:"low_cpu_mem_usage",val:" = False"}],parametersDescription:[{anchor:"diffusers.loaders.AmusedLoraLoaderMixin.load_lora_into_transformer.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The keys can either be indexed directly
into the unet or prefixed with an additional <code>unet</code> which can be used to distinguish between text
encoder lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.AmusedLoraLoaderMixin.load_lora_into_transformer.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
The value of the network alpha used for stable learning and preventing underflow. This value has the
same meaning as the <code>--network_alpha</code> option in the kohya-ss trainer script. Refer to <a href="https://github.com/darkstorm2150/sd-scripts/blob/main/docs/train_network_README-en.md#execute-learning" rel="nofollow">this
link</a>.`,name:"network_alphas"},{anchor:"diffusers.loaders.AmusedLoraLoaderMixin.load_lora_into_transformer.transformer",description:`<strong>transformer</strong> (<code>UVit2DModel</code>) &#x2014;
The Transformer model to load the LoRA layers into.`,name:"transformer"},{anchor:"diffusers.loaders.AmusedLoraLoaderMixin.load_lora_into_transformer.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.AmusedLoraLoaderMixin.load_lora_into_transformer.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading by only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_pipeline.py#L2126"}}),ze=new Yt({props:{title:"LoraBaseMixin",local:"diffusers.loaders.lora_base.LoraBaseMixin",headingTag:"h2"}}),qe=new y({props:{name:"class diffusers.loaders.lora_base.LoraBaseMixin",anchor:"diffusers.loaders.lora_base.LoraBaseMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_base.py#L300"}}),Ve=new y({props:{name:"delete_adapters",anchor:"diffusers.loaders.lora_base.LoraBaseMixin.delete_adapters",parameters:[{name:"adapter_names",val:": typing.Union[typing.List[str], str]"}],parametersDescription:[{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.delete_adapters.Deletes",description:`<strong>Deletes</strong> the LoRA layers of <code>adapter_name</code> for the unet and text-encoder(s). &#x2014;
adapter_names (<code>Union[List[str], str]</code>):
The names of the adapter to delete. Can be a single string or a list of strings`,name:"Deletes"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_base.py#L615"}}),Ze=new y({props:{name:"fuse_lora",anchor:"diffusers.loaders.lora_base.LoraBaseMixin.fuse_lora",parameters:[{name:"components",val:": typing.List[str] = []"},{name:"lora_scale",val:": float = 1.0"},{name:"safe_fusing",val:": bool = False"},{name:"adapter_names",val:": typing.Optional[typing.List[str]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.fuse_lora.components",description:"<strong>components</strong> &#x2014; (<code>List[str]</code>): List of LoRA-injectable components to fuse the LoRAs into.",name:"components"},{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.fuse_lora.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, defaults to 1.0) &#x2014;
Controls how much to influence the outputs with the LoRA parameters.`,name:"lora_scale"},{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.fuse_lora.safe_fusing",description:`<strong>safe_fusing</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to check fused weights for NaN values before fusing and if values are NaN not fusing them.`,name:"safe_fusing"},{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.fuse_lora.adapter_names",description:`<strong>adapter_names</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Adapter names to be used for fusing. If nothing is passed, all active adapters will be fused.`,name:"adapter_names"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_base.py#L387"}}),fe=new Ft({props:{warning:!0,$$slots:{default:[Ua]},$$scope:{ctx:S}}}),pe=new Er({props:{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.fuse_lora.example",$$slots:{default:[Ea]},$$scope:{ctx:S}}}),Ge=new y({props:{name:"get_active_adapters",anchor:"diffusers.loaders.lora_base.LoraBaseMixin.get_active_adapters",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_base.py#L637"}}),_e=new Er({props:{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.get_active_adapters.example",$$slots:{default:[Na]},$$scope:{ctx:S}}}),Fe=new y({props:{name:"get_list_adapters",anchor:"diffusers.loaders.lora_base.LoraBaseMixin.get_list_adapters",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_base.py#L670"}}),Ye=new y({props:{name:"set_lora_device",anchor:"diffusers.loaders.lora_base.LoraBaseMixin.set_lora_device",parameters:[{name:"adapter_names",val:": typing.List[str]"},{name:"device",val:": typing.Union[torch.device, str, int]"}],parametersDescription:[{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.set_lora_device.adapter_names",description:`<strong>adapter_names</strong> (<code>List[str]</code>) &#x2014;
List of adapters to send device to.`,name:"adapter_names"},{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.set_lora_device.device",description:`<strong>device</strong> (<code>Union[torch.device, str, int]</code>) &#x2014;
Device to send the adapters to. Can be either a torch device, a str or an integer.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_base.py#L692"}}),Qe=new y({props:{name:"unfuse_lora",anchor:"diffusers.loaders.lora_base.LoraBaseMixin.unfuse_lora",parameters:[{name:"components",val:": typing.List[str] = []"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.unfuse_lora.components",description:"<strong>components</strong> (<code>List[str]</code>) &#x2014; List of LoRA-injectable components to unfuse LoRA from.",name:"components"},{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.unfuse_lora.unfuse_unet",description:"<strong>unfuse_unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; Whether to unfuse the UNet LoRA parameters.",name:"unfuse_unet"},{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.unfuse_lora.unfuse_text_encoder",description:`<strong>unfuse_text_encoder</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to unfuse the text encoder LoRA parameters. If the text encoder wasn&#x2019;t monkey-patched with the
LoRA parameters then it won&#x2019;t have any effect.`,name:"unfuse_text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_base.py#L468"}}),he=new Ft({props:{warning:!0,$$slots:{default:[Xa]},$$scope:{ctx:S}}}),Ke=new y({props:{name:"unload_lora_weights",anchor:"diffusers.loaders.lora_base.LoraBaseMixin.unload_lora_weights",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10005/src/diffusers/loaders/lora_base.py#L364"}}),ge=new Er({props:{anchor:"diffusers.loaders.lora_base.LoraBaseMixin.unload_lora_weights.example",$$slots:{default:[Wa]},$$scope:{ctx:S}}}),Oe=new Ca({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/loaders/lora.md"}}),{c(){s=a("meta"),L=o(),f=a("p"),l=o(),_(v.$$.fragment),i=o(),w=a("p"),w.innerHTML=Xr,Kt=o(),be=a("ul"),be.innerHTML=Wr,Ot=o(),_(Q.$$.fragment),eo=o(),_(Le.$$.fragment),to=o(),k=a("div"),_(ve.$$.fragment),wo=o(),nt=a("p"),nt.innerHTML=Br,$o=o(),K=a("div"),_(we.$$.fragment),Mo=o(),st=a("p"),st.innerHTML=jr,yo=o(),O=a("div"),_($e.$$.fragment),Do=o(),it=a("p"),it.innerHTML=Jr,To=o(),I=a("div"),_(Me.$$.fragment),So=o(),dt=a("p"),dt.innerHTML=zr,ko=o(),lt=a("p"),lt.innerHTML=qr,Ao=o(),ct=a("p"),ct.innerHTML=Vr,Co=o(),ft=a("p"),ft.innerHTML=Zr,Ro=o(),pt=a("p"),pt.innerHTML=Gr,Po=o(),B=a("div"),_(ye.$$.fragment),Io=o(),_t=a("p"),_t.textContent=Fr,Ho=o(),_(ee.$$.fragment),Uo=o(),te=a("div"),_(De.$$.fragment),Eo=o(),mt=a("p"),mt.textContent=Yr,oo=o(),_(Te.$$.fragment),ro=o(),A=a("div"),_(Se.$$.fragment),No=o(),ut=a("p"),ut.innerHTML=Qr,Xo=o(),oe=a("div"),_(ke.$$.fragment),Wo=o(),ht=a("p"),ht.innerHTML=Kr,Bo=o(),re=a("div"),_(Ae.$$.fragment),jo=o(),gt=a("p"),gt.innerHTML=Or,Jo=o(),H=a("div"),_(Ce.$$.fragment),zo=o(),xt=a("p"),xt.innerHTML=ea,qo=o(),bt=a("p"),bt.innerHTML=ta,Vo=o(),Lt=a("p"),Lt.innerHTML=oa,Zo=o(),vt=a("p"),vt.innerHTML=ra,Go=o(),wt=a("p"),wt.innerHTML=aa,Fo=o(),j=a("div"),_(Re.$$.fragment),Yo=o(),$t=a("p"),$t.textContent=na,Qo=o(),_(ae.$$.fragment),Ko=o(),ne=a("div"),_(Pe.$$.fragment),Oo=o(),Mt=a("p"),Mt.textContent=sa,ao=o(),_(Ie.$$.fragment),no=o(),T=a("div"),_(He.$$.fragment),er=o(),yt=a("p"),yt.innerHTML=ia,tr=o(),Dt=a("p"),Dt.innerHTML=da,or=o(),se=a("div"),_(Ue.$$.fragment),rr=o(),Tt=a("p"),Tt.innerHTML=la,ar=o(),ie=a("div"),_(Ee.$$.fragment),nr=o(),St=a("p"),St.innerHTML=ca,sr=o(),N=a("div"),_(Ne.$$.fragment),ir=o(),kt=a("p"),kt.innerHTML=fa,dr=o(),At=a("p"),At.innerHTML=pa,lr=o(),Ct=a("p"),Ct.innerHTML=_a,cr=o(),Rt=a("p"),Rt.innerHTML=ma,fr=o(),J=a("div"),_(Xe.$$.fragment),pr=o(),Pt=a("p"),Pt.textContent=ua,_r=o(),_(de.$$.fragment),mr=o(),le=a("div"),_(We.$$.fragment),ur=o(),It=a("p"),It.textContent=ha,so=o(),_(Be.$$.fragment),io=o(),G=a("div"),_(je.$$.fragment),hr=o(),ce=a("div"),_(Je.$$.fragment),gr=o(),Ht=a("p"),Ht.innerHTML=ga,lo=o(),_(ze.$$.fragment),co=o(),D=a("div"),_(qe.$$.fragment),xr=o(),Ut=a("p"),Ut.textContent=xa,br=o(),Et=a("div"),_(Ve.$$.fragment),Lr=o(),X=a("div"),_(Ze.$$.fragment),vr=o(),Nt=a("p"),Nt.textContent=ba,wr=o(),_(fe.$$.fragment),$r=o(),_(pe.$$.fragment),Mr=o(),z=a("div"),_(Ge.$$.fragment),yr=o(),Xt=a("p"),Xt.textContent=La,Dr=o(),_(_e.$$.fragment),Tr=o(),me=a("div"),_(Fe.$$.fragment),Sr=o(),Wt=a("p"),Wt.textContent=va,kr=o(),ue=a("div"),_(Ye.$$.fragment),Ar=o(),Bt=a("p"),Bt.innerHTML=wa,Cr=o(),q=a("div"),_(Qe.$$.fragment),Rr=o(),jt=a("p"),jt.innerHTML=$a,Pr=o(),_(he.$$.fragment),Ir=o(),V=a("div"),_(Ke.$$.fragment),Hr=o(),Jt=a("p"),Jt.textContent=Ma,Ur=o(),_(ge.$$.fragment),fo=o(),_(Oe.$$.fragment),po=o(),Qt=a("p"),this.h()},l(e){const c=Aa("svelte-u9bgzb",document.head);s=n(c,"META",{name:!0,content:!0}),c.forEach(d),L=r(e),f=n(e,"P",{}),$(f).forEach(d),l=r(e),m(v.$$.fragment,e),i=r(e),w=n(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-zpo32d"&&(w.innerHTML=Xr),Kt=r(e),be=n(e,"UL",{"data-svelte-h":!0}),p(be)!=="svelte-14pig82"&&(be.innerHTML=Wr),Ot=r(e),m(Q.$$.fragment,e),eo=r(e),m(Le.$$.fragment,e),to=r(e),k=n(e,"DIV",{class:!0});var R=$(k);m(ve.$$.fragment,R),wo=r(R),nt=n(R,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1alxaxp"&&(nt.innerHTML=Br),$o=r(R),K=n(R,"DIV",{class:!0});var et=$(K);m(we.$$.fragment,et),Mo=r(et),st=n(et,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1062ci4"&&(st.innerHTML=jr),et.forEach(d),yo=r(R),O=n(R,"DIV",{class:!0});var tt=$(O);m($e.$$.fragment,tt),Do=r(tt),it=n(tt,"P",{"data-svelte-h":!0}),p(it)!=="svelte-u3q4so"&&(it.innerHTML=Jr),tt.forEach(d),To=r(R),I=n(R,"DIV",{class:!0});var E=$(I);m(Me.$$.fragment,E),So=r(E),dt=n(E,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-vs7s0z"&&(dt.innerHTML=zr),ko=r(E),lt=n(E,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-15b960v"&&(lt.innerHTML=qr),Ao=r(E),ct=n(E,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-12tcdua"&&(ct.innerHTML=Vr),Co=r(E),ft=n(E,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1xafxl1"&&(ft.innerHTML=Zr),Ro=r(E),pt=n(E,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-at0zcj"&&(pt.innerHTML=Gr),E.forEach(d),Po=r(R),B=n(R,"DIV",{class:!0});var F=$(B);m(ye.$$.fragment,F),Io=r(F),_t=n(F,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-flusvq"&&(_t.textContent=Fr),Ho=r(F),m(ee.$$.fragment,F),F.forEach(d),Uo=r(R),te=n(R,"DIV",{class:!0});var ot=$(te);m(De.$$.fragment,ot),Eo=r(ot),mt=n(ot,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1ufq5ot"&&(mt.textContent=Yr),ot.forEach(d),R.forEach(d),oo=r(e),m(Te.$$.fragment,e),ro=r(e),A=n(e,"DIV",{class:!0});var P=$(A);m(Se.$$.fragment,P),No=r(P),ut=n(P,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-5ktkcq"&&(ut.innerHTML=Qr),Xo=r(P),oe=n(P,"DIV",{class:!0});var rt=$(oe);m(ke.$$.fragment,rt),Wo=r(rt),ht=n(rt,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1062ci4"&&(ht.innerHTML=Kr),rt.forEach(d),Bo=r(P),re=n(P,"DIV",{class:!0});var at=$(re);m(Ae.$$.fragment,at),jo=r(at),gt=n(at,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-u3q4so"&&(gt.innerHTML=Or),at.forEach(d),Jo=r(P),H=n(P,"DIV",{class:!0});var W=$(H);m(Ce.$$.fragment,W),zo=r(W),xt=n(W,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-vs7s0z"&&(xt.innerHTML=ea),qo=r(W),bt=n(W,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-15b960v"&&(bt.innerHTML=ta),Vo=r(W),Lt=n(W,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-12tcdua"&&(Lt.innerHTML=oa),Zo=r(W),vt=n(W,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-1xafxl1"&&(vt.innerHTML=ra),Go=r(W),wt=n(W,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-at0zcj"&&(wt.innerHTML=aa),W.forEach(d),Fo=r(P),j=n(P,"DIV",{class:!0});var zt=$(j);m(Re.$$.fragment,zt),Yo=r(zt),$t=n(zt,"P",{"data-svelte-h":!0}),p($t)!=="svelte-flusvq"&&($t.textContent=na),Qo=r(zt),m(ae.$$.fragment,zt),zt.forEach(d),Ko=r(P),ne=n(P,"DIV",{class:!0});var mo=$(ne);m(Pe.$$.fragment,mo),Oo=r(mo),Mt=n(mo,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1ufq5ot"&&(Mt.textContent=sa),mo.forEach(d),P.forEach(d),ao=r(e),m(Ie.$$.fragment,e),no=r(e),T=n(e,"DIV",{class:!0});var U=$(T);m(He.$$.fragment,U),er=r(U),yt=n(U,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-6dziuj"&&(yt.innerHTML=ia),tr=r(U),Dt=n(U,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-gx3tt"&&(Dt.innerHTML=da),or=r(U),se=n(U,"DIV",{class:!0});var uo=$(se);m(Ue.$$.fragment,uo),rr=r(uo),Tt=n(uo,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-1062ci4"&&(Tt.innerHTML=la),uo.forEach(d),ar=r(U),ie=n(U,"DIV",{class:!0});var ho=$(ie);m(Ee.$$.fragment,ho),nr=r(ho),St=n(ho,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1lgbsz7"&&(St.innerHTML=ca),ho.forEach(d),sr=r(U),N=n(U,"DIV",{class:!0});var Z=$(N);m(Ne.$$.fragment,Z),ir=r(Z),kt=n(Z,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-vs7s0z"&&(kt.innerHTML=fa),dr=r(Z),At=n(Z,"P",{"data-svelte-h":!0}),p(At)!=="svelte-15b960v"&&(At.innerHTML=pa),lr=r(Z),Ct=n(Z,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-12tcdua"&&(Ct.innerHTML=_a),cr=r(Z),Rt=n(Z,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1ukghd4"&&(Rt.innerHTML=ma),Z.forEach(d),fr=r(U),J=n(U,"DIV",{class:!0});var qt=$(J);m(Xe.$$.fragment,qt),pr=r(qt),Pt=n(qt,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-flusvq"&&(Pt.textContent=ua),_r=r(qt),m(de.$$.fragment,qt),qt.forEach(d),mr=r(U),le=n(U,"DIV",{class:!0});var go=$(le);m(We.$$.fragment,go),ur=r(go),It=n(go,"P",{"data-svelte-h":!0}),p(It)!=="svelte-1ufq5ot"&&(It.textContent=ha),go.forEach(d),U.forEach(d),so=r(e),m(Be.$$.fragment,e),io=r(e),G=n(e,"DIV",{class:!0});var xo=$(G);m(je.$$.fragment,xo),hr=r(xo),ce=n(xo,"DIV",{class:!0});var bo=$(ce);m(Je.$$.fragment,bo),gr=r(bo),Ht=n(bo,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-1lgbsz7"&&(Ht.innerHTML=ga),bo.forEach(d),xo.forEach(d),lo=r(e),m(ze.$$.fragment,e),co=r(e),D=n(e,"DIV",{class:!0});var C=$(D);m(qe.$$.fragment,C),xr=r(C),Ut=n(C,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-1q4bbx"&&(Ut.textContent=xa),br=r(C),Et=n(C,"DIV",{class:!0});var ya=$(Et);m(Ve.$$.fragment,ya),ya.forEach(d),Lr=r(C),X=n(C,"DIV",{class:!0});var xe=$(X);m(Ze.$$.fragment,xe),vr=r(xe),Nt=n(xe,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-1nr2dy0"&&(Nt.textContent=ba),wr=r(xe),m(fe.$$.fragment,xe),$r=r(xe),m(pe.$$.fragment,xe),xe.forEach(d),Mr=r(C),z=n(C,"DIV",{class:!0});var Vt=$(z);m(Ge.$$.fragment,Vt),yr=r(Vt),Xt=n(Vt,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-h0os0v"&&(Xt.textContent=La),Dr=r(Vt),m(_e.$$.fragment,Vt),Vt.forEach(d),Tr=r(C),me=n(C,"DIV",{class:!0});var Lo=$(me);m(Fe.$$.fragment,Lo),Sr=r(Lo),Wt=n(Lo,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-1825k9e"&&(Wt.textContent=va),Lo.forEach(d),kr=r(C),ue=n(C,"DIV",{class:!0});var vo=$(ue);m(Ye.$$.fragment,vo),Ar=r(vo),Bt=n(vo,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-rvubqa"&&(Bt.innerHTML=wa),vo.forEach(d),Cr=r(C),q=n(C,"DIV",{class:!0});var Zt=$(q);m(Qe.$$.fragment,Zt),Rr=r(Zt),jt=n(Zt,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-ioswce"&&(jt.innerHTML=$a),Pr=r(Zt),m(he.$$.fragment,Zt),Zt.forEach(d),Ir=r(C),V=n(C,"DIV",{class:!0});var Gt=$(V);m(Ke.$$.fragment,Gt),Hr=r(Gt),Jt=n(Gt,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-119cgd9"&&(Jt.textContent=Ma),Ur=r(Gt),m(ge.$$.fragment,Gt),Gt.forEach(d),C.forEach(d),fo=r(e),m(Oe.$$.fragment,e),po=r(e),Qt=n(e,"P",{}),$(Qt).forEach(d),this.h()},h(){M(s,"name","hf:doc:metadata"),M(s,"content",ja),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,s),b(e,L,c),b(e,f,c),b(e,l,c),u(v,e,c),b(e,i,c),b(e,w,c),b(e,Kt,c),b(e,be,c),b(e,Ot,c),u(Q,e,c),b(e,eo,c),u(Le,e,c),b(e,to,c),b(e,k,c),u(ve,k,null),t(k,wo),t(k,nt),t(k,$o),t(k,K),u(we,K,null),t(K,Mo),t(K,st),t(k,yo),t(k,O),u($e,O,null),t(O,Do),t(O,it),t(k,To),t(k,I),u(Me,I,null),t(I,So),t(I,dt),t(I,ko),t(I,lt),t(I,Ao),t(I,ct),t(I,Co),t(I,ft),t(I,Ro),t(I,pt),t(k,Po),t(k,B),u(ye,B,null),t(B,Io),t(B,_t),t(B,Ho),u(ee,B,null),t(k,Uo),t(k,te),u(De,te,null),t(te,Eo),t(te,mt),b(e,oo,c),u(Te,e,c),b(e,ro,c),b(e,A,c),u(Se,A,null),t(A,No),t(A,ut),t(A,Xo),t(A,oe),u(ke,oe,null),t(oe,Wo),t(oe,ht),t(A,Bo),t(A,re),u(Ae,re,null),t(re,jo),t(re,gt),t(A,Jo),t(A,H),u(Ce,H,null),t(H,zo),t(H,xt),t(H,qo),t(H,bt),t(H,Vo),t(H,Lt),t(H,Zo),t(H,vt),t(H,Go),t(H,wt),t(A,Fo),t(A,j),u(Re,j,null),t(j,Yo),t(j,$t),t(j,Qo),u(ae,j,null),t(A,Ko),t(A,ne),u(Pe,ne,null),t(ne,Oo),t(ne,Mt),b(e,ao,c),u(Ie,e,c),b(e,no,c),b(e,T,c),u(He,T,null),t(T,er),t(T,yt),t(T,tr),t(T,Dt),t(T,or),t(T,se),u(Ue,se,null),t(se,rr),t(se,Tt),t(T,ar),t(T,ie),u(Ee,ie,null),t(ie,nr),t(ie,St),t(T,sr),t(T,N),u(Ne,N,null),t(N,ir),t(N,kt),t(N,dr),t(N,At),t(N,lr),t(N,Ct),t(N,cr),t(N,Rt),t(T,fr),t(T,J),u(Xe,J,null),t(J,pr),t(J,Pt),t(J,_r),u(de,J,null),t(T,mr),t(T,le),u(We,le,null),t(le,ur),t(le,It),b(e,so,c),u(Be,e,c),b(e,io,c),b(e,G,c),u(je,G,null),t(G,hr),t(G,ce),u(Je,ce,null),t(ce,gr),t(ce,Ht),b(e,lo,c),u(ze,e,c),b(e,co,c),b(e,D,c),u(qe,D,null),t(D,xr),t(D,Ut),t(D,br),t(D,Et),u(Ve,Et,null),t(D,Lr),t(D,X),u(Ze,X,null),t(X,vr),t(X,Nt),t(X,wr),u(fe,X,null),t(X,$r),u(pe,X,null),t(D,Mr),t(D,z),u(Ge,z,null),t(z,yr),t(z,Xt),t(z,Dr),u(_e,z,null),t(D,Tr),t(D,me),u(Fe,me,null),t(me,Sr),t(me,Wt),t(D,kr),t(D,ue),u(Ye,ue,null),t(ue,Ar),t(ue,Bt),t(D,Cr),t(D,q),u(Qe,q,null),t(q,Rr),t(q,jt),t(q,Pr),u(he,q,null),t(D,Ir),t(D,V),u(Ke,V,null),t(V,Hr),t(V,Jt),t(V,Ur),u(ge,V,null),b(e,fo,c),u(Oe,e,c),b(e,po,c),b(e,Qt,c),_o=!0},p(e,[c]){const R={};c&2&&(R.$$scope={dirty:c,ctx:e}),Q.$set(R);const et={};c&2&&(et.$$scope={dirty:c,ctx:e}),ee.$set(et);const tt={};c&2&&(tt.$$scope={dirty:c,ctx:e}),ae.$set(tt);const E={};c&2&&(E.$$scope={dirty:c,ctx:e}),de.$set(E);const F={};c&2&&(F.$$scope={dirty:c,ctx:e}),fe.$set(F);const ot={};c&2&&(ot.$$scope={dirty:c,ctx:e}),pe.$set(ot);const P={};c&2&&(P.$$scope={dirty:c,ctx:e}),_e.$set(P);const rt={};c&2&&(rt.$$scope={dirty:c,ctx:e}),he.$set(rt);const at={};c&2&&(at.$$scope={dirty:c,ctx:e}),ge.$set(at)},i(e){_o||(h(v.$$.fragment,e),h(Q.$$.fragment,e),h(Le.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h($e.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(ee.$$.fragment,e),h(De.$$.fragment,e),h(Te.$$.fragment,e),h(Se.$$.fragment,e),h(ke.$$.fragment,e),h(Ae.$$.fragment,e),h(Ce.$$.fragment,e),h(Re.$$.fragment,e),h(ae.$$.fragment,e),h(Pe.$$.fragment,e),h(Ie.$$.fragment,e),h(He.$$.fragment,e),h(Ue.$$.fragment,e),h(Ee.$$.fragment,e),h(Ne.$$.fragment,e),h(Xe.$$.fragment,e),h(de.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),h(ze.$$.fragment,e),h(qe.$$.fragment,e),h(Ve.$$.fragment,e),h(Ze.$$.fragment,e),h(fe.$$.fragment,e),h(pe.$$.fragment,e),h(Ge.$$.fragment,e),h(_e.$$.fragment,e),h(Fe.$$.fragment,e),h(Ye.$$.fragment,e),h(Qe.$$.fragment,e),h(he.$$.fragment,e),h(Ke.$$.fragment,e),h(ge.$$.fragment,e),h(Oe.$$.fragment,e),_o=!0)},o(e){g(v.$$.fragment,e),g(Q.$$.fragment,e),g(Le.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g($e.$$.fragment,e),g(Me.$$.fragment,e),g(ye.$$.fragment,e),g(ee.$$.fragment,e),g(De.$$.fragment,e),g(Te.$$.fragment,e),g(Se.$$.fragment,e),g(ke.$$.fragment,e),g(Ae.$$.fragment,e),g(Ce.$$.fragment,e),g(Re.$$.fragment,e),g(ae.$$.fragment,e),g(Pe.$$.fragment,e),g(Ie.$$.fragment,e),g(He.$$.fragment,e),g(Ue.$$.fragment,e),g(Ee.$$.fragment,e),g(Ne.$$.fragment,e),g(Xe.$$.fragment,e),g(de.$$.fragment,e),g(We.$$.fragment,e),g(Be.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(Ze.$$.fragment,e),g(fe.$$.fragment,e),g(pe.$$.fragment,e),g(Ge.$$.fragment,e),g(_e.$$.fragment,e),g(Fe.$$.fragment,e),g(Ye.$$.fragment,e),g(Qe.$$.fragment,e),g(he.$$.fragment,e),g(Ke.$$.fragment,e),g(ge.$$.fragment,e),g(Oe.$$.fragment,e),_o=!1},d(e){e&&(d(L),d(f),d(l),d(i),d(w),d(Kt),d(be),d(Ot),d(eo),d(to),d(k),d(oo),d(ro),d(A),d(ao),d(no),d(T),d(so),d(io),d(G),d(lo),d(co),d(D),d(fo),d(po),d(Qt)),d(s),x(v,e),x(Q,e),x(Le,e),x(ve),x(we),x($e),x(Me),x(ye),x(ee),x(De),x(Te,e),x(Se),x(ke),x(Ae),x(Ce),x(Re),x(ae),x(Pe),x(Ie,e),x(He),x(Ue),x(Ee),x(Ne),x(Xe),x(de),x(We),x(Be,e),x(je),x(Je),x(ze,e),x(qe),x(Ve),x(Ze),x(fe),x(pe),x(Ge),x(_e),x(Fe),x(Ye),x(Qe),x(he),x(Ke),x(ge),x(Oe,e)}}}const ja='{"title":"LoRA","local":"lora","sections":[{"title":"StableDiffusionLoraLoaderMixin","local":"diffusers.loaders.StableDiffusionLoraLoaderMixin","sections":[],"depth":2},{"title":"StableDiffusionXLLoraLoaderMixin","local":"diffusers.loaders.StableDiffusionXLLoraLoaderMixin","sections":[],"depth":2},{"title":"SD3LoraLoaderMixin","local":"diffusers.loaders.SD3LoraLoaderMixin","sections":[],"depth":2},{"title":"AmusedLoraLoaderMixin","local":"diffusers.loaders.AmusedLoraLoaderMixin","sections":[],"depth":2},{"title":"LoraBaseMixin","local":"diffusers.loaders.lora_base.LoraBaseMixin","sections":[],"depth":2}],"depth":1}';function Ja(S){return Ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qa extends Sa{constructor(s){super(),ka(this,s,Ja,Ba,Da,{})}}export{Qa as component};
