import{s as ue,n as me,o as Ce}from"../chunks/scheduler.f6319a2a.js";import{S as he,i as be,g as a,s as n,r as i,A as Je,h as y,f as t,c as M,j as we,u as p,x as o,k as de,y as Te,a as s,v as U,d as r,t as j,w as c}from"../chunks/index.85aa684c.js";import{C as w}from"../chunks/CodeBlock.3400fc53.js";import{D as ge}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as Nl,E as fe}from"../chunks/index.9e1e6fd7.js";function Ae(Yl){let d,sl,el,nl,u,Ml,m,al,C,Ll="In this notebook we will make a <strong>multi-agent web browser: an agentic system with several agents collaborating to solve problems using the web!</strong>",yl,h,zl="It will be a simple hierarchy:",ol,b,il,J,Fl="Let’s set up this system.",pl,T,ql="Run the line below to install the required dependencies:",Ul,g,rl,f,Pl="Let’s login to HF in order to call Inference Providers:",jl,A,cl,I,Dl='⚡️ Our agent will be powered by <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a> using <code>InferenceClientModel</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',wl,B,Kl='<em>Note:</em> The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.',dl,k,ul,Z,ml,G,Ol='For web browsing, we can already use our pre-existing <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/default_tools.py#L151-L176" rel="nofollow"><code>DuckDuckGoSearchTool</code></a> tool to provide a Google search equivalent.',Cl,v,le=`But then we will also need to be able to peak into the page found by the <code>DuckDuckGoSearchTool</code>.
To do so, we could import the library’s built-in <code>VisitWebpageTool</code>, but we will build it again to see how it’s done.`,hl,S,ee="So let’s create our <code>VisitWebpageTool</code> tool from scratch using <code>markdownify</code>.",bl,W,Jl,V,te="Ok, now let’s initialize and test our tool!",Tl,$,gl,Q,fl,_,se="Now that we have all the tools <code>search</code> and <code>visit_webpage</code>, we can use them to create the web agent.",Al,H,ne="Which configuration to choose for this agent?",Il,E,Me="<li>Web browsing is a single-timeline task that does not require parallel tool calls, so JSON tool calling works well for that. We thus choose a <code>ToolCallingAgent</code>.</li> <li>Also, since sometimes web search requires exploring many pages before finding the correct answer, we prefer to increase the number of <code>max_steps</code> to 10.</li>",Bl,x,kl,R,ae="Note that we gave this agent attributes <code>name</code> and <code>description</code>, mandatory attributes to make this agent callable by its manager agent.",Zl,X,ye="Then we create a manager agent, and upon initialization we pass our managed agent to it in its <code>managed_agents</code> argument.",Gl,N,oe="Since this agent is the one tasked with the planning and thinking, advanced reasoning will be beneficial, so a <code>CodeAgent</code> will be the best choice.",vl,Y,ie="Also, we want to ask a question that involves the current year and does additional data calculations: so let us add <code>additional_authorized_imports=[&quot;time&quot;, &quot;numpy&quot;, &quot;pandas&quot;]</code>, just in case the agent needs these packages.",Sl,L,Wl,z,pe="That’s all! Now let’s run our system! We select a question that requires both some calculation and research:",Vl,F,$l,q,Ue="We get this report as the answer:",Ql,P,_l,D,re='Seems like we’ll need some sizeable powerplants if the <a href="https://gwern.net/scaling-hypothesis" rel="nofollow">scaling hypothesis</a> continues to hold true.',Hl,K,je="Our agents managed to efficiently collaborate towards solving the task! ✅",El,O,ce="💡 You can easily extend this orchestration to more agents: one does the code execution, one the web search, one handles file loadings…",xl,ll,Rl,tl,Xl;return u=new Nl({props:{title:"Orchestrate a multi-agent system 🤖🤝🤖",local:"orchestrate-a-multi-agent-system-",headingTag:"h1"}}),m=new ge({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"}]}}),b=new w({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJCLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyME1hbmFnZXIlMjBhZ2VudCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0lMkIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfX19fX19fX19fX19fX18lN0NfX19fX19fX19fX19fXyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQUNvZGUlMjBJbnRlcnByZXRlciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBXZWIlMjBTZWFyY2glMjBhZ2VudCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFdlYiUyMFNlYXJjaCUyMHRvb2wlMjAlMjAlMjAlMjAlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBWaXNpdCUyMHdlYnBhZ2UlMjB0b29s",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
Code Interpreter            +------------------+
    tool                    |<span class="hljs-string"> Web Search agent </span>|
                            +------------------+
                               |<span class="hljs-string">            </span>|
                        Web Search tool     |<span class="hljs-string">
                                   Visit webpage tool</span>`,wrap:!1}}),g=new w({props:{code:"ISUyMHBpcCUyMGluc3RhbGwlMjBtYXJrZG93bmlmeSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwc21vbGFnZW50cyUyMC0tdXBncmFkZSUyMC1x",highlighted:"! pip install markdownify duckduckgo-search smolagents --upgrade -q",wrap:!1}}),A=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()`,wrap:!1}}),k=new w({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjI=",highlighted:'model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>',wrap:!1}}),Z=new Nl({props:{title:"🔍 Create a web search tool",local:"-create-a-web-search-tool",headingTag:"h2"}}),W=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = markdownify(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),$=new w({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),Q=new Nl({props:{title:"Build our multi-agent system 🤖🤝🤖",local:"build-our-multi-agent-system-",headingTag:"h2"}}),x=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMEElMjAlMjAlMjAlMjBMaXRlTExNTW9kZWwlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbChtb2RlbF9pZCUzRG1vZGVsX2lkKSUwQSUwQXdlYl9hZ2VudCUyMCUzRCUyMFRvb2xDYWxsaW5nQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTJDJTIwdmlzaXRfd2VicGFnZSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJ3ZWJfc2VhcmNoX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJSdW5zJTIwd2ViJTIwc2VhcmNoZXMlMjBmb3IlMjB5b3UuJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    InferenceClientModel,
    DuckDuckGoSearchTool,
    LiteLLMModel,
)

model = InferenceClientModel(model_id=model_id)

web_agent = ToolCallingAgent(
    tools=[DuckDuckGoSearchTool(), visit_webpage],
    model=model,
    max_steps=<span class="hljs-number">10</span>,
    name=<span class="hljs-string">&quot;web_search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you.&quot;</span>,
)`,wrap:!1}}),L=new w({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1QndlYl9hZ2VudCU1RCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIydGltZSUyMiUyQyUyMCUyMm51bXB5JTIyJTJDJTIwJTIycGFuZGFzJTIyJTVEJTJDJTBBKQ==",highlighted:`manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;numpy&quot;</span>, <span class="hljs-string">&quot;pandas&quot;</span>],
)`,wrap:!1}}),F=new w({props:{code:"YW5zd2VyJTIwJTNEJTIwbWFuYWdlcl9hZ2VudC5ydW4oJTIySWYlMjBMTE0lMjB0cmFpbmluZyUyMGNvbnRpbnVlcyUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUyQyUyMHdoYXQlMjB3b3VsZCUyMGJlJTIwdGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMGluJTIwR1clMjByZXF1aXJlZCUyMHRvJTIwcG93ZXIlMjB0aGUlMjBiaWdnZXN0JTIwdHJhaW5pbmclMjBydW5zJTIwYnklMjAyMDMwJTNGJTIwV2hhdCUyMHdvdWxkJTIwdGhhdCUyMGNvcnJlc3BvbmQlMjB0byUyQyUyMGNvbXBhcmVkJTIwdG8lMjBzb21lJTIwY291bnRyaWVzJTNGJTIwUGxlYXNlJTIwcHJvdmlkZSUyMGElMjBzb3VyY2UlMjBmb3IlMjBhbnklMjBudW1iZXJzJTIwdXNlZC4lMjIp",highlighted:'answer = manager_agent.run(<span class="hljs-string">&quot;If LLM training continues to scale up at the current rhythm until 2030, what would be the electric power in GW required to power the biggest training runs by 2030? What would that correspond to, compared to some countries? Please provide a source for any numbers used.&quot;</span>)',wrap:!1}}),P=new w({props:{code:"QmFzZWQlMjBvbiUyMGN1cnJlbnQlMjBncm93dGglMjBwcm9qZWN0aW9ucyUyMGFuZCUyMGVuZXJneSUyMGNvbnN1bXB0aW9uJTIwZXN0aW1hdGVzJTJDJTIwaWYlMjBMTE0lMjB0cmFpbmluZ3MlMjBjb250aW51ZSUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwJTBBY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUzQSUwQSUwQTEuJTIwVGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMHJlcXVpcmVkJTIwdG8lMjBwb3dlciUyMHRoZSUyMGJpZ2dlc3QlMjB0cmFpbmluZyUyMHJ1bnMlMjBieSUyMDIwMzAlMjB3b3VsZCUyMGJlJTIwYXBwcm94aW1hdGVseSUyMDMwMy43NCUyMEdXJTJDJTIwd2hpY2glMjAlMEF0cmFuc2xhdGVzJTIwdG8lMjBhYm91dCUyMDIlMkM2NjAlMkM3NjIlMjBHV2glMkZ5ZWFyLiUwQSUwQTIuJTIwQ29tcGFyaW5nJTIwdGhpcyUyMHRvJTIwY291bnRyaWVzJyUyMGVsZWN0cmljaXR5JTIwY29uc3VtcHRpb24lM0ElMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwZXF1aXZhbGVudCUyMHRvJTIwYWJvdXQlMjAzNCUyNSUyMG9mJTIwQ2hpbmEncyUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbi4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGV4Y2VlZCUyMHRoZSUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwSW5kaWElMjAoMTg0JTI1KSUyQyUyMFJ1c3NpYSUyMCgyNjclMjUpJTJDJTIwYW5kJTIwSmFwYW4lMjAoMjkxJTI1KS4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwbmVhcmx5JTIwOSUyMHRpbWVzJTIwdGhlJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwY291bnRyaWVzJTIwbGlrZSUyMEl0YWx5JTIwb3IlMjBNZXhpY28uJTBBJTBBMy4lMjBTb3VyY2UlMjBvZiUyMG51bWJlcnMlM0ElMEElMjAlMjAlMjAtJTIwVGhlJTIwaW5pdGlhbCUyMGVzdGltYXRlJTIwb2YlMjA1JTIwR1clMjBmb3IlMjBmdXR1cmUlMjBMTE0lMjB0cmFpbmluZyUyMGNvbWVzJTIwZnJvbSUyMEFXUyUyMENFTyUyME1hdHQlMjBHYXJtYW4uJTBBJTIwJTIwJTIwLSUyMFRoZSUyMGdyb3d0aCUyMHByb2plY3Rpb24lMjB1c2VkJTIwYSUyMENBR1IlMjBvZiUyMDc5LjgwJTI1JTIwZnJvbSUyMG1hcmtldCUyMHJlc2VhcmNoJTIwYnklMjBTcHJpbmdzLiUwQSUyMCUyMCUyMC0lMjBDb3VudHJ5JTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMGRhdGElMjBpcyUyMGZyb20lMjB0aGUlMjBVLlMuJTIwRW5lcmd5JTIwSW5mb3JtYXRpb24lMjBBZG1pbmlzdHJhdGlvbiUyQyUyMHByaW1hcmlseSUyMGZvciUyMHRoZSUyMHllYXIlMjAlMEEyMDIxLg==",highlighted:`Based <span class="hljs-keyword">on</span> current growth projections <span class="hljs-keyword">and</span> energy consumption estimates, <span class="hljs-keyword">if</span> LLM trainings <span class="hljs-keyword">continue</span> <span class="hljs-keyword">to</span> scale up <span class="hljs-keyword">at</span> <span class="hljs-keyword">the</span> 
current rhythm <span class="hljs-keyword">until</span> <span class="hljs-number">2030</span>:

<span class="hljs-number">1.</span> The electric power required <span class="hljs-keyword">to</span> power <span class="hljs-keyword">the</span> biggest training runs <span class="hljs-keyword">by</span> <span class="hljs-number">2030</span> would be approximately <span class="hljs-number">303.74</span> GW, which 
translates <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">2</span>,<span class="hljs-number">660</span>,<span class="hljs-number">762</span> GWh/<span class="hljs-built_in">year</span>.

<span class="hljs-number">2.</span> Comparing this <span class="hljs-keyword">to</span> countries&#x27; electricity consumption:
   - It would be equivalent <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">34</span>% <span class="hljs-keyword">of</span> China&#x27;s total electricity consumption.
   - It would exceed <span class="hljs-keyword">the</span> total electricity consumption <span class="hljs-keyword">of</span> India (<span class="hljs-number">184</span>%), Russia (<span class="hljs-number">267</span>%), <span class="hljs-keyword">and</span> Japan (<span class="hljs-number">291</span>%).
   - It would be nearly <span class="hljs-number">9</span> <span class="hljs-keyword">times</span> <span class="hljs-keyword">the</span> electricity consumption <span class="hljs-keyword">of</span> countries like Italy <span class="hljs-keyword">or</span> Mexico.

<span class="hljs-number">3.</span> Source <span class="hljs-keyword">of</span> numbers:
   - The initial estimate <span class="hljs-keyword">of</span> <span class="hljs-number">5</span> GW <span class="hljs-keyword">for</span> future LLM training comes <span class="hljs-keyword">from</span> AWS CEO Matt Garman.
   - The growth projection used a CAGR <span class="hljs-keyword">of</span> <span class="hljs-number">79.80</span>% <span class="hljs-keyword">from</span> market research <span class="hljs-keyword">by</span> Springs.
   - Country electricity consumption data <span class="hljs-keyword">is</span> <span class="hljs-keyword">from</span> <span class="hljs-keyword">the</span> U.S. Energy Information Administration, primarily <span class="hljs-keyword">for</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span> 
<span class="hljs-number">2021.</span>`,wrap:!1}}),ll=new fe({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/multiagents.mdx"}}),{c(){d=a("meta"),sl=n(),el=a("p"),nl=n(),i(u.$$.fragment),Ml=n(),i(m.$$.fragment),al=n(),C=a("p"),C.innerHTML=Ll,yl=n(),h=a("p"),h.textContent=zl,ol=n(),i(b.$$.fragment),il=n(),J=a("p"),J.textContent=Fl,pl=n(),T=a("p"),T.textContent=ql,Ul=n(),i(g.$$.fragment),rl=n(),f=a("p"),f.textContent=Pl,jl=n(),i(A.$$.fragment),cl=n(),I=a("p"),I.innerHTML=Dl,wl=n(),B=a("p"),B.innerHTML=Kl,dl=n(),i(k.$$.fragment),ul=n(),i(Z.$$.fragment),ml=n(),G=a("p"),G.innerHTML=Ol,Cl=n(),v=a("p"),v.innerHTML=le,hl=n(),S=a("p"),S.innerHTML=ee,bl=n(),i(W.$$.fragment),Jl=n(),V=a("p"),V.textContent=te,Tl=n(),i($.$$.fragment),gl=n(),i(Q.$$.fragment),fl=n(),_=a("p"),_.innerHTML=se,Al=n(),H=a("p"),H.textContent=ne,Il=n(),E=a("ul"),E.innerHTML=Me,Bl=n(),i(x.$$.fragment),kl=n(),R=a("p"),R.innerHTML=ae,Zl=n(),X=a("p"),X.innerHTML=ye,Gl=n(),N=a("p"),N.innerHTML=oe,vl=n(),Y=a("p"),Y.innerHTML=ie,Sl=n(),i(L.$$.fragment),Wl=n(),z=a("p"),z.textContent=pe,Vl=n(),i(F.$$.fragment),$l=n(),q=a("p"),q.textContent=Ue,Ql=n(),i(P.$$.fragment),_l=n(),D=a("p"),D.innerHTML=re,Hl=n(),K=a("p"),K.textContent=je,El=n(),O=a("p"),O.textContent=ce,xl=n(),i(ll.$$.fragment),Rl=n(),tl=a("p"),this.h()},l(l){const e=Je("svelte-u9bgzb",document.head);d=y(e,"META",{name:!0,content:!0}),e.forEach(t),sl=M(l),el=y(l,"P",{}),we(el).forEach(t),nl=M(l),p(u.$$.fragment,l),Ml=M(l),p(m.$$.fragment,l),al=M(l),C=y(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-45abwn"&&(C.innerHTML=Ll),yl=M(l),h=y(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1f6nia6"&&(h.textContent=zl),ol=M(l),p(b.$$.fragment,l),il=M(l),J=y(l,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1occiln"&&(J.textContent=Fl),pl=M(l),T=y(l,"P",{"data-svelte-h":!0}),o(T)!=="svelte-ofrdjq"&&(T.textContent=ql),Ul=M(l),p(g.$$.fragment,l),rl=M(l),f=y(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-gkovew"&&(f.textContent=Pl),jl=M(l),p(A.$$.fragment,l),cl=M(l),I=y(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-16hajs3"&&(I.innerHTML=Dl),wl=M(l),B=y(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1faawbb"&&(B.innerHTML=Kl),dl=M(l),p(k.$$.fragment,l),ul=M(l),p(Z.$$.fragment,l),ml=M(l),G=y(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1ul1u0f"&&(G.innerHTML=Ol),Cl=M(l),v=y(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-n7spa8"&&(v.innerHTML=le),hl=M(l),S=y(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1ms2uj2"&&(S.innerHTML=ee),bl=M(l),p(W.$$.fragment,l),Jl=M(l),V=y(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-hbvg5t"&&(V.textContent=te),Tl=M(l),p($.$$.fragment,l),gl=M(l),p(Q.$$.fragment,l),fl=M(l),_=y(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-5768lo"&&(_.innerHTML=se),Al=M(l),H=y(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-noa5rw"&&(H.textContent=ne),Il=M(l),E=y(l,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-cg2xmz"&&(E.innerHTML=Me),Bl=M(l),p(x.$$.fragment,l),kl=M(l),R=y(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-fbxoqx"&&(R.innerHTML=ae),Zl=M(l),X=y(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-wtigy3"&&(X.innerHTML=ye),Gl=M(l),N=y(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1btrnf1"&&(N.innerHTML=oe),vl=M(l),Y=y(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1ezr7oa"&&(Y.innerHTML=ie),Sl=M(l),p(L.$$.fragment,l),Wl=M(l),z=y(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-90lagx"&&(z.textContent=pe),Vl=M(l),p(F.$$.fragment,l),$l=M(l),q=y(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-tvhx1x"&&(q.textContent=Ue),Ql=M(l),p(P.$$.fragment,l),_l=M(l),D=y(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-19s7crl"&&(D.innerHTML=re),Hl=M(l),K=y(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-ollz3q"&&(K.textContent=je),El=M(l),O=y(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-rvy62f"&&(O.textContent=ce),xl=M(l),p(ll.$$.fragment,l),Rl=M(l),tl=y(l,"P",{}),we(tl).forEach(t),this.h()},h(){de(d,"name","hf:doc:metadata"),de(d,"content",Ie)},m(l,e){Te(document.head,d),s(l,sl,e),s(l,el,e),s(l,nl,e),U(u,l,e),s(l,Ml,e),U(m,l,e),s(l,al,e),s(l,C,e),s(l,yl,e),s(l,h,e),s(l,ol,e),U(b,l,e),s(l,il,e),s(l,J,e),s(l,pl,e),s(l,T,e),s(l,Ul,e),U(g,l,e),s(l,rl,e),s(l,f,e),s(l,jl,e),U(A,l,e),s(l,cl,e),s(l,I,e),s(l,wl,e),s(l,B,e),s(l,dl,e),U(k,l,e),s(l,ul,e),U(Z,l,e),s(l,ml,e),s(l,G,e),s(l,Cl,e),s(l,v,e),s(l,hl,e),s(l,S,e),s(l,bl,e),U(W,l,e),s(l,Jl,e),s(l,V,e),s(l,Tl,e),U($,l,e),s(l,gl,e),U(Q,l,e),s(l,fl,e),s(l,_,e),s(l,Al,e),s(l,H,e),s(l,Il,e),s(l,E,e),s(l,Bl,e),U(x,l,e),s(l,kl,e),s(l,R,e),s(l,Zl,e),s(l,X,e),s(l,Gl,e),s(l,N,e),s(l,vl,e),s(l,Y,e),s(l,Sl,e),U(L,l,e),s(l,Wl,e),s(l,z,e),s(l,Vl,e),U(F,l,e),s(l,$l,e),s(l,q,e),s(l,Ql,e),U(P,l,e),s(l,_l,e),s(l,D,e),s(l,Hl,e),s(l,K,e),s(l,El,e),s(l,O,e),s(l,xl,e),U(ll,l,e),s(l,Rl,e),s(l,tl,e),Xl=!0},p:me,i(l){Xl||(r(u.$$.fragment,l),r(m.$$.fragment,l),r(b.$$.fragment,l),r(g.$$.fragment,l),r(A.$$.fragment,l),r(k.$$.fragment,l),r(Z.$$.fragment,l),r(W.$$.fragment,l),r($.$$.fragment,l),r(Q.$$.fragment,l),r(x.$$.fragment,l),r(L.$$.fragment,l),r(F.$$.fragment,l),r(P.$$.fragment,l),r(ll.$$.fragment,l),Xl=!0)},o(l){j(u.$$.fragment,l),j(m.$$.fragment,l),j(b.$$.fragment,l),j(g.$$.fragment,l),j(A.$$.fragment,l),j(k.$$.fragment,l),j(Z.$$.fragment,l),j(W.$$.fragment,l),j($.$$.fragment,l),j(Q.$$.fragment,l),j(x.$$.fragment,l),j(L.$$.fragment,l),j(F.$$.fragment,l),j(P.$$.fragment,l),j(ll.$$.fragment,l),Xl=!1},d(l){l&&(t(sl),t(el),t(nl),t(Ml),t(al),t(C),t(yl),t(h),t(ol),t(il),t(J),t(pl),t(T),t(Ul),t(rl),t(f),t(jl),t(cl),t(I),t(wl),t(B),t(dl),t(ul),t(ml),t(G),t(Cl),t(v),t(hl),t(S),t(bl),t(Jl),t(V),t(Tl),t(gl),t(fl),t(_),t(Al),t(H),t(Il),t(E),t(Bl),t(kl),t(R),t(Zl),t(X),t(Gl),t(N),t(vl),t(Y),t(Sl),t(Wl),t(z),t(Vl),t($l),t(q),t(Ql),t(_l),t(D),t(Hl),t(K),t(El),t(O),t(xl),t(Rl),t(tl)),t(d),c(u,l),c(m,l),c(b,l),c(g,l),c(A,l),c(k,l),c(Z,l),c(W,l),c($,l),c(Q,l),c(x,l),c(L,l),c(F,l),c(P,l),c(ll,l)}}}const Ie='{"title":"Orchestrate a multi-agent system 🤖🤝🤖","local":"orchestrate-a-multi-agent-system-","sections":[{"title":"🔍 Create a web search tool","local":"-create-a-web-search-tool","sections":[],"depth":2},{"title":"Build our multi-agent system 🤖🤝🤖","local":"build-our-multi-agent-system-","sections":[],"depth":2}],"depth":1}';function Be(Yl){return Ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends he{constructor(d){super(),be(this,d,Be,Ae,ue,{})}}export{We as component};
