import{s as Zp,o as Ap,n as _}from"../chunks/scheduler.25b97de1.js";import{S as kp,i as Qp,g as o,s as a,r as M,A as Wp,h as i,f as l,c as n,j as Bp,u as r,x as p,k as Np,y as qp,a as s,v as c,d as y,t as u,w as m,m as Vp,n as _p}from"../chunks/index.d9030fc9.js";import{T as v}from"../chunks/Tip.baa67368.js";import{C as J}from"../chunks/CodeBlock.e6cd0d95.js";import{H as w,E as Rp}from"../chunks/EditOnGithub.91d95064.js";function Sp(b){let h,U=`The default behaviour of <code>TextGenerationPipeline</code> is to set <code>add_generation_prompt=True</code> so that it starts a new
message. However, if the final message in the input chat has the “assistant” role, it will assume that this message is
a prefill and switch to <code>continue_final_message=True</code> instead, because most models do not support multiple
consecutive assistant messages. You can override this behaviour by explicitly passing the <code>continue_final_message</code>
argument when calling the pipeline.`;return{c(){h=o("p"),h.innerHTML=U},l(d){h=i(d,"P",{"data-svelte-h":!0}),p(h)!=="svelte-95bbxf"&&(h.innerHTML=U)},m(d,T){s(d,h,T)},p:_,d(d){d&&l(h)}}}function zp(b){let h,U=`By default, some tokenizers add special tokens like <code>&lt;bos&gt;</code> and <code>&lt;eos&gt;</code> to text they tokenize. Chat templates should
already include all the special tokens they need, and so additional special tokens will often be incorrect or
duplicated, which will hurt model performance.`,d,T,C=`Therefore, if you format text with <code>apply_chat_template(tokenize=False)</code>, you should set the argument
<code>add_special_tokens=False</code> when you tokenize that text later. If you use <code>apply_chat_template(tokenize=True)</code>, you don’t need to worry about this!`;return{c(){h=o("p"),h.innerHTML=U,d=a(),T=o("p"),T.innerHTML=C},l(I){h=i(I,"P",{"data-svelte-h":!0}),p(h)!=="svelte-148xjo3"&&(h.innerHTML=U),d=n(I),T=i(I,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1hgzema"&&(T.innerHTML=C)},m(I,g){s(I,h,g),s(I,d,g),s(I,T,g)},p:_,d(I){I&&(l(h),l(d),l(T))}}}function Ep(b){let h,U=`The output format above is specific to the <code>Hermes-2-Pro</code> model we’re using in this example. Other models may emit different
tool call formats, and you may need to do some manual parsing at this step. For example, <code>Llama-3.1</code> models will emit
slightly different JSON, with <code>parameters</code> instead of <code>arguments</code>. Regardless of the format the model outputs, you
should add the tool call to the conversation in the format below, with <code>tool_calls</code>, <code>function</code> and <code>arguments</code> keys.`;return{c(){h=o("p"),h.innerHTML=U},l(d){h=i(d,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1wfdwuk"&&(h.innerHTML=U)},m(d,T){s(d,h,T)},p:_,d(d){d&&l(h)}}}function Xp(b){let h,U=`If you’re familiar with the OpenAI API, you should pay attention to an important difference here - the <code>tool_call</code> is
a dict, but in the OpenAI API it’s a JSON string. Passing a string may cause errors or strange model behaviour!`;return{c(){h=o("p"),h.innerHTML=U},l(d){h=i(d,"P",{"data-svelte-h":!0}),p(h)!=="svelte-fq11ea"&&(h.innerHTML=U)},m(d,T){s(d,h,T)},p:_,d(d){d&&l(h)}}}function Hp(b){let h,U=`Some model architectures, notably Mistral/Mixtral, also require a <code>tool_call_id</code> here, which should be
9 randomly-generated alphanumeric characters, and assigned to the <code>id</code> key of the tool call
dictionary. The same key should also be assigned to the <code>tool_call_id</code> key of the tool response dictionary below, so
that tool calls can be matched to tool responses. So, for Mistral/Mixtral models, the code above would be:`,d,T,C,I,g="and",G,f,$;return T=new J({props:{code:"dG9vbF9jYWxsX2lkJTIwJTNEJTIwJTIyOUFlM2JEYzJGJTIyJTIwJTIwJTIzJTIwUmFuZG9tJTIwSUQlMkMlMjA5JTIwYWxwaGFudW1lcmljJTIwY2hhcmFjdGVycyUwQXRvb2xfY2FsbCUyMCUzRCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF90ZW1wZXJhdHVyZSUyMiUyQyUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyUGFyaXMlMkMlMjBGcmFuY2UlMjIlMkMlMjAlMjJ1bml0JTIyJTNBJTIwJTIyY2Vsc2l1cyUyMiU3RCU3RCUwQW1lc3NhZ2VzLmFwcGVuZCglN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIydG9vbF9jYWxscyUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUyMCUyMmlkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call_id = <span class="hljs-string">&quot;9Ae3bDc2F&quot;</span>  <span class="hljs-comment"># Random ID, 9 alphanumeric characters</span>
tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),f=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIydG9vbF9jYWxsX2lkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;tool_call_id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),{c(){h=o("p"),h.innerHTML=U,d=a(),M(T.$$.fragment),C=a(),I=o("p"),I.textContent=g,G=a(),M(f.$$.fragment)},l(j){h=i(j,"P",{"data-svelte-h":!0}),p(h)!=="svelte-70hqps"&&(h.innerHTML=U),d=n(j),r(T.$$.fragment,j),C=n(j),I=i(j,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1qlona5"&&(I.textContent=g),G=n(j),r(f.$$.fragment,j)},m(j,x){s(j,h,x),s(j,d,x),c(T,j,x),s(j,C,x),s(j,I,x),s(j,G,x),c(f,j,x),$=!0},p:_,i(j){$||(y(T.$$.fragment,j),y(f.$$.fragment,j),$=!0)},o(j){u(T.$$.fragment,j),u(f.$$.fragment,j),$=!1},d(j){j&&(l(h),l(d),l(C),l(I),l(G)),m(T,j),m(f,j)}}}function Yp(b){let h,U="The <code>documents</code> input for retrieval-augmented generation is not widely supported, and many models have chat templates which simply ignore this input.",d,T,C="To verify if a model supports the <code>documents</code> input, you can read its model card, or <code>print(tokenizer.chat_template)</code> to see if the <code>documents</code> key is used anywhere.",I,g,G='One model class that does support it, though, is Cohere’s <a href="https://huggingface.co/CohereForAI/c4ai-command-r-08-2024" rel="nofollow">Command-R</a> and <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus-08-2024" rel="nofollow">Command-R+</a>, through their <code>rag</code> chat template. You can see additional examples of grounded generation using this feature in their model cards.';return{c(){h=o("p"),h.innerHTML=U,d=a(),T=o("p"),T.innerHTML=C,I=a(),g=o("p"),g.innerHTML=G},l(f){h=i(f,"P",{"data-svelte-h":!0}),p(h)!=="svelte-bl710l"&&(h.innerHTML=U),d=n(f),T=i(f,"P",{"data-svelte-h":!0}),p(T)!=="svelte-qpz2lz"&&(T.innerHTML=C),I=n(f),g=i(f,"P",{"data-svelte-h":!0}),p(g)!=="svelte-kg7zp3"&&(g.innerHTML=G)},m(f,$){s(f,h,$),s(f,d,$),s(f,T,$),s(f,I,$),s(f,g,$)},p:_,d(f){f&&(l(h),l(d),l(T),l(I),l(g))}}}function Fp(b){let h;return{c(){h=Vp(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(U){h=_p(U,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(U,d){s(U,h,d)},d(U){U&&l(h)}}}function Lp(b){let h,U=`The easiest way to get started with writing Jinja templates is to take a look at some existing ones. You can use
<code>print(tokenizer.chat_template)</code> for any chat model to see what template it’s using. In general, models that support tool use have
much more complex templates than other models - so when you’re just getting started, they’re probably a bad example
to learn from! You can also take a look at the
<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#synopsis" rel="nofollow">Jinja documentation</a> for details
of general Jinja formatting and syntax.`;return{c(){h=o("p"),h.innerHTML=U},l(d){h=i(d,"P",{"data-svelte-h":!0}),p(h)!=="svelte-qy60pj"&&(h.innerHTML=U)},m(d,T){s(d,h,T)},p:_,d(d){d&&l(h)}}}function Pp(b){let h,U=`You can actually pass any <code>kwarg</code> to <code>apply_chat_template</code>, and it will be accessible inside the template as a variable. In general,
we recommend trying to stick to the core variables above, as it will make your model harder to use if users have
to write custom code to pass model-specific <code>kwargs</code>. However, we’re aware that this field moves quickly, so if you
have a new use-case that doesn’t fit in the core API, feel free to use a new <code>kwarg</code> for it! If a new <code>kwarg</code>
becomes common we may promote it into the core API and create a standard, documented format for it.`;return{c(){h=o("p"),h.innerHTML=U},l(d){h=i(d,"P",{"data-svelte-h":!0}),p(h)!=="svelte-cvlh0x"&&(h.innerHTML=U)},m(d,T){s(d,h,T)},p:_,d(d){d&&l(h)}}}function Dp(b){let h,U,d,T,C,I,g,G,f,$=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,j,x,Go=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,ls,R,vo="Let’s make this concrete with a quick example using the <code>mistralai/Mistral-7B-Instruct-v0.1</code> model:",ss,S,as,z,Bo=`Notice how the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!), and the entire chat is condensed into a single string.
If we use <code>tokenize=True</code>, which is the default setting, that string will also be tokenized for us.`,ns,E,No="Now, try the same code, but swap in the <code>HuggingFaceH4/zephyr-7b-beta</code> model instead, and you should get:",os,X,is,H,Zo=`Both Zephyr and Mistral-Instruct were fine-tuned from the same base model, <code>Mistral-7B-v0.1</code>. However, they were trained
with totally different chat formats. Without chat templates, you would have to write manual formatting code for each
model, and it’s very easy to make minor errors that hurt performance! Chat templates handle the details of formatting
for you, allowing you to write universal code that works for any model.`,ps,Y,Ms,F,Ao=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> method. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,rs,L,ko="Here’s an example of preparing input for <code>model.generate()</code>, using <code>Zephyr</code> again:",cs,P,ys,D,Qo="This will yield a string in the input format that Zephyr expects.",us,K,ms,O,Wo="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",hs,tt,ds,et,qo="This will yield:",Js,lt,Ts,st,Vo="Arr, ‘twas easy after all!",Us,at,js,nt,_o=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/pr_30530/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,ws,ot,fs,it,Is,pt,Ro=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,gs,Mt,bs,rt,So=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Cs,ct,xs,yt,zo="Here’s what this will look like without a generation prompt, for a model that uses standard “ChatML” formatting:",$s,ut,Gs,mt,Eo="And here’s what it looks like <strong>with</strong> a generation prompt:",vs,ht,Bs,dt,Xo=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,Ns,Jt,Ho=`Not all models require generation prompts. Some models, like LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Zs,Tt,As,Ut,Yo=`When passing a list of messages to <code>apply_chat_template</code> or <code>TextGenerationPipeline</code>, you can choose
to format the chat so the model will continue the final message in the chat instead of starting a new one. This is done
by removing any end-of-sequence tokens that indicate the end of the final message, so that the model will simply
extend the final message when it begins to generate text. This is useful for “prefilling” the model’s response.`,ks,jt,Fo="Here’s an example:",Qs,wt,Ws,ft,Lo=`The model will generate text that continues the JSON string, rather than starting a new message. This approach
can be very useful for improving the accuracy of the model’s instruction-following when you know how you want
it to start its replies.`,qs,It,Po=`Because <code>add_generation_prompt</code> adds the tokens that start a new message, and <code>continue_final_message</code> removes any
end-of-message tokens from the final message, it does not make sense to use them together. As a result, you’ll
get an error if you try!`,Vs,B,_s,gt,Rs,bt,Do=`Yes! This is a good way to ensure that the chat template matches the tokens the model sees during training.
We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,Ss,Ct,zs,xt,Ko="And we get:",Es,$t,Xs,Gt,Oo="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",Hs,N,Ys,vt,Fs,Bt,ti=`The only argument that <code>apply_chat_template</code> requires is <code>messages</code>. However, you can pass any keyword
argument to <code>apply_chat_template</code> and it will be accessible inside the template. This gives you a lot of freedom to use
chat templates for many things. There are no restrictions on the names or the format of these arguments - you can pass
strings, lists, dicts or whatever else you want.`,Ls,Nt,ei=`That said, there are some common use-cases for these extra arguments,
such as passing tools for function calling, or documents for retrieval-augmented generation. In these common cases,
we have some opinionated recommendations about what the names and formats of these arguments should be, which are
described in the sections below. We encourage model authors to make their chat templates compatible with this format,
to make it easy to transfer tool-calling code between models.`,Ps,Zt,Ds,At,li=`“Tool use” LLMs can choose to call functions as external tools before generating an answer. When passing tools
to a tool-use model, you can simply pass a list of functions to the <code>tools</code> argument:`,Ks,kt,Os,Qt,si=`In order for this to work correctly, you should write your functions in the format above, so that they can be parsed
correctly as tools. Specifically, you should follow these rules:`,ta,Wt,ai=`<li>The function should have a descriptive name</li> <li>Every argument must have a type hint</li> <li>The function must have a docstring in the standard Google style (in other words, an initial function description<br/>
followed by an <code>Args:</code> block that describes the arguments, unless the function does not have any arguments.</li> <li>Do not include types in the <code>Args:</code> block. In other words, write <code>a: The first number to multiply</code>, not
<code>a (int): The first number to multiply</code>. Type hints should go in the function header instead.</li> <li>The function can have a return type and a <code>Returns:</code> block in the docstring. However, these are optional
because most tool-use models ignore them.</li>`,ea,qt,la,Vt,ni=`The sample code above is enough to list the available tools for your model, but what happens if it wants to actually use
one? If that happens, you should:`,sa,_t,oi="<li>Parse the model’s output to get the tool name(s) and arguments.</li> <li>Add the model’s tool call(s) to the conversation.</li> <li>Call the corresponding function(s) with those arguments.</li> <li>Add the result(s) to the conversation</li>",aa,Rt,na,St,ii=`Let’s walk through a tool use example, step by step. For this example, we will use an 8B <code>Hermes-2-Pro</code> model,
as it is one of the highest-performing tool-use models in its size category at the time of writing. If you have the
memory, you can consider using a larger model instead like <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">Command-R</a>
or <a href="https://huggingface.co/mistralai/Mixtral-8x22B-Instruct-v0.1" rel="nofollow">Mixtral-8x22B</a>, both of which also support tool use
and offer even stronger performance.`,oa,zt,pi="First, let’s load our model and tokenizer:",ia,Et,pa,Xt,Mi="Next, let’s define a list of tools:",Ma,Ht,ra,Yt,ri="Now, let’s set up a conversation for our bot:",ca,Ft,ya,Lt,ci="Now, let’s apply the chat template and generate a response:",ua,Pt,ma,Dt,yi="And we get:",ha,Kt,da,Ot,ui=`The model has called the function with valid arguments, in the format requested by the function docstring. It has
inferred that we’re most likely referring to the Paris in France, and it remembered that, as the home of SI units,
the temperature in France should certainly be displayed in Celsius.`,Ja,Z,Ta,te,mi="Next, let’s append the model’s tool call to the conversation.",Ua,ee,ja,A,wa,le,hi=`Now that we’ve added the tool call to the conversation, we can call the function and append the result to the
conversation. Since we’re just using a dummy function for this example that always returns 22.0, we can just append
that result directly.`,fa,se,Ia,k,ga,ae,di="Finally, let’s let the assistant read the function outputs and continue chatting with the user:",ba,ne,Ca,oe,Ji="And we get:",xa,ie,$a,pe,Ti=`Although this was a simple demo with dummy tools and a single call, the same technique works with
multiple real tools and longer conversations. This can be a powerful way to extend the capabilities of conversational
agents with real-time information, computational tools like calculators, or access to large databases.`,Ga,Me,va,re,Ui=`Each function you pass to the <code>tools</code> argument of <code>apply_chat_template</code> is converted into a
<a href="https://json-schema.org/learn/getting-started-step-by-step" rel="nofollow">JSON schema</a>. These schemas
are then passed to the model chat template. In other words, tool-use models do not see your functions directly, and they
never see the actual code inside them. What they care about is the function <strong>definitions</strong> and the <strong>arguments</strong> they
need to pass to them - they care about what the tools do and how to use them, not how they work! It is up to you
to read their outputs, detect if they have requested to use a tool, pass their arguments to the tool function, and
return the response in the chat.`,Ba,ce,ji=`Generating JSON schemas to pass to the template should be automatic and invisible as long as your functions
follow the specification above, but if you encounter problems, or you simply want more control over the conversion,
you can handle the conversion manually. Here is an example of a manual schema conversion.`,Na,ye,Za,ue,wi="This will yield:",Aa,me,ka,he,fi=`If you wish, you can edit these schemas, or even write them from scratch yourself without using <code>get_json_schema</code> at
all. JSON schemas can be passed directly to the <code>tools</code> argument of
<code>apply_chat_template</code> - this gives you a lot of power to define precise schemas for more complex functions. Be careful,
though - the more complex your schemas, the more likely the model is to get confused when dealing with them! We
recommend simple function signatures where possible, keeping arguments (and especially complex, nested arguments)
to a minimum.`,Qa,de,Ii="Here is an example of defining schemas by hand, and passing them directly to <code>apply_chat_template</code>:",Wa,Je,qa,Te,Va,Ue,gi=`“Retrieval-augmented generation” or “RAG” LLMs can search a corpus of documents for information before responding
to a query. This allows models to vastly expand their knowledge base beyond their limited context size. Our
recommendation for RAG models is that their template
should accept a <code>documents</code> argument. This should be a list of documents, where each “document”
is a single dict with <code>title</code> and <code>contents</code> keys, both of which are strings. Because this format is much simpler
than the JSON schemas used for tools, no helper functions are necessary.`,_a,je,bi="Here’s an example of a RAG template in action:",Ra,we,Sa,Q,za,fe,Ea,Ie,Ci=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at a <code>Zephyr</code> chat template, though note this
one is a little simplified from the actual one!`,Xa,ge,Ha,be,xi=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,Ya,Ce,Fa,xe,$i="Effectively, the template does three things:",La,$e,Gi=`<li>For each message, print the role enclosed in <code>&lt;|</code> and <code>|&gt;</code>, like <code>&lt;|user|&gt;</code> or <code>&lt;|assistant|&gt;</code>.</li> <li>Next, print the content of the message, followed by the end-of-sequence token.</li> <li>Finally, if <code>add_generation_prompt</code> is set, print the assistant token, so that the model knows to start generating
an assistant response.</li>`,Pa,Ge,vi=`This is a pretty simple template but Jinja gives you a lot of flexibility to do more complex things! Let’s see a Jinja
template that can format inputs similarly to the way LLaMA formats them (note that the real LLaMA template includes
handling for default system messages and slightly different system message handling in general - don’t use this one
in your actual code!)`,Da,ve,Ka,Be,Bi=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens like
<code>[INST]</code> and <code>[/INST]</code> based on the role of each message. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,Oa,Ne,tn,Ze,en,Ae,Ni=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,ln,ke,sn,Qe,Zi=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,an,We,nn,qe,Ai=`The method <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/pr_30530/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/pr_30530/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,on,W,pn,Ve,Mn,_e,ki=`Some models use different templates for different use cases. For example, they might use one template for normal chat
and another for tool-use, or retrieval-augmented generation. In these cases, <code>tokenizer.chat_template</code> is a dictionary.
This can cause some confusion, and where possible, we recommend using a single template for all use-cases. You can use
Jinja statements like <code>if tools is defined</code> and <code>{% macro %}</code> definitions to easily wrap multiple code paths in a
single template.`,rn,Re,Qi=`When a tokenizer has multiple templates, <code>tokenizer.chat_template</code> will be a <code>dict</code>, where each key is the name
of a template. The <code>apply_chat_template</code> method has special handling for certain template names: Specifically, it will
look for a template named <code>default</code> in most cases, and will raise an error if it can’t find one. However, if a template
named <code>tool_use</code> exists when the user has passed a <code>tools</code> argument, it will use that instead. To access templates
with other names, pass the name of the template you want to the <code>chat_template</code> argument of
<code>apply_chat_template()</code>.`,cn,Se,Wi=`We find that this can be a bit confusing for users, though - so if you’re writing a template yourself, we recommend
trying to put it all in a single template where possible!`,yn,ze,un,Ee,qi=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,mn,Xe,Vi=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,hn,He,dn,Ye,_i=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,Jn,Fe,Tn,Le,Ri=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,Un,Pe,jn,De,Si=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/pr_30530/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,wn,Ke,fn,Oe,zi=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,In,tl,Ei=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,gn,el,Xi=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,bn,ll,Cn,q,xn,sl,Hi=`Jinja templates in <code>transformers</code> are identical to Jinja templates elsewhere. The main thing to know is that
the conversation history will be accessible inside your template as a variable called <code>messages</code>.<br/>
You will be able to access <code>messages</code> in your template just like you can in Python, which means you can loop over
it with <code>{% for message in messages %}</code> or access individual messages with <code>{{ messages[0] }}</code>, for example.`,$n,al,Yi="You can also use the following tips to write clean, efficient Jinja templates:",Gn,nl,vn,ol,Fi=`By default, Jinja will print any whitespace that comes before or after a block. This can be a problem for chat
templates, which generally want to be very precise with whitespace! To avoid this, we strongly recommend writing
your templates like this:`,Bn,il,Nn,pl,Li="rather than like this:",Zn,Ml,An,rl,Pi=`Adding <code>-</code> will strip any whitespace that comes before the block. The second example looks innocent, but the newline
and indentation may end up being included in the output, which is probably not what you want!`,kn,cl,Qn,yl,Di=`Inside your template, you will have access several special variables. The most important of these is <code>messages</code>,
which contains the chat history as a list of message dicts. However, there are several others. Not every
variable will be used in every template. The most common other variables are:`,Wn,ul,Ki="<li><code>tools</code> contains a list of tools in JSON schema format. Will be <code>None</code> or undefined if no tools are passed.</li> <li><code>documents</code> contains a list of documents in the format <code>{&quot;title&quot;: &quot;Title&quot;, &quot;contents&quot;: &quot;Contents&quot;}</code>, used for retrieval-augmented generation. Will be <code>None</code> or undefined if no documents are passed.</li> <li><code>add_generation_prompt</code> is a bool that is <code>True</code> if the user has requested a generation prompt, and <code>False</code> otherwise. If this is set, your template should add the header for an assistant message to the end of the conversation. If your model doesn’t have a specific header for assistant messages, you can ignore this flag.</li> <li><strong>Special tokens</strong> like <code>bos_token</code> and <code>eos_token</code>. These are extracted from <code>tokenizer.special_tokens_map</code>. The exact tokens available inside each template will differ depending on the parent tokenizer.</li>",qn,V,Vn,ml,_n,hl,Oi="There is also a short list of callable functions available to you inside your templates. These are:",Rn,dl,tp=`<li><code>raise_exception(msg)</code>: Raises a <code>TemplateException</code>. This is useful for debugging, and for telling users when they’re
doing something that your template doesn’t support.</li> <li><code>strftime_now(format_str)</code>: Equivalent to <code>datetime.now().strftime(format_str)</code> in Python. This is used for getting
the current date/time in a specific format, which is sometimes included in system messages.</li>`,Sn,Jl,zn,Tl,ep=`There are multiple implementations of Jinja in various languages. They generally have the same syntax,
but a key difference is that when you’re writing a template in Python you can use Python methods, such as
<code>.lower()</code> on strings or <code>.items()</code> on dicts. This will break if someone tries to use your template on a non-Python
implementation of Jinja. Non-Python implementations are particularly common in deployment environments, where JS
and Rust are very popular.`,En,Ul,lp=`Don’t panic, though! There are a few easy changes you can make to your templates to ensure they’re compatible across
all implementations of Jinja:`,Xn,jl,sp=`<li>Replace Python methods with Jinja filters. These usually have the same name, for example <code>string.lower()</code> becomes
<code>string|lower</code>, and <code>dict.items()</code> becomes <code>dict|items</code>. One notable change is that <code>string.strip()</code> becomes <code>string|trim</code>.
See the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#builtin-filters" rel="nofollow">list of built-in filters</a>
in the Jinja documentation for more.</li> <li>Replace <code>True</code>, <code>False</code> and <code>None</code>, which are Python-specific, with <code>true</code>, <code>false</code> and <code>none</code>.</li> <li>Directly rendering a dict or list may give different results in other implementations (for example, string entries
might change from single-quoted to double-quoted). Adding the <code>tojson</code> filter can help to ensure consistency here.</li>`,Hn,wl,Yn,fl,ap=`We mentioned above that <code>add_generation_prompt</code> is a special variable that will be accessible inside your template,
and is controlled by the user setting the <code>add_generation_prompt</code> flag. If your model expects a header for
assistant messages, then your template must support adding the header when <code>add_generation_prompt</code> is set.`,Fn,Il,np="Here is an example of a template that formats messages ChatML-style, with generation prompt support:",Ln,gl,Pn,bl,op=`The exact content of the assistant header will depend on your specific model, but it should always be <strong>the string
that represents the start of an assistant message</strong>, so that if the user applies your template with
<code>add_generation_prompt=True</code> and then generates text, the model will write an assistant response. Also note that some
models do not need a generation prompt, because assistant messages always begin immediately after user messages.
This is particularly common for LLaMA and Mistral models, where assistant messages begin immediately after the <code>[/INST]</code>
token that ends user messages. In these cases, the template can ignore the <code>add_generation_prompt</code> flag.`,Dn,Cl,ip=`Generation prompts are important! If your model requires a generation prompt but it is not set in the template, then
model generations will likely be severely degraded, or the model may display unusual behaviour like continuing
the final user message!`,Kn,xl,On,$l,pp=`When this feature was introduced, most templates were quite small, the Jinja equivalent of a “one-liner” script.
However, with new models and features like tool-use and RAG, some templates can be 100 lines long or more. When
writing templates like these, it’s a good idea to write them in a separate file, using a text editor. You can easily
extract a chat template to a file:`,to,Gl,eo,vl,Mp="Or load the edited template back into the tokenizer:",lo,Bl,so,Nl,rp=`As an added bonus, when you write a long, multi-line template in a separate file, line numbers in that file will
exactly correspond to line numbers in template parsing or execution errors. This will make it much easier to
identify the source of issues.`,ao,Zl,no,Al,cp=`Although chat templates do not enforce a specific API for tools (or for anything, really), we recommend
template authors try to stick to a standard API where possible. The whole point of chat templates is to allow code
to be transferable across models, so deviating from the standard tools API means users will have to write
custom code to use tools with your model. Sometimes it’s unavoidable, but often with clever templating you can
make the standard API work!`,oo,kl,yp="Below, we’ll list the elements of the standard API, and give tips on writing templates that will work well with it.",io,Ql,po,Wl,up=`Your template should expect that the variable <code>tools</code> will either be null (if no tools are passed), or is a list
of JSON schema dicts. Our chat template methods allow users to pass tools as either JSON schema or Python functions, but when
functions are passed, we automatically generate JSON schema and pass that to your template. As a result, the
<code>tools</code> variable that your template receives will always be a list of JSON schema. Here is
a sample tool JSON schema:`,Mo,ql,ro,Vl,mp=`And here is some example code for handling tools in your chat template. Remember, this is just an example for a
specific format - your model will probably need different formatting!`,co,_l,yo,Rl,hp=`The specific tokens and tool descriptions your template renders should of course be chosen to match the ones your model
was trained with. There is no requirement that your <strong>model</strong> understands JSON schema input, only that your template can translate
JSON schema into your model’s format. For example, <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus-08-2024" rel="nofollow">Command-R</a>
was trained with tools defined using Python function headers, but the Command-R tool template accepts JSON schema,
converts types internally and renders the input tools as Python headers. You can do a lot with templates!`,uo,Sl,mo,zl,dp=`Tool calls, if present, will be a list attached to a message with the “assistant” role. Note that <code>tool_calls</code> is
always a list, even though most tool-calling models only support single tool calls at a time, which means
the list will usually only have a single element. Here is a sample message dict containing a tool call:`,ho,El,Jo,Xl,Jp="And a common pattern for handling them would be something like this:",To,Hl,Uo,Yl,Tp="Again, you should render the tool call with the formatting and special tokens that your model expects.",jo,Fl,wo,Ll,Up=`Tool responses have a simple format: They are a message dict with the “tool” role, a “name” key giving the name
of the called function, and a “content” key containing the result of the tool call. Here is a sample tool response:`,fo,Pl,Io,Dl,jp=`You don’t need to use all of the keys in the tool response. For example, if your model doesn’t expect the function
name to be included in the tool response, then rendering it can be as simple as:`,go,Kl,bo,Ol,wp=`Again, remember that the actual formatting and special tokens are model-specific - you should take a lot of care
to ensure that tokens, whitespace and everything else exactly match the format your model was trained with!`,Co,ts,xo,es,$o;return C=new w({props:{title:"Chat Templates",local:"chat-templates",headingTag:"h1"}}),g=new w({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),S=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),X=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQUknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBSSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTNDJTJGcyUzRQ==",highlighted:`&lt;|user|&gt;
Hello, how are you?&lt;/s&gt;
&lt;|assistant|&gt;
I&#x27;m doing great. How can I help you today?&lt;/s&gt;
&lt;|user|&gt;
I&#x27;d like to show off how chat templating works!&lt;/s&gt;`,wrap:!1}}),Y=new w({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),P=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),K=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),tt=new J({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),lt=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),at=new w({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),ot=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),it=new J({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),Mt=new w({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),ct=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),ut=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),ht=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),Tt=new w({props:{title:"What does “continue_final_message” do?",local:"what-does-continuefinalmessage-do",headingTag:"h2"}}),wt=new J({props:{code:"Y2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJyU3QiUyMm5hbWUlMjIlM0ElMjAlMjInJTdEJTJDJTBBJTVEJTBBJTBBZm9ybWF0dGVkX2NoYXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlJTJDJTIwY29udGludWVfZmluYWxfbWVzc2FnZSUzRFRydWUpJTBBbW9kZWwuZ2VuZXJhdGUoKipmb3JtYXR0ZWRfY2hhdCk=",highlighted:`chat = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you format the answer in JSON?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;name&quot;: &quot;&#x27;</span>},
]

formatted_chat = tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, continue_final_message=<span class="hljs-literal">True</span>)
model.generate(**formatted_chat)`,wrap:!1}}),B=new v({props:{$$slots:{default:[Sp]},$$scope:{ctx:b}}}),gt=new w({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),Ct=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),$t=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),N=new v({props:{$$slots:{default:[zp]},$$scope:{ctx:b}}}),vt=new w({props:{title:"Advanced: Extra inputs to chat templates",local:"advanced-extra-inputs-to-chat-templates",headingTag:"h2"}}),Zt=new w({props:{title:"Advanced: Tool use / function calling",local:"advanced-tool-use--function-calling",headingTag:"h2"}}),kt=new J({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZWYlMjBjdXJyZW50X3RpbWUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGRhdGV0aW1lLm5vdygpKSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBdG9vbHMlMjAlM0QlMjAlNUJjdXJyZW50X3RpbWUlMkMlMjBtdWx0aXBseSU1RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime

<span class="hljs-keyword">def</span> <span class="hljs-title function_">current_time</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get the current local time as a string.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(datetime.now())

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

tools = [current_time, multiply]

model_input = tokenizer.apply_chat_template(
    messages,
    tools=tools
)`,wrap:!1}}),qt=new w({props:{title:"Passing tool results to the model",local:"passing-tool-results-to-the-model",headingTag:"h3"}}),Rt=new w({props:{title:"A complete tool use example",local:"a-complete-tool-use-example",headingTag:"h3"}}),Et=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMk5vdXNSZXNlYXJjaCUyRkhlcm1lcy0yLVByby1MbGFtYS0zLThCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;NousResearch/Hermes-2-Pro-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Ht=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_temperature</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, unit: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current temperature at a location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
        unit: The unit to return the temperature in. (choices: [&quot;celsius&quot;, &quot;fahrenheit&quot;])
    Returns:
        The current temperature at the specified location in the specified units, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">22.</span>  <span class="hljs-comment"># A real function should probably actually get the temperature!</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_wind_speed</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current wind speed in km/h at a given location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
    Returns:
        The current wind speed at the given location in km/h, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">6.</span>  <span class="hljs-comment"># A real function should probably actually get the wind speed!</span>

tools = [get_current_temperature, get_current_wind_speed]`,wrap:!1}}),Ft=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVzcG9uZHMlMjB0byUyMHdlYXRoZXIlMjBxdWVyaWVzLiUyMFlvdSUyMHNob3VsZCUyMHJlcGx5JTIwd2l0aCUyMHRoZSUyMHVuaXQlMjB1c2VkJTIwaW4lMjB0aGUlMjBxdWVyaWVkJTIwbG9jYXRpb24uJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGV5JTJDJTIwd2hhdCdzJTIwdGhlJTIwdGVtcGVyYXR1cmUlMjBpbiUyMFBhcmlzJTIwcmlnaHQlMjBub3clM0YlMjIlN0QlMEElNUQ=",highlighted:`messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a bot that responds to weather queries. You should reply with the unit used in the queried location.&quot;</span>},
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hey, what&#x27;s the temperature in Paris right now?&quot;</span>}
]`,wrap:!1}}),Pt=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),Kt=new J({props:{code:"JTNDdG9vbF9jYWxsJTNFJTBBJTdCJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTdEJTBBJTNDJTJGdG9vbF9jYWxsJTNFJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;tool_call&gt;
{&quot;arguments&quot;: {&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}, &quot;name&quot;: &quot;get_current_temperature&quot;}
&lt;/tool_call&gt;&lt;|im_end|&gt;`,wrap:!1}}),Z=new v({props:{$$slots:{default:[Ep]},$$scope:{ctx:b}}}),ee=new J({props:{code:"dG9vbF9jYWxsJTIwJTNEJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTdEJTBBbWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJ0b29sX2NhbGxzJTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),A=new v({props:{warning:!0,$$slots:{default:[Xp]},$$scope:{ctx:b}}}),se=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),k=new v({props:{$$slots:{default:[Hp]},$$scope:{ctx:b}}}),ne=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),ie=new J({props:{code:"VGhlJTIwY3VycmVudCUyMHRlbXBlcmF0dXJlJTIwaW4lMjBQYXJpcyUyQyUyMEZyYW5jZSUyMGlzJTIwMjIuMCUyMCVDMiVCMCUyMENlbHNpdXMuJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:"The current temperature in Paris, France is 22.0 ° Celsius.&lt;|im_end|&gt;",wrap:!1}}),Me=new w({props:{title:"Understanding tool schemas",local:"understanding-tool-schemas",headingTag:"h3"}}),ye=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGdldF9qc29uX3NjaGVtYSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBc2NoZW1hJTIwJTNEJTIwZ2V0X2pzb25fc2NoZW1hKG11bHRpcGx5KSUwQXByaW50KHNjaGVtYSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> get_json_schema

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

schema = get_json_schema(multiply)
<span class="hljs-built_in">print</span>(schema)`,wrap:!1}}),me=new J({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Je=new J({props:{code:"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",highlighted:`<span class="hljs-comment"># A simple function that takes no arguments</span>
current_time = {
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
  <span class="hljs-string">&quot;function&quot;</span>: {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;current_time&quot;</span>,
    <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current local time as a string.&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {}
    }
  }
}

<span class="hljs-comment"># A more complete function that takes two numerical arguments</span>
multiply = {
  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;function&#x27;</span>,
  <span class="hljs-string">&#x27;function&#x27;</span>: {
    <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;multiply&#x27;</span>,
    <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;A function that multiplies two numbers&#x27;</span>, 
    <span class="hljs-string">&#x27;parameters&#x27;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>, 
      <span class="hljs-string">&#x27;properties&#x27;</span>: {
        <span class="hljs-string">&#x27;a&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>,
          <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The first number to multiply&#x27;</span>
        }, 
        <span class="hljs-string">&#x27;b&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The second number to multiply&#x27;</span>
        }
      }, 
      <span class="hljs-string">&#x27;required&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>]
    }
  }
}

model_input = tokenizer.apply_chat_template(
    messages,
    tools = [current_time, multiply]
)`,wrap:!1}}),Te=new w({props:{title:"Advanced: Retrieval-augmented generation",local:"advanced-retrieval-augmented-generation",headingTag:"h2"}}),we=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-comment"># Load the model and tokenizer</span>
model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01-4bit&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
device = model.device <span class="hljs-comment"># Get the device the model is loaded on</span>

<span class="hljs-comment"># Define conversation input</span>
conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What has Man always dreamed of?&quot;</span>}
]

<span class="hljs-comment"># Define documents for retrieval-based generation</span>
documents = [
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Moon: Our Age-Old Foe&quot;</span>, 
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Man has always dreamed of destroying the moon. In this essay, I shall...&quot;</span>
    },
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Sun: Our Age-Old Friend&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Although often underappreciated, the sun provides several notable benefits...&quot;</span>
    }
]

<span class="hljs-comment"># Tokenize conversation and documents using a RAG template, returning PyTorch tensors.</span>
input_ids = tokenizer.apply_chat_template(
    conversation=conversation,
    documents=documents,
    chat_template=<span class="hljs-string">&quot;rag&quot;</span>,
    tokenize=<span class="hljs-literal">True</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate a response </span>
gen_tokens = model.generate(
    input_ids,
    max_new_tokens=<span class="hljs-number">100</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.3</span>,
    )

<span class="hljs-comment"># Decode and print the generated text along with generation prompt</span>
gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),Q=new v({props:{$$slots:{default:[Yp]},$$scope:{ctx:b}}}),fe=new w({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),ge=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0MnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclN0MlM0UlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiUyNS0lMjBpZiUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0Q=",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;|&gt;\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;content&#x27;] + eos_token }}</span><span class="language-xml">
{%- endfor %}
{%- if add_generation_prompt %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|assistant|&gt;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endif %}</span>`,wrap:!1}}),Ce=new J({props:{code:"Zm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJyUzQyU3QyU3Qm1lc3NhZ2UlNUIlMjJyb2xlJTIyJTVEJTdEJTdDJTNFJyklMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuKSUwQWlmJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJyUzQyU3Q2Fzc2lzdGFudCU3QyUzRScp",highlighted:`<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;&lt;|<span class="hljs-subst">{message[<span class="hljs-string">&quot;role&quot;</span>]}</span>|&gt;&#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>] + eos_token)
<span class="hljs-keyword">if</span> add_generation_prompt:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;&lt;|assistant|&gt;&#x27;</span>)`,wrap:!1}}),ve=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclNUMlNUNuJTNDJTNDJTJGU1lTJTNFJTNFJTVDJTVDbiU1QyU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUyMCclMjAlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),Ne=new w({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),Ze=new w({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),ke=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTNDU1lTJTNFJTNFJTVDJTVDbiclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclNUJBU1NUJTVEJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJTVCJTJGQVNTVCU1RCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),We=new J({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),W=new v({props:{$$slots:{default:[Fp]},$$scope:{ctx:b}}}),Ve=new w({props:{title:"Why do some models have multiple templates?",local:"why-do-some-models-have-multiple-templates",headingTag:"h3"}}),ze=new w({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),He=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[&#x27;content&#x27;] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),Fe=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),Pe=new J({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),Ke=new w({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),ll=new w({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),q=new v({props:{$$slots:{default:[Lp]},$$scope:{ctx:b}}}),nl=new w({props:{title:"Trimming whitespace",local:"trimming-whitespace",headingTag:"h3"}}),il=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),Ml=new J({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0IlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] + message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),cl=new w({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),V=new v({props:{$$slots:{default:[Pp]},$$scope:{ctx:b}}}),ml=new w({props:{title:"Callable functions",local:"callable-functions",headingTag:"h3"}}),Jl=new w({props:{title:"Compatibility with non-Python Jinja",local:"compatibility-with-non-python-jinja",headingTag:"h3"}}),wl=new w({props:{title:"Writing generation prompts",local:"writing-generation-prompts",headingTag:"h3"}}),gl=new J({props:{code:"JTdCJTdCLSUyMGJvc190b2tlbiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElN0IlMjUtJTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiclMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0Q=",highlighted:`{{- bos_token }}
{%- for message in messages %}
    {{- &#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27; }}
{%- endfor %}
{%- if add_generation_prompt %}
    {{- &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}
{%- endif %}`,wrap:!1}}),xl=new w({props:{title:"Writing and debugging larger templates",local:"writing-and-debugging-larger-templates",headingTag:"h3"}}),Gl=new J({props:{code:"b3BlbiglMjJ0ZW1wbGF0ZS5qaW5qYSUyMiUyQyUyMCUyMnclMjIpLndyaXRlKHRva2VuaXplci5jaGF0X3RlbXBsYXRlKQ==",highlighted:'<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>).write(tokenizer.chat_template)',wrap:!1}}),Bl=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBvcGVuKCUyMnRlbXBsYXRlLmppbmphJTIyKS5yZWFkKCk=",highlighted:'tokenizer.chat_template = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>).read()',wrap:!1}}),Zl=new w({props:{title:"Writing templates for tools",local:"writing-templates-for-tools",headingTag:"h3"}}),Ql=new w({props:{title:"Tool definitions",local:"tool-definitions",headingTag:"h4"}}),ql=new J({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_l=new J({props:{code:"JTdCJTI1LSUyMGlmJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwdG9vbCUyMGluJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQ3Rvb2wlM0UnJTIwJTJCJTIwdG9vbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwYXJndW1lbnQlMjBpbiUyMHRvb2wlNUInZnVuY3Rpb24nJTVEJTVCJ3BhcmFtZXRlcnMnJTVEJTVCJ3Byb3BlcnRpZXMnJTVEJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMGFyZ3VtZW50JTIwJTJCJTIwJyUzQSUyMCclMjAlMkIlMjB0b29sJTVCJ2Z1bmN0aW9uJyU1RCU1QidwYXJhbWV0ZXJzJyU1RCU1Qidwcm9wZXJ0aWVzJyU1RCU1QmFyZ3VtZW50JTVEJTVCJ2Rlc2NyaXB0aW9uJyU1RCUyMCUyQiUyMCclNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyU1Q24lM0MlMkZ0b29sJTNFJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- if tools %}
    {%- for tool in tools %}
        {{- &#x27;&lt;tool&gt;&#x27; + tool[&#x27;function&#x27;][&#x27;name&#x27;] + &#x27;\\n&#x27; }}
        {%- for argument in tool[&#x27;function&#x27;][&#x27;parameters&#x27;][&#x27;properties&#x27;] %}
            {{- argument + &#x27;: &#x27; + tool[&#x27;function&#x27;][&#x27;parameters&#x27;][&#x27;properties&#x27;][argument][&#x27;description&#x27;] + &#x27;\\n&#x27; }}
        {%- endfor %}
        {{- &#x27;\\n&lt;/tool&gt;&#x27; }}
    {%- endif %}
{%- endif %}`,wrap:!1}}),Sl=new w({props:{title:"Tool calls",local:"tool-calls",headingTag:"h4"}}),El=new J({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMnRvb2xfY2FsbHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJtdWx0aXBseSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYiUyMiUzQSUyMDYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tool_calls&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;arguments&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">6</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Hl=new J({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwYW5kJTIwJ3Rvb2xfY2FsbHMnJTIwaW4lMjBtZXNzYWdlJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGZvciUyMHRvb2xfY2FsbCUyMGluJTIwbWVzc2FnZSU1Qid0b29sX2NhbGxzJyU1RCUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDdG9vbF9jYWxsJTNFJyUyMCUyQiUyMHRvb2xfY2FsbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlMkIlMjB0b29sX2NhbGwlNUInZnVuY3Rpb24nJTVEJTVCJ2FyZ3VtZW50cyclNUQlN0N0b2pzb24lMjAlMkIlMjAnJTVDbiUzQyUyRnRvb2xfY2FsbCUzRSclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- if message[&#x27;role&#x27;] == &#x27;assistant&#x27; and &#x27;tool_calls&#x27; in message %}
    {%- for tool_call in message[&#x27;tool_calls&#x27;] %}
            {{- &#x27;&lt;tool_call&gt;&#x27; + tool_call[&#x27;function&#x27;][&#x27;name&#x27;] + &#x27;\\n&#x27; + tool_call[&#x27;function&#x27;][&#x27;arguments&#x27;]|tojson + &#x27;\\n&lt;/tool_call&gt;&#x27; }}
        {%- endif %}
    {%- endfor %}
{%- endif %}`,wrap:!1}}),Fl=new w({props:{title:"Tool responses",local:"tool-responses",headingTag:"h4"}}),Pl=new J({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnRvb2wlMjIlMkMlMEElMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMEElMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyMzAlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tool&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;30&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Kl=new J({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd0b29sJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAlMjIlM0N0b29sX3Jlc3VsdCUzRSUyMiUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAlMjIlM0MlMkZ0b29sX3Jlc3VsdCUzRSUyMiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- if message[&#x27;role&#x27;] == &#x27;tool&#x27; %}
    {{- &quot;&lt;tool_result&gt;&quot; + message[&#x27;content&#x27;] + &quot;&lt;/tool_result&gt;&quot; }}
{%- endif %}`,wrap:!1}}),ts=new Rp({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_templating.md"}}),{c(){h=o("meta"),U=a(),d=o("p"),T=a(),M(C.$$.fragment),I=a(),M(g.$$.fragment),G=a(),f=o("p"),f.innerHTML=$,j=a(),x=o("p"),x.innerHTML=Go,ls=a(),R=o("p"),R.innerHTML=vo,ss=a(),M(S.$$.fragment),as=a(),z=o("p"),z.innerHTML=Bo,ns=a(),E=o("p"),E.innerHTML=No,os=a(),M(X.$$.fragment),is=a(),H=o("p"),H.innerHTML=Zo,ps=a(),M(Y.$$.fragment),Ms=a(),F=o("p"),F.innerHTML=Ao,rs=a(),L=o("p"),L.innerHTML=ko,cs=a(),M(P.$$.fragment),ys=a(),D=o("p"),D.textContent=Qo,us=a(),M(K.$$.fragment),ms=a(),O=o("p"),O.textContent=Wo,hs=a(),M(tt.$$.fragment),ds=a(),et=o("p"),et.textContent=qo,Js=a(),M(lt.$$.fragment),Ts=a(),st=o("p"),st.textContent=Vo,Us=a(),M(at.$$.fragment),js=a(),nt=o("p"),nt.innerHTML=_o,ws=a(),M(ot.$$.fragment),fs=a(),M(it.$$.fragment),Is=a(),pt=o("p"),pt.innerHTML=Ro,gs=a(),M(Mt.$$.fragment),bs=a(),rt=o("p"),rt.innerHTML=So,Cs=a(),M(ct.$$.fragment),xs=a(),yt=o("p"),yt.textContent=zo,$s=a(),M(ut.$$.fragment),Gs=a(),mt=o("p"),mt.innerHTML=Eo,vs=a(),M(ht.$$.fragment),Bs=a(),dt=o("p"),dt.textContent=Xo,Ns=a(),Jt=o("p"),Jt.innerHTML=Ho,Zs=a(),M(Tt.$$.fragment),As=a(),Ut=o("p"),Ut.innerHTML=Yo,ks=a(),jt=o("p"),jt.textContent=Fo,Qs=a(),M(wt.$$.fragment),Ws=a(),ft=o("p"),ft.textContent=Lo,qs=a(),It=o("p"),It.innerHTML=Po,Vs=a(),M(B.$$.fragment),_s=a(),M(gt.$$.fragment),Rs=a(),bt=o("p"),bt.innerHTML=Do,Ss=a(),M(Ct.$$.fragment),zs=a(),xt=o("p"),xt.textContent=Ko,Es=a(),M($t.$$.fragment),Xs=a(),Gt=o("p"),Gt.innerHTML=Oo,Hs=a(),M(N.$$.fragment),Ys=a(),M(vt.$$.fragment),Fs=a(),Bt=o("p"),Bt.innerHTML=ti,Ls=a(),Nt=o("p"),Nt.textContent=ei,Ps=a(),M(Zt.$$.fragment),Ds=a(),At=o("p"),At.innerHTML=li,Ks=a(),M(kt.$$.fragment),Os=a(),Qt=o("p"),Qt.textContent=si,ta=a(),Wt=o("ul"),Wt.innerHTML=ai,ea=a(),M(qt.$$.fragment),la=a(),Vt=o("p"),Vt.textContent=ni,sa=a(),_t=o("ol"),_t.innerHTML=oi,aa=a(),M(Rt.$$.fragment),na=a(),St=o("p"),St.innerHTML=ii,oa=a(),zt=o("p"),zt.textContent=pi,ia=a(),M(Et.$$.fragment),pa=a(),Xt=o("p"),Xt.textContent=Mi,Ma=a(),M(Ht.$$.fragment),ra=a(),Yt=o("p"),Yt.textContent=ri,ca=a(),M(Ft.$$.fragment),ya=a(),Lt=o("p"),Lt.textContent=ci,ua=a(),M(Pt.$$.fragment),ma=a(),Dt=o("p"),Dt.textContent=yi,ha=a(),M(Kt.$$.fragment),da=a(),Ot=o("p"),Ot.textContent=ui,Ja=a(),M(Z.$$.fragment),Ta=a(),te=o("p"),te.textContent=mi,Ua=a(),M(ee.$$.fragment),ja=a(),M(A.$$.fragment),wa=a(),le=o("p"),le.textContent=hi,fa=a(),M(se.$$.fragment),Ia=a(),M(k.$$.fragment),ga=a(),ae=o("p"),ae.textContent=di,ba=a(),M(ne.$$.fragment),Ca=a(),oe=o("p"),oe.textContent=Ji,xa=a(),M(ie.$$.fragment),$a=a(),pe=o("p"),pe.textContent=Ti,Ga=a(),M(Me.$$.fragment),va=a(),re=o("p"),re.innerHTML=Ui,Ba=a(),ce=o("p"),ce.textContent=ji,Na=a(),M(ye.$$.fragment),Za=a(),ue=o("p"),ue.textContent=wi,Aa=a(),M(me.$$.fragment),ka=a(),he=o("p"),he.innerHTML=fi,Qa=a(),de=o("p"),de.innerHTML=Ii,Wa=a(),M(Je.$$.fragment),qa=a(),M(Te.$$.fragment),Va=a(),Ue=o("p"),Ue.innerHTML=gi,_a=a(),je=o("p"),je.textContent=bi,Ra=a(),M(we.$$.fragment),Sa=a(),M(Q.$$.fragment),za=a(),M(fe.$$.fragment),Ea=a(),Ie=o("p"),Ie.innerHTML=Ci,Xa=a(),M(ge.$$.fragment),Ha=a(),be=o("p"),be.innerHTML=xi,Ya=a(),M(Ce.$$.fragment),Fa=a(),xe=o("p"),xe.textContent=$i,La=a(),$e=o("ol"),$e.innerHTML=Gi,Pa=a(),Ge=o("p"),Ge.textContent=vi,Da=a(),M(ve.$$.fragment),Ka=a(),Be=o("p"),Be.innerHTML=Bi,Oa=a(),M(Ne.$$.fragment),tn=a(),M(Ze.$$.fragment),en=a(),Ae=o("p"),Ae.innerHTML=Ni,ln=a(),M(ke.$$.fragment),sn=a(),Qe=o("p"),Qe.innerHTML=Zi,an=a(),M(We.$$.fragment),nn=a(),qe=o("p"),qe.innerHTML=Ai,on=a(),M(W.$$.fragment),pn=a(),M(Ve.$$.fragment),Mn=a(),_e=o("p"),_e.innerHTML=ki,rn=a(),Re=o("p"),Re.innerHTML=Qi,cn=a(),Se=o("p"),Se.textContent=Wi,yn=a(),M(ze.$$.fragment),un=a(),Ee=o("p"),Ee.textContent=qi,mn=a(),Xe=o("p"),Xe.innerHTML=Vi,hn=a(),M(He.$$.fragment),dn=a(),Ye=o("p"),Ye.innerHTML=_i,Jn=a(),M(Fe.$$.fragment),Tn=a(),Le=o("p"),Le.innerHTML=Ri,Un=a(),M(Pe.$$.fragment),jn=a(),De=o("p"),De.innerHTML=Si,wn=a(),M(Ke.$$.fragment),fn=a(),Oe=o("p"),Oe.innerHTML=zi,In=a(),tl=o("p"),tl.innerHTML=Ei,gn=a(),el=o("p"),el.textContent=Xi,bn=a(),M(ll.$$.fragment),Cn=a(),M(q.$$.fragment),xn=a(),sl=o("p"),sl.innerHTML=Hi,$n=a(),al=o("p"),al.textContent=Yi,Gn=a(),M(nl.$$.fragment),vn=a(),ol=o("p"),ol.textContent=Fi,Bn=a(),M(il.$$.fragment),Nn=a(),pl=o("p"),pl.textContent=Li,Zn=a(),M(Ml.$$.fragment),An=a(),rl=o("p"),rl.innerHTML=Pi,kn=a(),M(cl.$$.fragment),Qn=a(),yl=o("p"),yl.innerHTML=Di,Wn=a(),ul=o("ul"),ul.innerHTML=Ki,qn=a(),M(V.$$.fragment),Vn=a(),M(ml.$$.fragment),_n=a(),hl=o("p"),hl.textContent=Oi,Rn=a(),dl=o("ul"),dl.innerHTML=tp,Sn=a(),M(Jl.$$.fragment),zn=a(),Tl=o("p"),Tl.innerHTML=ep,En=a(),Ul=o("p"),Ul.textContent=lp,Xn=a(),jl=o("ul"),jl.innerHTML=sp,Hn=a(),M(wl.$$.fragment),Yn=a(),fl=o("p"),fl.innerHTML=ap,Fn=a(),Il=o("p"),Il.textContent=np,Ln=a(),M(gl.$$.fragment),Pn=a(),bl=o("p"),bl.innerHTML=op,Dn=a(),Cl=o("p"),Cl.textContent=ip,Kn=a(),M(xl.$$.fragment),On=a(),$l=o("p"),$l.textContent=pp,to=a(),M(Gl.$$.fragment),eo=a(),vl=o("p"),vl.textContent=Mp,lo=a(),M(Bl.$$.fragment),so=a(),Nl=o("p"),Nl.textContent=rp,ao=a(),M(Zl.$$.fragment),no=a(),Al=o("p"),Al.textContent=cp,oo=a(),kl=o("p"),kl.textContent=yp,io=a(),M(Ql.$$.fragment),po=a(),Wl=o("p"),Wl.innerHTML=up,Mo=a(),M(ql.$$.fragment),ro=a(),Vl=o("p"),Vl.textContent=mp,co=a(),M(_l.$$.fragment),yo=a(),Rl=o("p"),Rl.innerHTML=hp,uo=a(),M(Sl.$$.fragment),mo=a(),zl=o("p"),zl.innerHTML=dp,ho=a(),M(El.$$.fragment),Jo=a(),Xl=o("p"),Xl.textContent=Jp,To=a(),M(Hl.$$.fragment),Uo=a(),Yl=o("p"),Yl.textContent=Tp,jo=a(),M(Fl.$$.fragment),wo=a(),Ll=o("p"),Ll.textContent=Up,fo=a(),M(Pl.$$.fragment),Io=a(),Dl=o("p"),Dl.textContent=jp,go=a(),M(Kl.$$.fragment),bo=a(),Ol=o("p"),Ol.textContent=wp,Co=a(),M(ts.$$.fragment),xo=a(),es=o("p"),this.h()},l(t){const e=Wp("svelte-u9bgzb",document.head);h=i(e,"META",{name:!0,content:!0}),e.forEach(l),U=n(t),d=i(t,"P",{}),Bp(d).forEach(l),T=n(t),r(C.$$.fragment,t),I=n(t),r(g.$$.fragment,t),G=n(t),f=i(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-ydi30o"&&(f.innerHTML=$),j=n(t),x=i(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1p8dq8"&&(x.innerHTML=Go),ls=n(t),R=i(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-19ob0qf"&&(R.innerHTML=vo),ss=n(t),r(S.$$.fragment,t),as=n(t),z=i(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-gwj0xd"&&(z.innerHTML=Bo),ns=n(t),E=i(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-14wqu22"&&(E.innerHTML=No),os=n(t),r(X.$$.fragment,t),is=n(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1010uaq"&&(H.innerHTML=Zo),ps=n(t),r(Y.$$.fragment,t),Ms=n(t),F=i(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1nl6r13"&&(F.innerHTML=Ao),rs=n(t),L=i(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1vun9x2"&&(L.innerHTML=ko),cs=n(t),r(P.$$.fragment,t),ys=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1vy7akj"&&(D.textContent=Qo),us=n(t),r(K.$$.fragment,t),ms=n(t),O=i(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-hj60o5"&&(O.textContent=Wo),hs=n(t),r(tt.$$.fragment,t),ds=n(t),et=i(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1bfcqd3"&&(et.textContent=qo),Js=n(t),r(lt.$$.fragment,t),Ts=n(t),st=i(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-k9m2iy"&&(st.textContent=Vo),Us=n(t),r(at.$$.fragment,t),js=n(t),nt=i(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1xbl47m"&&(nt.innerHTML=_o),ws=n(t),r(ot.$$.fragment,t),fs=n(t),r(it.$$.fragment,t),Is=n(t),pt=i(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-5umvde"&&(pt.innerHTML=Ro),gs=n(t),r(Mt.$$.fragment,t),bs=n(t),rt=i(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-rhnu79"&&(rt.innerHTML=So),Cs=n(t),r(ct.$$.fragment,t),xs=n(t),yt=i(t,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-jpbe39"&&(yt.textContent=zo),$s=n(t),r(ut.$$.fragment,t),Gs=n(t),mt=i(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-61bp3d"&&(mt.innerHTML=Eo),vs=n(t),r(ht.$$.fragment,t),Bs=n(t),dt=i(t,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-inq88f"&&(dt.textContent=Xo),Ns=n(t),Jt=i(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-uz30n4"&&(Jt.innerHTML=Ho),Zs=n(t),r(Tt.$$.fragment,t),As=n(t),Ut=i(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-y1327w"&&(Ut.innerHTML=Yo),ks=n(t),jt=i(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-wwwyth"&&(jt.textContent=Fo),Qs=n(t),r(wt.$$.fragment,t),Ws=n(t),ft=i(t,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-j6m3wj"&&(ft.textContent=Lo),qs=n(t),It=i(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-hfpwig"&&(It.innerHTML=Po),Vs=n(t),r(B.$$.fragment,t),_s=n(t),r(gt.$$.fragment,t),Rs=n(t),bt=i(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-i3l9c1"&&(bt.innerHTML=Do),Ss=n(t),r(Ct.$$.fragment,t),zs=n(t),xt=i(t,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-13505nn"&&(xt.textContent=Ko),Es=n(t),r($t.$$.fragment,t),Xs=n(t),Gt=i(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-ziuqkt"&&(Gt.innerHTML=Oo),Hs=n(t),r(N.$$.fragment,t),Ys=n(t),r(vt.$$.fragment,t),Fs=n(t),Bt=i(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-dd615e"&&(Bt.innerHTML=ti),Ls=n(t),Nt=i(t,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-dcun4m"&&(Nt.textContent=ei),Ps=n(t),r(Zt.$$.fragment,t),Ds=n(t),At=i(t,"P",{"data-svelte-h":!0}),p(At)!=="svelte-6sd0wq"&&(At.innerHTML=li),Ks=n(t),r(kt.$$.fragment,t),Os=n(t),Qt=i(t,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-608o9m"&&(Qt.textContent=si),ta=n(t),Wt=i(t,"UL",{"data-svelte-h":!0}),p(Wt)!=="svelte-n1b3zm"&&(Wt.innerHTML=ai),ea=n(t),r(qt.$$.fragment,t),la=n(t),Vt=i(t,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-11962fa"&&(Vt.textContent=ni),sa=n(t),_t=i(t,"OL",{"data-svelte-h":!0}),p(_t)!=="svelte-1vd84s7"&&(_t.innerHTML=oi),aa=n(t),r(Rt.$$.fragment,t),na=n(t),St=i(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1oi0gsn"&&(St.innerHTML=ii),oa=n(t),zt=i(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-o8n6v4"&&(zt.textContent=pi),ia=n(t),r(Et.$$.fragment,t),pa=n(t),Xt=i(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-1q7358y"&&(Xt.textContent=Mi),Ma=n(t),r(Ht.$$.fragment,t),ra=n(t),Yt=i(t,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-11hfyaa"&&(Yt.textContent=ri),ca=n(t),r(Ft.$$.fragment,t),ya=n(t),Lt=i(t,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-1usrd3e"&&(Lt.textContent=ci),ua=n(t),r(Pt.$$.fragment,t),ma=n(t),Dt=i(t,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-13505nn"&&(Dt.textContent=yi),ha=n(t),r(Kt.$$.fragment,t),da=n(t),Ot=i(t,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-nxltbo"&&(Ot.textContent=ui),Ja=n(t),r(Z.$$.fragment,t),Ta=n(t),te=i(t,"P",{"data-svelte-h":!0}),p(te)!=="svelte-336ooj"&&(te.textContent=mi),Ua=n(t),r(ee.$$.fragment,t),ja=n(t),r(A.$$.fragment,t),wa=n(t),le=i(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1mv1vl9"&&(le.textContent=hi),fa=n(t),r(se.$$.fragment,t),Ia=n(t),r(k.$$.fragment,t),ga=n(t),ae=i(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1qjybqz"&&(ae.textContent=di),ba=n(t),r(ne.$$.fragment,t),Ca=n(t),oe=i(t,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-13505nn"&&(oe.textContent=Ji),xa=n(t),r(ie.$$.fragment,t),$a=n(t),pe=i(t,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1evxmus"&&(pe.textContent=Ti),Ga=n(t),r(Me.$$.fragment,t),va=n(t),re=i(t,"P",{"data-svelte-h":!0}),p(re)!=="svelte-pl4mbs"&&(re.innerHTML=Ui),Ba=n(t),ce=i(t,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-37xmdz"&&(ce.textContent=ji),Na=n(t),r(ye.$$.fragment,t),Za=n(t),ue=i(t,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1bfcqd3"&&(ue.textContent=wi),Aa=n(t),r(me.$$.fragment,t),ka=n(t),he=i(t,"P",{"data-svelte-h":!0}),p(he)!=="svelte-19t6fs5"&&(he.innerHTML=fi),Qa=n(t),de=i(t,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1nlyrys"&&(de.innerHTML=Ii),Wa=n(t),r(Je.$$.fragment,t),qa=n(t),r(Te.$$.fragment,t),Va=n(t),Ue=i(t,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1977j4z"&&(Ue.innerHTML=gi),_a=n(t),je=i(t,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1xmnzcc"&&(je.textContent=bi),Ra=n(t),r(we.$$.fragment,t),Sa=n(t),r(Q.$$.fragment,t),za=n(t),r(fe.$$.fragment,t),Ea=n(t),Ie=i(t,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-lanz4l"&&(Ie.innerHTML=Ci),Xa=n(t),r(ge.$$.fragment,t),Ha=n(t),be=i(t,"P",{"data-svelte-h":!0}),p(be)!=="svelte-zet1qo"&&(be.innerHTML=xi),Ya=n(t),r(Ce.$$.fragment,t),Fa=n(t),xe=i(t,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-9bdwn1"&&(xe.textContent=$i),La=n(t),$e=i(t,"OL",{"data-svelte-h":!0}),p($e)!=="svelte-1ax9ke1"&&($e.innerHTML=Gi),Pa=n(t),Ge=i(t,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-4zn2hx"&&(Ge.textContent=vi),Da=n(t),r(ve.$$.fragment,t),Ka=n(t),Be=i(t,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-prz4we"&&(Be.innerHTML=Bi),Oa=n(t),r(Ne.$$.fragment,t),tn=n(t),r(Ze.$$.fragment,t),en=n(t),Ae=i(t,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1ubxgh9"&&(Ae.innerHTML=Ni),ln=n(t),r(ke.$$.fragment,t),sn=n(t),Qe=i(t,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-uce22c"&&(Qe.innerHTML=Zi),an=n(t),r(We.$$.fragment,t),nn=n(t),qe=i(t,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-h0htdn"&&(qe.innerHTML=Ai),on=n(t),r(W.$$.fragment,t),pn=n(t),r(Ve.$$.fragment,t),Mn=n(t),_e=i(t,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1d7cql4"&&(_e.innerHTML=ki),rn=n(t),Re=i(t,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1u88h1j"&&(Re.innerHTML=Qi),cn=n(t),Se=i(t,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1g7ri12"&&(Se.textContent=Wi),yn=n(t),r(ze.$$.fragment,t),un=n(t),Ee=i(t,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-5u6sqi"&&(Ee.textContent=qi),mn=n(t),Xe=i(t,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-ffreiw"&&(Xe.innerHTML=Vi),hn=n(t),r(He.$$.fragment,t),dn=n(t),Ye=i(t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1cj1ql7"&&(Ye.innerHTML=_i),Jn=n(t),r(Fe.$$.fragment,t),Tn=n(t),Le=i(t,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-soh9qu"&&(Le.innerHTML=Ri),Un=n(t),r(Pe.$$.fragment,t),jn=n(t),De=i(t,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1rltwuf"&&(De.innerHTML=Si),wn=n(t),r(Ke.$$.fragment,t),fn=n(t),Oe=i(t,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1c4nr7g"&&(Oe.innerHTML=zi),In=n(t),tl=i(t,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-kn2i6o"&&(tl.innerHTML=Ei),gn=n(t),el=i(t,"P",{"data-svelte-h":!0}),p(el)!=="svelte-197jyne"&&(el.textContent=Xi),bn=n(t),r(ll.$$.fragment,t),Cn=n(t),r(q.$$.fragment,t),xn=n(t),sl=i(t,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1eu5v04"&&(sl.innerHTML=Hi),$n=n(t),al=i(t,"P",{"data-svelte-h":!0}),p(al)!=="svelte-10wmjwo"&&(al.textContent=Yi),Gn=n(t),r(nl.$$.fragment,t),vn=n(t),ol=i(t,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-1ttgeg7"&&(ol.textContent=Fi),Bn=n(t),r(il.$$.fragment,t),Nn=n(t),pl=i(t,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-qihux6"&&(pl.textContent=Li),Zn=n(t),r(Ml.$$.fragment,t),An=n(t),rl=i(t,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-pefrh0"&&(rl.innerHTML=Pi),kn=n(t),r(cl.$$.fragment,t),Qn=n(t),yl=i(t,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-1s7e55r"&&(yl.innerHTML=Di),Wn=n(t),ul=i(t,"UL",{"data-svelte-h":!0}),p(ul)!=="svelte-1rdzqgp"&&(ul.innerHTML=Ki),qn=n(t),r(V.$$.fragment,t),Vn=n(t),r(ml.$$.fragment,t),_n=n(t),hl=i(t,"P",{"data-svelte-h":!0}),p(hl)!=="svelte-w29vry"&&(hl.textContent=Oi),Rn=n(t),dl=i(t,"UL",{"data-svelte-h":!0}),p(dl)!=="svelte-1fmzhdy"&&(dl.innerHTML=tp),Sn=n(t),r(Jl.$$.fragment,t),zn=n(t),Tl=i(t,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-jvvtjt"&&(Tl.innerHTML=ep),En=n(t),Ul=i(t,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-f0ucf0"&&(Ul.textContent=lp),Xn=n(t),jl=i(t,"UL",{"data-svelte-h":!0}),p(jl)!=="svelte-doa6oc"&&(jl.innerHTML=sp),Hn=n(t),r(wl.$$.fragment,t),Yn=n(t),fl=i(t,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-13g6lvo"&&(fl.innerHTML=ap),Fn=n(t),Il=i(t,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-i5qalm"&&(Il.textContent=np),Ln=n(t),r(gl.$$.fragment,t),Pn=n(t),bl=i(t,"P",{"data-svelte-h":!0}),p(bl)!=="svelte-148o5ra"&&(bl.innerHTML=op),Dn=n(t),Cl=i(t,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-17es6d5"&&(Cl.textContent=ip),Kn=n(t),r(xl.$$.fragment,t),On=n(t),$l=i(t,"P",{"data-svelte-h":!0}),p($l)!=="svelte-180ap61"&&($l.textContent=pp),to=n(t),r(Gl.$$.fragment,t),eo=n(t),vl=i(t,"P",{"data-svelte-h":!0}),p(vl)!=="svelte-1bv602"&&(vl.textContent=Mp),lo=n(t),r(Bl.$$.fragment,t),so=n(t),Nl=i(t,"P",{"data-svelte-h":!0}),p(Nl)!=="svelte-1mq7g8k"&&(Nl.textContent=rp),ao=n(t),r(Zl.$$.fragment,t),no=n(t),Al=i(t,"P",{"data-svelte-h":!0}),p(Al)!=="svelte-kt3iym"&&(Al.textContent=cp),oo=n(t),kl=i(t,"P",{"data-svelte-h":!0}),p(kl)!=="svelte-1nlwaki"&&(kl.textContent=yp),io=n(t),r(Ql.$$.fragment,t),po=n(t),Wl=i(t,"P",{"data-svelte-h":!0}),p(Wl)!=="svelte-wrq3v1"&&(Wl.innerHTML=up),Mo=n(t),r(ql.$$.fragment,t),ro=n(t),Vl=i(t,"P",{"data-svelte-h":!0}),p(Vl)!=="svelte-1woymkp"&&(Vl.textContent=mp),co=n(t),r(_l.$$.fragment,t),yo=n(t),Rl=i(t,"P",{"data-svelte-h":!0}),p(Rl)!=="svelte-1vngoc7"&&(Rl.innerHTML=hp),uo=n(t),r(Sl.$$.fragment,t),mo=n(t),zl=i(t,"P",{"data-svelte-h":!0}),p(zl)!=="svelte-1x6y95z"&&(zl.innerHTML=dp),ho=n(t),r(El.$$.fragment,t),Jo=n(t),Xl=i(t,"P",{"data-svelte-h":!0}),p(Xl)!=="svelte-my9opo"&&(Xl.textContent=Jp),To=n(t),r(Hl.$$.fragment,t),Uo=n(t),Yl=i(t,"P",{"data-svelte-h":!0}),p(Yl)!=="svelte-hsoefm"&&(Yl.textContent=Tp),jo=n(t),r(Fl.$$.fragment,t),wo=n(t),Ll=i(t,"P",{"data-svelte-h":!0}),p(Ll)!=="svelte-1hx88do"&&(Ll.textContent=Up),fo=n(t),r(Pl.$$.fragment,t),Io=n(t),Dl=i(t,"P",{"data-svelte-h":!0}),p(Dl)!=="svelte-1okuuze"&&(Dl.textContent=jp),go=n(t),r(Kl.$$.fragment,t),bo=n(t),Ol=i(t,"P",{"data-svelte-h":!0}),p(Ol)!=="svelte-13n2q2c"&&(Ol.textContent=wp),Co=n(t),r(ts.$$.fragment,t),xo=n(t),es=i(t,"P",{}),Bp(es).forEach(l),this.h()},h(){Np(h,"name","hf:doc:metadata"),Np(h,"content",Kp)},m(t,e){qp(document.head,h),s(t,U,e),s(t,d,e),s(t,T,e),c(C,t,e),s(t,I,e),c(g,t,e),s(t,G,e),s(t,f,e),s(t,j,e),s(t,x,e),s(t,ls,e),s(t,R,e),s(t,ss,e),c(S,t,e),s(t,as,e),s(t,z,e),s(t,ns,e),s(t,E,e),s(t,os,e),c(X,t,e),s(t,is,e),s(t,H,e),s(t,ps,e),c(Y,t,e),s(t,Ms,e),s(t,F,e),s(t,rs,e),s(t,L,e),s(t,cs,e),c(P,t,e),s(t,ys,e),s(t,D,e),s(t,us,e),c(K,t,e),s(t,ms,e),s(t,O,e),s(t,hs,e),c(tt,t,e),s(t,ds,e),s(t,et,e),s(t,Js,e),c(lt,t,e),s(t,Ts,e),s(t,st,e),s(t,Us,e),c(at,t,e),s(t,js,e),s(t,nt,e),s(t,ws,e),c(ot,t,e),s(t,fs,e),c(it,t,e),s(t,Is,e),s(t,pt,e),s(t,gs,e),c(Mt,t,e),s(t,bs,e),s(t,rt,e),s(t,Cs,e),c(ct,t,e),s(t,xs,e),s(t,yt,e),s(t,$s,e),c(ut,t,e),s(t,Gs,e),s(t,mt,e),s(t,vs,e),c(ht,t,e),s(t,Bs,e),s(t,dt,e),s(t,Ns,e),s(t,Jt,e),s(t,Zs,e),c(Tt,t,e),s(t,As,e),s(t,Ut,e),s(t,ks,e),s(t,jt,e),s(t,Qs,e),c(wt,t,e),s(t,Ws,e),s(t,ft,e),s(t,qs,e),s(t,It,e),s(t,Vs,e),c(B,t,e),s(t,_s,e),c(gt,t,e),s(t,Rs,e),s(t,bt,e),s(t,Ss,e),c(Ct,t,e),s(t,zs,e),s(t,xt,e),s(t,Es,e),c($t,t,e),s(t,Xs,e),s(t,Gt,e),s(t,Hs,e),c(N,t,e),s(t,Ys,e),c(vt,t,e),s(t,Fs,e),s(t,Bt,e),s(t,Ls,e),s(t,Nt,e),s(t,Ps,e),c(Zt,t,e),s(t,Ds,e),s(t,At,e),s(t,Ks,e),c(kt,t,e),s(t,Os,e),s(t,Qt,e),s(t,ta,e),s(t,Wt,e),s(t,ea,e),c(qt,t,e),s(t,la,e),s(t,Vt,e),s(t,sa,e),s(t,_t,e),s(t,aa,e),c(Rt,t,e),s(t,na,e),s(t,St,e),s(t,oa,e),s(t,zt,e),s(t,ia,e),c(Et,t,e),s(t,pa,e),s(t,Xt,e),s(t,Ma,e),c(Ht,t,e),s(t,ra,e),s(t,Yt,e),s(t,ca,e),c(Ft,t,e),s(t,ya,e),s(t,Lt,e),s(t,ua,e),c(Pt,t,e),s(t,ma,e),s(t,Dt,e),s(t,ha,e),c(Kt,t,e),s(t,da,e),s(t,Ot,e),s(t,Ja,e),c(Z,t,e),s(t,Ta,e),s(t,te,e),s(t,Ua,e),c(ee,t,e),s(t,ja,e),c(A,t,e),s(t,wa,e),s(t,le,e),s(t,fa,e),c(se,t,e),s(t,Ia,e),c(k,t,e),s(t,ga,e),s(t,ae,e),s(t,ba,e),c(ne,t,e),s(t,Ca,e),s(t,oe,e),s(t,xa,e),c(ie,t,e),s(t,$a,e),s(t,pe,e),s(t,Ga,e),c(Me,t,e),s(t,va,e),s(t,re,e),s(t,Ba,e),s(t,ce,e),s(t,Na,e),c(ye,t,e),s(t,Za,e),s(t,ue,e),s(t,Aa,e),c(me,t,e),s(t,ka,e),s(t,he,e),s(t,Qa,e),s(t,de,e),s(t,Wa,e),c(Je,t,e),s(t,qa,e),c(Te,t,e),s(t,Va,e),s(t,Ue,e),s(t,_a,e),s(t,je,e),s(t,Ra,e),c(we,t,e),s(t,Sa,e),c(Q,t,e),s(t,za,e),c(fe,t,e),s(t,Ea,e),s(t,Ie,e),s(t,Xa,e),c(ge,t,e),s(t,Ha,e),s(t,be,e),s(t,Ya,e),c(Ce,t,e),s(t,Fa,e),s(t,xe,e),s(t,La,e),s(t,$e,e),s(t,Pa,e),s(t,Ge,e),s(t,Da,e),c(ve,t,e),s(t,Ka,e),s(t,Be,e),s(t,Oa,e),c(Ne,t,e),s(t,tn,e),c(Ze,t,e),s(t,en,e),s(t,Ae,e),s(t,ln,e),c(ke,t,e),s(t,sn,e),s(t,Qe,e),s(t,an,e),c(We,t,e),s(t,nn,e),s(t,qe,e),s(t,on,e),c(W,t,e),s(t,pn,e),c(Ve,t,e),s(t,Mn,e),s(t,_e,e),s(t,rn,e),s(t,Re,e),s(t,cn,e),s(t,Se,e),s(t,yn,e),c(ze,t,e),s(t,un,e),s(t,Ee,e),s(t,mn,e),s(t,Xe,e),s(t,hn,e),c(He,t,e),s(t,dn,e),s(t,Ye,e),s(t,Jn,e),c(Fe,t,e),s(t,Tn,e),s(t,Le,e),s(t,Un,e),c(Pe,t,e),s(t,jn,e),s(t,De,e),s(t,wn,e),c(Ke,t,e),s(t,fn,e),s(t,Oe,e),s(t,In,e),s(t,tl,e),s(t,gn,e),s(t,el,e),s(t,bn,e),c(ll,t,e),s(t,Cn,e),c(q,t,e),s(t,xn,e),s(t,sl,e),s(t,$n,e),s(t,al,e),s(t,Gn,e),c(nl,t,e),s(t,vn,e),s(t,ol,e),s(t,Bn,e),c(il,t,e),s(t,Nn,e),s(t,pl,e),s(t,Zn,e),c(Ml,t,e),s(t,An,e),s(t,rl,e),s(t,kn,e),c(cl,t,e),s(t,Qn,e),s(t,yl,e),s(t,Wn,e),s(t,ul,e),s(t,qn,e),c(V,t,e),s(t,Vn,e),c(ml,t,e),s(t,_n,e),s(t,hl,e),s(t,Rn,e),s(t,dl,e),s(t,Sn,e),c(Jl,t,e),s(t,zn,e),s(t,Tl,e),s(t,En,e),s(t,Ul,e),s(t,Xn,e),s(t,jl,e),s(t,Hn,e),c(wl,t,e),s(t,Yn,e),s(t,fl,e),s(t,Fn,e),s(t,Il,e),s(t,Ln,e),c(gl,t,e),s(t,Pn,e),s(t,bl,e),s(t,Dn,e),s(t,Cl,e),s(t,Kn,e),c(xl,t,e),s(t,On,e),s(t,$l,e),s(t,to,e),c(Gl,t,e),s(t,eo,e),s(t,vl,e),s(t,lo,e),c(Bl,t,e),s(t,so,e),s(t,Nl,e),s(t,ao,e),c(Zl,t,e),s(t,no,e),s(t,Al,e),s(t,oo,e),s(t,kl,e),s(t,io,e),c(Ql,t,e),s(t,po,e),s(t,Wl,e),s(t,Mo,e),c(ql,t,e),s(t,ro,e),s(t,Vl,e),s(t,co,e),c(_l,t,e),s(t,yo,e),s(t,Rl,e),s(t,uo,e),c(Sl,t,e),s(t,mo,e),s(t,zl,e),s(t,ho,e),c(El,t,e),s(t,Jo,e),s(t,Xl,e),s(t,To,e),c(Hl,t,e),s(t,Uo,e),s(t,Yl,e),s(t,jo,e),c(Fl,t,e),s(t,wo,e),s(t,Ll,e),s(t,fo,e),c(Pl,t,e),s(t,Io,e),s(t,Dl,e),s(t,go,e),c(Kl,t,e),s(t,bo,e),s(t,Ol,e),s(t,Co,e),c(ts,t,e),s(t,xo,e),s(t,es,e),$o=!0},p(t,[e]){const fp={};e&2&&(fp.$$scope={dirty:e,ctx:t}),B.$set(fp);const Ip={};e&2&&(Ip.$$scope={dirty:e,ctx:t}),N.$set(Ip);const gp={};e&2&&(gp.$$scope={dirty:e,ctx:t}),Z.$set(gp);const bp={};e&2&&(bp.$$scope={dirty:e,ctx:t}),A.$set(bp);const Cp={};e&2&&(Cp.$$scope={dirty:e,ctx:t}),k.$set(Cp);const xp={};e&2&&(xp.$$scope={dirty:e,ctx:t}),Q.$set(xp);const $p={};e&2&&($p.$$scope={dirty:e,ctx:t}),W.$set($p);const Gp={};e&2&&(Gp.$$scope={dirty:e,ctx:t}),q.$set(Gp);const vp={};e&2&&(vp.$$scope={dirty:e,ctx:t}),V.$set(vp)},i(t){$o||(y(C.$$.fragment,t),y(g.$$.fragment,t),y(S.$$.fragment,t),y(X.$$.fragment,t),y(Y.$$.fragment,t),y(P.$$.fragment,t),y(K.$$.fragment,t),y(tt.$$.fragment,t),y(lt.$$.fragment,t),y(at.$$.fragment,t),y(ot.$$.fragment,t),y(it.$$.fragment,t),y(Mt.$$.fragment,t),y(ct.$$.fragment,t),y(ut.$$.fragment,t),y(ht.$$.fragment,t),y(Tt.$$.fragment,t),y(wt.$$.fragment,t),y(B.$$.fragment,t),y(gt.$$.fragment,t),y(Ct.$$.fragment,t),y($t.$$.fragment,t),y(N.$$.fragment,t),y(vt.$$.fragment,t),y(Zt.$$.fragment,t),y(kt.$$.fragment,t),y(qt.$$.fragment,t),y(Rt.$$.fragment,t),y(Et.$$.fragment,t),y(Ht.$$.fragment,t),y(Ft.$$.fragment,t),y(Pt.$$.fragment,t),y(Kt.$$.fragment,t),y(Z.$$.fragment,t),y(ee.$$.fragment,t),y(A.$$.fragment,t),y(se.$$.fragment,t),y(k.$$.fragment,t),y(ne.$$.fragment,t),y(ie.$$.fragment,t),y(Me.$$.fragment,t),y(ye.$$.fragment,t),y(me.$$.fragment,t),y(Je.$$.fragment,t),y(Te.$$.fragment,t),y(we.$$.fragment,t),y(Q.$$.fragment,t),y(fe.$$.fragment,t),y(ge.$$.fragment,t),y(Ce.$$.fragment,t),y(ve.$$.fragment,t),y(Ne.$$.fragment,t),y(Ze.$$.fragment,t),y(ke.$$.fragment,t),y(We.$$.fragment,t),y(W.$$.fragment,t),y(Ve.$$.fragment,t),y(ze.$$.fragment,t),y(He.$$.fragment,t),y(Fe.$$.fragment,t),y(Pe.$$.fragment,t),y(Ke.$$.fragment,t),y(ll.$$.fragment,t),y(q.$$.fragment,t),y(nl.$$.fragment,t),y(il.$$.fragment,t),y(Ml.$$.fragment,t),y(cl.$$.fragment,t),y(V.$$.fragment,t),y(ml.$$.fragment,t),y(Jl.$$.fragment,t),y(wl.$$.fragment,t),y(gl.$$.fragment,t),y(xl.$$.fragment,t),y(Gl.$$.fragment,t),y(Bl.$$.fragment,t),y(Zl.$$.fragment,t),y(Ql.$$.fragment,t),y(ql.$$.fragment,t),y(_l.$$.fragment,t),y(Sl.$$.fragment,t),y(El.$$.fragment,t),y(Hl.$$.fragment,t),y(Fl.$$.fragment,t),y(Pl.$$.fragment,t),y(Kl.$$.fragment,t),y(ts.$$.fragment,t),$o=!0)},o(t){u(C.$$.fragment,t),u(g.$$.fragment,t),u(S.$$.fragment,t),u(X.$$.fragment,t),u(Y.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(ot.$$.fragment,t),u(it.$$.fragment,t),u(Mt.$$.fragment,t),u(ct.$$.fragment,t),u(ut.$$.fragment,t),u(ht.$$.fragment,t),u(Tt.$$.fragment,t),u(wt.$$.fragment,t),u(B.$$.fragment,t),u(gt.$$.fragment,t),u(Ct.$$.fragment,t),u($t.$$.fragment,t),u(N.$$.fragment,t),u(vt.$$.fragment,t),u(Zt.$$.fragment,t),u(kt.$$.fragment,t),u(qt.$$.fragment,t),u(Rt.$$.fragment,t),u(Et.$$.fragment,t),u(Ht.$$.fragment,t),u(Ft.$$.fragment,t),u(Pt.$$.fragment,t),u(Kt.$$.fragment,t),u(Z.$$.fragment,t),u(ee.$$.fragment,t),u(A.$$.fragment,t),u(se.$$.fragment,t),u(k.$$.fragment,t),u(ne.$$.fragment,t),u(ie.$$.fragment,t),u(Me.$$.fragment,t),u(ye.$$.fragment,t),u(me.$$.fragment,t),u(Je.$$.fragment,t),u(Te.$$.fragment,t),u(we.$$.fragment,t),u(Q.$$.fragment,t),u(fe.$$.fragment,t),u(ge.$$.fragment,t),u(Ce.$$.fragment,t),u(ve.$$.fragment,t),u(Ne.$$.fragment,t),u(Ze.$$.fragment,t),u(ke.$$.fragment,t),u(We.$$.fragment,t),u(W.$$.fragment,t),u(Ve.$$.fragment,t),u(ze.$$.fragment,t),u(He.$$.fragment,t),u(Fe.$$.fragment,t),u(Pe.$$.fragment,t),u(Ke.$$.fragment,t),u(ll.$$.fragment,t),u(q.$$.fragment,t),u(nl.$$.fragment,t),u(il.$$.fragment,t),u(Ml.$$.fragment,t),u(cl.$$.fragment,t),u(V.$$.fragment,t),u(ml.$$.fragment,t),u(Jl.$$.fragment,t),u(wl.$$.fragment,t),u(gl.$$.fragment,t),u(xl.$$.fragment,t),u(Gl.$$.fragment,t),u(Bl.$$.fragment,t),u(Zl.$$.fragment,t),u(Ql.$$.fragment,t),u(ql.$$.fragment,t),u(_l.$$.fragment,t),u(Sl.$$.fragment,t),u(El.$$.fragment,t),u(Hl.$$.fragment,t),u(Fl.$$.fragment,t),u(Pl.$$.fragment,t),u(Kl.$$.fragment,t),u(ts.$$.fragment,t),$o=!1},d(t){t&&(l(U),l(d),l(T),l(I),l(G),l(f),l(j),l(x),l(ls),l(R),l(ss),l(as),l(z),l(ns),l(E),l(os),l(is),l(H),l(ps),l(Ms),l(F),l(rs),l(L),l(cs),l(ys),l(D),l(us),l(ms),l(O),l(hs),l(ds),l(et),l(Js),l(Ts),l(st),l(Us),l(js),l(nt),l(ws),l(fs),l(Is),l(pt),l(gs),l(bs),l(rt),l(Cs),l(xs),l(yt),l($s),l(Gs),l(mt),l(vs),l(Bs),l(dt),l(Ns),l(Jt),l(Zs),l(As),l(Ut),l(ks),l(jt),l(Qs),l(Ws),l(ft),l(qs),l(It),l(Vs),l(_s),l(Rs),l(bt),l(Ss),l(zs),l(xt),l(Es),l(Xs),l(Gt),l(Hs),l(Ys),l(Fs),l(Bt),l(Ls),l(Nt),l(Ps),l(Ds),l(At),l(Ks),l(Os),l(Qt),l(ta),l(Wt),l(ea),l(la),l(Vt),l(sa),l(_t),l(aa),l(na),l(St),l(oa),l(zt),l(ia),l(pa),l(Xt),l(Ma),l(ra),l(Yt),l(ca),l(ya),l(Lt),l(ua),l(ma),l(Dt),l(ha),l(da),l(Ot),l(Ja),l(Ta),l(te),l(Ua),l(ja),l(wa),l(le),l(fa),l(Ia),l(ga),l(ae),l(ba),l(Ca),l(oe),l(xa),l($a),l(pe),l(Ga),l(va),l(re),l(Ba),l(ce),l(Na),l(Za),l(ue),l(Aa),l(ka),l(he),l(Qa),l(de),l(Wa),l(qa),l(Va),l(Ue),l(_a),l(je),l(Ra),l(Sa),l(za),l(Ea),l(Ie),l(Xa),l(Ha),l(be),l(Ya),l(Fa),l(xe),l(La),l($e),l(Pa),l(Ge),l(Da),l(Ka),l(Be),l(Oa),l(tn),l(en),l(Ae),l(ln),l(sn),l(Qe),l(an),l(nn),l(qe),l(on),l(pn),l(Mn),l(_e),l(rn),l(Re),l(cn),l(Se),l(yn),l(un),l(Ee),l(mn),l(Xe),l(hn),l(dn),l(Ye),l(Jn),l(Tn),l(Le),l(Un),l(jn),l(De),l(wn),l(fn),l(Oe),l(In),l(tl),l(gn),l(el),l(bn),l(Cn),l(xn),l(sl),l($n),l(al),l(Gn),l(vn),l(ol),l(Bn),l(Nn),l(pl),l(Zn),l(An),l(rl),l(kn),l(Qn),l(yl),l(Wn),l(ul),l(qn),l(Vn),l(_n),l(hl),l(Rn),l(dl),l(Sn),l(zn),l(Tl),l(En),l(Ul),l(Xn),l(jl),l(Hn),l(Yn),l(fl),l(Fn),l(Il),l(Ln),l(Pn),l(bl),l(Dn),l(Cl),l(Kn),l(On),l($l),l(to),l(eo),l(vl),l(lo),l(so),l(Nl),l(ao),l(no),l(Al),l(oo),l(kl),l(io),l(po),l(Wl),l(Mo),l(ro),l(Vl),l(co),l(yo),l(Rl),l(uo),l(mo),l(zl),l(ho),l(Jo),l(Xl),l(To),l(Uo),l(Yl),l(jo),l(wo),l(Ll),l(fo),l(Io),l(Dl),l(go),l(bo),l(Ol),l(Co),l(xo),l(es)),l(h),m(C,t),m(g,t),m(S,t),m(X,t),m(Y,t),m(P,t),m(K,t),m(tt,t),m(lt,t),m(at,t),m(ot,t),m(it,t),m(Mt,t),m(ct,t),m(ut,t),m(ht,t),m(Tt,t),m(wt,t),m(B,t),m(gt,t),m(Ct,t),m($t,t),m(N,t),m(vt,t),m(Zt,t),m(kt,t),m(qt,t),m(Rt,t),m(Et,t),m(Ht,t),m(Ft,t),m(Pt,t),m(Kt,t),m(Z,t),m(ee,t),m(A,t),m(se,t),m(k,t),m(ne,t),m(ie,t),m(Me,t),m(ye,t),m(me,t),m(Je,t),m(Te,t),m(we,t),m(Q,t),m(fe,t),m(ge,t),m(Ce,t),m(ve,t),m(Ne,t),m(Ze,t),m(ke,t),m(We,t),m(W,t),m(Ve,t),m(ze,t),m(He,t),m(Fe,t),m(Pe,t),m(Ke,t),m(ll,t),m(q,t),m(nl,t),m(il,t),m(Ml,t),m(cl,t),m(V,t),m(ml,t),m(Jl,t),m(wl,t),m(gl,t),m(xl,t),m(Gl,t),m(Bl,t),m(Zl,t),m(Ql,t),m(ql,t),m(_l,t),m(Sl,t),m(El,t),m(Hl,t),m(Fl,t),m(Pl,t),m(Kl,t),m(ts,t)}}}const Kp='{"title":"Chat Templates","local":"chat-templates","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"What does “continue_final_message” do?","local":"what-does-continuefinalmessage-do","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: Extra inputs to chat templates","local":"advanced-extra-inputs-to-chat-templates","sections":[],"depth":2},{"title":"Advanced: Tool use / function calling","local":"advanced-tool-use--function-calling","sections":[{"title":"Passing tool results to the model","local":"passing-tool-results-to-the-model","sections":[],"depth":3},{"title":"A complete tool use example","local":"a-complete-tool-use-example","sections":[],"depth":3},{"title":"Understanding tool schemas","local":"understanding-tool-schemas","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Retrieval-augmented generation","local":"advanced-retrieval-augmented-generation","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"Why do some models have multiple templates?","local":"why-do-some-models-have-multiple-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"Trimming whitespace","local":"trimming-whitespace","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Callable functions","local":"callable-functions","sections":[],"depth":3},{"title":"Compatibility with non-Python Jinja","local":"compatibility-with-non-python-jinja","sections":[],"depth":3},{"title":"Writing generation prompts","local":"writing-generation-prompts","sections":[],"depth":3},{"title":"Writing and debugging larger templates","local":"writing-and-debugging-larger-templates","sections":[],"depth":3},{"title":"Writing templates for tools","local":"writing-templates-for-tools","sections":[{"title":"Tool definitions","local":"tool-definitions","sections":[],"depth":4},{"title":"Tool calls","local":"tool-calls","sections":[],"depth":4},{"title":"Tool responses","local":"tool-responses","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function Op(b){return Ap(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nM extends kp{constructor(h){super(),Qp(this,h,Op,Dp,Zp,{})}}export{nM as component};
