import{s as P,n as aa,o as ta}from"../chunks/scheduler.25b97de1.js";import{S as sa,i as la,g as i,s as e,r as T,A as ea,h as p,f as s,c as n,j as L,u as f,x as g,k as D,y as na,a as l,v as j,d as U,t as W,w as Z}from"../chunks/index.d9030fc9.js";import{C as Q}from"../chunks/CodeBlock.e6cd0d95.js";import{H as O,E as oa}from"../chunks/EditOnGithub.91d95064.js";function ia(S){let o,X,_,k,m,F,r,x='<a href="https://github.com/pytorch/ao" rel="nofollow">TorchAO</a> is an architecture optimization library for PyTorch, it provides high performance dtypes, optimization techniques and kernels for inference and training, featuring composability with native PyTorch features like <code>torch.compile</code>, FSDP etc.. Some benchmark numbers can be found <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">here</a>.',R,c,H="Before you begin, make sure the following libraries are installed with their latest version:",B,d,G,u,A="By default, the weights are loaded in full precision (torch.float32) regardless of the actual data type the weights are stored in such as torch.float16. Set <code>torch_dtype=&quot;auto&quot;</code> to load the weights in the data type defined in a model’s <code>config.json</code> file to automatically load the most memory-optimal data type.",z,M,V,h,C,y,$='torchao quantization is implemented with <a href="https://pytorch.org/docs/stable/notes/extending.html#subclassing-torch-tensor" rel="nofollow">tensor subclasses</a>, it only work with huggingface non-safetensor serialization and deserialization. It relies on <code>torch.load(..., weights_only=True)</code> to avoid arbitrary user code execution during load time and use <a href="https://pytorch.org/docs/stable/notes/serialization.html#torch.serialization.add_safe_globals" rel="nofollow">add_safe_globals</a> to allowlist some known user functions.',Y,J,K="The reason why it does not support safe tensor serialization is that wrapper tensor subclass allows maximum flexibility so we want to make sure the effort of supporting new format of quantized Tensor is low, while safe tensor optimizes for maximum safety (no user code execution), it also means we have to make sure to manually support new quantization format.",v,b,q,w,E,I,N;return m=new O({props:{title:"TorchAO",local:"torchao",headingTag:"h1"}}),d=new Q({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRvcmNoJTIwdG9yY2hhbw==",highlighted:"pip install --upgrade torch torchao",wrap:!1}}),M=new Q({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TorchAoConfig, AutoModelForCausalLM, AutoTokenizer

model_name = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>
<span class="hljs-comment"># We support int4_weight_only, int8_weight_only and int8_dynamic_activation_int8_weight</span>
<span class="hljs-comment"># More examples and documentations for arguments can be found in https://github.com/pytorch/ao/tree/main/torchao/quantization#other-available-quantization-techniques</span>
quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int4_weight_only&quot;</span>, group_size=<span class="hljs-number">128</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=quantization_config)

tokenizer = AutoTokenizer.from_pretrained(model_name)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># compile the quantized model to get speedup</span>
<span class="hljs-keyword">import</span> torchao
torchao.quantization.utils.recommended_inductor_config_setter()
quantized_model = torch.<span class="hljs-built_in">compile</span>(quantized_model, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>)

output = quantized_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># benchmark the performance</span>
<span class="hljs-keyword">import</span> torch.utils.benchmark <span class="hljs-keyword">as</span> benchmark

<span class="hljs-keyword">def</span> <span class="hljs-title function_">benchmark_fn</span>(<span class="hljs-params">f, *args, **kwargs</span>):
    <span class="hljs-comment"># Manual warmup</span>
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        f(*args, **kwargs)
        
    t0 = benchmark.Timer(
        stmt=<span class="hljs-string">&quot;f(*args, **kwargs)&quot;</span>,
        <span class="hljs-built_in">globals</span>={<span class="hljs-string">&quot;args&quot;</span>: args, <span class="hljs-string">&quot;kwargs&quot;</span>: kwargs, <span class="hljs-string">&quot;f&quot;</span>: f},
        num_threads=torch.get_num_threads(),
    )
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{(t0.blocked_autorange().mean):<span class="hljs-number">.3</span>f}</span>&quot;</span>

MAX_NEW_TOKENS = <span class="hljs-number">1000</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;int4wo-128 model:&quot;</span>, benchmark_fn(quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS))

bf16_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.bfloat16)
bf16_model = torch.<span class="hljs-built_in">compile</span>(bf16_model, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;bf16 model:&quot;</span>, benchmark_fn(bf16_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS))
`,wrap:!1}}),h=new O({props:{title:"Serialization and Deserialization",local:"serialization-and-deserialization",headingTag:"h2"}}),b=new Q({props:{code:"JTIzJTIwc2F2ZSUyMHF1YW50aXplZCUyMG1vZGVsJTIwbG9jYWxseSUwQW91dHB1dF9kaXIlMjAlM0QlMjAlMjJsbGFtYTMtOGItaW50NHdvLTEyOCUyMiUwQXF1YW50aXplZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQob3V0cHV0X2RpciUyQyUyMHNhZmVfc2VyaWFsaXphdGlvbiUzREZhbHNlKSUwQSUwQSUyMyUyMHB1c2glMjB0byUyMGh1Z2dpbmdmYWNlJTIwaHViJTBBJTIzJTIwc2F2ZV90byUyMCUzRCUyMCUyMiU3QnVzZXJfaWQlN0QlMkZsbGFtYTMtOGItaW50NHdvLTEyOCUyMiUwQSUyMyUyMHF1YW50aXplZF9tb2RlbC5wdXNoX3RvX2h1YihzYXZlX3RvJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2UpJTBBJTBBJTIzJTIwbG9hZCUyMHF1YW50aXplZCUyMG1vZGVsJTBBY2twdF9pZCUyMCUzRCUyMCUyMmxsYW1hMy04Yi1pbnQ0d28tMTI4JTIyJTIwJTIwJTIzJTIwb3IlMjBodWdnaW5nZmFjZSUyMGh1YiUyMG1vZGVsJTIwaWQlMEFsb2FkZWRfcXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNrcHRfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiklMEElMEElMEElMjMlMjBjb25maXJtJTIwdGhlJTIwc3BlZWR1cCUwQWxvYWRlZF9xdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKGxvYWRlZF9xdWFudGl6ZWRfbW9kZWwlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyKSUwQXByaW50KCUyMmxvYWRlZCUyMGludDR3by0xMjglMjBtb2RlbCUzQSUyMiUyQyUyMGJlbmNobWFya19mbihsb2FkZWRfcXVhbnRpemVkX21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TKSk=",highlighted:`<span class="hljs-comment"># save quantized model locally</span>
output_dir = <span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>
quantized_model.save_pretrained(output_dir, safe_serialization=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># push to huggingface hub</span>
<span class="hljs-comment"># save_to = &quot;{user_id}/llama3-8b-int4wo-128&quot;</span>
<span class="hljs-comment"># quantized_model.push_to_hub(save_to, safe_serialization=False)</span>

<span class="hljs-comment"># load quantized model</span>
ckpt_id = <span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>  <span class="hljs-comment"># or huggingface hub model id</span>
loaded_quantized_model = AutoModelForCausalLM.from_pretrained(ckpt_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)


<span class="hljs-comment"># confirm the speedup</span>
loaded_quantized_model = torch.<span class="hljs-built_in">compile</span>(loaded_quantized_model, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;loaded int4wo-128 model:&quot;</span>, benchmark_fn(loaded_quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS))`,wrap:!1}}),w=new oa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){o=i("meta"),X=e(),_=i("p"),k=e(),T(m.$$.fragment),F=e(),r=i("p"),r.innerHTML=x,R=e(),c=i("p"),c.textContent=H,B=e(),T(d.$$.fragment),G=e(),u=i("p"),u.innerHTML=A,z=e(),T(M.$$.fragment),V=e(),T(h.$$.fragment),C=e(),y=i("p"),y.innerHTML=$,Y=e(),J=i("p"),J.textContent=K,v=e(),T(b.$$.fragment),q=e(),T(w.$$.fragment),E=e(),I=i("p"),this.h()},l(a){const t=ea("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(s),X=n(a),_=p(a,"P",{}),L(_).forEach(s),k=n(a),f(m.$$.fragment,a),F=n(a),r=p(a,"P",{"data-svelte-h":!0}),g(r)!=="svelte-1w5ww4g"&&(r.innerHTML=x),R=n(a),c=p(a,"P",{"data-svelte-h":!0}),g(c)!=="svelte-1wrsrbm"&&(c.textContent=H),B=n(a),f(d.$$.fragment,a),G=n(a),u=p(a,"P",{"data-svelte-h":!0}),g(u)!=="svelte-9fdmcv"&&(u.innerHTML=A),z=n(a),f(M.$$.fragment,a),V=n(a),f(h.$$.fragment,a),C=n(a),y=p(a,"P",{"data-svelte-h":!0}),g(y)!=="svelte-14dwjgd"&&(y.innerHTML=$),Y=n(a),J=p(a,"P",{"data-svelte-h":!0}),g(J)!=="svelte-10wmnl9"&&(J.textContent=K),v=n(a),f(b.$$.fragment,a),q=n(a),f(w.$$.fragment,a),E=n(a),I=p(a,"P",{}),L(I).forEach(s),this.h()},h(){D(o,"name","hf:doc:metadata"),D(o,"content",pa)},m(a,t){na(document.head,o),l(a,X,t),l(a,_,t),l(a,k,t),j(m,a,t),l(a,F,t),l(a,r,t),l(a,R,t),l(a,c,t),l(a,B,t),j(d,a,t),l(a,G,t),l(a,u,t),l(a,z,t),j(M,a,t),l(a,V,t),j(h,a,t),l(a,C,t),l(a,y,t),l(a,Y,t),l(a,J,t),l(a,v,t),j(b,a,t),l(a,q,t),j(w,a,t),l(a,E,t),l(a,I,t),N=!0},p:aa,i(a){N||(U(m.$$.fragment,a),U(d.$$.fragment,a),U(M.$$.fragment,a),U(h.$$.fragment,a),U(b.$$.fragment,a),U(w.$$.fragment,a),N=!0)},o(a){W(m.$$.fragment,a),W(d.$$.fragment,a),W(M.$$.fragment,a),W(h.$$.fragment,a),W(b.$$.fragment,a),W(w.$$.fragment,a),N=!1},d(a){a&&(s(X),s(_),s(k),s(F),s(r),s(R),s(c),s(B),s(G),s(u),s(z),s(V),s(C),s(y),s(Y),s(J),s(v),s(q),s(E),s(I)),s(o),Z(m,a),Z(d,a),Z(M,a),Z(h,a),Z(b,a),Z(w,a)}}}const pa='{"title":"TorchAO","local":"torchao","sections":[{"title":"Serialization and Deserialization","local":"serialization-and-deserialization","sections":[],"depth":2}],"depth":1}';function ma(S){return ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends sa{constructor(o){super(),la(this,o,ma,ia,P,{})}}export{Ma as component};
