import{s as dn,o as Mn,n as hn}from"../chunks/scheduler.5f3e6389.js";import{S as Tn,i as yn,e as i,s as n,c as r,h as Jn,a as o,d as s,b as a,f as cn,g as m,j as p,k as un,l as gn,m as l,n as c,t as u,o as d,p as M}from"../chunks/index.373ab25c.js";import{T as wn}from"../chunks/Tip.3e202241.js";import{C as Un,H as y}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f75956a8.js";import{C as h}from"../chunks/CodeBlock.a4a55474.js";function bn(ut){let T,w="Due to a limitation of ONNX Runtime, it is not possible to run quantized models on <code>CUDAExecutionProvider</code> and only models with static quantization can be run on <code>TensorrtExecutionProvider</code>.";return{c(){T=i("p"),T.innerHTML=w},l(J){T=o(J,"P",{"data-svelte-h":!0}),p(T)!=="svelte-3znnw0"&&(T.innerHTML=w)},m(J,mt){l(J,T,mt)},p:hn,d(J){J&&s(T)}}}function fn(ut){let T,w,J,mt,U,dt,b,Mt,f,nl="By default, ONNX Runtime runs inference on CPU devices. However, it is possible to place supported operations on an NVIDIA GPU, while leaving any unsupported ones on CPU. In most cases, this allows costly operations to be placed on GPU and significantly accelerate inference.",ht,j,al="This guide will show you how to run inference on two execution providers that ONNX Runtime supports for NVIDIA GPUs:",Tt,v,il='<li><code>CUDAExecutionProvider</code>: Generic acceleration on NVIDIA CUDA-enabled GPUs.</li> <li><code>TensorrtExecutionProvider</code>: Uses NVIDIA’s <a href="https://developer.nvidia.com/tensorrt" rel="nofollow">TensorRT</a> inference engine and generally provides the best runtime performance.</li>',yt,g,Jt,C,gt,x,wt,N,ol='Provided the CUDA and cuDNN <a href="https://onnxruntime.ai/docs/execution-providers/CUDA-ExecutionProvider.html#requirements" rel="nofollow">requirements</a> are satisfied, install the additional dependencies by running',Ut,R,bt,Z,pl="To avoid conflicts between <code>onnxruntime</code> and <code>onnxruntime-gpu</code>, make sure the package <code>onnxruntime</code> is not installed by running <code>pip uninstall onnxruntime</code> prior to installing Optimum.",ft,I,jt,E,rl="Before going further, run the following sample code to check whether the install was successful:",vt,V,Ct,B,ml="In case this code runs gracefully, congratulations, the installation is successful! If you encounter the following error or similar,",xt,$,Nt,G,cl="then something is wrong with the CUDA or ONNX Runtime installation.",Rt,W,Zt,_,ul="For non-quantized models, the use is straightforward. Simply specify the <code>provider</code> argument in the <code>ORTModel.from_pretrained()</code> method. Here’s an example:",It,X,Et,k,dl=`The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.
When using Transformers pipeline, note that the <code>device</code> argument should be set to perform pre- and post-processing on GPU, following the example below:`,Vt,z,Bt,Q,Ml="Additionally, you can pass the session option <code>log_severity_level = 0</code> (verbose), to check whether all nodes are indeed placed on the CUDA execution provider or not:",$t,S,Gt,L,hl="You should see the following logs:",Wt,q,_t,F,Tl="In this example, we can see that all the costly MatMul operations are placed on the CUDA execution provider.",Xt,H,kt,A,yl="Due to current limitations in ONNX Runtime, it is not possible to use quantized models with <code>CUDAExecutionProvider</code>. The reasons are as follows:",zt,P,Jl='<li><p>When using <a href="quantization#dynamic-quantization-example">🤗 Optimum dynamic quantization</a>, nodes as <a href="https://github.com/onnx/onnx/blob/v1.12.0/docs/Operators.md#MatMulInteger" rel="nofollow"><code>MatMulInteger</code></a>, <a href="https://github.com/onnx/onnx/blob/v1.12.0/docs/Operators.md#DynamicQuantizeLinear" rel="nofollow"><code>DynamicQuantizeLinear</code></a> may be inserted in the ONNX graph, that cannot be consumed by the CUDA execution provider.</p></li> <li><p>When using <a href="quantization#static-quantization-example">static quantization</a>, the ONNX computation graph will contain matrix multiplications and convolutions in floating-point arithmetic, along with Quantize + Dequantize operations to simulate quantization. In this case, although the costly matrix multiplications and convolutions will be run on the GPU, they will use floating-point arithmetic as the <code>CUDAExecutionProvider</code> can not consume the Quantize + Dequantize nodes to replace them by the operations using integer arithmetic.</p></li>',Qt,D,St,Y,gl='<a href="https://onnxruntime.ai/docs/api/python/api_summary.html#iobinding" rel="nofollow">IOBinding</a> is an efficient way to avoid expensive data copying when using GPUs. By default, ONNX Runtime will copy the input from the CPU (even if the tensors are already copied to the targeted device), and assume that outputs also need to be copied back to the CPU from GPUs after the run. These data copying overheads between the host and devices are expensive, and <strong>can lead to worse inference latency than vanilla PyTorch</strong> especially for the decoding process.',Lt,O,wl="To avoid the slowdown, 🤗 Optimum adopts the IOBinding to copy inputs onto GPUs and pre-allocate memory for outputs prior the inference.  When instantiating the <code>ORTModel</code>, set the value of the argument <code>use_io_binding</code> to choose whether to turn on the IOBinding during the inference. <code>use_io_binding</code> is set to <code>True</code> by default, if you choose CUDA as execution provider.",qt,K,Ul="And if you want to turn off IOBinding:",Ft,ee,Ht,te,bl="For the time being, IOBinding is supported for task-defined ORT models, if you want us to add support for custom models, file us an issue on the Optimum’s repository.",At,se,Pt,le,fl="We tested three common models with a decoding process: <code>GPT2</code> / <code>T5-small</code> / <code>M2M100-418M</code>, and the benchmark was run on a versatile Tesla T4 GPU (more environment details at the end of this section).",Dt,ne,jl="Here are some performance results running with <code>CUDAExecutionProvider</code> when IOBinding has been turned on. We have tested input sequence length from 8 to 512, and generated outputs both with greedy search and beam search (<code>num_beam=5</code>):",Yt,ae,vl='<tbody><tr><td><p align="center"><img alt="GPT2" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/t4_res_ort_gpt2.png" width="450"/> <br/> <em style="color: grey">GPT2</em></p></td> <td><p align="center"><img alt="T5-small" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/t4_res_ort_t5_s.png" width="450"/> <br/> <em style="color: grey">T5-small</em></p></td></tr> <tr><td><p align="center"><img alt="M2M100-418M" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/t4_res_ort_m2m100_418m.png" width="450"/> <br/> <em style="color: grey">M2M100-418M</em></p></td></tr></tbody>',Ot,ie,Cl="And here is a summary for the saving time with different sequence lengths (32 / 128) and generation modes(greedy search / beam search) while using ONNX Runtime compared with PyTorch:",Kt,oe,xl='<tbody><tr><td><p align="center"><img alt="seq32" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/inference_models_32.png" width="800"/> <br/> <em style="color: grey">sequence length: 32</em></p></td></tr> <tr><td><p align="center"><img alt="seq128" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/inference_models_128.png" width="800"/> <br/> <em style="color: grey">sequence length: 128</em></p></td></tr></tbody>',es,pe,Nl="Environment:",ts,re,ss,me,Rl="Note that previous experiments are run with <strong>vanilla ONNX</strong> models exported directly from the exporter. If you are interested in <strong>further acceleration</strong>, with <code>ORTOptimizer</code> you can optimize the graph and convert your model to FP16 if you have a GPU with mixed precision capabilities.",ls,ce,ns,ue,Zl='TensorRT uses its own set of optimizations, and <strong>generally does not support the optimizations from <a href="/docs/optimum/pr_70/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a></strong>. We therefore recommend to use the original ONNX models when using TensorrtExecutionProvider (<a href="https://github.com/microsoft/onnxruntime/issues/10905#issuecomment-1072649358" rel="nofollow">reference</a>).',as,de,is,Me,Il="The easiest way to use TensorRT as the execution provider for models optimized through 🤗 Optimum is with the available ONNX Runtime <code>TensorrtExecutionProvider</code>.",os,he,El="In order to use 🤗 Optimum with TensorRT in a local environment, we recommend following the NVIDIA installation guides:",ps,Te,Vl='<li>CUDA toolkit: <a href="https://docs.nvidia.com/cuda/cuda-installation-guide-linux/index.html" rel="nofollow">https://docs.nvidia.com/cuda/cuda-installation-guide-linux/index.html</a></li> <li>cuDNN: <a href="https://docs.nvidia.com/deeplearning/cudnn/install-guide/index.html" rel="nofollow">https://docs.nvidia.com/deeplearning/cudnn/install-guide/index.html</a></li> <li>TensorRT: <a href="https://docs.nvidia.com/deeplearning/tensorrt/install-guide/index.html" rel="nofollow">https://docs.nvidia.com/deeplearning/tensorrt/install-guide/index.html</a></li>',rs,ye,Bl='For TensorRT, we recommend the Tar File Installation method. Alternatively, TensorRT may be installable with <code>pip</code> by following <a href="https://github.com/microsoft/onnxruntime/issues/9986" rel="nofollow">these instructions</a>.',ms,Je,$l="Once the required packages are installed, the following environment variables need to be set with the appropriate paths for ONNX Runtime to detect TensorRT installation:",cs,ge,us,we,ds,Ue,Gl="Before going further, run the following sample code to check whether the install was successful:",Ms,be,hs,fe,Wl="In case this code runs gracefully, congratulations, the installation is successful!",Ts,je,_l="In case the above <code>assert</code> fails, or you encounter the following warning",ys,ve,Js,Ce,Xl="something is wrong with the TensorRT or ONNX Runtime installation.",gs,xe,ws,Ne,kl='TensorRT requires to build its <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#build-phase" rel="nofollow">inference engine</a> ahead of inference, which takes some time due to the model optimization and nodes fusion. To avoid rebuilding the engine every time the model is loaded, ONNX Runtime provides a pair of options to save the engine: <code>trt_engine_cache_enable</code> and <code>trt_engine_cache_path</code>.',Us,Re,zl='We recommend setting these two provider options when using the TensorRT execution provider. The usage is as follows, where <a href="https://huggingface.co/optimum/gpt2" rel="nofollow"><code>optimum/gpt2</code></a> is an ONNX model converted from PyTorch using the <a href="https://huggingface.co/docs/optimum/main/en/exporters/onnx/usage_guides/export_a_model" rel="nofollow">Optimum ONNX exporter</a>:',bs,Ze,fs,Ie,Ql="TensorRT builds its engine depending on specified input shapes. One big issue is that building the engine can be time consuming, especially for large models. Therefore, as a workaround, one recommendation is to build the TensorRT engine with dynamic shapes. This allows to avoid rebuilding the engine for new small and large shapes, which is unwanted once the model is deployed for inference.",js,Ee,Sl="To do so we use the provider’s options <code>trt_profile_min_shapes</code>, <code>trt_profile_max_shapes</code> and <code>trt_profile_opt_shapes</code> to specify the minimum, maximum and optimal shapes for the engine. For example, for GPT2, we can use the following shapes:",vs,Ve,Cs,Be,Ll="Passing the engine cache path in the provider options, the engine can therefore be built once for all and used fully for inference thereafter.",xs,$e,ql="For example, for text generation, the engine can be built with:",Ns,Ge,Rs,We,Fl="The engine is stored as:",Zs,_e,Hl='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/tensorrt_cache.png" alt="TensorRT engine cache folder"/>',Is,Xe,Al="Once the engine is built, the cache can be reloaded and generation does not need to rebuild the engine:",Es,ke,Vs,ze,Bs,Qe,Pl='Once the engine is built, it is recommended to do before inference <strong>one or a few warmup steps</strong>, as the first inference runs have <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#trtexec-flags" rel="nofollow">some overhead</a>.',$s,Se,Gs,Le,Dl="For non-quantized models, the use is straightforward, by simply using the <code>provider</code> argument in <code>ORTModel.from_pretrained()</code>. For example:",Ws,qe,_s,Fe,Yl='<a href="#use-cuda-execution-provider-with-floatingpoint-models">As previously for <code>CUDAExecutionProvider</code></a>, by passing the session option <code>log_severity_level = 0</code> (verbose), we can check in the logs whether all nodes are indeed placed on the TensorRT execution provider or not:',Xs,He,ks,Ae,Ol='The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.',zs,Pe,Qs,De,Kl='When it comes to quantized models, TensorRT only supports models that use <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#enable_int8_c" rel="nofollow"><strong>static</strong> quantization</a> with <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#intro-quantization" rel="nofollow"><strong>symmetric quantization</strong> for weights and activations</a>.',Ss,Ye,en='🤗 Optimum provides a quantization config ready to be used with <a href="/docs/optimum/pr_70/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> with the constraints of TensorRT quantization:',Ls,Oe,qs,Ke,tn='Using this <code>qconfig</code>, static quantization can be performed as explained in the <a href="quantization#static-quantization-example">static quantization guide</a>.',Fs,et,sn='In the code sample below, after performing static quantization, the resulting model is loaded into the <a href="/docs/optimum/pr_70/en/onnxruntime/package_reference/modeling#optimum.onnxruntime.ORTModel">ORTModel</a> class using TensorRT as the execution provider. ONNX Runtime graph optimization needs to be disabled for the model to be consumed and optimized by TensorRT, and the fact that INT8 operations are used needs to be specified to TensorRT.',Hs,tt,As,st,ln='The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.',Ps,lt,Ds,nt,nn="As highlighted in the previous section, TensorRT supports only a limited range of quantized models:",Ys,at,an="<li>Static quantization only</li> <li>Weights and activations quantization ranges are symmetric</li> <li>Weights need to be stored in float32 in the ONNX model, thus there is no storage space saving from quantization. TensorRT indeed requires to insert full Quantize + Dequantize pairs. Normally, weights would be stored in fixed point 8-bits format and only a <code>DequantizeLinear</code> would be applied on the weights.</li>",Os,it,on="In case <code>provider=&quot;TensorrtExecutionProvider&quot;</code> is passed and the model has not been quantized strictly following these constraints, various errors may be raised, where error messages can be unclear.",Ks,ot,el,pt,pn="Nvidia Nsight Systems tool can be used to profile the execution time on GPU. Before profiling or measuring latency/throughput, it is a good practice to do a few <strong>warmup steps</strong>.",tl,rt,rn="Coming soon!",sl,ct,ll;return U=new Un({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new y({props:{title:"Accelerated inference on NVIDIA GPUs",local:"accelerated-inference-on-nvidia-gpus",headingTag:"h1"}}),g=new wn({props:{warning:!0,$$slots:{default:[bn]},$$scope:{ctx:ut}}}),C=new y({props:{title:"CUDAExecutionProvider",local:"cudaexecutionprovider",headingTag:"h2"}}),x=new y({props:{title:"CUDA installation",local:"cuda-installation",headingTag:"h3"}}),R=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0lNUJvbm54cnVudGltZS1ncHUlNUQ=",highlighted:"pip install optimum[onnxruntime-gpu]",wrap:!1}}),I=new y({props:{title:"Checking the CUDA installation is successful",local:"checking-the-cuda-installation-is-successful",headingTag:"h3"}}),V=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiUyQyUwQSUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMEElMjAlMjBwcm92aWRlciUzRCUyMkNVREFFeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJwaGlsc2NobWlkJTJGdGlueS1iZXJ0LXNzdDItZGlzdGlsbGVkJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJleHBlY3RhdGlvbnMlMjB3ZXJlJTIwbG93JTJDJTIwYWN0dWFsJTIwZW5qb3ltZW50JTIwd2FzJTIwaGlnaCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFvdXRwdXRzJTIwJTNEJTIwb3J0X21vZGVsKCoqaW5wdXRzKSUwQWFzc2VydCUyMG9ydF9tb2RlbC5wcm92aWRlcnMlMjAlM0QlM0QlMjAlNUIlMjJDVURBRXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMjAlMjJDUFVFeGVjdXRpb25Qcm92aWRlciUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>,
<span class="hljs-meta">... </span>  export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;expectations were low, actual enjoyment was high&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = ort_model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> ort_model.providers == [<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CPUExecutionProvider&quot;</span>]`,wrap:!1}}),$=new h({props:{code:"VmFsdWVFcnJvciUzQSUyMEFza2VkJTIwdG8lMjB1c2UlMjBDVURBRXhlY3V0aW9uUHJvdmlkZXIlMjBhcyUyMGFuJTIwT05OWCUyMFJ1bnRpbWUlMjBleGVjdXRpb24lMjBwcm92aWRlciUyQyUyMGJ1dCUyMHRoZSUyMGF2YWlsYWJsZSUyMGV4ZWN1dGlvbiUyMHByb3ZpZGVycyUyMGFyZSUyMCU1QidDUFVFeGVjdXRpb25Qcm92aWRlciclNUQu",highlighted:'ValueError: Asked <span class="hljs-built_in">to</span> use CUDAExecutionProvider <span class="hljs-keyword">as</span> <span class="hljs-keyword">an</span> ONNX Runtime execution provider, but <span class="hljs-keyword">the</span> available execution providers are [<span class="hljs-string">&#x27;CPUExecutionProvider&#x27;</span>].',wrap:!1}}),W=new y({props:{title:"Use CUDA execution provider with floating-point models",local:"use-cuda-execution-provider-with-floating-point-models",headingTag:"h3"}}),X=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMHByb3ZpZGVyJTNEJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>  export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),z=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBwaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0RvcnRfbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTNBMCUyMiklMEFyZXN1bHQlMjAlM0QlMjBwaXBlKCUyMkJvdGglMjB0aGUlMjBtdXNpYyUyMGFuZCUyMHZpc3VhbCUyMHdlcmUlMjBhc3RvdW5kaW5nJTJDJTIwbm90JTIwdG8lMjBtZW50aW9uJTIwdGhlJTIwYWN0b3JzJTIwcGVyZm9ybWFuY2UuJTIyKSUwQXByaW50KHJlc3VsdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;text-classification&quot;</span>, model=ort_model, tokenizer=tokenizer, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = pipe(<span class="hljs-string">&quot;Both the music and visual were astounding, not to mention the actors performance.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)
<span class="hljs-comment"># printing: [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9997727274894714}]</span>`,wrap:!1}}),S=new h({props:{code:"aW1wb3J0JTIwb25ueHJ1bnRpbWUlMEElMEFzZXNzaW9uX29wdGlvbnMlMjAlM0QlMjBvbm54cnVudGltZS5TZXNzaW9uT3B0aW9ucygpJTBBc2Vzc2lvbl9vcHRpb25zLmxvZ19zZXZlcml0eV9sZXZlbCUyMCUzRCUyMDAlMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2Vzc2lvbl9vcHRpb25zJTNEc2Vzc2lvbl9vcHRpb25zJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnxruntime

<span class="hljs-meta">&gt;&gt;&gt; </span>session_options = onnxruntime.SessionOptions()
<span class="hljs-meta">&gt;&gt;&gt; </span>session_options.log_severity_level = <span class="hljs-number">0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    session_options=session_options
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new h({props:{code:"MjAyMi0xMC0xOCUyMDE0JTNBNTklM0ExMy43Mjg4ODYwNDElMjAlNUJWJTNBb25ueHJ1bnRpbWUlM0ElMkMlMjBzZXNzaW9uX3N0YXRlLmNjJTNBMTE5MyUyMFZlcmlmeUVhY2hOJTBBb2RlSXNBc3NpZ25lZFRvQW5FcCU1RCUyMCUyMFByb3ZpZGVyJTNBJTIwJTVCQ1BVRXhlY3V0aW9uUHJvdmlkZXIlNUQlM0ElMjAlNUJHYXRoZXIlMjAoR2F0aGVyXzc2KSUyQyUyMFVucyUwQXF1ZWV6ZSUyMChVbnNxdWVlemVfNzgpJTJDJTIwR2F0aGVyJTIwKEdhdGhlcl85NyklMkMlMjBHYXRoZXIlMjAoR2F0aGVyXzEwMCklMkMlMjBDb25jYXQlMjAoQ29uY2F0XzElMEExMCklMkMlMjBVbnNxdWVlemUlMjAoVW5zcXVlZXplXzEyNSklMkMlMjAuLi4lNUQlMEEyMDIyLTEwLTE4JTIwMTQlM0E1OSUzQTEzLjcyODkwNjQzMSUyMCU1QlYlM0Fvbm54cnVudGltZSUzQSUyQyUyMHNlc3Npb25fc3RhdGUuY2MlM0ExMTkzJTIwVmVyaWZ5RWFjaE4lMEFvZGVJc0Fzc2lnbmVkVG9BbkVwJTVEJTIwJTIwUHJvdmlkZXIlM0ElMjAlNUJDVURBRXhlY3V0aW9uUHJvdmlkZXIlNUQlM0ElMjAlNUJTaGFwZSUyMChTaGFwZV83NCklMkMlMjBTbGljJTBBZSUyMChTbGljZV84MCklMkMlMjBHYXRoZXIlMjAoR2F0aGVyXzgxKSUyQyUyMEdhdGhlciUyMChHYXRoZXJfODIpJTJDJTIwQWRkJTIwKEFkZF84MyklMkMlMjBTaGFwZSUyMChTaGFwZSUwQV85NSklMkMlMjBNYXRNdWwlMjAoTWF0TXVsXzEwMSklMkMlMjAuLi4lNUQ=",highlighted:`<span class="hljs-attribute">2022</span>-<span class="hljs-number">10</span>-<span class="hljs-number">18</span> <span class="hljs-number">14</span>:<span class="hljs-number">59</span>:<span class="hljs-number">13</span>.<span class="hljs-number">728886041</span><span class="hljs-meta"> [V:onnxruntime:, session_state.cc:1193 VerifyEachN
odeIsAssignedToAnEp]  Provider: [CPUExecutionProvider]: [Gather (Gather_76), Uns
queeze (Unsqueeze_78), Gather (Gather_97), Gather (Gather_100), Concat (Concat_1
10), Unsqueeze (Unsqueeze_125), ...]</span>
<span class="hljs-attribute">2022</span>-<span class="hljs-number">10</span>-<span class="hljs-number">18</span> <span class="hljs-number">14</span>:<span class="hljs-number">59</span>:<span class="hljs-number">13</span>.<span class="hljs-number">728906431</span><span class="hljs-meta"> [V:onnxruntime:, session_state.cc:1193 VerifyEachN
odeIsAssignedToAnEp]  Provider: [CUDAExecutionProvider]: [Shape (Shape_74), Slic
e (Slice_80), Gather (Gather_81), Gather (Gather_82), Add (Add_83), Shape (Shape
_95), MatMul (MatMul_101), ...]</span>`,wrap:!1}}),H=new y({props:{title:"Use CUDA execution provider with quantized models",local:"use-cuda-execution-provider-with-quantized-models",headingTag:"h3"}}),D=new y({props:{title:"Reduce memory footprint with IOBinding",local:"reduce-memory-footprint-with-iobinding",headingTag:"h3"}}),ee=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjB1c2VfaW9fYmluZGluZyUzREZhbHNlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19mciUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTNBMCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-comment"># Create a pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_fr&quot;</span>, model=model, tokenizer=tokenizer, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)`,wrap:!1}}),se=new y({props:{title:"Observed time gains",local:"observed-time-gains",headingTag:"h3"}}),re=new h({props:{code:"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",highlighted:`+-----------------------------------------------------------------------------+
|<span class="hljs-string"> NVIDIA-SMI 440.33.01    Driver Version: 440.33.01    CUDA Version: 11.3     </span>|
|<span class="hljs-string">-------------------------------+----------------------+----------------------+
</span>|<span class="hljs-string"> GPU  Name        Persistence-M</span>|<span class="hljs-string"> Bus-Id        Disp.A </span>|<span class="hljs-string"> Volatile Uncorr. ECC </span>|
|<span class="hljs-string"> Fan  Temp  Perf  Pwr:Usage/Cap</span>|<span class="hljs-string">         Memory-Usage </span>|<span class="hljs-string"> GPU-Util  Compute M. </span>|
|<span class="hljs-string">===============================+======================+======================</span>|
|<span class="hljs-string">   0  Tesla T4            On   </span>|<span class="hljs-string"> 00000000:00:1E.0 Off </span>|<span class="hljs-string">                    0 </span>|
|<span class="hljs-string"> N/A   28C    P8     8W /  70W </span>|<span class="hljs-string">      0MiB / 15109MiB </span>|<span class="hljs-string">      0%      Default </span>|
+-------------------------------+----------------------+----------------------+

- Platform: Linux-5.4.0-1089-aws-x86_64-with-glibc2.29
- Python version: 3.8.10
- \`transformers\` version: 4.24.0
- \`optimum\` version: 1.5.0
- PyTorch version: 1.12.0+cu113`,wrap:!1}}),ce=new y({props:{title:"TensorrtExecutionProvider",local:"tensorrtexecutionprovider",headingTag:"h2"}}),de=new y({props:{title:"TensorRT installation",local:"tensorrt-installation",headingTag:"h3"}}),ge=new h({props:{code:"ZXhwb3J0JTIwQ1VEQV9QQVRIJTNEJTJGdXNyJTJGbG9jYWwlMkZjdWRhJTBBZXhwb3J0JTIwTERfTElCUkFSWV9QQVRIJTNEJTI0TERfTElCUkFSWV9QQVRIJTNBJTJGdXNyJTJGbG9jYWwlMkZjdWRhLXgueCUyRmxpYjY0JTNBJTJGcGF0aCUyRnRvJTJGVGVuc29yUlQtOC54LnglMkZsaWI=",highlighted:`<span class="hljs-built_in">export</span> CUDA_PATH=/usr/local/cuda
<span class="hljs-built_in">export</span> LD_LIBRARY_PATH=<span class="hljs-variable">$LD_LIBRARY_PATH</span>:/usr/local/cuda-x.x/lib64:/path/to/TensorRT-8.x.x/lib`,wrap:!1}}),we=new y({props:{title:"Checking the TensorRT installation is successful",local:"checking-the-tensorrt-installation-is-successful",headingTag:"h3"}}),be=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMlRlbnNvcnJ0RXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMEEpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiklMEFpbnAlMjAlM0QlMjB0b2tlbml6ZXIoJTIyZXhwZWN0YXRpb25zJTIwd2VyZSUyMGxvdyUyQyUyMGFjdHVhbCUyMGVuam95bWVudCUyMHdhcyUyMGhpZ2glMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBJTBBcmVzdWx0JTIwJTNEJTIwb3J0X21vZGVsKCoqaW5wKSUwQWFzc2VydCUyMG9ydF9tb2RlbC5wcm92aWRlcnMlMjAlM0QlM0QlMjAlNUIlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTIwJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTIwJTIyQ1BVRXhlY3V0aW9uUHJvdmlkZXIlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inp = tokenizer(<span class="hljs-string">&quot;expectations were low, actual enjoyment was high&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>result = ort_model(**inp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> ort_model.providers == [<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CPUExecutionProvider&quot;</span>]`,wrap:!1}}),ve=new h({props:{code:"RmFpbGVkJTIwdG8lMjBjcmVhdGUlMjBUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyLiUyMFBsZWFzZSUyMHJlZmVyZW5jZSUyMGh0dHBzJTNBJTJGJTJGb25ueHJ1bnRpbWUuYWklMkZkb2NzJTJGZXhlY3V0aW9uLXByb3ZpZGVycyUyRlRlbnNvclJULUV4ZWN1dGlvblByb3ZpZGVyLmh0bWwlMjNyZXF1aXJlbWVudHMlMjB0byUyMGVuc3VyZSUyMGFsbCUyMGRlcGVuZGVuY2llcyUyMGFyZSUyMG1ldC4=",highlighted:'Failed to create TensorrtExecutionProvider. Please reference https:<span class="hljs-regexp">//</span>onnxruntime.ai<span class="hljs-regexp">/docs/</span>execution-providers/TensorRT-ExecutionProvider.html<span class="hljs-comment">#requirements to ensure all dependencies are met.</span>',wrap:!1}}),xe=new y({props:{title:"TensorRT engine build and warmup",local:"tensorrt-engine-build-and-warmup",headingTag:"h3"}}),Ze=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckNhdXNhbExNJTBBJTBBcHJvdmlkZXJfb3B0aW9ucyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRydF9lbmdpbmVfY2FjaGVfZW5hYmxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnRydF9lbmdpbmVfY2FjaGVfcGF0aCUyMiUzQSUyMCUyMnRtcCUyRnRydF9jYWNoZV9ncHQyX2V4YW1wbGUlMjIlMEElN0QlMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcHRpbXVtJTJGZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXJfb3B0aW9ucyUzRHByb3ZpZGVyX29wdGlvbnMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>provider_options = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_enable&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_path&quot;</span>: <span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>
<span class="hljs-meta">... </span>}

<span class="hljs-comment"># the TensorRT engine is not built here, it will be when doing inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/gpt2&quot;</span>,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    provider_options=provider_options
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ve=new h({props:{code:"cHJvdmlkZXJfb3B0aW9ucyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRydF9wcm9maWxlX21pbl9zaGFwZXMlMjIlM0ElMjAlMjJpbnB1dF9pZHMlM0ExeDElMkNhdHRlbnRpb25fbWFzayUzQTF4MSUyQ3Bvc2l0aW9uX2lkcyUzQTF4MSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRydF9wcm9maWxlX29wdF9zaGFwZXMlMjIlM0ElMjAlMjJpbnB1dF9pZHMlM0ExeDElMkNhdHRlbnRpb25fbWFzayUzQTF4MSUyQ3Bvc2l0aW9uX2lkcyUzQTF4MSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRydF9wcm9maWxlX21heF9zaGFwZXMlMjIlM0ElMjAlMjJpbnB1dF9pZHMlM0ExeDY0JTJDYXR0ZW50aW9uX21hc2slM0ExeDY0JTJDcG9zaXRpb25faWRzJTNBMXg2NCUyMiUyQyUwQSU3RA==",highlighted:`provider_options = {
    <span class="hljs-string">&quot;trt_profile_min_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x1,attention_mask:1x1,position_ids:1x1&quot;</span>,
    <span class="hljs-string">&quot;trt_profile_opt_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x1,attention_mask:1x1,position_ids:1x1&quot;</span>,
    <span class="hljs-string">&quot;trt_profile_max_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x64,attention_mask:1x64,position_ids:1x64&quot;</span>,
}`,wrap:!1}}),Ge=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEElMEFvcy5tYWtlZGlycyglMjJ0bXAlMkZ0cnRfY2FjaGVfZ3B0Ml9leGFtcGxlJTIyJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQXByb3ZpZGVyX29wdGlvbnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0cnRfZW5naW5lX2NhY2hlX2VuYWJsZSUyMiUzQSUyMFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cnRfZW5naW5lX2NhY2hlX3BhdGglMjIlM0ElMjAlMjJ0bXAlMkZ0cnRfY2FjaGVfZ3B0Ml9leGFtcGxlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJ0X3Byb2ZpbGVfbWluX3NoYXBlcyUyMiUzQSUyMCUyMmlucHV0X2lkcyUzQTF4MSUyQ2F0dGVudGlvbl9tYXNrJTNBMXgxJTJDcG9zaXRpb25faWRzJTNBMXgxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJ0X3Byb2ZpbGVfb3B0X3NoYXBlcyUyMiUzQSUyMCUyMmlucHV0X2lkcyUzQTF4MSUyQ2F0dGVudGlvbl9tYXNrJTNBMXgxJTJDcG9zaXRpb25faWRzJTNBMXgxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJ0X3Byb2ZpbGVfbWF4X3NoYXBlcyUyMiUzQSUyMCUyMmlucHV0X2lkcyUzQTF4NjQlMkNhdHRlbnRpb25fbWFzayUzQTF4NjQlMkNwb3NpdGlvbl9pZHMlM0ExeDY0JTIyJTJDJTBBJTdEJTBBJTBBb3J0X21vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3B0aW11bSUyRmdwdDIlMjIlMkMlMEElMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyVGVuc29ycnRFeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyX29wdGlvbnMlM0Rwcm92aWRlcl9vcHRpb25zJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>os.makedirs(<span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>provider_options = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_enable&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_path&quot;</span>: <span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_profile_min_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x1,attention_mask:1x1,position_ids:1x1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_profile_opt_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x1,attention_mask:1x1,position_ids:1x1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_profile_max_shapes&quot;</span>: <span class="hljs-string">&quot;input_ids:1x64,attention_mask:1x64,position_ids:1x64&quot;</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/gpt2&quot;</span>,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    provider_options=provider_options,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ke=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEElMEFwcm92aWRlcl9vcHRpb25zJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJ0X2VuZ2luZV9jYWNoZV9lbmFibGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJ0X2VuZ2luZV9jYWNoZV9wYXRoJTIyJTNBJTIwJTIydG1wJTJGdHJ0X2NhY2hlX2dwdDJfZXhhbXBsZSUyMiUwQSU3RCUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm9wdGltdW0lMkZncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2NhY2hlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMlRlbnNvcnJ0RXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlcl9vcHRpb25zJTNEcHJvdmlkZXJfb3B0aW9ucyUyQyUwQSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZ3B0MiUyMiklMEElMEF0ZXh0JTIwJTNEJTIwJTVCJTIyUmVwbGFjZSUyMG1lJTIwYnklMjBhbnklMjB0ZXh0JTIweW91J2QlMjBsaWtlLiUyMiU1RCUwQWVuY29kZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIodGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoMyklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBvcnRfbW9kZWwuZ2VuZXJhdGUoKiplbmNvZGVkX2lucHV0KSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCkpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQklHTk9SRV9SRVNVTFQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>provider_options = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_enable&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_path&quot;</span>: <span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/gpt2&quot;</span>,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    provider_options=provider_options,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = [<span class="hljs-string">&quot;Replace me by any text you&#x27;d like.&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_input = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
<span class="hljs-meta">... </span>    output = ort_model.generate(**encoded_input)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>]))  <span class="hljs-comment"># doctest: +IGNORE_RESULT</span>`,wrap:!1}}),ze=new y({props:{title:"Warmup",local:"warmup",headingTag:"h4"}}),Se=new y({props:{title:"Use TensorRT execution provider with floating-point models",local:"use-tensorrt-execution-provider-with-floating-point-models",headingTag:"h3"}}),qe=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyVGVuc29ycnRFeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),He=new h({props:{code:"MjAyMi0wOS0yMiUyMDE0JTNBMTIlM0E0OC4zNzE1MTM3NDElMjAlNUJWJTNBb25ueHJ1bnRpbWUlM0ElMkMlMjBzZXNzaW9uX3N0YXRlLmNjJTNBMTE4OCUyMFZlcmlmeUVhY2hOb2RlSXNBc3NpZ25lZFRvQW5FcCU1RCUyMEFsbCUyMG5vZGVzJTIwaGF2ZSUyMGJlZW4lMjBwbGFjZWQlMjBvbiUyMCU1QlRlbnNvcnJ0RXhlY3V0aW9uUHJvdmlkZXIlNUQ=",highlighted:'<span class="hljs-attribute">2022</span>-<span class="hljs-number">09</span>-<span class="hljs-number">22</span> <span class="hljs-number">14</span>:<span class="hljs-number">12</span>:<span class="hljs-number">48</span>.<span class="hljs-number">371513741</span><span class="hljs-meta"> [V:onnxruntime:, session_state.cc:1188 VerifyEachNodeIsAssignedToAnEp] All nodes have been placed on [TensorrtExecutionProvider]</span>',wrap:!1}}),Pe=new y({props:{title:"Use TensorRT execution provider with quantized models",local:"use-tensorrt-execution-provider-with-quantized-models",headingTag:"h3"}}),Oe=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBBdXRvUXVhbnRpemF0aW9uQ29uZmlnJTBBJTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcudGVuc29ycnQocGVyX2NoYW5uZWwlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> AutoQuantizationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.tensorrt(per_channel=<span class="hljs-literal">False</span>)`,wrap:!1}}),tt=new h({props:{code:"aW1wb3J0JTIwb25ueHJ1bnRpbWUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBc2Vzc2lvbl9vcHRpb25zJTIwJTNEJTIwb25ueHJ1bnRpbWUuU2Vzc2lvbk9wdGlvbnMoKSUwQXNlc3Npb25fb3B0aW9ucy5ncmFwaF9vcHRpbWl6YXRpb25fbGV2ZWwlMjAlM0QlMjBvbm54cnVudGltZS5HcmFwaE9wdGltaXphdGlvbkxldmVsLk9SVF9ESVNBQkxFX0FMTCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZ4bWFydHklMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1zc3QyLW9ubngtaW50OC1mb3ItdGVuc29ycnQlMjIpJTBBb3J0X21vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmeG1hcnR5JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtc3N0Mi1vbm54LWludDgtZm9yLXRlbnNvcnJ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2Vzc2lvbl9vcHRpb25zJTNEc2Vzc2lvbl9vcHRpb25zJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXJfb3B0aW9ucyUzRCU3QiUyMnRydF9pbnQ4X2VuYWJsZSUyMiUzQSUyMFRydWUlN0QlMkMlMEEpJTBBJTBBaW5wJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRlbnNvclJUJTIwaXMlMjBhJTIwYml0JTIwcGFpbmZ1bCUyMHRvJTIwdXNlJTJDJTIwYnV0JTIwYXQlMjB0aGUlMjBlbmQlMjBvZiUyMGRheSUyMGl0JTIwcnVucyUyMHNtb290aGx5JTIwYW5kJTIwYmxhemluZ2x5JTIwZmFzdCElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQXJlcyUyMCUzRCUyMG9ydF9tb2RlbCgqKmlucCklMEElMEFwcmludChyZXMpJTBBcHJpbnQob3J0X21vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnJlcy5sb2dpdHMlNUIwJTVELmFyZ21heCgpJTVEKSUwQSUyMyUyMFNlcXVlbmNlQ2xhc3NpZmllck91dHB1dChsb3NzJTNETm9uZSUyQyUyMGxvZ2l0cyUzRGFycmF5KCU1QiU1Qi0wLjU0NTA2NiUyMCUyQyUyMCUyMDAuNTYwOTc2NCU1RCU1RCUyQyUyMGR0eXBlJTNEZmxvYXQzMiklMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKSUwQSUyMyUyMFBPU0lUSVZF",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnxruntime
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>session_options = onnxruntime.SessionOptions()
<span class="hljs-meta">&gt;&gt;&gt; </span>session_options.graph_optimization_level = onnxruntime.GraphOptimizationLevel.ORT_DISABLE_ALL

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;fxmarty/distilbert-base-uncased-sst2-onnx-int8-for-tensorrt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fxmarty/distilbert-base-uncased-sst2-onnx-int8-for-tensorrt&quot;</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    session_options=session_options,
<span class="hljs-meta">... </span>    provider_options={<span class="hljs-string">&quot;trt_int8_enable&quot;</span>: <span class="hljs-literal">True</span>},
<span class="hljs-meta">&gt;&gt;&gt; </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inp = tokenizer(<span class="hljs-string">&quot;TensorRT is a bit painful to use, but at the end of day it runs smoothly and blazingly fast!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>res = ort_model(**inp)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(res)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(ort_model.config.id2label[res.logits[<span class="hljs-number">0</span>].argmax()])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SequenceClassifierOutput(loss=None, logits=array([[-0.545066 ,  0.5609764]], dtype=float32), hidden_states=None, attentions=None)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># POSITIVE</span>`,wrap:!1}}),lt=new y({props:{title:"TensorRT limitations for quantized models",local:"tensorrt-limitations-for-quantized-models",headingTag:"h3"}}),ot=new y({props:{title:"Observed time gains",local:"observed-time-gains",headingTag:"h3"}}),{c(){T=i("meta"),w=n(),J=i("p"),mt=n(),r(U.$$.fragment),dt=n(),r(b.$$.fragment),Mt=n(),f=i("p"),f.textContent=nl,ht=n(),j=i("p"),j.textContent=al,Tt=n(),v=i("ul"),v.innerHTML=il,yt=n(),r(g.$$.fragment),Jt=n(),r(C.$$.fragment),gt=n(),r(x.$$.fragment),wt=n(),N=i("p"),N.innerHTML=ol,Ut=n(),r(R.$$.fragment),bt=n(),Z=i("p"),Z.innerHTML=pl,ft=n(),r(I.$$.fragment),jt=n(),E=i("p"),E.textContent=rl,vt=n(),r(V.$$.fragment),Ct=n(),B=i("p"),B.textContent=ml,xt=n(),r($.$$.fragment),Nt=n(),G=i("p"),G.textContent=cl,Rt=n(),r(W.$$.fragment),Zt=n(),_=i("p"),_.innerHTML=ul,It=n(),r(X.$$.fragment),Et=n(),k=i("p"),k.innerHTML=dl,Vt=n(),r(z.$$.fragment),Bt=n(),Q=i("p"),Q.innerHTML=Ml,$t=n(),r(S.$$.fragment),Gt=n(),L=i("p"),L.textContent=hl,Wt=n(),r(q.$$.fragment),_t=n(),F=i("p"),F.textContent=Tl,Xt=n(),r(H.$$.fragment),kt=n(),A=i("p"),A.innerHTML=yl,zt=n(),P=i("ul"),P.innerHTML=Jl,Qt=n(),r(D.$$.fragment),St=n(),Y=i("p"),Y.innerHTML=gl,Lt=n(),O=i("p"),O.innerHTML=wl,qt=n(),K=i("p"),K.textContent=Ul,Ft=n(),r(ee.$$.fragment),Ht=n(),te=i("p"),te.textContent=bl,At=n(),r(se.$$.fragment),Pt=n(),le=i("p"),le.innerHTML=fl,Dt=n(),ne=i("p"),ne.innerHTML=jl,Yt=n(),ae=i("table"),ae.innerHTML=vl,Ot=n(),ie=i("p"),ie.textContent=Cl,Kt=n(),oe=i("table"),oe.innerHTML=xl,es=n(),pe=i("p"),pe.textContent=Nl,ts=n(),r(re.$$.fragment),ss=n(),me=i("p"),me.innerHTML=Rl,ls=n(),r(ce.$$.fragment),ns=n(),ue=i("p"),ue.innerHTML=Zl,as=n(),r(de.$$.fragment),is=n(),Me=i("p"),Me.innerHTML=Il,os=n(),he=i("p"),he.textContent=El,ps=n(),Te=i("ul"),Te.innerHTML=Vl,rs=n(),ye=i("p"),ye.innerHTML=Bl,ms=n(),Je=i("p"),Je.textContent=$l,cs=n(),r(ge.$$.fragment),us=n(),r(we.$$.fragment),ds=n(),Ue=i("p"),Ue.textContent=Gl,Ms=n(),r(be.$$.fragment),hs=n(),fe=i("p"),fe.textContent=Wl,Ts=n(),je=i("p"),je.innerHTML=_l,ys=n(),r(ve.$$.fragment),Js=n(),Ce=i("p"),Ce.textContent=Xl,gs=n(),r(xe.$$.fragment),ws=n(),Ne=i("p"),Ne.innerHTML=kl,Us=n(),Re=i("p"),Re.innerHTML=zl,bs=n(),r(Ze.$$.fragment),fs=n(),Ie=i("p"),Ie.textContent=Ql,js=n(),Ee=i("p"),Ee.innerHTML=Sl,vs=n(),r(Ve.$$.fragment),Cs=n(),Be=i("p"),Be.textContent=Ll,xs=n(),$e=i("p"),$e.textContent=ql,Ns=n(),r(Ge.$$.fragment),Rs=n(),We=i("p"),We.textContent=Fl,Zs=n(),_e=i("p"),_e.innerHTML=Hl,Is=n(),Xe=i("p"),Xe.textContent=Al,Es=n(),r(ke.$$.fragment),Vs=n(),r(ze.$$.fragment),Bs=n(),Qe=i("p"),Qe.innerHTML=Pl,$s=n(),r(Se.$$.fragment),Gs=n(),Le=i("p"),Le.innerHTML=Dl,Ws=n(),r(qe.$$.fragment),_s=n(),Fe=i("p"),Fe.innerHTML=Yl,Xs=n(),r(He.$$.fragment),ks=n(),Ae=i("p"),Ae.innerHTML=Ol,zs=n(),r(Pe.$$.fragment),Qs=n(),De=i("p"),De.innerHTML=Kl,Ss=n(),Ye=i("p"),Ye.innerHTML=en,Ls=n(),r(Oe.$$.fragment),qs=n(),Ke=i("p"),Ke.innerHTML=tn,Fs=n(),et=i("p"),et.innerHTML=sn,Hs=n(),r(tt.$$.fragment),As=n(),st=i("p"),st.innerHTML=ln,Ps=n(),r(lt.$$.fragment),Ds=n(),nt=i("p"),nt.textContent=nn,Ys=n(),at=i("ul"),at.innerHTML=an,Os=n(),it=i("p"),it.innerHTML=on,Ks=n(),r(ot.$$.fragment),el=n(),pt=i("p"),pt.innerHTML=pn,tl=n(),rt=i("p"),rt.textContent=rn,sl=n(),ct=i("p"),this.h()},l(e){const t=Jn("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(s),w=a(e),J=o(e,"P",{}),cn(J).forEach(s),mt=a(e),m(U.$$.fragment,e),dt=a(e),m(b.$$.fragment,e),Mt=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-domqad"&&(f.textContent=nl),ht=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-ww48at"&&(j.textContent=al),Tt=a(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-1f150mv"&&(v.innerHTML=il),yt=a(e),m(g.$$.fragment,e),Jt=a(e),m(C.$$.fragment,e),gt=a(e),m(x.$$.fragment,e),wt=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-19ifj7n"&&(N.innerHTML=ol),Ut=a(e),m(R.$$.fragment,e),bt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-uw46pi"&&(Z.innerHTML=pl),ft=a(e),m(I.$$.fragment,e),jt=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ojb3z4"&&(E.textContent=rl),vt=a(e),m(V.$$.fragment,e),Ct=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-j2t2xg"&&(B.textContent=ml),xt=a(e),m($.$$.fragment,e),Nt=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-f1x068"&&(G.textContent=cl),Rt=a(e),m(W.$$.fragment,e),Zt=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-8e3pil"&&(_.innerHTML=ul),It=a(e),m(X.$$.fragment,e),Et=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1icvfx4"&&(k.innerHTML=dl),Vt=a(e),m(z.$$.fragment,e),Bt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1i8mx2m"&&(Q.innerHTML=Ml),$t=a(e),m(S.$$.fragment,e),Gt=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-gej35a"&&(L.textContent=hl),Wt=a(e),m(q.$$.fragment,e),_t=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1fiacx2"&&(F.textContent=Tl),Xt=a(e),m(H.$$.fragment,e),kt=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-bair0o"&&(A.innerHTML=yl),zt=a(e),P=o(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-1530vj"&&(P.innerHTML=Jl),Qt=a(e),m(D.$$.fragment,e),St=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1weebfs"&&(Y.innerHTML=gl),Lt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-17f91ev"&&(O.innerHTML=wl),qt=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-5cnra5"&&(K.textContent=Ul),Ft=a(e),m(ee.$$.fragment,e),Ht=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-lbg3hy"&&(te.textContent=bl),At=a(e),m(se.$$.fragment,e),Pt=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-j6vk0b"&&(le.innerHTML=fl),Dt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-gwibyk"&&(ne.innerHTML=jl),Yt=a(e),ae=o(e,"TABLE",{"data-svelte-h":!0}),p(ae)!=="svelte-kb5dzt"&&(ae.innerHTML=vl),Ot=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1o7p4o2"&&(ie.textContent=Cl),Kt=a(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),p(oe)!=="svelte-1vr8f8j"&&(oe.innerHTML=xl),es=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1fkshtn"&&(pe.textContent=Nl),ts=a(e),m(re.$$.fragment,e),ss=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1qw28p2"&&(me.innerHTML=Rl),ls=a(e),m(ce.$$.fragment,e),ns=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-8aaht7"&&(ue.innerHTML=Zl),as=a(e),m(de.$$.fragment,e),is=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1rs6298"&&(Me.innerHTML=Il),os=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1ceem44"&&(he.textContent=El),ps=a(e),Te=o(e,"UL",{"data-svelte-h":!0}),p(Te)!=="svelte-dwey60"&&(Te.innerHTML=Vl),rs=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-73idjo"&&(ye.innerHTML=Bl),ms=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-rrllkl"&&(Je.textContent=$l),cs=a(e),m(ge.$$.fragment,e),us=a(e),m(we.$$.fragment,e),ds=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-ojb3z4"&&(Ue.textContent=Gl),Ms=a(e),m(be.$$.fragment,e),hs=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-10vc8nx"&&(fe.textContent=Wl),Ts=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-16mf5ei"&&(je.innerHTML=_l),ys=a(e),m(ve.$$.fragment,e),Js=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-a4iqo7"&&(Ce.textContent=Xl),gs=a(e),m(xe.$$.fragment,e),ws=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1w34bpb"&&(Ne.innerHTML=kl),Us=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1vctm96"&&(Re.innerHTML=zl),bs=a(e),m(Ze.$$.fragment,e),fs=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1adxaty"&&(Ie.textContent=Ql),js=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1bgbv86"&&(Ee.innerHTML=Sl),vs=a(e),m(Ve.$$.fragment,e),Cs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-7tlbrr"&&(Be.textContent=Ll),xs=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-10vd8g9"&&($e.textContent=ql),Ns=a(e),m(Ge.$$.fragment,e),Rs=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1a6v242"&&(We.textContent=Fl),Zs=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-h7osbf"&&(_e.innerHTML=Hl),Is=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-19pgd5i"&&(Xe.textContent=Al),Es=a(e),m(ke.$$.fragment,e),Vs=a(e),m(ze.$$.fragment,e),Bs=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1go7vzm"&&(Qe.innerHTML=Pl),$s=a(e),m(Se.$$.fragment,e),Gs=a(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1wz9kqz"&&(Le.innerHTML=Dl),Ws=a(e),m(qe.$$.fragment,e),_s=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-12c3zjv"&&(Fe.innerHTML=Yl),Xs=a(e),m(He.$$.fragment,e),ks=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-16axcqn"&&(Ae.innerHTML=Ol),zs=a(e),m(Pe.$$.fragment,e),Qs=a(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1gmqa4f"&&(De.innerHTML=Kl),Ss=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-19qil02"&&(Ye.innerHTML=en),Ls=a(e),m(Oe.$$.fragment,e),qs=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-qouywp"&&(Ke.innerHTML=tn),Fs=a(e),et=o(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1ozu5eg"&&(et.innerHTML=sn),Hs=a(e),m(tt.$$.fragment,e),As=a(e),st=o(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-16axcqn"&&(st.innerHTML=ln),Ps=a(e),m(lt.$$.fragment,e),Ds=a(e),nt=o(e,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1oae55m"&&(nt.textContent=nn),Ys=a(e),at=o(e,"UL",{"data-svelte-h":!0}),p(at)!=="svelte-dbp0vn"&&(at.innerHTML=an),Os=a(e),it=o(e,"P",{"data-svelte-h":!0}),p(it)!=="svelte-1jqg7cl"&&(it.innerHTML=on),Ks=a(e),m(ot.$$.fragment,e),el=a(e),pt=o(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-cgoioi"&&(pt.innerHTML=pn),tl=a(e),rt=o(e,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-15n2n4z"&&(rt.textContent=rn),sl=a(e),ct=o(e,"P",{}),cn(ct).forEach(s),this.h()},h(){un(T,"name","hf:doc:metadata"),un(T,"content",jn)},m(e,t){gn(document.head,T),l(e,w,t),l(e,J,t),l(e,mt,t),c(U,e,t),l(e,dt,t),c(b,e,t),l(e,Mt,t),l(e,f,t),l(e,ht,t),l(e,j,t),l(e,Tt,t),l(e,v,t),l(e,yt,t),c(g,e,t),l(e,Jt,t),c(C,e,t),l(e,gt,t),c(x,e,t),l(e,wt,t),l(e,N,t),l(e,Ut,t),c(R,e,t),l(e,bt,t),l(e,Z,t),l(e,ft,t),c(I,e,t),l(e,jt,t),l(e,E,t),l(e,vt,t),c(V,e,t),l(e,Ct,t),l(e,B,t),l(e,xt,t),c($,e,t),l(e,Nt,t),l(e,G,t),l(e,Rt,t),c(W,e,t),l(e,Zt,t),l(e,_,t),l(e,It,t),c(X,e,t),l(e,Et,t),l(e,k,t),l(e,Vt,t),c(z,e,t),l(e,Bt,t),l(e,Q,t),l(e,$t,t),c(S,e,t),l(e,Gt,t),l(e,L,t),l(e,Wt,t),c(q,e,t),l(e,_t,t),l(e,F,t),l(e,Xt,t),c(H,e,t),l(e,kt,t),l(e,A,t),l(e,zt,t),l(e,P,t),l(e,Qt,t),c(D,e,t),l(e,St,t),l(e,Y,t),l(e,Lt,t),l(e,O,t),l(e,qt,t),l(e,K,t),l(e,Ft,t),c(ee,e,t),l(e,Ht,t),l(e,te,t),l(e,At,t),c(se,e,t),l(e,Pt,t),l(e,le,t),l(e,Dt,t),l(e,ne,t),l(e,Yt,t),l(e,ae,t),l(e,Ot,t),l(e,ie,t),l(e,Kt,t),l(e,oe,t),l(e,es,t),l(e,pe,t),l(e,ts,t),c(re,e,t),l(e,ss,t),l(e,me,t),l(e,ls,t),c(ce,e,t),l(e,ns,t),l(e,ue,t),l(e,as,t),c(de,e,t),l(e,is,t),l(e,Me,t),l(e,os,t),l(e,he,t),l(e,ps,t),l(e,Te,t),l(e,rs,t),l(e,ye,t),l(e,ms,t),l(e,Je,t),l(e,cs,t),c(ge,e,t),l(e,us,t),c(we,e,t),l(e,ds,t),l(e,Ue,t),l(e,Ms,t),c(be,e,t),l(e,hs,t),l(e,fe,t),l(e,Ts,t),l(e,je,t),l(e,ys,t),c(ve,e,t),l(e,Js,t),l(e,Ce,t),l(e,gs,t),c(xe,e,t),l(e,ws,t),l(e,Ne,t),l(e,Us,t),l(e,Re,t),l(e,bs,t),c(Ze,e,t),l(e,fs,t),l(e,Ie,t),l(e,js,t),l(e,Ee,t),l(e,vs,t),c(Ve,e,t),l(e,Cs,t),l(e,Be,t),l(e,xs,t),l(e,$e,t),l(e,Ns,t),c(Ge,e,t),l(e,Rs,t),l(e,We,t),l(e,Zs,t),l(e,_e,t),l(e,Is,t),l(e,Xe,t),l(e,Es,t),c(ke,e,t),l(e,Vs,t),c(ze,e,t),l(e,Bs,t),l(e,Qe,t),l(e,$s,t),c(Se,e,t),l(e,Gs,t),l(e,Le,t),l(e,Ws,t),c(qe,e,t),l(e,_s,t),l(e,Fe,t),l(e,Xs,t),c(He,e,t),l(e,ks,t),l(e,Ae,t),l(e,zs,t),c(Pe,e,t),l(e,Qs,t),l(e,De,t),l(e,Ss,t),l(e,Ye,t),l(e,Ls,t),c(Oe,e,t),l(e,qs,t),l(e,Ke,t),l(e,Fs,t),l(e,et,t),l(e,Hs,t),c(tt,e,t),l(e,As,t),l(e,st,t),l(e,Ps,t),c(lt,e,t),l(e,Ds,t),l(e,nt,t),l(e,Ys,t),l(e,at,t),l(e,Os,t),l(e,it,t),l(e,Ks,t),c(ot,e,t),l(e,el,t),l(e,pt,t),l(e,tl,t),l(e,rt,t),l(e,sl,t),l(e,ct,t),ll=!0},p(e,[t]){const mn={};t&2&&(mn.$$scope={dirty:t,ctx:e}),g.$set(mn)},i(e){ll||(u(U.$$.fragment,e),u(b.$$.fragment,e),u(g.$$.fragment,e),u(C.$$.fragment,e),u(x.$$.fragment,e),u(R.$$.fragment,e),u(I.$$.fragment,e),u(V.$$.fragment,e),u($.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(z.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(H.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(de.$$.fragment,e),u(ge.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(ve.$$.fragment,e),u(xe.$$.fragment,e),u(Ze.$$.fragment,e),u(Ve.$$.fragment,e),u(Ge.$$.fragment,e),u(ke.$$.fragment,e),u(ze.$$.fragment,e),u(Se.$$.fragment,e),u(qe.$$.fragment,e),u(He.$$.fragment,e),u(Pe.$$.fragment,e),u(Oe.$$.fragment,e),u(tt.$$.fragment,e),u(lt.$$.fragment,e),u(ot.$$.fragment,e),ll=!0)},o(e){d(U.$$.fragment,e),d(b.$$.fragment,e),d(g.$$.fragment,e),d(C.$$.fragment,e),d(x.$$.fragment,e),d(R.$$.fragment,e),d(I.$$.fragment,e),d(V.$$.fragment,e),d($.$$.fragment,e),d(W.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(H.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(ge.$$.fragment,e),d(we.$$.fragment,e),d(be.$$.fragment,e),d(ve.$$.fragment,e),d(xe.$$.fragment,e),d(Ze.$$.fragment,e),d(Ve.$$.fragment,e),d(Ge.$$.fragment,e),d(ke.$$.fragment,e),d(ze.$$.fragment,e),d(Se.$$.fragment,e),d(qe.$$.fragment,e),d(He.$$.fragment,e),d(Pe.$$.fragment,e),d(Oe.$$.fragment,e),d(tt.$$.fragment,e),d(lt.$$.fragment,e),d(ot.$$.fragment,e),ll=!1},d(e){e&&(s(w),s(J),s(mt),s(dt),s(Mt),s(f),s(ht),s(j),s(Tt),s(v),s(yt),s(Jt),s(gt),s(wt),s(N),s(Ut),s(bt),s(Z),s(ft),s(jt),s(E),s(vt),s(Ct),s(B),s(xt),s(Nt),s(G),s(Rt),s(Zt),s(_),s(It),s(Et),s(k),s(Vt),s(Bt),s(Q),s($t),s(Gt),s(L),s(Wt),s(_t),s(F),s(Xt),s(kt),s(A),s(zt),s(P),s(Qt),s(St),s(Y),s(Lt),s(O),s(qt),s(K),s(Ft),s(Ht),s(te),s(At),s(Pt),s(le),s(Dt),s(ne),s(Yt),s(ae),s(Ot),s(ie),s(Kt),s(oe),s(es),s(pe),s(ts),s(ss),s(me),s(ls),s(ns),s(ue),s(as),s(is),s(Me),s(os),s(he),s(ps),s(Te),s(rs),s(ye),s(ms),s(Je),s(cs),s(us),s(ds),s(Ue),s(Ms),s(hs),s(fe),s(Ts),s(je),s(ys),s(Js),s(Ce),s(gs),s(ws),s(Ne),s(Us),s(Re),s(bs),s(fs),s(Ie),s(js),s(Ee),s(vs),s(Cs),s(Be),s(xs),s($e),s(Ns),s(Rs),s(We),s(Zs),s(_e),s(Is),s(Xe),s(Es),s(Vs),s(Bs),s(Qe),s($s),s(Gs),s(Le),s(Ws),s(_s),s(Fe),s(Xs),s(ks),s(Ae),s(zs),s(Qs),s(De),s(Ss),s(Ye),s(Ls),s(qs),s(Ke),s(Fs),s(et),s(Hs),s(As),s(st),s(Ps),s(Ds),s(nt),s(Ys),s(at),s(Os),s(it),s(Ks),s(el),s(pt),s(tl),s(rt),s(sl),s(ct)),s(T),M(U,e),M(b,e),M(g,e),M(C,e),M(x,e),M(R,e),M(I,e),M(V,e),M($,e),M(W,e),M(X,e),M(z,e),M(S,e),M(q,e),M(H,e),M(D,e),M(ee,e),M(se,e),M(re,e),M(ce,e),M(de,e),M(ge,e),M(we,e),M(be,e),M(ve,e),M(xe,e),M(Ze,e),M(Ve,e),M(Ge,e),M(ke,e),M(ze,e),M(Se,e),M(qe,e),M(He,e),M(Pe,e),M(Oe,e),M(tt,e),M(lt,e),M(ot,e)}}}const jn='{"title":"Accelerated inference on NVIDIA GPUs","local":"accelerated-inference-on-nvidia-gpus","sections":[{"title":"CUDAExecutionProvider","local":"cudaexecutionprovider","sections":[{"title":"CUDA installation","local":"cuda-installation","sections":[],"depth":3},{"title":"Checking the CUDA installation is successful","local":"checking-the-cuda-installation-is-successful","sections":[],"depth":3},{"title":"Use CUDA execution provider with floating-point models","local":"use-cuda-execution-provider-with-floating-point-models","sections":[],"depth":3},{"title":"Use CUDA execution provider with quantized models","local":"use-cuda-execution-provider-with-quantized-models","sections":[],"depth":3},{"title":"Reduce memory footprint with IOBinding","local":"reduce-memory-footprint-with-iobinding","sections":[],"depth":3},{"title":"Observed time gains","local":"observed-time-gains","sections":[],"depth":3}],"depth":2},{"title":"TensorrtExecutionProvider","local":"tensorrtexecutionprovider","sections":[{"title":"TensorRT installation","local":"tensorrt-installation","sections":[],"depth":3},{"title":"Checking the TensorRT installation is successful","local":"checking-the-tensorrt-installation-is-successful","sections":[],"depth":3},{"title":"TensorRT engine build and warmup","local":"tensorrt-engine-build-and-warmup","sections":[{"title":"Warmup","local":"warmup","sections":[],"depth":4}],"depth":3},{"title":"Use TensorRT execution provider with floating-point models","local":"use-tensorrt-execution-provider-with-floating-point-models","sections":[],"depth":3},{"title":"Use TensorRT execution provider with quantized models","local":"use-tensorrt-execution-provider-with-quantized-models","sections":[],"depth":3},{"title":"TensorRT limitations for quantized models","local":"tensorrt-limitations-for-quantized-models","sections":[],"depth":3},{"title":"Observed time gains","local":"observed-time-gains","sections":[],"depth":3}],"depth":2}],"depth":1}';function vn(ut){return Mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class In extends Tn{constructor(T){super(),yn(this,T,vn,fn,dn,{})}}export{In as component};
