/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.naturalli.Operator;

public class OperatorSpec {
    public final Operator instance;
    public final int quantifierBegin;
    public final int quantifierEnd;
    public final int quantifierHead;
    public final int subjectBegin;
    public final int subjectEnd;
    public final int objectBegin;
    public final int objectEnd;

    public OperatorSpec(Operator instance, int quantifierBegin, int quantifierEnd, int subjectBegin, int subjectEnd, int objectBegin, int objectEnd) {
        this.instance = instance;
        this.quantifierBegin = quantifierBegin;
        this.quantifierEnd = quantifierEnd;
        this.quantifierHead = quantifierEnd - 1;
        this.subjectBegin = subjectBegin;
        this.subjectEnd = subjectEnd;
        this.objectBegin = objectBegin;
        this.objectEnd = objectEnd;
    }

    protected OperatorSpec(Operator instance, int quantifierBegin, int quantifierEnd, int subjectBegin, int subjectEnd, int objectBegin, int objectEnd, int sentenceLength) {
        this(instance, Math.max(0, Math.min(sentenceLength - 1, quantifierBegin)), Math.max(0, Math.min(sentenceLength, quantifierEnd)), Math.max(0, Math.min(sentenceLength - 1, subjectBegin)), Math.max(0, Math.min(sentenceLength, subjectEnd)), Math.max(0, objectBegin == sentenceLength ? sentenceLength : Math.min(sentenceLength - 1, objectBegin)), Math.max(0, Math.min(sentenceLength, objectEnd)));
    }

    public boolean isExplicit() {
        return this.instance != Operator.IMPLICIT_NAMED_ENTITY;
    }

    public boolean isBinary() {
        return this.objectEnd > this.objectBegin;
    }

    public int quantifierLength() {
        return this.quantifierEnd - this.quantifierBegin;
    }

    public String toString() {
        return "QuantifierScope{subjectBegin=" + this.subjectBegin + ", subjectEnd=" + this.subjectEnd + ", objectBegin=" + this.objectBegin + ", objectEnd=" + this.objectEnd + '}';
    }

    public static OperatorSpec merge(OperatorSpec x, OperatorSpec y) {
        assert (x.quantifierBegin == y.quantifierBegin);
        assert (x.quantifierEnd == y.quantifierEnd);
        assert (x.instance == y.instance);
        return new OperatorSpec(x.instance, Math.min(x.quantifierBegin, y.quantifierBegin), Math.min(x.quantifierEnd, y.quantifierEnd), Math.min(x.subjectBegin, y.subjectBegin), Math.max(x.subjectEnd, y.subjectEnd), Math.min(x.objectBegin, y.objectBegin), Math.max(x.objectEnd, y.objectEnd));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperatorSpec)) {
            return false;
        }
        OperatorSpec that = (OperatorSpec)o;
        if (this.objectBegin != that.objectBegin) {
            return false;
        }
        if (this.objectEnd != that.objectEnd) {
            return false;
        }
        if (this.quantifierBegin != that.quantifierBegin) {
            return false;
        }
        if (this.quantifierEnd != that.quantifierEnd) {
            return false;
        }
        if (this.quantifierHead != that.quantifierHead) {
            return false;
        }
        if (this.subjectBegin != that.subjectBegin) {
            return false;
        }
        if (this.subjectEnd != that.subjectEnd) {
            return false;
        }
        return this.instance == that.instance;
    }

    public int hashCode() {
        int result = this.instance != null ? this.instance.hashCode() : 0;
        result = 31 * result + this.quantifierBegin;
        result = 31 * result + this.quantifierEnd;
        result = 31 * result + this.quantifierHead;
        result = 31 * result + this.subjectBegin;
        result = 31 * result + this.subjectEnd;
        result = 31 * result + this.objectBegin;
        result = 31 * result + this.objectEnd;
        return result;
    }
}

