/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.parser.nndep.Configuration;
import edu.stanford.nlp.parser.nndep.DependencyTree;
import edu.stanford.nlp.parser.nndep.ParsingSystem;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.List;

public class ArcStandard
extends ParsingSystem {
    private boolean singleRoot = true;

    public ArcStandard(TreebankLanguagePack tlp, List<String> labels, boolean verbose) {
        super(tlp, labels, verbose);
    }

    @Override
    public boolean isTerminal(Configuration c) {
        return c.getStackSize() == 1 && c.getBufferSize() == 0;
    }

    @Override
    public void makeTransitions() {
        this.transitions = new ArrayList();
        for (String label : this.labels) {
            this.transitions.add("L(" + label + ")");
        }
        for (String label : this.labels) {
            this.transitions.add("R(" + label + ")");
        }
        this.transitions.add("S");
    }

    @Override
    public Configuration initialConfiguration(CoreMap s) {
        Configuration c = new Configuration(s);
        int length = ((List)s.get(CoreAnnotations.TokensAnnotation.class)).size();
        for (int i = 1; i <= length; ++i) {
            c.tree.add(-1, "-UNKNOWN-");
            c.buffer.add(i);
        }
        c.stack.add(0);
        return c;
    }

    @Override
    public boolean canApply(Configuration c, String t) {
        if (t.startsWith("L") || t.startsWith("R")) {
            int h;
            String label = t.substring(2, t.length() - 1);
            int n = h = t.startsWith("L") ? c.getStack(0) : c.getStack(1);
            if (h < 0) {
                return false;
            }
            if (h == 0 && !label.equals(this.rootLabel)) {
                return false;
            }
        }
        int nStack = c.getStackSize();
        int nBuffer = c.getBufferSize();
        if (t.startsWith("L")) {
            return nStack > 2;
        }
        if (t.startsWith("R")) {
            if (this.singleRoot) {
                return nStack > 2 || nStack == 2 && nBuffer == 0;
            }
            return nStack >= 2;
        }
        return nBuffer > 0;
    }

    @Override
    public void apply(Configuration c, String t) {
        int w1 = c.getStack(1);
        int w2 = c.getStack(0);
        if (t.startsWith("L")) {
            c.addArc(w2, w1, t.substring(2, t.length() - 1));
            c.removeSecondTopStack();
        } else if (t.startsWith("R")) {
            c.addArc(w1, w2, t.substring(2, t.length() - 1));
            c.removeTopStack();
        } else {
            c.shift();
        }
    }

    @Override
    public String getOracle(Configuration c, DependencyTree dTree) {
        int w1 = c.getStack(1);
        int w2 = c.getStack(0);
        if (w1 > 0 && dTree.getHead(w1) == w2) {
            return "L(" + dTree.getLabel(w1) + ")";
        }
        if (w1 >= 0 && dTree.getHead(w2) == w1 && !c.hasOtherChild(w2, dTree)) {
            return "R(" + dTree.getLabel(w2) + ")";
        }
        return "S";
    }

    public boolean canReach(Configuration c, DependencyTree dTree) {
        int j;
        int i;
        int n = c.getSentenceSize();
        for (int i2 = 1; i2 <= n; ++i2) {
            if (c.getHead(i2) == -1 || c.getHead(i2) == dTree.getHead(i2)) continue;
            return false;
        }
        boolean[] inBuffer = new boolean[n + 1];
        boolean[] depInList = new boolean[n + 1];
        int[] leftL = new int[n + 2];
        int[] rightL = new int[n + 2];
        for (int i3 = 0; i3 < c.getBufferSize(); ++i3) {
            inBuffer[c.buffer.get((int)i3).intValue()] = true;
        }
        int nLeft = c.getStackSize();
        for (int i4 = 0; i4 < nLeft; ++i4) {
            int x;
            leftL[nLeft - i4] = x = c.stack.get(i4).intValue();
            if (x <= 0) continue;
            depInList[dTree.getHead((int)x)] = true;
        }
        int nRight = 1;
        rightL[nRight] = leftL[1];
        for (int i5 = 0; i5 < c.getBufferSize(); ++i5) {
            boolean inList = false;
            int x = c.buffer.get(i5);
            if (inBuffer[dTree.getHead(x)] && !depInList[x]) continue;
            rightL[++nRight] = x;
            depInList[dTree.getHead((int)x)] = true;
        }
        int[][] g = new int[nLeft + 1][nRight + 1];
        for (i = 1; i <= nLeft; ++i) {
            for (j = 1; j <= nRight; ++j) {
                g[i][j] = -1;
            }
        }
        g[1][1] = leftL[1];
        for (i = 1; i <= nLeft; ++i) {
            for (j = 1; j <= nRight; ++j) {
                if (g[i][j] == -1) continue;
                int x = g[i][j];
                if (j < nRight && dTree.getHead(rightL[j + 1]) == x) {
                    g[i][j + 1] = x;
                }
                if (j < nRight && dTree.getHead(x) == rightL[j + 1]) {
                    g[i][j + 1] = rightL[j + 1];
                }
                if (i < nLeft && dTree.getHead(leftL[i + 1]) == x) {
                    g[i + 1][j] = x;
                }
                if (i >= nLeft || dTree.getHead(x) != leftL[i + 1]) continue;
                g[i + 1][j] = leftL[i + 1];
            }
        }
        return g[nLeft][nRight] != -1;
    }

    @Override
    public boolean isOracle(Configuration c, String t, DependencyTree dTree) {
        if (!this.canApply(c, t)) {
            return false;
        }
        if (t.startsWith("L") && !dTree.getLabel(c.getStack(1)).equals(t.substring(2, t.length() - 1))) {
            return false;
        }
        if (t.startsWith("R") && !dTree.getLabel(c.getStack(0)).equals(t.substring(2, t.length() - 1))) {
            return false;
        }
        Configuration ct = new Configuration(c);
        this.apply(ct, t);
        return this.canReach(ct, dTree);
    }
}

