/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scoref;

import edu.stanford.nlp.hcoref.CorefDocMaker;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Properties;

public interface DocumentProcessor {
    public void process(int var1, Document var2);

    public void finish() throws Exception;

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    default public void run(Properties props, Dictionaries dictionaries) throws Exception {
        this.run(new CorefDocMaker(props, dictionaries));
    }

    default public void runFromScratch(Properties props, Dictionaries dictionaries) throws Exception {
        StanfordCoreNLP.clearAnnotatorPool();
        this.run(new CorefDocMaker(props, dictionaries));
    }

    default public void run(CorefDocMaker docMaker) throws Exception {
        Redwood.hideChannelsEverywhere("debug-mention", "debug-preprocessor", "debug-docreader", "debug-md");
        int docId = 0;
        Document document = docMaker.nextDoc();
        long time = System.currentTimeMillis();
        while (document != null) {
            document.extractGoldCorefClusters();
            this.process(docId, document);
            Redwood.log("scoref", "Processed document " + docId + " in " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s with " + this.getName());
            time = System.currentTimeMillis();
            ++docId;
            document = docMaker.nextDoc();
        }
        this.finish();
    }
}

