/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.sentiment.AbstractEvaluate;
import edu.stanford.nlp.sentiment.SentimentCostAndGradient;
import edu.stanford.nlp.sentiment.SentimentModel;
import edu.stanford.nlp.sentiment.SentimentUtils;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.List;

public class Evaluate
extends AbstractEvaluate {
    final SentimentCostAndGradient cag;
    final SentimentModel model;

    public Evaluate(SentimentModel model) {
        super(model.op);
        this.model = model;
        this.cag = new SentimentCostAndGradient(model, null);
    }

    @Override
    public void populatePredictedLabels(List<Tree> trees) {
        for (Tree tree : trees) {
            this.cag.forwardPropagateTree(tree);
        }
    }

    public static void main(String[] args) {
        String modelPath = null;
        String treePath = null;
        boolean filterUnknown = false;
        ArrayList<String> remainingArgs = Generics.newArrayList();
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-model")) {
                modelPath = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-treebank")) {
                treePath = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-filterUnknown")) {
                filterUnknown = true;
                ++argIndex;
                continue;
            }
            remainingArgs.add(args[argIndex]);
            ++argIndex;
        }
        String[] newArgs = new String[remainingArgs.size()];
        remainingArgs.toArray(newArgs);
        SentimentModel model = SentimentModel.loadSerialized(modelPath);
        int argIndex2 = 0;
        while (argIndex2 < newArgs.length) {
            int newIndex = model.op.setOption(newArgs, argIndex2);
            if (argIndex2 == newIndex) {
                System.err.println("Unknown argument " + newArgs[argIndex2]);
                throw new IllegalArgumentException("Unknown argument " + newArgs[argIndex2]);
            }
            argIndex2 = newIndex;
        }
        List<Tree> trees = SentimentUtils.readTreesWithGoldLabels(treePath);
        if (filterUnknown) {
            trees = SentimentUtils.filterUnknownRoots(trees);
        }
        Evaluate eval = new Evaluate(model);
        eval.eval(trees);
        eval.printSummary();
    }
}

