/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.negra.NegraHeadFinder;
import edu.stanford.nlp.trees.international.negra.NegraPennTreeReaderFactory;

public class NegraPennLanguagePack
extends AbstractTreebankLanguagePack {
    private static final long serialVersionUID = 9081305982861675328L;
    private boolean leaveGF = false;
    private static String[] gfToKeepArray = new String[]{"SB", "OA", "DA"};
    private static final String NEGRA_ENCODING = "ISO-8859-1";
    private static final String[] evalBignoredTags = new String[]{"$.", "$,"};
    private static final String[] negraSFPunctTags = new String[]{"$."};
    private static final String[] negraSFPunctWords = new String[]{".", "!", "?"};
    private static final String[] negraPunctTags = new String[]{"$.", "$,", "$*LRB*"};
    private static final String[] negraPunctWords = new String[]{"-", ",", ";", ":", "!", "?", "/", ".", "...", "\u00b7", "'", "\"", "(", ")", "*LRB*", "*RRB*"};
    private static char[] annotationIntroducingChars = new char[]{'-', '%', '=', '|', '#', '^', '~'};
    private static String[] pennStartSymbols = new String[]{"ROOT"};

    public NegraPennLanguagePack() {
        this(false, '-');
    }

    public NegraPennLanguagePack(boolean leaveGF) {
        this(leaveGF, '-');
    }

    public NegraPennLanguagePack(boolean leaveGF, char gfChar) {
        super(gfChar);
        this.leaveGF = leaveGF;
    }

    @Override
    public String[] punctuationTags() {
        return negraPunctTags;
    }

    @Override
    public String[] punctuationWords() {
        return negraPunctWords;
    }

    @Override
    public String[] sentenceFinalPunctuationTags() {
        return negraSFPunctTags;
    }

    @Override
    public String[] sentenceFinalPunctuationWords() {
        return negraSFPunctWords;
    }

    @Override
    public String basicCategory(String category) {
        String basicCat = this.leaveGF ? this.stripGF(category) : super.basicCategory(category);
        return basicCat;
    }

    @Override
    public String stripGF(String category) {
        if (category == null) {
            return null;
        }
        int index = category.lastIndexOf(this.gfCharacter);
        if (index > 0 && !NegraPennLanguagePack.containsKeptGF(category, index)) {
            category = category.substring(0, index);
        }
        return category;
    }

    private static boolean containsKeptGF(String category, int index) {
        for (String gf : gfToKeepArray) {
            int gfLength = gf.length();
            if (gfLength >= category.length() - index || !category.substring(index + 1, index + 1 + gfLength).equals(gf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] evalBIgnoredPunctuationTags() {
        return evalBignoredTags;
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    @Override
    public String[] startSymbols() {
        return pennStartSymbols;
    }

    @Override
    public String getEncoding() {
        return NEGRA_ENCODING;
    }

    @Override
    public String treebankFileExtension() {
        return "mrg";
    }

    public boolean isLeaveGF() {
        return this.leaveGF;
    }

    public void setLeaveGF(boolean leaveGF) {
        this.leaveGF = leaveGF;
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return new NegraPennTreeReaderFactory(this);
    }

    @Override
    public HeadFinder headFinder() {
        return new NegraHeadFinder(this);
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return new NegraHeadFinder(this);
    }

    public TokenizerFactory<Word> getTokenizerFactory() {
        return PTBTokenizer.factory();
    }
}

