/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.common;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.metrics.Eval;
import edu.stanford.nlp.parser.metrics.ParserQueryEval;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Timing;
import java.io.IOException;
import java.util.List;

public abstract class ParserGrammar
implements Function<List<? extends HasWord>, Tree> {
    public abstract ParserQuery parserQuery();

    @Override
    public abstract Tree apply(List<? extends HasWord> var1);

    public abstract List<Eval> getExtraEvals();

    public abstract List<ParserQueryEval> getParserQueryEvals();

    public abstract Options getOp();

    public abstract TreebankLangParserParams getTLPParams();

    public abstract TreebankLanguagePack treebankLanguagePack();

    public abstract String[] defaultCoreNLPFlags();

    public abstract void setOptionFlags(String ... var1);

    public abstract boolean requiresTags();

    public static ParserGrammar loadModel(String path, String ... extraFlags) {
        ParserGrammar parser;
        try {
            Timing timing = new Timing();
            System.err.print("Loading parser from serialized file " + path + " ...");
            parser = (ParserGrammar)IOUtils.readObjectFromURLOrClasspathOrFileSystem(path);
            timing.done();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeIOException(e);
        }
        if (extraFlags.length > 0) {
            parser.setOptionFlags(extraFlags);
        }
        return parser;
    }
}

