/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.ClassifierFactory;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.naturalli.ClauseSplitter;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.naturalli.Util;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.FixedPrioritiesPriorityQueue;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ClauseSplitterSearchProblem {
    protected static final Map<String, List<String>> HARD_SPLITS = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
        {
            this.put("comp", new ArrayList<String>(){
                {
                    this.add("simple");
                }
            });
            this.put("ccomp", new ArrayList<String>(){
                {
                    this.add("simple");
                }
            });
            this.put("xcomp", new ArrayList<String>(){
                {
                    this.add("clone_dobj");
                    this.add("clone_nsubj");
                    this.add("simple");
                }
            });
            this.put("vmod", new ArrayList<String>(){
                {
                    this.add("clone_nsubj");
                    this.add("simple");
                }
            });
            this.put("csubj", new ArrayList<String>(){
                {
                    this.add("clone_dobj");
                    this.add("simple");
                }
            });
            this.put("advcl", new ArrayList<String>(){
                {
                    this.add("clone_nsubj");
                    this.add("simple");
                }
            });
            this.put("conj:*", new ArrayList<String>(){
                {
                    this.add("clone_nsubj");
                    this.add("clone_dobj");
                    this.add("simple");
                }
            });
            this.put("acl:relcl", new ArrayList<String>(){
                {
                    this.add("simple");
                }
            });
        }
    });
    protected static final Set<String> INDIRECT_SPEECH_LEMMAS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("report");
            this.add("say");
            this.add("told");
            this.add("claim");
            this.add("assert");
            this.add("think");
            this.add("believe");
            this.add("suppose");
        }
    });
    public final SemanticGraph tree;
    public final boolean assumedTruth;
    public final int sentenceLength;
    private final Map<IndexedWord, Collection<SemanticGraphEdge>> extraEdgesByGovernor = new HashMap<IndexedWord, Collection<SemanticGraphEdge>>();
    private final Map<IndexedWord, Collection<SemanticGraphEdge>> extraEdgesByDependent = new HashMap<IndexedWord, Collection<SemanticGraphEdge>>();
    private final Optional<Classifier<ClauseSplitter.ClauseClassifierLabel, String>> isClauseClassifier;
    private final Optional<Function<Triple<State, Action, State>, Counter<String>>> featurizer;
    private final Index<SemanticGraphEdge> edgeToIndex = new HashIndex<SemanticGraphEdge>(ArrayList::new, IdentityHashMap::new);
    public static final Featurizer DEFAULT_FEATURIZER = new Featurizer(){
        private static final long serialVersionUID = 4145523451314579506L;

        @Override
        public boolean isSimpleSplit(Counter<String> feats) {
            for (String key : feats.keySet()) {
                if (!key.startsWith("simple&")) continue;
                return true;
            }
            return false;
        }

        @Override
        public Counter<String> apply(Triple<State, Action, State> triple) {
            String edgeRelShort;
            State from = (State)triple.first;
            Action action = (Action)triple.second;
            State to = (State)triple.third;
            String signature = action.signature();
            String edgeRelTaken = to.edge == null ? "root" : to.edge.getRelation().toString();
            String string = edgeRelShort = to.edge == null ? "root" : to.edge.getRelation().getShortName();
            if (edgeRelShort.contains("_")) {
                edgeRelShort = edgeRelShort.substring(0, edgeRelShort.indexOf("_"));
            }
            boolean parentHasSubj = false;
            boolean parentHasObj = false;
            boolean childHasSubj = false;
            boolean childHasObj = false;
            ClassicCounter<String> feats = new ClassicCounter<String>();
            feats.incrementCount(signature + "&edge:" + edgeRelTaken);
            feats.incrementCount(signature + "&edge_type:" + edgeRelShort);
            if (from.edge == null) {
                assert (to.edge == null || to.originalTree().getRoots().contains(to.edge.getGovernor()));
                feats.incrementCount(signature + "&at_root");
                feats.incrementCount(signature + "&at_root&root_pos:" + to.originalTree().getFirstRoot().tag());
            } else {
                feats.incrementCount(signature + "&not_root");
                Object lastRelShort = from.edge.getRelation().getShortName();
                if (((String)lastRelShort).contains("_")) {
                    lastRelShort = ((String)lastRelShort).substring(0, ((String)lastRelShort).indexOf("_"));
                }
                feats.incrementCount(signature + "&last_edge:" + (String)lastRelShort);
            }
            if (to.edge != null) {
                for (SemanticGraphEdge parentNeighbor : from.originalTree().outgoingEdgeIterable(to.edge.getGovernor())) {
                    if (parentNeighbor == to.edge) continue;
                    String parentNeighborRel = parentNeighbor.getRelation().toString();
                    if (parentNeighborRel.contains("subj")) {
                        parentHasSubj = true;
                    }
                    if (parentNeighborRel.contains("obj")) {
                        parentHasObj = true;
                    }
                    feats.incrementCount(signature + "&parent_neighbor:" + parentNeighborRel);
                    feats.incrementCount(signature + "&edge_type:" + edgeRelShort + "&parent_neighbor:" + parentNeighborRel);
                }
                int childNeighborCount = 0;
                for (SemanticGraphEdge childNeighbor : from.originalTree().outgoingEdgeIterable(to.edge.getDependent())) {
                    String childNeighborRel = childNeighbor.getRelation().toString();
                    if (childNeighborRel.contains("subj")) {
                        childHasSubj = true;
                    }
                    if (childNeighborRel.contains("obj")) {
                        childHasObj = true;
                    }
                    ++childNeighborCount;
                    feats.incrementCount(signature + "&child_neighbor:" + childNeighborRel);
                    feats.incrementCount(signature + "&edge_type:" + edgeRelShort + "&child_neighbor:" + childNeighborRel);
                }
                feats.incrementCount(signature + "&child_neighbor_count:" + (childNeighborCount < 3 ? Integer.valueOf(childNeighborCount) : ">2"));
                feats.incrementCount(signature + "&edge_type:" + edgeRelShort + "&child_neighbor_count:" + (childNeighborCount < 3 ? Integer.valueOf(childNeighborCount) : ">2"));
                feats.incrementCount(signature + "&parent_neighbor_subj:" + parentHasSubj);
                feats.incrementCount(signature + "&parent_neighbor_obj:" + parentHasObj);
                feats.incrementCount(signature + "&child_neighbor_subj:" + childHasSubj);
                feats.incrementCount(signature + "&child_neighbor_obj:" + childHasObj);
                feats.incrementCount(signature + "&parent_pos:" + to.edge.getGovernor().tag());
                feats.incrementCount(signature + "&child_pos:" + to.edge.getDependent().tag());
                feats.incrementCount(signature + "&pos_signature:" + to.edge.getGovernor().tag() + "_" + to.edge.getDependent().tag());
                feats.incrementCount(signature + "&edge_type:" + edgeRelShort + "&pos_signature:" + to.edge.getGovernor().tag() + "_" + to.edge.getDependent().tag());
            }
            return feats;
        }
    };

    protected ClauseSplitterSearchProblem(SemanticGraph tree, boolean assumedTruth, Optional<Classifier<ClauseSplitter.ClauseClassifierLabel, String>> isClauseClassifier, Optional<Function<Triple<State, Action, State>, Counter<String>>> featurizer) {
        this.tree = new SemanticGraph(tree);
        this.assumedTruth = assumedTruth;
        this.isClauseClassifier = isClauseClassifier;
        this.featurizer = featurizer;
        this.tree.edgeIterable().forEach(this.edgeToIndex::addToIndex);
        List<IndexedWord> sortedVertices = tree.vertexListSorted();
        this.sentenceLength = sortedVertices.get(sortedVertices.size() - 1).index();
        for (IndexedWord vertex : sortedVertices) {
            this.extraEdgesByGovernor.put(vertex, new ArrayList());
            this.extraEdgesByDependent.put(vertex, new ArrayList());
        }
        List<SemanticGraphEdge> extraEdges = Util.cleanTree(this.tree);
        assert (Util.isTree(this.tree));
        for (SemanticGraphEdge edge : extraEdges) {
            this.extraEdgesByGovernor.get(edge.getGovernor()).add(edge);
            this.extraEdgesByDependent.get(edge.getDependent()).add(edge);
        }
    }

    public ClauseSplitterSearchProblem(SemanticGraph tree, boolean assumedTruth) {
        this(tree, assumedTruth, Optional.empty(), Optional.empty());
    }

    static void splitToChildOfEdge(SemanticGraph tree, SemanticGraphEdge toKeep) {
        LinkedList<IndexedWord> fringe = new LinkedList<IndexedWord>();
        ArrayList<IndexedWord> nodesToRemove = new ArrayList<IndexedWord>();
        for (IndexedWord root : tree.getRoots()) {
            nodesToRemove.add(root);
            for (SemanticGraphEdge out2 : tree.outgoingEdgeIterable(root)) {
                if (out2.equals(toKeep)) continue;
                fringe.add(out2.getDependent());
            }
        }
        while (!fringe.isEmpty()) {
            IndexedWord node = (IndexedWord)fringe.poll();
            nodesToRemove.add(node);
            for (SemanticGraphEdge out3 : tree.outgoingEdgeIterable(node)) {
                if (out3.equals(toKeep)) continue;
                fringe.add(out3.getDependent());
            }
        }
        nodesToRemove.forEach(tree::removeVertex);
        tree.setRoot(toKeep.getDependent());
    }

    private void simpleClause(SemanticGraph tree, SemanticGraphEdge toKeep) {
        ClauseSplitterSearchProblem.splitToChildOfEdge(tree, toKeep);
        HashMap<IndexedWord, IndexedWord> refReplaceMap = new HashMap<IndexedWord, IndexedWord>();
        for (IndexedWord indexedWord : tree.vertexSet()) {
            for (SemanticGraphEdge edge : this.extraEdgesByDependent.get(indexedWord)) {
                if (!"ref".equals(edge.getRelation().toString()) || tree.containsVertex(edge.getGovernor())) continue;
                refReplaceMap.put(indexedWord, edge.getGovernor());
            }
        }
        for (Map.Entry entry : refReplaceMap.entrySet()) {
            Iterator<SemanticGraphEdge> iter = tree.incomingEdgeIterator((IndexedWord)entry.getKey());
            if (!iter.hasNext()) continue;
            SemanticGraphEdge incomingEdge = iter.next();
            IndexedWord governor = incomingEdge.getGovernor();
            tree.removeVertex((IndexedWord)entry.getKey());
            ClauseSplitterSearchProblem.addSubtree(tree, governor, incomingEdge.getRelation().toString(), this.tree, (IndexedWord)entry.getValue(), this.tree.incomingEdgeList(tree.getFirstRoot()));
        }
    }

    private static void addWord(SemanticGraph toModify, IndexedWord root, String rel, CoreLabel coreLabel) {
        IndexedWord dependent = new IndexedWord(coreLabel);
        toModify.addVertex(dependent);
        toModify.addEdge(root, dependent, GrammaticalRelation.valueOf(Language.English, rel), Double.NEGATIVE_INFINITY, false);
    }

    private static void addSubtree(SemanticGraph toModify, IndexedWord root, String rel, SemanticGraph originalTree, IndexedWord subject, Collection<SemanticGraphEdge> ignoredEdges) {
        if (toModify.containsVertex(subject)) {
            return;
        }
        LinkedList<IndexedWord> fringe = new LinkedList<IndexedWord>();
        ArrayList<IndexedWord> wordsToAdd = new ArrayList<IndexedWord>();
        ArrayList<SemanticGraphEdge> edgesToAdd = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge semanticGraphEdge : originalTree.outgoingEdgeIterable(subject)) {
            if (ignoredEdges.contains(semanticGraphEdge)) continue;
            if (toModify.containsVertex(semanticGraphEdge.getDependent())) {
                return;
            }
            edgesToAdd.add(semanticGraphEdge);
            fringe.add(semanticGraphEdge.getDependent());
        }
        while (!fringe.isEmpty()) {
            IndexedWord node = (IndexedWord)fringe.poll();
            wordsToAdd.add(node);
            for (SemanticGraphEdge edge : originalTree.outgoingEdgeIterable(node)) {
                if (ignoredEdges.contains(edge)) continue;
                if (toModify.containsVertex(edge.getDependent())) {
                    return;
                }
                edgesToAdd.add(edge);
                fringe.add(edge.getDependent());
            }
        }
        toModify.addVertex(subject);
        toModify.addEdge(root, subject, GrammaticalRelation.valueOf(Language.English, rel), Double.NEGATIVE_INFINITY, false);
        wordsToAdd.forEach(toModify::addVertex);
        for (SemanticGraphEdge semanticGraphEdge : edgesToAdd) {
            assert (!toModify.incomingEdgeIterator(semanticGraphEdge.getDependent()).hasNext());
            toModify.addEdge(semanticGraphEdge.getGovernor(), semanticGraphEdge.getDependent(), semanticGraphEdge.getRelation(), semanticGraphEdge.getWeight(), semanticGraphEdge.isExtra());
        }
    }

    private void stripAuxMark(SemanticGraph toModify) {
        ArrayList<SemanticGraphEdge> toClean = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : toModify.outgoingEdgeIterable(toModify.getFirstRoot())) {
            String rel = edge.getRelation().toString();
            if (!"aux".equals(rel) && !"mark".equals(rel) || toModify.outgoingEdgeIterator(edge.getDependent()).hasNext()) continue;
            toClean.add(edge);
        }
        for (SemanticGraphEdge edge : toClean) {
            toModify.removeEdge(edge);
            toModify.removeVertex(edge.getDependent());
        }
    }

    private CoreLabel mockNode(CoreLabel toCopy, String word, String POS) {
        CoreLabel mock = new CoreLabel(toCopy);
        mock.setWord(word);
        mock.setLemma(word);
        mock.setValue(word);
        mock.setNER("O");
        mock.setTag(POS);
        mock.setIndex(this.sentenceLength + 5);
        return mock;
    }

    public List<SentenceFragment> topClauses(double thresholdProbability) {
        ArrayList<SentenceFragment> results = new ArrayList<SentenceFragment>();
        this.search(triple -> {
            assert ((Double)triple.first <= 0.0);
            double prob = Math.exp((Double)triple.first);
            assert (prob <= 1.0);
            assert (prob >= 0.0);
            assert (!Double.isNaN(prob));
            if (prob >= thresholdProbability) {
                SentenceFragment fragment = (SentenceFragment)((Supplier)triple.third).get();
                fragment.score = prob;
                results.add(fragment);
                return true;
            }
            return false;
        });
        return results;
    }

    public void search(Predicate<Triple<Double, List<Counter<String>>, Supplier<SentenceFragment>>> candidateFragments) {
        if (!this.isClauseClassifier.isPresent()) {
            this.search(candidateFragments, new LinearClassifier<ClauseSplitter.ClauseClassifierLabel, String>(new ClassicCounter()), HARD_SPLITS, this.featurizer.isPresent() ? this.featurizer.get() : DEFAULT_FEATURIZER, 1000);
        } else {
            if (!(this.isClauseClassifier.get() instanceof LinearClassifier)) {
                throw new IllegalArgumentException("For now, only linear classifiers are supported");
            }
            this.search(candidateFragments, this.isClauseClassifier.get(), HARD_SPLITS, this.featurizer.get(), 1000);
        }
    }

    public void search(Predicate<Triple<Double, List<Counter<String>>, Supplier<SentenceFragment>>> candidateFragments, Classifier<ClauseSplitter.ClauseClassifierLabel, String> classifier, Map<String, List<String>> hardCodedSplits, Function<Triple<State, Action, State>, Counter<String>> featurizer, int maxTicks) {
        ArrayList<Action> actionSpace = new ArrayList<Action>();
        actionSpace.add(new Action(){

            @Override
            public String signature() {
                return "simple";
            }

            @Override
            public boolean prerequisitesMet(SemanticGraph originalTree, SemanticGraphEdge edge) {
                char tag = edge.getDependent().tag().charAt(0);
                return tag == 'V' || tag == 'N' || tag == 'J' || tag == 'P' || tag == 'D';
            }

            @Override
            public Optional<State> applyTo(SemanticGraph tree, State source, SemanticGraphEdge outgoingEdge, SemanticGraphEdge subjectOrNull, SemanticGraphEdge objectOrNull) {
                return Optional.of(new State(outgoingEdge, subjectOrNull == null ? source.subjectOrNull : subjectOrNull, subjectOrNull == null ? source.distanceFromSubj + 1 : 0, objectOrNull == null ? source.objectOrNull : objectOrNull, source.thunk.andThen(toModify -> {
                    assert (Util.isTree(toModify));
                    ClauseSplitterSearchProblem.this.simpleClause(toModify, outgoingEdge);
                    if (outgoingEdge.getRelation().toString().endsWith("comp")) {
                        ClauseSplitterSearchProblem.this.stripAuxMark(toModify);
                    }
                    assert (Util.isTree(toModify));
                }), false));
            }
        });
        actionSpace.add(new Action(){

            @Override
            public String signature() {
                return "clone_root_as_nsubjpass";
            }

            @Override
            public boolean prerequisitesMet(SemanticGraph originalTree, SemanticGraphEdge edge) {
                Iterator<SemanticGraphEdge> iter = originalTree.outgoingEdgeIterable(edge.getGovernor()).iterator();
                if (!iter.hasNext()) {
                    return false;
                }
                boolean nontrivialEdge = false;
                block7: while (iter.hasNext()) {
                    SemanticGraphEdge outEdge = iter.next();
                    switch (outEdge.getRelation().toString()) {
                        case "nn": 
                        case "amod": {
                            continue block7;
                        }
                    }
                    if (nontrivialEdge) {
                        return false;
                    }
                    nontrivialEdge = true;
                }
                return true;
            }

            @Override
            public Optional<State> applyTo(SemanticGraph tree, State source, SemanticGraphEdge outgoingEdge, SemanticGraphEdge subjectOrNull, SemanticGraphEdge objectOrNull) {
                return Optional.of(new State(outgoingEdge, subjectOrNull == null ? source.subjectOrNull : subjectOrNull, subjectOrNull == null ? source.distanceFromSubj + 1 : 0, objectOrNull == null ? source.objectOrNull : objectOrNull, source.thunk.andThen(toModify -> {
                    assert (Util.isTree(toModify));
                    ClauseSplitterSearchProblem.this.simpleClause(toModify, outgoingEdge);
                    ClauseSplitterSearchProblem.addSubtree(toModify, outgoingEdge.getDependent(), "nsubjpass", tree, outgoingEdge.getGovernor(), Collections.singleton(outgoingEdge));
                    assert (Util.isTree(toModify));
                }), true));
            }
        });
        actionSpace.add(new Action(){

            @Override
            public String signature() {
                return "clone_nsubj";
            }

            @Override
            public boolean prerequisitesMet(SemanticGraph originalTree, SemanticGraphEdge edge) {
                char tag = edge.getDependent().tag().charAt(0);
                if (tag != 'V' && tag != 'N') {
                    return false;
                }
                for (SemanticGraphEdge grandchild : originalTree.outgoingEdgeIterable(edge.getDependent())) {
                    if (!grandchild.getRelation().toString().contains("subj")) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Optional<State> applyTo(SemanticGraph tree, State source, SemanticGraphEdge outgoingEdge, SemanticGraphEdge subjectOrNull, SemanticGraphEdge objectOrNull) {
                if (subjectOrNull != null && !outgoingEdge.equals(subjectOrNull)) {
                    return Optional.of(new State(outgoingEdge, subjectOrNull, 0, objectOrNull == null ? source.objectOrNull : objectOrNull, source.thunk.andThen(toModify -> {
                        assert (Util.isTree(toModify));
                        ClauseSplitterSearchProblem.this.simpleClause(toModify, outgoingEdge);
                        ClauseSplitterSearchProblem.addSubtree(toModify, outgoingEdge.getDependent(), "nsubj", tree, subjectOrNull.getDependent(), Collections.singleton(outgoingEdge));
                        assert (Util.isTree(toModify));
                        ClauseSplitterSearchProblem.this.stripAuxMark(toModify);
                        assert (Util.isTree(toModify));
                    }), false));
                }
                return Optional.empty();
            }
        });
        actionSpace.add(new Action(){

            @Override
            public String signature() {
                return "clone_dobj";
            }

            @Override
            public boolean prerequisitesMet(SemanticGraph originalTree, SemanticGraphEdge edge) {
                char tag = edge.getDependent().tag().charAt(0);
                if (tag != 'V' && tag != 'N') {
                    return false;
                }
                for (SemanticGraphEdge grandchild : originalTree.outgoingEdgeIterable(edge.getDependent())) {
                    if (!grandchild.getRelation().toString().contains("subj")) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Optional<State> applyTo(SemanticGraph tree, State source, SemanticGraphEdge outgoingEdge, SemanticGraphEdge subjectOrNull, SemanticGraphEdge objectOrNull) {
                if (objectOrNull != null && !outgoingEdge.equals(objectOrNull)) {
                    return Optional.of(new State(outgoingEdge, subjectOrNull == null ? source.subjectOrNull : subjectOrNull, subjectOrNull == null ? source.distanceFromSubj + 1 : 0, objectOrNull, source.thunk.andThen(toModify -> {
                        assert (Util.isTree(toModify));
                        ClauseSplitterSearchProblem.this.simpleClause(toModify, outgoingEdge);
                        ClauseSplitterSearchProblem.addSubtree(toModify, outgoingEdge.getDependent(), "nsubj", tree, objectOrNull.getDependent(), Collections.singleton(outgoingEdge));
                        assert (Util.isTree(toModify));
                        ClauseSplitterSearchProblem.this.stripAuxMark(toModify);
                        assert (Util.isTree(toModify));
                    }), false));
                }
                return Optional.empty();
            }
        });
        for (IndexedWord root : this.tree.getRoots()) {
            this.search(root, candidateFragments, classifier, hardCodedSplits, featurizer, actionSpace, maxTicks);
        }
    }

    private Collection<Action> orderActions(Collection<Action> actionSpace, List<String> order) {
        ArrayList<Action> tmp = new ArrayList<Action>(actionSpace);
        ArrayList<Action> out2 = new ArrayList<Action>();
        for (String key : order) {
            Iterator iter = tmp.iterator();
            while (iter.hasNext()) {
                Action a = (Action)iter.next();
                if (!a.signature().equals(key)) continue;
                out2.add(a);
                iter.remove();
            }
        }
        out2.addAll(tmp);
        return out2;
    }

    protected void search(IndexedWord root, Predicate<Triple<Double, List<Counter<String>>, Supplier<SentenceFragment>>> candidateFragments, Classifier<ClauseSplitter.ClauseClassifierLabel, String> classifier, Map<String, ? extends List<String>> hardCodedSplits, Function<Triple<State, Action, State>, Counter<String>> featurizer, Collection<Action> actionSpace, int maxTicks) {
        FixedPrioritiesPriorityQueue fringe = new FixedPrioritiesPriorityQueue();
        HashSet<IndexedWord> seenWords = new HashSet<IndexedWord>();
        State firstState = new State(null, null, -9000, null, x -> {}, true);
        fringe.add(Pair.makePair(firstState, new ArrayList(0)), -0.0);
        int ticks = 0;
        while (!fringe.isEmpty()) {
            IndexedWord rootWord;
            if (++ticks > maxTicks) {
                return;
            }
            double logProbSoFar = fringe.getPriority();
            assert (logProbSoFar <= 0.0);
            Pair lastStatePair = (Pair)fringe.removeFirst();
            State lastState = (State)lastStatePair.first;
            List featuresSoFar = (List)lastStatePair.second;
            IndexedWord indexedWord = rootWord = lastState.edge == null ? root : lastState.edge.getDependent();
            if (lastState.isDone && !candidateFragments.test(Triple.makeTriple(logProbSoFar, featuresSoFar, () -> {
                SemanticGraph copy = new SemanticGraph(this.tree);
                lastState.thunk.andThen(x -> {
                    for (IndexedWord newTreeRoot : x.getRoots()) {
                        if (newTreeRoot == null) continue;
                        for (SemanticGraphEdge extraEdge : this.extraEdgesByGovernor.get(newTreeRoot)) {
                            assert (Util.isTree(x));
                            ClauseSplitterSearchProblem.addSubtree(x, newTreeRoot, extraEdge.getRelation().toString(), this.tree, extraEdge.getDependent(), this.tree.getIncomingEdgesSorted(newTreeRoot));
                            assert (Util.isTree(x));
                        }
                    }
                }).accept(copy);
                return new SentenceFragment(copy, this.assumedTruth, false);
            }))) break;
            SemanticGraphEdge subjOrNull = null;
            SemanticGraphEdge objOrNull = null;
            for (SemanticGraphEdge auxEdge : this.tree.outgoingEdgeIterable(rootWord)) {
                String relString = auxEdge.getRelation().toString();
                if (relString.contains("obj")) {
                    objOrNull = auxEdge;
                    continue;
                }
                if (!relString.contains("subj")) continue;
                subjOrNull = auxEdge;
            }
            block2: for (SemanticGraphEdge outgoingEdge : this.tree.outgoingEdgeIterable(rootWord)) {
                if (outgoingEdge.getRelation().toString().equals("ccomp") && (outgoingEdge.getGovernor().lemma() != null && INDIRECT_SPEECH_LEMMAS.contains(outgoingEdge.getGovernor().lemma()) || INDIRECT_SPEECH_LEMMAS.contains(outgoingEdge.getGovernor().word()))) continue;
                String outgoingEdgeRelation = outgoingEdge.getRelation().toString();
                List<String> forcedArcOrder = hardCodedSplits.get(outgoingEdgeRelation);
                if (forcedArcOrder == null && outgoingEdgeRelation.contains(":")) {
                    forcedArcOrder = hardCodedSplits.get(outgoingEdgeRelation.substring(0, outgoingEdgeRelation.indexOf(":")) + ":*");
                }
                boolean doneForcedArc = false;
                for (Action action : forcedArcOrder == null ? actionSpace : this.orderActions(actionSpace, forcedArcOrder)) {
                    ClauseSplitter.ClauseClassifierLabel bestLabel;
                    double logProbability;
                    if (!action.prerequisitesMet(this.tree, outgoingEdge)) continue;
                    if (forcedArcOrder != null && doneForcedArc) continue block2;
                    Optional<State> candidate = action.applyTo(this.tree, lastState, outgoingEdge, subjOrNull, objOrNull);
                    if (!candidate.isPresent()) continue;
                    final Counter<String> features = featurizer.apply(Triple.makeTriple(lastState, action, candidate.get()));
                    if (forcedArcOrder != null && !doneForcedArc) {
                        logProbability = 0.0;
                        bestLabel = ClauseSplitter.ClauseClassifierLabel.CLAUSE_SPLIT;
                        doneForcedArc = true;
                    } else if (features.containsKey("__undocumented_junit_no_classifier")) {
                        logProbability = Double.NEGATIVE_INFINITY;
                        bestLabel = ClauseSplitter.ClauseClassifierLabel.CLAUSE_INTERM;
                    } else {
                        String rel;
                        Counter<ClauseSplitter.ClauseClassifierLabel> scores = classifier.scoresOf(new RVFDatum(features));
                        if (scores.size() > 0) {
                            Counters.logNormalizeInPlace(scores);
                        }
                        if ("nsubj".equals(rel = outgoingEdge.getRelation().toString()) || "dobj".equals(rel)) {
                            scores.remove(ClauseSplitter.ClauseClassifierLabel.NOT_A_CLAUSE);
                        }
                        logProbability = Counters.max(scores, Double.NEGATIVE_INFINITY);
                        bestLabel = Counters.argmax(scores, (x, y) -> 0, ClauseSplitter.ClauseClassifierLabel.CLAUSE_SPLIT);
                    }
                    if (bestLabel == ClauseSplitter.ClauseClassifierLabel.NOT_A_CLAUSE) continue;
                    Pair<State, 7> childState = Pair.makePair(candidate.get().withIsDone(bestLabel), new ArrayList<Counter<String>>((Collection)featuresSoFar){
                        {
                            super(x0);
                            this.add(features);
                        }
                    });
                    if (seenWords.contains(((State)childState.first).edge.getDependent())) continue;
                    fringe.add(childState, logProbability);
                }
            }
            seenWords.add(rootWord);
        }
    }

    public static interface Featurizer
    extends Function<Triple<State, Action, State>, Counter<String>>,
    Serializable {
        public boolean isSimpleSplit(Counter<String> var1);
    }

    public static class TrainingOptions {
        @Execution.Option(name="negativeSubsampleRatio", gloss="The percent of negative datums to take")
        public double negativeSubsampleRatio = 1.0;
        @Execution.Option(name="positiveDatumWeight", gloss="The weight to assign every positive datum.")
        public float positiveDatumWeight = 100.0f;
        @Execution.Option(name="unknownDatumWeight", gloss="The weight to assign every unknown datum (everything extracted with an unconfirmed relation).")
        public float unknownDatumWeight = 1.0f;
        @Execution.Option(name="clauseSplitWeight", gloss="The weight to assign for clause splitting datums. Higher values push towards higher recall.")
        public float clauseSplitWeight = 1.0f;
        @Execution.Option(name="clauseIntermWeight", gloss="The weight to assign for intermediate splits. Higher values push towards higher recall.")
        public float clauseIntermWeight = 2.0f;
        @Execution.Option(name="seed", gloss="The random seed to use")
        public int seed = 42;
        @Execution.Option(name="classifierFactory", gloss="The class of the classifier factory to use for training the various classifiers")
        public Class<? extends ClassifierFactory<ClauseSplitter.ClauseClassifierLabel, String, Classifier<ClauseSplitter.ClauseClassifierLabel, String>>> classifierFactory = LinearClassifierFactory.class;
    }

    public static interface Action {
        public String signature();

        default public boolean prerequisitesMet(SemanticGraph originalTree, SemanticGraphEdge edge) {
            return true;
        }

        public Optional<State> applyTo(SemanticGraph var1, State var2, SemanticGraphEdge var3, SemanticGraphEdge var4, SemanticGraphEdge var5);
    }

    public class State {
        public final SemanticGraphEdge edge;
        public final int edgeIndex;
        public final SemanticGraphEdge subjectOrNull;
        public final int distanceFromSubj;
        public final SemanticGraphEdge objectOrNull;
        public final Consumer<SemanticGraph> thunk;
        public boolean isDone;

        public State(SemanticGraphEdge edge, SemanticGraphEdge subjectOrNull, int distanceFromSubj, SemanticGraphEdge objectOrNull, Consumer<SemanticGraph> thunk, boolean isDone) {
            this.edge = edge;
            this.edgeIndex = ClauseSplitterSearchProblem.this.edgeToIndex.indexOf(edge);
            this.subjectOrNull = subjectOrNull;
            this.distanceFromSubj = distanceFromSubj;
            this.objectOrNull = objectOrNull;
            this.thunk = thunk;
            this.isDone = isDone;
        }

        public State(State source, boolean isDone) {
            this.edge = source.edge;
            this.edgeIndex = ClauseSplitterSearchProblem.this.edgeToIndex.indexOf(this.edge);
            this.subjectOrNull = source.subjectOrNull;
            this.distanceFromSubj = source.distanceFromSubj;
            this.objectOrNull = source.objectOrNull;
            this.thunk = source.thunk;
            this.isDone = isDone;
        }

        public SemanticGraph originalTree() {
            return ClauseSplitterSearchProblem.this.tree;
        }

        public State withIsDone(ClauseSplitter.ClauseClassifierLabel argmax) {
            if (argmax == ClauseSplitter.ClauseClassifierLabel.CLAUSE_SPLIT) {
                this.isDone = true;
            } else if (argmax == ClauseSplitter.ClauseClassifierLabel.CLAUSE_INTERM) {
                this.isDone = false;
            } else {
                throw new IllegalStateException("Invalid classifier label for isDone: " + (Object)((Object)argmax));
            }
            return this;
        }
    }
}

