/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.OutputHandler;
import edu.stanford.nlp.util.logging.Redwood;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RedirectOutputHandler<LoggerClass, ChannelEquivalent>
extends OutputHandler {
    public final LoggerClass logger;
    public final Method loggingMethod;
    private final Map<Object, ChannelEquivalent> channelMapping;
    private final ChannelEquivalent defaultChannel;

    public RedirectOutputHandler(LoggerClass logger, Method loggingMethod) {
        this(logger, loggingMethod, null, null);
    }

    public RedirectOutputHandler(LoggerClass logger, Method loggingMethod, Map<Object, ChannelEquivalent> channelMapping, ChannelEquivalent defaultChannel) {
        this.logger = logger;
        this.loggingMethod = loggingMethod;
        this.channelMapping = channelMapping;
        this.defaultChannel = defaultChannel;
    }

    private boolean shouldLogChannels() {
        return this.channelMapping != null;
    }

    @Override
    public void print(Object[] channels, String line) {
        if (line.endsWith("\n")) {
            line = line.substring(0, line.length() - 1);
        }
        if (this.shouldLogChannels()) {
            Object channel = null;
            if (channels == null) {
                channel = this.defaultChannel;
            } else {
                for (Object candidate : channels) {
                    if (channel != null) continue;
                    channel = this.channelMapping.get(candidate);
                }
                if (channel == null) {
                    channel = this.defaultChannel;
                }
            }
            try {
                this.loggingMethod.invoke(this.logger, channel, line);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getCause());
            }
        }
        try {
            this.loggingMethod.invoke(this.logger, line);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    @Override
    protected boolean formatChannel(StringBuilder b, String channelStr, Object channel) {
        return this.channelMapping == null || !this.channelMapping.containsKey(channel);
    }

    public static RedirectOutputHandler<Logger, Level> fromJavaUtilLogging(Logger logger) {
        Map<Redwood.Flag, Level> channelMapping = Generics.newHashMap();
        channelMapping.put(Redwood.WARN, Level.WARNING);
        channelMapping.put(Redwood.DBG, Level.FINE);
        channelMapping.put(Redwood.ERR, Level.SEVERE);
        try {
            return new RedirectOutputHandler<Logger, Level>(logger, Logger.class.getMethod("log", Level.class, String.class), channelMapping, Level.INFO);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

