/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import java.util.Map;

public class AnnotationLookup {
    private static Map<Class<CoreAnnotation<?>>, Class<?>> valueCache = Generics.newHashMap();

    private AnnotationLookup() {
    }

    public static KeyLookup getCoreKey(String oldKey) {
        for (KeyLookup lookup : KeyLookup.values()) {
            if (!lookup.oldKey.equals(oldKey)) continue;
            return lookup;
        }
        return null;
    }

    public static Class<?> getValueType(Class<? extends CoreAnnotation> key) {
        Class<Object> type = valueCache.get(key);
        if (type == null) {
            try {
                type = key.newInstance().getType();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected failure to instantiate - is your key class fancy?", e);
            }
            valueCache.put(key, type);
        }
        return type;
    }

    private static class OldFeatureLabelKeys {
        public static final String DOCID_KEY = "docID";
        public static final String SENTINDEX_KEY = "sentIndex";
        public static final Object WORD_FORMAT = "WORD_FORMAT";
        public static final Object WORD_TAG_FORMAT = "WORD_TAG_FORMAT";
        public static final Object WORD_TAG_INDEX_FORMAT = "WORD_TAG_INDEX_FORMAT";
        public static final Object VALUE_FORMAT = "VALUE_FORMAT";
        public static final Object COMPLETE_FORMAT = "COMPLETE_FORMAT";
        public static final String VALUE_KEY = "value";
        public static final String TAG_KEY = "tag";
        public static final String WORD_KEY = "word";
        public static final String LEMMA_KEY = "lemma";
        public static final String CATEGORY_KEY = "cat";
        public static final String PROJ_CAT_KEY = "pcat";
        public static final String HEAD_WORD_KEY = "hw";
        public static final String HEAD_TAG_KEY = "ht";
        public static final String INDEX_KEY = "idx";
        public static final String ARG_KEY = "arg";
        public static final String MARKING_KEY = "mark";
        public static final String SEMANTIC_HEAD_WORD_KEY = "shw";
        public static final String SEMANTIC_HEAD_POS_KEY = "shp";
        public static final String VERB_SENSE_KEY = "vs";
        public static final String CATEGORY_FUNCTIONAL_TAG_KEY = "cft";
        public static final String NER_KEY = "ner";
        public static final String SHAPE_KEY = "shape";
        public static final String LEFT_TERM_KEY = "LEFT_TERM";
        public static final String PARENT_KEY = "PARENT";
        public static final String SPAN_KEY = "SPAN";
        public static final String BEFORE_KEY = "before";
        public static final String AFTER_KEY = "after";
        public static final String CURRENT_KEY = "current";
        public static final String ANSWER_KEY = "answer";
        public static final String GOLDANSWER_KEY = "goldAnswer";
        public static final String FEATURES_KEY = "features";
        public static final String INTERPRETATION_KEY = "interpretation";
        public static final String ROLE_KEY = "srl";
        public static final String GAZETTEER_KEY = "gazetteer";
        public static final String STEM_KEY = "stem";
        public static final String POLARITY_KEY = "polarity";
        public static final String CH_CHAR_KEY = "char";
        public static final String CH_ORIG_SEG_KEY = "orig_seg";
        public static final String CH_SEG_KEY = "seg";
        public static final String BEGIN_POSITION_KEY = "BEGIN_POS";
        public static final String END_POSITION_KEY = "END_POS";

        private OldFeatureLabelKeys() {
        }
    }

    public static enum KeyLookup {
        VALUE_KEY(CoreAnnotations.ValueAnnotation.class, "value"),
        TAG_KEY(CoreAnnotations.PartOfSpeechAnnotation.class, "tag"),
        WORD_KEY(CoreAnnotations.TextAnnotation.class, "word"),
        LEMMA_KEY(CoreAnnotations.LemmaAnnotation.class, "lemma"),
        CATEGORY_KEY(CoreAnnotations.CategoryAnnotation.class, "cat"),
        PROJ_CAT_KEY(CoreAnnotations.ProjectedCategoryAnnotation.class, "pcat"),
        HEAD_WORD_KEY("edu.stanford.nlp.ling.TreeCoreAnnotations.HeadWordAnnotation", "hw"),
        HEAD_TAG_KEY("edu.stanford.nlp.ling.TreeCoreAnnotations.HeadTagAnnotation", "ht"),
        INDEX_KEY(CoreAnnotations.IndexAnnotation.class, "idx"),
        ARG_KEY(CoreAnnotations.ArgumentAnnotation.class, "arg"),
        MARKING_KEY(CoreAnnotations.MarkingAnnotation.class, "mark"),
        SEMANTIC_HEAD_WORD_KEY(CoreAnnotations.SemanticHeadWordAnnotation.class, "shw"),
        SEMANTIC_HEAD_POS_KEY(CoreAnnotations.SemanticHeadTagAnnotation.class, "shp"),
        VERB_SENSE_KEY(CoreAnnotations.VerbSenseAnnotation.class, "vs"),
        CATEGORY_FUNCTIONAL_TAG_KEY(CoreAnnotations.CategoryFunctionalTagAnnotation.class, "cft"),
        NER_KEY(CoreAnnotations.NamedEntityTagAnnotation.class, "ner"),
        SHAPE_KEY(CoreAnnotations.ShapeAnnotation.class, "shape"),
        LEFT_TERM_KEY(CoreAnnotations.LeftTermAnnotation.class, "LEFT_TERM"),
        PARENT_KEY(CoreAnnotations.ParentAnnotation.class, "PARENT"),
        SPAN_KEY(CoreAnnotations.SpanAnnotation.class, "SPAN"),
        BEFORE_KEY(CoreAnnotations.BeforeAnnotation.class, "before"),
        AFTER_KEY(CoreAnnotations.AfterAnnotation.class, "after"),
        CURRENT_KEY(CoreAnnotations.OriginalTextAnnotation.class, "current"),
        ANSWER_KEY(CoreAnnotations.AnswerAnnotation.class, "answer"),
        GOLDANSWER_Key(CoreAnnotations.GoldAnswerAnnotation.class, "goldAnswer"),
        FEATURES_KEY(CoreAnnotations.FeaturesAnnotation.class, "features"),
        INTERPRETATION_KEY(CoreAnnotations.InterpretationAnnotation.class, "interpretation"),
        ROLE_KEY(CoreAnnotations.RoleAnnotation.class, "srl"),
        GAZETTEER_KEY(CoreAnnotations.GazetteerAnnotation.class, "gazetteer"),
        STEM_KEY(CoreAnnotations.StemAnnotation.class, "stem"),
        POLARITY_KEY(CoreAnnotations.PolarityAnnotation.class, "polarity"),
        CH_CHAR_KEY(CoreAnnotations.ChineseCharAnnotation.class, "char"),
        CH_ORIG_SEG_KEY(CoreAnnotations.ChineseOrigSegAnnotation.class, "orig_seg"),
        CH_SEG_KEY(CoreAnnotations.ChineseSegAnnotation.class, "seg"),
        BEGIN_POSITION_KEY(CoreAnnotations.CharacterOffsetBeginAnnotation.class, "BEGIN_POS"),
        END_POSITION_KEY(CoreAnnotations.CharacterOffsetEndAnnotation.class, "END_POS"),
        DOCID_KEY(CoreAnnotations.DocIDAnnotation.class, "docID"),
        SENTINDEX_KEY(CoreAnnotations.SentenceIndexAnnotation.class, "sentIndex"),
        IDF_KEY(CoreAnnotations.IDFAnnotation.class, "idf"),
        END_POSITION_KEY2(CoreAnnotations.CharacterOffsetEndAnnotation.class, "endPosition"),
        CHUNK_KEY(CoreAnnotations.ChunkAnnotation.class, "chunk"),
        NORMALIZED_NER_KEY(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, "normalized"),
        MORPHO_NUM_KEY(CoreAnnotations.MorphoNumAnnotation.class, "num"),
        MORPHO_PERS_KEY(CoreAnnotations.MorphoPersAnnotation.class, "pers"),
        MORPHO_GEN_KEY(CoreAnnotations.MorphoGenAnnotation.class, "gen"),
        MORPHO_CASE_KEY(CoreAnnotations.MorphoCaseAnnotation.class, "case"),
        WORDNET_SYN_KEY(CoreAnnotations.WordnetSynAnnotation.class, "wordnetsyn"),
        PROTO_SYN_KEY(CoreAnnotations.ProtoAnnotation.class, "proto"),
        DOCTITLE_KEY(CoreAnnotations.DocTitleAnnotation.class, "doctitle"),
        DOCTYPE_KEY(CoreAnnotations.DocTypeAnnotation.class, "doctype"),
        DOCDATE_KEY(CoreAnnotations.DocDateAnnotation.class, "docdate"),
        DOCSOURCETYPE_KEY(CoreAnnotations.DocSourceTypeAnnotation.class, "docsourcetype"),
        LINK_KEY(CoreAnnotations.LinkAnnotation.class, "link"),
        SPEAKER_KEY(CoreAnnotations.SpeakerAnnotation.class, "speaker"),
        AUTHOR_KEY(CoreAnnotations.AuthorAnnotation.class, "author"),
        SECTION_KEY(CoreAnnotations.SectionAnnotation.class, "section"),
        SECTIONID_KEY(CoreAnnotations.SectionIDAnnotation.class, "sectionID"),
        SECTIONDATE_KEY(CoreAnnotations.SectionDateAnnotation.class, "sectionDate"),
        HEAD_KEY(CoreAnnotations.HeadWordStringAnnotation.class, "head"),
        GOVERNOR_KEY(CoreAnnotations.GovernorAnnotation.class, "governor"),
        GAZ_KEY(CoreAnnotations.GazAnnotation.class, "gaz"),
        ABBR_KEY(CoreAnnotations.AbbrAnnotation.class, "abbr"),
        ABSTR_KEY(CoreAnnotations.AbstrAnnotation.class, "abstr"),
        FREQ_KEY(CoreAnnotations.FreqAnnotation.class, "freq"),
        WEB_KEY(CoreAnnotations.WebAnnotation.class, "web"),
        POS_TAG_KEY(CoreAnnotations.PartOfSpeechAnnotation.class, "pos");

        public final Class coreKey;
        public final String oldKey;

        private <T> KeyLookup(Class<? extends CoreAnnotation<T>> coreKey, String oldKey) {
            this.coreKey = coreKey;
            this.oldKey = oldKey;
        }

        private KeyLookup(String className, String oldKey) {
            Class<?> keyClass;
            try {
                keyClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                CoreLabel.GenericAnnotation<Object> newKey = new CoreLabel.GenericAnnotation<Object>(){

                    @Override
                    public Class<Object> getType() {
                        return Object.class;
                    }
                };
                keyClass = newKey.getClass();
            }
            this.coreKey = (Class)ErasureUtils.uncheckedCast(keyClass);
            this.oldKey = oldKey;
        }
    }
}

