/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentModel;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.List;

public class SentimentUtils {
    static final Filter<Tree> UNKNOWN_ROOT_FILTER = new Filter<Tree>(){

        @Override
        public boolean accept(Tree tree) {
            int gold = RNNCoreAnnotations.getGoldClass(tree);
            return gold != -1;
        }
    };

    private SentimentUtils() {
    }

    public static void attachGoldLabels(Tree tree) {
        if (tree.isLeaf()) {
            return;
        }
        for (Tree child : tree.children()) {
            SentimentUtils.attachGoldLabels(child);
        }
        RNNCoreAnnotations.setGoldClass(tree, Integer.valueOf(tree.label().value()));
    }

    public static List<Tree> readTreesWithGoldLabels(String path) {
        ArrayList<Tree> trees = Generics.newArrayList();
        MemoryTreebank treebank = new MemoryTreebank("utf-8");
        treebank.loadPath(path, null);
        for (Tree tree : treebank) {
            SentimentUtils.attachGoldLabels(tree);
            trees.add(tree);
        }
        return trees;
    }

    public static List<Tree> filterUnknownRoots(List<Tree> trees) {
        return CollectionUtils.filterAsList(trees, UNKNOWN_ROOT_FILTER);
    }

    public static String sentimentString(SentimentModel model, int sentiment) {
        String[] classNames = model.op.classNames;
        if (sentiment < 0 || sentiment > classNames.length) {
            return "Unknown sentiment label " + sentiment;
        }
        return classNames[sentiment];
    }
}

