/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SNIHostName;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.Krb5Authentication;
import sun.security.ssl.Krb5KeyExchange;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;

final class Krb5ClientKeyExchange {
    static final SSLConsumer krb5HandshakeConsumer = new Krb5ClientKeyExchangeConsumer();
    static final HandshakeProducer krb5HandshakeProducer = new Krb5ClientKeyExchangeProducer();

    Krb5ClientKeyExchange() {
    }

    private static final class Krb5ClientKeyExchangeConsumer
    implements SSLConsumer {
        private Krb5ClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            Object object2;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            Krb5Authentication.Krb5Possession krb5Possession = null;
            for (Object object2 : serverHandshakeContext.handshakePossessions) {
                if (!(object2 instanceof Krb5Authentication.Krb5Possession)) continue;
                krb5Possession = (Krb5Authentication.Krb5Possession)object2;
                break;
            }
            if (krb5Possession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No Kerberos possessions negotiated for client key exchange");
            }
            KerberosClientKeyExchange kerberosClientKeyExchange = new KerberosClientKeyExchange(serverHandshakeContext.negotiatedProtocol, ProtocolVersion.valueOf(serverHandshakeContext.clientHelloVersion), serverHandshakeContext.sslContext.getSecureRandom(), byteBuffer, serverHandshakeContext.conContext.acc, krb5Possession.serviceCreds);
            object2 = new Krb5ClientKeyExchangeMessage(serverHandshakeContext, kerberosClientKeyExchange);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming KRB5 ClientKeyExchange handshake message", object2);
            }
            serverHandshakeContext.handshakeSession.setPeerPrincipal(kerberosClientKeyExchange.getPeerPrincipal());
            serverHandshakeContext.handshakeSession.setLocalPrincipal(kerberosClientKeyExchange.getLocalPrincipal());
            byte[] byArray = kerberosClientKeyExchange.getUnencryptedPreMasterSecret();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "TlsPremasterSecret");
            serverHandshakeContext.handshakeCredentials.add(new Krb5KeyExchange.Krb5PremasterSecret(secretKeySpec));
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(serverHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            serverHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            serverHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, secretKey);
        }
    }

    private static final class Krb5ClientKeyExchangeProducer
    implements HandshakeProducer {
        private Krb5ClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object;
            Object object22;
            ClientHandshakeContext clientHandshakeContext;
            block10: {
                clientHandshakeContext = (ClientHandshakeContext)connectionContext;
                String string = null;
                for (Object object22 : clientHandshakeContext.requestedServerNames) {
                    if (!(object22 instanceof SNIHostName)) continue;
                    string = ((SNIHostName)object22).getAsciiName();
                    break;
                }
                object = null;
                if (string != null) {
                    try {
                        object = new KerberosClientKeyExchange(string, clientHandshakeContext.conContext.acc, clientHandshakeContext.negotiatedProtocol, clientHandshakeContext.sslContext.getSecureRandom());
                    }
                    catch (IOException iOException) {
                        if (clientHandshakeContext.serverNamesAccepted) {
                            throw iOException;
                        }
                        if (!SSLLogger.isOn || !SSLLogger.isOn("handshake")) break block10;
                        SSLLogger.warning("Cannot use Server Name Indication: " + iOException.getMessage(), new Object[0]);
                    }
                }
            }
            if (object == null) {
                object22 = clientHandshakeContext.handshakeSession.getPeerHost();
                if (object22 == null) {
                    throw new IOException("Hostname is required to use Kerberos cipher suites");
                }
                object = new KerberosClientKeyExchange((String)object22, clientHandshakeContext.conContext.acc, clientHandshakeContext.negotiatedProtocol, clientHandshakeContext.sslContext.getSecureRandom());
            }
            clientHandshakeContext.handshakeSession.setPeerPrincipal(((KerberosClientKeyExchange)object).getPeerPrincipal());
            clientHandshakeContext.handshakeSession.setLocalPrincipal(((KerberosClientKeyExchange)object).getLocalPrincipal());
            object22 = new Krb5ClientKeyExchangeMessage(clientHandshakeContext, (KerberosClientKeyExchange)object);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced KRB5 ClientKeyExchange handshake message", object22);
            }
            ((SSLHandshake.HandshakeMessage)object22).write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            byte[] byArray = ((KerberosClientKeyExchange)object).getUnencryptedPreMasterSecret();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "TlsPremasterSecret");
            clientHandshakeContext.handshakePossessions.add(new Krb5KeyExchange.Krb5PremasterSecret(secretKeySpec));
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(clientHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            clientHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            clientHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
            return null;
        }
    }

    private static final class Krb5ClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        KerberosClientKeyExchange legacy;

        Krb5ClientKeyExchangeMessage(HandshakeContext handshakeContext, KerberosClientKeyExchange kerberosClientKeyExchange) {
            super(handshakeContext);
            this.legacy = kerberosClientKeyExchange;
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            if (this.legacy != null) {
                return this.legacy.messageLength();
            }
            return 0;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            if (this.legacy != null) {
                this.legacy.send(handshakeOutStream);
            }
        }

        public String toString() {
            if (this.legacy != null) {
                return this.legacy.toString();
            }
            return "\"KRB5 ClientKeyExchange\": '{'\n  \"legacy implementation\": null\n'}'";
        }
    }
}

